/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.JniBasedUnixGroupsNetgroupMappingWithFallback;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMapping;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authentication.saml.WrappedWebContext;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.ImpalaInternalAdminUser;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.TransactionException;
import org.apache.impala.common.UserCancelledException;
import org.apache.impala.hooks.QueryCompleteContext;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.Canceller;
import org.apache.impala.service.Frontend;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TBuildTestDescriptorTableParams;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCivilTime;
import org.apache.impala.thrift.TDescribeDbParams;
import org.apache.impala.thrift.TDescribeHistoryParams;
import org.apache.impala.thrift.TDescribeResult;
import org.apache.impala.thrift.TDescribeTableParams;
import org.apache.impala.thrift.TDescriptorTable;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TGetAllHadoopConfigsResponse;
import org.apache.impala.thrift.TGetCatalogInfoResult;
import org.apache.impala.thrift.TGetCatalogMetricsResult;
import org.apache.impala.thrift.TGetDataSrcsParams;
import org.apache.impala.thrift.TGetDataSrcsResult;
import org.apache.impala.thrift.TGetDbsParams;
import org.apache.impala.thrift.TGetDbsResult;
import org.apache.impala.thrift.TGetFunctionsParams;
import org.apache.impala.thrift.TGetFunctionsResult;
import org.apache.impala.thrift.TGetHadoopConfigRequest;
import org.apache.impala.thrift.TGetHadoopConfigResponse;
import org.apache.impala.thrift.TGetMetadataTablesParams;
import org.apache.impala.thrift.TGetTableHistoryResult;
import org.apache.impala.thrift.TGetTablesParams;
import org.apache.impala.thrift.TGetTablesResult;
import org.apache.impala.thrift.TLoadDataReq;
import org.apache.impala.thrift.TLoadDataResp;
import org.apache.impala.thrift.TLogLevel;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TQueryCompleteContext;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.thrift.TShowFilesParams;
import org.apache.impala.thrift.TShowGrantPrincipalParams;
import org.apache.impala.thrift.TShowRolesParams;
import org.apache.impala.thrift.TShowStatsOp;
import org.apache.impala.thrift.TShowStatsParams;
import org.apache.impala.thrift.TStringLiteral;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateExecutorMembershipRequest;
import org.apache.impala.thrift.TWrappedHttpRequest;
import org.apache.impala.thrift.TWrappedHttpResponse;
import org.apache.impala.util.AuthorizationUtil;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.impala.util.GlogAppender;
import org.apache.impala.util.JniRequestPoolService;
import org.apache.impala.util.PatternMatcher;
import org.apache.impala.util.TSessionStateUtil;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniFrontend {
    private static final Logger LOG = LoggerFactory.getLogger(JniFrontend.class);
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private final Frontend frontend_;
    public static final String KEYSTORE_ERROR_MSG = "Failed to get password from keystore, error: invalid key '%s' or password doesn't exist";
    private static final Configuration CONF = new Configuration();
    private static final Groups GROUPS = Groups.getUserToGroupsMappingService((Configuration)CONF);
    private static final HiveConf HIVE_CONF = new HiveConf();

    public JniFrontend(byte[] thriftBackendConfig, boolean isBackendTest) throws ImpalaException, TException {
        TBackendGflags cfg = new TBackendGflags();
        JniUtil.deserializeThrift(protocolFactory_, cfg, thriftBackendConfig);
        BackendConfig.create(cfg);
        GlogAppender.Install(TLogLevel.values()[cfg.impala_log_lvl], TLogLevel.values()[cfg.non_impala_java_vlog]);
        LOG.info(JniUtil.getJavaVersion());
        if (cfg.is_coordinator) {
            AuthorizationFactory authzFactory = AuthorizationUtil.authzFactoryFrom(BackendConfig.INSTANCE);
            this.frontend_ = new Frontend(authzFactory, isBackendTest);
        } else {
            this.frontend_ = null;
        }
    }

    public byte[] createExecRequest(byte[] thriftQueryContext) throws ImpalaException {
        String explainStr;
        Preconditions.checkNotNull((Object)this.frontend_);
        TQueryCtx queryCtx = new TQueryCtx();
        JniUtil.deserializeThrift(protocolFactory_, queryCtx, thriftQueryContext);
        Frontend.PlanCtx planCtx = new Frontend.PlanCtx(queryCtx);
        TExecRequest result = this.frontend_.createExecRequest(planCtx);
        if (LOG.isTraceEnabled() && !(explainStr = planCtx.getExplainString()).isEmpty()) {
            LOG.trace(explainStr);
        }
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public void cancelExecRequest(byte[] thriftQueryId) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TUniqueId queryId = new TUniqueId();
        JniUtil.deserializeThrift(protocolFactory_, queryId, thriftQueryId);
        Canceller.cancel(queryId);
    }

    public byte[] updateCatalogCache(byte[] req) throws ImpalaException, TException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TUpdateCatalogCacheRequest request = new TUpdateCatalogCacheRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, req);
        return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)this.frontend_.updateCatalogCache(request));
    }

    public void updateExecutorMembership(byte[] thriftMembershipUpdate) throws ImpalaException {
        TUpdateExecutorMembershipRequest req = new TUpdateExecutorMembershipRequest();
        JniUtil.deserializeThrift(protocolFactory_, req, thriftMembershipUpdate);
        ExecutorMembershipSnapshot.update(req);
    }

    public byte[] loadTableData(byte[] thriftLoadTableDataParams) throws ImpalaException, IOException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TLoadDataReq request = new TLoadDataReq();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftLoadTableDataParams);
        TLoadDataResp response = this.frontend_.loadTableData(request);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)response);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public void convertTable(byte[] params) throws ImpalaException {
        TExecRequest execRequest = new TExecRequest();
        JniUtil.deserializeThrift(protocolFactory_, execRequest, params);
        this.frontend_.convertTable(execRequest);
    }

    public String getExplainPlan(byte[] thriftQueryContext) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TQueryCtx queryCtx = new TQueryCtx();
        JniUtil.deserializeThrift(protocolFactory_, queryCtx, thriftQueryContext);
        String plan = this.frontend_.getExplainString(queryCtx);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Explain plan: " + plan);
        }
        return plan;
    }

    public byte[] getCatalogMetrics() throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetCatalogMetricsResult metrics = this.frontend_.getCatalogMetrics();
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)metrics);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getCatalogInfo() throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetCatalogInfoResult info = this.frontend_.getCatalogInfo();
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)info);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getTableNames(byte[] thriftGetTablesParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetTablesParams params = new TGetTablesParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetTablesParams);
        TSessionState session = params.isSetSession() ? params.getSession() : null;
        User user = this.getUser(session);
        Preconditions.checkState((!params.isSetSession() || user != null ? 1 : 0) != 0);
        List<String> tables = this.frontend_.getTableNames(params.db, PatternMatcher.createHivePatternMatcher(params.pattern), user, params.getTable_types());
        TGetTablesResult result = new TGetTablesResult();
        result.setTables(tables);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getMetadataTableNames(byte[] thriftGetMetadataTablesParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetMetadataTablesParams params = new TGetMetadataTablesParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetMetadataTablesParams);
        TSessionState session = params.isSetSession() ? params.getSession() : null;
        User user = this.getUser(session);
        Preconditions.checkState((!params.isSetSession() || user != null ? 1 : 0) != 0);
        List<String> tables = this.frontend_.getMetadataTableNames(params.db, params.tbl, PatternMatcher.createHivePatternMatcher(params.pattern), user);
        TGetTablesResult result = new TGetTablesResult();
        result.setTables(tables);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getTableFiles(byte[] thriftShowFilesParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TShowFilesParams params = new TShowFilesParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftShowFilesParams);
        TResultSet result = this.frontend_.getTableFiles(params);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getDbs(byte[] thriftGetTablesParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetDbsParams params = new TGetDbsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetTablesParams);
        TSessionState session = params.isSetSession() ? params.getSession() : null;
        User user = this.getUser(session);
        TGetDbsResult result = new TGetDbsResult();
        result.setDbs(this.frontend_.getThriftDbs(PatternMatcher.createHivePatternMatcher(params.pattern), user));
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getTableHistory(byte[] thriftParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TDescribeHistoryParams params = new TDescribeHistoryParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TGetTableHistoryResult result = this.frontend_.getTableHistory(params);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getDataSrcMetadata(byte[] thriftParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetDataSrcsParams params = new TGetDataSrcsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TGetDataSrcsResult result = new TGetDataSrcsResult();
        List<? extends FeDataSource> dataSources = this.frontend_.getDataSrcs(params.pattern);
        result.setData_src_names(Lists.newArrayListWithCapacity((int)dataSources.size()));
        result.setLocations(Lists.newArrayListWithCapacity((int)dataSources.size()));
        result.setClass_names(Lists.newArrayListWithCapacity((int)dataSources.size()));
        result.setApi_versions(Lists.newArrayListWithCapacity((int)dataSources.size()));
        for (FeDataSource feDataSource : dataSources) {
            result.addToData_src_names(feDataSource.getName());
            result.addToLocations(feDataSource.getLocation());
            result.addToClass_names(feDataSource.getClassName());
            result.addToApi_versions(feDataSource.getApiVersion());
        }
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getStats(byte[] thriftShowStatsParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TShowStatsParams params = new TShowStatsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftShowStatsParams);
        Preconditions.checkState((boolean)params.isSetTable_name());
        TResultSet result = params.op == TShowStatsOp.COLUMN_STATS ? this.frontend_.getColumnStats(params.getTable_name().getDb_name(), params.getTable_name().getTable_name(), params.isSetShow_column_minmax_stats() && params.show_column_minmax_stats) : this.frontend_.getTableStats(params.getTable_name().getDb_name(), params.getTable_name().getTable_name(), params.op);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getFunctions(byte[] thriftGetFunctionsParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetFunctionsParams params = new TGetFunctionsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetFunctionsParams);
        TGetFunctionsResult result = new TGetFunctionsResult();
        ArrayList signatures = Lists.newArrayList();
        ArrayList retTypes = Lists.newArrayList();
        ArrayList fnBinaryTypes = Lists.newArrayList();
        ArrayList fnIsPersistent = Lists.newArrayList();
        List<Function> fns = this.frontend_.getFunctions(params.category, params.db, params.pattern, false);
        for (Function fn : fns) {
            signatures.add(fn.signatureString());
            retTypes.add(fn.getReturnType().toString());
            fnBinaryTypes.add(fn.getBinaryType().name());
            fnIsPersistent.add(String.valueOf(fn.isPersistent()));
        }
        result.setFn_signatures(signatures);
        result.setFn_ret_types(retTypes);
        result.setFn_binary_types(fnBinaryTypes);
        result.setFn_persistence(fnIsPersistent);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getCatalogObject(byte[] thriftParams) throws ImpalaException, TException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TCatalogObject objectDescription = new TCatalogObject();
        JniUtil.deserializeThrift(protocolFactory_, objectDescription, thriftParams);
        TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
        return serializer.serialize((TBase)this.frontend_.getCatalog().getTCatalogObject(objectDescription));
    }

    public byte[] describeDb(byte[] thriftDescribeDbParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TDescribeDbParams params = new TDescribeDbParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftDescribeDbParams);
        TDescribeResult result = this.frontend_.describeDb(params.getDb(), params.getOutput_style());
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] describeTable(byte[] thriftDescribeTableParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TDescribeTableParams params = new TDescribeTableParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftDescribeTableParams);
        Preconditions.checkState((boolean)(params.isSetTable_name() ^ params.isSetResult_struct()));
        User user = new User(TSessionStateUtil.getEffectiveUser(params.getSession()));
        TDescribeResult result = this.frontend_.describeTable(params, user);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public String showCreateTable(byte[] thriftTableName) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TTableName params = new TTableName();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftTableName);
        return ToSqlUtils.getCreateTableSql(this.frontend_.getCatalog().getTable(params.getDb_name(), params.getTable_name()));
    }

    public String showCreateFunction(byte[] thriftShowCreateFunctionParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TGetFunctionsParams params = new TGetFunctionsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftShowCreateFunctionParams);
        Preconditions.checkArgument((params.category == TFunctionCategory.SCALAR || params.category == TFunctionCategory.AGGREGATE ? 1 : 0) != 0);
        return ToSqlUtils.getCreateFunctionSql(this.frontend_.getFunctions(params.category, params.db, params.pattern, true));
    }

    public byte[] buildTestDescriptorTable(byte[] buildTestDescTblParams) throws ImpalaException {
        TBuildTestDescriptorTableParams params = new TBuildTestDescriptorTableParams();
        JniUtil.deserializeThrift(protocolFactory_, params, buildTestDescTblParams);
        Preconditions.checkNotNull(params.slot_types);
        TDescriptorTable result = DescriptorTable.buildTestDescriptorTable(params.slot_types);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            byte[] ret = serializer.serialize((TBase)result);
            return ret;
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getRoles(byte[] showRolesParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TShowRolesParams params = new TShowRolesParams();
        JniUtil.deserializeThrift(protocolFactory_, params, showRolesParams);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)this.frontend_.getAuthzManager().getRoles(params));
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getPrincipalPrivileges(byte[] showGrantPrincipalParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TShowGrantPrincipalParams params = new TShowGrantPrincipalParams();
        JniUtil.deserializeThrift(protocolFactory_, params, showGrantPrincipalParams);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)this.frontend_.getAuthzManager().getPrivileges(params));
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] execHiveServer2MetadataOp(byte[] metadataOpsParams) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TMetadataOpRequest params = new TMetadataOpRequest();
        JniUtil.deserializeThrift(protocolFactory_, params, metadataOpsParams);
        TResultSet result = this.frontend_.execHiveServer2MetadataOp(params);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public void setCatalogIsReady() {
        Preconditions.checkNotNull((Object)this.frontend_);
        LOG.info("Forcing catalog to ready state for testing");
        this.frontend_.getCatalog().setIsReady(true);
    }

    public void waitForCatalog() throws UserCancelledException {
        Preconditions.checkNotNull((Object)this.frontend_);
        this.frontend_.waitForCatalog();
    }

    public void refreshAuthorization() {
        Preconditions.checkNotNull((Object)this.frontend_);
        this.frontend_.refreshAuthorization();
    }

    FeTable getCatalogTable(byte[] tableNameParam) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TTableName tableName = new TTableName();
        JniUtil.deserializeThrift(protocolFactory_, tableName, tableNameParam);
        return this.frontend_.getCatalog().getTable(tableName.db_name, tableName.table_name);
    }

    public byte[] getAllHadoopConfigs() throws ImpalaException {
        HashMap configs = Maps.newHashMap();
        for (Map.Entry e : HIVE_CONF) {
            configs.put(e.getKey(), e.getValue());
        }
        TGetAllHadoopConfigsResponse result = new TGetAllHadoopConfigsResponse();
        result.setConfigs(configs);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getHadoopConfig(byte[] serializedRequest) throws ImpalaException {
        TGetHadoopConfigRequest request = new TGetHadoopConfigRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        TGetHadoopConfigResponse result = new TGetHadoopConfigResponse();
        result.setValue(CONF.get(request.getName()));
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getHadoopGroups(byte[] serializedRequest) throws ImpalaException {
        return JniRequestPoolService.getHadoopGroupsInternal(serializedRequest);
    }

    public void callQueryCompleteHooks(byte[] serializedRequest) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TQueryCompleteContext request = new TQueryCompleteContext();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        QueryCompleteContext context = new QueryCompleteContext(request.getLineage_string());
        this.frontend_.callQueryCompleteHooks(context);
    }

    public void addTransaction(byte[] thriftQueryContext) throws TransactionException, ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TQueryCtx queryCtx = new TQueryCtx();
        JniUtil.deserializeThrift(protocolFactory_, queryCtx, thriftQueryContext);
        this.frontend_.addTransaction(queryCtx);
    }

    public void abortTransaction(long transactionId) throws TransactionException {
        Preconditions.checkNotNull((Object)this.frontend_);
        this.frontend_.abortTransaction(transactionId);
    }

    public void unregisterTransaction(long transactionId) {
        Preconditions.checkNotNull((Object)this.frontend_);
        this.frontend_.unregisterTransaction(transactionId);
    }

    public byte[] getSaml2Redirect(byte[] serializedRequest) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        Preconditions.checkNotNull((Object)((Object)this.frontend_.getSaml2Client()));
        TWrappedHttpRequest request = new TWrappedHttpRequest();
        TWrappedHttpResponse response = new TWrappedHttpResponse();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        WrappedWebContext webContext = new WrappedWebContext(request, response);
        this.frontend_.getSaml2Client().setRedirect(webContext);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)response);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] validateSaml2Response(byte[] serializedRequest) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        Preconditions.checkNotNull((Object)((Object)this.frontend_.getSaml2Client()));
        TWrappedHttpRequest request = new TWrappedHttpRequest();
        TWrappedHttpResponse response = new TWrappedHttpResponse();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        WrappedWebContext webContext = new WrappedWebContext(request, response);
        this.frontend_.getSaml2Client().validateAuthnResponse(webContext);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)response);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public static String getSecretFromKeyStore(byte[] secretKeyRequest) throws ImpalaException {
        TStringLiteral secretKey = new TStringLiteral();
        JniUtil.deserializeThrift(protocolFactory_, secretKey, secretKeyRequest);
        String secret = null;
        try {
            String secretKeyStr = StandardCharsets.UTF_8.decode(secretKey.value).toString();
            char[] secretCharArray = CONF.getPassword(secretKeyStr);
            if (secretCharArray == null) {
                String errMsg = String.format(KEYSTORE_ERROR_MSG, secretKeyStr);
                LOG.error(errMsg);
                throw new InternalException(errMsg);
            }
            secret = new String(secretCharArray);
        }
        catch (IOException e) {
            LOG.error("Failed to get password from keystore, error: " + e);
            throw new InternalException(e.getMessage());
        }
        return secret;
    }

    public static byte[] hiveLegacyTimezoneConvert(byte[] timezoneT, long utc_time_millis) throws ImpalaException {
        TStringLiteral timezone = new TStringLiteral();
        JniUtil.deserializeThrift(protocolFactory_, timezone, timezoneT);
        String timezoneStr = StandardCharsets.UTF_8.decode(timezone.value).toString();
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone(timezoneStr));
        c.setTimeInMillis(utc_time_millis);
        TCivilTime civilTime = new TCivilTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)civilTime);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public String validateSaml2Bearer(byte[] serializedRequest) throws ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        Preconditions.checkNotNull((Object)((Object)this.frontend_.getSaml2Client()));
        TWrappedHttpRequest request = new TWrappedHttpRequest();
        TWrappedHttpResponse dummyResponse = new TWrappedHttpResponse();
        JniUtil.deserializeThrift(protocolFactory_, request, serializedRequest);
        WrappedWebContext webContext = new WrappedWebContext(request, dummyResponse);
        return this.frontend_.getSaml2Client().validateBearer(webContext);
    }

    public void abortKuduTransaction(byte[] thriftQueryId) throws TransactionException, ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TUniqueId queryId = new TUniqueId();
        JniUtil.deserializeThrift(protocolFactory_, queryId, thriftQueryId);
        this.frontend_.abortKuduTransaction(queryId);
    }

    public void commitKuduTransaction(byte[] thriftQueryId) throws TransactionException, ImpalaException {
        Preconditions.checkNotNull((Object)this.frontend_);
        TUniqueId queryId = new TUniqueId();
        JniUtil.deserializeThrift(protocolFactory_, queryId, thriftQueryId);
        this.frontend_.commitKuduTransaction(queryId);
    }

    @VisibleForTesting
    protected static String checkGroupsMappingProvider(Configuration conf) {
        String provider = conf.get("hadoop.security.group.mapping");
        if (ShellBasedUnixGroupsNetgroupMapping.class.getName().equals(provider)) {
            return String.format("Hadoop groups mapping provider: %s is known to be problematic. Consider using: %s instead.", provider, JniBasedUnixGroupsNetgroupMappingWithFallback.class.getName());
        }
        if (ShellBasedUnixGroupsMapping.class.getName().equals(provider)) {
            return String.format("Hadoop groups mapping provider: %s is known to be problematic. Consider using: %s instead.", provider, JniBasedUnixGroupsMappingWithFallback.class.getName());
        }
        return "";
    }

    public String checkConfiguration() throws ImpalaException {
        StringBuilder output = new StringBuilder();
        output.append(this.checkLogFilePermission());
        output.append(this.checkFileSystem(CONF));
        output.append(JniFrontend.checkShortCircuitRead(CONF));
        if (BackendConfig.INSTANCE.isAuthorizedProxyGroupEnabled() && !BackendConfig.INSTANCE.isShellBasedGroupsMappingEnabled()) {
            output.append(JniFrontend.checkGroupsMappingProvider(CONF));
        }
        return output.toString();
    }

    private String checkLogFilePermission() {
        org.apache.log4j.Logger l4jRootLogger = org.apache.log4j.Logger.getRootLogger();
        Enumeration appenders = l4jRootLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender) || ((FileAppender)appender).getFile() != null) continue;
            return "Impala does not have permission to write to the log file specified in log4j.properties.";
        }
        return "";
    }

    @VisibleForTesting
    protected static String checkShortCircuitRead(Configuration conf) {
        if (!conf.getBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false)) {
            LOG.info("Short-circuit reads are not enabled.");
            return "";
        }
        StringBuilder output = new StringBuilder();
        String errorMessage = "Invalid short-circuit reads configuration:\n";
        String prefix = "  - ";
        StringBuilder errorCause = new StringBuilder();
        String domainSocketPath = conf.getTrimmed("dfs.domain.socket.path", "");
        if (domainSocketPath.isEmpty()) {
            errorCause.append(prefix);
            errorCause.append("dfs.domain.socket.path");
            errorCause.append(" is not configured.\n");
        } else {
            File socketFile = new File(domainSocketPath);
            File socketDir = socketFile.getParentFile();
            if (BackendConfig.INSTANCE.isDedicatedCoordinator()) {
                LOG.warn("Dedicated coordinator instance will not read local data via short-circuit reads, socket path directory checks are skipped.");
            } else if (socketDir == null || !socketDir.canRead() || !socketDir.canExecute()) {
                errorCause.append(prefix);
                errorCause.append("Impala cannot read or execute the parent directory of ");
                errorCause.append("dfs.domain.socket.path");
                errorCause.append("\n");
            }
        }
        if (conf.getBoolean("dfs.client.use.legacy.blockreader.local", false)) {
            errorCause.append(prefix);
            errorCause.append("dfs.client.use.legacy.blockreader.local");
            errorCause.append(" should not be enabled.\n");
        }
        if (errorCause.length() > 0) {
            output.append(errorMessage);
            output.append((CharSequence)errorCause);
        }
        return output.toString();
    }

    private User getUser(TSessionState session) {
        User user = session == null ? ImpalaInternalAdminUser.getInstance() : new User(TSessionStateUtil.getEffectiveUser(session));
        return user;
    }

    private String checkFileSystem(Configuration conf) {
        String[] path_strings;
        try {
            FileSystem fs = FileSystem.get((Configuration)CONF);
            if (!FileSystemUtil.isValidDefaultFileSystem(fs)) {
                return "Currently configured default filesystem: " + fs.getClass().getSimpleName() + ". " + "fs.defaultFS" + " (" + CONF.get("fs.defaultFS") + ") is not supported.";
            }
        }
        catch (IOException e) {
            return "couldn't retrieve FileSystem:\n" + e.getMessage();
        }
        String startup_filesystem_check_dirs = BackendConfig.INSTANCE.getStartupFilesystemCheckDirectories();
        for (String path_string : path_strings = startup_filesystem_check_dirs.split(",")) {
            if (path_string.isEmpty()) continue;
            try {
                LOG.info("Verifying access to " + path_string);
                Path path = new Path(path_string);
                FileSystem fs = path.getFileSystem(CONF);
                if (!fs.exists(path)) {
                    return "Invalid path specified for startup_filesystem_check_directories: " + path_string + " does not exist.";
                }
                if (!fs.isDirectory(path)) {
                    return "Invalid path specified for startup_filesystem_check_directories: " + path_string + " is not a directory.";
                }
                FileSystemUtil.getTotalNumVisibleFiles(path);
                LOG.info("Successfully listed " + path_string);
            }
            catch (IllegalArgumentException e) {
                return "Invalid path specified for startup_filesystem_check_directories: " + path_string + ". Error was: \n" + e.getMessage();
            }
            catch (IOException e) {
                return "Could not read the path at " + path_string + ". Error was: \n" + e.getMessage();
            }
        }
        return "";
    }

    public Frontend getFrontend() {
        return this.frontend_;
    }
}

