/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TAddressesList;
import org.apache.impala.thrift.TCacheJarParams;
import org.apache.impala.thrift.TCacheJarResult;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TExprBatch;
import org.apache.impala.thrift.TGetNullPartitionNameRequest;
import org.apache.impala.thrift.TGetNullPartitionNameResponse;
import org.apache.impala.thrift.TGetPartitionStatsRequest;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.TParseDateStringResult;
import org.apache.impala.thrift.TPrioritizeLoadRequest;
import org.apache.impala.thrift.TPrioritizeLoadResponse;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TStatus;
import org.apache.impala.thrift.TSymbolLookupParams;
import org.apache.impala.thrift.TSymbolLookupResult;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TWaitForHmsEventRequest;
import org.apache.impala.util.NativeLibUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FeSupport.class);
    private static boolean loaded_ = false;
    private static boolean externalFE_ = false;

    public static native void NativeFeInit(boolean var0);

    public static native byte[] NativeEvalExprsWithoutRow(byte[] var0, byte[] var1, long var2);

    public static native byte[] NativeLookupSymbol(byte[] var0);

    public static native byte[] NativeCacheJar(byte[] var0);

    public static native int NativeAddPendingTopicItem(long var0, String var2, long var3, byte[] var5, boolean var6);

    public static native Pair<Boolean, ByteBuffer> NativeGetNextCatalogObjectUpdate(long var0);

    public static native boolean NativeLibCacheSetNeedsRefresh(String var0);

    public static native boolean NativeLibCacheRemoveEntry(String var0);

    public static native byte[] NativePrioritizeLoad(byte[] var0);

    public static native byte[] NativeGetPartialCatalogObject(byte[] var0) throws InternalException;

    public static native byte[] NativeGetPartitionStats(byte[] var0);

    public static native byte[] NativeUpdateTableUsage(byte[] var0);

    public static native byte[] NativeParseQueryOptions(String var0, byte[] var1);

    public static native int MinLogSpaceForBloomFilter(long var0, double var2);

    public static native double FalsePositiveProbForBloomFilter(long var0, int var2);

    public static native byte[] nativeParseDateString(String var0);

    public static native byte[] NativeGetNullPartitionName(byte[] var0);

    public static native byte[] NativeGetLatestCompactions(byte[] var0);

    public static native byte[] NativeGetCoordinators();

    public static native long NativeNumLiveQueries();

    public static native byte[] NativeWaitForHmsEvents(byte[] var0, byte[] var1);

    public static TCacheJarResult CacheJar(String hdfsLocation) throws InternalException {
        Preconditions.checkNotNull((Object)hdfsLocation);
        TCacheJarParams params = new TCacheJarParams(hdfsLocation);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.CacheJar(serializer.serialize((TBase)params));
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TCacheJarResult thriftResult = new TCacheJarResult();
            deserializer.deserialize((TBase)thriftResult, result);
            return thriftResult;
        }
        catch (TException e) {
            throw new InternalException("Couldn't cache jar at HDFS location " + hdfsLocation, e);
        }
    }

    private static byte[] CacheJar(byte[] thriftParams) {
        try {
            return FeSupport.NativeCacheJar(thriftParams);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeCacheJar(thriftParams);
        }
    }

    public static TColumnValue EvalExprWithoutRow(Expr expr, TQueryCtx queryCtx) throws InternalException {
        return FeSupport.EvalExprWithoutRowBounded(expr, queryCtx, 0);
    }

    public static TColumnValue EvalExprWithoutRowBounded(Expr expr, TQueryCtx queryCtx, int maxResultSize) throws InternalException {
        Preconditions.checkState((!expr.contains(SlotRef.class) ? 1 : 0) != 0);
        TExprBatch exprBatch = new TExprBatch();
        exprBatch.addToExprs(expr.treeToThrift());
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.EvalExprsWithoutRowBounded(serializer.serialize((TBase)exprBatch), serializer.serialize((TBase)queryCtx), maxResultSize);
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TResultRow val = new TResultRow();
            deserializer.deserialize((TBase)val, result);
            if (val.getColValsSize() != 1) {
                throw new IllegalStateException(String.format("Illegal expr eval result. Expr=%s\nTExpBatch=%s\nResult=%s", expr.toSql(), exprBatch, val));
            }
            return val.getColVals().get(0);
        }
        catch (TException e) {
            throw new InternalException("couldn't execute expr " + expr.toSql(), e);
        }
    }

    private static byte[] LookupSymbol(byte[] thriftParams) {
        try {
            return FeSupport.NativeLookupSymbol(thriftParams);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeLookupSymbol(thriftParams);
        }
    }

    public static TSymbolLookupResult LookupSymbol(TSymbolLookupParams params) throws InternalException {
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] resultBytes = FeSupport.LookupSymbol(serializer.serialize((TBase)params));
            Preconditions.checkNotNull((Object)resultBytes);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TSymbolLookupResult result = new TSymbolLookupResult();
            deserializer.deserialize((TBase)result, resultBytes);
            return result;
        }
        catch (TException e) {
            throw new InternalException("couldn't perform symbol lookup.", e);
        }
    }

    private static byte[] EvalExprsWithoutRow(byte[] thriftExprBatch, byte[] thriftQueryContext) {
        return FeSupport.EvalExprsWithoutRowBounded(thriftExprBatch, thriftQueryContext, 0);
    }

    private static byte[] EvalExprsWithoutRowBounded(byte[] thriftExprBatch, byte[] thriftQueryContext, int maxResultSize) {
        try {
            return FeSupport.NativeEvalExprsWithoutRow(thriftExprBatch, thriftQueryContext, maxResultSize);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeEvalExprsWithoutRow(thriftExprBatch, thriftQueryContext, maxResultSize);
        }
    }

    public static boolean EvalPredicate(Expr pred, TQueryCtx queryCtx) throws InternalException {
        if (pred instanceof BoolLiteral) {
            return ((BoolLiteral)pred).getValue();
        }
        if (Expr.IS_NULL_LITERAL.apply((Object)pred)) {
            return false;
        }
        Preconditions.checkState((boolean)pred.getType().isBoolean());
        TColumnValue val = FeSupport.EvalExprWithoutRow(pred, queryCtx);
        return val.isBool_val() && val.bool_val;
    }

    public static TResultRow EvalPredicateBatch(List<Expr> exprs, TQueryCtx queryCtx) throws InternalException {
        TExprBatch exprBatch = new TExprBatch();
        for (Expr expr : exprs) {
            Preconditions.checkState((boolean)expr.getType().isBoolean());
            Preconditions.checkState((!expr.contains(SlotRef.class) ? 1 : 0) != 0);
            exprBatch.addToExprs(expr.treeToThrift());
        }
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.EvalExprsWithoutRow(serializer.serialize((TBase)exprBatch), serializer.serialize((TBase)queryCtx));
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TResultRow val = new TResultRow();
            deserializer.deserialize((TBase)val, result);
            return val;
        }
        catch (TException e) {
            throw new InternalException("couldn't execute a batch of exprs.", e);
        }
    }

    private static byte[] PrioritizeLoad(byte[] thriftReq) {
        try {
            return FeSupport.NativePrioritizeLoad(thriftReq);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativePrioritizeLoad(thriftReq);
        }
    }

    public static void PrioritizeLoad(Set<TableName> tableNames, @Nullable TUniqueId queryId) throws InternalException {
        Preconditions.checkNotNull(tableNames);
        LOG.info(String.format("Requesting prioritized load of table(s): %s", Joiner.on((String)", ").join(tableNames)));
        ArrayList<TCatalogObject> objectDescs = new ArrayList<TCatalogObject>(tableNames.size());
        for (TableName tableName : tableNames) {
            TCatalogObject catalogObject = new TCatalogObject();
            catalogObject.setType(TCatalogObjectType.TABLE);
            catalogObject.setTable(new TTable(tableName.getDb(), tableName.getTbl()));
            objectDescs.add(catalogObject);
        }
        TPrioritizeLoadRequest request = new TPrioritizeLoadRequest();
        request.setHeader(new TCatalogServiceRequestHeader());
        request.header.setQuery_id(queryId);
        request.setObject_descs(objectDescs);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.PrioritizeLoad(serializer.serialize((TBase)request));
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TPrioritizeLoadResponse response = new TPrioritizeLoadResponse();
            deserializer.deserialize((TBase)response, result);
            if (response.getStatus().getStatus_code() != TErrorCode.OK) {
                throw new InternalException("Error requesting prioritized load: " + Joiner.on((String)"\n").join(response.getStatus().getError_msgs()));
            }
        }
        catch (TException e) {
            throw new InternalException("Error processing request: " + e.getMessage(), e);
        }
    }

    private static byte[] GetPartitionStats(byte[] thriftReq) {
        try {
            return FeSupport.NativeGetPartitionStats(thriftReq);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeGetPartitionStats(thriftReq);
        }
    }

    public static TGetPartitionStatsResponse GetPartitionStats(TableName table) throws InternalException {
        Preconditions.checkNotNull((Object)table);
        LOG.info("Fetching partition statistics for table {} from catalog.", (Object)table);
        TGetPartitionStatsRequest request = new TGetPartitionStatsRequest();
        request.setTable_name(table.toThrift());
        TGetPartitionStatsResponse response = new TGetPartitionStatsResponse();
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.GetPartitionStats(serializer.serialize((TBase)request));
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize((TBase)response, result);
            if (response.getStatus().getStatus_code() != TErrorCode.OK) {
                throw new InternalException("Error requesting GetPartitionStats: " + Joiner.on((String)"\n").join(response.getStatus().getError_msgs()));
            }
        }
        catch (TException e) {
            throw new InternalException("Error processing request: " + e.getMessage(), e);
        }
        int numPartitionsFetched = 0;
        if (response.isSetPartition_stats()) {
            numPartitionsFetched = response.partition_stats.size();
        }
        LOG.info("Fetched statistics for {} partitions of table {}.", (Object)numPartitionsFetched, (Object)table);
        return response;
    }

    private static byte[] ParseQueryOptions(String csvQueryOptions, byte[] queryOptions) {
        try {
            return FeSupport.NativeParseQueryOptions(csvQueryOptions, queryOptions);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeParseQueryOptions(csvQueryOptions, queryOptions);
        }
    }

    public static TQueryOptions ParseQueryOptions(String csvQueryOptions, TQueryOptions queryOptions) throws InternalException {
        Preconditions.checkNotNull((Object)csvQueryOptions);
        Preconditions.checkNotNull((Object)queryOptions);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] result = FeSupport.ParseQueryOptions(csvQueryOptions, serializer.serialize((TBase)queryOptions));
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TQueryOptions updatedQueryOptions = new TQueryOptions();
            deserializer.deserialize((TBase)updatedQueryOptions, result);
            return updatedQueryOptions;
        }
        catch (TException e) {
            throw new InternalException("Could not parse query options: " + e.getMessage(), e);
        }
    }

    public static int GetMinLogSpaceForBloomFilter(long ndv, double fpp) {
        try {
            return FeSupport.MinLogSpaceForBloomFilter(ndv, fpp);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.MinLogSpaceForBloomFilter(ndv, fpp);
        }
    }

    public static double GetFalsePositiveProbForBloomFilter(long ndv, int logBufferpoolSpace) {
        try {
            return FeSupport.FalsePositiveProbForBloomFilter(ndv, logBufferpoolSpace);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.FalsePositiveProbForBloomFilter(ndv, logBufferpoolSpace);
        }
    }

    public static byte[] GetPartialCatalogObject(byte[] thriftReq) throws InternalException {
        try {
            return FeSupport.NativeGetPartialCatalogObject(thriftReq);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeGetPartialCatalogObject(thriftReq);
        }
    }

    private static byte[] parseDateStringUtil(String date) {
        try {
            return FeSupport.nativeParseDateString(date);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.nativeParseDateString(date);
        }
    }

    public static TParseDateStringResult parseDateString(String date) throws InternalException {
        Preconditions.checkNotNull((Object)date);
        try {
            byte[] result = FeSupport.parseDateStringUtil(date);
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TParseDateStringResult res = new TParseDateStringResult();
            deserializer.deserialize((TBase)res, result);
            return res;
        }
        catch (TException e) {
            throw new InternalException("Could not parse date string: " + e.getMessage(), e);
        }
    }

    private static byte[] GetNullPartitionName(byte[] thriftReq) {
        try {
            return FeSupport.NativeGetNullPartitionName(thriftReq);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeGetNullPartitionName(thriftReq);
        }
    }

    public static String GetNullPartitionName() throws InternalException {
        TGetNullPartitionNameRequest request = new TGetNullPartitionNameRequest();
        TGetNullPartitionNameResponse response = new TGetNullPartitionNameResponse();
        try {
            byte[] result = FeSupport.GetNullPartitionName(new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory()).serialize((TBase)request));
            Preconditions.checkNotNull((Object)result);
            new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory()).deserialize((TBase)response, result);
            if (response.getStatus().getStatus_code() != TErrorCode.OK) {
                throw new InternalException("Error requesting GetNullPartitionName: " + Joiner.on((String)"\n").join(response.getStatus().getError_msgs()));
            }
            Preconditions.checkNotNull((Object)response.partition_value);
            return response.partition_value;
        }
        catch (TException e) {
            throw new InternalException("Error processing request: " + e.getMessage(), e);
        }
    }

    public static byte[] GetLatestCompactions(byte[] thriftReq) {
        try {
            return FeSupport.NativeGetLatestCompactions(thriftReq);
        }
        catch (UnsatisfiedLinkError e) {
            FeSupport.loadLibrary();
            return FeSupport.NativeGetLatestCompactions(thriftReq);
        }
    }

    public static TAddressesList GetCoordinators() throws InternalException {
        try {
            byte[] result = FeSupport.NativeGetCoordinators();
            Preconditions.checkNotNull((Object)result);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TAddressesList coordinators_list = new TAddressesList();
            deserializer.deserialize((TBase)coordinators_list, result);
            return coordinators_list;
        }
        catch (TException e) {
            throw new InternalException("Error getting coordinators", e);
        }
    }

    public static long NumLiveQueries() {
        return FeSupport.NativeNumLiveQueries();
    }

    public static TStatus WaitForHmsEvents(TWaitForHmsEventRequest req, TQueryOptions queryOptions) throws InternalException {
        try {
            TSerializer serializer = new TSerializer();
            byte[] result = FeSupport.NativeWaitForHmsEvents(serializer.serialize((TBase)req), serializer.serialize((TBase)queryOptions));
            Preconditions.checkNotNull((Object)result, (Object)"result of NativeWaitForHmsEvents is null");
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            TStatus status = new TStatus();
            deserializer.deserialize((TBase)status, result);
            return status;
        }
        catch (TException e) {
            throw new InternalException("Error waiting for HMS events", e);
        }
    }

    public static synchronized void setExternalFE() {
        Preconditions.checkState((!loaded_ ? 1 : 0) != 0);
        externalFE_ = true;
    }

    public static synchronized void loadLibrary() {
        if (loaded_) {
            return;
        }
        LOG.info("Loading libfesupport.so");
        NativeLibUtil.loadLibrary("libfesupport.so");
        LOG.info("Loaded libfesupport.so");
        loaded_ = true;
        FeSupport.NativeFeInit(externalFE_);
    }
}

