/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationDelta;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnNotFoundException;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FileMetadataLoadOpts;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.HdfsTableLoadParamsBuilder;
import org.apache.impala.catalog.HiveStorageDescriptorFactory;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.ParallelFileMetadataLoader;
import org.apache.impala.catalog.PartitionNotFoundException;
import org.apache.impala.catalog.PartitionStatsUtil;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.TableNotFoundException;
import org.apache.impala.catalog.Transaction;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.View;
import org.apache.impala.catalog.events.DeleteEventLog;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.monitor.CatalogMonitor;
import org.apache.impala.catalog.monitor.CatalogOperationTracker;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.catalog.paimon.PaimonCatalogOpExecutor;
import org.apache.impala.catalog.paimon.PaimonTableLoadingException;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.common.TransactionException;
import org.apache.impala.common.TransactionKeepalive;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveJavaFunctionFactory;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.IcebergCatalogOpExecutor;
import org.apache.impala.service.JniCatalog;
import org.apache.impala.service.KuduCatalogOpExecutor;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TAlterDbParams;
import org.apache.impala.thrift.TAlterDbSetOwnerParams;
import org.apache.impala.thrift.TAlterTableAddColsParams;
import org.apache.impala.thrift.TAlterTableAddDropRangePartitionParams;
import org.apache.impala.thrift.TAlterTableAddPartitionParams;
import org.apache.impala.thrift.TAlterTableAlterColParams;
import org.apache.impala.thrift.TAlterTableDropColParams;
import org.apache.impala.thrift.TAlterTableDropPartitionParams;
import org.apache.impala.thrift.TAlterTableExecuteParams;
import org.apache.impala.thrift.TAlterTableOrViewSetOwnerParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableReplaceColsParams;
import org.apache.impala.thrift.TAlterTableSetCachedParams;
import org.apache.impala.thrift.TAlterTableSetFileFormatParams;
import org.apache.impala.thrift.TAlterTableSetLocationParams;
import org.apache.impala.thrift.TAlterTableSetPartitionSpecParams;
import org.apache.impala.thrift.TAlterTableSetRowFormatParams;
import org.apache.impala.thrift.TAlterTableSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TAlterTableUnSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableUpdateStatsParams;
import org.apache.impala.thrift.TBucketType;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TCatalogUpdateResult;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnName;
import org.apache.impala.thrift.TColumnStats;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TCommentOnParams;
import org.apache.impala.thrift.TCopyTestCaseReq;
import org.apache.impala.thrift.TCreateDataSourceParams;
import org.apache.impala.thrift.TCreateDbParams;
import org.apache.impala.thrift.TCreateDropRoleParams;
import org.apache.impala.thrift.TCreateFunctionParams;
import org.apache.impala.thrift.TCreateOrAlterViewParams;
import org.apache.impala.thrift.TCreateTableLikeParams;
import org.apache.impala.thrift.TCreateTableParams;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TDdlExecResponse;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TDropDataSourceParams;
import org.apache.impala.thrift.TDropDbParams;
import org.apache.impala.thrift.TDropFunctionParams;
import org.apache.impala.thrift.TDropStatsParams;
import org.apache.impala.thrift.TDropTableOrViewParams;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TFunctionName;
import org.apache.impala.thrift.TGrantRevokePrivParams;
import org.apache.impala.thrift.TGrantRevokeRoleParams;
import org.apache.impala.thrift.THdfsCachingOp;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergPartitionSpec;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TKuduPartitionParam;
import org.apache.impala.thrift.TPaimonCatalog;
import org.apache.impala.thrift.TPartitionDef;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.thrift.TRangePartitionOperationType;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TResetMetadataResponse;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TRuntimeProfileNode;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TStatus;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.thrift.TTableRowFormat;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.thrift.TTestCaseData;
import org.apache.impala.thrift.TTruncateParams;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateCatalogRequest;
import org.apache.impala.thrift.TUpdateCatalogResponse;
import org.apache.impala.thrift.TUpdatedPartition;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.CatalogOpUtil;
import org.apache.impala.util.CompressionUtil;
import org.apache.impala.util.DebugUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.HdfsCachingUtil;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.ThreadNameAnnotator;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogOpExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogOpExecutor.class);
    public static final String HMS_RPC_ERROR_FORMAT_STR = "Error making '%s' RPC to Hive Metastore: ";
    private static final String BLACKLISTED_DBS_INCONSISTENT_ERR_STR = "--blacklisted_dbs or --enable_workload_mgmt may be inconsistent between catalogd and coordinators";
    private static final String BLACKLISTED_TABLES_INCONSISTENT_ERR_STR = "--blacklisted_tables may be inconsistent between catalogd and coordinators";
    private static final String ALTER_TBL_UNSET_NON_EXIST_PROPERTY = "Please use the following syntax if not sure whether the property existed or not:\nALTER TABLE tableName UNSET (TBLPROPERTIES|SERDEPROPERTIES) IF EXISTS (key1, key2, ...)\n";
    private static final String ALTER_VIEW_UNSET_NON_EXIST_PROPERTY = "Please use the following syntax if not sure whether the property existed or not:\nALTER VIEW viewName UNSET TBLPROPERTIES IF EXISTS (key1, key2, ...)\n";
    private static final String ACIDINSERTONLY_CAPABILITIES = "HIVEMANAGEDINSERTREAD,HIVEMANAGEDINSERTWRITE";
    private static final String FULLACID_CAPABILITIES = "HIVEFULLACIDREAD";
    private static final String NONACID_CAPABILITIES = "EXTREAD,EXTWRITE";
    public static final short MAX_PARTITION_UPDATES_PER_RPC = 500;
    public static final String CAPABILITIES_KEY = "OBJCAPABILITIES";
    private static final String CATALOG_TIMELINE_NAME = "Catalog Server Operation";
    private static final String CHECKED_HMS_TABLE_EXISTENCE = "Checked table existence in Metastore";
    private static final String CREATED_HMS_TABLE = "Created table in Metastore";
    private static final String CREATED_CATALOG_TABLE = "Created table in catalog cache";
    private static final String CREATED_ICEBERG_TABLE = "Created table using Iceberg Catalog ";
    private static final String DDL_FINISHED = "DDL finished";
    public static final String FETCHED_LATEST_HMS_EVENT_ID = "Got current Metastore event id ";
    public static final String FETCHED_HMS_EVENT_BATCH = "Fetched event batch from Metastore";
    public static final String FETCHED_HMS_TABLE = "Fetched table from Metastore";
    public static final String FETCHED_HMS_DB = "Fetched database from Metastore";
    public static final String FETCHED_HMS_PARTITION = "Fetched partition from Metastore";
    private static final String GOT_METASTORE_DDL_LOCK = "Got metastoreDdlLock";
    public static final String GOT_TABLE_WRITE_LOCK = "Got catalog version write lock and table write lock";
    public static final String GOT_TABLE_READ_LOCK = "Got table read lock";
    private static final String LOADED_ICEBERG_TABLE = "Loaded iceberg table";
    private static final String SENT_CATALOG_FOR_SYNC_DDL = "Sent catalog update for sync_ddl";
    private final CatalogServiceCatalog catalog_;
    private final AuthorizationConfig authzConfig_;
    private final AuthorizationManager authzManager_;
    private final HiveJavaFunctionFactory hiveJavaFuncFactory_;
    private final ExecutorService icebergExecutorService_;
    private final CatalogOperationTracker catalogOpTracker_ = CatalogMonitor.INSTANCE.getCatalogOperationTracker();
    private final ReentrantLock metastoreDdlLock_ = new ReentrantLock();

    public CatalogOpExecutor(CatalogServiceCatalog catalog, AuthorizationConfig authzConfig, AuthorizationManager authzManager, HiveJavaFunctionFactory hiveJavaFuncFactory) throws ImpalaException {
        Preconditions.checkNotNull((Object)authzManager);
        this.catalog_ = (CatalogServiceCatalog)Preconditions.checkNotNull((Object)catalog);
        this.authzConfig_ = (AuthorizationConfig)Preconditions.checkNotNull((Object)authzConfig);
        this.authzManager_ = (AuthorizationManager)Preconditions.checkNotNull((Object)authzManager);
        this.hiveJavaFuncFactory_ = (HiveJavaFunctionFactory)Preconditions.checkNotNull((Object)hiveJavaFuncFactory);
        this.icebergExecutorService_ = Executors.newFixedThreadPool(BackendConfig.INSTANCE.icebergCatalogNumThreads(), new ThreadFactoryBuilder().setNameFormat("IcebergCatalogThread-%d").build());
    }

    public CatalogServiceCatalog getCatalog() {
        return this.catalog_;
    }

    public AuthorizationManager getAuthzManager() {
        return this.authzManager_;
    }

    public TDdlExecResponse execDdlRequest(TDdlExecRequest ddlRequest) throws ImpalaException {
        EventSequence catalogTimeline = new EventSequence(CATALOG_TIMELINE_NAME);
        TDdlExecResponse response = new TDdlExecResponse();
        response.setResult(new TCatalogUpdateResult());
        response.getResult().setCatalog_service_id(JniCatalog.getServiceId());
        User requestingUser = null;
        TUniqueId queryId = null;
        boolean wantMinimalResult = false;
        if (ddlRequest.isSetHeader()) {
            TCatalogServiceRequestHeader header = ddlRequest.getHeader();
            if (header.isSetRequesting_user()) {
                requestingUser = new User(ddlRequest.getHeader().getRequesting_user());
            }
            wantMinimalResult = ddlRequest.getHeader().isWant_minimal_response();
            queryId = header.getQuery_id();
        }
        Optional<TTableName> tTableName = Optional.empty();
        TDdlType ddlType = ddlRequest.ddl_type;
        try {
            boolean syncDdl = ddlRequest.getQuery_options().isSync_ddl();
            String debugAction = ddlRequest.getQuery_options().getDebug_action();
            switch (ddlType) {
                case ALTER_DATABASE: {
                    TAlterDbParams alter_db_params = ddlRequest.getAlter_db_params();
                    tTableName = Optional.of(new TTableName(alter_db_params.db, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.alterDatabase(alter_db_params, wantMinimalResult, response, catalogTimeline);
                    break;
                }
                case ALTER_TABLE: {
                    TAlterTableParams alter_table_params = ddlRequest.getAlter_table_params();
                    tTableName = Optional.of(alter_table_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.alterTable(alter_table_params, debugAction, wantMinimalResult, response, catalogTimeline);
                    break;
                }
                case ALTER_VIEW: {
                    TCreateOrAlterViewParams alter_view_params = ddlRequest.getAlter_view_params();
                    tTableName = Optional.of(alter_view_params.getView_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.alterView(alter_view_params, wantMinimalResult, response, catalogTimeline);
                    break;
                }
                case CREATE_DATABASE: {
                    TCreateDbParams create_db_params = ddlRequest.getCreate_db_params();
                    tTableName = Optional.of(new TTableName(create_db_params.db, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createDatabase(create_db_params, response, catalogTimeline, syncDdl, wantMinimalResult);
                    break;
                }
                case CREATE_TABLE_AS_SELECT: {
                    TCreateTableParams create_table_as_select_params = ddlRequest.getCreate_table_params();
                    tTableName = Optional.of(create_table_as_select_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    response.setNew_table_created(this.createTable(create_table_as_select_params, response, catalogTimeline, syncDdl, wantMinimalResult, debugAction));
                    break;
                }
                case CREATE_TABLE: {
                    TCreateTableParams create_table_params = ddlRequest.getCreate_table_params();
                    tTableName = Optional.of(create_table_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createTable(ddlRequest.getCreate_table_params(), response, catalogTimeline, syncDdl, wantMinimalResult, debugAction);
                    break;
                }
                case CREATE_TABLE_LIKE: {
                    TCreateTableLikeParams create_table_like_params = ddlRequest.getCreate_table_like_params();
                    tTableName = Optional.of(create_table_like_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createTableLike(create_table_like_params, response, catalogTimeline, syncDdl, wantMinimalResult, debugAction);
                    break;
                }
                case CREATE_VIEW: {
                    TCreateOrAlterViewParams create_view_params = ddlRequest.getCreate_view_params();
                    tTableName = Optional.of(create_view_params.getView_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createView(create_view_params, wantMinimalResult, response, catalogTimeline);
                    break;
                }
                case CREATE_FUNCTION: {
                    TCreateFunctionParams create_func_params = ddlRequest.getCreate_fn_params();
                    TFunctionName fnName = create_func_params.getFn().getName();
                    tTableName = Optional.of(new TTableName(fnName.db_name, fnName.function_name));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createFunction(ddlRequest.getCreate_fn_params(), response, catalogTimeline);
                    break;
                }
                case CREATE_DATA_SOURCE: {
                    TCreateDataSourceParams create_ds_params = ddlRequest.getCreate_data_source_params();
                    tTableName = Optional.of(new TTableName(create_ds_params.getData_source().name, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createDataSource(create_ds_params, response);
                    break;
                }
                case COMPUTE_STATS: {
                    Preconditions.checkState((boolean)false, (Object)"Compute stats should trigger an ALTER TABLE.");
                    break;
                }
                case DROP_STATS: {
                    TDropStatsParams drop_stats_params = ddlRequest.getDrop_stats_params();
                    tTableName = Optional.of(drop_stats_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropStats(drop_stats_params, wantMinimalResult, response, catalogTimeline, ddlRequest.getQuery_options().getDebug_action());
                    break;
                }
                case DROP_DATABASE: {
                    TDropDbParams drop_db_params = ddlRequest.getDrop_db_params();
                    tTableName = Optional.of(new TTableName(drop_db_params.getDb(), ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropDatabase(drop_db_params, response, ddlRequest.getQuery_options().getKudu_table_reserve_seconds(), catalogTimeline);
                    break;
                }
                case DROP_TABLE: 
                case DROP_VIEW: {
                    TDropTableOrViewParams drop_table_or_view_params = ddlRequest.getDrop_table_or_view_params();
                    tTableName = Optional.of(drop_table_or_view_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropTableOrView(drop_table_or_view_params, response, ddlRequest.getQuery_options().getLock_max_wait_time_s(), ddlRequest.getQuery_options().getKudu_table_reserve_seconds(), catalogTimeline);
                    break;
                }
                case TRUNCATE_TABLE: {
                    TTruncateParams truncate_params = ddlRequest.getTruncate_params();
                    tTableName = Optional.of(truncate_params.getTable_name());
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.truncateTable(truncate_params, wantMinimalResult, response, ddlRequest.getQuery_options().getLock_max_wait_time_s(), catalogTimeline, ddlRequest.getQuery_options().getDebug_action());
                    break;
                }
                case DROP_FUNCTION: {
                    TDropFunctionParams drop_func_params = ddlRequest.getDrop_fn_params();
                    TFunctionName dropFnName = drop_func_params.getFn_name();
                    tTableName = Optional.of(new TTableName(dropFnName.db_name, dropFnName.function_name));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropFunction(ddlRequest.getDrop_fn_params(), response, catalogTimeline);
                    break;
                }
                case DROP_DATA_SOURCE: {
                    TDropDataSourceParams drop_ds_params = ddlRequest.getDrop_data_source_params();
                    tTableName = Optional.of(new TTableName(drop_ds_params.data_source, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropDataSource(drop_ds_params, response);
                    break;
                }
                case CREATE_ROLE: {
                    TCreateDropRoleParams create_role_params = ddlRequest.getCreate_drop_role_params();
                    tTableName = Optional.of(new TTableName(create_role_params.role_name, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.createRole(requestingUser, create_role_params, response);
                    break;
                }
                case DROP_ROLE: {
                    TCreateDropRoleParams drop_role_params = ddlRequest.getCreate_drop_role_params();
                    tTableName = Optional.of(new TTableName(drop_role_params.role_name, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.dropRole(requestingUser, drop_role_params, response);
                    break;
                }
                case GRANT_ROLE: {
                    TGrantRevokeRoleParams grant_role_params = ddlRequest.getGrant_revoke_role_params();
                    tTableName = Optional.of(new TTableName(StringUtils.join((CharSequence)",", grant_role_params.group_names), ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.grantRoleToGroup(requestingUser, grant_role_params, response);
                    break;
                }
                case REVOKE_ROLE: {
                    TGrantRevokeRoleParams revoke_role_params = ddlRequest.getGrant_revoke_role_params();
                    tTableName = Optional.of(new TTableName(StringUtils.join((CharSequence)",", revoke_role_params.group_names), ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.revokeRoleFromGroup(requestingUser, revoke_role_params, response);
                    break;
                }
                case GRANT_PRIVILEGE: {
                    TGrantRevokePrivParams grant_priv_params = ddlRequest.getGrant_revoke_priv_params();
                    tTableName = Optional.of(new TTableName(grant_priv_params.principal_name, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.grantPrivilege(ddlRequest.getHeader(), grant_priv_params, response);
                    break;
                }
                case REVOKE_PRIVILEGE: {
                    TGrantRevokePrivParams revoke_priv_params = ddlRequest.getGrant_revoke_priv_params();
                    tTableName = Optional.of(new TTableName(revoke_priv_params.principal_name, ""));
                    this.catalogOpTracker_.increment(ddlRequest, tTableName);
                    this.revokePrivilege(ddlRequest.getHeader(), revoke_priv_params, response);
                    break;
                }
                case COMMENT_ON: {
                    tTableName = Optional.of(new TTableName("", ""));
                    this.alterCommentOn(ddlRequest, response, tTableName, wantMinimalResult, catalogTimeline);
                    break;
                }
                case COPY_TESTCASE: {
                    this.catalogOpTracker_.increment(ddlRequest, Optional.empty());
                    this.copyTestCaseData(ddlRequest.getCopy_test_case_params(), response, wantMinimalResult);
                    break;
                }
                default: {
                    this.catalogOpTracker_.increment(ddlRequest, Optional.empty());
                    throw new IllegalStateException("Unexpected DDL exec request type: " + (Object)((Object)ddlType));
                }
            }
            catalogTimeline.markEvent(DDL_FINISHED);
            if (syncDdl) {
                response.getResult().setVersion(this.catalog_.waitForSyncDdlVersion(response.getResult()));
                catalogTimeline.markEvent(SENT_CATALOG_FOR_SYNC_DDL);
            }
            TRuntimeProfileNode profile = Frontend.createTRuntimeProfileNode("CatalogOp");
            profile.addToEvent_sequences(catalogTimeline.toThrift());
            response.setProfile(profile);
            response.getResult().setStatus(new TStatus(TErrorCode.OK, new ArrayList<String>()));
            this.catalogOpTracker_.decrement(ddlType, queryId, tTableName, null);
        }
        catch (Exception e) {
            this.catalogOpTracker_.decrement(ddlType, queryId, tTableName, JniUtil.throwableToString(e));
            throw e;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public String copyTestCaseData(TCopyTestCaseReq request, TDdlExecResponse response, boolean wantMinimalResult) throws ImpalaException {
        Path inputPath = new Path((String)Preconditions.checkNotNull((Object)request.input_path));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FileSystem fs = FileSystemUtil.getFileSystemForPath(inputPath);
            FSDataInputStream in = fs.open(inputPath);
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)fs.getConf(), (boolean)true);
        }
        catch (IOException e) {
            throw new ImpalaRuntimeException(String.format("Error reading test case data from path: %s", inputPath), e);
        }
        byte[] decompressedBytes = CompressionUtil.deflateDecompress(out.toByteArray());
        TTestCaseData testCaseData = new TTestCaseData();
        try {
            JniUtil.deserializeThrift(testCaseData, decompressedBytes);
        }
        catch (ImpalaException e) {
            throw new CatalogException(String.format("Error deserializing the testcase data at path %s. File data may be corrupt or incompatible with the current version of Impala.", inputPath.toString()), e);
        }
        int numDbsAdded = 0;
        if (testCaseData.getDbs() != null) {
            for (TDatabase thriftDb : testCaseData.getDbs()) {
                Db db = Db.fromTDatabase(thriftDb);
                db.setCatalogVersion(this.catalog_.incrementAndGetCatalogVersion());
                Db ret = this.catalog_.addDb(db.getName(), db.getMetaStoreDb());
                if (ret == null) continue;
                ++numDbsAdded;
                this.addDbToCatalogUpdate(db, wantMinimalResult, response.result);
            }
        }
        int numTblsAdded = 0;
        int numViewsAdded = 0;
        int numPartsAdded = 0;
        int numFilesAdded = 0;
        if (testCaseData.getTables_and_views() != null) {
            for (TTable tTable : testCaseData.tables_and_views) {
                Db db = this.catalog_.getDb(tTable.db_name);
                Preconditions.checkNotNull((Object)db, (Object)String.format("Missing db %s", tTable.db_name));
                org.apache.impala.catalog.Table t = org.apache.impala.catalog.Table.fromThrift(db, tTable, false);
                t.setCatalogVersion(this.catalog_.incrementAndGetCatalogVersion());
                this.catalog_.addTable(db, t);
                if (t instanceof View) {
                    ++numViewsAdded;
                } else {
                    ++numTblsAdded;
                }
                t.takeReadLock();
                try {
                    CatalogOpExecutor.addTableToCatalogUpdate(t, wantMinimalResult, response.result);
                    if (!(t instanceof HdfsTable)) continue;
                    HdfsTable hdfsTable = (HdfsTable)t;
                    for (PrunablePartition prunablePartition : hdfsTable.getPartitions()) {
                        HdfsPartition part = (HdfsPartition)prunablePartition;
                        numFilesAdded += part.getNumFileDescriptors();
                        ++numPartsAdded;
                    }
                }
                finally {
                    t.releaseReadLock();
                }
            }
        }
        StringBuilder responseStr = new StringBuilder();
        responseStr.append(String.format("Testcase generated using Impala version %s. ", testCaseData.getImpala_version()));
        responseStr.append(String.format("%d db(s), %d table(s) and %d view(s) imported for query: ", numDbsAdded, numTblsAdded, numViewsAdded));
        responseStr.append("\n\n").append(testCaseData.getQuery_stmt());
        LOG.info("{}\n\nTotal partitions: {}. Total files: {}. Testcase path: {}", new Object[]{responseStr, numPartsAdded, numFilesAdded, inputPath});
        CatalogOpExecutor.addSummary(response, responseStr.toString());
        return testCaseData.getQuery_stmt();
    }

    private static void addSummary(TDdlExecResponse response, String summary) {
        TColumnValue resultColVal = new TColumnValue();
        resultColVal.setString_val(summary);
        TResultSet resultSet = new TResultSet();
        resultSet.setSchema(new TResultSetMetadata(Lists.newArrayList((Object[])new TColumn[]{new TColumn("summary", Type.STRING.toThrift())})));
        TResultRow resultRow = new TResultRow();
        resultRow.setColVals(Lists.newArrayList((Object[])new TColumnValue[]{resultColVal}));
        resultSet.setRows(Lists.newArrayList((Object[])new TResultRow[]{resultRow}));
        response.setResult_set(resultSet);
    }

    public void UnlockWriteLockIfErronouslyLocked() {
        if (this.catalog_.getLock().isWriteLockedByCurrentThread()) {
            LOG.error("Write lock should have been released.");
            this.catalog_.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTableIfNotAddedLater(long eventId, String dbName, String tblName, Reference<Boolean> tblAddedLater) {
        tblAddedLater.setRef(false);
        this.getMetastoreDdlLock().lock();
        try {
            Db db = this.catalog_.getDb(dbName);
            if (db == null) {
                LOG.debug("EventId: {} Not removing the table since database {} does not exist", (Object)eventId, (Object)dbName);
                boolean bl = false;
                return bl;
            }
            org.apache.impala.catalog.Table tblToBeRemoved = db.getTable(tblName);
            if (tblToBeRemoved == null) {
                LOG.debug("EventId: {} Not removing the table since table {} does not exist", (Object)eventId, (Object)tblName);
                boolean bl = false;
                return bl;
            }
            if (eventId <= tblToBeRemoved.getCreateEventId()) {
                LOG.debug("EventId: {} Not removing the table {} table's create event id is {} ", new Object[]{eventId, new TableName(dbName, tblName), tblToBeRemoved.getCreateEventId()});
                tblAddedLater.setRef(true);
                boolean bl = false;
                return bl;
            }
            LOG.debug("EventId: {} Removing table {}.{} since its create event id is {}", new Object[]{eventId, dbName, tblName, tblToBeRemoved.getCreateEventId()});
            org.apache.impala.catalog.Table removedTbl = db.removeTable(tblToBeRemoved.getName());
            removedTbl.setCatalogVersion(this.catalog_.incrementAndGetCatalogVersion());
            this.catalog_.getDeleteLog().addRemovedObject(removedTbl.toMinimalTCatalogObject());
            boolean bl = true;
            return bl;
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTableIfNotRemovedLater(long eventId, org.apache.hadoop.hive.metastore.api.Table msTbl) throws DatabaseNotFoundException {
        this.getMetastoreDdlLock().lock();
        try {
            String dbName = msTbl.getDbName();
            Db db = this.catalog_.getDb(dbName);
            DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
            if (db == null) {
                if (!deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getDbKey(msTbl.getDbName()))) {
                    throw new DatabaseNotFoundException(dbName + " not found");
                }
                LOG.debug("EventId: {} Table was not added since the database {} was removed later", (Object)eventId, (Object)dbName);
                boolean bl = false;
                return bl;
            }
            String tblName = msTbl.getTableName();
            org.apache.impala.catalog.Table existingTable = db.getTable(tblName);
            if (existingTable != null) {
                LOG.debug("EventId: {} Table {} was not added since it already exists in catalog.", (Object)eventId, (Object)existingTable.getFullName());
                if (existingTable.getCreateEventId() != eventId) {
                    LOG.warn("Existing table {} create event Id: {} does not match the event id: {}", new Object[]{existingTable.getFullName(), existingTable.getCreateEventId(), eventId});
                }
                boolean bl = false;
                return bl;
            }
            if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getKey(msTbl))) {
                LOG.debug("EventId: {} Table was not added since it was removed later", (Object)eventId);
                boolean bl = false;
                return bl;
            }
            IncompleteTable incompleteTable = IncompleteTable.createUninitializedTable(db, tblName, MetastoreShim.mapToInternalTableType(msTbl.getTableType()), MetadataOp.getTableComment(msTbl), eventId);
            incompleteTable.setCatalogVersion(this.catalog_.incrementAndGetCatalogVersion());
            db.addTable(incompleteTable);
            LOG.debug("EventId: {} Added table {}. Catalog version: {}", new Object[]{eventId, incompleteTable.getFullName(), incompleteTable.getCatalogVersion()});
            boolean bl = true;
            return bl;
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTableFromEvent(long eventId, org.apache.hadoop.hive.metastore.api.Table msTblBefore, org.apache.hadoop.hive.metastore.api.Table msTblAfter, Reference<Boolean> oldTblRemoved, Reference<Boolean> newTblAdded) throws CatalogException {
        this.getMetastoreDdlLock().lock();
        try {
            org.apache.impala.catalog.Table tblBefore = null;
            try {
                tblBefore = this.catalog_.getTable(msTblBefore.getDbName(), msTblBefore.getTableName());
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                // empty catch block
            }
            boolean beforeTblLocked = false;
            try {
                if (tblBefore != null) {
                    this.tryWriteLock(tblBefore, "ALTER_TABLE RENAME EVENT", NoOpEventSequence.INSTANCE);
                    beforeTblLocked = true;
                    this.catalog_.getLock().writeLock().unlock();
                }
                Reference<Boolean> tableAddedLater = new Reference<Boolean>();
                boolean tblRemoved = this.removeTableIfNotAddedLater(eventId, msTblBefore.getDbName(), msTblBefore.getTableName(), tableAddedLater);
                oldTblRemoved.setRef(tblRemoved);
                if (!tblRemoved) {
                    LOG.debug("EventId: {} original table not removed since {}", (Object)eventId, (Object)(tableAddedLater.getRef() != false ? "it is added later" : "it doesn't exist anymore"));
                }
                boolean tblAdded = this.addTableIfNotRemovedLater(eventId, msTblAfter);
                newTblAdded.setRef(tblAdded);
            }
            catch (InternalException e) {
                throw new CatalogException("Unable to process rename table event " + eventId, e);
            }
            finally {
                this.UnlockWriteLockIfErronouslyLocked();
                if (tblBefore != null && beforeTblLocked) {
                    tblBefore.releaseWriteLock();
                }
            }
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDbIfNotRemovedLater(long eventId, Database msDb) {
        this.getMetastoreDdlLock().lock();
        try {
            String dbName = msDb.getName();
            Db db = this.catalog_.getDb(dbName);
            DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
            if (db == null && !deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getKey(msDb))) {
                this.catalog_.addDb(dbName, msDb, eventId);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDbIfNotAddedLater(long eventId, String dbName) {
        this.getMetastoreDdlLock().lock();
        try {
            Db catalogDb = this.catalog_.getDb(dbName);
            if (catalogDb == null) {
                LOG.info("EventId: {} Skipping the event since database {} does not exist anymore", (Object)eventId, (Object)dbName);
                boolean bl = false;
                return bl;
            }
            if (catalogDb.getCreateEventId() > eventId) {
                LOG.info("EventId: {} Not removing the database {} since the create event id is {}", new Object[]{eventId, dbName, catalogDb.getCreateEventId()});
                boolean bl = false;
                return bl;
            }
            this.catalog_.removeDb(dbName);
            boolean bl = true;
            return bl;
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterDbIfExists(long eventId, Database alteredMsDb) {
        Preconditions.checkNotNull((Object)alteredMsDb);
        String dbName = alteredMsDb.getName();
        Db dbToAlter = this.catalog_.getDb(dbName);
        if (dbToAlter == null) {
            LOG.debug("Event id: {}, not altering db {} since it does not exist in catalogd", (Object)eventId, (Object)dbName);
            return false;
        }
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        boolean dbLocked = false;
        try {
            this.tryLock(dbToAlter, String.format("alter db from event id: %s", eventId), NoOpEventSequence.INSTANCE);
            this.catalog_.getLock().writeLock().unlock();
            dbLocked = true;
            if (syncToLatestEventId && dbToAlter.getLastSyncedEventId() >= eventId) {
                LOG.debug("Not altering db {} from event id: {} since db is already synced till event id: {}", new Object[]{dbName, eventId, dbToAlter.getLastSyncedEventId()});
                boolean bl = false;
                return bl;
            }
            boolean success = this.catalog_.updateDbIfExists(alteredMsDb);
            if (success) {
                dbToAlter.setLastSyncedEventId(eventId);
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Event id: {}, failed to alter db {}. Error message: {}", new Object[]{eventId, dbName, e.getMessage()});
            boolean bl = false;
            return bl;
        }
        finally {
            if (dbLocked) {
                dbToAlter.getLock().unlock();
            }
        }
    }

    private void alterTable(TAlterTableParams params, @Nullable String debugAction, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        boolean reloadFileMetadata = false;
        boolean reloadTableSchema = false;
        Reference<Long> numUpdatedPartitions = new Reference<Long>(0L);
        TableName tableName = TableName.fromThrift(params.getTable_name());
        org.apache.impala.catalog.Table tbl = this.getExistingTable(tableName.getDb(), tableName.getTbl(), "Load for ALTER TABLE", catalogTimeline);
        if (params.getAlter_type() == TAlterTableType.RENAME_VIEW || params.getAlter_type() == TAlterTableType.RENAME_TABLE) {
            TableName newTableName = TableName.fromThrift(params.getRename_params().getNew_table_name());
            Preconditions.checkState((!this.catalog_.isBlacklistedTable(newTableName) ? 1 : 0) != 0, (Object)String.format("Can't rename to blacklisted table name: %s. %s", newTableName, BLACKLISTED_TABLES_INCONSISTENT_ERR_STR));
        }
        this.tryWriteLock(tbl, catalogTimeline);
        long oldCatalogVersion = tbl.getCatalogVersion();
        InProgressTableModification modification = new InProgressTableModification(this.catalog_, tbl);
        this.catalog_.getLock().writeLock().unlock();
        modification.addCatalogServiceIdentifiersToTable();
        Timer.Context context = tbl.getMetrics().getTimer("alter-duration").time();
        try {
            boolean needToUpdateHms;
            if (params.getAlter_type() == TAlterTableType.RENAME_VIEW || params.getAlter_type() == TAlterTableType.RENAME_TABLE) {
                this.alterTableOrViewRename(tbl, TableName.fromThrift(params.getRename_params().getNew_table_name()), wantMinimalResult, response, catalogTimeline, debugAction);
                modification.validateInProgressModificationComplete();
                return;
            }
            String responseSummaryMsg = null;
            if (tbl instanceof KuduTable && this.altersKuduTable(params.getAlter_type())) {
                this.alterKuduTable(params, response, (KuduTable)tbl, modification, wantMinimalResult, catalogTimeline, debugAction);
                modification.validateInProgressModificationComplete();
                return;
            }
            if (tbl instanceof IcebergTable && this.altersIcebergTable(params.getAlter_type()) && !(needToUpdateHms = this.alterIcebergTable(params, response, (IcebergTable)tbl, wantMinimalResult, debugAction, catalogTimeline, modification))) {
                modification.validateInProgressModificationComplete();
                return;
            }
            boolean reloadMetadata = true;
            switch (params.getAlter_type()) {
                case ADD_COLUMNS: {
                    boolean added = false;
                    if (params.getAdd_cols_params() != null && params.getAdd_cols_params().getColumnsSize() != 0) {
                        TAlterTableAddColsParams addColParams = params.getAdd_cols_params();
                        added = this.alterTableAddCols(tbl, addColParams.getColumns(), addColParams.isIf_not_exists(), catalogTimeline, modification);
                        reloadTableSchema = true;
                    }
                    if (added) {
                        responseSummaryMsg = "New column(s) have been added to the table.";
                        break;
                    }
                    responseSummaryMsg = "No new column(s) have been added to the table.";
                    break;
                }
                case REPLACE_COLUMNS: {
                    TAlterTableReplaceColsParams replaceColParams = params.getReplace_cols_params();
                    this.alterTableReplaceCols(tbl, replaceColParams.getColumns(), catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Table columns have been replaced.";
                    break;
                }
                case ADD_PARTITION: {
                    THdfsFileFormat format = null;
                    if (params.isSetSet_file_format_params()) {
                        format = params.getSet_file_format_params().file_format;
                    }
                    this.alterTableAddPartitions(tbl, params.getAdd_partition_params(), format, catalogTimeline, modification, debugAction);
                    reloadMetadata = false;
                    responseSummaryMsg = "New partition has been added to the table.";
                    break;
                }
                case DROP_COLUMN: {
                    TAlterTableDropColParams dropColParams = params.getDrop_col_params();
                    this.alterTableDropCol(tbl, dropColParams.getCol_name(), catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Column has been dropped.";
                    break;
                }
                case ALTER_COLUMN: {
                    TAlterTableAlterColParams alterColParams = params.getAlter_col_params();
                    this.alterTableAlterCol(tbl, alterColParams.getCol_name(), alterColParams.getNew_col_def(), catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Column has been altered.";
                    break;
                }
                case DROP_PARTITION: {
                    TAlterTableDropPartitionParams dropPartParams = params.getDrop_partition_params();
                    if (tbl instanceof IcebergTable) {
                        this.updateHmsAfterIcebergOnlyModification((IcebergTable)tbl, catalogTimeline, modification);
                        break;
                    }
                    this.alterTableDropPartition(tbl, dropPartParams.getPartition_set(), dropPartParams.isIf_exists(), dropPartParams.isPurge(), numUpdatedPartitions, catalogTimeline, modification);
                    responseSummaryMsg = "Dropped " + numUpdatedPartitions.getRef() + " partition(s).";
                    reloadMetadata = false;
                    break;
                }
                case RENAME_TABLE: 
                case RENAME_VIEW: {
                    Preconditions.checkState((boolean)false, (Object)"RENAME TABLE/VIEW operation has been processed");
                    break;
                }
                case SET_FILE_FORMAT: {
                    TAlterTableSetFileFormatParams fileFormatParams = params.getSet_file_format_params();
                    reloadFileMetadata = this.alterTableSetFileFormat(tbl, fileFormatParams.getPartition_set(), fileFormatParams.getFile_format(), numUpdatedPartitions, catalogTimeline, modification);
                    if (fileFormatParams.isSetPartition_set()) {
                        responseSummaryMsg = "Updated " + numUpdatedPartitions.getRef() + " partition(s).";
                        break;
                    }
                    responseSummaryMsg = "Updated table.";
                    break;
                }
                case SET_ROW_FORMAT: {
                    TAlterTableSetRowFormatParams rowFormatParams = params.getSet_row_format_params();
                    reloadFileMetadata = this.alterTableSetRowFormat(tbl, rowFormatParams.getPartition_set(), rowFormatParams.getRow_format(), numUpdatedPartitions, catalogTimeline, modification);
                    if (rowFormatParams.isSetPartition_set()) {
                        responseSummaryMsg = "Updated " + numUpdatedPartitions.getRef() + " partition(s).";
                        break;
                    }
                    responseSummaryMsg = "Updated table.";
                    break;
                }
                case SET_LOCATION: {
                    TAlterTableSetLocationParams setLocationParams = params.getSet_location_params();
                    List<TPartitionKeyValue> partitionSpec = setLocationParams.getPartition_spec();
                    reloadFileMetadata = this.alterTableSetLocation(tbl, partitionSpec, setLocationParams.getLocation(), catalogTimeline, modification);
                    if (partitionSpec == null) {
                        responseSummaryMsg = "New location has been set.";
                        break;
                    }
                    responseSummaryMsg = "New location has been set for the specified partition.";
                    break;
                }
                case SET_TBL_PROPERTIES: {
                    this.alterTableSetTblProperties(tbl, params.getSet_tbl_properties_params(), numUpdatedPartitions, catalogTimeline, modification);
                    reloadTableSchema = true;
                    if (params.getSet_tbl_properties_params().isSetPartition_set()) {
                        responseSummaryMsg = "Updated " + numUpdatedPartitions.getRef() + " partition(s).";
                        break;
                    }
                    responseSummaryMsg = "Updated table.";
                    break;
                }
                case UNSET_TBL_PROPERTIES: {
                    this.alterTableUnSetTblProperties(tbl, params.getUnset_tbl_properties_params(), numUpdatedPartitions, catalogTimeline, modification);
                    reloadTableSchema = true;
                    if (params.getUnset_tbl_properties_params().isSetPartition_set()) {
                        responseSummaryMsg = "Updated " + numUpdatedPartitions.getRef() + " partition(s).";
                        break;
                    }
                    responseSummaryMsg = "Updated table.";
                    break;
                }
                case SET_VIEW_PROPERTIES: {
                    this.alterViewSetTblProperties(tbl, params.getSet_tbl_properties_params(), catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Updated view.";
                    break;
                }
                case UNSET_VIEW_PROPERTIES: {
                    this.alterViewUnSetTblProperties(tbl, params.getUnset_tbl_properties_params(), catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Updated view.";
                    break;
                }
                case UPDATE_STATS: {
                    Preconditions.checkState((boolean)params.isSetUpdate_stats_params());
                    Reference<Long> numUpdatedColumns = new Reference<Long>(0L);
                    this.alterTableUpdateStats(tbl, params.getUpdate_stats_params(), numUpdatedPartitions, numUpdatedColumns, debugAction, catalogTimeline, modification);
                    reloadTableSchema = true;
                    responseSummaryMsg = "Updated " + numUpdatedPartitions.getRef() + " partition(s) and " + numUpdatedColumns.getRef() + " column(s).";
                    break;
                }
                case SET_CACHED: {
                    String op;
                    Preconditions.checkState((boolean)params.isSetSet_cached_params());
                    String string = op = params.getSet_cached_params().getCache_op().isSet_cached() ? "Cached " : "Uncached ";
                    if (params.getSet_cached_params().getPartition_set() == null) {
                        reloadFileMetadata = this.alterTableSetCached(tbl, params.getSet_cached_params(), catalogTimeline, modification);
                        responseSummaryMsg = op + "table.";
                        break;
                    }
                    this.alterPartitionSetCached(tbl, params.getSet_cached_params(), numUpdatedPartitions, catalogTimeline, modification);
                    responseSummaryMsg = op + numUpdatedPartitions.getRef() + " partition(s).";
                    break;
                }
                case RECOVER_PARTITIONS: {
                    this.alterTableRecoverPartitions(tbl, debugAction, catalogTimeline, modification);
                    responseSummaryMsg = "Partitions have been recovered.";
                    break;
                }
                case SET_OWNER: {
                    Preconditions.checkState((boolean)params.isSetSet_owner_params());
                    this.alterTableOrViewSetOwner(tbl, params.getSet_owner_params(), response, catalogTimeline, modification);
                    responseSummaryMsg = "Updated table/view.";
                    break;
                }
                case EXECUTE: 
                case SET_PARTITION_SPEC: {
                    Preconditions.checkState((boolean)(tbl instanceof IcebergTable));
                    this.updateHmsAfterIcebergOnlyModification((IcebergTable)tbl, catalogTimeline, modification);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown ALTER TABLE operation type: " + (Object)((Object)params.getAlter_type()));
                }
            }
            if (modification.isInProgress()) {
                Preconditions.checkState((boolean)reloadMetadata, (String)"In-progress modification of table %s must be followed by metadata reload.", (Object)tbl.getFullName());
            }
            if (reloadMetadata) {
                this.loadTableMetadata(tbl, modification.newVersionNumber(), reloadFileMetadata, reloadTableSchema, "ALTER TABLE " + params.getAlter_type().name(), debugAction, catalogTimeline);
                modification.markInflightEventRegistrationComplete();
            }
            CatalogOpExecutor.addSummary(response, responseSummaryMsg);
            if (tbl.getCatalogVersion() != oldCatalogVersion) {
                CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, response.result);
            }
            modification.validateInProgressModificationComplete();
        }
        catch (Exception ex) {
            modification.cancelInflightEventIfExist();
            throw ex;
        }
        finally {
            context.stop();
            this.UnlockWriteLockIfErronouslyLocked();
            tbl.resetInProgressModification();
            tbl.releaseWriteLock();
        }
    }

    private boolean altersKuduTable(TAlterTableType type) {
        return type == TAlterTableType.ADD_COLUMNS || type == TAlterTableType.REPLACE_COLUMNS || type == TAlterTableType.DROP_COLUMN || type == TAlterTableType.ALTER_COLUMN || type == TAlterTableType.ADD_DROP_RANGE_PARTITION;
    }

    private void alterKuduTable(TAlterTableParams params, TDdlExecResponse response, KuduTable tbl, InProgressTableModification modification, boolean wantMinimalResult, EventSequence catalogTimeline, @Nullable String debugAction) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        switch (params.getAlter_type()) {
            case ADD_COLUMNS: {
                if (params.getAdd_cols_params() != null && params.getAdd_cols_params().getColumnsSize() != 0) {
                    TAlterTableAddColsParams addColParams = params.getAdd_cols_params();
                    KuduCatalogOpExecutor.addColumn(tbl, addColParams.getColumns(), catalogTimeline);
                    CatalogOpExecutor.addSummary(response, "Column(s) have been added.");
                    break;
                }
                CatalogOpExecutor.addSummary(response, "No new column(s) have been added to the table.");
                break;
            }
            case REPLACE_COLUMNS: {
                TAlterTableReplaceColsParams replaceColParams = params.getReplace_cols_params();
                KuduCatalogOpExecutor.addColumn(tbl, replaceColParams.getColumns(), catalogTimeline);
                CatalogOpExecutor.addSummary(response, "Column(s) have been replaced.");
                break;
            }
            case DROP_COLUMN: {
                TAlterTableDropColParams dropColParams = params.getDrop_col_params();
                KuduCatalogOpExecutor.dropColumn(tbl, dropColParams.getCol_name(), catalogTimeline);
                CatalogOpExecutor.addSummary(response, "Column has been dropped.");
                break;
            }
            case ALTER_COLUMN: {
                TAlterTableAlterColParams alterColParams = params.getAlter_col_params();
                KuduCatalogOpExecutor.alterColumn(tbl, alterColParams.getCol_name(), alterColParams.getNew_col_def(), catalogTimeline);
                CatalogOpExecutor.addSummary(response, "Column has been altered.");
                break;
            }
            case ADD_DROP_RANGE_PARTITION: {
                TAlterTableAddDropRangePartitionParams partParams = params.getAdd_drop_range_partition_params();
                KuduCatalogOpExecutor.addDropRangePartition(tbl, partParams, catalogTimeline);
                CatalogOpExecutor.addSummary(response, "Range partition has been " + (partParams.type == TRangePartitionOperationType.ADD ? "added." : "dropped."));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported ALTER TABLE operation for Kudu tables: " + (Object)((Object)params.getAlter_type()));
            }
        }
        this.loadTableMetadata(tbl, modification.newVersionNumber(), true, true, "ALTER KUDU TABLE " + params.getAlter_type().name(), debugAction, catalogTimeline);
        CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, response.result);
    }

    private boolean altersIcebergTable(TAlterTableType type) {
        return type == TAlterTableType.ADD_COLUMNS || type == TAlterTableType.REPLACE_COLUMNS || type == TAlterTableType.EXECUTE || type == TAlterTableType.DROP_COLUMN || type == TAlterTableType.ALTER_COLUMN || type == TAlterTableType.SET_PARTITION_SPEC || type == TAlterTableType.SET_TBL_PROPERTIES || type == TAlterTableType.UNSET_TBL_PROPERTIES || type == TAlterTableType.DROP_PARTITION;
    }

    private boolean alterIcebergTable(TAlterTableParams params, TDdlExecResponse response, IcebergTable tbl, boolean wantMinimalResult, @Nullable String debugAction, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        if (params.getAlter_type() == TAlterTableType.EXECUTE) {
            Preconditions.checkState((boolean)params.isSetSet_execute_params());
            TAlterTableExecuteParams setExecuteParams = params.getSet_execute_params();
            if (setExecuteParams.isSetRemove_orphan_files_params()) {
                String removeOrphanSummary = IcebergCatalogOpExecutor.alterTableExecuteRemoveOrphanFiles(tbl, setExecuteParams.getRemove_orphan_files_params(), this.icebergExecutorService_);
                CatalogOpExecutor.addSummary(response, removeOrphanSummary);
                return false;
            }
        }
        boolean needsToUpdateHms = !IcebergUtil.isHiveCatalog(tbl.getMetaStoreTable());
        try {
            org.apache.iceberg.Transaction iceTxn = IcebergUtil.getIcebergTransaction(tbl);
            catalogTimeline.markEvent("Got Iceberg transaction");
            switch (params.getAlter_type()) {
                case ADD_COLUMNS: {
                    if (params.getAdd_cols_params() != null && params.getAdd_cols_params().getColumnsSize() != 0) {
                        TAlterTableAddColsParams addColParams = params.getAdd_cols_params();
                        IcebergCatalogOpExecutor.addColumns(iceTxn, addColParams.getColumns());
                        CatalogOpExecutor.addSummary(response, "Column(s) have been added.");
                        break;
                    }
                    CatalogOpExecutor.addSummary(response, "No new column(s) have been added to the table.");
                    break;
                }
                case DROP_COLUMN: {
                    TAlterTableDropColParams dropColParams = params.getDrop_col_params();
                    IcebergCatalogOpExecutor.dropColumn(iceTxn, dropColParams.getCol_name());
                    CatalogOpExecutor.addSummary(response, "Column has been dropped.");
                    break;
                }
                case ALTER_COLUMN: {
                    TAlterTableAlterColParams alterColParams = params.getAlter_col_params();
                    IcebergCatalogOpExecutor.alterColumn(iceTxn, alterColParams.getCol_name(), alterColParams.getNew_col_def());
                    CatalogOpExecutor.addSummary(response, "Column has been altered.");
                    break;
                }
                case EXECUTE: {
                    Preconditions.checkState((boolean)params.isSetSet_execute_params());
                    TAlterTableExecuteParams setExecuteParams = params.getSet_execute_params();
                    if (setExecuteParams.isSetExecute_rollback_params()) {
                        String rollbackSummary = IcebergCatalogOpExecutor.alterTableExecuteRollback(iceTxn, tbl, setExecuteParams.getExecute_rollback_params());
                        CatalogOpExecutor.addSummary(response, rollbackSummary);
                        break;
                    }
                    if (setExecuteParams.isSetExpire_snapshots_params()) {
                        String expireSummary = IcebergCatalogOpExecutor.alterTableExecuteExpireSnapshots(iceTxn, setExecuteParams.getExpire_snapshots_params(), this.icebergExecutorService_);
                        CatalogOpExecutor.addSummary(response, expireSummary);
                        break;
                    }
                    if (setExecuteParams.isSetRemove_orphan_files_params()) {
                        throw new IllegalStateException("Alter table execute REMOVE_ORPHAN_FILES should not use Iceberg Transaction.");
                    }
                    throw new IllegalStateException("Alter table execute statement is not implemented.");
                }
                case SET_PARTITION_SPEC: {
                    TAlterTableSetPartitionSpecParams setPartSpecParams = params.getSet_partition_spec_params();
                    IcebergCatalogOpExecutor.alterTableSetPartitionSpec(tbl, setPartSpecParams.getPartition_spec(), iceTxn);
                    CatalogOpExecutor.addSummary(response, "Updated partition spec.");
                    break;
                }
                case SET_TBL_PROPERTIES: {
                    needsToUpdateHms |= !this.setIcebergTblProperties(tbl, params, iceTxn);
                    CatalogOpExecutor.addSummary(response, "Updated table.");
                    break;
                }
                case UNSET_TBL_PROPERTIES: {
                    needsToUpdateHms |= !this.unsetIcebergTblProperties(tbl, params, iceTxn);
                    CatalogOpExecutor.addSummary(response, "Updated table.");
                    break;
                }
                case DROP_PARTITION: {
                    long droppedPartitions = IcebergCatalogOpExecutor.alterTableDropPartition(iceTxn, params.getDrop_partition_params());
                    CatalogOpExecutor.addSummary(response, String.format("Dropped %d partition(s)", droppedPartitions));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported ALTER TABLE operation for Iceberg tables: " + (Object)((Object)params.getAlter_type()));
                }
            }
            catalogTimeline.markEvent("Iceberg operations are prepared for commit");
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            IcebergCatalogOpExecutor.setTblProperties(iceTxn, property);
            if (!needsToUpdateHms) {
                modification.registerInflightEvent();
                IcebergCatalogOpExecutor.addCatalogVersionToTxn(iceTxn, this.catalog_.getCatalogServiceId(), modification.newVersionNumber());
            }
            if (debugAction != null) {
                DebugUtils.executeDebugAction(debugAction, "catalogd_iceberg_commit");
            }
            iceTxn.commitTransaction();
            catalogTimeline.markEvent("Committed Iceberg transaction");
            if (!needsToUpdateHms) {
                modification.markInflightEventRegistrationComplete();
            }
        }
        catch (IllegalArgumentException | ValidationException ex) {
            modification.cancelInflightEventIfExist();
            throw new ImpalaRuntimeException(String.format("Failed to ALTER table '%s': %s", params.getTable_name().table_name, ex.getMessage()));
        }
        if (!needsToUpdateHms) {
            this.loadTableMetadata(tbl, modification.newVersionNumber(), true, true, "ALTER Iceberg TABLE " + params.getAlter_type().name(), debugAction, catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, response.result);
        }
        return needsToUpdateHms;
    }

    private boolean setIcebergTblProperties(IcebergTable tbl, TAlterTableParams params, org.apache.iceberg.Transaction iceTxn) throws ImpalaException {
        TAlterTableSetTblPropertiesParams setPropsParams = params.getSet_tbl_properties_params();
        if (setPropsParams.getTarget() != TTablePropertyType.TBL_PROPERTY) {
            return false;
        }
        this.addMergeOnReadPropertiesIfNeeded(tbl, setPropsParams.getProperties());
        IcebergCatalogOpExecutor.setTblProperties(iceTxn, setPropsParams.getProperties());
        return true;
    }

    private void addMergeOnReadPropertiesIfNeeded(IcebergTable tbl, Map<String, String> properties) {
        String formatVersion = properties.get("format-version");
        if (formatVersion == null || Integer.valueOf(formatVersion) < 2) {
            return;
        }
        if (!IcebergUtil.isAnyWriteModeSet(properties) && !IcebergUtil.isAnyWriteModeSet(tbl.getMetaStoreTable().getParameters())) {
            String MERGE_ON_READ = "merge-on-read";
            properties.put("write.delete.mode", "merge-on-read");
            properties.put("write.update.mode", "merge-on-read");
            properties.put("write.merge.mode", "merge-on-read");
        }
    }

    private boolean unsetIcebergTblProperties(IcebergTable tbl, TAlterTableParams params, org.apache.iceberg.Transaction iceTxn) throws ImpalaException {
        TAlterTableUnSetTblPropertiesParams unsetParams = params.getUnset_tbl_properties_params();
        if (unsetParams.getTarget() != TTablePropertyType.TBL_PROPERTY) {
            return false;
        }
        IcebergCatalogOpExecutor.unsetTblProperties(iceTxn, unsetParams.getProperty_keys());
        return true;
    }

    private void updateHmsAfterIcebergOnlyModification(IcebergTable tbl, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaRuntimeException {
        Preconditions.checkState((!IcebergUtil.isHiveCatalog(tbl.getMetaStoreTable()) ? 1 : 0) != 0);
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void loadTableMetadata(org.apache.impala.catalog.Table tbl, long newCatalogVersion, boolean reloadFileMetadata, boolean reloadTableSchema, String reason, @Nullable String debugAction, EventSequence catalogTimeline) throws CatalogException {
        this.loadTableMetadata(tbl, newCatalogVersion, reloadFileMetadata, reloadTableSchema, null, null, reason, debugAction, catalogTimeline);
    }

    private void loadTableMetadata(org.apache.impala.catalog.Table tbl, long newCatalogVersion, boolean reloadFileMetadata, boolean reloadTableSchema, @Nullable Set<String> partitionsToUpdate, @Nullable Map<String, Long> partitionToEventId, String reason, @Nullable String debugAction, EventSequence catalogTimeline) throws CatalogException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        long eventId = -1L;
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            org.apache.hadoop.hive.metastore.api.Table msTbl = this.getMetaStoreTable(msClient, tbl);
            catalogTimeline.markEvent(FETCHED_HMS_TABLE);
            if (debugAction != null) {
                DebugUtils.executeDebugAction(debugAction, "catalogd_load_metadata_delay");
            }
            if (msTbl.getPartitionKeysSize() == 0) {
                eventId = MetastoreEventsProcessor.getCurrentEventIdNoThrow(msClient.getHiveClient());
                catalogTimeline.markEvent(FETCHED_LATEST_HMS_EVENT_ID + eventId);
            }
            if (tbl instanceof HdfsTable) {
                ((HdfsTable)tbl).load(true, msClient.getHiveClient(), msTbl, reloadFileMetadata, reloadTableSchema, false, partitionsToUpdate, debugAction, partitionToEventId, reason, catalogTimeline);
            } else {
                tbl.load(true, msClient.getHiveClient(), msTbl, reason, catalogTimeline);
            }
            if (msTbl.getPartitionKeysSize() == 0 && eventId > tbl.getLastRefreshEventId() && reloadFileMetadata && reloadTableSchema) {
                tbl.setLastRefreshEventId(eventId);
            }
            catalogTimeline.markEvent("Reloaded table metadata");
        }
        tbl.setCatalogVersion(newCatalogVersion);
    }

    private static void addTableToCatalogUpdate(org.apache.impala.catalog.Table tbl, boolean wantMinimalResult, TCatalogUpdateResult result) {
        Preconditions.checkNotNull((Object)tbl);
        TCatalogObject updatedCatalogObject = wantMinimalResult ? tbl.toInvalidationObject() : tbl.toTCatalogObject();
        result.addToUpdated_catalog_objects(updatedCatalogObject);
        result.setVersion(updatedCatalogObject.getCatalog_version());
    }

    private org.apache.impala.catalog.Table addHdfsPartitions(MetaStoreClientPool.MetaStoreClient msClient, org.apache.impala.catalog.Table tbl, List<Partition> addedPartitions, Map<String, Long> partitionToEventId, EventSequence catalogTimeline) throws CatalogException {
        Preconditions.checkNotNull((Object)tbl);
        Preconditions.checkNotNull(addedPartitions);
        if (!(tbl instanceof HdfsTable)) {
            throw new CatalogException("Table " + tbl.getFullName() + " is not an HDFS table");
        }
        HdfsTable hdfsTable = (HdfsTable)tbl;
        List<HdfsPartition> hdfsPartitions = hdfsTable.createAndLoadPartitions(msClient.getHiveClient(), addedPartitions, partitionToEventId, catalogTimeline);
        for (HdfsPartition hdfsPartition : hdfsPartitions) {
            this.catalog_.addPartition(hdfsPartition);
        }
        return hdfsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterView(TCreateOrAlterViewParams params, boolean wantMinimalResult, TDdlExecResponse resp, EventSequence catalogTimeline) throws ImpalaException {
        TableName tableName = TableName.fromThrift(params.getView_name());
        Preconditions.checkState((tableName != null && tableName.isFullyQualified() ? 1 : 0) != 0);
        Preconditions.checkState((params.getColumns() != null && params.getColumns().size() > 0 ? 1 : 0) != 0, (Object)"Null or empty column list given as argument to DdlExecutor.alterView");
        org.apache.impala.catalog.Table tbl = this.getExistingTable(tableName.getDb(), tableName.getTbl(), "Load for ALTER VIEW", catalogTimeline);
        Preconditions.checkState((boolean)(tbl instanceof View), (String)"Expected view: %s", (Object)tableName);
        this.tryWriteLock(tbl, catalogTimeline);
        try {
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, tbl);
            this.catalog_.getLock().writeLock().unlock();
            modification.addCatalogServiceIdentifiersToTable();
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            if (!msTbl.getTableType().equalsIgnoreCase(TableType.VIRTUAL_VIEW.toString())) {
                throw new ImpalaRuntimeException(String.format("ALTER VIEW not allowed on a table: %s", tableName.toString()));
            }
            this.setAlterViewAttributes(params, msTbl);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Altering view %s", tableName));
            }
            this.applyAlterTable(msTbl, true, null, catalogTimeline);
            long eventId = -1L;
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                eventId = MetastoreEventsProcessor.getCurrentEventIdNoThrow(msClient.getHiveClient());
                tbl.load(true, msClient.getHiveClient(), msTbl, "ALTER VIEW", catalogTimeline);
            }
            CatalogOpExecutor.addSummary(resp, "View has been altered.");
            modification.updateTableCatalogVersion();
            if (eventId > tbl.getLastRefreshEventId()) {
                tbl.setLastRefreshEventId(eventId);
            }
            CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, resp.result);
            modification.validateInProgressModificationComplete();
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    private void addCatalogServiceIdentifiers(org.apache.hadoop.hive.metastore.api.Table msTbl, String catalogServiceId, long catalogVersion) {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return;
        }
        msTbl.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), catalogServiceId);
        msTbl.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), String.valueOf(catalogVersion));
    }

    private void alterTableUpdateStats(org.apache.impala.catalog.Table table, TAlterTableUpdateStatsParams params, Reference<Long> numUpdatedPartitions, Reference<Long> numUpdatedColumns, @Nullable String debugAction, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)table.isWriteLockedByCurrentThread());
        Preconditions.checkState((params.isSetTable_stats() || params.isSetColumn_stats() ? 1 : 0) != 0);
        TableName tableName = table.getTableName();
        Preconditions.checkState((tableName != null && tableName.isFullyQualified() ? 1 : 0) != 0);
        if (LOG.isInfoEnabled()) {
            int numPartitions = params.isSetPartition_stats() ? params.partition_stats.size() : 0;
            int numColumns = params.isSetColumn_stats() ? params.column_stats.size() : 0;
            LOG.info(String.format("Updating stats for table %s: table-stats=%s partitions=%d column-stats=%d", tableName, params.isSetTable_stats(), numPartitions, numColumns));
        }
        org.apache.hadoop.hive.metastore.api.Table msTbl = table.getMetaStoreTable().deepCopy();
        AcidUtils.TblTransaction tblTxn = null;
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            modification.registerInflightEvent();
            try {
                if (AcidUtils.isTransactionalTable(msTbl.getParameters())) {
                    tblTxn = MetastoreShim.createTblTransaction(msClient.getHiveClient(), msTbl, -1L);
                    catalogTimeline.markEvent("Opened new transaction");
                }
                this.alterTableUpdateStatsInner(table, msTbl, params, numUpdatedPartitions, numUpdatedColumns, msClient, tblTxn, catalogTimeline);
                if (tblTxn != null) {
                    MetastoreShim.commitTblTransactionIfNeeded(msClient.getHiveClient(), tblTxn);
                    catalogTimeline.markEvent("Committed transaction");
                }
            }
            catch (Exception ex) {
                modification.cancelInflightEventIfExist();
                if (tblTxn != null) {
                    MetastoreShim.abortTblTransactionIfNeeded(msClient.getHiveClient(), tblTxn);
                    catalogTimeline.markEvent("Aborted transaction");
                }
                throw ex;
            }
            modification.markInflightEventRegistrationComplete();
        }
        DebugUtils.executeDebugAction(debugAction, "catalogd_update_stats_delay");
    }

    private void alterTableUpdateStatsInner(org.apache.impala.catalog.Table table, org.apache.hadoop.hive.metastore.api.Table msTbl, TAlterTableUpdateStatsParams params, Reference<Long> numUpdatedPartitions, Reference<Long> numUpdatedColumns, MetaStoreClientPool.MetaStoreClient msClient, AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline) throws ImpalaException {
        numUpdatedColumns.setRef(0L);
        if (params.isSetColumn_stats()) {
            ColumnStatistics colStats = CatalogOpExecutor.createHiveColStats(params, table);
            if (colStats.getStatsObjSize() > 0) {
                if (tblTxn != null) {
                    MetastoreShim.setTableColumnStatsTransactional(msClient.getHiveClient(), msTbl, colStats, tblTxn);
                } else {
                    try {
                        msClient.getHiveClient().updateTableColumnStatistics(colStats);
                    }
                    catch (Exception e) {
                        throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "updateTableColumnStatistics"), e);
                    }
                }
                catalogTimeline.markEvent("Updated column stats");
            }
            numUpdatedColumns.setRef(Long.valueOf(colStats.getStatsObjSize()));
        }
        List<HdfsPartition.Builder> modifiedParts = null;
        if (params.isSetPartition_stats() && table.getNumClusteringCols() > 0) {
            Preconditions.checkState((boolean)(table instanceof HdfsTable));
            modifiedParts = this.updatePartitionStats(params, (HdfsTable)table);
            this.bulkAlterPartitions(table, modifiedParts, tblTxn, UpdatePartitionMethod.MARK_DIRTY, catalogTimeline);
        }
        if (params.isSetTable_stats()) {
            this.updateTableStats(params, msTbl);
            org.apache.impala.catalog.Table.updateTimestampProperty(msTbl, "impala.lastComputeStatsTime");
            if (IcebergTable.isIcebergTable(msTbl)) {
                ((IcebergTable)table).updateComputeStatsIcebergSnapshotsProperty(msTbl, params);
            }
        }
        if (IcebergTable.isIcebergTable(msTbl) && this.isIcebergHmsIntegrationEnabled(msTbl)) {
            this.updateTableStatsViaIceberg((IcebergTable)table, msTbl);
            catalogTimeline.markEvent("Updated table stats via Iceberg");
        } else {
            msTbl.getParameters().remove("COLUMN_STATS_ACCURATE");
            this.applyAlterTable(msTbl, false, tblTxn, catalogTimeline);
        }
        numUpdatedPartitions.setRef(0L);
        if (modifiedParts != null) {
            numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
        } else if (params.isSetTable_stats()) {
            numUpdatedPartitions.setRef(1L);
        }
    }

    private void updateTableStatsViaIceberg(IcebergTable iceTbl, org.apache.hadoop.hive.metastore.api.Table msTbl) throws ImpalaException {
        String CATALOG_SERVICE_ID = MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey();
        String CATALOG_VERSION = MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey();
        String COMPUTE_STATS_TIME = "impala.lastComputeStatsTime";
        String COMPUTE_STATS_SNAPSHOT_IDS = "impala.computeStatsSnapshotIds";
        Preconditions.checkState((boolean)msTbl.getParameters().containsKey(CATALOG_SERVICE_ID));
        Preconditions.checkState((boolean)msTbl.getParameters().containsKey(CATALOG_VERSION));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(CATALOG_SERVICE_ID, (String)msTbl.getParameters().get(CATALOG_SERVICE_ID));
        props.put(CATALOG_VERSION, (String)msTbl.getParameters().get(CATALOG_VERSION));
        if (msTbl.getParameters().containsKey(COMPUTE_STATS_TIME)) {
            props.put(COMPUTE_STATS_TIME, (String)msTbl.getParameters().get(COMPUTE_STATS_TIME));
        }
        if (msTbl.getParameters().containsKey(COMPUTE_STATS_SNAPSHOT_IDS)) {
            props.put(COMPUTE_STATS_SNAPSHOT_IDS, (String)msTbl.getParameters().get(COMPUTE_STATS_SNAPSHOT_IDS));
        }
        org.apache.iceberg.Transaction iceTxn = IcebergUtil.getIcebergTransaction(iceTbl);
        IcebergCatalogOpExecutor.setTblProperties(iceTxn, props);
        iceTxn.commitTransaction();
    }

    private List<HdfsPartition.Builder> updatePartitionStats(TAlterTableUpdateStatsParams params, HdfsTable table) throws ImpalaException {
        Preconditions.checkState((boolean)params.isSetPartition_stats());
        ArrayList modifiedParts = Lists.newArrayList();
        Collection<? extends FeFsPartition> parts = table.loadAllPartitions();
        for (FeFsPartition feFsPartition : parts) {
            HdfsPartition partition = (HdfsPartition)feFsPartition;
            List<String> partitionValues = partition.getPartitionValuesAsStrings(false);
            TPartitionStats partitionStats = params.partition_stats.get(partitionValues);
            if (partitionStats == null) {
                if (!params.expect_all_partitions) continue;
                partitionStats = new TPartitionStats();
                if (params.is_incremental) {
                    partitionStats.intermediate_col_stats = Maps.newHashMap();
                }
                partitionStats.stats = new TTableStats();
                partitionStats.stats.setNum_rows(0L);
            }
            boolean updatedPartition = false;
            TPartitionStats existingPartStats = partition.getPartitionStats();
            if (existingPartStats == null || !existingPartStats.equals(partitionStats)) {
                updatedPartition = true;
            }
            long numRows = partitionStats.stats.num_rows;
            String existingRowCount = partition.getParameters().get("numRows");
            if (existingRowCount == null || !existingRowCount.equals(String.valueOf(numRows))) {
                updatedPartition = true;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} stats for partition {}: numRows={}", new Object[]{updatedPartition ? "Updating" : "Skip updating", partition.getValuesAsString(), numRows});
            }
            if (!updatedPartition) continue;
            HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
            PartitionStatsUtil.partStatsToPartition(partitionStats, partBuilder);
            partBuilder.setRowCountParam(numRows);
            partBuilder.putToParameters(MetastoreShim.statsGeneratedViaStatsTaskParam());
            partBuilder.getParameters().remove("COLUMN_STATS_ACCURATE");
            modifiedParts.add(partBuilder);
        }
        return modifiedParts;
    }

    private void updateTableStats(TAlterTableUpdateStatsParams params, org.apache.hadoop.hive.metastore.api.Table msTbl) throws ImpalaException {
        Preconditions.checkState((boolean)params.isSetTable_stats());
        long numRows = params.table_stats.num_rows;
        msTbl.putToParameters("numRows", String.valueOf(numRows));
        if (params.getTable_stats().isSetTotal_file_bytes()) {
            msTbl.putToParameters("totalSize", String.valueOf(params.getTable_stats().total_file_bytes));
        }
        Pair<String, String> statsTaskParam = MetastoreShim.statsGeneratedViaStatsTaskParam();
        msTbl.putToParameters((String)statsTaskParam.first, (String)statsTaskParam.second);
    }

    private static ColumnStatistics createHiveColStats(TAlterTableUpdateStatsParams params, org.apache.impala.catalog.Table table) {
        Preconditions.checkState((boolean)params.isSetColumn_stats());
        ColumnStatistics colStats = MetastoreShim.createNewHiveColStats();
        colStats.setStatsDesc(new ColumnStatisticsDesc(true, table.getDb().getName(), table.getName()));
        for (Map.Entry<String, TColumnStats> entry : params.getColumn_stats().entrySet()) {
            long ndvCap;
            ColumnStatisticsData colStatsData;
            String colName = entry.getKey();
            Column tableCol = table.getColumn(entry.getKey());
            if (tableCol == null || (colStatsData = ColumnStats.createHiveColStatsData(ndvCap = params.isSetTable_stats() ? params.table_stats.num_rows : -1L, entry.getValue(), tableCol.getType())) == null) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Updating column stats for %s: numDVs=%d numNulls=%d maxSize=%d avgSize=%.2f minValue=%s maxValue=%s", colName, entry.getValue().getNum_distinct_values(), entry.getValue().getNum_nulls(), entry.getValue().getMax_size(), entry.getValue().getAvg_size(), entry.getValue().getLow_value() != null ? entry.getValue().getLow_value().toString() : Integer.valueOf(-1), entry.getValue().getHigh_value() != null ? entry.getValue().getHigh_value().toString() : Integer.valueOf(-1)));
            }
            ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj(colName, tableCol.getType().toString().toLowerCase(), colStatsData);
            colStats.addToStatsObj(colStatsObj);
        }
        return colStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabase(TCreateDbParams params, TDdlExecResponse resp, EventSequence catalogTimeline, boolean syncDdl, boolean wantMinimalResult) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        String dbName = params.getDb();
        Preconditions.checkState((dbName != null && !dbName.isEmpty() ? 1 : 0) != 0, (Object)"Null or empty database name passed as argument to Catalog.createDatabase");
        Preconditions.checkState((!this.catalog_.isBlacklistedDb(dbName) ? 1 : 0) != 0, (Object)String.format("Can't create blacklisted database: %s. %s", dbName, BLACKLISTED_DBS_INCONSISTENT_ERR_STR));
        Db existingDb = this.catalog_.getDb(dbName);
        if (params.if_not_exists && existingDb != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping database creation because " + dbName + " already exists and IF NOT EXISTS was specified.");
            }
            Preconditions.checkNotNull((Object)existingDb);
            if (syncDdl) {
                this.tryLock(existingDb, "create database", catalogTimeline);
                try {
                    long newVersion = this.catalog_.incrementAndGetCatalogVersion();
                    existingDb.setCatalogVersion(newVersion);
                    LOG.trace("Database {} version bumped to {} because SYNC_DDL is enabled.", (Object)dbName, (Object)newVersion);
                }
                finally {
                    this.catalog_.getLock().writeLock().unlock();
                    existingDb.getLock().unlock();
                }
            }
            this.addDbToCatalogUpdate(existingDb, wantMinimalResult, resp.result);
            CatalogOpExecutor.addSummary(resp, "Database already exists.");
            return;
        }
        Database db = new Database();
        db.setName(dbName);
        if (params.getComment() != null) {
            db.setDescription(params.getComment());
        }
        if (params.getLocation() != null) {
            db.setLocationUri(params.getLocation());
        }
        if (params.getManaged_location() != null) {
            MetastoreShim.setManagedLocationUri(db, params.getManaged_location());
        }
        db.setOwnerName(params.getOwner());
        db.setOwnerType(PrincipalType.USER);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating database " + dbName);
        }
        Db newDb = null;
        this.acquireMetastoreDdlLock(catalogTimeline);
        try {
            block36: {
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    try {
                        long eventId = this.getCurrentEventId(msClient, catalogTimeline);
                        msClient.getHiveClient().createDatabase(db);
                        catalogTimeline.markEvent("Created database in Metastore");
                        List<NotificationEvent> events = this.getNextMetastoreEventsForDbIfEnabled(catalogTimeline, eventId, dbName, "CREATE_DATABASE");
                        Pair<Long, Database> eventDbPair = this.getDatabaseFromEvents(events, params.if_not_exists);
                        if (eventDbPair == null) {
                            eventDbPair = new Pair<Long, Database>(-1L, msClient.getHiveClient().getDatabase(dbName));
                        } else {
                            eventDbPair.second = msClient.getHiveClient().getDatabase(dbName);
                        }
                        newDb = this.catalog_.addDb(dbName, (Database)eventDbPair.second, (Long)eventDbPair.first);
                        catalogTimeline.markEvent("Created database in catalog cache");
                        CatalogOpExecutor.addSummary(resp, "Database has been created.");
                    }
                    catch (AlreadyExistsException e) {
                        if (!params.if_not_exists) {
                            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createDatabase"), e);
                        }
                        CatalogOpExecutor.addSummary(resp, "Database already exists.");
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(String.format("Ignoring '%s' when creating database %s because IF NOT EXISTS was specified.", new Object[]{e, dbName}));
                        }
                        if ((newDb = this.catalog_.getDb(dbName)) != null) break block36;
                        try {
                            Database msDb = msClient.getHiveClient().getDatabase(dbName);
                            catalogTimeline.markEvent(FETCHED_HMS_DB);
                            newDb = this.catalog_.addDb(dbName, msDb);
                            catalogTimeline.markEvent("Created database in catalog cache");
                        }
                        catch (TException e1) {
                            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createDatabase"), e1);
                        }
                    }
                    catch (TException e) {
                        throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createDatabase"), e);
                    }
                }
            }
            this.addDbToCatalogUpdate(newDb, wantMinimalResult, resp.result);
            if (this.authzConfig_.isEnabled()) {
                this.authzManager_.updateDatabaseOwnerPrivilege(params.server_name, newDb.getName(), null, null, newDb.getMetaStoreDb().getOwnerName(), newDb.getMetaStoreDb().getOwnerType(), resp);
            }
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
    }

    private List<NotificationEvent> getNextMetastoreEventsForTableIfEnabled(EventSequence catalogTimeline, long eventId, String dbName, String tblName, String eventType) throws MetastoreNotificationException {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return Collections.emptyList();
        }
        List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForTable(this.catalog_, eventId, dbName, tblName, eventType);
        catalogTimeline.markEvent(FETCHED_HMS_EVENT_BATCH);
        return events;
    }

    private List<NotificationEvent> getNextMetastoreEventsForDbIfEnabled(EventSequence catalogTimeline, long eventId, String dbName, String eventType) throws MetastoreNotificationException {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return Collections.emptyList();
        }
        List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForDb(this.catalog_, eventId, dbName, eventType);
        catalogTimeline.markEvent(FETCHED_HMS_EVENT_BATCH);
        return events;
    }

    private List<NotificationEvent> getNextMetastoreDropEventsForDbIfEnabled(EventSequence catalogTimeline, long eventId, String dbName) throws MetastoreNotificationException {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return Collections.emptyList();
        }
        ArrayList eventTypes = Lists.newArrayList((Object[])new String[]{"DROP_DATABASE", "DROP_TABLE"});
        IMetaStoreClient.NotificationFilter filter = e -> dbName.equalsIgnoreCase(e.getDbName()) && MetastoreShim.isDefaultCatalog(e.getCatName()) && eventTypes.contains(e.getEventType());
        List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatches(this.catalog_, eventId, filter, "DROP_DATABASE", "DROP_TABLE");
        catalogTimeline.markEvent(FETCHED_HMS_EVENT_BATCH);
        return events;
    }

    private Pair<Long, Database> getDatabaseFromEvents(List<NotificationEvent> events, boolean useLatestEvent) throws CatalogException {
        if (events == null || events.isEmpty()) {
            return null;
        }
        Preconditions.checkState((useLatestEvent || events.size() == 1 ? 1 : 0) != 0, (Object)"Database was recreated in metastore while createDatabase operation was in progress");
        try {
            MetastoreEvents.MetastoreEvent event = this.catalog_.getMetastoreEventProcessor().getEventsFactory().get(events.get(events.size() - 1), null);
            Preconditions.checkState((boolean)(event instanceof MetastoreEvents.CreateDatabaseEvent), (String)"Expects CreateDatabaseEvent but got %s. All events: %s", (Object)event, events);
            return new Pair<Long, Database>(events.get(0).getEventId(), ((MetastoreEvents.CreateDatabaseEvent)event).getDatabase());
        }
        catch (MetastoreNotificationException e) {
            throw new CatalogException("Unable to create a metastore event ", e);
        }
    }

    private Pair<Long, org.apache.hadoop.hive.metastore.api.Table> getTableFromEvents(List<NotificationEvent> events, boolean useLatestEvent) throws CatalogException {
        if (events == null || events.isEmpty()) {
            return null;
        }
        Preconditions.checkState((useLatestEvent || events.size() == 1 ? 1 : 0) != 0, (Object)"Table was recreated in metastore while createTable operation was in progress.");
        try {
            MetastoreEvents.MetastoreEvent event = this.catalog_.getMetastoreEventProcessor().getEventsFactory().get(events.get(events.size() - 1), null);
            Preconditions.checkState((boolean)(event instanceof MetastoreEvents.CreateTableEvent));
            return new Pair<Long, org.apache.hadoop.hive.metastore.api.Table>(events.get(0).getEventId(), ((MetastoreEvents.CreateTableEvent)event).getTable());
        }
        catch (MetastoreNotificationException e) {
            throw new CatalogException("Unable to create a metastore event", e);
        }
    }

    private Pair<Long, Pair<org.apache.hadoop.hive.metastore.api.Table, org.apache.hadoop.hive.metastore.api.Table>> getRenamedTableFromEvents(List<NotificationEvent> events) throws CatalogException {
        if (events == null || events.isEmpty()) {
            return null;
        }
        for (NotificationEvent notificationEvent : events) {
            try {
                MetastoreEvents.MetastoreEvent event = this.catalog_.getMetastoreEventProcessor().getEventsFactory().get(notificationEvent, null);
                Preconditions.checkState((boolean)(event instanceof MetastoreEvents.AlterTableEvent));
                MetastoreEvents.AlterTableEvent alterEvent = (MetastoreEvents.AlterTableEvent)event;
                if (!alterEvent.isRename()) continue;
                return new Pair<Long, Pair<org.apache.hadoop.hive.metastore.api.Table, org.apache.hadoop.hive.metastore.api.Table>>(alterEvent.getEventId(), new Pair<org.apache.hadoop.hive.metastore.api.Table, org.apache.hadoop.hive.metastore.api.Table>(alterEvent.getBeforeTable(), alterEvent.getAfterTable()));
            }
            catch (MetastoreNotificationException e) {
                throw new CatalogException("Unable to create a metastore event", e);
            }
        }
        return null;
    }

    private void getPartitionsFromEvent(List<NotificationEvent> events, Map<Partition, Long> partitionToEventId) throws CatalogException {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (NotificationEvent event : events) {
            try {
                MetastoreEvents.MetastoreEvent metastoreEvent = this.catalog_.getMetastoreEventProcessor().getEventsFactory().get(event, null);
                Preconditions.checkState((boolean)(metastoreEvent instanceof MetastoreEvents.AddPartitionEvent));
                Long eventId = metastoreEvent.getEventId();
                for (Partition part : ((MetastoreEvents.AddPartitionEvent)metastoreEvent).getPartitions()) {
                    partitionToEventId.put(part, eventId);
                }
            }
            catch (MetastoreNotificationException e) {
                throw new CatalogException("Unable to create a metastore event", e);
            }
        }
    }

    private void addDroppedPartitionsFromEvent(List<String> partColNames, List<NotificationEvent> events, Map<Long, List<List<String>>> eventIdToPartVals) throws CatalogException {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (NotificationEvent notificationEvent : events) {
            try {
                MetastoreEvents.MetastoreEvent event = this.catalog_.getMetastoreEventProcessor().getEventsFactory().get(notificationEvent, null);
                Preconditions.checkState((boolean)(event instanceof MetastoreEvents.DropPartitionEvent));
                Long eventId = notificationEvent.getEventId();
                List<Map<String, String>> droppedPartitions = ((MetastoreEvents.DropPartitionEvent)event).getDroppedPartitions();
                for (Map<String, String> partKeyVals : droppedPartitions) {
                    ArrayList partVals = Lists.newArrayList();
                    for (String partColName : partColNames) {
                        String val = (String)Preconditions.checkNotNull((Object)partKeyVals.get(partColName));
                        partVals.add(val);
                    }
                    eventIdToPartVals.computeIfAbsent(eventId, l -> new ArrayList()).add(partVals);
                }
            }
            catch (MetastoreNotificationException e) {
                throw new CatalogException("Unable to create a metastore event", e);
            }
        }
    }

    private long getCurrentEventId(MetaStoreClientPool.MetaStoreClient msClient, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        try {
            long id = msClient.getHiveClient().getCurrentNotificationEventId().getEventId();
            if (catalogTimeline != null) {
                catalogTimeline.markEvent(FETCHED_LATEST_HMS_EVENT_ID + id);
            }
            return id;
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "getCurrentNotificationEventId") + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFunction(TCreateFunctionParams params, TDdlExecResponse resp, EventSequence catalogTimeline) throws ImpalaException {
        Function fn = Function.fromThrift(params.getFn());
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Adding %s: %s", fn.getClass().getSimpleName(), fn.signatureString()));
        }
        boolean isPersistentJavaFn = fn.getBinaryType() == TFunctionBinaryType.JAVA && fn.isPersistent();
        HiveJavaFunction hiveJavaFunction = fn.getBinaryType() == TFunctionBinaryType.JAVA ? this.hiveJavaFuncFactory_.create((ScalarFunction)fn) : null;
        Db db = this.catalog_.getDb(fn.dbName());
        if (db == null) {
            throw new CatalogException("Database: " + fn.dbName() + " does not exist.");
        }
        this.tryLock(db, "creating function " + fn.getClass().getSimpleName(), catalogTimeline);
        long newCatalogVersion = this.catalog_.incrementAndGetCatalogVersion();
        this.catalog_.getLock().writeLock().unlock();
        try {
            for (Function function : db.getFunctions(fn.functionName())) {
                if (!isPersistentJavaFn && (!function.isPersistent() || function.getBinaryType() != TFunctionBinaryType.JAVA) && !function.compare(fn, Function.CompareMode.IS_INDISTINGUISHABLE)) continue;
                if (!params.if_not_exists) {
                    throw new CatalogException("Function " + fn.functionName() + " already exists.");
                }
                CatalogOpExecutor.addSummary(resp, "Function already exists.");
                return;
            }
            ArrayList addedFunctions = Lists.newArrayList();
            if (isPersistentJavaFn) {
                Preconditions.checkState((boolean)(fn instanceof ScalarFunction));
                Preconditions.checkNotNull((Object)hiveJavaFunction);
                List<ScalarFunction> funcs = hiveJavaFunction.extract();
                if (this.addJavaFunctionToHms(hiveJavaFunction.getHiveFunction(), params.if_not_exists, catalogTimeline)) {
                    for (Function function : funcs) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(String.format("Adding function: %s.%s", function.dbName(), function.signatureString()));
                        }
                        Preconditions.checkState((boolean)this.catalog_.addFunction(function));
                        addedFunctions.add(function.toTCatalogObject());
                    }
                }
            } else if (this.catalog_.addFunction(fn)) {
                this.addCatalogServiceIdentifiers(db.getMetaStoreDb(), this.catalog_.getCatalogServiceId(), newCatalogVersion);
                this.applyAlterDatabase(db.getMetaStoreDb(), catalogTimeline);
                addedFunctions.add(fn.toTCatalogObject());
                this.catalog_.addVersionsForInflightEvents(db, newCatalogVersion);
            }
            if (!addedFunctions.isEmpty()) {
                resp.result.setUpdated_catalog_objects(addedFunctions);
                resp.result.setVersion(this.catalog_.getCatalogVersion());
                CatalogOpExecutor.addSummary(resp, "Function has been created.");
            } else {
                CatalogOpExecutor.addSummary(resp, "Function already exists.");
            }
        }
        finally {
            db.getLock().unlock();
        }
    }

    private void createDataSource(TCreateDataSourceParams params, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding DATA SOURCE: " + params.toString());
        }
        DataSource dataSource = DataSource.fromThrift(params.getData_source());
        Preconditions.checkNotNull((Object)dataSource);
        String dataSrcName = dataSource.getName();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)dataSrcName) ? 1 : 0) != 0, (Object)"Null or empty DataSource name passed as argument to CatalogOpExecutor.createDataSource");
        DataSource existingDataSource = this.catalog_.getDataSource(dataSrcName);
        if (existingDataSource != null) {
            if (!params.if_not_exists) {
                throw new ImpalaRuntimeException("Data source " + dataSource.getName() + " already exists.");
            }
            CatalogOpExecutor.addSummary(resp, "Data source already exists.");
            resp.result.addToUpdated_catalog_objects(existingDataSource.toTCatalogObject());
            resp.result.setVersion(existingDataSource.getCatalogVersion());
            return;
        }
        this.addDataSourceToHms(dataSource, params.if_not_exists);
        this.catalog_.addDataSource(dataSource);
        resp.result.addToUpdated_catalog_objects(dataSource.toTCatalogObject());
        resp.result.setVersion(dataSource.getCatalogVersion());
        CatalogOpExecutor.addSummary(resp, "Data source has been created.");
    }

    private void dropDataSource(TDropDataSourceParams params, TDdlExecResponse resp) throws ImpalaException {
        String dataSrcName;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Drop DATA SOURCE: " + params.toString());
        }
        Preconditions.checkState((!Strings.isNullOrEmpty((String)(dataSrcName = params.getData_source())) ? 1 : 0) != 0, (Object)"Null or empty DataSource name passed as argument to CatalogOpExecutor.dropDataSource");
        DataSource dataSource = this.catalog_.removeDataSource(dataSrcName);
        if (dataSource == null) {
            if (!params.if_exists) {
                throw new ImpalaRuntimeException("Data source " + params.getData_source() + " does not exists.");
            }
            CatalogOpExecutor.addSummary(resp, "Data source does not exist.");
            resp.result.setVersion(this.catalog_.getCatalogVersion());
            return;
        }
        this.dropDataSourceFromHms(dataSrcName, false);
        resp.result.addToRemoved_catalog_objects(dataSource.toTCatalogObject());
        resp.result.setVersion(dataSource.getCatalogVersion());
        CatalogOpExecutor.addSummary(resp, "Data source has been dropped.");
    }

    private void dropStats(TDropStatsParams params, boolean wantMinimalResult, TDdlExecResponse resp, EventSequence catalogTimeline, @Nullable String debugAction) throws ImpalaException {
        org.apache.impala.catalog.Table table = this.getExistingTable(params.getTable_name().getDb_name(), params.getTable_name().getTable_name(), "Load for DROP STATS", catalogTimeline);
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkState((!AcidUtils.isTransactionalTable(table) ? 1 : 0) != 0);
        this.tryWriteLock(table, "dropping stats", catalogTimeline);
        InProgressTableModification modification = null;
        try {
            modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            modification.addCatalogServiceIdentifiersToTable();
            modification.registerInflightEvent();
            if (params.getPartition_set() == null) {
                boolean isIntegratedIcebergTbl;
                this.dropColumnStats(table, catalogTimeline);
                org.apache.hadoop.hive.metastore.api.Table msTbl = table.getMetaStoreTable();
                boolean bl = isIntegratedIcebergTbl = IcebergTable.isIcebergTable(msTbl) && this.isIcebergHmsIntegrationEnabled(msTbl);
                if (isIntegratedIcebergTbl) {
                    org.apache.iceberg.Transaction iceTxn = IcebergUtil.getIcebergTransaction((FeIcebergTable)((Object)table));
                    this.dropIntegratedIcebergTableStats(table, iceTxn);
                    IcebergCatalogOpExecutor.addCatalogVersionToTxn(iceTxn, this.catalog_.getCatalogServiceId(), modification.newVersionNumber());
                    iceTxn.commitTransaction();
                } else {
                    this.dropTableStats(table, catalogTimeline);
                }
            } else {
                HdfsTable hdfsTbl = (HdfsTable)table;
                List<HdfsPartition> partitions = hdfsTbl.getPartitionsFromPartitionSet(params.getPartition_set());
                if (partitions.isEmpty()) {
                    CatalogOpExecutor.addSummary(resp, "No partitions found for table.");
                    return;
                }
                ArrayList modifiedParts = Lists.newArrayList();
                for (HdfsPartition partition : partitions) {
                    if (partition.getPartitionStatsCompressed() == null) continue;
                    HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                    partBuilder.dropPartitionStats();
                    modifiedParts.add(partBuilder);
                }
                this.bulkAlterPartitions(table, modifiedParts, null, UpdatePartitionMethod.IN_PLACE, catalogTimeline);
            }
            this.loadTableMetadata(table, modification.newVersionNumber(), false, true, "DROP STATS", debugAction, catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(table, wantMinimalResult, resp.result);
            CatalogOpExecutor.addSummary(resp, "Stats have been dropped.");
            modification.markInflightEventRegistrationComplete();
            modification.validateInProgressModificationComplete();
        }
        catch (ImpalaException ex) {
            if (modification != null) {
                modification.cancelInflightEventIfExist();
            }
            throw ex;
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            table.releaseWriteLock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int dropColumnStats(org.apache.impala.catalog.Table table, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        Preconditions.checkState((boolean)table.isWriteLockedByCurrentThread());
        int numColsUpdated = 0;
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            for (Column col : table.getColumns()) {
                if (!col.getStats().hasStats()) continue;
                try {
                    MetastoreShim.deleteTableColumnStatistics(msClient.getHiveClient(), table.getDb().getName(), table.getName(), col.getName());
                    catalogTimeline.markEvent("Deleted column statistics in Metastore");
                    ++numColsUpdated;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (TException e) {
                    throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "delete_table_column_statistics"), e);
                    return numColsUpdated;
                }
            }
        }
    }

    private int dropTableStats(org.apache.impala.catalog.Table table, EventSequence catalogTimeline) throws ImpalaException {
        boolean droppedIcebergComputeStatsSnapshotIds;
        Preconditions.checkState((boolean)table.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = table.getMetaStoreTable();
        boolean isIntegratedIcebergTbl = IcebergTable.isIcebergTable(msTbl) && this.isIcebergHmsIntegrationEnabled(msTbl);
        Preconditions.checkState((!isIntegratedIcebergTbl ? 1 : 0) != 0);
        int numTargetedPartitions = 0;
        boolean droppedRowCount = msTbl.getParameters().remove("numRows") != null;
        boolean droppedTotalSize = msTbl.getParameters().remove("totalSize") != null;
        boolean droppedLastCompute = msTbl.getParameters().remove("impala.lastComputeStatsTime") != null;
        boolean bl = droppedIcebergComputeStatsSnapshotIds = msTbl.getParameters().remove("impala.computeStatsSnapshotIds") != null;
        if (droppedRowCount || droppedTotalSize || droppedLastCompute || droppedIcebergComputeStatsSnapshotIds) {
            this.applyAlterTable(msTbl, false, null, catalogTimeline);
            ++numTargetedPartitions;
        }
        if (!(table instanceof HdfsTable) || table.getNumClusteringCols() == 0) {
            return numTargetedPartitions;
        }
        HdfsTable hdfsTable = (HdfsTable)table;
        Preconditions.checkNotNull((Object)hdfsTable);
        ArrayList modifiedParts = Lists.newArrayList();
        Collection<? extends FeFsPartition> parts = hdfsTable.loadAllPartitions();
        for (FeFsPartition feFsPartition : parts) {
            HdfsPartition part = (HdfsPartition)feFsPartition;
            HdfsPartition.Builder partBuilder = null;
            if (part.getPartitionStatsCompressed() != null) {
                partBuilder = new HdfsPartition.Builder(part).dropPartitionStats();
            }
            if (part.getParameters().containsKey("numRows")) {
                if (partBuilder == null) {
                    partBuilder = new HdfsPartition.Builder(part);
                }
                partBuilder.removeRowCountParam();
            }
            if (partBuilder == null) continue;
            modifiedParts.add(partBuilder);
        }
        this.bulkAlterPartitions(table, modifiedParts, null, UpdatePartitionMethod.IN_PLACE, catalogTimeline);
        return modifiedParts.size();
    }

    private void dropIntegratedIcebergTableStats(org.apache.impala.catalog.Table table, org.apache.iceberg.Transaction iceTxn) throws ImpalaException {
        org.apache.hadoop.hive.metastore.api.Table msTbl = table.getMetaStoreTable();
        boolean isIntegratedIcebergTbl = IcebergTable.isIcebergTable(msTbl) && this.isIcebergHmsIntegrationEnabled(msTbl);
        Preconditions.checkState((boolean)isIntegratedIcebergTbl);
        IcebergCatalogOpExecutor.unsetTblProperties(iceTxn, Arrays.asList("impala.lastComputeStatsTime", "impala.computeStatsSnapshotIds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabase(TDropDbParams params, TDdlExecResponse resp, int kudu_table_reserve_seconds, EventSequence catalogTimeline) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        String dbName = params.getDb();
        Preconditions.checkState((dbName != null && !dbName.isEmpty() ? 1 : 0) != 0, (Object)"Null or empty database name passed as argument to Catalog.dropDatabase");
        Preconditions.checkState((!this.catalog_.isBlacklistedDb(dbName) || params.if_exists ? 1 : 0) != 0, (Object)String.format("Can't drop blacklisted database: %s. %s", dbName, BLACKLISTED_DBS_INCONSISTENT_ERR_STR));
        if (this.catalog_.isBlacklistedDb(dbName)) {
            CatalogOpExecutor.addSummary(resp, "Can't drop blacklisted database: " + dbName);
            return;
        }
        LOG.trace("Dropping database " + dbName);
        Db db = this.catalog_.getDb(dbName);
        if (db != null && db.numFunctions() > 0 && !params.cascade) {
            throw new CatalogException("Database " + db.getName() + " is not empty");
        }
        TCatalogObject removedObject = null;
        this.acquireMetastoreDdlLock(catalogTimeline);
        try {
            if (db != null && params.cascade) {
                this.dropTablesFromKudu(db, kudu_table_reserve_seconds, catalogTimeline);
            }
            try {
                MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);
                Object object = null;
                try {
                    long eventId = this.getCurrentEventId(msClient, catalogTimeline);
                    msClient.getHiveClient().dropDatabase(dbName, true, false, params.cascade);
                    catalogTimeline.markEvent("Dropped database in Metastore");
                    List<NotificationEvent> events = this.getNextMetastoreDropEventsForDbIfEnabled(catalogTimeline, eventId, dbName);
                    this.addToDeleteEventLog(events);
                    CatalogOpExecutor.addSummary(resp, "Database has been dropped.");
                }
                catch (Throwable eventId) {
                    object = eventId;
                    throw eventId;
                }
                finally {
                    if (msClient != null) {
                        if (object != null) {
                            try {
                                msClient.close();
                            }
                            catch (Throwable eventId) {
                                ((Throwable)object).addSuppressed(eventId);
                            }
                        } else {
                            msClient.close();
                        }
                    }
                }
            }
            catch (TException e) {
                if (e instanceof NoSuchObjectException && params.if_exists) {
                    CatalogOpExecutor.addSummary(resp, "Database does not exist.");
                }
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropDatabase"), e);
            }
            Db removedDb = this.catalog_.removeDb(dbName);
            catalogTimeline.markEvent("Deleted database in catalog cache");
            if (removedDb == null) {
                resp.result.setVersion(this.catalog_.getCatalogVersion());
                return;
            }
            for (String tableName : removedDb.getAllTableNames()) {
                CatalogOpExecutor.uncacheTable(removedDb.getTable(tableName), catalogTimeline);
            }
            removedObject = removedDb.toTCatalogObject();
            if (this.authzConfig_.isEnabled() && db != null) {
                this.authzManager_.updateDatabaseOwnerPrivilege(params.server_name, dbName, db.getMetaStoreDb().getOwnerName(), db.getMetaStoreDb().getOwnerType(), null, null, resp);
            }
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        Preconditions.checkNotNull((Object)removedObject);
        resp.result.setVersion(removedObject.getCatalog_version());
        resp.result.addToRemoved_catalog_objects(removedObject);
        CatalogOpExecutor.addSummary(resp, "Database has been dropped.");
    }

    public void addToDeleteEventLog(List<NotificationEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (NotificationEvent event : events) {
            String key;
            String eventType = event.getEventType();
            Preconditions.checkState((eventType.equals("DROP_DATABASE") || eventType.equals("DROP_TABLE") || eventType.equals("DROP_PARTITION") ? 1 : 0) != 0, (String)"Can not add event type: %s to deleteEventLog", (Object)eventType);
            if ("DROP_DATABASE".equals(event.getEventType())) {
                key = DeleteEventLog.getDbKey(event.getDbName());
            } else {
                Preconditions.checkNotNull((Object)event.getTableName());
                key = DeleteEventLog.getTblKey(event.getDbName(), event.getTableName());
            }
            this.addToDeleteEventLog(event.getEventId(), key);
        }
    }

    private void dropTablesFromKudu(Db db, int kudu_table_reserve_seconds, EventSequence catalogTimeline) throws ImpalaException {
        ArrayList incompleteTableNames = Lists.newArrayList();
        ArrayList msTables = Lists.newArrayList();
        for (org.apache.impala.catalog.Table table : db.getTables()) {
            org.apache.hadoop.hive.metastore.api.Table msTable = table.getMetaStoreTable();
            if (msTable == null) {
                incompleteTableNames.add(table.getName());
                continue;
            }
            msTables.add(msTable);
        }
        if (!incompleteTableNames.isEmpty()) {
            try {
                Throwable throwable = null;
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    msTables.addAll(msClient.getHiveClient().getTableObjectsByName(db.getName(), (List)incompleteTableNames));
                    catalogTimeline.markEvent("Fetched unloaded tables from Metastore");
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (TException e) {
                LOG.error(String.format(HMS_RPC_ERROR_FORMAT_STR, "getTableObjectsByName") + e.getMessage());
            }
        }
        for (org.apache.hadoop.hive.metastore.api.Table table : msTables) {
            if (!KuduTable.isKuduTable(table) || !KuduTable.isSynchronizedTable(table)) continue;
            KuduCatalogOpExecutor.dropTable(table, true, kudu_table_reserve_seconds, catalogTimeline);
        }
    }

    private boolean isHmsIntegrationAutomatic(org.apache.hadoop.hive.metastore.api.Table msTbl) throws ImpalaRuntimeException {
        if (KuduTable.isKuduTable(msTbl)) {
            return this.isKuduHmsIntegrationEnabled(msTbl);
        }
        if (IcebergTable.isIcebergTable(msTbl)) {
            return this.isIcebergHmsIntegrationEnabled(msTbl);
        }
        return false;
    }

    private boolean isKuduHmsIntegrationEnabled(org.apache.hadoop.hive.metastore.api.Table msTbl) throws ImpalaRuntimeException {
        Preconditions.checkState((boolean)KuduTable.isKuduTable(msTbl));
        String masterHosts = (String)msTbl.getParameters().get("kudu.master_addresses");
        String hmsUris = MetaStoreUtil.getHiveMetastoreUris();
        return KuduTable.isHMSIntegrationEnabledAndValidate(masterHosts, hmsUris);
    }

    private boolean isIcebergHmsIntegrationEnabled(org.apache.hadoop.hive.metastore.api.Table msTbl) throws ImpalaRuntimeException {
        Preconditions.checkState((boolean)IcebergTable.isIcebergTable(msTbl));
        if (!IcebergTable.isSynchronizedTable(msTbl)) {
            return false;
        }
        return IcebergUtil.isHiveCatalog(msTbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableOrView(TDropTableOrViewParams params, TDdlExecResponse resp, int lockMaxWaitTime, int kudu_table_reserve_seconds, EventSequence catalogTimeline) throws ImpalaException {
        TableName tableName = TableName.fromThrift(params.getTable_name());
        Preconditions.checkState((tableName != null && tableName.isFullyQualified() ? 1 : 0) != 0);
        Preconditions.checkState((!this.catalog_.isBlacklistedTable(tableName) || params.if_exists ? 1 : 0) != 0, (Object)String.format("Can't drop blacklisted table: %s. %s", tableName, BLACKLISTED_TABLES_INCONSISTENT_ERR_STR));
        if (this.catalog_.isBlacklistedTable(tableName)) {
            CatalogOpExecutor.addSummary(resp, "Can't drop blacklisted table: " + tableName);
            return;
        }
        LOG.trace(String.format("Dropping table/view %s", tableName));
        try {
            this.catalog_.getOrLoadTable(params.getTable_name().db_name, params.getTable_name().table_name, "Load for DROP TABLE/VIEW", null, -1L, catalogTimeline);
            catalogTimeline.markEvent("Loaded catalog table");
        }
        catch (CatalogException catalogException) {
            // empty catch block
        }
        org.apache.impala.catalog.Table tbl = this.catalog_.getTableIfCachedNoThrow(tableName.getDb(), tableName.getTbl());
        long lockId = -1L;
        if (tbl != null && !(tbl instanceof IncompleteTable) && AcidUtils.isTransactionalTable(tbl)) {
            TransactionKeepalive.HeartbeatContext ctx = new TransactionKeepalive.HeartbeatContext(String.format("Drop table/view %s.%s", tableName.getDb(), tableName.getTbl()), System.nanoTime());
            lockId = this.catalog_.lockTableStandalone(tableName.getDb(), tableName.getTbl(), ctx, lockMaxWaitTime);
            catalogTimeline.markEvent("Acquired Metastore lock on the table");
        }
        try {
            this.dropTableOrViewInternal(params, tableName, resp, kudu_table_reserve_seconds, catalogTimeline);
        }
        finally {
            if (lockId > 0L) {
                this.catalog_.releaseTableLock(lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableOrViewInternal(TDropTableOrViewParams params, TableName tableName, TDdlExecResponse resp, int kudu_table_reserve_seconds, EventSequence catalogTimeline) throws ImpalaException {
        TCatalogObject removedObject = new TCatalogObject();
        this.acquireMetastoreDdlLock(catalogTimeline);
        try {
            boolean needsHmsDropTable;
            long eventId;
            boolean isSynchronizedKuduTable;
            Throwable throwable;
            MetaStoreClientPool.MetaStoreClient msClient;
            Db db = this.catalog_.getDb(params.getTable_name().db_name);
            if (db == null) {
                String dbNotExist = "Database does not exist: " + params.getTable_name().db_name;
                if (params.if_exists) {
                    CatalogOpExecutor.addSummary(resp, dbNotExist);
                    return;
                }
                throw new CatalogException(dbNotExist);
            }
            org.apache.impala.catalog.Table existingTbl = db.getTable(params.getTable_name().table_name);
            if (existingTbl == null) {
                if (params.if_exists) {
                    CatalogOpExecutor.addSummary(resp, (params.is_table ? "Table " : "View ") + "does not exist.");
                    return;
                }
                throw new CatalogException("Table/View does not exist.");
            }
            if (params.isSetIs_table() && (params.is_table && existingTbl instanceof View || !params.is_table && !(existingTbl instanceof View))) {
                String errorMsg = "DROP " + (params.is_table ? "TABLE " : "VIEW ") + "not allowed on a " + (params.is_table ? "view: " : "table: ") + tableName;
                if (params.if_exists) {
                    CatalogOpExecutor.addSummary(resp, "Drop " + (params.is_table ? "table " : "view ") + "is not allowed on a " + (params.is_table ? "view." : "table."));
                    return;
                }
                throw new CatalogException(errorMsg);
            }
            org.apache.hadoop.hive.metastore.api.Table msTbl = existingTbl.getMetaStoreTable();
            if (msTbl == null) {
                long hmsLoadTime;
                Preconditions.checkState((boolean)(existingTbl instanceof IncompleteTable));
                Stopwatch hmsLoadSW = Stopwatch.createStarted();
                try {
                    msClient = this.catalog_.getMetaStoreClient(catalogTimeline);
                    throwable = null;
                    try {
                        msTbl = msClient.getHiveClient().getTable(tableName.getDb(), tableName.getTbl());
                        catalogTimeline.markEvent(FETCHED_HMS_TABLE);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (msClient != null) {
                            if (throwable != null) {
                                try {
                                    msClient.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                msClient.close();
                            }
                        }
                    }
                }
                catch (TException e) {
                    LOG.error(String.format(HMS_RPC_ERROR_FORMAT_STR, "getTable") + e.getMessage());
                }
                finally {
                    hmsLoadTime = hmsLoadSW.elapsed(TimeUnit.NANOSECONDS);
                }
                existingTbl.updateHMSLoadTableSchemaTime(hmsLoadTime);
            }
            boolean bl = isSynchronizedKuduTable = msTbl != null && KuduTable.isKuduTable(msTbl) && KuduTable.isSynchronizedTable(msTbl);
            if (isSynchronizedKuduTable) {
                KuduCatalogOpExecutor.dropTable(msTbl, true, kudu_table_reserve_seconds, catalogTimeline);
            }
            msClient = this.catalog_.getMetaStoreClient(catalogTimeline);
            throwable = null;
            try {
                eventId = this.getCurrentEventId(msClient, catalogTimeline);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (msClient != null) {
                    if (throwable != null) {
                        try {
                            msClient.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        msClient.close();
                    }
                }
            }
            boolean isSynchronizedIcebergTable = msTbl != null && IcebergTable.isIcebergTable(msTbl) && IcebergTable.isSynchronizedTable(msTbl);
            boolean isSynchronizedTable = isSynchronizedKuduTable || isSynchronizedIcebergTable;
            boolean bl2 = needsHmsDropTable = existingTbl instanceof IncompleteTable && isSynchronizedIcebergTable || !isSynchronizedTable || !this.isHmsIntegrationAutomatic(msTbl);
            if (!(existingTbl instanceof IncompleteTable) && isSynchronizedIcebergTable) {
                Preconditions.checkState((boolean)(existingTbl instanceof IcebergTable));
                try {
                    IcebergCatalogOpExecutor.dropTable((IcebergTable)existingTbl, params.if_exists);
                    catalogTimeline.markEvent("Dropped table using Iceberg");
                }
                catch (TableNotFoundException e) {
                    if (!needsHmsDropTable) {
                        throw e;
                    }
                    LOG.warn(String.format("Could not drop Iceberg table %s.%s proceeding to drop table in HMS", tableName.getDb(), tableName.getTbl()), (Throwable)e);
                }
            }
            if (existingTbl instanceof FePaimonTable) {
                needsHmsDropTable = PaimonCatalogOpExecutor.dropTable(msTbl, existingTbl, catalogTimeline, params);
            }
            if (needsHmsDropTable) {
                try (MetaStoreClientPool.MetaStoreClient msClient2 = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    msClient2.getHiveClient().dropTable(tableName.getDb(), tableName.getTbl(), true, params.if_exists, params.purge);
                    catalogTimeline.markEvent("Dropped table in Metastore");
                }
                catch (NoSuchObjectException e) {
                    throw new ImpalaRuntimeException(String.format("Table %s no longer exists in the Hive MetaStore. Run 'invalidate metadata %s' to update the Impala catalog.", tableName, tableName));
                }
                catch (TException e) {
                    throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropTable"), e);
                }
            }
            List<NotificationEvent> events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId, tableName.getDb(), tableName.getTbl(), "DROP_TABLE");
            CatalogOpExecutor.addSummary(resp, (params.is_table ? "Table " : "View ") + "has been dropped.");
            this.addToDeleteEventLog(events);
            org.apache.impala.catalog.Table table = this.catalog_.removeTable(params.getTable_name().db_name, params.getTable_name().table_name);
            catalogTimeline.markEvent("Deleted table in catalog cache");
            if (table == null) {
                resp.result.setVersion(this.catalog_.getCatalogVersion());
                return;
            }
            resp.result.setVersion(table.getCatalogVersion());
            CatalogOpExecutor.uncacheTable(table, catalogTimeline);
            if (table.getMetaStoreTable() != null && this.authzConfig_.isEnabled()) {
                this.authzManager_.updateTableOwnerPrivilege(params.server_name, table.getDb().getName(), table.getName(), table.getMetaStoreTable().getOwner(), table.getMetaStoreTable().getOwnerType(), null, null, resp);
            }
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        removedObject.setType(params.is_table ? TCatalogObjectType.TABLE : TCatalogObjectType.VIEW);
        removedObject.setTable(new TTable());
        removedObject.getTable().setTbl_name(tableName.getTbl());
        removedObject.getTable().setDb_name(tableName.getDb());
        removedObject.setCatalog_version(resp.result.getVersion());
        resp.result.addToRemoved_catalog_objects(removedObject);
    }

    private static void uncacheTable(FeTable table, EventSequence catalogTimeline) {
        if (!(table instanceof FeFsTable)) {
            return;
        }
        FeFsTable hdfsTable = (FeFsTable)table;
        if (hdfsTable.isMarkedCached()) {
            try {
                HdfsCachingUtil.removeTblCacheDirective(table.getMetaStoreTable());
                catalogTimeline.markEvent("Removed table cache directive of " + table.getFullName());
            }
            catch (Exception e) {
                LOG.error("Unable to uncache table: " + table.getFullName(), (Throwable)e);
            }
        }
        if (table.getNumClusteringCols() > 0) {
            Collection<? extends FeFsPartition> parts = hdfsTable.loadAllPartitions();
            boolean hasTasks = false;
            for (FeFsPartition feFsPartition : parts) {
                if (!feFsPartition.isMarkedCached()) continue;
                hasTasks = true;
                HdfsPartition.Builder partBuilder = new HdfsPartition.Builder((HdfsPartition)feFsPartition);
                try {
                    HdfsCachingUtil.removePartitionCacheDirective(partBuilder);
                }
                catch (Exception e) {
                    LOG.error("Unable to uncache partition: " + feFsPartition.getPartitionName(), (Throwable)e);
                }
            }
            if (hasTasks) {
                catalogTimeline.markEvent("Removed partition cache directives of " + table.getFullName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateTable(TTruncateParams params, boolean wantMinimalResult, TDdlExecResponse resp, int lockMaxWaitTime, EventSequence catalogTimeline, @Nullable String debugAction) throws ImpalaException {
        TTableName tblName = params.getTable_name();
        org.apache.impala.catalog.Table table = null;
        try {
            table = this.getExistingTable(tblName.getDb_name(), tblName.getTable_name(), "Load for TRUNCATE TABLE", catalogTimeline);
        }
        catch (TableNotFoundException e) {
            if (params.if_exists) {
                CatalogOpExecutor.addSummary(resp, "Table does not exist.");
                return;
            }
            throw e;
        }
        Preconditions.checkNotNull((Object)table);
        if (!(table instanceof FeFsTable)) {
            throw new CatalogException(String.format("TRUNCATE TABLE not supported on non-HDFS table: %s", table.getFullName()));
        }
        this.tryWriteLock(table, "truncating", catalogTimeline);
        try {
            long newCatalogVersion = 0L;
            try {
                newCatalogVersion = AcidUtils.isTransactionalTable(table) ? this.truncateTransactionalTable(params, table, lockMaxWaitTime, catalogTimeline) : (table instanceof FeIcebergTable ? this.truncateIcebergTable(params, table, catalogTimeline) : this.truncateNonTransactionalTable(params, table, catalogTimeline));
                catalogTimeline.markEvent("Truncated table");
            }
            catch (Exception e) {
                String fqName = tblName.db_name + "." + tblName.table_name;
                throw new CatalogException(String.format("Failed to truncate table: %s.\nTable may be in a partially truncated state.", fqName), e);
            }
            Preconditions.checkState((newCatalogVersion > 0L ? 1 : 0) != 0, (Object)"newCatalogVersion must be greater than 0!");
            CatalogOpExecutor.addSummary(resp, "Table has been truncated.");
            this.loadTableMetadata(table, newCatalogVersion, true, true, "TRUNCATE", debugAction, catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(table, wantMinimalResult, resp.result);
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long truncateTransactionalTable(TTruncateParams params, org.apache.impala.catalog.Table table, int lockMaxWaitTime, EventSequence catalogTimeline) throws ImpalaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isTableBeingReplicated(IMetaStoreClient metastoreClient, HdfsTable tbl) throws CatalogException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        String dbName = tbl.getDb().getName();
        try {
            Database db = metastoreClient.getDatabase(dbName);
            if (!db.isSetParameters()) {
                return false;
            }
            return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)db.getParameters().get("repl.source.for")));
        }
        catch (TException tException) {
            throw new CatalogException(String.format("Could not determine if the table %s is a replication source", tbl.getFullName()), tException);
        }
    }

    private long truncateIcebergTable(TTruncateParams params, org.apache.impala.catalog.Table table, EventSequence catalogTimeline) throws ImpalaException {
        Preconditions.checkState((boolean)table.isWriteLockedByCurrentThread());
        Preconditions.checkState((boolean)this.catalog_.getLock().isWriteLockedByCurrentThread());
        Preconditions.checkState((boolean)(table instanceof FeIcebergTable));
        InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
        this.catalog_.getLock().writeLock().unlock();
        modification.addCatalogServiceIdentifiersToTable();
        try {
            FeIcebergTable iceTbl = (FeIcebergTable)((Object)table);
            org.apache.iceberg.Transaction iceTxn = IcebergUtil.getIcebergTransaction(iceTbl);
            if (params.isDelete_stats()) {
                modification.registerInflightEvent();
                this.dropColumnStats(table, catalogTimeline);
                if (this.isIcebergHmsIntegrationEnabled(table.getMetaStoreTable())) {
                    this.dropIntegratedIcebergTableStats(table, iceTxn);
                } else {
                    this.dropTableStats(table, catalogTimeline);
                }
            }
            IcebergCatalogOpExecutor.truncateTable(iceTxn);
            if (this.isIcebergHmsIntegrationEnabled(iceTbl.getMetaStoreTable())) {
                modification.registerInflightEvent();
                IcebergCatalogOpExecutor.addCatalogVersionToTxn(iceTxn, this.catalog_.getCatalogServiceId(), modification.newVersionNumber());
            }
            iceTxn.commitTransaction();
            modification.markInflightEventRegistrationComplete();
            modification.validateInProgressModificationComplete();
        }
        catch (ImpalaException ex) {
            modification.cancelInflightEventIfExist();
            throw ex;
        }
        return modification.newVersionNumber();
    }

    private long truncateNonTransactionalTable(TTruncateParams params, org.apache.impala.catalog.Table table, EventSequence catalogTimeline) throws Exception {
        Preconditions.checkState((boolean)table.isWriteLockedByCurrentThread());
        Preconditions.checkState((boolean)this.catalog_.getLock().isWriteLockedByCurrentThread());
        InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
        this.catalog_.getLock().writeLock().unlock();
        modification.addCatalogServiceIdentifiersToTable();
        HdfsTable hdfsTable = (HdfsTable)table;
        boolean truncateWithHms = BackendConfig.INSTANCE.truncateExternalTablesWithHms();
        Stopwatch sw = Stopwatch.createStarted();
        if (truncateWithHms && !params.isDelete_stats()) {
            throw new ImpalaRuntimeException("Setting the query option 'DELETE_STATS_IN_TRUNCATE' to false is not supported when the flag '--truncate_external_tables_with_hms' is set to true.");
        }
        try {
            MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient(catalogTimeline);
            Object object = null;
            try {
                if (!truncateWithHms) {
                    truncateWithHms = this.isTableBeingReplicated(client.getHiveClient(), hdfsTable);
                }
                if (truncateWithHms) {
                    modification.registerInflightEvent();
                    String string = ((Db)Preconditions.checkNotNull((Object)hdfsTable.getDb())).getName();
                    client.getHiveClient().truncateTable(string, hdfsTable.getName(), null);
                    catalogTimeline.markEvent("Truncated table in Metastore");
                    LOG.trace("Time elapsed after truncating table {} using HMS API: {} msec", (Object)hdfsTable.getFullName(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            if (!truncateWithHms) {
                Collection<? extends FeFsPartition> parts = hdfsTable.loadAllPartitions();
                for (FeFsPartition feFsPartition : parts) {
                    FileSystemUtil.deleteAllVisibleFiles(new Path(feFsPartition.getLocation()));
                }
                catalogTimeline.markEvent("Deleted all visible files");
                LOG.trace("Time elapsed after deleting files for table {}: {} msec", (Object)table.getFullName(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            if (params.isDelete_stats()) {
                modification.registerInflightEvent();
                this.dropColumnStats(table, catalogTimeline);
                this.dropTableStats(table, catalogTimeline);
                LOG.trace("Time elapsed after deleting statistics for table {}: {} msec ", (Object)table.getFullName(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            modification.markInflightEventRegistrationComplete();
            modification.validateInProgressModificationComplete();
            long parts = modification.newVersionNumber();
            return parts;
        }
        catch (Exception ex) {
            modification.cancelInflightEventIfExist();
            throw ex;
        }
        finally {
            LOG.debug("Time taken for metastore and filesystem operations for truncating table {}: {} msec", (Object)table.getFullName(), (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private void createEmptyBaseDirectories(Collection<? extends FeFsPartition> partitions, long writeId) throws IOException {
        for (FeFsPartition feFsPartition : partitions) {
            Path partPath = new Path(feFsPartition.getLocation());
            FileSystem fs = FileSystemUtil.getFileSystemForPath(partPath);
            String baseDirStr = feFsPartition.getLocation() + "/" + "base_" + String.valueOf(writeId);
            fs.mkdirs(new Path(baseDirStr));
            String emptyFile = baseDirStr + "/" + "empty";
            fs.create(new Path(emptyFile)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropFunction(TDropFunctionParams params, TDdlExecResponse resp, EventSequence catalogTimeline) throws ImpalaException {
        FunctionName fName = FunctionName.fromThrift(params.fn_name);
        Db db = this.catalog_.getDb(fName.getDb());
        if (db == null) {
            if (!params.if_exists) {
                throw new CatalogException("Database: " + fName.getDb() + " does not exist.");
            }
            CatalogOpExecutor.addSummary(resp, "Database does not exist.");
            return;
        }
        this.tryLock(db, "dropping function " + fName, catalogTimeline);
        long newCatalogVersion = this.catalog_.incrementAndGetCatalogVersion();
        this.catalog_.getLock().writeLock().unlock();
        try {
            ArrayList removedFunctions = Lists.newArrayList();
            if (!params.isSetSignature()) {
                this.dropJavaFunctionFromHms(fName.getDb(), fName.getFunction(), params.if_exists, catalogTimeline);
                for (Function fn : db.getFunctions(fName.getFunction())) {
                    if (fn.getBinaryType() != TFunctionBinaryType.JAVA || !fn.isPersistent()) continue;
                    Preconditions.checkNotNull((Object)this.catalog_.removeFunction(fn));
                    removedFunctions.add(fn.toTCatalogObject());
                }
            } else {
                ArrayList argTypes = Lists.newArrayList();
                for (TColumnType t : params.arg_types) {
                    argTypes.add(Type.fromThrift(t));
                }
                Function desc = new Function(fName, argTypes, (Type)Type.INVALID, false);
                Function fn = this.catalog_.removeFunction(desc);
                catalogTimeline.markEvent("Removed function in catalog cache");
                if (fn == null) {
                    if (!params.if_exists) {
                        throw new CatalogException("Function: " + desc.signatureString() + " does not exist.");
                    }
                } else {
                    this.addCatalogServiceIdentifiers(db.getMetaStoreDb(), this.catalog_.getCatalogServiceId(), newCatalogVersion);
                    this.applyAlterDatabase(db.getMetaStoreDb(), catalogTimeline);
                    removedFunctions.add(fn.toTCatalogObject());
                    this.catalog_.addVersionsForInflightEvents(db, newCatalogVersion);
                }
            }
            if (!removedFunctions.isEmpty()) {
                CatalogOpExecutor.addSummary(resp, "Function has been dropped.");
                resp.result.setRemoved_catalog_objects(removedFunctions);
            } else {
                CatalogOpExecutor.addSummary(resp, "Function does not exist.");
            }
            resp.result.setVersion(this.catalog_.getCatalogVersion());
        }
        finally {
            db.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(TCreateTableParams params, TDdlExecResponse response, EventSequence catalogTimeline, boolean syncDdl, boolean wantMinimalResult, @Nullable String debugAction) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        TableName tableName = TableName.fromThrift(params.getTable_name());
        Preconditions.checkState((tableName != null && tableName.isFullyQualified() ? 1 : 0) != 0);
        Preconditions.checkState((params.getColumns() != null ? 1 : 0) != 0, (Object)"Null column list given as argument to Catalog.createTable");
        Preconditions.checkState((!this.catalog_.isBlacklistedTable(tableName) ? 1 : 0) != 0, (Object)String.format("Can't create blacklisted table: %s. %s", tableName, BLACKLISTED_TABLES_INCONSISTENT_ERR_STR));
        org.apache.impala.catalog.Table existingTbl = this.catalog_.getTableNoThrow(tableName.getDb(), tableName.getTbl());
        if (params.if_not_exists && existingTbl != null) {
            CatalogOpExecutor.addSummary(response, "Table already exists.");
            LOG.trace("Skipping table creation because {} already exists and IF NOT EXISTS was specified.", (Object)tableName);
            this.tryWriteLock(existingTbl, catalogTimeline);
            try {
                if (syncDdl) {
                    long newVersion = this.catalog_.incrementAndGetCatalogVersion();
                    existingTbl.setCatalogVersion(newVersion);
                    LOG.trace("Table {} version bumped to {} because SYNC_DDL is enabled.", (Object)tableName, (Object)newVersion);
                }
                CatalogOpExecutor.addTableToCatalogUpdate(existingTbl, wantMinimalResult, response.result);
            }
            finally {
                this.catalog_.getLock().writeLock().unlock();
                existingTbl.releaseWriteLock();
            }
            return false;
        }
        org.apache.hadoop.hive.metastore.api.Table tbl = CatalogOpExecutor.createMetaStoreTable(params);
        LOG.trace("Creating table {}", (Object)tableName);
        if (KuduTable.isKuduTable(tbl)) {
            return this.createKuduTable(tbl, params, wantMinimalResult, response, catalogTimeline);
        }
        if (IcebergTable.isIcebergTable(tbl)) {
            return this.createIcebergTable(tbl, wantMinimalResult, response, catalogTimeline, params.if_not_exists, params.getColumns(), params.getPartition_spec(), params.getPrimary_key_column_names(), params.getTable_properties(), params.getComment(), debugAction);
        }
        if (PaimonUtil.isPaimonTable(tbl)) {
            return this.createPaimonTable(tbl, wantMinimalResult, response, catalogTimeline, params, debugAction);
        }
        Preconditions.checkState((params.getColumns().size() > 0 ? 1 : 0) != 0, (Object)"Empty column list given as argument to Catalog.createTable");
        MetastoreShim.setTableLocation(this.catalog_.getDb(tbl.getDbName()), tbl);
        return this.createTable(tbl, params.if_not_exists, params.getCache_op(), params.server_name, params.getPrimary_keys(), params.getForeign_keys(), wantMinimalResult, response, catalogTimeline);
    }

    public static org.apache.hadoop.hive.metastore.api.Table createMetaStoreTable(TCreateTableParams params) {
        Preconditions.checkNotNull((Object)params);
        TableName tableName = TableName.fromThrift(params.getTable_name());
        org.apache.hadoop.hive.metastore.api.Table tbl = new org.apache.hadoop.hive.metastore.api.Table();
        tbl.setDbName(tableName.getDb());
        tbl.setTableName(tableName.getTbl());
        tbl.setOwner(params.getOwner());
        if (params.isSetTable_properties()) {
            tbl.setParameters(params.getTable_properties());
        } else {
            tbl.setParameters(new HashMap());
        }
        if (params.isSetSort_columns() && !params.sort_columns.isEmpty()) {
            tbl.getParameters().put("sort.columns", Joiner.on((String)",").join(params.sort_columns));
            TSortingOrder sortingOrder = params.isSetSorting_order() ? params.sorting_order : TSortingOrder.LEXICAL;
            tbl.getParameters().put("sort.order", sortingOrder.toString());
        }
        if (params.getComment() != null) {
            tbl.getParameters().put("comment", params.getComment());
        }
        if (params.is_external) {
            tbl.setTableType(TableType.EXTERNAL_TABLE.toString());
            tbl.putToParameters("EXTERNAL", "TRUE");
        } else {
            tbl.setTableType(TableType.MANAGED_TABLE.toString());
        }
        if (params.getBucket_info() != null && params.getBucket_info().getBucket_type() != TBucketType.NONE) {
            tbl.getParameters().put("bucketing_version", "2");
        }
        tbl.setSd(CatalogOpExecutor.createSd(params));
        if (params.getPartition_columns() != null) {
            tbl.setPartitionKeys(CatalogOpExecutor.buildFieldSchemaList(params.getPartition_columns()));
        } else {
            tbl.setPartitionKeys(new ArrayList());
        }
        CatalogOpExecutor.setDefaultTableCapabilities(tbl);
        return tbl;
    }

    private static StorageDescriptor createSd(TCreateTableParams params) {
        StorageDescriptor sd = HiveStorageDescriptorFactory.createSd(params.getFile_format(), RowFormat.fromThrift(params.getRow_format()));
        if (params.isSetSerde_properties()) {
            if (sd.getSerdeInfo().getParameters() == null) {
                sd.getSerdeInfo().setParameters(params.getSerde_properties());
            } else {
                sd.getSerdeInfo().getParameters().putAll(params.getSerde_properties());
            }
        }
        if (params.getLocation() != null) {
            sd.setLocation(params.getLocation());
        }
        if (params.getBucket_info() != null && params.getBucket_info().getBucket_type() != TBucketType.NONE) {
            sd.setBucketCols(params.getBucket_info().getBucket_columns());
            sd.setNumBuckets(params.getBucket_info().getNum_bucket());
        }
        sd.setCols(CatalogOpExecutor.buildFieldSchemaList(params.getColumns()));
        return sd;
    }

    private boolean createKuduTable(org.apache.hadoop.hive.metastore.api.Table newTable, TCreateTableParams params, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        boolean createHMSTable;
        long eventId;
        Preconditions.checkState((boolean)KuduTable.isKuduTable(newTable));
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            eventId = this.getCurrentEventId(msClient, catalogTimeline);
        }
        if (!KuduTable.isSynchronizedTable(newTable)) {
            KuduCatalogOpExecutor.populateExternalTableColsFromKudu(catalogTimeline, newTable);
            createHMSTable = true;
        } else {
            KuduCatalogOpExecutor.createSynchronizedTable(catalogTimeline, newTable, params);
            createHMSTable = !this.isKuduHmsIntegrationEnabled(newTable);
        }
        try {
            List<NotificationEvent> events = Collections.emptyList();
            this.acquireMetastoreDdlLock(catalogTimeline);
            if (createHMSTable) {
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    boolean tableInMetastore = msClient.getHiveClient().tableExists(newTable.getDbName(), newTable.getTableName());
                    catalogTimeline.markEvent(CHECKED_HMS_TABLE_EXISTENCE);
                    if (tableInMetastore) {
                        CatalogOpExecutor.addSummary(response, "Table already exists.");
                        boolean bl = false;
                        return bl;
                    }
                    msClient.getHiveClient().createTable(newTable);
                    catalogTimeline.markEvent(CREATED_HMS_TABLE);
                    events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId, newTable.getDbName(), newTable.getTableName(), "CREATE_TABLE");
                }
            }
            long createEventId = -1L;
            Pair<Long, org.apache.hadoop.hive.metastore.api.Table> eventTblPair = this.getTableFromEvents(events, params.if_not_exists);
            createEventId = eventTblPair == null ? -1L : (Long)eventTblPair.first;
            org.apache.hadoop.hive.metastore.api.Table msTable = eventTblPair == null ? null : (org.apache.hadoop.hive.metastore.api.Table)eventTblPair.second;
            this.setTableNameAndCreateTimeInResponse(msTable, newTable.getDbName(), newTable.getTableName(), response, catalogTimeline);
            org.apache.impala.catalog.Table newTbl = this.catalog_.addIncompleteTable(newTable.getDbName(), newTable.getTableName(), TImpalaTableType.TABLE, params.getComment(), createEventId);
            Preconditions.checkNotNull((Object)newTbl);
            catalogTimeline.markEvent(CREATED_CATALOG_TABLE);
            LOG.debug("Created a Kudu table {} with create event id {}", (Object)newTbl.getFullName(), (Object)createEventId);
            CatalogOpExecutor.addTableToCatalogUpdate(newTbl, wantMinimalResult, response.result);
        }
        catch (Exception e) {
            try {
                if (KuduTable.isSynchronizedTable(newTable)) {
                    KuduCatalogOpExecutor.dropTable(newTable, false, 0, catalogTimeline);
                }
            }
            catch (Exception logged) {
                String kuduTableName = (String)newTable.getParameters().get("kudu.table_name");
                LOG.error(String.format("Failed to drop Kudu table '%s'", kuduTableName), (Throwable)logged);
                throw new RuntimeException(String.format("Failed to create the table '%s' in  the Metastore and the newly created Kudu table '%s' could not be  dropped. The log contains more information.", newTable.getTableName(), kuduTableName), e);
            }
            if (e instanceof AlreadyExistsException && params.if_not_exists) {
                CatalogOpExecutor.addSummary(response, "Table already exists.");
                boolean bl = false;
                return bl;
            }
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createTable"), e);
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        CatalogOpExecutor.addSummary(response, "Table has been created.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(org.apache.hadoop.hive.metastore.api.Table newTable, boolean if_not_exists, THdfsCachingOp cacheOp, String serverName, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        block27: {
            org.apache.hadoop.hive.metastore.api.Table msTable;
            Preconditions.checkState((!KuduTable.isKuduTable(newTable) ? 1 : 0) != 0);
            this.acquireMetastoreDdlLock(catalogTimeline);
            Pair<Long, org.apache.hadoop.hive.metastore.api.Table> eventIdTblPair = null;
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                long eventId = this.getCurrentEventId(msClient, catalogTimeline);
                if (primaryKeys == null && foreignKeys == null) {
                    msClient.getHiveClient().createTable(newTable);
                } else {
                    MetastoreShim.createTableWithConstraints(msClient.getHiveClient(), newTable, primaryKeys == null ? Collections.emptyList() : primaryKeys, foreignKeys == null ? Collections.emptyList() : foreignKeys);
                }
                catalogTimeline.markEvent(CREATED_HMS_TABLE);
                CatalogOpExecutor.addSummary(response, "Table has been created.");
                List<NotificationEvent> events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId, newTable.getDbName(), newTable.getTableName(), "CREATE_TABLE");
                eventIdTblPair = this.getTableFromEvents(events, if_not_exists);
                if (eventIdTblPair == null) {
                    eventIdTblPair = new Pair<Long, org.apache.hadoop.hive.metastore.api.Table>(-1L, msClient.getHiveClient().getTable(newTable.getDbName(), newTable.getTableName()));
                    catalogTimeline.markEvent(FETCHED_HMS_TABLE);
                }
                msTable = (org.apache.hadoop.hive.metastore.api.Table)eventIdTblPair.second;
                this.setTableNameAndCreateTimeInResponse(msTable, newTable.getDbName(), newTable.getTableName(), response, catalogTimeline);
                if (newTable.getTableType() == TableType.EXTERNAL_TABLE.toString()) {
                    String tableLocation = newTable.getSd().getLocation();
                    if (tableLocation == null) {
                        tableLocation = msTable.getSd().getLocation();
                    }
                    response.setTable_location(tableLocation);
                }
            }
            catch (Exception e) {
                if (e instanceof AlreadyExistsException && if_not_exists) {
                    CatalogOpExecutor.addSummary(response, "Table already exists");
                    boolean bl = false;
                    this.getMetastoreDdlLock().unlock();
                    return bl;
                }
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createTable"), e);
            }
            org.apache.impala.catalog.Table newTbl = this.catalog_.addIncompleteTable(msTable.getDbName(), msTable.getTableName(), MetastoreShim.mapToInternalTableType(msTable.getTableType()), MetadataOp.getTableComment(msTable), (Long)eventIdTblPair.first);
            Preconditions.checkNotNull((Object)newTbl);
            catalogTimeline.markEvent(CREATED_CATALOG_TABLE);
            LOG.debug("Created catalog table {} with create event id {}", (Object)newTbl.getFullName(), eventIdTblPair.first);
            if (cacheOp != null && cacheOp.isSet_cached()) {
                short replication = cacheOp.isSetReplication() ? cacheOp.getReplication() : (short)1;
                long id = HdfsCachingUtil.submitCacheTblDirective(msTable, cacheOp.getCache_pool_name(), replication);
                this.catalog_.watchCacheDirs(Lists.newArrayList((Object[])new Long[]{id}), new TTableName(msTable.getDbName(), msTable.getTableName()), "CREATE TABLE CACHED");
                this.addCatalogServiceIdentifiers(msTable, this.catalog_.getCatalogServiceId(), newTbl.getCatalogVersion());
                this.applyAlterTable(msTable, true, null, catalogTimeline);
                newTbl.addToVersionsForInflightEvents(false, newTbl.getCatalogVersion());
            }
            CatalogOpExecutor.addTableToCatalogUpdate(newTbl, wantMinimalResult, response.result);
            if (this.authzConfig_.isEnabled()) {
                this.authzManager_.updateTableOwnerPrivilege(serverName, msTable.getDbName(), msTable.getTableName(), null, null, msTable.getOwner(), msTable.getOwnerType(), response);
            }
            break block27;
            finally {
                this.getMetastoreDdlLock().unlock();
            }
        }
        return true;
    }

    private void setTableNameAndCreateTimeInResponse(org.apache.hadoop.hive.metastore.api.Table msTable, String dbName, String tblName, TDdlExecResponse response, EventSequence catalogTimeline) throws TException {
        if (msTable == null) {
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                msTable = msClient.getHiveClient().getTable(dbName, tblName);
                catalogTimeline.markEvent("Fetched table from Metastore to get create time");
            }
        }
        response.setTable_name(dbName + "." + tblName);
        response.setTable_create_time(msTable.getCreateTime());
    }

    private void createView(TCreateOrAlterViewParams params, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        TableName tableName = TableName.fromThrift(params.getView_name());
        Preconditions.checkState((boolean)tableName.isFullyQualified());
        Preconditions.checkState((params.getColumns() != null && params.getColumns().size() > 0 ? 1 : 0) != 0, (Object)"Null or empty column list given as argument to DdlExecutor.createView");
        Preconditions.checkState((!this.catalog_.isBlacklistedTable(tableName) ? 1 : 0) != 0, (Object)String.format("Can't create view with blacklisted table name: %s. %s", tableName, BLACKLISTED_TABLES_INCONSISTENT_ERR_STR));
        if (params.if_not_exists && this.catalog_.containsTable(tableName.getDb(), tableName.getTbl())) {
            LOG.trace(String.format("Skipping view creation because %s already exists and ifNotExists is true.", tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table view = new org.apache.hadoop.hive.metastore.api.Table();
        this.setCreateViewAttributes(params, view);
        LOG.trace(String.format("Creating view %s", tableName));
        if (!this.createTable(view, params.if_not_exists, null, params.server_name, null, null, wantMinimalResult, response, catalogTimeline)) {
            CatalogOpExecutor.addSummary(response, "View already exists.");
        } else {
            CatalogOpExecutor.addSummary(response, "View has been created.");
        }
    }

    private boolean createIcebergTable(org.apache.hadoop.hive.metastore.api.Table newTable, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline, boolean ifNotExists, List<TColumn> columns, TIcebergPartitionSpec partitionSpec, List<String> primaryKeyColumnNames, Map<String, String> tableProperties, String tblComment, @Nullable String debugAction) throws ImpalaException {
        Preconditions.checkState((boolean)IcebergTable.isIcebergTable(newTable));
        this.acquireMetastoreDdlLock(catalogTimeline);
        try {
            List<NotificationEvent> events;
            block36: {
                boolean eventId2;
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    boolean tableInMetastore = msClient.getHiveClient().tableExists(newTable.getDbName(), newTable.getTableName());
                    catalogTimeline.markEvent(CHECKED_HMS_TABLE_EXISTENCE);
                    if (!tableInMetastore) {
                        long eventId2 = this.getCurrentEventId(msClient, catalogTimeline);
                        TIcebergCatalog catalog = IcebergUtil.getTIcebergCatalog(newTable);
                        String location = newTable.getSd().getLocation();
                        if (IcebergTable.isSynchronizedTable(newTable)) {
                            if (location == null) {
                                location = catalog == TIcebergCatalog.HADOOP_CATALOG ? IcebergUtil.getIcebergCatalogLocation(newTable) : MetastoreShim.getPathForNewTable(msClient.getHiveClient().getDatabase(newTable.getDbName()), newTable);
                            }
                            if (debugAction != null) {
                                DebugUtils.executeDebugAction(debugAction, "catalogd_iceberg_create");
                            }
                            String tableLoc = IcebergCatalogOpExecutor.createTable(catalog, IcebergUtil.getIcebergTableIdentifier(newTable), location, columns, partitionSpec, primaryKeyColumnNames, newTable.getOwner(), tableProperties).location();
                            newTable.getSd().setLocation(tableLoc);
                            catalogTimeline.markEvent(CREATED_ICEBERG_TABLE + catalog.name());
                        } else {
                            String locationToLoadFrom;
                            TIcebergCatalog underlyingCatalog = IcebergUtil.getUnderlyingCatalog(newTable);
                            if (underlyingCatalog == TIcebergCatalog.HADOOP_TABLES) {
                                if (location == null) {
                                    CatalogOpExecutor.addSummary(response, "Location is necessary for external iceberg table.");
                                    boolean bl = false;
                                    return bl;
                                }
                                locationToLoadFrom = location;
                            } else {
                                locationToLoadFrom = IcebergUtil.getIcebergCatalogLocation(newTable);
                            }
                            TableIdentifier identifier = IcebergUtil.getIcebergTableIdentifier(newTable);
                            org.apache.iceberg.Table iceTable = IcebergUtil.loadTable(catalog, identifier, locationToLoadFrom, newTable.getParameters());
                            catalogTimeline.markEvent(LOADED_ICEBERG_TABLE);
                            IcebergCatalogOpExecutor.populateExternalTableCols(newTable, iceTable);
                            if (location == null) {
                                newTable.getSd().setLocation(iceTable.location());
                            }
                        }
                        Preconditions.checkState((newTable.getPartitionKeys() == null || newTable.getPartitionKeys().isEmpty() ? 1 : 0) != 0);
                        if (!this.isIcebergHmsIntegrationEnabled(newTable)) {
                            msClient.getHiveClient().createTable(newTable);
                            catalogTimeline.markEvent(CREATED_HMS_TABLE);
                        }
                        events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId2, newTable.getDbName(), newTable.getTableName(), "CREATE_TABLE");
                        break block36;
                    }
                    CatalogOpExecutor.addSummary(response, "Table already exists.");
                    eventId2 = false;
                }
                return eventId2;
            }
            Pair<Long, org.apache.hadoop.hive.metastore.api.Table> eventTblPair = this.getTableFromEvents(events, ifNotExists);
            long createEventId = eventTblPair == null ? -1L : (Long)eventTblPair.first;
            org.apache.hadoop.hive.metastore.api.Table msTable = eventTblPair == null ? null : (org.apache.hadoop.hive.metastore.api.Table)eventTblPair.second;
            this.setTableNameAndCreateTimeInResponse(msTable, newTable.getDbName(), newTable.getTableName(), response, catalogTimeline);
            org.apache.impala.catalog.Table newTbl = this.catalog_.addIncompleteTable(newTable.getDbName(), newTable.getTableName(), TImpalaTableType.TABLE, tblComment, createEventId);
            Preconditions.checkNotNull((Object)newTbl);
            catalogTimeline.markEvent(CREATED_CATALOG_TABLE);
            LOG.debug("Created an iceberg table {} in catalog with create event Id {} ", (Object)newTbl.getFullName(), (Object)createEventId);
            CatalogOpExecutor.addTableToCatalogUpdate(newTbl, wantMinimalResult, response.result);
        }
        catch (Exception e) {
            if (ifNotExists && (e instanceof AlreadyExistsException || e instanceof org.apache.iceberg.exceptions.AlreadyExistsException)) {
                CatalogOpExecutor.addSummary(response, "Table already exists.");
                boolean bl = false;
                return bl;
            }
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createTable"), e);
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        CatalogOpExecutor.addSummary(response, "Table has been created.");
        return true;
    }

    private boolean createPaimonTable(org.apache.hadoop.hive.metastore.api.Table newTable, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline, TCreateTableParams params, @Nullable String debugAction) throws ImpalaException {
        Preconditions.checkState((boolean)PaimonUtil.isPaimonTable(newTable));
        this.acquireMetastoreDdlLock(catalogTimeline);
        try {
            List<NotificationEvent> events;
            block39: {
                boolean eventId2;
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    boolean tableInMetastore = msClient.getHiveClient().tableExists(newTable.getDbName(), newTable.getTableName());
                    catalogTimeline.markEvent(CHECKED_HMS_TABLE_EXISTENCE);
                    if (!tableInMetastore) {
                        long eventId2 = this.getCurrentEventId(msClient, catalogTimeline);
                        String location = newTable.getSd().getLocation();
                        if (PaimonUtil.isSynchronizedTable(newTable)) {
                            if (location == null) {
                                location = PaimonUtil.getPaimonCatalogLocation(msClient, newTable);
                            }
                            if (debugAction != null) {
                                DebugUtils.executeDebugAction(debugAction, "catalogd_paimon_create");
                            }
                            String tableLoc = PaimonCatalogOpExecutor.createTable(PaimonUtil.getTableIdentifier(newTable), location, params, newTable);
                            newTable.getSd().setLocation(tableLoc);
                            catalogTimeline.markEvent("Created table using Paimon Catalog " + newTable.getTableName());
                        } else {
                            String locationToLoadFrom;
                            TPaimonCatalog underlyingCatalog = PaimonUtil.getTPaimonCatalog(newTable);
                            if (underlyingCatalog != TPaimonCatalog.HADOOP_CATALOG && underlyingCatalog != TPaimonCatalog.HIVE_CATALOG) {
                                throw new TableLoadingException("Paimon table only support hadoop catalog and hive catalog.");
                            }
                            if (underlyingCatalog == TPaimonCatalog.HIVE_CATALOG) {
                                if (location == null) {
                                    CatalogOpExecutor.addSummary(response, "Location is necessary for external paimon table with hive catalog.");
                                    boolean bl = false;
                                    return bl;
                                }
                                locationToLoadFrom = location;
                            } else {
                                locationToLoadFrom = PaimonUtil.getPaimonCatalogLocation(msClient, newTable);
                            }
                            try {
                                FileStoreTable paimonTable = PaimonUtil.createFileStoreTable(locationToLoadFrom);
                                PaimonCatalogOpExecutor.populateExternalTableSchemaFromPaimonTable(newTable, (Table)paimonTable);
                                catalogTimeline.markEvent("Loaded paimon table");
                                if (location == null) {
                                    newTable.getSd().setLocation(((DataTable)paimonTable).location().toString());
                                }
                            }
                            catch (Exception ex) {
                                if (newTable.getSd().getCols().isEmpty()) {
                                    throw new PaimonTableLoadingException("Failed to extract paimon schema from underlying paimon table", ex);
                                }
                                String tableLoc = PaimonCatalogOpExecutor.createTable(PaimonUtil.getTableIdentifier(newTable), location, params, newTable);
                                newTable.getSd().setLocation(tableLoc);
                            }
                        }
                        msClient.getHiveClient().createTable(newTable);
                        catalogTimeline.markEvent(CREATED_HMS_TABLE);
                        events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId2, newTable.getDbName(), newTable.getTableName(), "CREATE_TABLE");
                        break block39;
                    }
                    CatalogOpExecutor.addSummary(response, "Table already exists.");
                    eventId2 = false;
                }
                return eventId2;
            }
            Pair<Long, org.apache.hadoop.hive.metastore.api.Table> eventTblPair = this.getTableFromEvents(events, params.if_not_exists);
            long createEventId = eventTblPair == null ? -1L : (Long)eventTblPair.first;
            org.apache.hadoop.hive.metastore.api.Table msTable = eventTblPair == null ? null : (org.apache.hadoop.hive.metastore.api.Table)eventTblPair.second;
            this.setTableNameAndCreateTimeInResponse(msTable, newTable.getDbName(), newTable.getTableName(), response, catalogTimeline);
            org.apache.impala.catalog.Table newTbl = this.catalog_.addIncompleteTable(newTable.getDbName(), newTable.getTableName(), TImpalaTableType.TABLE, params.getComment(), createEventId);
            catalogTimeline.markEvent(CREATED_CATALOG_TABLE);
            LOG.debug("Created an paimon table {} in catalog with create event Id {} ", (Object)newTbl.getFullName(), (Object)createEventId);
            CatalogOpExecutor.addTableToCatalogUpdate(newTbl, wantMinimalResult, response.result);
        }
        catch (Exception e) {
            if (params.if_not_exists && (e instanceof AlreadyExistsException || e instanceof org.apache.iceberg.exceptions.AlreadyExistsException)) {
                CatalogOpExecutor.addSummary(response, "Table already exists.");
                boolean bl = false;
                return bl;
            }
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createTable"), e);
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        CatalogOpExecutor.addSummary(response, "Table has been created.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableLike(TCreateTableLikeParams params, TDdlExecResponse response, EventSequence catalogTimeline, boolean syncDdl, boolean wantMinimalResult, @Nullable String debugAction) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        THdfsFileFormat fileFormat = params.isSetFile_format() ? params.getFile_format() : null;
        String comment = params.isSetComment() ? params.getComment() : null;
        TableName tblName = TableName.fromThrift(params.getTable_name());
        TableName srcTblName = TableName.fromThrift(params.getSrc_table_name());
        Preconditions.checkState((tblName != null && tblName.isFullyQualified() ? 1 : 0) != 0);
        Preconditions.checkState((srcTblName != null && srcTblName.isFullyQualified() ? 1 : 0) != 0);
        Preconditions.checkState((!this.catalog_.isBlacklistedTable(tblName) ? 1 : 0) != 0, (Object)String.format("Can't create blacklisted table: %s. %s", tblName, BLACKLISTED_TABLES_INCONSISTENT_ERR_STR));
        org.apache.impala.catalog.Table existingTbl = this.catalog_.getTableNoThrow(tblName.getDb(), tblName.getTbl());
        if (params.if_not_exists && existingTbl != null) {
            CatalogOpExecutor.addSummary(response, "Table already exists.");
            LOG.trace(String.format("Skipping table creation because %s already exists and IF NOT EXISTS was specified.", tblName));
            this.tryWriteLock(existingTbl, catalogTimeline);
            try {
                if (syncDdl) {
                    long newVersion = this.catalog_.incrementAndGetCatalogVersion();
                    existingTbl.setCatalogVersion(newVersion);
                    LOG.trace("Table {} version bumped to {} because SYNC_DDL is enabled.", (Object)existingTbl.getFullName(), (Object)newVersion);
                }
                CatalogOpExecutor.addTableToCatalogUpdate(existingTbl, wantMinimalResult, response.result);
            }
            finally {
                this.catalog_.getLock().writeLock().unlock();
                existingTbl.releaseWriteLock();
            }
            return;
        }
        org.apache.impala.catalog.Table srcTable = this.getExistingTable(srcTblName.getDb(), srcTblName.getTbl(), "Load source for CREATE TABLE LIKE", catalogTimeline);
        org.apache.hadoop.hive.metastore.api.Table tbl = srcTable.getMetaStoreTable().deepCopy();
        tbl.setDbName(tblName.getDb());
        tbl.setTableName(tblName.getTbl());
        tbl.setOwner(params.getOwner());
        if (tbl.getParameters() == null) {
            tbl.setParameters(new HashMap());
        }
        if (params.isSetSort_columns() && !params.sort_columns.isEmpty()) {
            tbl.getParameters().put("sort.columns", Joiner.on((String)",").join(params.sort_columns));
            TSortingOrder sortingOrder = params.isSetSorting_order() ? params.sorting_order : TSortingOrder.LEXICAL;
            tbl.getParameters().put("sort.order", sortingOrder.toString());
        }
        if (comment != null) {
            tbl.getParameters().put("comment", comment);
        }
        if (params.is_external) {
            tbl.setTableType(TableType.EXTERNAL_TABLE.toString());
            tbl.putToParameters("EXTERNAL", "TRUE");
        } else {
            tbl.setTableType(TableType.MANAGED_TABLE.toString());
            if (tbl.getParameters().containsKey("EXTERNAL")) {
                tbl.getParameters().remove("EXTERNAL");
            }
        }
        if (tbl.getParameters().containsKey("cache_directive_id")) {
            tbl.getParameters().remove("cache_directive_id");
        }
        if (tbl.getParameters().containsKey("cache_replication")) {
            tbl.getParameters().remove("cache_replication");
        }
        tbl.getSd().setLocation(params.getLocation());
        if (fileFormat != null) {
            CatalogOpExecutor.setStorageDescriptorFileFormat(tbl.getSd(), fileFormat);
        } else if (srcTable instanceof View) {
            CatalogOpExecutor.setStorageDescriptorFileFormat(tbl.getSd(), THdfsFileFormat.TEXT);
        }
        tbl.putToParameters("numRows", "-1");
        CatalogOpExecutor.setDefaultTableCapabilities(tbl);
        LOG.trace(String.format("Creating table %s LIKE %s", tblName, srcTblName));
        if (srcTable instanceof IcebergTable && IcebergTable.isIcebergTable(tbl)) {
            IcebergTable srcIceTable = (IcebergTable)srcTable;
            HashMap tableProperties = Maps.newHashMap((Map)srcIceTable.getIcebergApiTable().properties());
            tableProperties.remove("name");
            tableProperties.remove("location");
            tableProperties.remove("iceberg.catalog");
            tableProperties.remove("iceberg.table_identifier");
            TableIdentifier identifier = IcebergUtil.getIcebergTableIdentifier(tbl.getDbName(), tbl.getTableName());
            if (tbl.getParameters().containsKey("name")) {
                tbl.getParameters().put("name", identifier.toString());
                tableProperties.put("name", identifier.toString());
            }
            if (tbl.getParameters().containsKey("iceberg.catalog")) {
                tableProperties.put("iceberg.catalog", tbl.getParameters().get("iceberg.catalog"));
            }
            if (tbl.getParameters().containsKey("iceberg.table_identifier")) {
                tbl.getParameters().put("iceberg.table_identifier", identifier.toString());
                tableProperties.put("iceberg.table_identifier", identifier.toString());
            }
            ArrayList<TColumn> columns = new ArrayList<TColumn>();
            for (Column col : srcIceTable.getColumns()) {
                columns.add(col.toThrift());
            }
            TIcebergPartitionSpec partitionSpec = srcIceTable.getDefaultPartitionSpec().toThrift();
            this.createIcebergTable(tbl, wantMinimalResult, response, catalogTimeline, params.if_not_exists, columns, partitionSpec, Lists.newArrayList((Iterable)srcIceTable.getIcebergSchema().identifierFieldNames()), tableProperties, params.getComment(), debugAction);
        } else if (srcTable instanceof KuduTable && KuduTable.isKuduTable(tbl)) {
            TCreateTableParams createTableParams = this.extractKuduCreateTableParams(params, tblName, (KuduTable)srcTable, tbl);
            this.createKuduTable(tbl, createTableParams, wantMinimalResult, response, catalogTimeline);
        } else {
            MetastoreShim.setTableLocation(this.catalog_.getDb(tbl.getDbName()), tbl);
            this.createTable(tbl, params.if_not_exists, null, params.server_name, null, null, wantMinimalResult, response, catalogTimeline);
        }
    }

    private TCreateTableParams extractKuduCreateTableParams(TCreateTableLikeParams params, TableName tblName, KuduTable kuduTable, org.apache.hadoop.hive.metastore.api.Table tbl) throws ImpalaRuntimeException {
        TCreateTableParams createTableParams = new TCreateTableParams();
        createTableParams.if_not_exists = params.if_not_exists;
        createTableParams.setComment(params.getComment());
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        for (Column col : kuduTable.getColumns()) {
            if (((KuduColumn)col).isAutoIncrementing()) continue;
            columns.add(col.toThrift());
        }
        createTableParams.setColumns(columns);
        ArrayList<String> primaryColumnNames = new ArrayList<String>(kuduTable.getPrimaryKeyColumnNames());
        if (kuduTable.hasAutoIncrementingColumn()) {
            primaryColumnNames.remove(KuduUtil.getAutoIncrementingColumnName());
        }
        createTableParams.setPrimary_key_column_names(primaryColumnNames);
        ArrayList<TKuduPartitionParam> partitionParams = new ArrayList<TKuduPartitionParam>();
        for (KuduPartitionParam kuduPartitionParam : kuduTable.getPartitionBy()) {
            partitionParams.add(kuduPartitionParam.toThrift());
        }
        createTableParams.setPartition_by(partitionParams);
        Map tableProperties = tbl.getParameters();
        tableProperties.remove("kudu.table_name");
        tableProperties.remove("kudu.table_id");
        String kuduMasters = (String)tbl.getParameters().get("kudu.master_addresses");
        boolean isKuduHmsIntegrationEnabled = KuduTable.isHMSIntegrationEnabled(kuduMasters);
        tableProperties.put("kudu.table_name", KuduUtil.getDefaultKuduTableName(tblName.getDb(), tblName.getTbl(), isKuduHmsIntegrationEnabled));
        tbl.setParameters(tableProperties);
        return createTableParams;
    }

    private static void setDefaultTableCapabilities(org.apache.hadoop.hive.metastore.api.Table tbl) {
        if (MetastoreShim.getMajorVersion() > 2L) {
            MetastoreShim.setTableAccessType(tbl, (byte)8);
            if (tbl.getParameters().containsKey(CAPABILITIES_KEY)) {
                return;
            }
            if (AcidUtils.isTransactionalTable(tbl.getParameters())) {
                if (AcidUtils.isFullAcidTable(tbl.getParameters())) {
                    tbl.getParameters().put(CAPABILITIES_KEY, FULLACID_CAPABILITIES);
                } else {
                    tbl.getParameters().put(CAPABILITIES_KEY, ACIDINSERTONLY_CAPABILITIES);
                }
            } else if (!KuduTable.isKuduTable(tbl)) {
                tbl.getParameters().put(CAPABILITIES_KEY, NONACID_CAPABILITIES);
            }
        }
    }

    private void setCreateViewAttributes(TCreateOrAlterViewParams params, org.apache.hadoop.hive.metastore.api.Table view) {
        view.setTableType(TableType.VIRTUAL_VIEW.toString());
        view.setViewOriginalText(params.getOriginal_view_def());
        view.setViewExpandedText(params.getExpanded_view_def());
        view.setDbName(params.getView_name().getDb_name());
        view.setTableName(params.getView_name().getTable_name());
        view.setOwner(params.getOwner());
        if (view.getParameters() == null) {
            view.setParameters(new HashMap());
        }
        if (params.isSetComment() && params.getComment() != null) {
            view.getParameters().put("comment", params.getComment());
        }
        if (params.getTblproperties() != null && params.getTblpropertiesSize() != 0) {
            view.getParameters().putAll(params.getTblproperties());
        }
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(CatalogOpExecutor.buildFieldSchemaList(params.getColumns()));
        sd.setSerdeInfo(new SerDeInfo());
        view.setSd(sd);
    }

    private void setAlterViewAttributes(TCreateOrAlterViewParams params, org.apache.hadoop.hive.metastore.api.Table view) {
        view.setViewOriginalText(params.getOriginal_view_def());
        view.setViewExpandedText(params.getExpanded_view_def());
        if (params.isSetComment() && params.getComment() != null) {
            view.getParameters().put("comment", params.getComment());
        }
        if (params.getTblproperties() != null && params.getTblpropertiesSize() != 0) {
            view.getParameters().putAll(params.getTblproperties());
        }
        view.getSd().setCols(CatalogOpExecutor.buildFieldSchemaList(params.getColumns()));
    }

    private boolean alterTableAddCols(org.apache.impala.catalog.Table tbl, List<TColumn> columns, boolean ifNotExists, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        ArrayList<TColumn> colsToAdd = new ArrayList<TColumn>();
        for (TColumn column : columns) {
            Column col = tbl.getColumn(column.getColumnName());
            if (ifNotExists && col != null) continue;
            if (col != null) {
                throw new CatalogException(String.format("Column '%s' in table '%s' already exists.", col.getName(), tbl.getName()));
            }
            colsToAdd.add(column);
        }
        if (!colsToAdd.isEmpty()) {
            msTbl.getSd().getCols().addAll(CatalogOpExecutor.buildFieldSchemaList(colsToAdd));
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
            return true;
        }
        return false;
    }

    private void alterTableReplaceCols(org.apache.impala.catalog.Table tbl, List<TColumn> columns, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        List<FieldSchema> newColumns = CatalogOpExecutor.buildFieldSchemaList(columns);
        msTbl.getSd().setCols(newColumns);
        String sortByKey = "sort.columns";
        if (msTbl.getParameters().containsKey(sortByKey)) {
            String oldColumns = (String)msTbl.getParameters().get(sortByKey);
            String alteredColumns = MetaStoreUtil.intersectCsvListWithColumNames(oldColumns, columns);
            msTbl.getParameters().put(sortByKey, alteredColumns);
        }
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void alterTableAlterCol(org.apache.impala.catalog.Table tbl, String colName, TColumn newCol, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        Iterator iterator = msTbl.getSd().getColsIterator();
        while (iterator.hasNext()) {
            FieldSchema fs = (FieldSchema)iterator.next();
            if (fs.getName().toLowerCase().equals(colName.toLowerCase())) {
                fs.setName(newCol.getColumnName());
                Type type = Type.fromThrift(newCol.getColumnType());
                fs.setType(type.toSql().toLowerCase());
                if (newCol.getComment() != null) {
                    fs.setComment(newCol.getComment());
                }
                String sortByKey = "sort.columns";
                if (!msTbl.getParameters().containsKey(sortByKey)) break;
                String oldColumns = (String)msTbl.getParameters().get(sortByKey);
                String alteredColumns = MetaStoreUtil.replaceValueInCsvList(oldColumns, colName, newCol.getColumnName());
                msTbl.getParameters().put(sortByKey, alteredColumns);
                break;
            }
            if (iterator.hasNext()) continue;
            throw new ColumnNotFoundException(String.format("Column name %s not found in table %s.", colName, tbl.getFullName()));
        }
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void alterTableAddPartitions(org.apache.impala.catalog.Table tbl, TAlterTableAddPartitionParams addPartParams, THdfsFileFormat fileFormat, EventSequence catalogTimeline, InProgressTableModification modification, String debugAction) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        TableName tableName = tbl.getTableName();
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        boolean ifNotExists = addPartParams.isIf_not_exists();
        ArrayList allHmsPartitionsToAdd = Lists.newArrayList();
        HashMap partitionCachingOpMap = Maps.newHashMap();
        for (TPartitionDef partParams : addPartParams.getPartitions()) {
            THdfsCachingOp cacheOp;
            List<TPartitionKeyValue> partitionSpec = partParams.getPartition_spec();
            if (this.catalog_.containsHdfsPartition(tableName.getDb(), tableName.getTbl(), partitionSpec)) {
                String partitionSpecStr = Joiner.on((String)", ").join(partitionSpec);
                if (!ifNotExists) {
                    throw new ImpalaRuntimeException(String.format("Partition already exists: (%s)", partitionSpecStr));
                }
                LOG.trace(String.format("Skipping partition creation because (%s) already exists and IF NOT EXISTS was specified.", partitionSpecStr));
                continue;
            }
            Partition hmsPartition = this.createHmsPartition(partitionSpec, msTbl, tableName, partParams.getLocation());
            allHmsPartitionsToAdd.add(hmsPartition);
            if (fileFormat != null) {
                CatalogOpExecutor.setStorageDescriptorFileFormat(hmsPartition.getSd(), fileFormat);
            }
            if ((cacheOp = partParams.getCache_op()) == null) continue;
            partitionCachingOpMap.put(hmsPartition.getValues(), cacheOp);
        }
        if (allHmsPartitionsToAdd.isEmpty()) {
            return;
        }
        List<Partition> difference = null;
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            HashMap partitionToEventId = Maps.newHashMap();
            List<Partition> addedHmsPartitions = this.addHmsPartitionsInTransaction(msClient, tbl, allHmsPartitionsToAdd, partitionToEventId, ifNotExists, catalogTimeline, debugAction);
            this.alterTableCachePartitions(msTbl, msClient, tableName, addedHmsPartitions, partitionCachingOpMap, catalogTimeline);
            if (allHmsPartitionsToAdd.size() != addedHmsPartitions.size()) {
                difference = this.computeDifference(allHmsPartitionsToAdd, addedHmsPartitions);
                addedHmsPartitions.addAll(this.getPartitionsFromHms(msTbl, msClient, difference));
            }
            if (addedHmsPartitions.isEmpty() && difference != null) {
                LOG.info("{} partitions already exist in HMS, but unable to be retrieved.", (Object)difference.size());
                return;
            }
            this.addHdfsPartitions(msClient, tbl, addedHmsPartitions, partitionToEventId, catalogTimeline);
        }
        modification.registerInflightEvent();
        modification.updateTableCatalogVersion();
        modification.markInflightEventRegistrationComplete();
    }

    public int addPartitionsIfNotRemovedLater(long eventId, String dbName, String tblName, List<Partition> partitions, String reason) throws CatalogException {
        org.apache.impala.catalog.Table table;
        try {
            table = this.catalog_.getTable(dbName, tblName);
        }
        catch (DatabaseNotFoundException e) {
            LOG.info("EventId: {} Not adding partitions since the database {} does not exist anymore.", (Object)eventId, (Object)dbName);
            return 0;
        }
        if (table == null) {
            LOG.info("EventId: {} Not adding partitions since the table {}.{} does not exist anymore.", new Object[]{eventId, dbName, tblName});
            return 0;
        }
        if (table instanceof IncompleteTable) {
            LOG.info("EventId: {} Table {} is not loaded. Skipping add partitions", (Object)eventId, (Object)table.getFullName());
            return 0;
        }
        if (table instanceof IcebergTable) {
            LOG.info("EventId: {} Table {} is an Iceberg table. Partitioning is handled by Iceberg. Skipping add partitions", (Object)eventId, (Object)table.getFullName());
            return 0;
        }
        if (!(table instanceof HdfsTable)) {
            throw new CatalogException("Partition event " + eventId + " received on a non-hdfs table");
        }
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        try {
            this.tryWriteLock(table, reason, NoOpEventSequence.INSTANCE);
            if (syncToLatestEventId && table.getLastSyncedEventId() >= eventId) {
                LOG.info("Not adding partitions from event id: {} since table {} is already synced till event id {}", new Object[]{eventId, table.getFullName(), table.getLastSyncedEventId()});
                int n = 0;
                return n;
            }
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            HdfsTable hdfsTable = (HdfsTable)table;
            List<Partition> partitionsToAdd = this.filterPartitionsToAddFromEvent(eventId, hdfsTable, partitions);
            int partitionsAdded = 0;
            if (!partitionsToAdd.isEmpty()) {
                LOG.debug("Found {}/{} partitions to add in table {} from event {}", new Object[]{partitionsToAdd.size(), partitions.size(), table.getFullName(), eventId});
                HashMap partToEventId = Maps.newHashMap();
                for (Partition part : partitionsToAdd) {
                    partToEventId.put(FeCatalogUtils.getPartitionName(hdfsTable, part.getValues()), eventId);
                }
                try (MetaStoreClientPool.MetaStoreClient metaStoreClient = this.catalog_.getMetaStoreClient();){
                    this.addHdfsPartitions(metaStoreClient, table, partitionsToAdd, partToEventId, NoOpEventSequence.INSTANCE);
                }
                modification.updateTableCatalogVersion();
                partitionsAdded = partitionsToAdd.size();
            }
            if (syncToLatestEventId) {
                table.setLastSyncedEventId(eventId);
            }
            modification.validateInProgressModificationComplete();
            int n = partitionsAdded;
            return n;
        }
        catch (UnsupportedEncodingException | InternalException e) {
            throw new CatalogException("Unable to add partition for table " + table.getFullName(), e);
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
    }

    private List<Partition> filterPartitionsToAddFromEvent(long eventId, HdfsTable hdfsTable, List<Partition> partitions) throws UnsupportedEncodingException, CatalogException {
        Preconditions.checkNotNull((Object)hdfsTable);
        ArrayList partsToBeAdded = Lists.newArrayList();
        org.apache.hadoop.hive.metastore.api.Table msTbl = hdfsTable.getMetaStoreTable();
        DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
        if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getDbKey(msTbl.getDbName()))) {
            LOG.info("EventId: {} Not adding partitions since the database {} was removed later", (Object)eventId, (Object)msTbl.getDbName());
            return partsToBeAdded;
        }
        if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getTblKey(msTbl.getDbName(), msTbl.getTableName()))) {
            LOG.info("EventId: {} Not adding partitions since the table {} was removed later", (Object)eventId, (Object)hdfsTable.getFullName());
            return partsToBeAdded;
        }
        Preconditions.checkState((!partitions.isEmpty() ? 1 : 0) != 0);
        for (Partition part : partitions) {
            List<LiteralExpr> partExprs = FeCatalogUtils.parsePartitionKeyValues(hdfsTable, part.getValues());
            HdfsPartition hdfsPartition = hdfsTable.getPartition(partExprs);
            if (hdfsPartition != null) continue;
            boolean removed = deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getPartitionKey(hdfsTable, part.getValues()));
            if (removed) {
                LOG.info("EventId: {} Skipping addition of partition {} since it was removed later in catalog for table {}", new Object[]{eventId, FileUtils.makePartName(hdfsTable.getClusteringColNames(), (List)part.getValues()), hdfsTable.getFullName()});
                continue;
            }
            partsToBeAdded.add(part);
        }
        return partsToBeAdded;
    }

    public int removePartitionsIfNotAddedLater(long eventId, String dbName, String tblName, List<Map<String, String>> droppedPartitions, String reason) throws CatalogException {
        org.apache.impala.catalog.Table table;
        try {
            table = this.catalog_.getTable(dbName, tblName);
        }
        catch (DatabaseNotFoundException e) {
            LOG.info("EventId: {} Not removing partitions since the database {} does not exist anymore.", (Object)eventId, (Object)dbName);
            return 0;
        }
        if (table == null) {
            LOG.info("EventId: {} Not dropping partitions since the table {}.{} does not exist anymore", new Object[]{eventId, dbName, tblName});
            return 0;
        }
        if (table instanceof IncompleteTable) {
            LOG.info("EventId: {} Table {} is not loaded. Not processing the event.", (Object)eventId, (Object)table.getFullName());
            return 0;
        }
        if (!(table instanceof HdfsTable)) {
            throw new CatalogException("Partition event received on a non-hdfs table");
        }
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        boolean errorOccured = false;
        try {
            this.tryWriteLock(table, reason, NoOpEventSequence.INSTANCE);
            if (syncToLatestEventId && table.getLastSyncedEventId() >= eventId) {
                LOG.info("Not dropping partitions from event id: {} since table {} is already synced till event id {}", new Object[]{eventId, table.getFullName(), table.getLastSyncedEventId()});
                int n = 0;
                return n;
            }
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            HdfsTable hdfsTable = (HdfsTable)table;
            if (eventId <= hdfsTable.getCreateEventId()) {
                LOG.info("EventId: {} Not dropping partitions table's create event id is {}", (Object)eventId, (Object)hdfsTable.getCreateEventId());
                int n = 0;
                return n;
            }
            ArrayList skippedPartitions = Lists.newArrayList();
            for (Map<String, String> partKeyVals : droppedPartitions) {
                if (this.canDropPartitionFromEvent(eventId, hdfsTable, Lists.newArrayList(partKeyVals.values()))) continue;
                skippedPartitions.add(partKeyVals);
            }
            droppedPartitions.removeAll(skippedPartitions);
            if (droppedPartitions.isEmpty()) {
                int n = 0;
                return n;
            }
            LOG.info("EventId: {} Skipping removal of {}/{} partitions since they don't exist or were created later in table {}.", new Object[]{eventId, skippedPartitions.size(), droppedPartitions.size(), table.getFullName()});
            ArrayList allTPartKeyVals = Lists.newArrayListWithCapacity((int)droppedPartitions.size());
            List<Column> partitionCols = hdfsTable.getClusteringColumns();
            for (Map<String, String> droppedPartitionKeyVals : droppedPartitions) {
                ArrayList tPartKeyVals = Lists.newArrayListWithCapacity((int)partitionCols.size());
                for (Column partitionCol : partitionCols) {
                    String val = droppedPartitionKeyVals.get(partitionCol.getName());
                    if (val == null) {
                        throw new CatalogException(String.format("Event does not contain partition value for key %s. Event contains %s", partitionCol.getName(), Joiner.on((String)",").withKeyValueSeparator("=").join(droppedPartitionKeyVals)));
                    }
                    tPartKeyVals.add(new TPartitionKeyValue(partitionCol.getName(), val));
                }
                allTPartKeyVals.add(tPartKeyVals);
            }
            Preconditions.checkState((!allTPartKeyVals.isEmpty() ? 1 : 0) != 0);
            this.catalog_.dropPartitions(table, allTPartKeyVals);
            modification.updateTableCatalogVersion();
            modification.validateInProgressModificationComplete();
            int n = allTPartKeyVals.size();
            return n;
        }
        catch (InternalException e) {
            errorOccured = true;
            throw new CatalogException("Unable to add partition for table " + table.getFullName(), e);
        }
        finally {
            if (!errorOccured && syncToLatestEventId && table.getLastSyncedEventId() < eventId) {
                table.setLastSyncedEventId(eventId);
            }
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
    }

    private boolean canDropPartitionFromEvent(long eventId, HdfsTable hdfsTable, List<String> values) throws CatalogException {
        List<LiteralExpr> partExprs = FeCatalogUtils.parsePartitionKeyValues(hdfsTable, values);
        HdfsPartition hdfsPartition = hdfsTable.getPartition(partExprs);
        if (hdfsPartition == null) {
            return false;
        }
        boolean isStale = hdfsPartition.getCreateEventId() > eventId;
        LOG.info("{} partition {} of table {} since it's create event id {} is {} than eventid {}", new Object[]{isStale ? "Not dropping" : "Dropping", hdfsPartition.getPartitionName(), hdfsTable.getFullName(), hdfsPartition.getCreateEventId(), isStale ? "higher" : "not higher", eventId});
        return !isStale;
    }

    public int reloadPartitionsIfExist(long eventId, String eventType, String dbName, String tblName, List<Partition> partsFromEvent, String reason, FileMetadataLoadOpts fileMetadataLoadOpts) throws CatalogException {
        ArrayList<String> partNames = new ArrayList<String>();
        org.apache.impala.catalog.Table table = this.catalog_.getTable(dbName, tblName);
        if (table instanceof HdfsTable) {
            HdfsTable hdfsTable = (HdfsTable)table;
            for (Partition part : partsFromEvent) {
                partNames.add(FileUtils.makePartName(hdfsTable.getClusteringColNames(), (List)part.getValues(), null));
            }
        }
        return this.reloadPartitionsFromNamesIfExists(eventId, eventType, dbName, tblName, partNames, reason, fileMetadataLoadOpts);
    }

    public int reloadPartitionsFromNamesIfExists(long eventId, String eventType, String dbName, String tblName, List<String> partNames, String reason, FileMetadataLoadOpts fileMetadataLoadOpts) throws CatalogException {
        org.apache.impala.catalog.Table table = this.catalog_.getTable(dbName, tblName);
        if (table == null) {
            DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
            if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getTblKey(dbName, tblName))) {
                LOG.info("EventId: {} EventType: {} Not reloading the partition of table {}.{} since it was removed later in catalog", new Object[]{eventId, eventType, dbName, tblName});
                return -1;
            }
            throw new TableNotFoundException("Table " + dbName + "." + tblName + " not found");
        }
        if (table instanceof IncompleteTable) {
            LOG.info("Table {} is not loaded. Skipping {} event {}", new Object[]{table.getFullName(), eventType, eventId});
            return 0;
        }
        if (!(table instanceof HdfsTable)) {
            throw new CatalogException("Partition event received on a non-hdfs table");
        }
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        boolean errorOccured = false;
        try {
            int numOfPartsReloaded;
            if (DebugUtils.hasDebugAction(BackendConfig.INSTANCE.debugActions(), "mock_write_lock_failure")) {
                int n = 0;
                return n;
            }
            this.tryWriteLock(table, reason, NoOpEventSequence.INSTANCE);
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            if (syncToLatestEventId && table.getLastSyncedEventId() >= eventId) {
                LOG.info("EventId: {} EventType: {} Not reloading partition since table {} is already synced till event id {}", new Object[]{eventId, eventType, table.getFullName(), table.getLastSyncedEventId()});
                int n = 0;
                return n;
            }
            HdfsTable hdfsTable = (HdfsTable)table;
            try (MetaStoreClientPool.MetaStoreClient metaStoreClient = this.catalog_.getMetaStoreClient();){
                numOfPartsReloaded = hdfsTable.reloadPartitionsFromNames(eventId, metaStoreClient.getHiveClient(), partNames, reason, fileMetadataLoadOpts);
            }
            modification.updateTableCatalogVersion();
            modification.validateInProgressModificationComplete();
            int n = numOfPartsReloaded;
            return n;
        }
        catch (TableLoadingException e) {
            LOG.info("EventId: {} EventType: {} Could not reload {} partitions of table {}", new Object[]{eventId, eventType, partNames.size(), table.getFullName(), e});
        }
        catch (InternalException e) {
            errorOccured = true;
            throw new CatalogException("Could not acquire lock on the table " + table.getFullName(), e);
        }
        finally {
            if (!errorOccured && syncToLatestEventId && table.getLastSyncedEventId() < eventId) {
                table.setLastSyncedEventId(eventId);
            }
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
        return 0;
    }

    public int reloadPartitionsFromEvent(long eventId, String dbName, String tblName, List<Partition> partsFromEvent, String reason) throws CatalogException {
        org.apache.impala.catalog.Table table = this.catalog_.getTable(dbName, tblName);
        if (table == null) {
            DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
            if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getTblKey(dbName, tblName))) {
                LOG.info("Not reloading the partition of table {} since it was removed later in catalog", (Object)new TableName(dbName, tblName));
                return -1;
            }
            throw new TableNotFoundException("Table " + dbName + "." + tblName + " not found");
        }
        if (table instanceof IncompleteTable) {
            LOG.info("Table {} is not loaded. Skipping drop partition event {}", (Object)table.getFullName(), (Object)eventId);
            return -1;
        }
        if (!(table instanceof HdfsTable)) {
            throw new CatalogException("Partition event received on a non-hdfs table");
        }
        if (eventId > 0L && eventId <= table.getCreateEventId()) {
            LOG.debug("Not reloading partitions of table {}.{} for event {} since it is recreated at event {}.", new Object[]{dbName, tblName, eventId, table.getCreateEventId()});
            return -1;
        }
        try {
            int numOfPartsReloaded;
            this.tryWriteLock(table, reason, NoOpEventSequence.INSTANCE);
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            HdfsTable hdfsTable = (HdfsTable)table;
            try (MetaStoreClientPool.MetaStoreClient metaStoreClient = this.catalog_.getMetaStoreClient();){
                numOfPartsReloaded = hdfsTable.reloadPartitionsFromEvent(eventId, metaStoreClient.getHiveClient(), partsFromEvent, false, reason);
            }
            modification.updateTableCatalogVersion();
            modification.validateInProgressModificationComplete();
            int n = numOfPartsReloaded;
            return n;
        }
        catch (InternalException e) {
            throw new CatalogException("Could not acquire lock on the table " + table.getFullName(), e);
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
    }

    public int addCommittedWriteIdsAndReloadPartitionsIfExist(long eventId, String dbName, String tblName, List<Long> writeIds, List<Partition> partsFromEvent, String reason) throws CatalogException {
        org.apache.impala.catalog.Table table = this.catalog_.getTable(dbName, tblName);
        if (table == null) {
            DeleteEventLog deleteEventLog = this.catalog_.getMetastoreEventProcessor().getDeleteEventLog();
            if (deleteEventLog.wasRemovedAfter(eventId, DeleteEventLog.getTblKey(dbName, tblName))) {
                LOG.info("Not reloading partitions of table {} for event {} since it was removed later in catalog", (Object)new TableName(dbName, tblName), (Object)eventId);
                return 0;
            }
            throw new TableNotFoundException("Table " + dbName + "." + tblName + " not found");
        }
        if (table instanceof IncompleteTable) {
            LOG.info("Table {} is not loaded. Skipping partition event {}", (Object)table.getFullName(), (Object)eventId);
            return -1;
        }
        if (!(table instanceof HdfsTable)) {
            throw new CatalogException("Partition event received on a non-hdfs table");
        }
        HdfsTable hdfsTable = (HdfsTable)table;
        ValidWriteIdList previousWriteIdList = hdfsTable.getValidWriteIds();
        try {
            int numOfPartsReloaded;
            this.tryWriteLock(table, reason, NoOpEventSequence.INSTANCE);
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, hdfsTable);
            this.catalog_.getLock().writeLock().unlock();
            boolean syncToLatestEvent = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
            if (hdfsTable.getLastSyncedEventId() > eventId) {
                LOG.info("EventId: {}, Skipping addition of committed writeIds and partitions reload for table {} since it is already synced till eventId: {}", new Object[]{eventId, hdfsTable.getFullName(), hdfsTable.getLastSyncedEventId()});
                int n = 0;
                return n;
            }
            Preconditions.checkState((previousWriteIdList != null ? 1 : 0) != 0, (String)"Write id list of table %s should not be null", (Object)table.getFullName());
            previousWriteIdList = MetastoreShim.getValidWriteIdListFromString(previousWriteIdList.toString());
            ArrayList<Partition> partsToRefresh = new ArrayList<Partition>();
            ArrayList<Long> writeIdsToRefresh = new ArrayList<Long>();
            ListIterator<Partition> it = partsFromEvent.listIterator();
            while (it.hasNext()) {
                long writeId = writeIds.get(it.nextIndex());
                Partition part = it.next();
                Preconditions.checkState((!previousWriteIdList.isWriteIdAborted(writeId) ? 1 : 0) != 0, (String)"Write id %d of Table %s should not be aborted", (long)writeId, (Object)table.getFullName());
                if (previousWriteIdList.isWriteIdValid(writeId)) continue;
                MetastoreShim.setWriteIdToMSPartition(part, writeId);
                partsToRefresh.add(part);
                writeIdsToRefresh.add(writeId);
            }
            if (partsToRefresh.isEmpty()) {
                LOG.info("Not reloading partitions of table {} for event {} since the cache is already up-to-date", (Object)table.getFullName(), (Object)eventId);
                if (syncToLatestEvent) {
                    hdfsTable.setLastSyncedEventId(eventId);
                }
                int writeId = 0;
                return writeId;
            }
            hdfsTable.addWriteIds(writeIdsToRefresh, MutableValidWriteIdList.WriteIdStatus.COMMITTED);
            try (MetaStoreClientPool.MetaStoreClient metaStoreClient = this.catalog_.getMetaStoreClient();){
                numOfPartsReloaded = hdfsTable.reloadPartitionsFromEvent(eventId, metaStoreClient.getHiveClient(), partsToRefresh, true, reason);
            }
            modification.updateTableCatalogVersion();
            if (syncToLatestEvent) {
                hdfsTable.setLastSyncedEventId(eventId);
            }
            modification.validateInProgressModificationComplete();
            int n = numOfPartsReloaded;
            return n;
        }
        catch (InternalException e) {
            throw new CatalogException("Could not acquire lock on the table " + table.getFullName(), e);
        }
        catch (Exception e) {
            LOG.info("Rolling back the write id list of table {} because reloading for event {} is failed: {}", new Object[]{table.getFullName(), eventId, e.getMessage()});
            hdfsTable.setValidWriteIds(previousWriteIdList);
            throw e;
        }
        finally {
            this.UnlockWriteLockIfErronouslyLocked();
            if (table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
    }

    public ReentrantLock getMetastoreDdlLock() {
        return this.metastoreDdlLock_;
    }

    private void acquireMetastoreDdlLock(EventSequence catalogTimeline) {
        this.metastoreDdlLock_.lock();
        catalogTimeline.markEvent(GOT_METASTORE_DDL_LOCK);
    }

    private List<Partition> addHmsPartitions(MetaStoreClientPool.MetaStoreClient msClient, org.apache.impala.catalog.Table tbl, List<Partition> allHmsPartitionsToAdd, Map<String, Long> partitionToEventId, boolean ifNotExists, EventSequence catalogTimeline) throws ImpalaRuntimeException, CatalogException {
        long eventId = this.getCurrentEventId(msClient, catalogTimeline);
        ArrayList addedHmsPartitions = Lists.newArrayListWithCapacity((int)allHmsPartitionsToAdd.size());
        long numDone = 0L;
        for (List hmsSublist : Lists.partition(allHmsPartitionsToAdd, (int)500)) {
            try {
                List<Partition> addedPartitions = MetaStoreUtil.addPartitions(msClient.getHiveClient(), tbl.getMetaStoreTable(), hmsSublist, ifNotExists, true);
                catalogTimeline.markEvent(String.format("Added %d partitions in Metastore", numDone += (long)hmsSublist.size()));
                LOG.info("Added {}/{} partitions in HMS for table {}", new Object[]{numDone, allHmsPartitionsToAdd.size(), tbl.getFullName()});
                org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable();
                List<NotificationEvent> events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, eventId, msTbl.getDbName(), msTbl.getTableName(), "ADD_PARTITION");
                HashMap partitionToEventSubMap = Maps.newHashMap();
                this.getPartitionsFromEvent(events, partitionToEventSubMap);
                if (!events.isEmpty()) {
                    eventId = events.get(events.size() - 1).getEventId();
                }
                if (partitionToEventSubMap.isEmpty()) {
                    addedHmsPartitions.addAll(addedPartitions);
                    continue;
                }
                addedHmsPartitions.addAll(partitionToEventSubMap.keySet());
                for (Partition part : partitionToEventSubMap.keySet()) {
                    partitionToEventId.put(FeCatalogUtils.getPartitionName((FeFsTable)((Object)tbl), part.getValues()), (Long)partitionToEventSubMap.get(part));
                }
            }
            catch (MetastoreNotificationException | TException e) {
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "add_partitions"), e);
            }
        }
        return addedHmsPartitions;
    }

    private List<Partition> addHmsPartitionsInTransaction(MetaStoreClientPool.MetaStoreClient msClient, org.apache.impala.catalog.Table tbl, List<Partition> partitions, Map<String, Long> partitionToEventId, boolean ifNotExists, EventSequence catalogTimeline, String debugAction) throws ImpalaException {
        if (!AcidUtils.isTransactionalTable(tbl)) {
            if (DebugUtils.hasDebugAction(debugAction, "enable_event_processor")) {
                this.catalog_.startEventsProcessor();
            }
            return this.addHmsPartitions(msClient, tbl, partitions, partitionToEventId, ifNotExists, catalogTimeline);
        }
        try (Transaction txn = new Transaction(msClient.getHiveClient(), this.catalog_.getAcidUserId(), String.format("ADD PARTITION for %s", tbl.getFullName()));){
            MetastoreShim.allocateTableWriteId(msClient.getHiveClient(), txn.getId(), tbl.getDb().getName(), tbl.getName());
            List<Partition> ret = this.addHmsPartitions(msClient, tbl, partitions, partitionToEventId, ifNotExists, catalogTimeline);
            txn.commit();
            List<Partition> list = ret;
            return list;
        }
    }

    private List<Partition> computeDifference(List<Partition> aList, List<Partition> bList) {
        HashSet bSet = Sets.newHashSet();
        for (Partition b : bList) {
            bSet.add(b.getValues());
        }
        ArrayList diffList = Lists.newArrayList();
        for (Partition a : aList) {
            if (bSet.contains(a.getValues())) continue;
            diffList.add(a);
        }
        return diffList;
    }

    private List<Partition> getPartitionsFromHms(org.apache.hadoop.hive.metastore.api.Table msTbl, MetaStoreClientPool.MetaStoreClient msClient, List<Partition> hmsPartitions) throws ImpalaException {
        ArrayList partitionCols = Lists.newArrayList();
        for (Object fs : msTbl.getPartitionKeys()) {
            partitionCols.add(fs.getName());
        }
        ArrayList partitionNames = Lists.newArrayListWithCapacity((int)hmsPartitions.size());
        for (Partition part : hmsPartitions) {
            String partName = FileUtils.makePartName((List)partitionCols, (List)part.getValues());
            partitionNames.add(partName);
        }
        try {
            return MetaStoreUtil.fetchPartitionsByName(msClient.getHiveClient(), partitionNames, msTbl);
        }
        catch (TException e) {
            throw new ImpalaRuntimeException("Metadata inconsistency has occured. Please run 'invalidate metadata <tablename>' to resolve the problem.", e);
        }
    }

    private void alterTableCachePartitions(org.apache.hadoop.hive.metastore.api.Table msTbl, MetaStoreClientPool.MetaStoreClient msClient, TableName tableName, List<Partition> hmsPartitions, Map<List<String>, THdfsCachingOp> partitionCachingOpMap, EventSequence catalogTimeline) throws ImpalaException {
        ArrayList cacheIds = Lists.newArrayList();
        ArrayList hmsPartitionsToCache = Lists.newArrayList();
        Long parentTblCacheDirId = HdfsCachingUtil.getCacheDirectiveId(msTbl.getParameters());
        for (Partition partition : hmsPartitions) {
            THdfsCachingOp cacheOp = partitionCachingOpMap.get(partition.getValues());
            String cachePoolName = null;
            Short replication = null;
            if (cacheOp == null && parentTblCacheDirId != null) {
                cachePoolName = HdfsCachingUtil.getCachePool(parentTblCacheDirId);
                Preconditions.checkNotNull((Object)cachePoolName);
                replication = HdfsCachingUtil.getCacheReplication(parentTblCacheDirId);
                Preconditions.checkNotNull((Object)replication);
            } else if (cacheOp != null && cacheOp.isSet_cached()) {
                cachePoolName = cacheOp.getCache_pool_name();
                replication = !cacheOp.isSetReplication() && parentTblCacheDirId != null ? HdfsCachingUtil.getCacheReplication(parentTblCacheDirId) : Short.valueOf(HdfsCachingUtil.getReplicationOrDefault(cacheOp));
            }
            if (cachePoolName == null) continue;
            Preconditions.checkNotNull(replication);
            long id = HdfsCachingUtil.submitCachePartitionDirective(partition, cachePoolName, (short)replication);
            cacheIds.add(id);
            hmsPartitionsToCache.add(partition);
        }
        if (!cacheIds.isEmpty()) {
            for (Partition part : hmsPartitionsToCache) {
                this.addCatalogServiceIdentifiers(msTbl, part);
            }
            this.applyAlterHmsPartitions(msClient, tableName, hmsPartitionsToCache, catalogTimeline);
            this.catalog_.watchCacheDirs(cacheIds, tableName.toThrift(), "ALTER TABLE CACHE PARTITIONS");
        }
    }

    private void alterTableDropPartition(org.apache.impala.catalog.Table tbl, List<List<TPartitionKeyValue>> partitionSet, boolean ifExists, boolean purge, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        Preconditions.checkNotNull(partitionSet);
        TableName tableName = tbl.getTableName();
        if (!ifExists) {
            Preconditions.checkState((!partitionSet.isEmpty() ? 1 : 0) != 0);
        } else if (partitionSet.isEmpty()) {
            LOG.trace(String.format("Ignoring empty partition list when dropping partitions from %s because ifExists is true.", tableName));
            return;
        }
        Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable));
        List<HdfsPartition> parts = ((HdfsTable)tbl).getPartitionsFromPartitionSet(partitionSet);
        if (!ifExists && parts.isEmpty()) {
            throw new PartitionNotFoundException("The partitions being dropped don't exist any more");
        }
        PartitionDropOptions dropOptions = PartitionDropOptions.instance();
        dropOptions.purgeData(purge);
        long numTargetedPartitions = 0L;
        HashMap droppedPartsFromEvent = Maps.newHashMap();
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            long currentEventId = this.getCurrentEventId(msClient, catalogTimeline);
            for (HdfsPartition part : parts) {
                try {
                    msClient.getHiveClient().dropPartition(tableName.getDb(), tableName.getTbl(), part.getPartitionValuesAsStrings(true), dropOptions);
                    LOG.info("Dropped partition {}.{}:{} in Metastore", new Object[]{tableName.getDb(), tableName.getTbl(), part.getPartitionName()});
                    ++numTargetedPartitions;
                }
                catch (NoSuchObjectException e) {
                    if (!ifExists) {
                        throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropPartition"), e);
                    }
                    LOG.trace(String.format("Ignoring '%s' when dropping partitions from %s because ifExists is true.", new Object[]{e, tableName}));
                }
                catalogTimeline.markEvent("Dropped partitions in Metastore");
            }
            List<NotificationEvent> events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, currentEventId, tableName.getDb(), tableName.getTbl(), "DROP_PARTITION");
            this.addDroppedPartitionsFromEvent(((HdfsTable)tbl).getClusteringColNames(), events, droppedPartsFromEvent);
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropPartition"), e);
        }
        numUpdatedPartitions.setRef(numTargetedPartitions);
        this.catalog_.dropPartitions(tbl, partitionSet);
        for (Map.Entry eventToPartitionNames : droppedPartsFromEvent.entrySet()) {
            Preconditions.checkState((((List)eventToPartitionNames.getValue()).size() == 1 ? 1 : 0) != 0);
            this.addToDeleteEventLog((Long)eventToPartitionNames.getKey(), DeleteEventLog.getPartitionKey((HdfsTable)tbl, (List)((List)eventToPartitionNames.getValue()).get(0)));
        }
        modification.updateTableCatalogVersion();
    }

    private void alterTableDropCol(org.apache.impala.catalog.Table tbl, String colName, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        Iterator iterator = msTbl.getSd().getColsIterator();
        while (iterator.hasNext()) {
            FieldSchema fs = (FieldSchema)iterator.next();
            if (fs.getName().toLowerCase().equals(colName.toLowerCase())) {
                iterator.remove();
                break;
            }
            if (iterator.hasNext()) continue;
            throw new ColumnNotFoundException(String.format("Column name %s not found in table %s.", colName, tbl.getFullName()));
        }
        String sortByKey = "sort.columns";
        if (msTbl.getParameters().containsKey(sortByKey)) {
            String oldColumns = (String)msTbl.getParameters().get(sortByKey);
            String alteredColumns = MetaStoreUtil.removeValueFromCsvList(oldColumns, colName);
            msTbl.getParameters().put(sortByKey, alteredColumns);
        }
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void alterTableOrViewRename(org.apache.impala.catalog.Table oldTbl, TableName newTableName, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline, @Nullable String debugAction) throws ImpalaException {
        boolean needsHmsAlterTable;
        boolean isSynchronizedIcebergTable;
        Preconditions.checkState((boolean)oldTbl.isWriteLockedByCurrentThread());
        TableName tableName = oldTbl.getTableName();
        org.apache.hadoop.hive.metastore.api.Table msTbl = oldTbl.getMetaStoreTable().deepCopy();
        msTbl.setDbName(newTableName.getDb());
        msTbl.setTableName(newTableName.getTbl());
        long eventId = -1L;
        if (this.catalog_.isEventProcessingEnabled()) {
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                eventId = this.getCurrentEventId(msClient, catalogTimeline);
            }
        }
        boolean isSynchronizedKuduTable = oldTbl instanceof KuduTable && KuduTable.isSynchronizedTable(msTbl);
        boolean integratedHmsTable = this.isHmsIntegrationAutomatic(msTbl);
        if (isSynchronizedKuduTable) {
            Preconditions.checkState((boolean)KuduTable.isKuduTable(msTbl));
            this.renameManagedKuduTable((KuduTable)oldTbl, msTbl, newTableName, integratedHmsTable, catalogTimeline);
        }
        boolean bl = isSynchronizedIcebergTable = oldTbl instanceof IcebergTable && IcebergTable.isSynchronizedTable(msTbl);
        if (isSynchronizedIcebergTable) {
            this.renameManagedIcebergTable((IcebergTable)oldTbl, msTbl, newTableName);
            catalogTimeline.markEvent("Renamed table in Iceberg");
        }
        boolean isSynchronizedTable = isSynchronizedKuduTable || isSynchronizedIcebergTable;
        boolean bl2 = needsHmsAlterTable = !isSynchronizedTable || !integratedHmsTable;
        if (needsHmsAlterTable) {
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                org.apache.impala.catalog.Table.updateTimestampProperty(msTbl, "transient_lastDdlTime");
                msClient.getHiveClient().alter_table(tableName.getDb(), tableName.getTbl(), msTbl);
                if (debugAction != null) {
                    DebugUtils.executeDebugAction(debugAction, "catalogd_table_rename_delay");
                }
                catalogTimeline.markEvent("Renamed table in Metastore");
            }
            catch (TException e) {
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "alter_table"), e);
            }
        }
        eventId = this.trackAlterTableRenameEvent(tableName, newTableName, eventId, catalogTimeline);
        Pair<org.apache.impala.catalog.Table, org.apache.impala.catalog.Table> result = this.catalog_.renameTable(tableName.toThrift(), newTableName.toThrift(), eventId);
        Preconditions.checkNotNull(result);
        Pair<TCatalogObject, TCatalogObject> objs = this.handleCatalogRenameResult(oldTbl, newTableName, wantMinimalResult, result, eventId, catalogTimeline);
        response.result.addToRemoved_catalog_objects((TCatalogObject)objs.first);
        response.result.addToUpdated_catalog_objects((TCatalogObject)objs.second);
        response.result.setVersion(((TCatalogObject)objs.second).getCatalog_version());
        CatalogOpExecutor.addSummary(response, "Renaming was successful.");
    }

    private long trackAlterTableRenameEvent(TableName oldTableName, TableName newTableName, long startEventId, EventSequence catalogTimeline) throws MetastoreNotificationException, CatalogException {
        List<NotificationEvent> events = this.getNextMetastoreEventsForTableIfEnabled(catalogTimeline, startEventId, newTableName.getDb(), newTableName.getTbl(), "ALTER_TABLE");
        Pair<Long, Pair<org.apache.hadoop.hive.metastore.api.Table, org.apache.hadoop.hive.metastore.api.Table>> renamedTable = this.getRenamedTableFromEvents(events);
        long eventId = startEventId;
        if (renamedTable != null) {
            eventId = (Long)renamedTable.first;
            LOG.info("Got ALTER_TABLE RENAME event id {}.", (Object)eventId);
        } else if (this.catalog_.isEventProcessingEnabled()) {
            LOG.warn("ALTER_TABLE RENAME event not found. Using {} in createEventId of {} and DeleteEventLog for {}.", new Object[]{eventId, newTableName, oldTableName});
        }
        if (this.catalog_.isEventProcessingEnabled()) {
            this.addToDeleteEventLog(eventId, DeleteEventLog.getTblKey(oldTableName.getDb(), oldTableName.getTbl()));
        }
        return eventId;
    }

    private Pair<TCatalogObject, TCatalogObject> handleCatalogRenameResult(org.apache.impala.catalog.Table oldTbl, TableName newTableName, boolean wantMinimalResult, Pair<org.apache.impala.catalog.Table, org.apache.impala.catalog.Table> result, long alterTableEventId, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        TCatalogObject newTblDesc;
        TCatalogObject oldTblDesc;
        if (result.first == null) {
            oldTblDesc = wantMinimalResult ? oldTbl.toInvalidationObject() : oldTbl.toMinimalTCatalogObject();
            long version = this.catalog_.getDeleteLog().getLatestRemovedVersion(oldTblDesc);
            if (version > 0L) {
                oldTblDesc.setCatalog_version(version);
            } else {
                LOG.warn("Deletion update on the old table {} not found. Impalad might still have its metadata until the deletion update arrives from statestore.", (Object)oldTbl.getFullName());
            }
        } else {
            TCatalogObject tCatalogObject = oldTblDesc = wantMinimalResult ? ((org.apache.impala.catalog.Table)result.first).toInvalidationObject() : ((org.apache.impala.catalog.Table)result.first).toMinimalTCatalogObject();
        }
        if (result.second == null) {
            newTblDesc = this.catalog_.invalidateTable(newTableName.toThrift(), new Reference<Boolean>(), new Reference<Boolean>(), catalogTimeline, alterTableEventId);
            if (newTblDesc == null) {
                throw new ImpalaRuntimeException(String.format("The new table/view %s was concurrently removed during rename.", newTableName));
            }
            LOG.info("Invalidated {} to recover from catalog rename failure", (Object)newTableName);
        } else {
            Preconditions.checkNotNull(result.first);
            newTblDesc = wantMinimalResult ? ((org.apache.impala.catalog.Table)result.second).toInvalidationObject() : ((org.apache.impala.catalog.Table)result.second).toTCatalogObject();
        }
        return new Pair<TCatalogObject, TCatalogObject>(oldTblDesc, newTblDesc);
    }

    public void addToDeleteEventLog(long eventId, String objectKey) {
        if (!this.catalog_.isEventProcessingEnabled()) {
            LOG.trace("Not adding event {}:{} since events processing is not enabled", (Object)eventId, (Object)objectKey);
            return;
        }
        this.catalog_.getMetastoreEventProcessor().getDeleteEventLog().addRemovedObject(eventId, objectKey);
    }

    private void renameManagedKuduTable(KuduTable oldTbl, org.apache.hadoop.hive.metastore.api.Table oldMsTbl, TableName newTableName, boolean isHMSIntegrationEanbled, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        String newKuduTableName = KuduUtil.getDefaultKuduTableName(newTableName.getDb(), newTableName.getTbl(), isHMSIntegrationEanbled);
        if (oldTbl.getKuduTableName().equals(newKuduTableName)) {
            return;
        }
        KuduCatalogOpExecutor.renameTable(oldTbl, newKuduTableName, catalogTimeline);
        oldMsTbl.getParameters().put("kudu.table_name", newKuduTableName);
    }

    private void renameManagedIcebergTable(IcebergTable oldTbl, org.apache.hadoop.hive.metastore.api.Table msTbl, TableName newTableName) throws ImpalaRuntimeException {
        TableIdentifier tableId = TableIdentifier.of((String[])new String[]{newTableName.getDb(), newTableName.getTbl()});
        IcebergCatalogOpExecutor.renameTable(oldTbl, tableId);
        if (msTbl.getParameters().get("iceberg.table_identifier") != null) {
            msTbl.getParameters().put("iceberg.table_identifier", tableId.toString());
        }
    }

    private boolean alterTableSetFileFormat(org.apache.impala.catalog.Table tbl, List<List<TPartitionKeyValue>> partitionSet, THdfsFileFormat fileFormat, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        boolean reloadFileMetadata = false;
        if (partitionSet == null) {
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            CatalogOpExecutor.setStorageDescriptorFileFormat(msTbl.getSd(), fileFormat);
            if (tbl instanceof HdfsTable) {
                ((HdfsTable)tbl).setPrototypePartition(msTbl.getSd());
            }
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
            reloadFileMetadata = true;
        } else {
            Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable));
            List<HdfsPartition> partitions = ((HdfsTable)tbl).getPartitionsFromPartitionSet(partitionSet);
            ArrayList modifiedParts = Lists.newArrayList();
            for (HdfsPartition partition : partitions) {
                modifiedParts.add(new HdfsPartition.Builder(partition).setFileFormat(HdfsFileFormat.fromThrift(fileFormat)));
            }
            this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.MARK_DIRTY, catalogTimeline, modification);
            numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
        }
        return reloadFileMetadata;
    }

    private boolean alterTableSetRowFormat(org.apache.impala.catalog.Table tbl, List<List<TPartitionKeyValue>> partitionSet, TTableRowFormat tRowFormat, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable));
        boolean reloadFileMetadata = false;
        RowFormat rowFormat = RowFormat.fromThrift(tRowFormat);
        if (partitionSet == null) {
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            StorageDescriptor sd = msTbl.getSd();
            HiveStorageDescriptorFactory.setSerdeInfo(rowFormat, sd.getSerdeInfo());
            ((HdfsTable)tbl).setPrototypePartition(msTbl.getSd());
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
            reloadFileMetadata = true;
        } else {
            List<HdfsPartition> partitions = ((HdfsTable)tbl).getPartitionsFromPartitionSet(partitionSet);
            ArrayList modifiedParts = Lists.newArrayList();
            for (HdfsPartition partition : partitions) {
                HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                HiveStorageDescriptorFactory.setSerdeInfo(rowFormat, partBuilder.getSerdeInfo());
                modifiedParts.add(partBuilder);
            }
            this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.MARK_DIRTY, catalogTimeline, modification);
            numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
        }
        return reloadFileMetadata;
    }

    private static void setStorageDescriptorFileFormat(StorageDescriptor sd, THdfsFileFormat fileFormat) {
        StorageDescriptor tempSd = HiveStorageDescriptorFactory.createSd(fileFormat, RowFormat.DEFAULT_ROW_FORMAT);
        sd.setInputFormat(tempSd.getInputFormat());
        sd.setOutputFormat(tempSd.getOutputFormat());
        sd.getSerdeInfo().setSerializationLib(tempSd.getSerdeInfo().getSerializationLib());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alterTableSetLocation(org.apache.impala.catalog.Table tbl, List<TPartitionKeyValue> partitionSpec, String location, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        boolean reloadFileMetadata = false;
        if (partitionSpec == null) {
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            if (msTbl.getPartitionKeysSize() == 0) {
                reloadFileMetadata = true;
            }
            msTbl.getSd().setLocation(location);
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
        } else {
            TableName tableName = tbl.getTableName();
            HdfsPartition partition = this.catalog_.getHdfsPartition(tableName.getDb(), tableName.getTbl(), partitionSpec);
            HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
            partBuilder.setLocation(location);
            try {
                this.applyAlterPartition(tbl, partBuilder, catalogTimeline);
            }
            finally {
                ((HdfsTable)tbl).markDirtyPartition(partBuilder);
            }
            modification.registerInflightEvent();
        }
        return reloadFileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTableSetTblProperties(org.apache.impala.catalog.Table tbl, TAlterTableSetTblPropertiesParams params, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        Map<String, String> properties = params.getProperties();
        Preconditions.checkNotNull(properties);
        if (params.isSetPartition_set()) {
            Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable));
            List<HdfsPartition> partitions = ((HdfsTable)tbl).getPartitionsFromPartitionSet(params.getPartition_set());
            ArrayList modifiedParts = Lists.newArrayList();
            for (HdfsPartition partition : partitions) {
                HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                switch (params.getTarget()) {
                    case TBL_PROPERTY: {
                        partBuilder.getParameters().putAll(properties);
                        break;
                    }
                    case SERDE_PROPERTY: {
                        partBuilder.getSerdeInfo().getParameters().putAll(properties);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown target TTablePropertyType: " + (Object)((Object)params.getTarget()));
                    }
                }
                modifiedParts.add(partBuilder);
            }
            try {
                this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.NONE, catalogTimeline, modification);
            }
            finally {
                ((HdfsTable)tbl).markDirtyPartitions(modifiedParts);
            }
            numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
        } else {
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            switch (params.getTarget()) {
                case TBL_PROPERTY: {
                    if (KuduTable.isKuduTable(msTbl)) {
                        if (properties.containsKey("kudu.table_name") && !properties.get("kudu.table_name").equals(msTbl.getParameters().get("kudu.table_name")) && KuduTable.isSynchronizedTable(msTbl)) {
                            KuduCatalogOpExecutor.renameTable((KuduTable)tbl, properties.get("kudu.table_name"), catalogTimeline);
                        }
                        msTbl.getParameters().putAll(properties);
                        KuduCatalogOpExecutor.validateKuduTblExists(msTbl);
                        break;
                    }
                    msTbl.getParameters().putAll(properties);
                    break;
                }
                case SERDE_PROPERTY: {
                    msTbl.getSd().getSerdeInfo().getParameters().putAll(properties);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown target TTablePropertyType: " + (Object)((Object)params.getTarget()));
                }
            }
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTableUnSetTblProperties(org.apache.impala.catalog.Table tbl, TAlterTableUnSetTblPropertiesParams params, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        List<String> removeProperties = params.getProperty_keys();
        boolean ifExists = params.isIf_exists();
        Preconditions.checkNotNull(removeProperties);
        if (params.isSetPartition_set()) {
            Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable), (Object)"Partition spec not allowed for non-HDFS table");
            List<HdfsPartition> partitions = ((HdfsTable)tbl).getPartitionsFromPartitionSet(params.getPartition_set());
            ArrayList modifiedParts = Lists.newArrayList();
            for (HdfsPartition partition : partitions) {
                Set<String> keys;
                HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                switch (params.getTarget()) {
                    case TBL_PROPERTY: {
                        keys = partBuilder.getParameters().keySet();
                        break;
                    }
                    case SERDE_PROPERTY: {
                        keys = partBuilder.getSerdeInfo().getParameters().keySet();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown target TTablePropertyType: " + (Object)((Object)params.getTarget()));
                    }
                }
                this.removeKeys(removeProperties, ifExists, keys, "partition " + partition.getPartitionName(), ALTER_TBL_UNSET_NON_EXIST_PROPERTY);
                modifiedParts.add(partBuilder);
            }
            try {
                this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.NONE, catalogTimeline, modification);
            }
            finally {
                ((HdfsTable)tbl).markDirtyPartitions(modifiedParts);
            }
            numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
        } else {
            Set<String> keys;
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            switch (params.getTarget()) {
                case TBL_PROPERTY: {
                    keys = msTbl.getParameters().keySet();
                    break;
                }
                case SERDE_PROPERTY: {
                    keys = msTbl.getSd().getSerdeInfo().getParameters().keySet();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown target TTablePropertyType: " + (Object)((Object)params.getTarget()));
                }
            }
            this.removeKeys(removeProperties, ifExists, keys, "table " + tbl.getFullName(), ALTER_TBL_UNSET_NON_EXIST_PROPERTY);
            if (KuduTable.isKuduTable(msTbl)) {
                KuduCatalogOpExecutor.validateKuduTblExists(msTbl);
            }
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
        }
    }

    private void alterViewSetTblProperties(org.apache.impala.catalog.Table tbl, TAlterTableSetTblPropertiesParams params, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        Map<String, String> properties = params.getProperties();
        Preconditions.checkNotNull(properties);
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        msTbl.getParameters().putAll(properties);
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void alterViewUnSetTblProperties(org.apache.impala.catalog.Table tbl, TAlterTableUnSetTblPropertiesParams params, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        List<String> removeProperties = params.getProperty_keys();
        boolean ifExists = params.isIf_exists();
        Preconditions.checkNotNull(removeProperties);
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        Set<String> keys = msTbl.getParameters().keySet();
        this.removeKeys(removeProperties, ifExists, keys, "view " + tbl.getFullName(), ALTER_VIEW_UNSET_NON_EXIST_PROPERTY);
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
    }

    private void removeKeys(List<String> removeProperties, boolean ifExists, Set<String> keys, String fullName, String excepInfo) throws CatalogException {
        if (!ifExists && !keys.containsAll(removeProperties)) {
            ArrayList<String> removeCopy = new ArrayList<String>(removeProperties);
            removeCopy.removeAll(keys);
            throw new CatalogException(String.format("These properties do not exist for %s: %s.\n%s", fullName, String.join((CharSequence)",", removeCopy), excepInfo));
        }
        keys.removeAll(removeProperties);
    }

    private boolean alterTableSetCached(org.apache.impala.catalog.Table tbl, TAlterTableSetCachedParams params, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkArgument((boolean)tbl.isWriteLockedByCurrentThread());
        THdfsCachingOp cacheOp = params.getCache_op();
        Preconditions.checkNotNull((Object)cacheOp);
        if (!(tbl instanceof HdfsTable)) {
            throw new ImpalaRuntimeException("ALTER TABLE SET CACHED/UNCACHED must target an HDFS table.");
        }
        boolean loadFileMetadata = false;
        TableName tableName = tbl.getTableName();
        HdfsTable hdfsTable = (HdfsTable)tbl;
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        Long cacheDirId = HdfsCachingUtil.getCacheDirectiveId(msTbl.getParameters());
        if (cacheOp.isSet_cached()) {
            ArrayList cacheDirIds = Lists.newArrayList();
            short cacheReplication = HdfsCachingUtil.getReplicationOrDefault(cacheOp);
            if (cacheDirId == null) {
                cacheDirIds.add(HdfsCachingUtil.submitCacheTblDirective(msTbl, cacheOp.getCache_pool_name(), cacheReplication));
            } else if (HdfsCachingUtil.isUpdateOp(cacheOp, msTbl.getParameters())) {
                HdfsCachingUtil.validateCachePool(cacheOp, cacheDirId, tableName);
                cacheDirIds.add(HdfsCachingUtil.modifyCacheDirective(cacheDirId, msTbl, cacheOp.getCache_pool_name(), cacheReplication));
            }
            if (tbl.getNumClusteringCols() > 0) {
                Collection<? extends FeFsPartition> parts = hdfsTable.loadAllPartitions();
                ArrayList arrayList = Lists.newArrayList();
                for (FeFsPartition feFsPartition : parts) {
                    HdfsPartition partition = (HdfsPartition)feFsPartition;
                    if (partition.isMarkedCached() && !HdfsCachingUtil.isUpdateOp(cacheOp, partition.getParameters())) continue;
                    HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                    try {
                        if (!partition.isMarkedCached()) {
                            cacheDirIds.add(HdfsCachingUtil.submitCachePartitionDirective(partBuilder, cacheOp.getCache_pool_name(), cacheReplication));
                        } else {
                            Long directiveId = HdfsCachingUtil.getCacheDirectiveId(partition.getParameters());
                            cacheDirIds.add(HdfsCachingUtil.modifyCacheDirective(directiveId, partBuilder, cacheOp.getCache_pool_name(), cacheReplication));
                        }
                    }
                    catch (ImpalaRuntimeException e) {
                        if (partition.isMarkedCached()) {
                            LOG.error("Unable to modify cache partition: " + partition.getPartitionName(), (Throwable)e);
                        }
                        LOG.error("Unable to cache partition: " + partition.getPartitionName(), (Throwable)e);
                    }
                    arrayList.add(partBuilder);
                }
                this.bulkAlterPartitions(tbl, arrayList, null, UpdatePartitionMethod.MARK_DIRTY, catalogTimeline);
            } else {
                loadFileMetadata = true;
            }
            if (cacheDirIds.isEmpty()) {
                return loadFileMetadata;
            }
            this.catalog_.watchCacheDirs(cacheDirIds, tableName.toThrift(), "ALTER TABLE SET CACHED");
        } else {
            if (cacheDirId != null) {
                HdfsCachingUtil.removeTblCacheDirective(msTbl);
            }
            if (tbl.getNumClusteringCols() > 0) {
                Collection<? extends FeFsPartition> parts = hdfsTable.loadAllPartitions();
                ArrayList modifiedParts = Lists.newArrayList();
                for (FeFsPartition feFsPartition : parts) {
                    HdfsPartition partition = (HdfsPartition)feFsPartition;
                    if (!partition.isMarkedCached()) continue;
                    HdfsPartition.Builder builder = new HdfsPartition.Builder(partition);
                    HdfsCachingUtil.removePartitionCacheDirective(builder);
                    modifiedParts.add(builder);
                }
                this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.MARK_DIRTY, catalogTimeline);
            } else {
                loadFileMetadata = true;
            }
        }
        this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
        return loadFileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterPartitionSetCached(org.apache.impala.catalog.Table tbl, TAlterTableSetCachedParams params, Reference<Long> numUpdatedPartitions, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkArgument((boolean)tbl.isWriteLockedByCurrentThread());
        THdfsCachingOp cacheOp = params.getCache_op();
        Preconditions.checkNotNull((Object)cacheOp);
        Preconditions.checkNotNull(params.getPartition_set());
        TableName tableName = tbl.getTableName();
        Preconditions.checkArgument((boolean)(tbl instanceof HdfsTable));
        List<HdfsPartition> partitions = ((HdfsTable)tbl).getPartitionsFromPartitionSet(params.getPartition_set());
        ArrayList modifiedParts = Lists.newArrayList();
        if (cacheOp.isSet_cached()) {
            for (HdfsPartition partition : partitions) {
                Long directiveId = HdfsCachingUtil.getCacheDirectiveId(partition.getParameters());
                HdfsPartition.Builder partBuilder = null;
                short replication = HdfsCachingUtil.getReplicationOrDefault(cacheOp);
                ArrayList cacheDirs = Lists.newArrayList();
                if (directiveId == null) {
                    partBuilder = new HdfsPartition.Builder(partition);
                    cacheDirs.add(HdfsCachingUtil.submitCachePartitionDirective(partBuilder, cacheOp.getCache_pool_name(), replication));
                } else if (HdfsCachingUtil.isUpdateOp(cacheOp, partition.getParameters())) {
                    partBuilder = new HdfsPartition.Builder(partition);
                    HdfsCachingUtil.validateCachePool(cacheOp, directiveId, tableName, partition);
                    cacheDirs.add(HdfsCachingUtil.modifyCacheDirective(directiveId, partBuilder, cacheOp.getCache_pool_name(), replication));
                }
                if (!cacheDirs.isEmpty()) {
                    this.catalog_.watchCacheDirs(cacheDirs, tableName.toThrift(), "ALTER PARTITION SET CACHED");
                }
                if (partBuilder == null) continue;
                modifiedParts.add(partBuilder);
            }
        } else {
            for (HdfsPartition partition : partitions) {
                if (!partition.isMarkedCached()) continue;
                HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                HdfsCachingUtil.removePartitionCacheDirective(partBuilder);
                modifiedParts.add(partBuilder);
            }
        }
        try {
            this.bulkAlterPartitions(tbl, modifiedParts, null, UpdatePartitionMethod.NONE, catalogTimeline, modification);
        }
        finally {
            ((HdfsTable)tbl).markDirtyPartitions(modifiedParts);
        }
        numUpdatedPartitions.setRef(Long.valueOf(modifiedParts.size()));
    }

    private void alterTableRecoverPartitions(org.apache.impala.catalog.Table tbl, @Nullable String debugAction, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        Preconditions.checkArgument((boolean)tbl.isWriteLockedByCurrentThread());
        if (!(tbl instanceof HdfsTable)) {
            throw new CatalogException("Table " + tbl.getFullName() + " is not an HDFS table");
        }
        HdfsTable hdfsTable = (HdfsTable)tbl;
        List<List<String>> partitionsNotInHms = hdfsTable.getPathsWithoutPartitions(debugAction);
        if (partitionsNotInHms.isEmpty()) {
            return;
        }
        ArrayList hmsPartitions = Lists.newArrayList();
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        TableName tableName = tbl.getTableName();
        for (List<String> partitionSpecValues : partitionsNotInHms) {
            hmsPartitions.add(this.createHmsPartitionFromValues(partitionSpecValues, msTbl, tableName, null));
        }
        String cachePoolName = null;
        Short replication = null;
        ArrayList cacheIds = Lists.newArrayList();
        Long parentTblCacheDirId = HdfsCachingUtil.getCacheDirectiveId(msTbl.getParameters());
        if (parentTblCacheDirId != null) {
            cachePoolName = HdfsCachingUtil.getCachePool(parentTblCacheDirId);
            Preconditions.checkNotNull((Object)cachePoolName);
            replication = HdfsCachingUtil.getCacheReplication(parentTblCacheDirId);
            Preconditions.checkNotNull((Object)replication);
        }
        HashMap partitionToEventId = Maps.newHashMap();
        String annotation = String.format("Recovering %d partitions for %s", hmsPartitions.size(), tbl.getFullName());
        LOG.info(annotation);
        if (DebugUtils.hasDebugAction(debugAction, "enable_event_processor")) {
            this.catalog_.startEventsProcessor();
        }
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator(annotation);
             MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            List<Partition> addedPartitions = this.addHmsPartitions(msClient, tbl, hmsPartitions, partitionToEventId, true, catalogTimeline);
            this.addHdfsPartitions(msClient, tbl, addedPartitions, partitionToEventId, catalogTimeline);
            if (cachePoolName != null) {
                Preconditions.checkNotNull((Object)replication);
                int numDone = 0;
                for (List hmsSublist : Lists.partition(addedPartitions, (int)500)) {
                    for (Partition partition : hmsSublist) {
                        long id = HdfsCachingUtil.submitCachePartitionDirective(partition, cachePoolName, (short)replication);
                        cacheIds.add(id);
                    }
                    MetastoreShim.alterPartitions(msClient.getHiveClient(), tableName.getDb(), tableName.getTbl(), hmsSublist);
                    LOG.info("Updated cache directive id for {}/{} partitions for table {}", new Object[]{numDone += hmsSublist.size(), addedPartitions.size(), tableName});
                }
            }
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "add_partition"), e);
        }
        if (!cacheIds.isEmpty()) {
            this.catalog_.watchCacheDirs(cacheIds, tableName.toThrift(), "ALTER TABLE RECOVER PARTITIONS");
        }
        modification.registerInflightEvent();
    }

    private void alterTableOrViewSetOwner(org.apache.impala.catalog.Table tbl, TAlterTableOrViewSetOwnerParams params, TDdlExecResponse response, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
        String oldOwner = msTbl.getOwner();
        PrincipalType oldOwnerType = msTbl.getOwnerType();
        msTbl.setOwner(params.owner_name);
        msTbl.setOwnerType(PrincipalType.valueOf((String)params.owner_type.name()));
        boolean isSynchronizedKuduTable = tbl instanceof KuduTable && KuduTable.isSynchronizedTable(msTbl);
        boolean altersHMSTable = true;
        if (isSynchronizedKuduTable) {
            boolean isKuduHmsIntegrationEnabled = this.isKuduHmsIntegrationEnabled(msTbl);
            altersHMSTable = !isKuduHmsIntegrationEnabled;
            KuduCatalogOpExecutor.alterSetOwner((KuduTable)tbl, params.owner_name, catalogTimeline);
        }
        if (altersHMSTable) {
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
        }
        if (this.authzConfig_.isEnabled()) {
            this.authzManager_.updateTableOwnerPrivilege(params.server_name, msTbl.getDbName(), msTbl.getTableName(), oldOwner, oldOwnerType, msTbl.getOwner(), msTbl.getOwnerType(), response);
        }
    }

    private Partition createHmsPartition(List<TPartitionKeyValue> partitionSpec, org.apache.hadoop.hive.metastore.api.Table msTbl, TableName tableName, String location) {
        ArrayList values = Lists.newArrayList();
        for (FieldSchema fs : msTbl.getPartitionKeys()) {
            for (TPartitionKeyValue kv : partitionSpec) {
                if (!fs.getName().toLowerCase().equals(kv.getName().toLowerCase())) continue;
                values.add(kv.getValue());
            }
        }
        return this.createHmsPartitionFromValues(values, msTbl, tableName, location);
    }

    private Partition createHmsPartitionFromValues(List<String> partitionSpecValues, org.apache.hadoop.hive.metastore.api.Table msTbl, TableName tableName, String location) {
        Partition partition = new Partition();
        partition.setDbName(tableName.getDb());
        partition.setTableName(tableName.getTbl());
        partition.setValues(partitionSpecValues);
        StorageDescriptor sd = MetaStoreUtil.shallowCopyStorageDescriptor(msTbl.getSd());
        sd.setLocation(location);
        partition.setSd(sd);
        return partition;
    }

    private void addCatalogServiceIdentifiers(org.apache.hadoop.hive.metastore.api.Table msTbl, Partition partition) {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return;
        }
        Preconditions.checkState((boolean)msTbl.isSetParameters());
        Preconditions.checkNotNull((Object)partition, (Object)"Partition is null");
        Map tblParams = msTbl.getParameters();
        Preconditions.checkState((boolean)tblParams.containsKey(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey()), (Object)"Table parameters must have catalog service identifier before adding it to partition parameters");
        Preconditions.checkState((boolean)tblParams.containsKey(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey()), (Object)"Table parameters must contain catalog version before adding it to partition parameters");
        String serviceIdFromTbl = (String)tblParams.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey());
        String version = (String)tblParams.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey());
        if (this.catalog_.getCatalogServiceId().equals(serviceIdFromTbl)) {
            partition.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), serviceIdFromTbl);
            partition.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), version);
        }
    }

    private void addToInflightVersionsOfPartition(Map<String, String> partitionParams, HdfsPartition.Builder partBuilder) {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return;
        }
        Preconditions.checkState((partitionParams != null ? 1 : 0) != 0);
        String version = partitionParams.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey());
        String serviceId = partitionParams.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey());
        if (this.catalog_.getCatalogServiceId().equals(serviceId)) {
            Preconditions.checkNotNull((Object)version);
            partBuilder.addToVersionsForInflightEvents(false, Long.parseLong(version));
        }
    }

    public boolean addJavaFunctionToHms(org.apache.hadoop.hive.metastore.api.Function fn, boolean ifNotExists, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            msClient.getHiveClient().createFunction(fn);
            catalogTimeline.markEvent("Created function in Metastore");
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createFunction"), e);
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Error executing createFunction() metastore call: " + fn.getFunctionName(), (Throwable)e);
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createFunction"), e);
        }
        return true;
    }

    public boolean dropJavaFunctionFromHms(String db, String fn, boolean ifExists, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            msClient.getHiveClient().dropFunction(db, fn);
            catalogTimeline.markEvent("Dropped function in Metastore");
        }
        catch (NoSuchObjectException e) {
            if (!ifExists) {
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropFunction"), e);
            }
            return false;
        }
        catch (TException e) {
            LOG.error("Error executing dropFunction() metastore call: " + fn, (Throwable)e);
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "dropFunction"), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDataSourceToHms(DataSource dataSource, boolean ifNotExists) throws ImpalaRuntimeException {
        this.getMetastoreDdlLock().lock();
        try {
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient();){
                MetastoreShim.createDataSource(msClient.getHiveClient(), dataSource);
            }
            catch (AlreadyExistsException e) {
                if (!ifNotExists) {
                    throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createDataConnector"), e);
                }
                boolean bl = false;
                this.getMetastoreDdlLock().unlock();
                return bl;
            }
            catch (TException e) {
                LOG.error("Error executing createDataConnector() metastore call: " + dataSource.getName(), (Throwable)e);
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createDataConnector"), e);
            }
        }
        finally {
            this.getMetastoreDdlLock().unlock();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean dropDataSourceFromHms(String name, boolean ifExists) throws ImpalaRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void applyAlterDatabase(Database msDb, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            msClient.getHiveClient().alterDatabase(msDb.getName(), msDb);
            catalogTimeline.markEvent("Altered database in Metastore");
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "alterDatabase"), e);
        }
    }

    private void applyAlterAndInProgressTableModification(org.apache.hadoop.hive.metastore.api.Table msTbl, EventSequence catalogTimeline, @Nullable InProgressTableModification modification) throws ImpalaRuntimeException {
        this.applyAlterTable(msTbl, true, null, catalogTimeline, modification);
    }

    private void applyAlterTable(org.apache.hadoop.hive.metastore.api.Table msTbl, boolean overwriteLastDdlTime, @Nullable AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        this.applyAlterTable(msTbl, overwriteLastDdlTime, tblTxn, catalogTimeline, null);
    }

    private void applyAlterTable(org.apache.hadoop.hive.metastore.api.Table msTbl, boolean overwriteLastDdlTime, @Nullable AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline, @Nullable InProgressTableModification modification) throws ImpalaRuntimeException {
        if (modification != null) {
            modification.registerInflightEvent();
        }
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            if (overwriteLastDdlTime) {
                org.apache.impala.catalog.Table.updateTimestampProperty(msTbl, "transient_lastDdlTime");
            }
            msTbl.putToParameters("DO_NOT_UPDATE_STATS", "true");
            if (tblTxn != null) {
                MetastoreShim.alterTableWithTransaction(msClient.getHiveClient(), msTbl, tblTxn);
            } else {
                try {
                    msClient.getHiveClient().alter_table(msTbl.getDbName(), msTbl.getTableName(), msTbl);
                }
                catch (TException e) {
                    throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "alter_table"), e);
                }
            }
            catalogTimeline.markEvent("Altered table in Metastore");
        }
        catch (Exception ex) {
            if (modification != null) {
                modification.cancelInflightEventIfExist();
            }
            throw ex;
        }
        if (modification != null) {
            modification.markInflightEventRegistrationComplete();
        }
    }

    private void applyAlterPartition(org.apache.impala.catalog.Table tbl, HdfsPartition.Builder partBuilder, EventSequence catalogTimeline) throws ImpalaException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            Partition hmsPartition = partBuilder.toHmsPartition();
            this.addCatalogServiceIdentifiers(tbl.getMetaStoreTable(), hmsPartition);
            this.applyAlterHmsPartitions(msClient, tbl.getTableName(), Arrays.asList(hmsPartition), catalogTimeline);
            this.addToInflightVersionsOfPartition(hmsPartition.getParameters(), partBuilder);
        }
    }

    private void applyAlterHmsPartitions(MetaStoreClientPool.MetaStoreClient msClient, TableName tableName, List<Partition> hmsPartitions, EventSequence catalogTimeline) throws ImpalaException {
        try {
            MetastoreShim.alterPartitions(msClient.getHiveClient(), tableName.getDb(), tableName.getTbl(), hmsPartitions);
            catalogTimeline.markEvent(String.format("Altered %d partitions in Metastore", hmsPartitions.size()));
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "alter_partitions"), e);
        }
    }

    private void createRole(User requestingUser, TCreateDropRoleParams createDropRoleParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)requestingUser);
        Preconditions.checkNotNull((Object)createDropRoleParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((!createDropRoleParams.isIs_drop() ? 1 : 0) != 0);
        this.authzManager_.createRole(requestingUser, createDropRoleParams, resp);
        CatalogOpExecutor.addSummary(resp, "Role has been created.");
    }

    private void dropRole(User requestingUser, TCreateDropRoleParams createDropRoleParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)requestingUser);
        Preconditions.checkNotNull((Object)createDropRoleParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((boolean)createDropRoleParams.isIs_drop());
        this.authzManager_.dropRole(requestingUser, createDropRoleParams, resp);
        CatalogOpExecutor.addSummary(resp, "Role has been dropped.");
    }

    private void grantRoleToGroup(User requestingUser, TGrantRevokeRoleParams grantRevokeRoleParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)requestingUser);
        Preconditions.checkNotNull((Object)grantRevokeRoleParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((boolean)grantRevokeRoleParams.isIs_grant());
        this.authzManager_.grantRoleToGroup(requestingUser, grantRevokeRoleParams, resp);
        CatalogOpExecutor.addSummary(resp, "Role has been granted.");
    }

    private void revokeRoleFromGroup(User requestingUser, TGrantRevokeRoleParams grantRevokeRoleParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)requestingUser);
        Preconditions.checkNotNull((Object)grantRevokeRoleParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((!grantRevokeRoleParams.isIs_grant() ? 1 : 0) != 0);
        this.authzManager_.revokeRoleFromGroup(requestingUser, grantRevokeRoleParams, resp);
        CatalogOpExecutor.addSummary(resp, "Role has been revoked.");
    }

    private void grantPrivilege(TCatalogServiceRequestHeader header, TGrantRevokePrivParams grantRevokePrivParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)grantRevokePrivParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((boolean)grantRevokePrivParams.isIs_grant());
        switch (grantRevokePrivParams.principal_type) {
            case ROLE: {
                this.authzManager_.grantPrivilegeToRole(header, grantRevokePrivParams, resp);
                break;
            }
            case USER: {
                this.authzManager_.grantPrivilegeToUser(header, grantRevokePrivParams, resp);
                break;
            }
            case GROUP: {
                this.authzManager_.grantPrivilegeToGroup(header, grantRevokePrivParams, resp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected principal type: " + (Object)((Object)grantRevokePrivParams.principal_type));
            }
        }
        CatalogOpExecutor.addSummary(resp, "Privilege(s) have been granted.");
    }

    private void revokePrivilege(TCatalogServiceRequestHeader header, TGrantRevokePrivParams grantRevokePrivParams, TDdlExecResponse resp) throws ImpalaException {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkNotNull((Object)grantRevokePrivParams);
        Preconditions.checkNotNull((Object)resp);
        Preconditions.checkArgument((!grantRevokePrivParams.isIs_grant() ? 1 : 0) != 0);
        switch (grantRevokePrivParams.principal_type) {
            case ROLE: {
                this.authzManager_.revokePrivilegeFromRole(header, grantRevokePrivParams, resp);
                break;
            }
            case USER: {
                this.authzManager_.revokePrivilegeFromUser(header, grantRevokePrivParams, resp);
                break;
            }
            case GROUP: {
                this.authzManager_.revokePrivilegeFromGroup(header, grantRevokePrivParams, resp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected principal type: " + (Object)((Object)grantRevokePrivParams.principal_type));
            }
        }
        CatalogOpExecutor.addSummary(resp, "Privilege(s) have been revoked.");
    }

    private void bulkAlterPartitions(org.apache.impala.catalog.Table tbl, List<HdfsPartition.Builder> modifiedParts, AcidUtils.TblTransaction tblTxn, UpdatePartitionMethod updateMethod, EventSequence catalogTimeline) throws ImpalaException {
        this.bulkAlterPartitions(tbl, modifiedParts, tblTxn, updateMethod, catalogTimeline, null);
    }

    /*
     * Exception decompiling
     */
    private void bulkAlterPartitions(org.apache.impala.catalog.Table tbl, List<HdfsPartition.Builder> modifiedParts, AcidUtils.TblTransaction tblTxn, UpdatePartitionMethod updateMethod, EventSequence catalogTimeline, @Nullable InProgressTableModification modification) throws ImpalaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private org.apache.hadoop.hive.metastore.api.Table getMetaStoreTable(MetaStoreClientPool.MetaStoreClient msClient, org.apache.impala.catalog.Table tbl) throws CatalogException {
        long hmsLoadTime;
        Preconditions.checkState((!(tbl instanceof IncompleteTable) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)msClient);
        Db db = tbl.getDb();
        org.apache.hadoop.hive.metastore.api.Table msTbl = null;
        Stopwatch hmsLoadSW = Stopwatch.createStarted();
        try {
            msTbl = msClient.getHiveClient().getTable(db.getName(), tbl.getName());
        }
        catch (Exception e) {
            throw new TableLoadingException("Error loading metadata for table: " + db.getName() + "." + tbl.getName(), e);
        }
        finally {
            long hmsLoadTime2 = hmsLoadSW.elapsed(TimeUnit.NANOSECONDS);
        }
        tbl.updateHMSLoadTableSchemaTime(hmsLoadTime);
        return msTbl;
    }

    private static List<FieldSchema> buildFieldSchemaList(List<TColumn> columns) {
        ArrayList fsList = Lists.newArrayList();
        for (TColumn col : columns) {
            Type type = Type.fromThrift(col.getColumnType());
            String typeSql = type.toSql().toLowerCase();
            FieldSchema fs = new FieldSchema(col.getColumnName(), typeSql, col.getComment());
            fsList.add(fs);
        }
        return fsList;
    }

    public TResetMetadataResponse execResetMetadata(TResetMetadataRequest req) throws CatalogException {
        this.catalogOpTracker_.increment(req);
        try {
            TResetMetadataResponse response = this.execResetMetadataImpl(req);
            this.catalogOpTracker_.decrement(req, null);
            return response;
        }
        catch (Exception e) {
            this.catalogOpTracker_.decrement(req, JniUtil.throwableToString(e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TResetMetadataResponse execResetMetadataImpl(TResetMetadataRequest req) throws CatalogException {
        EventSequence catalogTimeline = new EventSequence(CATALOG_TIMELINE_NAME);
        String cmdString = CatalogOpUtil.getShortDescForReset(req);
        TResetMetadataResponse resp = new TResetMetadataResponse();
        resp.setResult(new TCatalogUpdateResult());
        resp.getResult().setCatalog_service_id(JniCatalog.getServiceId());
        if (req.isSetDb_name()) {
            Preconditions.checkState((!this.catalog_.isBlacklistedDb(req.getDb_name()) ? 1 : 0) != 0, (Object)String.format("Can't refresh functions in blacklisted database: %s. %s", req.getDb_name(), BLACKLISTED_DBS_INCONSISTENT_ERR_STR));
            this.acquireMetastoreDdlLock(catalogTimeline);
            try {
                ArrayList addedFuncs = Lists.newArrayList();
                ArrayList removedFuncs = Lists.newArrayList();
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    this.catalog_.refreshFunctions(msClient, req.getDb_name(), addedFuncs, removedFuncs);
                }
                resp.result.setUpdated_catalog_objects(addedFuncs);
                resp.result.setRemoved_catalog_objects(removedFuncs);
                resp.result.setVersion(this.catalog_.getCatalogVersion());
                for (TCatalogObject removedFn : removedFuncs) {
                    this.catalog_.getDeleteLog().addRemovedObject(removedFn);
                }
            }
            finally {
                this.getMetastoreDdlLock().unlock();
            }
        }
        if (req.isSetTable_name()) {
            Reference<Boolean> tblWasRemoved = new Reference<Boolean>(false);
            Reference<Boolean> dbWasAdded = new Reference<Boolean>(false);
            TCatalogObject updatedThriftTable = null;
            org.apache.impala.catalog.Table tbl = null;
            TableName tblName = TableName.fromThrift(req.getTable_name());
            long eventId = -1L;
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                eventId = MetastoreEventsProcessor.getCurrentEventIdNoThrow(msClient.getHiveClient());
            }
            if (!req.isIs_refresh()) {
                updatedThriftTable = this.catalog_.invalidateTable(req.getTable_name(), tblWasRemoved, dbWasAdded, catalogTimeline, eventId);
                catalogTimeline.markEvent("Invalidated table in catalog cache");
            } else {
                tbl = this.catalog_.getTable(tblName.getDb(), tblName.getTbl());
                if (tbl != null) {
                    CatalogObject.ThriftObjectType resultType;
                    boolean isTableLoadedInCatalog = tbl.isLoaded();
                    tbl = this.getExistingTable(tblName.getDb(), tblName.getTbl(), "Load triggered by " + cmdString, catalogTimeline);
                    CatalogObject.ThriftObjectType thriftObjectType = resultType = req.header.want_minimal_response ? CatalogObject.ThriftObjectType.INVALIDATION : CatalogObject.ThriftObjectType.FULL;
                    if (isTableLoadedInCatalog) {
                        if (req.isSetPartition_spec() || req.getPartition_spec_listSize() == 1) {
                            Preconditions.checkArgument((!AcidUtils.isTransactionalTable(tbl) ? 1 : 0) != 0);
                            List<TPartitionKeyValue> partitionSpec = req.isSetPartition_spec() ? req.getPartition_spec() : req.getPartition_spec_list().get(0);
                            Reference<Boolean> wasPartitionRefreshed = new Reference<Boolean>(false);
                            updatedThriftTable = this.catalog_.reloadPartition(tbl, partitionSpec, wasPartitionRefreshed, resultType, cmdString, catalogTimeline);
                        } else {
                            try {
                                updatedThriftTable = this.catalog_.reloadTable(tbl, req, resultType, cmdString, -1L, catalogTimeline);
                            }
                            catch (IcebergTableLoadingException e) {
                                updatedThriftTable = this.catalog_.invalidateTable(req.getTable_name(), tblWasRemoved, dbWasAdded, catalogTimeline, eventId);
                            }
                        }
                    } else {
                        catalogTimeline.markEvent("Loaded table from scratch");
                        tbl.takeReadLock();
                        catalogTimeline.markEvent(GOT_TABLE_READ_LOCK);
                        try {
                            updatedThriftTable = tbl.toTCatalogObject(resultType);
                        }
                        finally {
                            tbl.releaseReadLock();
                        }
                    }
                }
            }
            if (updatedThriftTable == null) {
                throw new TableNotFoundException("Table not found: " + req.getTable_name().getDb_name() + "." + req.getTable_name().getTable_name());
            }
            if (BackendConfig.INSTANCE.enableReloadEvents()) {
                if (!req.isIs_refresh()) {
                    tbl = this.catalog_.getTable(tblName.getDb(), tblName.getTbl());
                }
                Preconditions.checkNotNull((Object)tbl, (Object)("tbl is null in " + cmdString));
                this.fireReloadEventAndUpdateRefreshEventId(req, tblName, tbl);
                catalogTimeline.markEvent("Fired reload events in Metastore");
            }
            if (tblWasRemoved.getRef().booleanValue()) {
                resp.getResult().addToRemoved_catalog_objects(updatedThriftTable);
            } else {
                resp.getResult().addToUpdated_catalog_objects(updatedThriftTable);
            }
            if (dbWasAdded.getRef().booleanValue()) {
                Db addedDb = this.catalog_.getDb(updatedThriftTable.getTable().getDb_name());
                if (addedDb == null) {
                    throw new CatalogException("Database " + updatedThriftTable.getTable().getDb_name() + " was removed by a concurrent operation. Try invalidating the table again.");
                }
                this.addDbToCatalogUpdate(addedDb, req.header.want_minimal_response, resp.getResult());
            }
            resp.getResult().setVersion(updatedThriftTable.getCatalog_version());
        } else if (req.isAuthorization()) {
            AuthorizationDelta authzDelta = this.catalog_.refreshAuthorization(false);
            resp.result.setUpdated_catalog_objects(authzDelta.getCatalogObjectsAdded());
            resp.result.setRemoved_catalog_objects(authzDelta.getCatalogObjectsRemoved());
            resp.result.setVersion(this.catalog_.getCatalogVersion());
        } else {
            Preconditions.checkArgument((!req.isIs_refresh() ? 1 : 0) != 0);
            boolean isCatalogServerRequest = !req.header.isSetRequesting_user() && !req.header.isSetCoordinator_hostname();
            resp.getResult().setVersion(this.catalog_.reset(catalogTimeline, req.isSync_ddl(), isCatalogServerRequest));
            resp.getResult().setIs_invalidate(true);
        }
        catalogTimeline.markEvent("Finished resetMetadata request");
        if (req.isSync_ddl()) {
            resp.getResult().setVersion(this.catalog_.waitForSyncDdlVersion(resp.getResult()));
            catalogTimeline.markEvent(SENT_CATALOG_FOR_SYNC_DDL);
        }
        resp.getResult().setStatus(new TStatus(TErrorCode.OK, new ArrayList<String>()));
        TRuntimeProfileNode profile = Frontend.createTRuntimeProfileNode("CatalogOp");
        profile.addToEvent_sequences(catalogTimeline.toThrift());
        resp.setProfile(profile);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReloadEventAndUpdateRefreshEventId(TResetMetadataRequest req, TableName tblName, org.apache.impala.catalog.Table tbl) {
        List<List<TPartitionKeyValue>> partSpecList = null;
        List<List<String>> partValsList = null;
        if (req.isSetPartition_spec()) {
            partSpecList = Collections.singletonList(req.partition_spec);
        } else if (req.isSetPartition_spec_list()) {
            partSpecList = req.partition_spec_list;
        }
        if (partSpecList != null) {
            partValsList = partSpecList.stream().map(ps -> ps.stream().map(TPartitionKeyValue::getValue).collect(Collectors.toList())).collect(Collectors.toList());
        }
        try {
            List<Long> eventIds = MetastoreShim.fireReloadEventHelper(this.catalog_.getMetaStoreClient(), req.isIs_refresh(), partValsList, tblName.getDb(), tblName.getTbl(), Collections.emptyMap());
            LOG.info("Fired {} RELOAD events for table {}: {}", new Object[]{eventIds.size(), tbl.getFullName(), StringUtils.join((CharSequence)",", eventIds)});
            if (!req.isIs_refresh() || eventIds.isEmpty()) {
                return;
            }
            if (!this.catalog_.tryLock(tbl, true, 600000L)) {
                LOG.warn("Couldn't obtain a version lock for the table: {}. Self events may go undetected in that case", (Object)tbl.getFullName());
                return;
            }
            if (partSpecList != null) {
                Preconditions.checkNotNull(partValsList);
                boolean partitionChanged = false;
                for (int i = 0; i < partSpecList.size(); ++i) {
                    HdfsTable hdfsTbl = (HdfsTable)tbl;
                    HdfsPartition partition = hdfsTbl.getPartitionFromThriftPartitionSpec(partSpecList.get(i));
                    if (partition != null) {
                        HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(partition);
                        partBuilder.setLastRefreshEventId(eventIds.get(eventIds.size() - 1));
                        partitionChanged |= hdfsTbl.updatePartition(partBuilder);
                        continue;
                    }
                    LOG.warn("Partition {} no longer exists in table {}. It might be dropped by a concurrent operation.", (Object)FeCatalogUtils.getPartitionName(hdfsTbl, partValsList.get(i)), (Object)hdfsTbl.getFullName());
                }
                if (partitionChanged) {
                    tbl.setCatalogVersion(this.catalog_.incrementAndGetCatalogVersion());
                }
            } else {
                tbl.setLastRefreshEventId(eventIds.get(0));
            }
        }
        catch (CatalogException | TException e) {
            LOG.error(String.format(HMS_RPC_ERROR_FORMAT_STR, "fireReloadEvent") + e.getMessage());
        }
        finally {
            if (tbl.isWriteLockedByCurrentThread()) {
                tbl.releaseWriteLock();
                this.catalog_.getLock().writeLock().unlock();
            }
        }
    }

    public TUpdateCatalogResponse updateCatalog(TUpdateCatalogRequest update) throws ImpalaException {
        this.catalogOpTracker_.increment(update);
        try {
            TUpdateCatalogResponse response = this.updateCatalogImpl(update);
            this.catalogOpTracker_.decrement(update, null);
            return response;
        }
        catch (Exception e) {
            this.catalogOpTracker_.decrement(update, JniUtil.throwableToString(e));
            throw e;
        }
    }

    public TUpdateCatalogResponse updateCatalogImpl(TUpdateCatalogRequest update) throws ImpalaException {
        EventSequence catalogTimeline = new EventSequence(CATALOG_TIMELINE_NAME);
        TUpdateCatalogResponse response = new TUpdateCatalogResponse();
        org.apache.impala.catalog.Table table = this.getExistingTable(update.getDb_name(), update.getTarget_table(), "Load for INSERT", catalogTimeline);
        if (!(table instanceof FeFsTable)) {
            throw new InternalException("Unexpected table type: " + update.getTarget_table());
        }
        FeFsTable feFsTable = (FeFsTable)((Object)table);
        Map<String, List<FileMetadata>> fileMetadata = this.getFileMetadata(feFsTable, update.getUpdated_partitions(), update.getDebug_action(), catalogTimeline);
        this.tryWriteLock(table, "updating the catalog", catalogTimeline);
        Timer.Context context = table.getMetrics().getTimer("catalog-update-duration").time();
        InProgressTableModification modification = null;
        try {
            modification = new InProgressTableModification(this.catalog_, table);
            this.catalog_.getLock().writeLock().unlock();
            AcidUtils.TblTransaction tblTxn = this.createTableTransactionIfApplicable(update, catalogTimeline, table);
            ArrayList cacheDirIds = Lists.newArrayList();
            Pair<String, Short> cacheInfo = table.getTableCacheInfo(cacheDirIds);
            String cachePoolName = (String)cacheInfo.first;
            Short cacheReplication = (Short)cacheInfo.second;
            TableName tblName = new TableName(table.getDb().getName(), table.getName());
            ArrayList errorMessages = Lists.newArrayList();
            HashSet partsToLoadMetadata = null;
            modification.addCatalogServiceIdentifiersToTable();
            org.apache.hadoop.hive.metastore.api.Table msTbl = table.getMetaStoreTable().deepCopy();
            HashSet partsToCreate = new HashSet();
            if (table.getNumClusteringCols() > 0) {
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    partsToCreate = Sets.newHashSet(update.getUpdated_partitions().keySet());
                    ((HdfsTable)table).load(new HdfsTableLoadParamsBuilder(msClient.getHiveClient(), msTbl).reuseMetadata(true).setLoadPartitionFileMetadata(false).setLoadTableSchema(false).setRefreshUpdatedPartitions(false).setPartitionsToUpdate(partsToCreate).setDebugAction(update.getDebug_action()).setReason("Preload for INSERT").setIsPreLoadForInsert(true).setCatalogTimeline(catalogTimeline).build());
                }
            }
            Collection<? extends FeFsPartition> parts = feFsTable.loadAllPartitions();
            ArrayList<FeFsPartition> affectedExistingPartitions = new ArrayList<FeFsPartition>();
            ArrayList hmsPartitionsStatsUnset = Lists.newArrayList();
            HashMap<String, List<String>> addedPartitionNames = new HashMap<String, List<String>>();
            HashMap<String, Long> partitionToEventId = new HashMap<String, Long>();
            if (table.getNumClusteringCols() > 0) {
                partsToLoadMetadata = Sets.newHashSet((Iterable)partsToCreate);
                for (FeFsPartition feFsPartition : parts) {
                    this.updatePartitionMetadataAndCacheStatus(partsToCreate, affectedExistingPartitions, feFsPartition, hmsPartitionsStatsUnset, cacheDirIds);
                    if (!partsToCreate.isEmpty()) continue;
                    break;
                }
                this.addPartitionNamesInMetastore(table, tblName, partsToCreate, addedPartitionNames, cachePoolName, cacheReplication, catalogTimeline, partitionToEventId, cacheDirIds, msTbl, errorMessages);
                if (!hmsPartitionsStatsUnset.isEmpty()) {
                    this.unsetPartitionsColStats(table.getMetaStoreTable(), hmsPartitionsStatsUnset, tblTxn, catalogTimeline);
                }
            } else {
                FeFsPartition singlePart = (FeFsPartition)Iterables.getOnlyElement(parts);
                affectedExistingPartitions.add(singlePart);
            }
            this.unsetTableColStats(table.getMetaStoreTable(), tblTxn, catalogTimeline);
            if (!cacheDirIds.isEmpty()) {
                this.catalog_.watchCacheDirs(cacheDirIds, tblName.toThrift(), "INSERT into cached partitions");
            }
            response.setResult(new TCatalogUpdateResult());
            response.getResult().setCatalog_service_id(JniCatalog.getServiceId());
            if (errorMessages.size() > 0) {
                errorMessages.add("Please refer to the catalogd error log for details regarding the failed un/caching operations.");
                response.getResult().setStatus(new TStatus(TErrorCode.INTERNAL_ERROR, errorMessages));
            } else {
                response.getResult().setStatus(new TStatus(TErrorCode.OK, new ArrayList<String>()));
            }
            try {
                this.createInsertEvents(feFsTable, fileMetadata, addedPartitionNames, update.is_overwrite, tblTxn, catalogTimeline);
            }
            catch (Exception e) {
                LOG.error("Failed to fire insert events for table {}", (Object)table.getFullName(), (Object)e);
            }
            if (update.isSetTransaction_id() && response.getResult().getStatus().getStatus_code() == TErrorCode.OK) {
                this.commitTransaction(update.getTransaction_id(), catalogTimeline);
            }
            if (table instanceof FeIcebergTable && update.isSetIceberg_operation()) {
                this.insertIntoIcebergTable(table, update, catalogTimeline, modification);
            }
            this.loadTableMetadata(table, modification.newVersionNumber(), true, false, partsToLoadMetadata, partitionToEventId, "INSERT", update.getDebug_action(), catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(table, update.header.want_minimal_response, response.result);
            modification.validateInProgressModificationComplete();
        }
        catch (ImpalaException ex) {
            if (modification != null) {
                modification.cancelInflightEventIfExist();
            }
            throw ex;
        }
        finally {
            context.stop();
            this.UnlockWriteLockIfErronouslyLocked();
            table.releaseWriteLock();
        }
        catalogTimeline.markEvent("Finished updateCatalog request");
        if (update.isSync_ddl()) {
            response.getResult().setVersion(this.catalog_.waitForSyncDdlVersion(response.getResult()));
            catalogTimeline.markEvent(SENT_CATALOG_FOR_SYNC_DDL);
        }
        if (update.isSetDebug_action()) {
            DebugUtils.executeDebugAction(update.getDebug_action(), "catalogd_insert_finish_delay");
        }
        TRuntimeProfileNode profile = Frontend.createTRuntimeProfileNode("CatalogOp");
        profile.addToEvent_sequences(catalogTimeline.toThrift());
        response.setProfile(profile);
        return response;
    }

    private AcidUtils.TblTransaction createTableTransactionIfApplicable(TUpdateCatalogRequest update, EventSequence catalogTimeline, org.apache.impala.catalog.Table table) throws ImpalaException {
        AcidUtils.TblTransaction tblTxn = null;
        if (update.isSetTransaction_id()) {
            long transactionId = update.getTransaction_id();
            Preconditions.checkState((transactionId > 0L ? 1 : 0) != 0);
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                if (DebugUtils.hasDebugAction(update.getDebug_action(), "catalogd_update_catalog_abort_txn")) {
                    MetastoreShim.abortTransaction(msClient.getHiveClient(), transactionId);
                    LOG.info("Aborted txn due to the debug action.");
                }
                tblTxn = MetastoreShim.createTblTransaction(msClient.getHiveClient(), table.getMetaStoreTable(), transactionId);
                catalogTimeline.markEvent("Created Metastore transaction");
            }
        }
        return tblTxn;
    }

    private void updatePartitionMetadataAndCacheStatus(HashSet<String> pickupExistingPartitions, List<FeFsPartition> affectedExistingPartitions, FeFsPartition partition, List<Partition> hmsPartitionsStatsUnset, List<Long> cacheDirIds) throws ImpalaException {
        String partName = partition.getPartitionName();
        if (pickupExistingPartitions.remove(partName)) {
            affectedExistingPartitions.add(partition);
            if (partition.getParameters() != null && partition.getParameters().containsKey("COLUMN_STATS_ACCURATE")) {
                Partition hmsPartition = ((HdfsPartition)partition).toHmsPartition();
                hmsPartition.getParameters().remove("COLUMN_STATS_ACCURATE");
                hmsPartitionsStatsUnset.add(hmsPartition);
            }
            if (partition.isMarkedCached()) {
                cacheDirIds.add(HdfsCachingUtil.getCacheDirectiveId(partition.getParameters()));
            }
        }
    }

    private void addPartitionNamesInMetastore(org.apache.impala.catalog.Table table, TableName tblName, HashSet<String> partsToCreate, Map<String, List<String>> addedPartitionNames, String cachePoolName, Short cacheReplication, EventSequence catalogTimeline, Map<String, Long> partitionToEventId, List<Long> cacheDirIds, org.apache.hadoop.hive.metastore.api.Table msTbl, List<String> errorMessages) throws ImpalaException {
        block26: {
            if (!partsToCreate.isEmpty()) {
                try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
                    ArrayList hmsParts = Lists.newArrayList();
                    HiveConf hiveConf = new HiveConf(this.getClass());
                    Warehouse warehouse = new Warehouse((Configuration)hiveConf);
                    for (String string : partsToCreate) {
                        Partition partition = new Partition();
                        hmsParts.add(partition);
                        partition.setDbName(tblName.getDb());
                        partition.setTableName(tblName.getTbl());
                        partition.setValues(MetaStoreUtil.getPartValsFromName(msTbl, string));
                        partition.setSd(MetaStoreUtil.shallowCopyStorageDescriptor(msTbl.getSd()));
                        partition.getSd().setLocation(msTbl.getSd().getLocation() + "/" + string);
                        if (AcidUtils.isTransactionalTable(msTbl.getParameters())) {
                            this.addCatalogServiceIdentifiers(msTbl, partition);
                        }
                        MetastoreShim.updatePartitionStatsFast(partition, msTbl, warehouse);
                    }
                    List<Partition> addedHmsParts = this.addHmsPartitions(msClient, table, hmsParts, partitionToEventId, true, catalogTimeline);
                    for (Partition partition : addedHmsParts) {
                        String part_name = FeCatalogUtils.getPartitionName((FeFsTable)((Object)table), partition.getValues());
                        addedPartitionNames.put(part_name, partition.getValues());
                    }
                    if (addedHmsParts.size() <= 0 || cachePoolName == null) break block26;
                    ArrayList arrayList = Lists.newArrayList();
                    for (Partition part : addedHmsParts) {
                        try {
                            cacheDirIds.add(HdfsCachingUtil.submitCachePartitionDirective(part, cachePoolName, (short)cacheReplication));
                            StatsSetupConst.setBasicStatsState((Map)part.getParameters(), (String)"false");
                            arrayList.add(part);
                        }
                        catch (ImpalaRuntimeException e) {
                            String msg = String.format("Partition %s.%s(%s): State: Not cached. Action: Cache manully via 'ALTER TABLE'.", part.getDbName(), part.getTableName(), part.getValues());
                            LOG.error(msg, (Throwable)e);
                            errorMessages.add(msg);
                        }
                    }
                    try {
                        MetastoreShim.alterPartitions(msClient.getHiveClient(), tblName.getDb(), tblName.getTbl(), arrayList);
                    }
                    catch (Exception exception) {
                        LOG.error("Failed in alter_partitions: ", (Throwable)exception);
                        for (Partition part : arrayList) {
                            try {
                                HdfsCachingUtil.removePartitionCacheDirective(part.getParameters());
                            }
                            catch (ImpalaException e1) {
                                String msg = String.format("Partition %s.%s(%s): State: Leaked caching directive. Action: Manually uncache directory %s via hdfs cacheAdmin.", part.getDbName(), part.getTableName(), part.getValues(), part.getSd().getLocation());
                                LOG.error(msg, (Throwable)exception);
                                errorMessages.add(msg);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new InternalException("Error adding partitions", e);
                }
            }
        }
    }

    private void insertIntoIcebergTable(org.apache.impala.catalog.Table table, TUpdateCatalogRequest update, EventSequence catalogTimeline, InProgressTableModification modification) throws ImpalaException {
        FeIcebergTable iceTbl = (FeIcebergTable)((Object)table);
        org.apache.iceberg.Transaction iceTxn = IcebergUtil.getIcebergTransaction(iceTbl);
        try {
            DebugUtils.executeDebugAction(update.getDebug_action(), "catalogd_iceberg_conflict");
            IcebergCatalogOpExecutor.execute(iceTbl, iceTxn, update.getIceberg_operation());
            catalogTimeline.markEvent("Executed Iceberg operation " + (Object)((Object)update.getIceberg_operation().getOperation()));
            if (this.isIcebergHmsIntegrationEnabled(iceTbl.getMetaStoreTable())) {
                modification.registerInflightEvent();
                IcebergCatalogOpExecutor.addCatalogVersionToTxn(iceTxn, this.catalog_.getCatalogServiceId(), modification.newVersionNumber());
                catalogTimeline.markEvent("Updated table properties");
            }
            DebugUtils.executeDebugAction(update.getDebug_action(), "catalogd_iceberg_commit");
            iceTxn.commitTransaction();
        }
        catch (CommitStateUnknownException u) {
            throw new ImpalaRuntimeException(u.getMessage(), u);
        }
        catch (Exception e) {
            IcebergCatalogOpExecutor.cleanupUncommittedFiles(update.getIceberg_operation());
            LOG.info("Cleaned up uncommitted data files after failing to commit them to table {}", (Object)table.getFullName());
            throw new ImpalaRuntimeException(e.getMessage(), e);
        }
        modification.markInflightEventRegistrationComplete();
    }

    private void createInsertEvents(FeFsTable table, Map<String, List<FileMetadata>> updatedPartitions, Map<String, List<String>> addedPartitionNames, boolean isInsertOverwrite, AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline) throws CatalogException, MetaException {
        if (!this.shouldGenerateInsertEvents(table)) {
            return;
        }
        long txnId = tblTxn == null ? -1L : tblTxn.txnId;
        long writeId = tblTxn == null ? -1L : tblTxn.writeId;
        boolean isTransactional = AcidUtils.isTransactionalTable(table);
        if (isTransactional) {
            Preconditions.checkState((txnId > 0L ? 1 : 0) != 0, (String)"Invalid transaction id %s for table %s", (long)txnId, (Object)table.getFullName());
            Preconditions.checkState((writeId > 0L ? 1 : 0) != 0, (String)"Invalid write id %s for table %s", (long)writeId, (Object)table.getFullName());
        }
        boolean isPartitioned = table.getNumClusteringCols() > 0;
        ArrayList<InsertEventRequestData> insertEventReqDatas = new ArrayList<InsertEventRequestData>();
        ArrayList<List<String>> insertEventPartVals = new ArrayList<List<String>>();
        LinkedHashSet<String> existingPartSetInHms = new LinkedHashSet<String>();
        if (isPartitioned) {
            existingPartSetInHms.addAll(updatedPartitions.keySet());
            existingPartSetInHms.removeAll(addedPartitionNames.keySet());
            for (String string : existingPartSetInHms) {
                List<String> partVals = MetaStoreUtil.getPartValsFromName(table.getMetaStoreTable(), string);
                this.prepareInsertEventData(table, string, partVals, updatedPartitions, isInsertOverwrite, isPartitioned, insertEventReqDatas, insertEventPartVals);
            }
        } else {
            Preconditions.checkState((updatedPartitions.size() == 1 ? 1 : 0) != 0);
            this.prepareInsertEventData(table, "", Collections.emptyList(), updatedPartitions, isInsertOverwrite, isPartitioned, insertEventReqDatas, insertEventPartVals);
        }
        if (isTransactional) {
            for (Map.Entry entry : addedPartitionNames.entrySet()) {
                this.prepareInsertEventData(table, (String)entry.getKey(), (List)entry.getValue(), updatedPartitions, isInsertOverwrite, isPartitioned, insertEventReqDatas, insertEventPartVals);
            }
        }
        if (insertEventReqDatas.isEmpty()) {
            return;
        }
        catalogTimeline.markEvent("Prepared InsertEvent data");
        MetaStoreClientPool.MetaStoreClient metaStoreClient = this.catalog_.getMetaStoreClient(catalogTimeline);
        MetaStoreUtil.TableInsertEventInfo tableInsertEventInfo = new MetaStoreUtil.TableInsertEventInfo(insertEventReqDatas, insertEventPartVals, isTransactional, txnId, writeId);
        List<Long> eventIds = MetastoreShim.fireInsertEvents(metaStoreClient, tableInsertEventInfo, table.getDb().getName(), table.getName());
        catalogTimeline.markEvent("Fired Metastore events");
        if (isTransactional) {
            Preconditions.checkState((boolean)eventIds.isEmpty());
            return;
        }
        this.trackInsertEvents((HdfsTable)table, eventIds, existingPartSetInHms);
    }

    private void prepareInsertEventData(FeFsTable table, String partName, List<String> partVals, Map<String, List<FileMetadata>> updatedPartitions, boolean isInsertOverwrite, boolean isPartitioned, List<InsertEventRequestData> insertEventReqDatas, List<List<String>> insertEventPartVals) {
        List<FileMetadata> newFiles = updatedPartitions.get(partName);
        if (!newFiles.isEmpty() || isInsertOverwrite) {
            LOG.info("{} new files detected for table {}{}", new Object[]{newFiles.size(), table.getFullName(), isPartitioned ? " partition " + partName : ""});
            insertEventReqDatas.add(this.makeInsertEventData(table, partVals, newFiles, isInsertOverwrite));
            insertEventPartVals.add(partVals);
        }
    }

    private void trackInsertEvents(HdfsTable table, List<Long> eventIds, LinkedHashSet<String> existingPartsInHms) {
        if (eventIds == null || eventIds.isEmpty()) {
            return;
        }
        if (table.getNumClusteringCols() == 0) {
            Preconditions.checkState((eventIds.size() == 1 ? 1 : 0) != 0);
            this.catalog_.addVersionsForInflightEvents(true, table, eventIds.get(0));
        } else {
            Preconditions.checkState((existingPartsInHms.size() == eventIds.size() ? 1 : 0) != 0);
            int par_idx = 0;
            for (String partName : existingPartsInHms) {
                long eventId;
                if (table.addInflightInsertEventToPartition(partName, eventId = eventIds.get(par_idx++).longValue())) continue;
                LOG.warn("INSERT event {} on partition {} of table {} are not tracked since it doesn't exist in catalogd cache", new Object[]{eventId, partName, table.getFullName()});
            }
        }
    }

    private boolean shouldGenerateInsertEvents(FeFsTable table) {
        if (table instanceof FeIcebergTable) {
            return false;
        }
        return BackendConfig.INSTANCE.isInsertEventsEnabled();
    }

    private FileSystem getFileSystemOrNull(FeFsTable table) {
        try {
            return table.getFileSystem();
        }
        catch (CatalogException e) {
            LOG.warn("Failed to get FileSystem for table {}", (Object)table.getFullName(), (Object)e);
            return null;
        }
    }

    private Map<String, List<FileMetadata>> getFileMetadata(FeFsTable table, Map<String, TUpdatedPartition> updatedPartitions, String debugAction, EventSequence catalogTimeline) {
        if (!this.shouldGenerateInsertEvents(table)) {
            return null;
        }
        boolean isPartitioned = table.isPartitioned();
        boolean isTransactional = AcidUtils.isTransactionalTable(table);
        FileSystem tableFs = this.getFileSystemOrNull(table);
        ArrayList<Pair<String, Callable<Object>>> loaders = new ArrayList<Pair<String, Callable<Object>>>();
        ArrayList<Consumer<Object>> updaters = new ArrayList<Consumer<Object>>();
        HashMap fileMetadata = Maps.newHashMap();
        int numFiles = 0;
        for (Map.Entry<String, TUpdatedPartition> e : updatedPartitions.entrySet()) {
            numFiles += e.getValue().getFiles().size();
            ArrayList files = new ArrayList(e.getValue().getFiles().size());
            for (String file : e.getValue().getFiles()) {
                loaders.add(new Pair<String, Callable<Object>>(file, () -> {
                    FileChecksum checksum = null;
                    String acidDirPath = null;
                    try {
                        FileSystem fs;
                        Path filePath = new Path(file);
                        FileSystem fileSystem = fs = isPartitioned || tableFs == null ? FeFsTable.getFileSystem(filePath) : tableFs;
                        if (debugAction != null) {
                            DebugUtils.executeDebugAction(debugAction, "catalogd_load_file_checksums_delay");
                        }
                        checksum = fs.getFileChecksum(filePath);
                        if (isTransactional) {
                            acidDirPath = AcidUtils.getFirstLevelAcidDirPath(filePath, fs);
                        }
                    }
                    catch (IOException | CatalogException ex) {
                        LOG.error("Failed to collect insert metadata for {} in table {}", new Object[]{file, table.getFullName(), ex});
                    }
                    return new FileMetadata(file, checksum, acidDirPath);
                }));
                updaters.add(result -> files.add((FileMetadata)result));
                fileMetadata.put(e.getKey(), files);
            }
        }
        String logPrefix = String.format("Loading file checksums for %s paths for table %s", numFiles, table.getFullName());
        try {
            new ParallelFileMetadataLoader(table.getFileSystem(), logPrefix, loaders, updaters).load();
        }
        catch (CatalogException e) {
            LOG.error("Failed to collect insert metadata for table {}", (Object)table.getFullName(), (Object)e);
        }
        catalogTimeline.markEvent("Collected file checksums");
        return fileMetadata;
    }

    private InsertEventRequestData makeInsertEventData(FeFsTable tbl, List<String> partVals, List<FileMetadata> newFiles, boolean isInsertOverwrite) {
        Preconditions.checkNotNull(newFiles);
        Preconditions.checkNotNull(partVals);
        InsertEventRequestData insertEventRequestData = new InsertEventRequestData(new ArrayList(newFiles.size()));
        boolean isTransactional = AcidUtils.isTransactionalTable(tbl);
        MetastoreShim.setPartitionVal(insertEventRequestData, partVals);
        insertEventRequestData.setReplace(isInsertOverwrite);
        for (FileMetadata metadata : newFiles) {
            insertEventRequestData.addToFilesAdded(metadata.filename);
            insertEventRequestData.addToFilesAddedChecksum(metadata.getChecksum());
            if (!isTransactional) continue;
            MetastoreShim.addToSubDirectoryList(insertEventRequestData, metadata.acidDirPath);
        }
        return insertEventRequestData;
    }

    public org.apache.impala.catalog.Table getExistingTable(String dbName, String tblName, String reason, EventSequence catalogTimeline) throws CatalogException {
        org.apache.impala.catalog.Table tbl = this.catalog_.getOrLoadTable(dbName, tblName, reason, null, -1L, catalogTimeline);
        if (tbl == null) {
            throw new TableNotFoundException("Table not found: " + dbName + "." + tblName);
        }
        tbl.incrementMetadataOpsCount();
        if (!tbl.isLoaded()) {
            throw new CatalogException(String.format("Table '%s.%s' was modified while operation was in progress, aborting execution.", dbName, tblName));
        }
        if (tbl instanceof IncompleteTable && tbl.isLoaded()) {
            ImpalaException e = ((IncompleteTable)tbl).getCause();
            if (e instanceof TableLoadingException) {
                throw (TableLoadingException)e;
            }
            throw new TableLoadingException(e.getMessage(), e);
        }
        Preconditions.checkNotNull((Object)tbl);
        Preconditions.checkState((boolean)tbl.isLoaded());
        return tbl;
    }

    private void alterCommentOn(TDdlExecRequest ddlRequest, TDdlExecResponse response, Optional<TTableName> tTableName, boolean wantMinimalResult, EventSequence catalogTimeline) throws ImpalaRuntimeException, CatalogException, InternalException {
        Preconditions.checkState((boolean)tTableName.isPresent());
        TCommentOnParams params = ddlRequest.getComment_on_params();
        if (params.getDb() != null) {
            Preconditions.checkArgument((!params.isSetTable_name() && !params.isSetColumn_name() ? 1 : 0) != 0);
            tTableName.get().setDb_name(params.db);
            this.catalogOpTracker_.increment(ddlRequest, tTableName);
            this.alterCommentOnDb(params.getDb(), params.getComment(), wantMinimalResult, response, catalogTimeline);
        } else if (params.getTable_name() != null) {
            Preconditions.checkArgument((!params.isSetDb() && !params.isSetColumn_name() ? 1 : 0) != 0);
            tTableName.get().setDb_name(params.table_name.db_name);
            tTableName.get().setTable_name(params.table_name.table_name);
            this.catalogOpTracker_.increment(ddlRequest, tTableName);
            this.alterCommentOnTableOrView(TableName.fromThrift(params.getTable_name()), params.getComment(), wantMinimalResult, response, catalogTimeline, ddlRequest.getQuery_options().getDebug_action());
        } else if (params.getColumn_name() != null) {
            Preconditions.checkArgument((!params.isSetDb() && !params.isSetTable_name() ? 1 : 0) != 0);
            TColumnName columnName = params.getColumn_name();
            tTableName.get().setDb_name(columnName.table_name.table_name);
            tTableName.get().setTable_name(columnName.table_name.table_name);
            this.catalogOpTracker_.increment(ddlRequest, tTableName);
            this.alterCommentOnColumn(TableName.fromThrift(columnName.getTable_name()), columnName.getColumn_name(), params.getComment(), wantMinimalResult, response, catalogTimeline, ddlRequest.getQuery_options().getDebug_action());
        } else {
            throw new UnsupportedOperationException("Unsupported COMMENT ON operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterCommentOnDb(String dbName, String comment, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaRuntimeException, CatalogException, InternalException {
        Db db = this.catalog_.getDb(dbName);
        if (db == null) {
            throw new CatalogException("Database: " + dbName + " does not exist.");
        }
        this.tryLock(db, "altering the comment", catalogTimeline);
        long newCatalogVersion = this.catalog_.incrementAndGetCatalogVersion();
        this.catalog_.getLock().writeLock().unlock();
        try {
            Database msDb = db.getMetaStoreDb().deepCopy();
            this.addCatalogServiceIdentifiers(msDb, this.catalog_.getCatalogServiceId(), newCatalogVersion);
            msDb.setDescription(comment);
            this.applyAlterDatabase(msDb, catalogTimeline);
            Db updatedDb = this.catalog_.updateDb(msDb);
            catalogTimeline.markEvent("Updated database in catalog cache");
            this.addDbToCatalogUpdate(updatedDb, wantMinimalResult, response.result);
            this.catalog_.addVersionsForInflightEvents(db, newCatalogVersion);
        }
        finally {
            db.getLock().unlock();
        }
        CatalogOpExecutor.addSummary(response, "Updated database.");
    }

    private void alterDatabase(TAlterDbParams params, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        Preconditions.checkNotNull((Object)params);
        String dbName = params.getDb();
        Db db = this.catalog_.getDb(dbName);
        if (db == null) {
            throw new CatalogException("Database: " + dbName + " does not exist.");
        }
        switch (params.getAlter_type()) {
            case SET_OWNER: {
                this.alterDatabaseSetOwner(db, params.getSet_owner_params(), wantMinimalResult, response, catalogTimeline);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown ALTER DATABASE operation type: " + (Object)((Object)params.getAlter_type()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterDatabaseSetOwner(Db db, TAlterDbSetOwnerParams params, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline) throws ImpalaException {
        Preconditions.checkNotNull((Object)params.owner_name);
        Preconditions.checkNotNull((Object)((Object)params.owner_type));
        this.tryLock(db, "altering the owner", catalogTimeline);
        long newCatalogVersion = this.catalog_.incrementAndGetCatalogVersion();
        this.catalog_.getLock().writeLock().unlock();
        try {
            Database msDb = db.getMetaStoreDb().deepCopy();
            this.addCatalogServiceIdentifiers(msDb, this.catalog_.getCatalogServiceId(), newCatalogVersion);
            String originalOwnerName = msDb.getOwnerName();
            PrincipalType originalOwnerType = msDb.getOwnerType();
            msDb.setOwnerName(params.owner_name);
            msDb.setOwnerType(PrincipalType.valueOf((String)params.owner_type.name()));
            this.applyAlterDatabase(msDb, catalogTimeline);
            if (this.authzConfig_.isEnabled()) {
                this.authzManager_.updateDatabaseOwnerPrivilege(params.server_name, db.getName(), originalOwnerName, originalOwnerType, msDb.getOwnerName(), msDb.getOwnerType(), response);
            }
            Db updatedDb = this.catalog_.updateDb(msDb);
            catalogTimeline.markEvent("Updated database in catalog cache");
            this.addDbToCatalogUpdate(updatedDb, wantMinimalResult, response.result);
            this.catalog_.addVersionsForInflightEvents(db, newCatalogVersion);
        }
        finally {
            db.getLock().unlock();
        }
        CatalogOpExecutor.addSummary(response, "Updated database.");
    }

    private void addCatalogServiceIdentifiers(Database msDb, String catalogServiceId, long newCatalogVersion) {
        if (!this.catalog_.isEventProcessingEnabled()) {
            return;
        }
        Preconditions.checkNotNull((Object)msDb);
        msDb.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), catalogServiceId);
        msDb.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), String.valueOf(newCatalogVersion));
    }

    private void addDbToCatalogUpdate(Db db, boolean wantMinimalResult, TCatalogUpdateResult result) {
        Preconditions.checkNotNull((Object)db);
        TCatalogObject updatedCatalogObject = wantMinimalResult ? db.toMinimalTCatalogObject() : db.toTCatalogObject();
        result.addToUpdated_catalog_objects(updatedCatalogObject);
        result.setVersion(updatedCatalogObject.getCatalog_version());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterCommentOnTableOrView(TableName tableName, String comment, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline, @Nullable String debugAction) throws CatalogException, InternalException, ImpalaRuntimeException {
        org.apache.impala.catalog.Table tbl = this.getExistingTable(tableName.getDb(), tableName.getTbl(), "Load for ALTER COMMENT", catalogTimeline);
        this.tryWriteLock(tbl, catalogTimeline);
        try {
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, tbl);
            this.catalog_.getLock().writeLock().unlock();
            modification.addCatalogServiceIdentifiersToTable();
            org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
            boolean isView = msTbl.getTableType().equalsIgnoreCase(TableType.VIRTUAL_VIEW.toString());
            if (comment == null) {
                msTbl.getParameters().remove("comment");
            } else {
                msTbl.getParameters().put("comment", comment);
            }
            this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
            this.loadTableMetadata(tbl, modification.newVersionNumber(), false, false, "ALTER COMMENT", debugAction, catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, response.result);
            CatalogOpExecutor.addSummary(response, String.format("Updated %s.", isView ? "view" : "table"));
            modification.validateInProgressModificationComplete();
        }
        finally {
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterCommentOnColumn(TableName tableName, String columnName, String comment, boolean wantMinimalResult, TDdlExecResponse response, EventSequence catalogTimeline, @Nullable String debugAction) throws CatalogException, InternalException, ImpalaRuntimeException {
        org.apache.impala.catalog.Table tbl = this.getExistingTable(tableName.getDb(), tableName.getTbl(), "Load for ALTER COLUMN COMMENT", catalogTimeline);
        this.tryWriteLock(tbl, catalogTimeline);
        try {
            InProgressTableModification modification = new InProgressTableModification(this.catalog_, tbl);
            this.catalog_.getLock().writeLock().unlock();
            modification.addCatalogServiceIdentifiersToTable();
            if (tbl instanceof KuduTable) {
                TColumn new_col = new TColumn(columnName, tbl.getColumn(columnName).getType().toThrift());
                new_col.setComment(comment != null ? comment : "");
                KuduCatalogOpExecutor.alterColumn((KuduTable)tbl, columnName, new_col, catalogTimeline);
            } else {
                org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable().deepCopy();
                if (!CatalogOpExecutor.updateColumnComment(msTbl.getSd().getColsIterator(), columnName, comment) && !CatalogOpExecutor.updateColumnComment(msTbl.getPartitionKeysIterator(), columnName, comment)) {
                    throw new ColumnNotFoundException(String.format("Column name %s not found in table %s.", columnName, tbl.getFullName()));
                }
                this.applyAlterAndInProgressTableModification(msTbl, catalogTimeline, modification);
            }
            this.loadTableMetadata(tbl, modification.newVersionNumber(), false, true, "ALTER COLUMN COMMENT", debugAction, catalogTimeline);
            CatalogOpExecutor.addTableToCatalogUpdate(tbl, wantMinimalResult, response.result);
            CatalogOpExecutor.addSummary(response, "Column has been altered.");
            modification.validateInProgressModificationComplete();
        }
        finally {
            tbl.releaseWriteLock();
        }
    }

    private static boolean updateColumnComment(Iterator<FieldSchema> iterator, String columnName, String comment) {
        while (iterator.hasNext()) {
            FieldSchema fs = iterator.next();
            if (!fs.getName().equalsIgnoreCase(columnName)) continue;
            fs.setComment(comment);
            return true;
        }
        return false;
    }

    private void tryWriteLock(org.apache.impala.catalog.Table tbl, EventSequence catalogTimeline) throws InternalException {
        this.tryWriteLock(tbl, "altering", catalogTimeline);
    }

    private void tryWriteLock(org.apache.impala.catalog.Table tbl, String operation, EventSequence catalogTimeline) throws InternalException {
        String type;
        String string = type = tbl instanceof View ? "view" : "table";
        if (!this.catalog_.tryWriteLock(tbl, catalogTimeline)) {
            throw new InternalException(String.format("Error %s (for) %s %s due to lock contention.", operation, type, tbl.getFullName()));
        }
    }

    private void tryLock(Db db, String operation, EventSequence catalogTimeline) throws InternalException {
        if (!this.catalog_.tryLockDb(db)) {
            throw new InternalException(String.format("Error %s of database %s due to lock contention.", operation, db.getName()));
        }
        catalogTimeline.markEvent("Got database lock");
    }

    private void commitTransaction(long transactionId, EventSequence catalogTimeline) throws TransactionException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            MetastoreShim.commitTransaction(msClient.getHiveClient(), transactionId);
            catalogTimeline.markEvent("Committed Metastore transaction " + transactionId);
            LOG.info("Committed transaction: " + transactionId);
        }
    }

    private void unsetTableColStats(org.apache.hadoop.hive.metastore.api.Table msTable, AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        Map params = msTable.getParameters();
        if (params != null && params.containsKey("COLUMN_STATS_ACCURATE")) {
            params.remove("COLUMN_STATS_ACCURATE");
            this.applyAlterTable(msTable, false, tblTxn, catalogTimeline);
        }
    }

    private void unsetPartitionsColStats(org.apache.hadoop.hive.metastore.api.Table msTable, List<Partition> hmsPartitionsStatsUnset, AcidUtils.TblTransaction tblTxn, EventSequence catalogTimeline) throws ImpalaRuntimeException {
        try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            try {
                if (tblTxn != null) {
                    MetastoreShim.alterPartitionsWithTransaction(msClient.getHiveClient(), msTable.getDbName(), msTable.getTableName(), hmsPartitionsStatsUnset, tblTxn);
                } else {
                    MetastoreShim.alterPartitions(msClient.getHiveClient(), msTable.getDbName(), msTable.getTableName(), hmsPartitionsStatsUnset);
                }
                catalogTimeline.markEvent("Unset partition stats in Metastore");
            }
            catch (TException te) {
                throw new ImpalaRuntimeException(String.format(HMS_RPC_ERROR_FORMAT_STR, "alter_partitions"), te);
            }
        }
    }

    private class FileMetadata {
        String filename;
        FileChecksum checksum;
        String acidDirPath;

        FileMetadata(String filename, FileChecksum checksum, String acidDirPath) {
            this.filename = filename;
            this.checksum = checksum;
            this.acidDirPath = acidDirPath;
        }

        String getChecksum() {
            return this.checksum == null ? "" : StringUtils.byteToHexString((byte[])this.checksum.getBytes(), (int)0, (int)this.checksum.getLength());
        }
    }

    private static enum UpdatePartitionMethod {
        NONE,
        IN_PLACE,
        MARK_DIRTY;

    }

    private static class InProgressTableModification {
        private final CatalogServiceCatalog catalog_;
        private final org.apache.impala.catalog.Table table_;
        private final long newVersionNumber_;
        private boolean inflightEventAdded_ = false;
        private boolean inflightEventRegistrationOngoing_ = false;

        public InProgressTableModification(CatalogServiceCatalog catalog, org.apache.impala.catalog.Table table) {
            this.catalog_ = catalog;
            this.table_ = table;
            this.newVersionNumber_ = catalog.incrementAndGetCatalogVersion();
        }

        public long newVersionNumber() {
            return this.newVersionNumber_;
        }

        public void registerInflightEvent() {
            if (this.inflightEventAdded_) {
                return;
            }
            if (this.catalog_.addVersionsForInflightEvents(false, this.table_, this.newVersionNumber_)) {
                this.inflightEventAdded_ = true;
                this.inflightEventRegistrationOngoing_ = true;
            }
        }

        public void cancelInflightEventIfExist() {
            boolean isRemoved = this.table_.removeFromVersionsForInflightEvents(false, this.newVersionNumber_);
            LOG.info("Cancel in-progress in-flight event of table " + this.table_.getFullName() + ". versionNumber=" + this.newVersionNumber_ + " isRemoved=" + isRemoved + " inflightEventAdded_=" + this.inflightEventAdded_);
            this.markInflightEventRegistrationComplete();
        }

        public void markInflightEventRegistrationComplete() {
            this.inflightEventRegistrationOngoing_ = false;
        }

        public void updateTableCatalogVersion() {
            this.table_.setCatalogVersion(this.newVersionNumber_);
        }

        private void addCatalogServiceIdentifiersToTable() {
            if (!this.catalog_.isEventProcessingEnabled()) {
                return;
            }
            org.apache.hadoop.hive.metastore.api.Table msTbl = this.table_.getMetaStoreTable();
            msTbl.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), this.catalog_.getCatalogServiceId());
            msTbl.putToParameters(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), String.valueOf(this.newVersionNumber_));
        }

        public boolean isInProgress() {
            return this.table_.hasInProgressModification() || this.inflightEventRegistrationOngoing_;
        }

        public void validateInProgressModificationComplete() {
            Preconditions.checkState((!this.table_.hasInProgressModification() ? 1 : 0) != 0, (String)"Table %s still has in-progress modification.", (Object)this.table_.getFullName());
            Preconditions.checkState((!this.inflightEventRegistrationOngoing_ ? 1 : 0) != 0, (String)"Table %s still has incomplete self-event registration.", (Object)this.table_.getFullName());
        }
    }
}

