/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.impala.common.Pair;
import org.apache.impala.common.UserCancelledException;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.TUniqueIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Canceller {
    private static final Logger LOG = LoggerFactory.getLogger(Canceller.class);
    private static final ConcurrentHashMap<TUniqueId, Pair<Thread, AtomicBoolean>> queryThreads_ = new ConcurrentHashMap();
    private static final ThreadLocal<AtomicBoolean> cancelled_ = new ThreadLocal();

    private Canceller() {
    }

    public static Registration register(TUniqueId queryId) {
        if (queryId == null) {
            return null;
        }
        LOG.trace("register {}", (Object)TUniqueIdUtil.PrintId(queryId));
        cancelled_.set(new AtomicBoolean(false));
        queryThreads_.put(queryId, new Pair<Thread, AtomicBoolean>(Thread.currentThread(), cancelled_.get()));
        return new Registration(queryId);
    }

    public static void cancel(TUniqueId queryId) {
        if (queryId == null) {
            return;
        }
        Pair<Thread, AtomicBoolean> queryPair = queryThreads_.get(queryId);
        if (queryPair == null) {
            LOG.info("Unable to cancel request: thread for query {} not found", (Object)TUniqueIdUtil.PrintId(queryId));
            return;
        }
        Thread queryThread = (Thread)queryPair.first;
        LOG.debug("Cancelling request: thread {} for query {}", (Object)queryThread, (Object)TUniqueIdUtil.PrintId(queryId));
        ((AtomicBoolean)queryPair.second).set(true);
        queryThread.interrupt();
    }

    public static void throwIfCancelled() throws UserCancelledException {
        if (Canceller.isCancelled()) {
            throw new UserCancelledException();
        }
    }

    private static boolean isCancelled() {
        AtomicBoolean cancelled = cancelled_.get();
        return cancelled != null && cancelled.get();
    }

    public static class Registration
    implements AutoCloseable {
        private final TUniqueId queryId_;

        public Registration(TUniqueId queryId) {
            this.queryId_ = queryId;
        }

        @Override
        public void close() {
            LOG.trace("unregister {}", (Object)TUniqueIdUtil.PrintId(this.queryId_));
            Pair curr = (Pair)queryThreads_.remove(this.queryId_);
            Preconditions.checkState((curr.first == Thread.currentThread() ? 1 : 0) != 0);
            Preconditions.checkState((curr.second == cancelled_.get() ? 1 : 0) != 0);
            cancelled_.remove();
        }
    }
}

