/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TGeospatialLibrary;

public class BackendConfig {
    public static BackendConfig INSTANCE;
    private TBackendGflags backendCfg_;
    private long warnCatalogResponseSize_;
    private long warnCatalogResponseDurationMs_;

    private BackendConfig(TBackendGflags cfg) {
        this.backendCfg_ = cfg;
        this.warnCatalogResponseSize_ = (long)cfg.warn_catalog_response_size_mb * 1024L * 1024L;
        this.warnCatalogResponseDurationMs_ = (long)cfg.warn_catalog_response_duration_s * 1000L;
    }

    public static void create(TBackendGflags cfg) {
        BackendConfig.create(cfg, true);
    }

    public static void create(TBackendGflags cfg, boolean initialize) {
        Preconditions.checkNotNull((Object)cfg);
        INSTANCE = new BackendConfig(cfg);
        if (initialize) {
            SqlScanner.init(cfg.getReserved_words_version());
            BackendConfig.initAuthToLocal();
        }
    }

    public TBackendGflags getBackendCfg() {
        return this.backendCfg_;
    }

    public long getReadSize() {
        return this.backendCfg_.read_size;
    }

    public boolean getComputeLineage() {
        return !Strings.isNullOrEmpty((String)this.backendCfg_.lineage_event_log_dir) || !Strings.isNullOrEmpty((String)this.getQueryExecHookClasses());
    }

    public long getIncStatsMaxSize() {
        return this.backendCfg_.inc_stats_size_limit_bytes;
    }

    public boolean isStatsExtrapolationEnabled() {
        return this.backendCfg_.enable_stats_extrapolation;
    }

    public boolean isAuthToLocalEnabled() {
        return this.backendCfg_.load_auth_to_local_rules && !Strings.isNullOrEmpty((String)this.backendCfg_.principal);
    }

    public int getKuduClientTimeoutMs() {
        return this.backendCfg_.kudu_operation_timeout_ms;
    }

    public String getKuduSaslProtocolName() {
        return this.backendCfg_.kudu_sasl_protocol_name;
    }

    public String getImpalaBuildVersion() {
        return this.backendCfg_.impala_build_version;
    }

    public int getImpalaLogLevel() {
        return this.backendCfg_.impala_log_lvl;
    }

    public int getNonImpalaJavaVlogLevel() {
        return this.backendCfg_.non_impala_java_vlog;
    }

    public int maxHdfsPartsParallelLoad() {
        return this.backendCfg_.max_hdfs_partitions_parallel_load;
    }

    public int maxNonHdfsPartsParallelLoad() {
        return this.backendCfg_.max_nonhdfs_partitions_parallel_load;
    }

    public double getMaxFilterErrorRate() {
        return this.backendCfg_.max_filter_error_rate;
    }

    public long getMinBufferSize() {
        return this.backendCfg_.min_buffer_size;
    }

    public boolean isAuthorizedProxyGroupEnabled() {
        return !Strings.isNullOrEmpty((String)this.backendCfg_.authorized_proxy_group_config);
    }

    public boolean isShellBasedGroupsMappingEnabled() {
        return this.backendCfg_.enable_shell_based_groups_mapping_support;
    }

    public boolean disableCatalogDataOpsDebugOnly() {
        return this.backendCfg_.disable_catalog_data_ops_debug_only;
    }

    public int getInvalidateTablesTimeoutS() {
        return this.backendCfg_.invalidate_tables_timeout_s;
    }

    public boolean invalidateTablesOnMemoryPressure() {
        return this.backendCfg_.invalidate_tables_on_memory_pressure;
    }

    public double getInvalidateTablesGcOldGenFullThreshold() {
        return this.backendCfg_.invalidate_tables_gc_old_gen_full_threshold;
    }

    public double getInvalidateTablesFractionOnMemoryPressure() {
        return this.backendCfg_.invalidate_tables_fraction_on_memory_pressure;
    }

    public int getLocalCatalogMaxFetchRetries() {
        return this.backendCfg_.local_catalog_max_fetch_retries;
    }

    public int getCatalogMaxParallelPartialFetchRpc() {
        return this.backendCfg_.catalog_max_parallel_partial_fetch_rpc;
    }

    public long getCatalogPartialFetchRpcQueueTimeoutS() {
        return this.backendCfg_.catalog_partial_fetch_rpc_queue_timeout_s;
    }

    public int getCatalogPartialFetchMaxFiles() {
        return this.backendCfg_.catalog_partial_fetch_max_files;
    }

    public double getHMSPollingIntervalInSeconds() {
        return this.backendCfg_.hms_event_polling_interval_s;
    }

    public boolean isInsertEventsEnabled() {
        return this.backendCfg_.enable_insert_events;
    }

    public String getAuthorizationFactoryClass() {
        String val = this.backendCfg_.getAuthorization_factory_class();
        return "".equals(val) ? null : val;
    }

    public boolean recursivelyListPartitions() {
        return this.backendCfg_.recursively_list_partitions;
    }

    public String getRangerServiceType() {
        return this.backendCfg_.getRanger_service_type();
    }

    public String getRangerAppId() {
        return this.backendCfg_.getRanger_app_id();
    }

    public String getAuthorizationProvider() {
        return this.backendCfg_.getAuthorization_provider();
    }

    public String getQueryExecHookClasses() {
        return this.backendCfg_.getQuery_event_hook_classes();
    }

    public int getNumQueryExecHookThreads() {
        return this.backendCfg_.getQuery_event_hook_nthreads();
    }

    public boolean useDedicatedCoordinatorEstimates() {
        return !this.backendCfg_.is_executor && this.backendCfg_.use_dedicated_coordinator_estimates;
    }

    public String getBlacklistedDbs() {
        return this.backendCfg_.blacklisted_dbs;
    }

    public String getBlacklistedTables() {
        return this.backendCfg_.blacklisted_tables;
    }

    public boolean isZOrderSortUnlocked() {
        return this.backendCfg_.unlock_zorder_sort;
    }

    public void setZOrderSortUnlocked(boolean zOrdering) {
        this.backendCfg_.setUnlock_zorder_sort(zOrdering);
    }

    public String getMinPrivilegeSetForShowStmts() {
        return this.backendCfg_.min_privilege_set_for_show_stmts;
    }

    public int getNumCheckAuthorizationThreads() {
        return this.backendCfg_.num_check_authorization_threads;
    }

    public boolean useCustomizedUserGroupsMapperForRanger() {
        return this.backendCfg_.use_customized_user_groups_mapper_for_ranger;
    }

    public void setColumnMaskingEnabled(boolean columnMaskingEnabled) {
        this.backendCfg_.setEnable_column_masking(columnMaskingEnabled);
    }

    public void setRowFilteringEnabled(boolean rowFilteringEnabled) {
        this.backendCfg_.setEnable_row_filtering(rowFilteringEnabled);
    }

    public boolean isColumnMaskingEnabled() {
        return this.backendCfg_.enable_column_masking;
    }

    public boolean isRowFilteringEnabled() {
        return this.backendCfg_.enable_row_filtering;
    }

    public boolean isCompactCatalogTopic() {
        return this.backendCfg_.compact_catalog_topic;
    }

    public boolean isIncrementalMetadataUpdatesEnabled() {
        return this.backendCfg_.enable_incremental_metadata_updates;
    }

    public String getSaml2KeystorePath() {
        return this.backendCfg_.saml2_keystore_path;
    }

    public String getSaml2KeystorePassword() {
        return this.backendCfg_.saml2_keystore_password;
    }

    public String getSaml2PrivateKeyPassword() {
        return this.backendCfg_.saml2_private_key_password;
    }

    public String getSaml2IdpMetadata() {
        return this.backendCfg_.saml2_idp_metadata;
    }

    public String getSaml2SpEntityId() {
        return this.backendCfg_.saml2_sp_entity_id;
    }

    public String getSaml2SpCallbackUrl() {
        return this.backendCfg_.saml2_sp_callback_url;
    }

    public boolean getSaml2WantAsserationsSigned() {
        return this.backendCfg_.saml2_want_assertations_signed;
    }

    public boolean getSaml2SignRequest() {
        return this.backendCfg_.saml2_sign_requests;
    }

    public int getSaml2CallbackTokenTtl() {
        return this.backendCfg_.saml2_callback_token_ttl;
    }

    public String getSaml2GroupAttibuteName() {
        return this.backendCfg_.saml2_group_attribute_name;
    }

    public String getSaml2GroupFilter() {
        return this.backendCfg_.saml2_group_filter;
    }

    public boolean getSaml2EETestMode() {
        return this.backendCfg_.saml2_ee_test_mode;
    }

    public String getScratchDirs() {
        return this.backendCfg_.scratch_dirs;
    }

    public boolean getAllowOrdinalsInHaving() {
        return this.backendCfg_.allow_ordinals_in_having;
    }

    public void setAllowOrdinalsInHaving(boolean allow_ordinals_in_having) {
        this.backendCfg_.allow_ordinals_in_having = allow_ordinals_in_having;
    }

    public long getWarnCatalogResponseSize() {
        return this.warnCatalogResponseSize_;
    }

    public long getWarnCatalogResponseDurationMs() {
        return this.warnCatalogResponseDurationMs_;
    }

    private static void initAuthToLocal() {
        String defaultRule = "RULE:[1:$1] RULE:[2:$1]";
        Configuration conf = new Configuration();
        if (INSTANCE.isAuthToLocalEnabled()) {
            KerberosName.setRules((String)conf.get("hadoop.security.auth_to_local", "DEFAULT"));
        } else {
            KerberosName.setRules((String)"RULE:[1:$1] RULE:[2:$1]");
        }
    }

    public boolean isDedicatedCoordinator() {
        return !this.backendCfg_.is_executor && this.backendCfg_.is_coordinator;
    }

    public int getMaxWaitTimeForSyncDdlSecs() {
        return this.backendCfg_.max_wait_time_for_sync_ddl_s;
    }

    public boolean startHmsServer() {
        return this.backendCfg_.start_hms_server;
    }

    public int getHMSPort() {
        return this.backendCfg_.hms_port;
    }

    public boolean fallbackToHMSOnErrors() {
        return this.backendCfg_.fallback_to_hms_on_errors;
    }

    @VisibleForTesting
    public void setEnableCatalogdHMSCache(boolean flag) {
        this.backendCfg_.enable_catalogd_hms_cache = flag;
    }

    public boolean enableCatalogdHMSCache() {
        return this.backendCfg_.enable_catalogd_hms_cache;
    }

    public boolean invalidateCatalogdHMSCacheOnDDLs() {
        return this.backendCfg_.invalidate_hms_cache_on_ddls;
    }

    public String getStartupFilesystemCheckDirectories() {
        return this.backendCfg_.startup_filesystem_check_directories;
    }

    public boolean getHMSEventIncrementalRefreshTransactionalTable() {
        return this.backendCfg_.hms_event_incremental_refresh_transactional_table;
    }

    public boolean isAutoCheckCompaction() {
        return this.backendCfg_.auto_check_compaction;
    }

    @VisibleForTesting
    public void setInvalidateCatalogdHMSCacheOnDDLs(boolean flag) {
        this.backendCfg_.invalidate_hms_cache_on_ddls = flag;
    }

    public boolean enableSyncToLatestEventOnDdls() {
        return this.backendCfg_.enable_sync_to_latest_event_on_ddls;
    }

    @VisibleForTesting
    public void setEnableSyncToLatestEventOnDdls(boolean flag) {
        this.backendCfg_.enable_sync_to_latest_event_on_ddls = flag;
    }

    public boolean enableReloadEvents() {
        return this.backendCfg_.enable_reload_events;
    }

    @VisibleForTesting
    public void setEnableReloadEvents(boolean flag) {
        this.backendCfg_.enable_reload_events = flag;
    }

    public boolean enableSkippingOlderEvents() {
        return this.backendCfg_.enable_skipping_older_events;
    }

    @VisibleForTesting
    public void setSkippingOlderEvents(boolean flag) {
        this.backendCfg_.enable_skipping_older_events = flag;
    }

    public boolean pullTableTypesAndComments() {
        return this.backendCfg_.pull_table_types_and_comments;
    }

    public boolean useHmsColumnOrderForHBaseTables() {
        return this.backendCfg_.use_hms_column_order_for_hbase_tables;
    }

    public String getIgnoredDirPrefixList() {
        return this.backendCfg_.ignored_dir_prefix_list;
    }

    public TGeospatialLibrary getGeospatialLibrary() {
        return this.backendCfg_.geospatial_library;
    }

    public double getQueryCpuCountDivisor() {
        return this.backendCfg_.query_cpu_count_divisor;
    }

    public boolean isProcessingCostUseEqualExprWeight() {
        return this.backendCfg_.processing_cost_use_equal_expr_weight;
    }

    public long getMinProcessingPerThread() {
        return this.backendCfg_.min_processing_per_thread;
    }

    public boolean isSkipResourceCheckingOnLastExecutorGroupSet() {
        return this.backendCfg_.skip_resource_checking_on_last_executor_group_set;
    }

    public int getThriftRpcMaxMessageSize() {
        return (int)Math.min(this.backendCfg_.thrift_rpc_max_message_size, Integer.MAX_VALUE);
    }

    public String getFileMetadataReloadProperties() {
        return this.backendCfg_.file_metadata_reload_properties;
    }

    @VisibleForTesting
    public void setFileMetadataReloadProperties(String newPropertiesConfig) {
        this.backendCfg_.file_metadata_reload_properties = newPropertiesConfig;
    }

    public float getScanRangeCostFactor() {
        return (float)this.backendCfg_.scan_range_cost_factor;
    }

    public boolean useJammWeigher() {
        return this.backendCfg_.use_jamm_weigher;
    }

    public boolean icebergAllowDatafileInTableLocationOnly() {
        return this.backendCfg_.iceberg_allow_datafiles_in_table_location_only;
    }

    public void setIcebergAllowDatafileInTableLocationOnly(boolean flag) {
        this.backendCfg_.iceberg_allow_datafiles_in_table_location_only = flag;
    }

    public boolean icebergAlwaysAllowMergeOnReadOperations() {
        return this.backendCfg_.iceberg_always_allow_merge_on_read_operations;
    }

    public long dataStreamSenderBufferSizeUsedByPlanner() {
        return this.backendCfg_.data_stream_sender_buffer_size_used_by_planner;
    }

    public boolean enableReadingPuffinStats() {
        return this.backendCfg_.enable_reading_puffin_stats;
    }

    public boolean isJsonScannerEnabled() {
        return this.backendCfg_.enable_json_scanner;
    }

    public double getMaxFilterErrorRateFromFullScan() {
        return this.backendCfg_.max_filter_error_rate_from_full_scan;
    }

    public int catalogOperationLogSize() {
        return this.backendCfg_.catalog_operation_log_size >= 0 ? this.backendCfg_.catalog_operation_log_size : Integer.MAX_VALUE;
    }

    public String getHostname() {
        return this.backendCfg_.hostname;
    }

    public boolean allowCatalogCacheOpFromMaskedUsers() {
        return this.backendCfg_.allow_catalog_cache_op_from_masked_users;
    }

    public String debugActions() {
        return this.backendCfg_.debug_actions;
    }

    public void setDebugActions(String debugActions) {
        this.backendCfg_.debug_actions = debugActions;
    }

    public boolean isInvalidateMetadataOnEventProcessFailureEnabled() {
        return this.backendCfg_.invalidate_metadata_on_event_processing_failure;
    }

    public boolean isInvalidateGlobalMetadataOnEventProcessFailureEnabled() {
        return this.backendCfg_.invalidate_global_metadata_on_event_processing_failure;
    }

    public void setInvalidateGlobalMetadataOnEventProcessFailure(boolean isEnabled) {
        this.backendCfg_.invalidate_global_metadata_on_event_processing_failure = isEnabled;
    }

    public String getProcessEventFailureEventTypes() {
        return this.backendCfg_.inject_process_event_failure_event_types;
    }

    public double getProcessEventFailureRatio() {
        return this.backendCfg_.inject_process_event_failure_ratio;
    }

    public boolean enableWorkloadMgmt() {
        return this.backendCfg_.enable_workload_mgmt;
    }

    @VisibleForTesting
    public void setEnableWorkloadMgmt(boolean enableWorkloadMgmt) {
        this.backendCfg_.enable_workload_mgmt = enableWorkloadMgmt;
    }

    public String queryLogTableName() {
        return this.backendCfg_.query_log_table_name;
    }

    public boolean isMinimalTopicMode() {
        return this.backendCfg_.catalog_topic_mode.equalsIgnoreCase("minimal");
    }

    public double getQueryCpuRootFactor() {
        return this.backendCfg_.query_cpu_root_factor;
    }

    public String getDefaultSkippedHmsEventTypes() {
        return this.backendCfg_.default_skipped_hms_event_types;
    }

    public String getCommonHmsEventTypes() {
        return this.backendCfg_.common_hms_event_types;
    }

    public int getDbcpMaxConnPoolSize() {
        return this.backendCfg_.dbcp_max_conn_pool_size;
    }

    public int getDbcpMaxWaitMillisForConn() {
        return this.backendCfg_.dbcp_max_wait_millis_for_conn;
    }

    public int getDbcpDataSourceIdleTimeoutInSeconds() {
        return this.backendCfg_.dbcp_data_source_idle_timeout;
    }

    public boolean isReleaseBuild() {
        return this.backendCfg_.is_release_build;
    }

    public boolean isCatalogdHAEnabled() {
        return this.backendCfg_.enable_catalogd_ha;
    }

    public String getInjectedGroupMembersDebugOnly() {
        return this.backendCfg_.injected_group_members_debug_only;
    }

    public boolean isHierarchicalEventProcessingEnabled() {
        return this.backendCfg_.enable_hierarchical_event_processing;
    }

    public int getNumDbEventExecutors() {
        return this.backendCfg_.num_db_event_executors;
    }

    public int getNumTableEventExecutorsPerDbEventExecutor() {
        return this.backendCfg_.num_table_event_executors_per_db_event_executor;
    }

    public int getMinEventProcessorIdleMs() {
        return this.backendCfg_.min_event_processor_idle_ms;
    }

    public int getMaxOutstandingEventsOnExecutors() {
        return this.backendCfg_.max_outstanding_events_on_executors;
    }

    public boolean consolidateGrantRevokeRequests() {
        return this.backendCfg_.consolidate_grant_revoke_requests;
    }

    public int icebergCatalogNumThreads() {
        return this.backendCfg_.iceberg_catalog_num_threads;
    }

    public int getResetMetadataLockDurationMs() {
        return this.backendCfg_.reset_metadata_lock_duration_ms;
    }

    public int getCatalogResetMaxThreads() {
        return this.backendCfg_.catalog_reset_max_threads;
    }

    public String getWarmupTablesConfigFile() {
        return this.backendCfg_.warmup_tables_config_file;
    }

    public boolean keepsWarmupTablesLoaded() {
        return this.backendCfg_.keeps_warmup_tables_loaded;
    }

    public boolean truncateExternalTablesWithHms() {
        return this.backendCfg_.truncate_external_tables_with_hms;
    }

    public double getTupleCacheCostCoefficientWriteBytes() {
        return this.backendCfg_.tuple_cache_cost_coefficient_write_bytes;
    }

    public double getTupleCacheCostCoefficientWriteRows() {
        return this.backendCfg_.tuple_cache_cost_coefficient_write_rows;
    }

    public double getTupleCacheCostCoefficientReadBytes() {
        return this.backendCfg_.tuple_cache_cost_coefficient_read_bytes;
    }

    public double getTupleCacheCostCoefficientReadRows() {
        return this.backendCfg_.tuple_cache_cost_coefficient_read_rows;
    }
}

