/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class SimplifyConditionalsRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new SimplifyConditionalsRule();
    private static List<String> IFNULL_ALIASES = ImmutableList.of((Object)"ifnull", (Object)"isnull", (Object)"nvl");

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        Expr simplified;
        if (!expr.isAnalyzed()) {
            return expr;
        }
        if (expr instanceof FunctionCallExpr) {
            simplified = this.simplifyFunctionCallExpr((FunctionCallExpr)expr);
        } else if (expr instanceof CompoundPredicate) {
            simplified = this.simplifyCompoundPredicate((CompoundPredicate)expr);
        } else if (expr instanceof CaseExpr) {
            simplified = this.simplifyCaseExpr((CaseExpr)expr, analyzer);
        } else {
            return expr;
        }
        if (expr != simplified) {
            simplified.analyze(analyzer);
            if (expr.contains(Expr.IS_AGGREGATE) && !simplified.contains(Expr.IS_AGGREGATE)) {
                return expr;
            }
        }
        return simplified;
    }

    private Expr simplifyIfFunctionCallExpr(FunctionCallExpr expr) {
        Preconditions.checkState((expr.getChildren().size() == 3 ? 1 : 0) != 0);
        Expr head = (Expr)expr.getChild(0);
        if (Expr.IS_TRUE_LITERAL.apply((Object)head)) {
            return (Expr)expr.getChild(1);
        }
        if (Expr.IS_FALSE_LITERAL.apply((Object)head)) {
            return (Expr)expr.getChild(2);
        }
        if (Expr.IS_NULL_LITERAL.apply((Object)head)) {
            return (Expr)expr.getChild(2);
        }
        return expr;
    }

    private Expr simplifyIfNullFunctionCallExpr(FunctionCallExpr expr) {
        Preconditions.checkState((expr.getChildren().size() == 2 ? 1 : 0) != 0);
        Expr child0 = (Expr)expr.getChild(0);
        if (Expr.IS_NULL_LITERAL.apply((Object)child0)) {
            return (Expr)expr.getChild(1);
        }
        if (Expr.IS_LITERAL.apply((Object)child0)) {
            return child0;
        }
        return expr;
    }

    private Expr simplifyCoalesceFunctionCallExpr(FunctionCallExpr expr) {
        int numChildren = expr.getChildren().size();
        Expr result = NullLiteral.create(expr.getType());
        for (int i = 0; i < numChildren; ++i) {
            Expr childExpr = (Expr)expr.getChildren().get(i);
            if (Expr.IS_NULL_VALUE.apply((Object)childExpr)) continue;
            if (i == numChildren - 1 || Expr.IS_LITERAL.apply((Object)childExpr)) {
                result = childExpr;
                break;
            }
            if (i == 0) {
                result = expr;
                break;
            }
            ArrayList newChildren = Lists.newArrayList(expr.getChildren().subList(i, numChildren));
            result = new FunctionCallExpr(expr.getFnName(), (List<Expr>)newChildren);
            break;
        }
        return result;
    }

    private Expr simplifyFunctionCallExpr(FunctionCallExpr expr) {
        String fnName = expr.getFnName().getFunction();
        if (fnName.equals("if")) {
            return this.simplifyIfFunctionCallExpr(expr);
        }
        if (fnName.equals("coalesce")) {
            return this.simplifyCoalesceFunctionCallExpr(expr);
        }
        if (IFNULL_ALIASES.contains(fnName)) {
            return this.simplifyIfNullFunctionCallExpr(expr);
        }
        return expr;
    }

    private Expr simplifyCompoundPredicate(CompoundPredicate expr) {
        Expr leftChild = (Expr)expr.getChild(0);
        if (!(leftChild instanceof BoolLiteral)) {
            return expr;
        }
        if (expr.getOp() == CompoundPredicate.Operator.AND) {
            if (Expr.IS_TRUE_LITERAL.apply((Object)leftChild)) {
                return (Expr)expr.getChild(1);
            }
            return leftChild;
        }
        if (expr.getOp() == CompoundPredicate.Operator.OR) {
            if (Expr.IS_TRUE_LITERAL.apply((Object)leftChild)) {
                return leftChild;
            }
            return (Expr)expr.getChild(1);
        }
        return expr;
    }

    private Expr simplifyCaseExpr(CaseExpr expr, Analyzer analyzer) throws AnalysisException {
        Expr caseExpr;
        Expr expr2 = caseExpr = expr.hasCaseExpr() ? (Expr)expr.getChild(0) : null;
        if (expr.hasCaseExpr() && (!Expr.IS_LITERAL.apply((Object)caseExpr) || Expr.IS_NULL_LITERAL.apply((Object)caseExpr))) {
            return expr;
        }
        int numChildren = expr.getChildren().size();
        int loopStart = expr.hasCaseExpr() ? 1 : 0;
        boolean canSimplify = false;
        for (int i = loopStart; i < numChildren - 1; i += 2) {
            if (!Expr.IS_LITERAL.apply(expr.getChild(i))) continue;
            canSimplify = true;
            break;
        }
        if (!canSimplify) {
            return expr;
        }
        ArrayList<CaseWhenClause> newWhenClauses = new ArrayList<CaseWhenClause>();
        Expr elseExpr = null;
        for (int i = loopStart; i < numChildren - 1; i += 2) {
            Expr whenExpr;
            Expr child = (Expr)expr.getChild(i);
            if (Expr.IS_NULL_LITERAL.apply((Object)child)) continue;
            if (expr.hasCaseExpr()) {
                if (Expr.IS_LITERAL.apply((Object)child)) {
                    BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.EQ, caseExpr, (Expr)expr.getChild(i));
                    pred.analyze(analyzer);
                    whenExpr = analyzer.getConstantFolder().rewrite(pred, analyzer);
                } else {
                    whenExpr = null;
                }
            } else {
                whenExpr = child;
            }
            if (whenExpr instanceof BoolLiteral) {
                if (!((BoolLiteral)whenExpr).getValue()) continue;
                if (newWhenClauses.size() == 0) {
                    return (Expr)expr.getChild(i + 1);
                }
                elseExpr = (Expr)expr.getChild(i + 1);
                break;
            }
            newWhenClauses.add(new CaseWhenClause(child, (Expr)expr.getChild(i + 1)));
        }
        if (expr.hasElseExpr() && elseExpr == null) {
            elseExpr = (Expr)expr.getChild(numChildren - 1);
        }
        if (newWhenClauses.size() == 0) {
            if (elseExpr == null) {
                return NullLiteral.create(expr.getType());
            }
            return elseExpr;
        }
        return new CaseExpr(caseExpr, newWhenClauses, elseExpr);
    }
}

