/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class RemoveRedundantStringCast
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new RemoveRedundantStringCast();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        boolean isPotentiallyRedundantCast;
        if (!(expr instanceof BinaryPredicate)) {
            return expr;
        }
        BinaryPredicate.Operator op = ((BinaryPredicate)expr).getOp();
        boolean bl = isPotentiallyRedundantCast = (op == BinaryPredicate.Operator.EQ || op == BinaryPredicate.Operator.NE) && ((Expr)expr.getChild(0)).ignoreImplicitCast() instanceof CastExpr && ((Expr)expr.getChild(0)).ignoreImplicitCast().getType().isStringType() && ((Expr)expr.getChild(1)).getType().isStringType() && Expr.IS_LITERAL.apply(expr.getChild(1));
        if (!isPotentiallyRedundantCast) {
            return expr;
        }
        Expr castExpr = ((Expr)expr.getChild(0)).ignoreImplicitCast();
        Expr castExprChild = ((Expr)castExpr.getChild(0)).ignoreImplicitCast();
        LiteralExpr literalExpr = (LiteralExpr)expr.getChild(1);
        CastExpr castForRedundancyCheck = new CastExpr(new TypeDef(castExpr.getType()), (Expr)new CastExpr(new TypeDef(castExprChild.getType()), (Expr)literalExpr));
        castForRedundancyCheck.analyze(analyzer);
        LiteralExpr resultOfReverseCast = LiteralExpr.createBounded(castForRedundancyCheck, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
        if (resultOfReverseCast != null && !Expr.IS_NULL_VALUE.apply((Object)resultOfReverseCast) && resultOfReverseCast.getStringValue().trim().equals(literalExpr.getStringValue().trim())) {
            return new BinaryPredicate(op, castExprChild, ((Expr)castForRedundancyCheck.getChild(0)).ignoreImplicitCast());
        }
        return expr;
    }
}

