/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.rewrite.ExprRewriteRule;

public class NormalizeExprsRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new NormalizeExprsRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!expr.isAnalyzed()) {
            return expr;
        }
        if (expr instanceof CompoundPredicate) {
            return this.normalizeCompoundPredicate((CompoundPredicate)expr);
        }
        return expr;
    }

    private Expr normalizeCompoundPredicate(CompoundPredicate expr) {
        if (expr.getOp() == CompoundPredicate.Operator.NOT) {
            return expr;
        }
        if (!(expr.getChild(0) instanceof BoolLiteral) && expr.getChild(1) instanceof BoolLiteral) {
            return new CompoundPredicate(expr.getOp(), (Expr)expr.getChild(1), (Expr)expr.getChild(0));
        }
        return expr;
    }
}

