/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.rewrite.ExprRewriteRule;

public class ExtractCommonConjunctRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new ExtractCommonConjunctRule();
    private static final int MAX_EQUALS_COMPARISONS = 900;

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!Expr.IS_OR_PREDICATE.apply((Object)expr)) {
            return expr;
        }
        List<Expr> child0Conjuncts = ((Expr)expr.getChild(0)).getConjuncts();
        List<Expr> child1Conjuncts = ((Expr)expr.getChild(1)).getConjuncts();
        Preconditions.checkState((!child0Conjuncts.isEmpty() && !child1Conjuncts.isEmpty() ? 1 : 0) != 0);
        if (child0Conjuncts.size() * child1Conjuncts.size() > 900) {
            return expr;
        }
        ArrayList commonConjuncts = Lists.newArrayList();
        for (Expr conjunct : child0Conjuncts) {
            if (!child1Conjuncts.contains(conjunct)) continue;
            conjunct.setPrintSqlInParens(false);
            commonConjuncts.add(conjunct);
        }
        if (commonConjuncts.isEmpty()) {
            return expr;
        }
        child0Conjuncts.removeAll(commonConjuncts);
        child1Conjuncts.removeAll(commonConjuncts);
        if (child0Conjuncts.isEmpty() || child1Conjuncts.isEmpty()) {
            Preconditions.checkState((!commonConjuncts.isEmpty() ? 1 : 0) != 0);
            return CompoundPredicate.createConjunctivePredicate(commonConjuncts);
        }
        Expr child0Disjunct = CompoundPredicate.createConjunctivePredicate(child0Conjuncts);
        child0Disjunct.setPrintSqlInParens(((Expr)expr.getChild(0)).getPrintSqlInParens());
        Expr child1Disjunct = CompoundPredicate.createConjunctivePredicate(child1Conjuncts);
        child1Disjunct.setPrintSqlInParens(((Expr)expr.getChild(1)).getPrintSqlInParens());
        ArrayList newDisjuncts = Lists.newArrayList((Object[])new Expr[]{child0Disjunct, child1Disjunct});
        Expr newDisjunction = CompoundPredicate.createDisjunctivePredicate(newDisjuncts);
        newDisjunction.setPrintSqlInParens(true);
        return CompoundPredicate.createConjunction(newDisjunction, CompoundPredicate.createConjunctivePredicate(commonConjuncts));
    }

    private ExtractCommonConjunctRule() {
    }
}

