/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExprRewriter.class);
    private int numChanges_ = 0;
    private final List<ExprRewriteRule> rules_;

    public ExprRewriter(List<ExprRewriteRule> rules) {
        this.rules_ = rules;
    }

    public ExprRewriter(ExprRewriteRule rule) {
        this.rules_ = Lists.newArrayList((Object[])new ExprRewriteRule[]{rule});
    }

    public Expr rewrite(Expr expr, Analyzer analyzer) throws AnalysisException {
        int oldNumChanges;
        Expr rewrittenExpr = expr;
        do {
            oldNumChanges = this.numChanges_;
            for (ExprRewriteRule rule : this.rules_) {
                rewrittenExpr = this.applyRuleRepeatedly(rewrittenExpr, rule, analyzer);
            }
        } while (oldNumChanges != this.numChanges_);
        return rewrittenExpr;
    }

    private Expr applyRuleRepeatedly(Expr expr, ExprRewriteRule rule, Analyzer analyzer) throws AnalysisException {
        int oldNumChanges;
        Expr rewrittenExpr = expr;
        do {
            oldNumChanges = this.numChanges_;
            rewrittenExpr = this.applyRuleBottomUp(rewrittenExpr, rule, analyzer);
        } while (oldNumChanges != this.numChanges_);
        return rewrittenExpr;
    }

    private Expr applyRuleBottomUp(Expr expr, ExprRewriteRule rule, Analyzer analyzer) throws AnalysisException {
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            expr.setChild(i, this.applyRuleBottomUp((Expr)expr.getChild(i), rule, analyzer));
        }
        Expr rewrittenExpr = rule.apply(expr, analyzer);
        if (rewrittenExpr != expr) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} transformed {} to {}", new Object[]{rule.getClass().getSimpleName(), expr.debugString(), rewrittenExpr.debugString()});
            }
            rewrittenExpr.analyze(analyzer);
            ++this.numChanges_;
        }
        return rewrittenExpr;
    }

    public void rewriteList(List<Expr> exprs, Analyzer analyzer) throws AnalysisException {
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, this.rewrite(exprs.get(i), analyzer));
        }
    }

    public void addNumChanges(ExprRewriter otherRewriter) {
        this.numChanges_ += otherRewriter.numChanges_;
    }

    public void reset() {
        this.numChanges_ = 0;
    }

    public boolean changed() {
        return this.numChanges_ > 0;
    }

    public int getNumChanges() {
        return this.numChanges_;
    }
}

