/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.rewrite.ExprRewriteRule;

public class EqualityDisjunctsToInRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new EqualityDisjunctsToInRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) {
        if (!Expr.IS_OR_PREDICATE.apply((Object)expr)) {
            return expr;
        }
        Expr inAndOtherExpr = this.rewriteInAndOtherExpr((Expr)expr.getChild(0), (Expr)expr.getChild(1));
        if (inAndOtherExpr != null) {
            return inAndOtherExpr;
        }
        Expr orChildExpr = this.rewriteEqEqPredicate((Expr)expr.getChild(0), (Expr)expr.getChild(1));
        if (orChildExpr != null) {
            return orChildExpr;
        }
        return expr;
    }

    private Expr rewriteInAndOtherExpr(Expr child0, Expr child1) {
        InPredicate inPred = null;
        Expr otherPred = null;
        if (child0 instanceof InPredicate) {
            inPred = (InPredicate)child0;
            otherPred = child1;
        } else if (child1 instanceof InPredicate) {
            inPred = (InPredicate)child1;
            otherPred = child0;
        }
        if (inPred == null || inPred.isNotIn() || inPred.contains(Subquery.class) || !((Expr)inPred.getChild(0)).equals(otherPred.getChild(0))) {
            return null;
        }
        ArrayList newInList = Lists.newArrayList(inPred.getChildren().subList(1, inPred.getChildren().size()));
        if (Expr.IS_EXPR_EQ_LITERAL_PREDICATE.apply((Object)otherPred)) {
            if (newInList.size() + 1 == 10000) {
                return null;
            }
            newInList.add(otherPred.getChild(1));
        } else if (otherPred instanceof InPredicate && !((InPredicate)otherPred).isNotIn() && !otherPred.contains(Subquery.class)) {
            if (newInList.size() + otherPred.getChildren().size() > 10000) {
                return null;
            }
            newInList.addAll(otherPred.getChildren().subList(1, otherPred.getChildren().size()));
        } else {
            return null;
        }
        return new InPredicate((Expr)inPred.getChild(0), newInList, false);
    }

    private Expr rewriteEqEqPredicate(Expr child0, Expr child1) {
        if (!Expr.IS_EXPR_EQ_LITERAL_PREDICATE.apply((Object)child0)) {
            return null;
        }
        if (!Expr.IS_EXPR_EQ_LITERAL_PREDICATE.apply((Object)child1)) {
            return null;
        }
        if (!((Expr)child0.getChild(0)).equals(child1.getChild(0))) {
            return null;
        }
        InPredicate newExpr = new InPredicate((Expr)child0.getChild(0), Lists.newArrayList((Object[])new Expr[]{(Expr)child0.getChild(1), (Expr)child1.getChild(1)}), false);
        return newExpr;
    }
}

