/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import java.math.BigDecimal;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class DefaultNdvScaleRule
implements ExprRewriteRule {
    public static DefaultNdvScaleRule INSTANCE = new DefaultNdvScaleRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (!(expr instanceof FunctionCallExpr) || !expr.isAnalyzed()) {
            return expr;
        }
        int scale = analyzer.getQueryOptions().getDefault_ndv_scale();
        if (scale > 10 || scale < 1 || scale == 2) {
            return expr;
        }
        FunctionCallExpr oldFunctionCallExpr = (FunctionCallExpr)expr;
        if (!oldFunctionCallExpr.getFnName().getFunction().equals("ndv") || oldFunctionCallExpr.getParams().exprs().size() > 1) {
            return expr;
        }
        List<Expr> params = oldFunctionCallExpr.getParams().exprs();
        params.add(new NumericLiteral(BigDecimal.valueOf(scale), (Type)Type.INT));
        return new FunctionCallExpr("ndv", params);
    }
}

