/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;

public class CountDistinctToNdvRule
implements ExprRewriteRule {
    public static CountDistinctToNdvRule INSTANCE = new CountDistinctToNdvRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (!analyzer.getQueryCtx().client_request.query_options.appx_count_distinct) {
            return expr;
        }
        if (!(expr instanceof FunctionCallExpr) || !expr.isAnalyzed()) {
            return expr;
        }
        FunctionCallExpr oldFunctionCallExpr = (FunctionCallExpr)expr;
        if (!oldFunctionCallExpr.getFnName().getFunction().equals("count") || !oldFunctionCallExpr.isDistinct() || oldFunctionCallExpr.getParams().exprs().size() != 1) {
            return expr;
        }
        return new FunctionCallExpr("ndv", oldFunctionCallExpr.getParams().exprs());
    }
}

