/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToCNFRule
implements ExprRewriteRule {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToCNFRule.class);
    private final int maxCnfExprs_;
    private int numCnfExprs_ = 0;
    private final boolean forMultiTablesOnly_;

    @Override
    public Expr apply(Expr expr, Analyzer analyzer) throws AnalysisException {
        return this.convertToCNF(expr, analyzer);
    }

    private Expr convertToCNF(Expr pred, Analyzer analyzer) throws AnalysisException {
        if (!(pred instanceof CompoundPredicate)) {
            return pred;
        }
        if (!((CompoundPredicate)pred).shouldConvertToCNF()) {
            LOG.debug("It is not feasible to rewrite predicate " + pred.toSql() + " to CNF.");
            return pred;
        }
        if (this.maxCnfExprs_ > 0 && this.numCnfExprs_ >= this.maxCnfExprs_) {
            return pred;
        }
        CompoundPredicate cpred = (CompoundPredicate)pred;
        if (cpred.getOp() == CompoundPredicate.Operator.AND) {
            return cpred;
        }
        if (cpred.getOp() == CompoundPredicate.Operator.OR || cpred.getOp() == CompoundPredicate.Operator.NOT) {
            Expr child;
            if (this.forMultiTablesOnly_) {
                Expr basePred;
                TableRef tbl;
                ArrayList<TupleId> tids = new ArrayList<TupleId>();
                if (!cpred.isAnalyzed()) {
                    cpred = (CompoundPredicate)cpred.clone();
                    cpred.analyzeNoThrow(analyzer);
                }
                cpred.getIds(tids, null);
                if (tids.size() == 1 && (tbl = analyzer.getTableRef((TupleId)tids.get(0))) instanceof InlineViewRef && !(basePred = cpred.trySubstitute(((InlineViewRef)tbl).getBaseTblSmap(), analyzer, false)).equals(cpred)) {
                    tids.clear();
                    basePred.getIds(tids, null);
                }
                if (tids.size() <= 1) {
                    return pred;
                }
            }
            if (cpred.getOp() == CompoundPredicate.Operator.OR) {
                Expr lhs = (Expr)cpred.getChild(0);
                Expr rhs = (Expr)cpred.getChild(1);
                if (lhs instanceof CompoundPredicate && ((CompoundPredicate)lhs).getOp() == CompoundPredicate.Operator.AND) {
                    return this.createPredAndIncrementCount((Expr)lhs.getChild(0), rhs, (Expr)lhs.getChild(1), rhs, analyzer);
                }
                if (rhs instanceof CompoundPredicate && ((CompoundPredicate)rhs).getOp() == CompoundPredicate.Operator.AND) {
                    return this.createPredAndIncrementCount(lhs, (Expr)rhs.getChild(0), lhs, (Expr)rhs.getChild(1), analyzer);
                }
            } else if (cpred.getOp() == CompoundPredicate.Operator.NOT && (child = (Expr)cpred.getChild(0)) instanceof CompoundPredicate && ((CompoundPredicate)child).getOp() == CompoundPredicate.Operator.OR) {
                Expr lhs = (Expr)((CompoundPredicate)child).getChild(0);
                Expr rhs = (Expr)((CompoundPredicate)child).getChild(1);
                CompoundPredicate lhs1 = new CompoundPredicate(CompoundPredicate.Operator.NOT, lhs, null);
                CompoundPredicate rhs1 = new CompoundPredicate(CompoundPredicate.Operator.NOT, rhs, null);
                CompoundPredicate newPredicate = (CompoundPredicate)CompoundPredicate.createConjunction(lhs1, rhs1);
                newPredicate.analyze(analyzer);
                ++this.numCnfExprs_;
                return newPredicate;
            }
        }
        return pred;
    }

    private Predicate createPredAndIncrementCount(Expr first_lhs, Expr second_lhs, Expr first_rhs, Expr second_rhs, Analyzer analyzer) throws AnalysisException {
        List<Expr> disjuncts = Arrays.asList(first_lhs, second_lhs);
        CompoundPredicate lhs1 = (CompoundPredicate)CompoundPredicate.createDisjunctivePredicate(disjuncts);
        disjuncts = Arrays.asList(first_rhs, second_rhs);
        CompoundPredicate rhs1 = (CompoundPredicate)CompoundPredicate.createDisjunctivePredicate(disjuncts);
        CompoundPredicate newPredicate = (CompoundPredicate)CompoundPredicate.createConjunction(lhs1, rhs1);
        newPredicate.analyze(analyzer);
        ++this.numCnfExprs_;
        return newPredicate;
    }

    public ConvertToCNFRule(int maxCnfExprs, boolean forMultiTablesOnly) {
        this.maxCnfExprs_ = maxCnfExprs;
        this.forMultiTablesOnly_ = forMultiTablesOnly;
    }
}

