/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.PipelineMembership;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExecNodePhase;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TUnionNode;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(UnionNode.class);
    private static final double COST_COEFFICIENT_BYTES_MATERIALIZED = 0.00317;
    private static final double COST_COEFFICIENT_ROWS_MATERIALIZED = 0.0257;
    protected List<Expr> unionResultExprs_;
    protected List<List<Expr>> resultExprLists_ = new ArrayList<List<Expr>>();
    protected List<List<Expr>> constExprLists_ = new ArrayList<List<Expr>>();
    protected List<List<Expr>> materializedResultExprLists_ = new ArrayList<List<Expr>>();
    protected List<List<Expr>> materializedConstExprLists_ = new ArrayList<List<Expr>>();
    protected boolean isInSubplan_;
    protected int firstMaterializedChildIdx_;
    protected final TupleId tupleId_;

    protected UnionNode(PlanNodeId id, TupleId tupleId) {
        super(id, tupleId.asList(), "UNION");
        this.unionResultExprs_ = new ArrayList<Expr>();
        this.tupleId_ = tupleId;
        this.isInSubplan_ = false;
    }

    protected UnionNode(PlanNodeId id, TupleId tupleId, List<Expr> unionResultExprs, boolean isInSubplan) {
        super(id, tupleId.asList(), "UNION");
        this.unionResultExprs_ = unionResultExprs;
        this.tupleId_ = tupleId;
        this.isInSubplan_ = isInSubplan;
    }

    public void addConstExprList(List<Expr> exprs) {
        this.constExprLists_.add(exprs);
    }

    public boolean isConstantUnion() {
        return this.resultExprLists_.isEmpty();
    }

    public int getFirstNonPassthroughChildIndex() {
        return this.firstMaterializedChildIdx_;
    }

    public void addChild(PlanNode node, List<Expr> resultExprs) {
        super.addChild(node);
        this.resultExprLists_.add(resultExprs);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        analyzer.registerTupleProducingNode(this.tupleId_, this);
        long totalChildCardinality = 0L;
        boolean haveChildWithCardinality = false;
        this.hasHardEstimates_ = true;
        for (PlanNode child : this.children_) {
            if (child.cardinality_ >= 0L) {
                totalChildCardinality = MathUtil.addCardinalities(totalChildCardinality, child.cardinality_);
                haveChildWithCardinality = true;
            }
            this.numNodes_ = Math.max(child.getNumNodes(), this.numNodes_);
            this.numInstances_ = Math.max(child.getNumInstances(), this.numInstances_);
            this.hasHardEstimates_ &= child.hasHardEstimates_;
        }
        this.cardinality_ = haveChildWithCardinality || this.children_.size() == 0 ? MathUtil.addCardinalities(totalChildCardinality, this.constExprLists_.size()) : -1L;
        if (this.numNodes_ == -1) {
            this.numNodes_ = 1;
            this.numInstances_ = 1;
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (LOG.isTraceEnabled()) {
            LOG.trace("stats Union: cardinality=" + Long.toString(this.cardinality_));
        }
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        long totalMaterializedCardinality = 0L;
        for (int i = this.firstMaterializedChildIdx_; i < this.resultExprLists_.size(); ++i) {
            PlanNode child = (PlanNode)this.children_.get(i);
            if (child.cardinality_ < 0L) continue;
            totalMaterializedCardinality = MathUtil.addCardinalities(totalMaterializedCardinality, Math.max(0L, child.cardinality_));
        }
        long estBytesMaterialized = (long)Math.ceil((double)this.getAvgRowSize() * (double)totalMaterializedCardinality);
        double totalCost = (double)estBytesMaterialized * 0.00317 + (double)totalMaterializedCardinality * 0.0257;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Union CPU cost estimate: " + totalCost + ", estBytesMaterialized: " + estBytesMaterialized + ", totalMaterializedCardinality: " + totalMaterializedCardinality + ", expr list size: " + this.resultExprLists_.size());
        }
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), totalCost);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    public PlanNode.ExecPhaseResourceProfiles computeTreeResourceProfiles(TQueryOptions queryOptions) {
        ResourceProfile maxProfile = ResourceProfile.invalid();
        for (PlanNode child : this.children_) {
            PlanNode.ExecPhaseResourceProfiles childResources = child.computeTreeResourceProfiles(queryOptions);
            maxProfile = maxProfile.max(childResources.duringOpenProfile);
            maxProfile = maxProfile.max(childResources.postOpenProfile);
        }
        ResourceProfile peakResources = this.nodeResourceProfile_.sum(maxProfile);
        return new PlanNode.ExecPhaseResourceProfiles(peakResources, peakResources);
    }

    private boolean isChildPassthrough(Analyzer analyzer, PlanNode childNode, List<Expr> childExprList) {
        List<TupleId> childTupleIds = childNode.getTupleIds();
        Preconditions.checkState((childTupleIds.size() != 1 || !childNode.getNullableTupleIds().contains(childTupleIds.get(0)) ? 1 : 0) != 0);
        if (this.isInSubplan_) {
            return false;
        }
        if (childTupleIds.size() != 1) {
            return false;
        }
        Preconditions.checkState((!this.unionResultExprs_.isEmpty() ? 1 : 0) != 0);
        TupleDescriptor unionTupleDescriptor = analyzer.getDescTbl().getTupleDesc(this.tupleId_);
        TupleDescriptor childTupleDescriptor = analyzer.getDescTbl().getTupleDesc(childTupleIds.get(0));
        Preconditions.checkState((unionTupleDescriptor.getSlots().size() == this.unionResultExprs_.size() ? 1 : 0) != 0);
        Preconditions.checkState((unionTupleDescriptor.getSlots().size() == childExprList.size() ? 1 : 0) != 0);
        if (this.unionResultExprs_.size() != childTupleDescriptor.getSlots().size()) {
            return false;
        }
        if (unionTupleDescriptor.getByteSize() != childTupleDescriptor.getByteSize()) {
            return false;
        }
        for (int i = 0; i < this.unionResultExprs_.size(); ++i) {
            if (!unionTupleDescriptor.getSlots().get(i).isMaterialized()) continue;
            SlotRef unionSlotRef = this.unionResultExprs_.get(i).unwrapSlotRef(false);
            SlotRef childSlotRef = childExprList.get(i).unwrapSlotRef(false);
            Preconditions.checkNotNull((Object)unionSlotRef);
            if (childSlotRef == null) {
                return false;
            }
            if (childSlotRef.getDesc().LayoutEquals(unionSlotRef.getDesc())) continue;
            return false;
        }
        return true;
    }

    void computePassthrough(Analyzer analyzer) {
        int i;
        ArrayList<List<Expr>> newResultExprLists = new ArrayList<List<Expr>>();
        ArrayList newChildren = new ArrayList();
        for (i = 0; i < this.children_.size(); ++i) {
            if (!this.isChildPassthrough(analyzer, (PlanNode)this.children_.get(i), this.resultExprLists_.get(i))) continue;
            newResultExprLists.add(this.resultExprLists_.get(i));
            newChildren.add(this.children_.get(i));
        }
        this.firstMaterializedChildIdx_ = newChildren.size();
        for (i = 0; i < this.children_.size(); ++i) {
            if (this.isChildPassthrough(analyzer, (PlanNode)this.children_.get(i), this.resultExprLists_.get(i))) continue;
            for (Expr expr : this.resultExprLists_.get(i)) {
                Preconditions.checkState((boolean)SortInfo.isValidInSortingTuple(expr.getType()), (Object)"only pass-through UNION ALL is supported for structs containing collections.");
            }
            newResultExprLists.add(this.resultExprLists_.get(i));
            newChildren.add(this.children_.get(i));
        }
        Preconditions.checkState((this.resultExprLists_.size() == newResultExprLists.size() ? 1 : 0) != 0);
        this.resultExprLists_ = newResultExprLists;
        Preconditions.checkState((this.children_.size() == newChildren.size() ? 1 : 0) != 0);
        this.children_ = newChildren;
    }

    @Override
    public void init(Analyzer analyzer) {
        ArrayList<Expr> newExprList;
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        this.computeMemLayout(analyzer);
        this.computeStats(analyzer);
        this.computePassthrough(analyzer);
        this.materializedResultExprLists_.clear();
        Preconditions.checkState((this.resultExprLists_.size() == this.children_.size() ? 1 : 0) != 0);
        List<SlotDescriptor> slots = analyzer.getDescTbl().getTupleDesc(this.tupleId_).getSlots();
        for (int i = 0; i < this.resultExprLists_.size(); ++i) {
            List<Expr> exprList = this.resultExprLists_.get(i);
            newExprList = new ArrayList<Expr>();
            Preconditions.checkState((exprList.size() == slots.size() ? 1 : 0) != 0);
            for (int j = 0; j < exprList.size(); ++j) {
                if (!slots.get(j).isMaterialized()) continue;
                newExprList.add(exprList.get(j));
            }
            this.materializedResultExprLists_.add(Expr.substituteList(newExprList, ((PlanNode)this.getChild(i)).getOutputSmap(), analyzer, true));
        }
        Preconditions.checkState((this.materializedResultExprLists_.size() == this.getChildren().size() ? 1 : 0) != 0);
        this.materializedConstExprLists_.clear();
        for (List<Expr> exprList : this.constExprLists_) {
            Preconditions.checkState((exprList.size() == slots.size() ? 1 : 0) != 0);
            newExprList = new ArrayList();
            for (int i = 0; i < exprList.size(); ++i) {
                if (!slots.get(i).isMaterialized()) continue;
                Expr constExpr = exprList.get(i);
                if (!this.isInSubplan_) {
                    constExpr.disableCodegen();
                }
                newExprList.add(constExpr);
            }
            this.materializedConstExprLists_.add(newExprList);
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature.");
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        Preconditions.checkState((this.materializedResultExprLists_.size() == this.children_.size() ? 1 : 0) != 0);
        ArrayList<List<TExpr>> texprLists = new ArrayList<List<TExpr>>();
        for (List<Expr> exprList : this.materializedResultExprLists_) {
            texprLists.add(Expr.treesToThrift(exprList, serialCtx));
        }
        ArrayList<List<TExpr>> constTexprLists = new ArrayList<List<TExpr>>();
        for (List<Expr> constTexprList : this.materializedConstExprLists_) {
            constTexprLists.add(Expr.treesToThrift(constTexprList, serialCtx));
        }
        Preconditions.checkState((this.firstMaterializedChildIdx_ <= this.children_.size() ? 1 : 0) != 0);
        msg.union_node = new TUnionNode(this.tupleId_.asInt(), texprLists, constTexprLists, this.firstMaterializedChildIdx_);
        msg.node_type = TPlanNodeType.UNION_NODE;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_));
        if (!this.conjuncts_.isEmpty()) {
            output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        if (!this.constExprLists_.isEmpty()) {
            output.append(detailPrefix + "constant-operands=" + this.constExprLists_.size() + "\n");
        }
        if (detailLevel.ordinal() > TExplainLevel.MINIMAL.ordinal()) {
            ArrayList<String> passThroughNodeIds = new ArrayList<String>();
            for (int i = 0; i < this.firstMaterializedChildIdx_; ++i) {
                passThroughNodeIds.add(((PlanNode)this.children_.get(i)).getId().toString());
            }
            if (!passThroughNodeIds.isEmpty()) {
                String result = detailPrefix + "pass-through-operands: ";
                if (passThroughNodeIds.size() == this.children_.size()) {
                    output.append(result + "all\n");
                } else {
                    output.append(result + Joiner.on((String)",").join(passThroughNodeIds) + "\n");
                }
            }
        }
        return output.toString();
    }

    @Override
    public void computePipelineMembership() {
        this.pipelines_ = new ArrayList();
        for (PlanNode child : this.children_) {
            child.computePipelineMembership();
            for (PipelineMembership childPipeline : child.getPipelines()) {
                if (childPipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
                this.pipelines_.add(new PipelineMembership(childPipeline.getId(), childPipeline.getHeight() + 1, TExecNodePhase.GETNEXT));
            }
        }
    }

    @Override
    public boolean isTupleCachingImplemented() {
        return true;
    }

    @Override
    public boolean omitTupleCache() {
        return true;
    }
}

