/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.TupleCacheAllEligiblePolicy;
import org.apache.impala.planner.TupleCacheCostBasedPolicy;
import org.apache.impala.planner.TupleCacheNode;
import org.apache.impala.planner.TupleCachePlacementPolicy;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTupleCachePlacementPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleCachePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCachePlanner.class);
    private final PlannerContext ctx_;
    private final TQueryOptions queryOptions_;
    private final TupleCachePlacementPolicy placementPolicy_;

    public TupleCachePlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
        this.queryOptions_ = this.ctx_.getRootAnalyzer().getQueryCtx().client_request.getQuery_options();
        TTupleCachePlacementPolicy policy = this.queryOptions_.getTuple_cache_placement_policy();
        LOG.info("Using tuple cache placement policy: " + (Object)((Object)policy));
        switch (policy) {
            case ALL_ELIGIBLE: {
                this.placementPolicy_ = new TupleCacheAllEligiblePolicy();
                break;
            }
            case COST_BASED: {
                this.placementPolicy_ = new TupleCacheCostBasedPolicy(this.queryOptions_);
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)("Unexpected placement policy: " + (Object)((Object)policy)));
                this.placementPolicy_ = null;
            }
        }
    }

    public List<PlanFragment> createPlans(List<PlanFragment> plan) throws ImpalaException {
        PlanNode root = plan.get(0).getPlanRoot();
        root.computeTupleCacheInfo(this.ctx_.getRootAnalyzer().getDescTbl(), this.ctx_.getRootAnalyzer().getQueryCtx().query_options_result_hash);
        HashSet<PlanNode> eligibleLocations = new HashSet<PlanNode>();
        root.collectAll(node -> node.getTupleCacheInfo().isEligible() && !node.omitTupleCache(), eligibleLocations);
        if (eligibleLocations.size() == 0) {
            return plan;
        }
        Set<PlanNode> finalLocations = this.placementPolicy_.getFinalCachingLocations(eligibleLocations);
        PlanNode newRoot = this.buildCachingPlan(root, finalLocations);
        Preconditions.checkState((plan.get(0).getPlanRoot() == newRoot ? 1 : 0) != 0);
        return plan;
    }

    private PlanNode buildCachingPlan(PlanNode node, Set<PlanNode> locations) throws ImpalaException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            node.setChild(i, this.buildCachingPlan((PlanNode)node.getChild(i), locations));
        }
        if (!locations.contains(node)) {
            return node;
        }
        Preconditions.checkState((node.getTupleCacheInfo().isEligible() && !node.omitTupleCache() ? 1 : 0) != 0, (Object)"Final location must be eligible");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding TupleCacheNode above node " + node.getId().toString());
        }
        TupleCacheNode tupleCacheNode = new TupleCacheNode(this.ctx_.getNextNodeId(), node, this.queryOptions_.isEnable_tuple_cache_verification());
        tupleCacheNode.init(this.ctx_.getRootAnalyzer());
        PlanFragment curFragment = node.getFragment();
        if (node == curFragment.getPlanRoot()) {
            curFragment.addPlanRoot(tupleCacheNode);
            return tupleCacheNode;
        }
        tupleCacheNode.setFragment(curFragment);
        return tupleCacheNode;
    }
}

