/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTupleCacheNode;

public class TupleCacheNode
extends PlanNode {
    protected String compileTimeKey_;
    protected boolean displayCorrectnessCheckingInfo_;
    protected boolean skipCorrectnessVerification_;
    protected final List<Integer> inputScanNodeIds_ = new ArrayList<Integer>();
    protected final TupleCacheInfo childTupleCacheInfo_;

    public TupleCacheNode(PlanNodeId id, PlanNode child, boolean displayCorrectnessCheckingInfo) {
        super(id, "TUPLE CACHE");
        this.addChild(child);
        this.cardinality_ = child.getCardinality();
        if (child.getFilteredCardinality() != this.cardinality_) {
            this.setFilteredCardinality(child.getFilteredCardinality());
        }
        this.limit_ = child.limit_;
        this.childTupleCacheInfo_ = child.getTupleCacheInfo();
        Preconditions.checkState((boolean)this.childTupleCacheInfo_.isEligible());
        this.compileTimeKey_ = this.childTupleCacheInfo_.getHashString();
        this.skipCorrectnessVerification_ = this.childTupleCacheInfo_.getStreamingAggVariability();
        this.displayCorrectnessCheckingInfo_ = displayCorrectnessCheckingInfo;
        for (HdfsScanNode scanNode : this.childTupleCacheInfo_.getInputScanNodes()) {
            scanNode.setDeterministicScanRangeAssignment(true);
            scanNode.setScheduleScanRangesOldestToNewest(true);
            this.inputScanNodeIds_.add(scanNode.getId().asInt());
        }
        this.computeTupleIds();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.TUPLE_CACHE_NODE;
        Preconditions.checkState((!this.hasLimit() ? 1 : 0) != 0, (Object)"TupleCacheNode does not enforce limits itself and cannot have a limit set.");
        TTupleCacheNode tupleCacheNode = new TTupleCacheNode();
        tupleCacheNode.setCompile_time_key(this.compileTimeKey_);
        tupleCacheNode.setInput_scan_node_ids(this.inputScanNodeIds_);
        tupleCacheNode.setSkip_correctness_verification(this.skipCorrectnessVerification_);
        msg.setTuple_cache_node(tupleCacheNode);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)this.fragment_, (Object)"PlanNode must be placed into a fragment before calling this method.");
        long perInstanceMemEstimate = 0L;
        long bufferSize = TupleCacheNode.computeMaxSpillableBufferSize(queryOptions.getDefault_spillable_buffer_size(), queryOptions.getMax_row_size());
        long perInstanceMinMemReservation = 2L * bufferSize;
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(bufferSize).build();
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_));
        output.append(detailPrefix + "cache key: " + this.compileTimeKey_ + "\n");
        if (this.displayCorrectnessCheckingInfo_) {
            output.append(detailPrefix + "skip correctness verification: " + this.skipCorrectnessVerification_ + "\n");
        }
        List input_scan_node_ids_strs = this.inputScanNodeIds_.stream().map(Object::toString).collect(Collectors.toList());
        output.append(detailPrefix + "input scan node ids: " + String.join((CharSequence)",", input_scan_node_ids_strs) + "\n");
        output.append(this.childTupleCacheInfo_.getCostExplainString(detailPrefix));
        return output.toString();
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), this.getCardinality(), 0.0f);
    }
}

