/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TSlotDescriptor;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTupleDescriptor;
import org.apache.impala.util.AcidUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TupleCacheInfo {
    private EnumSet<IneligibilityReason> ineligibilityReasons_;
    private DescriptorTable descriptorTable_;
    private final Map<TupleId, TupleId> tupleTranslationMap_ = new TreeMap<TupleId, TupleId>();
    private final Map<SlotId, SlotId> slotTranslationMap_ = new HashMap<SlotId, SlotId>();
    private final IdGenerator<TupleId> translatedTupleIdGenerator_ = TupleId.createGenerator();
    private final IdGenerator<SlotId> translatedSlotIdGenerator_ = SlotId.createGenerator();
    private final List<HdfsScanNode> inputScanNodes_ = new ArrayList<HdfsScanNode>();
    private boolean streamingAggVariability_ = false;
    private Hasher hasher_ = Hashing.murmur3_128().newHasher();
    private List<HashTraceElement> hashTraces_ = new ArrayList<HashTraceElement>();
    private boolean finalized_ = false;
    private String finalizedHashString_ = null;
    private long cumulativeProcessingCost_ = 0L;
    private long estimatedSerializedSize_ = -1L;
    private long estimatedSerializedSizePerNode_ = -1L;
    private long writeProcessingCost_ = -1L;
    private long readProcessingCost_ = -1L;

    public TupleCacheInfo(DescriptorTable descTbl) {
        this.ineligibilityReasons_ = EnumSet.noneOf(IneligibilityReason.class);
        this.descriptorTable_ = descTbl;
    }

    public void setIneligible(IneligibilityReason reason) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        this.ineligibilityReasons_.add(reason);
    }

    public boolean isEligible() {
        return this.ineligibilityReasons_.isEmpty();
    }

    public void setStreamingAggVariability() {
        Preconditions.checkState((!this.streamingAggVariability_ ? 1 : 0) != 0);
        this.streamingAggVariability_ = true;
    }

    public void clearStreamingAggVariability() {
        this.streamingAggVariability_ = false;
    }

    public boolean getStreamingAggVariability() {
        return this.streamingAggVariability_;
    }

    public String getHashString() {
        this.checkFinalizedAndEligible("a hash");
        return this.finalizedHashString_;
    }

    public List<HashTraceElement> getHashTraces() {
        this.checkFinalizedAndEligible("a hash trace");
        return this.hashTraces_;
    }

    public void finalizeHash() {
        this.finalizedHashString_ = this.hasher_.hash().toString();
        this.hasher_ = null;
        this.hashTraces_ = Collections.unmodifiableList(this.hashTraces_);
        this.finalized_ = true;
    }

    public long getCumulativeProcessingCost() {
        this.checkFinalizedAndEligible("cost information");
        return this.cumulativeProcessingCost_;
    }

    public long getEstimatedSerializedSize() {
        this.checkFinalizedAndEligible("cost information");
        return this.estimatedSerializedSize_;
    }

    public long getEstimatedSerializedSizePerNode() {
        this.checkFinalizedAndEligible("cost information");
        return this.estimatedSerializedSizePerNode_;
    }

    public long getWriteProcessingCost() {
        this.checkFinalizedAndEligible("cost information");
        return this.writeProcessingCost_;
    }

    public long getReadProcessingCost() {
        this.checkFinalizedAndEligible("cost information");
        return this.readProcessingCost_;
    }

    private void checkFinalizedAndEligible(String contextString) {
        Preconditions.checkState((boolean)this.isEligible(), (String)"TupleCacheInfo only has %s if it is cache eligible.", (Object)contextString);
        Preconditions.checkState((boolean)this.finalized_, (Object)"TupleCacheInfo not finalized");
    }

    public void calculateCostInformation(PlanNode thisPlanNode) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        Preconditions.checkState((boolean)this.isEligible(), (Object)"TupleCacheInfo only calculates cost information if it is cache eligible.");
        Preconditions.checkState((thisPlanNode.getTupleCacheInfo() == this ? 1 : 0) != 0, (Object)"calculateCostInformation() must be called with its enclosing PlanNode");
        Preconditions.checkState((thisPlanNode.getNumNodes() > 0 ? 1 : 0) != 0, (Object)"PlanNode fragment must have nodes");
        for (PlanNode child : thisPlanNode.getChildren()) {
            this.cumulativeProcessingCost_ += child.getTupleCacheInfo().getCumulativeProcessingCost();
            if (child.getFragment() == thisPlanNode.getFragment()) continue;
            this.cumulativeProcessingCost_ += child.getFragment().getSink().getProcessingCost().getTotalCost();
        }
        this.cumulativeProcessingCost_ += thisPlanNode.getProcessingCost().getTotalCost();
        if (thisPlanNode.getFilteredCardinality() > -1L) {
            long cardinality = thisPlanNode.getFilteredCardinality();
            this.estimatedSerializedSize_ = Math.round(ExchangeNode.getAvgSerializedRowSize(thisPlanNode) * (double)cardinality);
            this.estimatedSerializedSizePerNode_ = this.estimatedSerializedSize_ / (long)thisPlanNode.getNumNodes();
            double costCoefficientWriteBytes = BackendConfig.INSTANCE.getTupleCacheCostCoefficientWriteBytes();
            double costCoefficientWriteRows = BackendConfig.INSTANCE.getTupleCacheCostCoefficientWriteRows();
            this.writeProcessingCost_ = (long)((double)this.estimatedSerializedSize_ * costCoefficientWriteBytes + (double)cardinality * costCoefficientWriteRows);
            double costCoefficientReadBytes = BackendConfig.INSTANCE.getTupleCacheCostCoefficientReadBytes();
            double costCoefficientReadRows = BackendConfig.INSTANCE.getTupleCacheCostCoefficientReadRows();
            this.readProcessingCost_ = (long)((double)this.estimatedSerializedSize_ * costCoefficientReadBytes + (double)cardinality * costCoefficientReadRows);
        }
    }

    public boolean mergeChild(String comment, TupleCacheInfo child) {
        if (!this.mergeChildImpl(comment, child, false)) {
            return false;
        }
        this.inputScanNodes_.addAll(child.inputScanNodes_);
        return true;
    }

    public boolean mergeChildWithScans(String comment, TupleCacheInfo child) {
        if (!child.isEligible()) {
            return this.mergeChild(comment, child);
        }
        TupleCacheInfo tmpInfo = new TupleCacheInfo(this.descriptorTable_);
        boolean success = tmpInfo.mergeChild(comment, child);
        Preconditions.checkState((boolean)success);
        tmpInfo.incorporateScans();
        tmpInfo.finalizeHash();
        Preconditions.checkState((tmpInfo.inputScanNodes_.size() == 0 ? 1 : 0) != 0);
        return this.mergeChildImpl(comment, tmpInfo, true);
    }

    public void incorporateScans() {
        for (HdfsScanNode scanNode : this.inputScanNodes_) {
            scanNode.incorporateScansIntoTupleCache(this);
        }
        this.inputScanNodes_.clear();
    }

    private boolean mergeChildImpl(String comment, TupleCacheInfo child, boolean mergeChildHashTrace) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        if (!child.isEligible()) {
            this.ineligibilityReasons_.add(IneligibilityReason.CHILDREN_INELIGIBLE);
            return false;
        }
        this.hasher_.putBytes(child.getHashString().getBytes());
        if (mergeChildHashTrace) {
            this.hashTraces_.addAll(child.getHashTraces());
        } else {
            this.hashTraces_.add(new HashTraceElement(comment, child.getHashString()));
        }
        for (TupleId id : child.tupleTranslationMap_.keySet()) {
            this.registerTupleHelper(id, false);
        }
        if (child.streamingAggVariability_) {
            this.streamingAggVariability_ = true;
        }
        return true;
    }

    public void hashThrift(String comment, TBase<?, ?> thriftObj) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            this.hasher_.putBytes(serializer.serialize(thriftObj));
        }
        catch (TException e) {
            Preconditions.checkState((boolean)false, (Object)("Unexpected Thrift exception: " + e.toString()));
        }
        String thriftString = thriftObj.toString();
        Preconditions.checkState((thriftString != null ? 1 : 0) != 0);
        this.hashTraces_.add(new HashTraceElement(comment, thriftString));
    }

    public void hashString(String comment, String s) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        Preconditions.checkState((s != null ? 1 : 0) != 0);
        this.hasher_.putUnencodedChars((CharSequence)s);
        this.hashTraces_.add(new HashTraceElement(comment, s));
    }

    public void registerTuple(TupleId id) {
        this.registerTupleHelper(id, true);
    }

    private void registerTupleHelper(TupleId id, boolean incorporateIntoHash) {
        Preconditions.checkState((!this.finalized_ ? 1 : 0) != 0, (Object)"TupleCacheInfo is finalized and can't be modified");
        ThriftSerializationCtx serialCtx = new ThriftSerializationCtx(this);
        if (!this.tupleTranslationMap_.containsKey(id)) {
            this.tupleTranslationMap_.put(id, this.translatedTupleIdGenerator_.getNextId());
            TupleDescriptor tupleDesc = this.descriptorTable_.getTupleDesc(id);
            if (!tupleDesc.isMaterialized()) {
                return;
            }
            if (incorporateIntoHash) {
                boolean needs_table_id = tupleDesc.getTable() != null && !(tupleDesc.getTable() instanceof FeView);
                TTupleDescriptor thriftTupleDesc = tupleDesc.toThrift(needs_table_id ? new Integer(1) : null, serialCtx);
                this.hashThrift("TupleDescriptor " + id, thriftTupleDesc);
            }
            for (SlotDescriptor slotDesc : tupleDesc.getMaterializedSlots()) {
                this.slotTranslationMap_.put(slotDesc.getId(), this.translatedSlotIdGenerator_.getNextId());
                TupleDescriptor nestedTupleDesc = slotDesc.getItemTupleDesc();
                if (nestedTupleDesc != null) {
                    this.registerTupleHelper(nestedTupleDesc.getId(), incorporateIntoHash);
                }
                if (!incorporateIntoHash) continue;
                TSlotDescriptor thriftSlotDesc = slotDesc.toThrift(serialCtx);
                this.hashThrift("SlotDescriptor " + slotDesc.getId(), thriftSlotDesc);
            }
        }
    }

    private void registerTable(FeTable tbl) {
        Preconditions.checkState((!(tbl instanceof FeView) ? 1 : 0) != 0, (Object)"registerTable() only applies to base tables");
        Preconditions.checkState((tbl != null ? 1 : 0) != 0, (Object)"Invalid null argument to registerTable()");
        if (tbl.getMetaStoreTable() != null && AcidUtils.isFullAcidTable(tbl.getMetaStoreTable().getParameters())) {
            this.setIneligible(IneligibilityReason.FULL_ACID);
            return;
        }
        TTableName tblName = tbl.getTableName().toThrift();
        this.hashThrift("Table", tblName);
    }

    public void registerInputScanNode(HdfsScanNode hdfsScanNode) {
        this.registerTable(hdfsScanNode.getTupleDesc().getTable());
        this.inputScanNodes_.add(hdfsScanNode);
    }

    public List<HdfsScanNode> getInputScanNodes() {
        return this.inputScanNodes_;
    }

    public TupleId getLocalTupleId(TupleId globalId) {
        Preconditions.checkState((boolean)this.tupleTranslationMap_.containsKey(globalId));
        return this.tupleTranslationMap_.get(globalId);
    }

    public SlotId getLocalSlotId(SlotId globalId) {
        Preconditions.checkState((boolean)this.slotTranslationMap_.containsKey(globalId));
        return this.slotTranslationMap_.get(globalId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TupleCacheInfo:");
        if (this.isEligible()) {
            builder.append("cache key: ");
            builder.append(this.getHashString());
            builder.append("\n");
            builder.append("cache key hash trace: ");
            for (HashTraceElement elem : this.getHashTraces()) {
                builder.append(elem.getComment());
                builder.append(": ");
                builder.append(elem.getHashTrace());
                builder.append("\n");
            }
            builder.append("\n");
        } else {
            builder.append("ineligibility reasons: ");
            builder.append(this.getIneligibilityReasonsString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getExplainHashTrace(String detailPrefix) {
        StringBuilder output = new StringBuilder();
        int keyFormatWidth = 100;
        for (HashTraceElement elem : this.getHashTraces()) {
            String hashTrace = elem.getHashTrace();
            if (hashTrace.length() < 100) {
                output.append(String.format("%s  %s: %s\n", detailPrefix, elem.getComment(), hashTrace));
                continue;
            }
            output.append(String.format("%s  %s:\n", detailPrefix, elem.getComment()));
            for (int idx = 0; idx < hashTrace.length(); idx += 100) {
                int stopIdx = Math.min(hashTrace.length(), idx + 100);
                output.append(String.format("%s  [%s]\n", detailPrefix, hashTrace.substring(idx, stopIdx)));
            }
        }
        return output.toString();
    }

    public String getExplainString(String detailPrefix, TExplainLevel detailLevel) {
        if (detailLevel.ordinal() >= TExplainLevel.VERBOSE.ordinal()) {
            StringBuilder output = new StringBuilder();
            if (this.isEligible()) {
                output.append(String.format("%stuple cache key: %s\n", detailPrefix, this.getHashString()));
                output.append(this.getCostExplainString(detailPrefix));
                output.append(this.getExplainHashTrace(detailPrefix));
            } else {
                output.append(String.format("%stuple cache ineligibility reasons: %s\n", detailPrefix, this.getIneligibilityReasonsString()));
            }
            return output.toString();
        }
        return "";
    }

    public String getCostExplainString(String detailPrefix) {
        StringBuilder output = new StringBuilder();
        output.append(detailPrefix + "estimated serialized size: ");
        if (this.estimatedSerializedSize_ > -1L) {
            output.append(PrintUtils.printBytes(this.estimatedSerializedSize_));
        } else {
            output.append("unavailable");
        }
        output.append("\n");
        output.append(detailPrefix + "estimated serialized size per node: ");
        if (this.estimatedSerializedSizePerNode_ > -1L) {
            output.append(PrintUtils.printBytes(this.estimatedSerializedSizePerNode_));
        } else {
            output.append("unavailable");
        }
        output.append("\n");
        output.append(detailPrefix + "cumulative processing cost: ");
        output.append(this.getCumulativeProcessingCost());
        output.append("\n");
        output.append(detailPrefix + "cache read processing cost: ");
        output.append(this.getReadProcessingCost());
        output.append("\n");
        output.append(detailPrefix + "cache write processing cost: ");
        output.append(this.getWriteProcessingCost());
        output.append("\n");
        return output.toString();
    }

    public String getIneligibilityReasonsString() {
        StringJoiner joiner = new StringJoiner(",");
        for (IneligibilityReason reason : this.ineligibilityReasons_) {
            joiner.add(reason.toString());
        }
        return joiner.toString();
    }

    public static class HashTraceElement {
        private String comment_;
        private String hashTrace_;

        public HashTraceElement(String comment, String hashTrace) {
            Preconditions.checkNotNull((Object)comment, (Object)"Hash trace comment must not be null");
            this.comment_ = comment;
            this.hashTrace_ = hashTrace;
        }

        public String getComment() {
            return this.comment_;
        }

        public String getHashTrace() {
            return this.hashTrace_;
        }
    }

    public static enum IneligibilityReason {
        NOT_IMPLEMENTED,
        CHILDREN_INELIGIBLE,
        LIMIT,
        NONDETERMINISTIC_FN,
        MERGING_EXCHANGE,
        PARTITIONED_EXCHANGE,
        FULL_ACID;

    }
}

