/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.TupleCachePlacementPolicy;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleCacheCostBasedPolicy
implements TupleCachePlacementPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCacheCostBasedPolicy.class);
    private final Comparator<PlanNode> rankingComparator_ = new CostReductionPerByteComparator();
    private final TQueryOptions queryOptions_;

    public TupleCacheCostBasedPolicy(TQueryOptions queryOptions) {
        this.queryOptions_ = queryOptions;
    }

    private boolean meetsRequiredCostReductionFactor(PlanNode node) {
        double requiredCostReductionFactor;
        long cacheReadProcessingCost;
        long cumulativeProcessingCost = node.getTupleCacheInfo().getCumulativeProcessingCost();
        double costReductionFactor = (double)cumulativeProcessingCost / (double)(cacheReadProcessingCost = Math.max(node.getTupleCacheInfo().getReadProcessingCost(), 1L));
        if (costReductionFactor < (requiredCostReductionFactor = this.queryOptions_.tuple_cache_required_cost_reduction_factor)) {
            LOG.trace(String.format("%s eliminated (cost reduction factor %f < threshold %f)", node.getDisplayLabel(), costReductionFactor, requiredCostReductionFactor));
            return false;
        }
        return true;
    }

    private boolean meetsCostThresholds(PlanNode node) {
        if (node.getTupleCacheInfo().getEstimatedSerializedSize() < 0L) {
            LOG.trace(node.getDisplayLabel() + " eliminated due to missing statistics");
            return false;
        }
        long budget = this.queryOptions_.tuple_cache_budget_bytes_per_executor;
        long bytesPerExecutor = node.getTupleCacheInfo().getEstimatedSerializedSizePerNode();
        if (bytesPerExecutor > budget) {
            LOG.trace(String.format("%s eliminated (bytes per executor %d > budget %d)", node.getDisplayLabel(), bytesPerExecutor, budget));
            return false;
        }
        return this.meetsRequiredCostReductionFactor(node);
    }

    private Double computeCostReductionPerByte(PlanNode node) {
        long cumulativeProcessingCost = node.getTupleCacheInfo().getCumulativeProcessingCost();
        long cacheReadProcessingCost = node.getTupleCacheInfo().getReadProcessingCost();
        long estimatedSerializedSize = node.getTupleCacheInfo().getEstimatedSerializedSize();
        long costReduction = cumulativeProcessingCost - cacheReadProcessingCost;
        return (double)costReduction / (double)(estimatedSerializedSize + 1L);
    }

    @Override
    public Set<PlanNode> getFinalCachingLocations(Set<PlanNode> eligibleLocations) {
        Preconditions.checkState((eligibleLocations.size() > 0 ? 1 : 0) != 0);
        PriorityQueue<PlanNode> sortedLocations = new PriorityQueue<PlanNode>(eligibleLocations.size(), this.rankingComparator_);
        for (PlanNode node : eligibleLocations) {
            if (!this.meetsCostThresholds(node)) continue;
            sortedLocations.add(node);
        }
        HashSet<PlanNode> finalLocations = new HashSet<PlanNode>();
        long remainingBytesPerExecutorBudget = this.queryOptions_.tuple_cache_budget_bytes_per_executor;
        while (sortedLocations.size() > 0) {
            PlanNode node = sortedLocations.poll();
            long curBytesPerExecutor = node.getTupleCacheInfo().getEstimatedSerializedSizePerNode();
            if (curBytesPerExecutor > remainingBytesPerExecutorBudget) {
                LOG.trace(String.format("Skipped %s (bytes per executor: %d, remaining budget: %d)", node.getDisplayLabel(), curBytesPerExecutor, remainingBytesPerExecutorBudget));
                continue;
            }
            LOG.trace(String.format("Picked %s (bytes per executor: %d, remaining budget: %d)", node.getDisplayLabel(), curBytesPerExecutor, remainingBytesPerExecutorBudget));
            finalLocations.add(node);
            remainingBytesPerExecutorBudget -= curBytesPerExecutor;
        }
        return finalLocations;
    }

    private class CostReductionPerByteComparator
    implements Comparator<PlanNode> {
        private CostReductionPerByteComparator() {
        }

        @Override
        public int compare(PlanNode n1, PlanNode n2) {
            Double n2_cost_density;
            Double n1_cost_density = TupleCacheCostBasedPolicy.this.computeCostReductionPerByte(n1);
            int result = -n1_cost_density.compareTo(n2_cost_density = TupleCacheCostBasedPolicy.this.computeCostReductionPerByte(n2));
            if (result != 0) {
                return result;
            }
            return n1.getId().asInt() - n2.getId().asInt();
        }
    }
}

