/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.ExprUtil;

public class SingularRowSrcNode
extends PlanNode {
    private final SubplanNode containingSubplanNode_;

    protected SingularRowSrcNode(PlanNodeId id, SubplanNode containingSubplanNode) {
        super(id, "SINGULAR ROW SRC");
        this.containingSubplanNode_ = containingSubplanNode;
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tupleIds_.addAll(((PlanNode)this.containingSubplanNode_.getChild(0)).getTupleIds());
        this.tblRefIds_.addAll(((PlanNode)this.containingSubplanNode_.getChild(0)).getTblRefIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.containingSubplanNode_.getChild(0)).getNullableTupleIds());
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        this.outputSmap_ = ((PlanNode)this.containingSubplanNode_.getChild(0)).getOutputSmap();
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = 1L;
        this.numNodes_ = ((PlanNode)this.containingSubplanNode_.getChild(0)).getNumNodes();
        this.numInstances_ = ((PlanNode)this.containingSubplanNode_.getChild(0)).getNumInstances();
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), ((PlanNode)this.containingSubplanNode_.getChild(0)).getCardinality(), ExprUtil.computeExprsTotalCost(this.getConjuncts()));
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s\n", prefix, this.getDisplayLabel()));
        if (detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(String.format("%sparent-subplan=%s\n", detailPrefix, this.containingSubplanNode_.getId()));
        }
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.SINGULAR_ROW_SRC_NODE;
    }
}

