/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprId;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.IcebergMetadataTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.SingularRowSrcTableRef;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.analysis.UnionStmt;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.AnalyticEvalNode;
import org.apache.impala.planner.AnalyticPlanner;
import org.apache.impala.planner.CardinalityCheckNode;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.DataSourceScanNode;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.HBaseScanNode;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.HdfsPartitionPruner;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.IcebergMetadataScanNode;
import org.apache.impala.planner.IcebergScanPlanner;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.KuduScanNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.SelectNode;
import org.apache.impala.planner.SingleNodePlannerIntf;
import org.apache.impala.planner.SingularRowSrcNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.planner.SystemTableScanNode;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.planner.UnnestNode;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.util.AcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleNodePlanner
implements SingleNodePlannerIntf {
    private static final double JOIN_DISTINCT_THRESHOLD = 0.25;
    private static final Logger LOG = LoggerFactory.getLogger(SingleNodePlanner.class);
    private final PlannerContext ctx_;
    private boolean valueTransferGraphNeedsUpdate_ = false;

    public SingleNodePlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
    }

    @Override
    public PlanNode createSingleNodePlan() throws ImpalaException {
        QueryStmt queryStmt = this.ctx_.getQueryStmt();
        Analyzer analyzer = queryStmt.getAnalyzer();
        analyzer.computeValueTransferGraph();
        this.ctx_.getTimeline().markEvent("Value transfer graph computed");
        if (queryStmt.getBaseTblResultExprs() != null) {
            analyzer.materializeSlots(queryStmt.getBaseTblResultExprs());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("desctbl: " + analyzer.getDescTbl().debugString());
        }
        PlanNode singleNodePlan = this.createQueryPlan(queryStmt, analyzer, this.ctx_.getQueryOptions().isDisable_outermost_topn());
        Preconditions.checkNotNull((Object)singleNodePlan);
        if (this.valueTransferGraphNeedsUpdate_) {
            this.ctx_.getTimeline().markEvent("Recomputing value transfer graph");
            analyzer.computeValueTransferGraph();
            this.ctx_.getTimeline().markEvent("Value transfer graph computed");
            this.valueTransferGraphNeedsUpdate_ = false;
        }
        return singleNodePlan;
    }

    public static void validatePlan(PlannerContext planCtx, PlanNode planNode) throws NotImplementedException {
        JoinNode joinNode;
        JoinOperator joinOp;
        if (planCtx.isSingleNodeExec()) {
            return;
        }
        if (planNode instanceof NestedLoopJoinNode && ((joinOp = (joinNode = (JoinNode)planNode).getJoinOp()).isRightSemiJoin() || joinOp.isFullOuterJoin() || joinOp == JoinOperator.RIGHT_OUTER_JOIN) && joinNode.getEqJoinConjuncts().isEmpty()) {
            throw new NotImplementedException(String.format("Error generating a valid execution plan for this query. A %s type with no equi-join predicates can only be executed with a single node plan.", joinOp.toString()));
        }
        if (planNode instanceof SubplanNode) {
            SingleNodePlanner.validatePlan(planCtx, (PlanNode)planNode.getChild(0));
        } else {
            for (PlanNode child : planNode.getChildren()) {
                SingleNodePlanner.validatePlan(planCtx, child);
            }
        }
    }

    private PlanNode createEmptyNode(QueryStmt stmt, Analyzer analyzer) {
        ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
        stmt.getMaterializedTupleIds(tupleIds);
        if (tupleIds.isEmpty()) {
            Preconditions.checkState((boolean)(stmt instanceof SelectStmt), (Object)"Only constant selects should have no materialized tuples");
            SelectStmt selectStmt = (SelectStmt)stmt;
            Preconditions.checkState((boolean)selectStmt.getTableRefs().isEmpty());
            tupleIds.add(this.createResultTupleDescriptor(selectStmt, "empty", analyzer).getId());
        }
        this.unmarkCollectionSlots(stmt);
        EmptySetNode node = new EmptySetNode(this.ctx_.getNextNodeId(), tupleIds);
        node.init(analyzer);
        if (stmt instanceof SelectStmt) {
            node.setOutputSmap(((SelectStmt)stmt).getBaseTblSmap());
        }
        return node;
    }

    private void unmarkCollectionSlots(QueryStmt stmt) {
        ArrayList<TableRef> tblRefs = new ArrayList<TableRef>();
        stmt.collectFromClauseTableRefs(tblRefs);
        for (TableRef ref : tblRefs) {
            if (!ref.isRelative()) continue;
            Preconditions.checkState((boolean)(ref instanceof CollectionTableRef));
            CollectionTableRef collTblRef = (CollectionTableRef)ref;
            Expr collExpr = collTblRef.getCollectionExpr();
            Preconditions.checkState((boolean)(collExpr instanceof SlotRef));
            SlotRef collSlotRef = (SlotRef)collExpr;
            collSlotRef.getDesc().setIsMaterialized(false);
            collSlotRef.getDesc().getParent().recomputeMemLayout();
        }
    }

    private PlanNode createQueryPlan(QueryStmt stmt, Analyzer analyzer, boolean disableTopN) throws ImpalaException {
        PlanNode root;
        if (analyzer.hasEmptyResultSet()) {
            return this.createEmptyNode(stmt, analyzer);
        }
        if (stmt instanceof SelectStmt) {
            SelectStmt selectStmt = (SelectStmt)stmt;
            root = this.createSelectPlan(selectStmt, analyzer);
            if (((SelectStmt)stmt).getAnalyticInfo() != null) {
                List<Expr> groupingExprs;
                AnalyticInfo analyticInfo = selectStmt.getAnalyticInfo();
                AnalyticPlanner analyticPlanner = new AnalyticPlanner(analyticInfo, analyzer, this.ctx_);
                MultiAggregateInfo multiAggInfo = selectStmt.getMultiAggInfo();
                if (multiAggInfo != null) {
                    groupingExprs = multiAggInfo.getSubstGroupingExprs();
                    Preconditions.checkState((groupingExprs != null ? 1 : 0) != 0);
                } else {
                    groupingExprs = Collections.emptyList();
                }
                ArrayList<Expr> inputPartitionExprs = new ArrayList<Expr>();
                root = analyticPlanner.createSingleNodePlan(root, groupingExprs, inputPartitionExprs);
                if (multiAggInfo != null && !inputPartitionExprs.isEmpty() && multiAggInfo.getMaterializedAggClasses().size() == 1) {
                    multiAggInfo.getMaterializedAggClass(0).setPartitionExprs(inputPartitionExprs);
                }
            }
        } else {
            Preconditions.checkState((boolean)(stmt instanceof UnionStmt));
            root = this.createUnionPlan((UnionStmt)stmt, analyzer);
        }
        boolean sortHasMaterializedSlots = false;
        if (stmt.evaluateOrderBy()) {
            for (SlotDescriptor sortSlotDesc : stmt.getSortInfo().getSortTupleDescriptor().getSlots()) {
                if (!sortSlotDesc.isMaterialized()) continue;
                sortHasMaterializedSlots = true;
                break;
            }
        }
        if (stmt.evaluateOrderBy() && sortHasMaterializedSlots) {
            root = SingleNodePlanner.createSortNode(this.ctx_, analyzer, root, stmt.getSortInfo(), stmt.getLimit(), stmt.getOffset(), stmt.hasLimit(), disableTopN);
        } else {
            root.setLimit(stmt.getLimit());
            root.computeStats(analyzer);
            if (root.hasLimit()) {
                SingleNodePlanner.checkAndApplyLimitPushdown(root, null, root.getLimit(), analyzer, this.ctx_);
            }
        }
        return root;
    }

    public static SortNode createSortNode(PlannerContext planCtx, Analyzer analyzer, PlanNode root, SortInfo sortInfo, long limit, long offset, boolean hasLimit, boolean disableTopN) throws ImpalaException {
        SortNode sortNode;
        if (hasLimit && offset == 0L) {
            SingleNodePlanner.checkAndApplyLimitPushdown(root, sortInfo, limit, analyzer, planCtx);
        }
        if (hasLimit && !disableTopN) {
            sortNode = SortNode.createTopNSortNode(planCtx.getQueryOptions(), planCtx.getNextNodeId(), root, sortInfo, offset, limit, false);
        } else {
            sortNode = SortNode.createTotalSortNode(planCtx.getNextNodeId(), root, sortInfo, offset);
            sortNode.setLimit(limit);
        }
        Preconditions.checkState((boolean)sortNode.hasValidStats());
        sortNode.init(analyzer);
        return sortNode;
    }

    private static void checkAndApplyLimitPushdown(PlanNode root, SortInfo sortInfo, long limit, Analyzer analyzer, PlannerContext planCtx) {
        AnalyticEvalNode.LimitPushdownInfo pushdownLimit = null;
        TreeNode analyticNode = null;
        ArrayList<PlanNode> intermediateNodes = new ArrayList<PlanNode>();
        SortNode analyticNodeSort = null;
        PlanNode descendant = SingleNodePlanner.findDescendantAnalyticNode(root, intermediateNodes);
        if (descendant != null && intermediateNodes.size() <= 1) {
            Preconditions.checkArgument((boolean)(descendant instanceof AnalyticEvalNode));
            analyticNode = (AnalyticEvalNode)descendant;
            if (!(analyticNode.getChild(0) instanceof SortNode)) {
                return;
            }
            analyticNodeSort = (SortNode)analyticNode.getChild(0);
            if (analyticNodeSort.hasLimit() || analyticNodeSort.hasOffset()) {
                return;
            }
            int numNodes = intermediateNodes.size();
            if (numNodes > 1 || numNodes == 1 && !(intermediateNodes.get(0) instanceof SelectNode)) {
                pushdownLimit = null;
            } else if (numNodes == 0) {
                pushdownLimit = ((AnalyticEvalNode)analyticNode).checkForLimitPushdown(sortInfo, root.getOutputSmap(), null, limit, analyticNodeSort, planCtx.getRootAnalyzer());
            } else {
                SelectNode selectNode = (SelectNode)intermediateNodes.get(0);
                pushdownLimit = ((AnalyticEvalNode)analyticNode).checkForLimitPushdown(sortInfo, root.getOutputSmap(), selectNode, limit, analyticNodeSort, planCtx.getRootAnalyzer());
            }
        }
        if (pushdownLimit != null) {
            Preconditions.checkArgument((analyticNode != null ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)(analyticNode.getChild(0) instanceof SortNode));
            analyticNodeSort.tryConvertToTopN(limit + (long)pushdownLimit.additionalLimit, analyzer, pushdownLimit.includeTies);
            ((AnalyticEvalNode)analyticNode).computeStats(analyzer);
            for (PlanNode n : intermediateNodes) {
                n.computeStats(analyzer);
            }
        }
    }

    private static PlanNode findDescendantAnalyticNode(PlanNode root, List<PlanNode> intermediateNodes) {
        if (root == null || root instanceof AnalyticEvalNode) {
            return root;
        }
        if (root instanceof SortNode || root instanceof AggregationNode || root instanceof JoinNode || root instanceof SubplanNode || root.getChildren().size() > 1) {
            return null;
        }
        intermediateNodes.add(root);
        return SingleNodePlanner.findDescendantAnalyticNode((PlanNode)root.getChild(0), intermediateNodes);
    }

    private PlanNode addUnassignedConjuncts(Analyzer analyzer, List<TupleId> tupleIds, PlanNode root) {
        if (root instanceof EmptySetNode) {
            return root;
        }
        Preconditions.checkNotNull((Object)root);
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(root);
        return root.addConjunctsToNode(this.ctx_, analyzer, tupleIds, conjuncts);
    }

    private PlanNode createCheapestJoinPlan(Analyzer analyzer, List<Pair<TableRef, PlanNode>> parentRefPlans, List<SubplanRef> subplanRefs) throws ImpalaException {
        LOG.trace("createCheapestJoinPlan");
        if (parentRefPlans.size() == 1) {
            return (PlanNode)parentRefPlans.get((int)0).second;
        }
        ArrayList<Pair<TableRef, Long>> candidates = new ArrayList<Pair<TableRef, Long>>();
        for (Pair<TableRef, PlanNode> pair : parentRefPlans) {
            TableRef ref = (TableRef)pair.first;
            JoinOperator joinOp = ref.getJoinOp();
            if (joinOp.isOuterJoin() || joinOp.isSemiJoin() || joinOp.isCrossJoin()) continue;
            PlanNode plan = (PlanNode)pair.second;
            if (plan.getCardinality() == -1L) {
                candidates.add(new Pair<TableRef, Long>(ref, 0L));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("candidate " + ref.getUniqueAlias() + ": 0");
                continue;
            }
            Preconditions.checkState((boolean)ref.isAnalyzed());
            long materializedSize = (long)Math.ceil((double)plan.getAvgRowSize() * (double)plan.getCardinality());
            candidates.add(new Pair<TableRef, Long>(ref, materializedSize));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("candidate " + ref.getUniqueAlias() + ": " + Long.toString(materializedSize));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Collections.sort(candidates, new Comparator<Pair<TableRef, Long>>(){

            @Override
            public int compare(Pair<TableRef, Long> a, Pair<TableRef, Long> b) {
                long diff = (Long)b.second - (Long)a.second;
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        for (Pair<TableRef, PlanNode> pair : candidates) {
            PlanNode result = this.createJoinPlan(analyzer, (TableRef)pair.first, parentRefPlans, subplanRefs);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private PlanNode createJoinPlan(Analyzer analyzer, TableRef leftmostRef, List<Pair<TableRef, PlanNode>> refPlans, List<SubplanRef> subplanRefs) throws ImpalaException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("createJoinPlan: " + leftmostRef.getUniqueAlias());
        }
        ArrayList<Pair<TableRef, PlanNode>> remainingRefs = new ArrayList<Pair<TableRef, PlanNode>>();
        PlanNode root = null;
        for (Pair<TableRef, PlanNode> entry : refPlans) {
            if (entry.first == leftmostRef) {
                root = (PlanNode)entry.second;
                continue;
            }
            remainingRefs.add(entry);
        }
        Preconditions.checkNotNull(root);
        HashMap<TableRef, HashSet> precedingRefs = new HashMap<TableRef, HashSet>();
        ArrayList<TableRef> tmpTblRefs = new ArrayList<TableRef>();
        for (Pair<TableRef, PlanNode> entry : refPlans) {
            TableRef tblRef = (TableRef)entry.first;
            if (tblRef.getJoinOp().isOuterJoin() || tblRef.getJoinOp().isSemiJoin()) {
                precedingRefs.put(tblRef, Sets.newHashSet(tmpTblRefs));
            }
            tmpTblRefs.add(tblRef);
        }
        HashSet joinedRefs = Sets.newHashSet((Object[])new TableRef[]{leftmostRef});
        long numOps = 0L;
        int i = 0;
        while (!remainingRefs.isEmpty()) {
            PlanNode newRoot = null;
            Pair minEntry = null;
            for (Pair pair : remainingRefs) {
                TableRef ref = (TableRef)pair.first;
                JoinOperator joinOp = ref.getJoinOp();
                Set requiredRefs = (Set)precedingRefs.get(ref);
                if (requiredRefs != null) {
                    Preconditions.checkState((joinOp.isOuterJoin() || joinOp.isSemiJoin() ? 1 : 0) != 0);
                    if (!requiredRefs.equals(joinedRefs)) break;
                }
                analyzer.setAssignedConjuncts(root.getAssignedConjuncts());
                PlanNode candidate = this.createJoinNode(root, (PlanNode)pair.second, ref, analyzer);
                if (candidate == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("cardinality=" + Long.toString(candidate.getCardinality()));
                }
                if (joinOp.isOuterJoin() || joinOp.isSemiJoin()) {
                    newRoot = candidate;
                    minEntry = pair;
                    break;
                }
                if (newRoot != null && (!candidate.getClass().equals(newRoot.getClass()) || candidate.getCardinality() >= newRoot.getCardinality()) && (!(candidate instanceof HashJoinNode) || !(newRoot instanceof NestedLoopJoinNode))) continue;
                newRoot = candidate;
                minEntry = pair;
            }
            if (newRoot == null) {
                return null;
            }
            long lhsCardinality = root.getCardinality();
            long rhsCardinality = ((PlanNode)minEntry.second).getCardinality();
            numOps += lhsCardinality + rhsCardinality;
            if (LOG.isTraceEnabled()) {
                LOG.trace(Integer.toString(i) + " chose " + ((TableRef)minEntry.first).getUniqueAlias() + " #lhs=" + Long.toString(lhsCardinality) + " #rhs=" + Long.toString(rhsCardinality) + " #ops=" + Long.toString(numOps));
            }
            remainingRefs.remove(minEntry);
            joinedRefs.add(minEntry.first);
            root = newRoot;
            root = this.createSubplan(root, subplanRefs, false, analyzer);
            if (root instanceof SubplanNode) {
                ((PlanNode)root.getChild(0)).setId(this.ctx_.getNextNodeId());
            }
            root.setId(this.ctx_.getNextNodeId());
            analyzer.setAssignedConjuncts(root.getAssignedConjuncts());
            ++i;
        }
        return root;
    }

    private PlanNode createFromClauseJoinPlan(Analyzer analyzer, List<Pair<TableRef, PlanNode>> parentRefPlans, List<SubplanRef> subplanRefs) throws ImpalaException {
        Preconditions.checkState((!parentRefPlans.isEmpty() ? 1 : 0) != 0);
        PlanNode root = (PlanNode)parentRefPlans.get((int)0).second;
        for (int i = 1; i < parentRefPlans.size(); ++i) {
            PlanNode innerPlan = (PlanNode)parentRefPlans.get((int)i).second;
            TableRef innerRef = (TableRef)parentRefPlans.get((int)i).first;
            if ((root = this.createJoinNode(root, innerPlan, innerRef, analyzer)) != null) {
                root = this.createSubplan(root, subplanRefs, false, analyzer);
            }
            if (root instanceof SubplanNode) {
                ((PlanNode)root.getChild(0)).setId(this.ctx_.getNextNodeId());
            }
            root.setId(this.ctx_.getNextNodeId());
        }
        return root;
    }

    private PlanNode createSelectPlan(SelectStmt selectStmt, Analyzer analyzer) throws ImpalaException {
        if (selectStmt.getTableRefs().isEmpty()) {
            return this.createConstantSelectPlan(selectStmt, analyzer);
        }
        selectStmt.materializeRequiredSlots(analyzer);
        ArrayList<TupleId> rowTuples = new ArrayList<TupleId>();
        for (TableRef tblRef : selectStmt.getTableRefs()) {
            rowTuples.addAll(tblRef.getMaterializedTupleIds());
        }
        if (analyzer.hasEmptySpjResultSet()) {
            this.unmarkCollectionSlots(selectStmt);
            EmptySetNode emptySetNode = new EmptySetNode(this.ctx_.getNextNodeId(), rowTuples);
            ((PlanNode)emptySetNode).init(analyzer);
            emptySetNode.setOutputSmap(selectStmt.getBaseTblSmap());
            return this.createAggregationPlan(selectStmt, analyzer, emptySetNode);
        }
        if (!analyzer.isStraightJoin() && analyzer.getQueryOptions().isEnable_outer_join_to_inner_transformation() && analyzer.hasOuterJoined(selectStmt.getTableRefs())) {
            HashSet<TupleId> nonnullableTidList = new HashSet<TupleId>();
            if (analyzer.simplifyOuterJoins(selectStmt.getTableRefs(), nonnullableTidList)) {
                this.ctx_.getTimeline().markEvent("Recomputing value transfer graph");
                analyzer.computeValueTransferGraph();
                this.ctx_.getTimeline().markEvent("Value transfer graph computed");
                this.valueTransferGraphNeedsUpdate_ = false;
            }
        }
        ArrayList<TableRef> parentRefs = new ArrayList<TableRef>();
        ArrayList<SubplanRef> subplanRefs = new ArrayList<SubplanRef>();
        this.computeParentAndSubplanRefs(selectStmt.getTableRefs(), analyzer.isStraightJoin(), parentRefs, subplanRefs);
        MultiAggregateInfo multiAggInfo = selectStmt.getMultiAggInfo();
        PlanNode root = this.createTableRefsPlan(parentRefs, subplanRefs, multiAggInfo, analyzer);
        if (multiAggInfo != null) {
            if (multiAggInfo.getMaterializedAggClasses().size() == 1 && (root instanceof HdfsScanNode || root instanceof KuduScanNode)) {
                AggregateInfo scanAggInfo = multiAggInfo.getMaterializedAggClass(0);
                scanAggInfo.substitute(((ScanNode)root).getOptimizedAggSmap(), analyzer);
                scanAggInfo.getMergeAggInfo().substitute(((ScanNode)root).getOptimizedAggSmap(), analyzer);
            }
            root = this.createAggregationPlan(selectStmt, analyzer, root);
        }
        return root;
    }

    private void computeParentAndSubplanRefs(List<TableRef> tblRefs, boolean isStraightJoin, List<TableRef> parentRefs, List<SubplanRef> subplanRefs) {
        ArrayList<TupleId> planTblRefIds = new ArrayList<TupleId>();
        List<Object> subplanTids = Collections.emptyList();
        if (this.ctx_.hasSubplan()) {
            planTblRefIds.addAll(((PlanNode)this.ctx_.getSubplan().getChild(0)).getTblRefIds());
            subplanTids = Collections.unmodifiableList(((PlanNode)this.ctx_.getSubplan().getChild(0)).getTupleIds());
        }
        TableRef lastSemiOrOuterJoin = null;
        for (TableRef ref : tblRefs) {
            boolean isParentRef = true;
            if (ref.isRelative() || ref.isCorrelated()) {
                ArrayList<TupleId> requiredTids = new ArrayList<TupleId>();
                ArrayList<TupleId> requiredTblRefIds = new ArrayList<TupleId>();
                if (ref.isCorrelated()) {
                    requiredTids.addAll(ref.getCorrelatedTupleIds());
                } else {
                    CollectionTableRef collectionTableRef = (CollectionTableRef)ref;
                    SlotRef collectionExpr = (SlotRef)collectionTableRef.getCollectionExpr();
                    if (collectionExpr != null) {
                        SlotDescriptor desc = collectionExpr.getDesc();
                        TupleDescriptor topTuple = desc.getTopEnclosingTupleDesc();
                        requiredTids.add(topTuple.getId());
                    } else {
                        requiredTids.add(collectionTableRef.getResolvedPath().getRootDesc().getId());
                    }
                }
                if (isStraightJoin) {
                    requiredTblRefIds.addAll(planTblRefIds);
                }
                if (lastSemiOrOuterJoin != null) {
                    requiredTblRefIds.addAll(lastSemiOrOuterJoin.getAllTableRefIds());
                }
                if (!subplanTids.containsAll(requiredTids)) {
                    isParentRef = false;
                    if (ref.getJoinOp().isOuterJoin() || ref.getJoinOp().isSemiJoin()) {
                        requiredTblRefIds.addAll(ref.getAllTableRefIds());
                        requiredTblRefIds.remove(ref.getId());
                    }
                    subplanRefs.add(new SubplanRef(ref, requiredTids, requiredTblRefIds));
                }
            }
            if (isParentRef) {
                parentRefs.add(ref);
                planTblRefIds.add(ref.getId());
            }
            if (!ref.getJoinOp().isOuterJoin() && !ref.getJoinOp().isSemiJoin()) continue;
            lastSemiOrOuterJoin = ref;
        }
        Preconditions.checkState((tblRefs.size() == parentRefs.size() + subplanRefs.size() ? 1 : 0) != 0);
        parentRefs.get(0).setLeftTblRef(null);
        for (int i = 1; i < parentRefs.size(); ++i) {
            parentRefs.get(i).setLeftTblRef(parentRefs.get(i - 1));
        }
        for (SubplanRef subplanRef : subplanRefs) {
            subplanRef.tblRef.setLeftTblRef(null);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("parentRefs: {}", (Object)parentRefs.stream().map(TableRef::debugString).reduce(", ", String::concat));
            LOG.trace("subplanRefs: {}", (Object)subplanRefs.stream().map(r -> r.tblRef.debugString()).reduce(", ", String::concat));
        }
    }

    private PlanNode createTableRefsPlan(List<TableRef> parentRefs, List<SubplanRef> subplanRefs, MultiAggregateInfo aggInfo, Analyzer analyzer) throws ImpalaException {
        ArrayList<Pair<TableRef, PlanNode>> parentRefPlans = new ArrayList<Pair<TableRef, PlanNode>>();
        List<CollectionTableRef> unnestCollectionRefs = this.extractZippingUnnestTableRefs(parentRefs);
        this.reduceUnnestCollectionRefs(parentRefs, unnestCollectionRefs);
        for (TableRef tableRef : parentRefs) {
            PlanNode root = this.createTableRefNode(tableRef, aggInfo, analyzer, unnestCollectionRefs);
            Preconditions.checkNotNull((Object)root);
            root = this.createSubplan(root, subplanRefs, true, analyzer);
            parentRefPlans.add(new Pair<TableRef, PlanNode>(tableRef, root));
        }
        for (Pair pair : parentRefPlans) {
            ((PlanNode)pair.second).setAssignedConjuncts(analyzer.getAssignedConjuncts());
        }
        PlanNode root = null;
        if (!analyzer.isStraightJoin()) {
            Set<ExprId> set = analyzer.getAssignedConjuncts();
            root = this.createCheapestJoinPlan(analyzer, parentRefPlans, subplanRefs);
            if (root == null) {
                analyzer.setAssignedConjuncts(set);
            }
        }
        if (analyzer.isStraightJoin() || root == null) {
            root = this.createFromClauseJoinPlan(analyzer, parentRefPlans, subplanRefs);
            Preconditions.checkNotNull((Object)root);
        }
        return root;
    }

    private PlanNode createSubplan(PlanNode root, List<SubplanRef> subplanRefs, boolean assignId, Analyzer analyzer) throws ImpalaException {
        Preconditions.checkNotNull((Object)root);
        List<TableRef> applicableRefs = this.extractApplicableRefs(root, subplanRefs);
        if (applicableRefs.isEmpty()) {
            return root;
        }
        Preconditions.checkState((applicableRefs.get(0).getLeftTblRef() == null ? 1 : 0) != 0);
        applicableRefs.add(0, new SingularRowSrcTableRef(root));
        applicableRefs.get(1).setLeftTblRef(applicableRefs.get(0));
        SubplanNode subplanNode = new SubplanNode(root);
        if (assignId) {
            subplanNode.setId(this.ctx_.getNextNodeId());
        }
        this.ctx_.pushSubplan(subplanNode);
        PlanNode subplan = this.createTableRefsPlan(applicableRefs, subplanRefs, null, analyzer);
        this.ctx_.popSubplan();
        subplanNode.setSubplan(subplan);
        subplanNode.init(analyzer);
        return subplanNode;
    }

    private List<TableRef> extractApplicableRefs(PlanNode root, List<SubplanRef> subplanRefs) {
        ArrayList tblRefIds = Lists.newArrayList(root.getTblRefIds());
        ArrayList<TableRef> result = new ArrayList<TableRef>();
        Iterator<SubplanRef> subplanRefIt = subplanRefs.iterator();
        TableRef leftTblRef = null;
        while (subplanRefIt.hasNext()) {
            SubplanRef subplanRef = subplanRefIt.next();
            if (!root.getTupleIds().containsAll(subplanRef.requiredTids) || !tblRefIds.containsAll(subplanRef.requiredTblRefIds)) continue;
            subplanRef.tblRef.setLeftTblRef(leftTblRef);
            result.add(subplanRef.tblRef);
            leftTblRef = subplanRef.tblRef;
            subplanRefIt.remove();
            tblRefIds.add(subplanRef.tblRef.getId());
        }
        return result;
    }

    private List<CollectionTableRef> extractZippingUnnestTableRefs(List<TableRef> refs) {
        Preconditions.checkNotNull(refs);
        ArrayList collectionRefs = Lists.newArrayList();
        for (TableRef ref : refs) {
            if (!(ref instanceof CollectionTableRef) || !ref.isZippingUnnest()) continue;
            collectionRefs.add((CollectionTableRef)ref);
        }
        return collectionRefs;
    }

    private void reduceUnnestCollectionRefs(List<TableRef> refs, List<CollectionTableRef> unnestCollectionRefs) {
        Preconditions.checkNotNull(refs);
        Preconditions.checkNotNull(unnestCollectionRefs);
        if (unnestCollectionRefs.size() <= 1) {
            return;
        }
        List<CollectionTableRef> reducedCollectionRefs = unnestCollectionRefs.subList(1, unnestCollectionRefs.size());
        refs.removeAll(reducedCollectionRefs);
    }

    private AggregationNode createAggregationPlan(SelectStmt selectStmt, Analyzer analyzer, PlanNode root) throws ImpalaException {
        MultiAggregateInfo multiAggInfo = (MultiAggregateInfo)Preconditions.checkNotNull((Object)selectStmt.getMultiAggInfo());
        AggregationNode result = this.createAggregationPlan(root, multiAggInfo, analyzer);
        ExprSubstitutionMap simplifiedAggSmap = multiAggInfo.getSimplifiedAggSmap();
        if (simplifiedAggSmap == null) {
            return result;
        }
        AggregationNode dummyAgg = new AggregationNode(this.ctx_.getNextNodeId(), result, multiAggInfo, MultiAggregateInfo.AggPhase.TRANSPOSE);
        dummyAgg.init(analyzer);
        List<Expr> conjuncts = Expr.substituteList(dummyAgg.getConjuncts(), simplifiedAggSmap, analyzer, true);
        for (Expr c : conjuncts) {
            Preconditions.checkState((boolean)c.isBound(result.getTupleIds().get(0)));
        }
        result.getConjuncts().addAll(conjuncts);
        result.setOutputSmap(ExprSubstitutionMap.compose(result.getOutputSmap(), simplifiedAggSmap, analyzer));
        return result;
    }

    private AggregationNode createAggregationPlan(PlanNode root, MultiAggregateInfo multiAggInfo, Analyzer analyzer) throws InternalException {
        Preconditions.checkNotNull((Object)multiAggInfo);
        AggregationNode agg = new AggregationNode(this.ctx_.getNextNodeId(), root, multiAggInfo, MultiAggregateInfo.AggPhase.FIRST);
        agg.init(analyzer);
        if (!multiAggInfo.hasSecondPhase() && !multiAggInfo.hasTransposePhase()) {
            return agg;
        }
        agg.setIntermediateTuple();
        if (multiAggInfo.hasSecondPhase()) {
            agg.unsetNeedsFinalize();
            agg = new AggregationNode(this.ctx_.getNextNodeId(), agg, multiAggInfo, MultiAggregateInfo.AggPhase.SECOND);
            agg.init(analyzer);
        }
        if (multiAggInfo.hasTransposePhase()) {
            agg = new AggregationNode(this.ctx_.getNextNodeId(), agg, multiAggInfo, MultiAggregateInfo.AggPhase.TRANSPOSE);
            agg.init(analyzer);
        }
        return agg;
    }

    private PlanNode createConstantSelectPlan(SelectStmt selectStmt, Analyzer analyzer) throws InternalException {
        Preconditions.checkState((boolean)selectStmt.getTableRefs().isEmpty());
        List<Expr> resultExprs = selectStmt.getResultExprs();
        TupleDescriptor tupleDesc = this.createResultTupleDescriptor(selectStmt, "union", analyzer);
        UnionNode unionNode = new UnionNode(this.ctx_.getNextNodeId(), tupleDesc.getId());
        unionNode.addConstExprList(Lists.newArrayList(resultExprs));
        for (int i = 0; i < resultExprs.size(); ++i) {
            SlotRef slotRef = new SlotRef(tupleDesc.getSlots().get(i));
            resultExprs.set(i, slotRef);
        }
        unionNode.init(analyzer);
        return unionNode;
    }

    private TupleDescriptor createResultTupleDescriptor(SelectStmt selectStmt, String debugName, Analyzer analyzer) {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().createTupleDescriptor(debugName);
        tupleDesc.setIsMaterialized(true);
        List<Expr> resultExprs = selectStmt.getResultExprs();
        List<String> colLabels = selectStmt.getColLabels();
        for (int i = 0; i < resultExprs.size(); ++i) {
            Expr resultExpr = resultExprs.get(i);
            String colLabel = colLabels.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(tupleDesc);
            slotDesc.setLabel(colLabel);
            slotDesc.setSourceExpr(resultExpr);
            slotDesc.setType(resultExpr.getType());
            slotDesc.setStats(ColumnStats.fromExpr(resultExpr));
            slotDesc.setIsMaterialized(true);
        }
        tupleDesc.computeMemLayout();
        return tupleDesc;
    }

    private PlanNode createInlineViewPlan(Analyzer analyzer, InlineViewRef inlineViewRef) throws ImpalaException {
        SelectStmt selectStmt;
        this.migrateConjunctsToInlineView(analyzer, inlineViewRef);
        this.migrateSimpleLimitToInlineView(analyzer, inlineViewRef);
        QueryStmt viewStmt = inlineViewRef.getViewStmt();
        if (viewStmt instanceof SelectStmt && (selectStmt = (SelectStmt)viewStmt).getTableRefs().isEmpty()) {
            if (inlineViewRef.getAnalyzer().hasEmptyResultSet()) {
                PlanNode emptySetNode = this.createEmptyNode(viewStmt, inlineViewRef.getAnalyzer());
                Preconditions.checkState((!analyzer.isOuterJoined(inlineViewRef.getId()) ? 1 : 0) != 0);
                emptySetNode.setOutputSmap(inlineViewRef.getSmap());
                emptySetNode.setTblRefIds(Lists.newArrayList((Object[])new TupleId[]{inlineViewRef.getId()}));
                return emptySetNode;
            }
            Preconditions.checkState((inlineViewRef.getMaterializedTupleIds().size() == 1 ? 1 : 0) != 0);
            analyzer.getTupleDesc(inlineViewRef.getId()).materializeSlots();
            UnionNode unionNode = new UnionNode(this.ctx_.getNextNodeId(), inlineViewRef.getMaterializedTupleIds().get(0));
            if (analyzer.hasEmptyResultSet()) {
                return unionNode;
            }
            unionNode.setTblRefIds(Lists.newArrayList((Object[])new TupleId[]{inlineViewRef.getId()}));
            unionNode.addConstExprList(selectStmt.getBaseTblResultExprs());
            unionNode.init(analyzer);
            return unionNode;
        }
        PlanNode rootNode = this.createQueryPlan(inlineViewRef.getViewStmt(), inlineViewRef.getAnalyzer(), false);
        rootNode.setTblRefIds(Lists.newArrayList((Object[])new TupleId[]{inlineViewRef.getId()}));
        ExprSubstitutionMap outputSmap = ExprSubstitutionMap.compose(inlineViewRef.getSmap(), rootNode.getOutputSmap(), analyzer);
        if (analyzer.isOuterJoined(inlineViewRef.getId())) {
            List<Expr> nullableRhs = TupleIsNullPredicate.wrapExprs(outputSmap.getRhs(), rootNode.getTupleIds(), analyzer);
            outputSmap = new ExprSubstitutionMap(outputSmap.getLhs(), nullableRhs);
        }
        rootNode.setOutputSmap(outputSmap);
        if (inlineViewRef.getViewStmt().isRuntimeScalar()) {
            rootNode = new CardinalityCheckNode(this.ctx_.getNextNodeId(), rootNode, inlineViewRef.getViewStmt().getOrigSqlString());
            rootNode.setOutputSmap(outputSmap);
            rootNode.init(this.ctx_.getRootAnalyzer());
        }
        if (!this.canMigrateConjuncts(inlineViewRef)) {
            rootNode = this.addUnassignedConjuncts(analyzer, inlineViewRef.getDesc().getId().asList(), rootNode);
        }
        if (rootNode instanceof AggregationNode) {
            ((AggregationNode)rootNode).setIsNonCorrelatedScalarSubquery(inlineViewRef.isNonCorrelatedScalarSubquery());
        }
        return rootNode;
    }

    private void getConjunctsToInlineView(Analyzer analyzer, String alias, List<TupleId> tupleIds, List<Expr> unassignedConjuncts, List<Expr> evalInInlineViewPreds, List<Expr> evalAfterJoinPreds) {
        for (Expr e : unassignedConjuncts) {
            if (!e.isBoundByTupleIds(tupleIds)) continue;
            ArrayList<TupleId> tids = new ArrayList<TupleId>();
            e.getIds(tids, null);
            if (tids.isEmpty()) {
                evalInInlineViewPreds.add(e);
            } else if (e.isOnClauseConjunct()) {
                if (!analyzer.canEvalOnClauseConjunct(tupleIds, e)) continue;
                evalInInlineViewPreds.add(e);
            } else if (analyzer.isLastOjMaterializedByTupleIds(tupleIds, e)) {
                evalInInlineViewPreds.add(e);
            } else {
                try {
                    if (analyzer.isTrueWithNullSlots(e)) continue;
                    evalAfterJoinPreds.add(e);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Can propagate {} to inline view {}", (Object)e.debugString(), (Object)alias);
                }
                catch (InternalException ex) {
                    LOG.warn("Skipping propagation of conjunct because backend evaluation failed: " + e.toSql(), (Throwable)ex);
                }
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Can evaluate {} in inline view {}", (Object)e.debugString(), (Object)alias);
        }
    }

    public void migrateSimpleLimitToInlineView(Analyzer analyzer, InlineViewRef inlineViewRef) {
        Pair<Boolean, Long> outerStatus = analyzer.getSimpleLimitStatus();
        if (outerStatus == null || !((Boolean)outerStatus.first).booleanValue() || inlineViewRef.isTableMaskingView()) {
            return;
        }
        Pair<Boolean, Long> viewStatus = inlineViewRef.getAnalyzer().getSimpleLimitStatus();
        if (viewStatus != null && !((Boolean)viewStatus.first).booleanValue()) {
            inlineViewRef.getAnalyzer().setSimpleLimitStatus(new Pair<Boolean, Long>(true, (Long)outerStatus.second));
        }
    }

    private void migrateConjunctsToInlineView(Analyzer analyzer, InlineViewRef inlineViewRef) throws ImpalaException {
        ArrayList<TupleId> tids = inlineViewRef.getId().asList();
        if (inlineViewRef.isTableMaskingView() && inlineViewRef.getUnMaskedTableRef().exposeNestedColumnsByTableMaskView()) {
            tids.add(inlineViewRef.getUnMaskedTableRef().getId());
        }
        List<Expr> unassignedConjuncts = analyzer.getUnassignedConjuncts(tids, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("migrateConjunctsToInlineView() unassignedConjuncts: " + Expr.debugString(unassignedConjuncts));
        }
        if (!this.canMigrateConjuncts(inlineViewRef)) {
            List<Expr> analyticPreds = this.findAnalyticConjunctsToMigrate(analyzer, inlineViewRef, unassignedConjuncts);
            if (analyticPreds.size() > 0) {
                this.migrateOrCopyConjunctsToInlineView(analyzer, inlineViewRef, tids, analyticPreds, unassignedConjuncts);
            }
        } else {
            this.migrateOrCopyConjunctsToInlineView(analyzer, inlineViewRef, tids, unassignedConjuncts, unassignedConjuncts);
        }
        List<Expr> substUnassigned = Expr.substituteList(unassignedConjuncts, inlineViewRef.getBaseTblSmap(), analyzer, false);
        analyzer.materializeSlots(substUnassigned);
    }

    private void migrateOrCopyConjunctsToInlineView(Analyzer analyzer, InlineViewRef inlineViewRef, List<TupleId> tids, List<Expr> evalPreds, List<Expr> unassignedConjuncts) throws ImpalaException {
        ArrayList<Expr> evalInInlineViewPreds = new ArrayList<Expr>();
        ArrayList<Expr> evalAfterJoinPreds = new ArrayList<Expr>();
        this.getConjunctsToInlineView(analyzer, inlineViewRef.getExplicitAlias(), tids, evalPreds, evalInInlineViewPreds, evalAfterJoinPreds);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Assign predicates for view: migrating {}, coping {}.", (Object)Expr.debugString(evalInInlineViewPreds), (Object)Expr.debugString(evalAfterJoinPreds));
        }
        unassignedConjuncts.removeAll(evalInInlineViewPreds);
        analyzer.markConjunctsAssigned(evalInInlineViewPreds);
        evalInInlineViewPreds.addAll(evalAfterJoinPreds);
        this.addConjunctsIntoInlineView(analyzer, inlineViewRef, evalInInlineViewPreds);
    }

    private List<Expr> findAnalyticConjunctsToMigrate(Analyzer analyzer, InlineViewRef inlineViewRef, List<Expr> conjuncts) {
        if (inlineViewRef.getViewStmt().hasLimit() || inlineViewRef.getViewStmt().hasOffset() || !(inlineViewRef.getViewStmt() instanceof SelectStmt)) {
            return Collections.emptyList();
        }
        SelectStmt selectStmt = (SelectStmt)inlineViewRef.getViewStmt();
        if (!selectStmt.hasAnalyticInfo()) {
            return Collections.emptyList();
        }
        TupleDescriptor analyticTuple = selectStmt.getAnalyticInfo().getOutputTupleDesc();
        ArrayList<Expr> analyticPreds = new ArrayList<Expr>();
        ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
        for (Expr pred : conjuncts) {
            Expr viewPred = pred.substitute(inlineViewRef.getSmap(), analyzer, false);
            tupleIds.clear();
            viewPred.getIds(tupleIds, null);
            if (!viewPred.referencesTuple(analyticTuple.getId()) || tupleIds.size() > 1) continue;
            analyticPreds.add(pred);
        }
        return analyticPreds;
    }

    private void addConjunctsIntoInlineView(final Analyzer analyzer, final InlineViewRef inlineViewRef, List<Expr> preds) throws AnalysisException {
        analyzer.createEquivConjuncts(inlineViewRef.getId(), preds);
        com.google.common.base.Predicate<Expr> isIdentityPredicate = new com.google.common.base.Predicate<Expr>(){

            public boolean apply(Expr e) {
                if (!Predicate.isEquivalencePredicate(e) || !((BinaryPredicate)e).isInferred()) {
                    return false;
                }
                try {
                    BinaryPredicate finalExpr = (BinaryPredicate)e.trySubstitute(inlineViewRef.getBaseTblSmap(), analyzer, false);
                    boolean isIdentity = finalExpr.hasIdenticalOperands();
                    BinaryPredicate midExpr = (BinaryPredicate)e.trySubstitute(inlineViewRef.getSmap(), analyzer, false);
                    Preconditions.checkState((!midExpr.hasIdenticalOperands() || isIdentity ? 1 : 0) != 0);
                    if (LOG.isTraceEnabled() && isIdentity) {
                        LOG.trace("Removed identity predicate: " + finalExpr.debugString());
                    }
                    return isIdentity;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed analysis after expr substitution.", ex);
                }
            }
        };
        Iterables.removeIf(preds, (com.google.common.base.Predicate)isIdentityPredicate);
        List<Expr> viewPredicates = Expr.substituteList(preds, inlineViewRef.getSmap(), analyzer, false);
        this.removeDisqualifyingInferredPreds(inlineViewRef, viewPredicates);
        for (Expr e : viewPredicates) {
            e.setIsOnClauseConjunct(false);
        }
        inlineViewRef.getAnalyzer().registerConjuncts(viewPredicates);
    }

    private void removeDisqualifyingInferredPreds(InlineViewRef inlineViewRef, List<Expr> preds) {
        Analyzer analyzer = inlineViewRef.getAnalyzer();
        String WARN_MESSAGE_HEADER = "Removed inferred predicate %s from the list of predicates considered for inline view because %s.";
        boolean isAnalytic = !this.canMigrateConjuncts(inlineViewRef);
        ListIterator<Expr> iter = preds.listIterator();
        while (iter.hasNext()) {
            BinaryPredicate p;
            Pair<SlotId, SlotId> slots;
            Expr e = iter.next();
            if (!(e instanceof BinaryPredicate) || !((BinaryPredicate)e).isInferred() || (slots = (p = (BinaryPredicate)e).getEqSlots()) == null) continue;
            TupleId leftParent = analyzer.getTupleId((SlotId)slots.first);
            TupleId rightParent = analyzer.getTupleId((SlotId)slots.second);
            if (analyzer.isOuterJoined(leftParent) || analyzer.isOuterJoined(rightParent)) {
                iter.remove();
                LOG.warn(String.format(WARN_MESSAGE_HEADER, p.toSql(), "either the left or right side is derived from an outer join output"));
                continue;
            }
            if (!isAnalytic || !leftParent.equals(rightParent)) continue;
            iter.remove();
            LOG.warn(String.format(WARN_MESSAGE_HEADER, p.toSql(), "both sides of the predicate reference the same TupleId " + leftParent + " which could result in pushing the conjunct to the scan node before the analytic function is applied"));
        }
    }

    private boolean canMigrateConjuncts(InlineViewRef inlineViewRef) {
        return !inlineViewRef.getViewStmt().hasLimit() && !inlineViewRef.getViewStmt().hasOffset() && (!(inlineViewRef.getViewStmt() instanceof SelectStmt) || !((SelectStmt)inlineViewRef.getViewStmt()).hasAnalyticInfo());
    }

    private PlanNode createHdfsScanPlan(TableRef hdfsTblRef, MultiAggregateInfo aggInfo, List<Expr> conjuncts, Analyzer analyzer) throws ImpalaException {
        TupleDescriptor tupleDesc = hdfsTblRef.getDesc();
        HdfsPartitionPruner pruner = new HdfsPartitionPruner(tupleDesc);
        Pair<List<? extends FeFsPartition>, List<Expr>> pair = pruner.prunePartitions(analyzer, conjuncts, false, hdfsTblRef);
        List partitions = (List)pair.first;
        analyzer.materializeSlots(conjuncts);
        FeFsPartition part = this.findUnsupportedDateFsPartition(partitions);
        if (part != null) {
            FeFsTable table = (FeFsTable)hdfsTblRef.getTable();
            HdfsFileFormat ff = part.getFileFormat();
            for (SlotDescriptor slotDesc : tupleDesc.getMaterializedSlots()) {
                if (slotDesc.getColumn() == null || table.isClusteringColumn(slotDesc.getColumn()) || slotDesc.getType() != ScalarType.DATE) continue;
                throw new NotImplementedException("Scanning DATE values in table '" + table.getFullName() + "' is not supported for fileformat " + (Object)((Object)ff));
            }
        }
        boolean allAggsDistinct = aggInfo != null && aggInfo.hasAllDistinctAgg();
        boolean isPartitionKeyScan = allAggsDistinct && tupleDesc.hasClusteringColsOnly();
        TQueryOptions queryOpts = analyzer.getQueryCtx().client_request.query_options;
        if (isPartitionKeyScan && queryOpts.optimize_partition_key_scans) {
            HashSet uniqueExprs = new HashSet();
            for (FeFsPartition partition : partitions) {
                if (partition.getSize() == 0L) continue;
                ArrayList<LiteralExpr> arrayList = new ArrayList<LiteralExpr>();
                for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                    if (!slotDesc.isMaterialized()) {
                        arrayList.add(NullLiteral.create(slotDesc.getType()));
                        continue;
                    }
                    int pos = slotDesc.getColumn().getPosition();
                    arrayList.add(partition.getPartitionValue(pos));
                }
                uniqueExprs.add(arrayList);
            }
            UnionNode unionNode = new UnionNode(this.ctx_.getNextNodeId(), tupleDesc.getId());
            for (List list : uniqueExprs) {
                unionNode.addConstExprList(list);
            }
            unionNode.init(analyzer);
            return unionNode;
        }
        if (SingleNodePlanner.addAcidSlotsIfNeeded(analyzer, hdfsTblRef, partitions)) {
            return SingleNodePlanner.createAcidJoinNode(analyzer, hdfsTblRef, conjuncts, partitions, (List)pair.second, this.ctx_);
        }
        HdfsScanNode scanNode = new HdfsScanNode(this.ctx_.getNextNodeId(), tupleDesc, conjuncts, partitions, hdfsTblRef, aggInfo, (List)pair.second, isPartitionKeyScan);
        scanNode.init(analyzer);
        return scanNode;
    }

    public static boolean addAcidSlotsIfNeeded(Analyzer analyzer, TableRef hdfsTblRef, List<? extends FeFsPartition> partitions) throws AnalysisException {
        FeTable feTable = hdfsTblRef.getTable();
        if (!AcidUtils.isFullAcidTable(feTable.getMetaStoreTable().getParameters())) {
            return false;
        }
        boolean areThereDeletedRows = false;
        for (FeFsPartition feFsPartition : partitions) {
            if (feFsPartition.genDeleteDeltaPartition() == null) continue;
            areThereDeletedRows = true;
            break;
        }
        if (!areThereDeletedRows) {
            return false;
        }
        SingleNodePlanner.addAcidSlots(analyzer, hdfsTblRef);
        return true;
    }

    public static void addAcidSlots(Analyzer analyzer, TableRef hdfsTblRef) throws AnalysisException {
        String[] acidFields;
        FeTable feTable = hdfsTblRef.getTable();
        ArrayList<String> rawPath = new ArrayList<String>();
        rawPath.add(hdfsTblRef.getUniqueAlias());
        for (Column partCol : feTable.getClusteringColumns()) {
            rawPath.add(partCol.getName());
            SingleNodePlanner.addSlotRefToDesc(analyzer, rawPath);
            rawPath.remove(rawPath.size() - 1);
        }
        rawPath.add("row__id");
        for (String acidField : acidFields = new String[]{"originaltransaction", "bucket", "rowid"}) {
            rawPath.add(acidField);
            SingleNodePlanner.addSlotRefToDesc(analyzer, rawPath);
            rawPath.remove(rawPath.size() - 1);
        }
    }

    public static SlotDescriptor addSlotRefToDesc(Analyzer analyzer, List<String> rawPath) throws AnalysisException {
        Path resolvedPath = null;
        try {
            resolvedPath = analyzer.resolvePath(rawPath, Path.PathType.SLOT_REF);
        }
        catch (TableLoadingException e) {
            Preconditions.checkState((boolean)false);
        }
        Preconditions.checkNotNull((Object)resolvedPath);
        SlotDescriptor desc = analyzer.registerSlotRef(resolvedPath);
        desc.setIsMaterialized(true);
        return desc;
    }

    public static PlanNode createAcidJoinNode(Analyzer analyzer, TableRef hdfsTblRef, List<Expr> conjuncts, List<? extends FeFsPartition> partitions, List<Expr> partConjuncts, PlannerContext ctx) throws ImpalaException {
        FeTable feTable = hdfsTblRef.getTable();
        Preconditions.checkState((boolean)AcidUtils.isFullAcidTable(feTable.getMetaStoreTable().getParameters()));
        ArrayList<FeFsPartition> insertDeltaPartitions = new ArrayList<FeFsPartition>();
        ArrayList<FeFsPartition> deleteDeltaPartitions = new ArrayList<FeFsPartition>();
        for (FeFsPartition feFsPartition : partitions) {
            insertDeltaPartitions.add(feFsPartition.genInsertDeltaPartition());
            FeFsPartition deleteDeltaPartition = feFsPartition.genDeleteDeltaPartition();
            if (deleteDeltaPartition == null) continue;
            deleteDeltaPartitions.add(deleteDeltaPartition);
        }
        TableRef deleteDeltaRef = TableRef.newTableRef(analyzer, hdfsTblRef.getPath(), hdfsTblRef.getUniqueAlias() + "-delete-delta");
        SingleNodePlanner.addAcidSlots(analyzer, deleteDeltaRef);
        HdfsScanNode hdfsScanNode = new HdfsScanNode(ctx.getNextNodeId(), hdfsTblRef.getDesc(), conjuncts, insertDeltaPartitions, hdfsTblRef, null, partConjuncts, false);
        hdfsScanNode.init(analyzer);
        HdfsScanNode deleteDeltaScanNode = new HdfsScanNode(ctx.getNextNodeId(), deleteDeltaRef.getDesc(), Collections.emptyList(), deleteDeltaPartitions, deleteDeltaRef, null, partConjuncts, false);
        deleteDeltaScanNode.init(analyzer);
        List<BinaryPredicate> acidJoinConjuncts = SingleNodePlanner.createAcidJoinConjuncts(analyzer, hdfsTblRef.getDesc(), deleteDeltaRef.getDesc());
        HashJoinNode acidJoin = new HashJoinNode(hdfsScanNode, deleteDeltaScanNode, true, JoinNode.DistributionMode.BROADCAST, JoinOperator.LEFT_ANTI_JOIN, acidJoinConjuncts, Collections.emptyList());
        acidJoin.setId(ctx.getNextNodeId());
        ((JoinNode)acidJoin).init(analyzer);
        acidJoin.setIsDeleteRowsJoin();
        return acidJoin;
    }

    public static List<BinaryPredicate> createAcidJoinConjuncts(Analyzer analyzer, TupleDescriptor insertTupleDesc, TupleDescriptor deleteTupleDesc) throws AnalysisException {
        ArrayList<BinaryPredicate> ret = new ArrayList<BinaryPredicate>();
        for (SlotDescriptor deleteSlotDesc : deleteTupleDesc.getSlots()) {
            boolean foundMatch = false;
            for (SlotDescriptor insertSlotDesc : insertTupleDesc.getSlots()) {
                if (!deleteSlotDesc.getMaterializedPath().equals(insertSlotDesc.getMaterializedPath())) continue;
                foundMatch = true;
                BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(insertSlotDesc), new SlotRef(deleteSlotDesc));
                pred.analyze(analyzer);
                ret.add(pred);
                break;
            }
            Preconditions.checkState((boolean)foundMatch);
        }
        return ret;
    }

    private FeFsPartition findUnsupportedDateFsPartition(List<? extends FeFsPartition> partitions) {
        for (FeFsPartition feFsPartition : partitions) {
            HdfsFileFormat ff = feFsPartition.getFileFormat();
            if (ff.isDateTypeSupported()) continue;
            return feFsPartition;
        }
        return null;
    }

    private PlanNode createScanNode(TableRef tblRef, MultiAggregateInfo aggInfo, Analyzer analyzer) throws ImpalaException {
        FeTable table;
        ScanNode scanNode = null;
        ArrayList<Expr> conjuncts = new ArrayList<Expr>();
        TupleId tid = tblRef.getId();
        conjuncts.addAll(analyzer.getBoundPredicates(tid));
        List<Expr> unassigned = analyzer.getUnassignedConjuncts(tid.asList());
        PlanNode.removeZippingUnnestConjuncts(unassigned, analyzer);
        conjuncts.addAll(unassigned);
        analyzer.markConjunctsAssigned(unassigned);
        analyzer.createEquivConjuncts(tid, conjuncts);
        if (analyzer.getQueryCtx().client_request.query_options.enable_expr_rewrites) {
            if (!Expr.optimizeConjuncts(conjuncts, analyzer)) {
                EmptySetNode node = new EmptySetNode(this.ctx_.getNextNodeId(), tid.asList());
                node.init(analyzer);
                return node;
            }
        } else {
            Expr.removeDuplicates(conjuncts);
        }
        if ((table = tblRef.getTable()) instanceof FeFsTable) {
            if (table instanceof FeIcebergTable) {
                IcebergScanPlanner icebergPlanner = new IcebergScanPlanner(analyzer, this.ctx_, tblRef, conjuncts, aggInfo);
                return icebergPlanner.createIcebergScanPlan();
            }
            return this.createHdfsScanPlan(tblRef, aggInfo, conjuncts, analyzer);
        }
        if (table instanceof FeDataSourceTable) {
            scanNode = new DataSourceScanNode(this.ctx_.getNextNodeId(), tblRef.getDesc(), conjuncts);
            scanNode.init(analyzer);
            return scanNode;
        }
        if (table instanceof FeHBaseTable) {
            scanNode = new HBaseScanNode(this.ctx_.getNextNodeId(), tblRef.getDesc());
            scanNode.addConjuncts(conjuncts);
            scanNode.init(analyzer);
            return scanNode;
        }
        if (table instanceof FeKuduTable) {
            scanNode = new KuduScanNode(this.ctx_.getNextNodeId(), tblRef.getDesc(), conjuncts, aggInfo, tblRef);
            scanNode.init(analyzer);
            return scanNode;
        }
        if (table instanceof IcebergMetadataTable) {
            return this.createIcebergMetadataScanNode(tblRef, conjuncts, analyzer);
        }
        if (table instanceof FeSystemTable) {
            scanNode = new SystemTableScanNode(this.ctx_.getNextNodeId(), tblRef.getDesc());
            scanNode.addConjuncts(conjuncts);
            scanNode.init(analyzer);
            return scanNode;
        }
        throw new NotImplementedException("Planning not implemented for table class: " + table.getClass());
    }

    private PlanNode createIcebergMetadataScanNode(TableRef tblRef, List<Expr> conjuncts, Analyzer analyzer) throws ImpalaException {
        IcebergMetadataScanNode icebergMetadataScanNode = new IcebergMetadataScanNode(this.ctx_.getNextNodeId(), conjuncts, tblRef);
        icebergMetadataScanNode.init(analyzer);
        return icebergMetadataScanNode;
    }

    private List<BinaryPredicate> getHashLookupJoinConjuncts(List<TupleId> lhsTblRefIds, List<TupleId> rhsTblRefIds, Analyzer analyzer) {
        ArrayList<BinaryPredicate> result = new ArrayList<BinaryPredicate>();
        List<Expr> candidates = analyzer.getEqJoinConjuncts(lhsTblRefIds, rhsTblRefIds);
        Preconditions.checkNotNull(candidates);
        for (Expr e : candidates) {
            BinaryPredicate normalizedJoinConjunct;
            if (!(e instanceof BinaryPredicate) || (normalizedJoinConjunct = SingleNodePlanner.getNormalizedEqPred(e, lhsTblRefIds, rhsTblRefIds, analyzer)) == null) continue;
            analyzer.markConjunctAssigned(e);
            result.add(normalizedJoinConjunct);
        }
        if (!result.isEmpty()) {
            return result;
        }
        HashSet<TupleId> lhsTblRefIdsHs = new HashSet<TupleId>(lhsTblRefIds);
        for (TupleId rhsId : rhsTblRefIds) {
            TableRef rhsTblRef = analyzer.getTableRef(rhsId);
            Preconditions.checkNotNull((Object)rhsTblRef);
            block2: for (SlotDescriptor slotDesc : rhsTblRef.getDesc().getSlots()) {
                SlotId rhsSid = slotDesc.getId();
                for (SlotId lhsSid : analyzer.getEquivClass(rhsSid)) {
                    if (!lhsTblRefIdsHs.contains(analyzer.getTupleId(lhsSid))) continue;
                    result.add(analyzer.createInferredEqPred(lhsSid, rhsSid));
                    continue block2;
                }
            }
        }
        return result;
    }

    public static BinaryPredicate getNormalizedEqPred(Expr expr, List<TupleId> lhsTids, List<TupleId> rhsTids, Analyzer analyzer) {
        if (!(expr instanceof BinaryPredicate)) {
            return null;
        }
        BinaryPredicate pred = (BinaryPredicate)expr;
        if (!pred.getOp().isEquivalence() && pred.getOp() != BinaryPredicate.Operator.NULL_MATCHING_EQ) {
            return null;
        }
        if (((Expr)pred.getChild(0)).isConstant() || ((Expr)pred.getChild(1)).isConstant()) {
            return null;
        }
        Expr lhsExpr = Expr.getFirstBoundChild(pred, lhsTids);
        Expr rhsExpr = Expr.getFirstBoundChild(pred, rhsTids);
        if (lhsExpr == null || rhsExpr == null || lhsExpr == rhsExpr) {
            return null;
        }
        BinaryPredicate result = new BinaryPredicate(pred.getOp(), lhsExpr, rhsExpr);
        result.analyzeNoThrow(analyzer);
        return result;
    }

    public static BinaryPredicate getNormalizedSingleRangePred(Expr expr, List<TupleId> lhsTids, List<TupleId> rhsTids, Analyzer analyzer) {
        if (!(expr instanceof BinaryPredicate)) {
            return null;
        }
        BinaryPredicate pred = (BinaryPredicate)expr;
        if (!pred.getOp().isSingleRange()) {
            return null;
        }
        if (((Expr)pred.getChild(0)).isConstant() || ((Expr)pred.getChild(1)).isConstant()) {
            return null;
        }
        Expr lhsExpr = Expr.getFirstBoundChild(pred, lhsTids);
        Expr rhsExpr = Expr.getFirstBoundChild(pred, rhsTids);
        if (lhsExpr == null || rhsExpr == null || lhsExpr == rhsExpr) {
            return null;
        }
        BinaryPredicate result = new BinaryPredicate(pred.getOp(), lhsExpr, rhsExpr);
        result.analyzeNoThrow(analyzer);
        return result;
    }

    private PlanNode createJoinNode(PlanNode outer, PlanNode inner, TableRef innerRef, Analyzer analyzer) throws ImpalaException {
        List<BinaryPredicate> eqJoinConjuncts = this.getHashLookupJoinConjuncts(outer.getTblRefIds(), inner.getTblRefIds(), analyzer);
        if (!innerRef.getJoinOp().isOuterJoin()) {
            analyzer.createEquivConjuncts(outer.getTblRefIds(), inner.getTblRefIds(), eqJoinConjuncts);
        }
        if (!eqJoinConjuncts.isEmpty() && innerRef.getJoinOp() == JoinOperator.CROSS_JOIN) {
            innerRef.setJoinOp(JoinOperator.INNER_JOIN);
        }
        ArrayList<Expr> otherJoinConjuncts = new ArrayList();
        if (innerRef.getJoinOp().isOuterJoin()) {
            otherJoinConjuncts = analyzer.getUnassignedOjConjuncts(innerRef);
        } else if (innerRef.getJoinOp().isSemiJoin()) {
            ArrayList tblRefIds = Lists.newArrayList(outer.getTblRefIds());
            tblRefIds.addAll(inner.getTblRefIds());
            otherJoinConjuncts = analyzer.getUnassignedConjuncts(tblRefIds, false);
            if (innerRef.getJoinOp().isNullAwareLeftAntiJoin()) {
                boolean hasNullMatchingEqOperator = false;
                Iterator<BinaryPredicate> it = eqJoinConjuncts.iterator();
                while (it.hasNext()) {
                    BinaryPredicate conjunct = it.next();
                    if (!conjunct.isNullMatchingEq()) {
                        otherJoinConjuncts.add(conjunct);
                        it.remove();
                        continue;
                    }
                    Preconditions.checkState((!hasNullMatchingEqOperator ? 1 : 0) != 0);
                    hasNullMatchingEqOperator = true;
                }
                Preconditions.checkState((boolean)hasNullMatchingEqOperator);
            }
        }
        PlanNode.removeZippingUnnestConjuncts(otherJoinConjuncts, analyzer);
        analyzer.markConjunctsAssigned(otherJoinConjuncts);
        if (analyzer.getQueryOptions().isEnable_distinct_semi_join_optimization() && innerRef.getJoinOp().isLeftSemiJoin()) {
            inner = this.addDistinctToJoinInput(inner, analyzer, eqJoinConjuncts, otherJoinConjuncts);
        }
        JoinNode result = null;
        Preconditions.checkState((!innerRef.getJoinOp().isNullAwareLeftAntiJoin() || !(inner instanceof SingularRowSrcNode) ? 1 : 0) != 0);
        if (eqJoinConjuncts.isEmpty() || inner instanceof SingularRowSrcNode) {
            otherJoinConjuncts.addAll(eqJoinConjuncts);
            result = new NestedLoopJoinNode(outer, inner, analyzer.isStraightJoin(), innerRef.getDistributionMode(), innerRef.getJoinOp(), otherJoinConjuncts);
        } else {
            result = new HashJoinNode(outer, inner, analyzer.isStraightJoin(), innerRef.getDistributionMode(), innerRef.getJoinOp(), eqJoinConjuncts, otherJoinConjuncts);
        }
        result.init(analyzer);
        return result;
    }

    private PlanNode addDistinctToJoinInput(PlanNode joinInput, Analyzer analyzer, List<BinaryPredicate> eqJoinConjuncts, List<Expr> otherJoinConjuncts) throws InternalException, AnalysisException {
        List<Expr> allJoinConjuncts = new ArrayList<Expr>();
        allJoinConjuncts.addAll(eqJoinConjuncts);
        allJoinConjuncts.addAll(otherJoinConjuncts);
        allJoinConjuncts = Expr.substituteList(allJoinConjuncts, joinInput.getOutputSmap(), analyzer, true);
        ArrayList<SlotId> allSlotIds = new ArrayList<SlotId>();
        Expr.getIds(allJoinConjuncts, null, allSlotIds);
        List<TupleId> joinInputTupleIds = joinInput.getTupleIds();
        ArrayList<Expr> distinctExprs = new ArrayList<Expr>();
        for (SlotDescriptor slot : analyzer.getSlotDescs(allSlotIds)) {
            if (!joinInputTupleIds.contains(slot.getParent().getId())) continue;
            distinctExprs.add(new SlotRef(slot));
        }
        if (distinctExprs.isEmpty()) {
            joinInput.setLimit(1L);
            return joinInput;
        }
        long numDistinct = AggregationNode.estimateNumGroups(distinctExprs, joinInput.getCardinality(), joinInput, analyzer);
        if (numDistinct < 0L || joinInput.getCardinality() < 0L) {
            LOG.trace("addDistinctToJoinInput():: missing stats, will not add agg");
            return joinInput;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("addDistinctToJoinInput(): numDistinct=" + numDistinct + " inputCardinality=" + joinInput.getCardinality());
        }
        if (joinInput.getCardinality() <= 1L || (double)numDistinct > 0.25 * (double)joinInput.getCardinality()) {
            return joinInput;
        }
        MultiAggregateInfo distinctAggInfo = new MultiAggregateInfo(distinctExprs, Collections.emptyList(), null);
        distinctAggInfo.analyze(analyzer);
        distinctAggInfo.materializeRequiredSlots(analyzer, new ExprSubstitutionMap());
        AggregationNode agg = new AggregationNode(this.ctx_.getNextNodeId(), joinInput, distinctAggInfo, MultiAggregateInfo.AggPhase.FIRST);
        agg.init(analyzer);
        agg.setTblRefIds(joinInput.getTblRefIds());
        agg.setOutputSmap(ExprSubstitutionMap.compose(agg.getOutputSmap(), distinctAggInfo.getOutputSmap(), analyzer));
        for (int i = 0; i < distinctExprs.size(); ++i) {
            Expr distinctExpr = (Expr)distinctExprs.get(i);
            SlotDescriptor outputSlot = distinctAggInfo.getAggClass(0).getResultTupleDesc().getSlots().get(i);
            analyzer.registerValueTransfer(((SlotRef)distinctExpr).getSlotId(), outputSlot.getId());
            this.valueTransferGraphNeedsUpdate_ = true;
        }
        return agg;
    }

    private PlanNode createTableRefNode(TableRef tblRef, MultiAggregateInfo aggInfo, Analyzer analyzer, List<CollectionTableRef> collectionRefsToZip) throws ImpalaException {
        PlanNode result = null;
        if (tblRef instanceof BaseTableRef) {
            result = this.createScanNode(tblRef, aggInfo, analyzer);
        } else if (tblRef instanceof CollectionTableRef) {
            if (tblRef.isRelative()) {
                Preconditions.checkState((boolean)this.ctx_.hasSubplan());
                result = collectionRefsToZip != null && collectionRefsToZip.size() > 0 ? new UnnestNode(this.ctx_.getNextNodeId(), this.ctx_.getSubplan(), collectionRefsToZip) : new UnnestNode(this.ctx_.getNextNodeId(), this.ctx_.getSubplan(), (CollectionTableRef)tblRef);
                result.init(analyzer);
            } else {
                result = this.createScanNode(tblRef, null, analyzer);
            }
        } else if (tblRef instanceof InlineViewRef) {
            result = this.createInlineViewPlan(analyzer, (InlineViewRef)tblRef);
        } else if (tblRef instanceof SingularRowSrcTableRef) {
            Preconditions.checkState((boolean)this.ctx_.hasSubplan());
            result = new SingularRowSrcNode(this.ctx_.getNextNodeId(), this.ctx_.getSubplan());
            result.init(analyzer);
        } else if (tblRef instanceof IcebergMetadataTableRef) {
            result = this.createScanNode(tblRef, aggInfo, analyzer);
        } else {
            throw new NotImplementedException("Planning not implemented for table ref class: " + tblRef.getClass());
        }
        return result;
    }

    private UnionNode createUnionPlan(Analyzer analyzer, UnionStmt unionStmt, List<SetOperationStmt.SetOperand> unionOperands, PlanNode unionDistinctPlan) throws ImpalaException {
        UnionNode unionNode = new UnionNode(this.ctx_.getNextNodeId(), unionStmt.getTupleId(), unionStmt.getSetOperationResultExprs(), this.ctx_.hasSubplan());
        for (SetOperationStmt.SetOperand op : unionOperands) {
            SelectStmt selectStmt;
            if (op.getAnalyzer().hasEmptyResultSet()) {
                this.unmarkCollectionSlots(op.getQueryStmt());
                continue;
            }
            QueryStmt queryStmt = op.getQueryStmt();
            if (queryStmt instanceof SelectStmt && (selectStmt = (SelectStmt)queryStmt).getTableRefs().isEmpty()) {
                unionNode.addConstExprList(selectStmt.getResultExprs());
                continue;
            }
            PlanNode opPlan = this.createQueryPlan(queryStmt, op.getAnalyzer(), false);
            if ((opPlan = this.addUnassignedConjuncts(analyzer, opPlan.getTupleIds(), opPlan)) instanceof EmptySetNode) continue;
            unionNode.addChild(opPlan, op.getQueryStmt().getResultExprs());
        }
        if (unionDistinctPlan != null) {
            Preconditions.checkState((boolean)unionStmt.hasUnionDistinctOps());
            Preconditions.checkState((boolean)(unionDistinctPlan instanceof AggregationNode));
            unionNode.addChild(unionDistinctPlan, unionStmt.getDistinctAggInfo().getGroupingExprs());
        }
        unionNode.init(analyzer);
        return unionNode;
    }

    private PlanNode createUnionPlan(UnionStmt unionStmt, Analyzer analyzer) throws ImpalaException {
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(unionStmt.getTupleId().asList(), false);
        if (!unionStmt.hasAnalyticExprs()) {
            for (SetOperationStmt.SetOperand op : unionStmt.getOperands()) {
                List<Expr> opConjuncts = Expr.substituteList(conjuncts, op.getSmap(), analyzer, false);
                op.getAnalyzer().registerConjuncts(opConjuncts);
            }
            analyzer.markConjunctsAssigned(conjuncts);
        } else {
            analyzer.materializeSlots(conjuncts);
        }
        unionStmt.materializeRequiredSlots(analyzer);
        PlanNode result = null;
        if (unionStmt.hasUnionDistinctOps()) {
            result = this.createUnionPlan(analyzer, unionStmt, unionStmt.getUnionDistinctOperands(), null);
            MultiAggregateInfo unionDistinctAggInfo = unionStmt.getDistinctAggInfo();
            unionDistinctAggInfo.setConjunctsToKeep(analyzer.getUnassignedConjuncts(result));
            result = new AggregationNode(this.ctx_.getNextNodeId(), result, unionDistinctAggInfo, MultiAggregateInfo.AggPhase.FIRST);
            result.init(analyzer);
        }
        if (unionStmt.hasUnionAllOps()) {
            result = this.createUnionPlan(analyzer, unionStmt, unionStmt.getUnionAllOperands(), result);
        }
        if (unionStmt.hasAnalyticExprs()) {
            result = this.addUnassignedConjuncts(analyzer, unionStmt.getTupleId().asList(), result);
        }
        return result;
    }

    @Override
    public DataSink createDataSink(ExprSubstitutionMap rootNodeSmap) {
        QueryStmt queryStmt = this.ctx_.getQueryStmt();
        queryStmt.substituteResultExprs(rootNodeSmap, this.ctx_.getRootAnalyzer());
        List<Expr> resultExprs = queryStmt.getResultExprs();
        return this.ctx_.getAnalysisResult().getQueryStmt().createDataSink(resultExprs);
    }

    @Override
    public List<String> getColLabels() {
        return this.ctx_.getQueryStmt().getColLabels();
    }

    @Override
    public TResultSetMetadata getTResultSetMetadata(ParsedStatement parsedStmt) {
        LOG.trace("create result set metadata");
        TResultSetMetadata metadata = new TResultSetMetadata();
        QueryStmt queryStmt = (QueryStmt)parsedStmt.getTopLevelNode();
        int colCnt = queryStmt.getColLabels().size();
        for (int i = 0; i < colCnt; ++i) {
            TColumn colDesc = new TColumn();
            colDesc.columnName = queryStmt.getColLabels().get(i);
            colDesc.columnType = queryStmt.getResultExprs().get(i).getType().toThrift();
            metadata.addToColumns(colDesc);
        }
        return metadata;
    }

    private static class SubplanRef {
        public final TableRef tblRef;
        public final List<TupleId> requiredTids;
        public final List<TupleId> requiredTblRefIds;

        public SubplanRef(TableRef tblRef, List<TupleId> requiredTids, List<TupleId> requiredTblRefIds) {
            Preconditions.checkState((tblRef.isRelative() || tblRef.isCorrelated() ? 1 : 0) != 0);
            this.tblRef = tblRef;
            this.requiredTids = requiredTids;
            this.requiredTblRefIds = requiredTblRefIds;
        }
    }
}

