/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(SelectNode.class);
    private double selectivity_ = -1.0;

    protected SelectNode(PlanNodeId id, PlanNode child, List<Expr> conjuncts) {
        super(id, "SELECT");
        this.addChild(child);
        this.conjuncts_.addAll(conjuncts);
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.SELECT_NODE;
    }

    @Override
    public void init(Analyzer analyzer) {
        analyzer.markConjunctsAssigned(this.conjuncts_);
        this.conjuncts_ = SelectNode.orderConjunctsByCost(this.conjuncts_);
        this.computeStats(analyzer);
        this.createDefaultSmap(analyzer);
    }

    public static PlanNode create(PlannerContext plannerCtx, Analyzer analyzer, PlanNode root, List<Expr> conjuncts) {
        SelectNode selectNode;
        if (root instanceof SelectNode && !root.hasLimit()) {
            selectNode = (SelectNode)root;
            for (Expr conjunct : conjuncts) {
                if (selectNode.conjuncts_.contains(conjunct)) continue;
                selectNode.conjuncts_.add(conjunct);
            }
        } else {
            selectNode = new SelectNode(plannerCtx.getNextNodeId(), root, conjuncts);
        }
        selectNode.init(analyzer);
        Preconditions.checkState((boolean)selectNode.hasValidStats());
        return selectNode;
    }

    public static SelectNode createFromCalcite(PlanNodeId id, PlanNode child, List<Expr> conjuncts) {
        return new SelectNode(id, child, conjuncts);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (((PlanNode)this.getChild((int)0)).cardinality_ == -1L) {
            this.cardinality_ = -1L;
        } else {
            this.cardinality_ = this.applyConjunctsSelectivity(((PlanNode)this.getChild((int)0)).cardinality_);
            Preconditions.checkState((this.cardinality_ >= 0L ? 1 : 0) != 0);
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (LOG.isTraceEnabled()) {
            LOG.trace("stats Select: cardinality=" + Long.toString(this.cardinality_));
        }
    }

    @Override
    protected double computeSelectivity() {
        if (this.selectivity_ == -1.0) {
            return super.computeSelectivity();
        }
        return this.selectivity_;
    }

    public void setSelectivity(double value) {
        this.selectivity_ = value;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_));
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal() && !this.conjuncts_.isEmpty()) {
            output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
        }
        return output.toString();
    }
}

