/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.util.MathUtil;

public class ScaledProcessingCost
extends ProcessingCost {
    private final ProcessingCost cost_;
    private final long multiplier_;

    protected ScaledProcessingCost(ProcessingCost cost, long multiplier) {
        Preconditions.checkArgument((boolean)cost.isValid(), (String)"ScaledProcessingCost: cost is invalid! %s", (Object)cost);
        Preconditions.checkArgument((multiplier >= 0L ? 1 : 0) != 0, (Object)"ScaledProcessingCost: multiplier must be non-negative!");
        this.cost_ = cost;
        this.multiplier_ = multiplier;
    }

    @Override
    public long getTotalCost() {
        return MathUtil.saturatingMultiply(this.cost_.getTotalCost(), this.multiplier_);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ProcessingCost clone() {
        return new ScaledProcessingCost(this.cost_, this.multiplier_);
    }

    @Override
    public String getExplainString(String detailPrefix, boolean fullExplain) {
        StringBuilder sb = new StringBuilder();
        sb.append(detailPrefix);
        sb.append("ScaledCost(");
        sb.append(this.multiplier_);
        sb.append("): ");
        sb.append(this.getDetails());
        if (fullExplain) {
            sb.append("\n");
            sb.append(this.cost_.getExplainString(detailPrefix + "  ", true));
        }
        return sb.toString();
    }
}

