/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.KuduScanNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.RuntimeFilterId;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.SingleNodePlanner;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TRuntimeFilterDesc;
import org.apache.impala.thrift.TRuntimeFilterMode;
import org.apache.impala.thrift.TRuntimeFilterTargetDesc;
import org.apache.impala.thrift.TRuntimeFilterType;
import org.apache.impala.util.BitUtil;
import org.apache.impala.util.TColumnValueUtil;
import org.apache.impala.util.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeFilterGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeFilterGenerator.class);
    private static final long MIN_BLOOM_FILTER_SIZE = 4096L;
    private static final long MAX_BLOOM_FILTER_SIZE = 0x20000000L;
    private static final long IN_LIST_FILTER_STRING_SET_MAX_TOTAL_LENGTH = 0x400000L;
    private static final Set<PrimitiveType> IN_LIST_FILTER_SUPPORTED_TYPES = new HashSet<PrimitiveType>(Arrays.asList(PrimitiveType.TINYINT, PrimitiveType.SMALLINT, PrimitiveType.INT, PrimitiveType.BIGINT, PrimitiveType.DATE, PrimitiveType.STRING, PrimitiveType.CHAR, PrimitiveType.VARCHAR));
    private final Map<TupleId, List<RuntimeFilter>> runtimeFiltersByTid_ = new HashMap<TupleId, List<RuntimeFilter>>();
    private final IdGenerator<RuntimeFilterId> filterIdGenerator = RuntimeFilterId.createGenerator();
    private final Map<PlanFragmentId, Integer> fragmentHeight_ = new HashMap<PlanFragmentId, Integer>();
    private final FilterSizeLimits filterSizeLimits_;

    private RuntimeFilterGenerator(TQueryOptions tQueryOptions) {
        this.filterSizeLimits_ = new FilterSizeLimits(tQueryOptions);
    }

    public static void generateRuntimeFilters(PlannerContext ctx, PlanNode plan) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)ctx.getQueryOptions());
        int maxNumBloomFilters = ctx.getQueryOptions().getMax_num_runtime_filters();
        Preconditions.checkState((maxNumBloomFilters >= 0 ? 1 : 0) != 0);
        RuntimeFilterGenerator filterGenerator = new RuntimeFilterGenerator(ctx.getQueryOptions());
        filterGenerator.generateFilters(ctx, plan);
        ArrayList filters = Lists.newArrayList(filterGenerator.getRuntimeFilters());
        if (filters.size() > maxNumBloomFilters) {
            Collections.sort(filters, new Comparator<RuntimeFilter>(){

                @Override
                public int compare(RuntimeFilter a, RuntimeFilter b) {
                    double aSelectivity = a.getSelectivity() == -1.0 ? Double.MAX_VALUE : a.getSelectivity();
                    double bSelectivity = b.getSelectivity() == -1.0 ? Double.MAX_VALUE : b.getSelectivity();
                    return Double.compare(aSelectivity, bSelectivity);
                }
            });
        }
        int numBloomFilters = 0;
        for (RuntimeFilter filter : filters) {
            JoinNode.DistributionMode distMode;
            if (filter.getType() == TRuntimeFilterType.BLOOM) {
                if (numBloomFilters >= maxNumBloomFilters) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Skip runtime filter (already reached max runtime filter count): " + filter.debugString());
                    continue;
                }
                ++numBloomFilters;
            }
            filter.setIsBroadcast((distMode = filter.src_.getDistributionMode()) == JoinNode.DistributionMode.BROADCAST);
            if (filter.getType() == TRuntimeFilterType.IN_LIST && distMode == JoinNode.DistributionMode.PARTITIONED) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Skip IN-list filter on partitioned join: {}", (Object)filter.debugString());
                continue;
            }
            filter.computeHasLocalTargets();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Runtime filter: " + filter.debugString());
            }
            filter.assignToPlanNodes();
        }
        RuntimeFilterGenerator.arrangeRuntimefiltersForParquet(plan);
    }

    public static void arrangeRuntimefiltersForParquet(PlanNode root) {
        if (root instanceof HdfsScanNode) {
            ((HdfsScanNode)root).arrangeRuntimefiltersForParquet();
        } else {
            for (PlanNode childNode : root.getChildren()) {
                RuntimeFilterGenerator.arrangeRuntimefiltersForParquet(childNode);
            }
        }
    }

    private void reduceFilters(Collection<RuntimeFilter> allFilters) {
        if (BackendConfig.INSTANCE.getMaxFilterErrorRateFromFullScan() < 0.0) {
            return;
        }
        boolean hasEliminatedFilter = true;
        double maxAllowedFpp = Math.max(BackendConfig.INSTANCE.getMaxFilterErrorRateFromFullScan(), this.filterSizeLimits_.targetFpp);
        List highFppFilters = allFilters.stream().filter(f -> f.getType() == TRuntimeFilterType.BLOOM && ((RuntimeFilter)f).level_ <= 1 && ((PlanNode)((RuntimeFilter)f).src_.getChild((int)1)).hasHardEstimates_ && ((RuntimeFilter)f).src_.fkPkEqJoinConjuncts_ != null && ((RuntimeFilter)f).est_fpp_ > maxAllowedFpp).collect(Collectors.toList());
        while (!highFppFilters.isEmpty() && hasEliminatedFilter) {
            hasEliminatedFilter = false;
            ArrayList<RuntimeFilter> skippedFilters = new ArrayList<RuntimeFilter>();
            BuildVisitor buildVisitor = new BuildVisitor();
            for (RuntimeFilter filter : highFppFilters) {
                buildVisitor.reset();
                ((PlanNode)filter.src_.getChild(1)).accept(buildVisitor);
                if (!buildVisitor.isEligibleForPrunning()) continue;
                hasEliminatedFilter = true;
                skippedFilters.add(filter);
                for (RuntimeFilter.RuntimeFilterTarget target : filter.getTargets()) {
                    TupleId targetTid = target.node.getTupleIds().get(0);
                    this.runtimeFiltersByTid_.get(targetTid).remove(filter);
                }
            }
            for (RuntimeFilter filter : skippedFilters) {
                highFppFilters.remove(filter);
                allFilters.remove(filter);
            }
        }
    }

    public List<RuntimeFilter> getRuntimeFilters() {
        HashSet<RuntimeFilter> resultSet = new HashSet<RuntimeFilter>();
        for (List<RuntimeFilter> filters : this.runtimeFiltersByTid_.values()) {
            resultSet.addAll(filters);
        }
        ArrayList resultList = Lists.newArrayList(resultSet);
        Collections.sort(resultList, new Comparator<RuntimeFilter>(){

            @Override
            public int compare(RuntimeFilter a, RuntimeFilter b) {
                return a.getFilterId().compareTo(b.getFilterId());
            }
        });
        this.reduceFilters(resultList);
        return resultList;
    }

    private void generateFilters(PlannerContext ctx, PlanNode root) {
        root.getFragment().postAccept(f -> {
            int height = 0;
            for (PlanFragment child : f.getChildren()) {
                height = Math.max(height, this.fragmentHeight_.get(child.getId()));
            }
            this.fragmentHeight_.put(((PlanFragment)f).getId(), height + 1);
        });
        this.generateFiltersRecursive(ctx, root);
    }

    private void generateFiltersRecursive(PlannerContext ctx, PlanNode root) {
        if (root instanceof HashJoinNode || root instanceof NestedLoopJoinNode) {
            JoinNode joinNode = (JoinNode)root;
            PlanNode buildHandNode = (PlanNode)root.getChild(1);
            while (buildHandNode.getFragment() == root.getFragment() && buildHandNode.hasChild(0)) {
                buildHandNode = (PlanNode)buildHandNode.getChild(0);
            }
            int level = this.fragmentHeight_.get(buildHandNode.getFragment().getId());
            ArrayList<Expr> joinConjuncts = new ArrayList<Expr>();
            if (!(joinNode.getJoinOp().isLeftOuterJoin() || joinNode.getJoinOp().isFullOuterJoin() || joinNode.getJoinOp().isAntiJoin())) {
                joinConjuncts.addAll(joinNode.getEqJoinConjuncts());
            }
            joinConjuncts.addAll(joinNode.getConjuncts());
            ArrayList<RuntimeFilter> filters = new ArrayList<RuntimeFilter>();
            Set<TRuntimeFilterType> enabledRuntimeFilterTypes = ctx.getQueryOptions().getEnabled_runtime_filter_types();
            for (TRuntimeFilterType filterType : TRuntimeFilterType.values()) {
                if (!enabledRuntimeFilterTypes.contains((Object)filterType)) continue;
                for (Expr conjunct : joinConjuncts) {
                    RuntimeFilter filter2;
                    RuntimeFilter filter = RuntimeFilter.create(this.filterIdGenerator, ctx.getRootAnalyzer(), conjunct, joinNode, filterType, this.filterSizeLimits_, false, level);
                    if (filter != null) {
                        this.registerRuntimeFilter(ctx, filter);
                        filters.add(filter);
                    }
                    if (filterType != TRuntimeFilterType.BLOOM || !Predicate.isEquivalencePredicate(conjunct) || !((Expr)conjunct.getChild(0)).getType().isTimestamp() || !((Expr)conjunct.getChild(1)).getType().isTimestamp() || (filter2 = RuntimeFilter.create(this.filterIdGenerator, ctx.getRootAnalyzer(), conjunct, joinNode, filterType, this.filterSizeLimits_, true, level)) == null) continue;
                    this.registerRuntimeFilter(ctx, filter2);
                    filters.add(filter2);
                }
            }
            this.generateFiltersRecursive(ctx, (PlanNode)root.getChild(0));
            for (RuntimeFilter runtimeFilter : filters) {
                this.finalizeRuntimeFilter(runtimeFilter);
            }
            this.generateFiltersRecursive(ctx, (PlanNode)root.getChild(1));
        } else if (root instanceof ScanNode) {
            this.assignRuntimeFilters(ctx, (ScanNode)root);
        } else {
            for (PlanNode childNode : root.getChildren()) {
                this.generateFiltersRecursive(ctx, childNode);
            }
        }
    }

    private void registerRuntimeFilter(PlannerContext ctx, RuntimeFilter filter) {
        Map<TupleId, List<SlotId>> targetSlotsByTid = filter.getTargetSlots();
        Preconditions.checkState((targetSlotsByTid != null && !targetSlotsByTid.isEmpty() ? 1 : 0) != 0);
        for (TupleId tupleId : targetSlotsByTid.keySet()) {
            this.registerRuntimeFilter(ctx, filter, tupleId);
        }
    }

    private void registerRuntimeFilter(PlannerContext ctx, RuntimeFilter filter, TupleId targetTid) {
        Preconditions.checkArgument((boolean)filter.getTargetSlots().containsKey(targetTid), (Object)"filter does not contain target slot!");
        Preconditions.checkArgument((!filter.isFinalized() ? 1 : 0) != 0, (Object)"filter must not finalized yet!");
        if (ctx.getQueryOptions().isSetRuntime_filter_ids_to_skip() && ctx.getQueryOptions().getRuntime_filter_ids_to_skip().contains(filter.getFilterId().asInt())) {
            return;
        }
        this.runtimeFiltersByTid_.computeIfAbsent(targetTid, t -> new ArrayList()).add(filter);
    }

    private void finalizeRuntimeFilter(RuntimeFilter runtimeFilter) {
        HashSet<TupleId> targetTupleIds = new HashSet<TupleId>();
        for (RuntimeFilter.RuntimeFilterTarget target : runtimeFilter.getTargets()) {
            targetTupleIds.addAll(target.node.getTupleIds());
        }
        for (TupleId tupleId : runtimeFilter.getTargetSlots().keySet()) {
            if (targetTupleIds.contains(tupleId)) continue;
            this.runtimeFiltersByTid_.get(tupleId).remove(runtimeFilter);
        }
        runtimeFilter.markFinalized();
    }

    public static boolean enableOverlapFilter(TQueryOptions queryOptions) {
        return queryOptions.parquet_read_statistics && (queryOptions.isMinmax_filter_sorted_columns() || queryOptions.getMinmax_filter_threshold() > 0.0 || queryOptions.isMinmax_filter_partition_columns());
    }

    private void assignRuntimeFilters(PlannerContext ctx, ScanNode scanNode) {
        if (!(scanNode instanceof HdfsScanNode) && !(scanNode instanceof KuduScanNode)) {
            return;
        }
        TupleId tid = scanNode.getTupleIds().get(0);
        if (!this.runtimeFiltersByTid_.containsKey(tid)) {
            return;
        }
        Analyzer analyzer = ctx.getRootAnalyzer();
        boolean disableRowRuntimeFiltering = ctx.getQueryOptions().isDisable_row_runtime_filtering();
        boolean enable_overlap_filter = RuntimeFilterGenerator.enableOverlapFilter(ctx.getQueryOptions());
        TRuntimeFilterMode runtimeFilterMode = ctx.getQueryOptions().getRuntime_filter_mode();
        Set<TRuntimeFilterType> enabledRuntimeFilterTypes = ctx.getQueryOptions().getEnabled_runtime_filter_types();
        if (scanNode instanceof HdfsScanNode && enable_overlap_filter) {
            ((HdfsScanNode)scanNode).initOverlapPredicate(analyzer);
        }
        for (RuntimeFilter filter : this.runtimeFiltersByTid_.get(tid)) {
            Column col;
            SlotRef slotRefInScan;
            SlotRef slotRef;
            Expr targetExpr;
            if (filter.isFinalized() || (targetExpr = this.computeTargetExpr(filter, tid, analyzer)) == null) continue;
            boolean isBoundByPartitionColumns = RuntimeFilterGenerator.isBoundByPartitionColumns(analyzer, targetExpr, scanNode);
            if (disableRowRuntimeFiltering && !isBoundByPartitionColumns) continue;
            boolean isColumnInDataFile = RuntimeFilterGenerator.isColumnInDataFile(scanNode.getTupleDesc().getTable(), isBoundByPartitionColumns);
            boolean isLocalTarget = RuntimeFilterGenerator.isLocalTarget(filter, scanNode);
            if (runtimeFilterMode == TRuntimeFilterMode.LOCAL && !isLocalTarget) continue;
            if (scanNode instanceof HdfsScanNode) {
                if (filter.isTimestampTruncation()) continue;
                if (filter.getType() == TRuntimeFilterType.MIN_MAX) {
                    Preconditions.checkState((boolean)enabledRuntimeFilterTypes.contains((Object)TRuntimeFilterType.MIN_MAX), (Object)"MIN_MAX filters should not be generated");
                    if (!enable_overlap_filter || !((HdfsScanNode)scanNode).tryToComputeOverlapPredicate(analyzer, filter, targetExpr, isBoundByPartitionColumns).booleanValue()) {
                        continue;
                    }
                } else if (filter.getType() == TRuntimeFilterType.IN_LIST && !((HdfsScanNode)scanNode).getFileFormats().contains((Object)HdfsFileFormat.ORC)) {
                    continue;
                }
            } else if (filter.getType() == TRuntimeFilterType.BLOOM) {
                Preconditions.checkState((boolean)enabledRuntimeFilterTypes.contains((Object)TRuntimeFilterType.BLOOM), (Object)"BLOOM filters should not be generated!");
                if (targetExpr.getType().isVarchar() || !(targetExpr instanceof SlotRef) || filter.getExprCompOp() == BinaryPredicate.Operator.NOT_DISTINCT || targetExpr.getType().isTimestamp() && !filter.isTimestampTruncation() || (slotRef = (SlotRef)targetExpr).getDesc().getColumn() == null) continue;
                if (filter.isTimestampTruncation() && analyzer.getQueryOptions().isConvert_kudu_utc_timestamps() && analyzer.getQueryOptions().isDisable_kudu_local_timestamp_bloom_filter()) {
                    LOG.info("Skipping runtime filter because kudu local timestamp bloom filter is disabled: " + filter.getSrcExpr().toSql());
                    continue;
                }
            } else if (filter.getType() == TRuntimeFilterType.MIN_MAX) {
                Preconditions.checkState((boolean)enabledRuntimeFilterTypes.contains((Object)TRuntimeFilterType.MIN_MAX), (Object)"MIN_MAX filters should not be generated!");
                if (targetExpr.getType().isVarchar() || (slotRef = targetExpr.unwrapSlotRef(true)) == null || slotRef.getDesc().getColumn() == null || targetExpr instanceof CastExpr && !targetExpr.getType().isIntegerType() || filter.getExprCompOp() == BinaryPredicate.Operator.NOT_DISTINCT) {
                    continue;
                }
            } else {
                Preconditions.checkState((filter.getType() == TRuntimeFilterType.IN_LIST ? 1 : 0) != 0);
                Preconditions.checkState((boolean)enabledRuntimeFilterTypes.contains((Object)TRuntimeFilterType.IN_LIST), (Object)"IN_LIST filters should not be generated!");
                continue;
            }
            TColumnValue lowValue = null;
            TColumnValue highValue = null;
            if (scanNode instanceof HdfsScanNode && (slotRefInScan = targetExpr.unwrapSlotRef(true)) != null && (col = slotRefInScan.getDesc().getColumn()) != null) {
                lowValue = col.getStats().getLowValue();
                highValue = col.getStats().getHighValue();
            }
            RuntimeFilter.RuntimeFilterTarget target = new RuntimeFilter.RuntimeFilterTarget(scanNode, targetExpr, isBoundByPartitionColumns, isColumnInDataFile, isLocalTarget, lowValue, highValue);
            filter.addTarget(target);
        }
        if (scanNode instanceof HdfsScanNode && enable_overlap_filter) {
            ((HdfsScanNode)scanNode).finalizeOverlapPredicate();
        }
    }

    private static boolean isLocalTarget(RuntimeFilter filter, ScanNode targetNode) {
        return targetNode.getFragment().getId().equals(filter.src_.getFragment().getId());
    }

    private static boolean isBoundByPartitionColumns(Analyzer analyzer, Expr targetExpr, ScanNode targetNode) {
        Preconditions.checkState((boolean)targetExpr.isBoundByTupleIds(targetNode.getTupleIds()));
        TupleDescriptor baseTblDesc = targetNode.getTupleDesc();
        FeTable tbl = baseTblDesc.getTable();
        if (tbl.getNumClusteringCols() == 0 && !(tbl instanceof FeIcebergTable)) {
            return false;
        }
        ArrayList<SlotId> sids = new ArrayList<SlotId>();
        targetExpr.getIds(null, sids);
        for (SlotId sid : sids) {
            Column col = analyzer.getSlotDesc(sid).getColumn();
            if (col == null) {
                return false;
            }
            if (tbl.isClusteringColumn(col) || tbl.isComputedPartitionColumn(col)) continue;
            return false;
        }
        return true;
    }

    private static boolean isColumnInDataFile(FeTable tbl, boolean isBoundByPartitionColumns) {
        if (!isBoundByPartitionColumns) {
            return true;
        }
        return tbl instanceof FeIcebergTable;
    }

    public static double getJoinNodeSelectivity(JoinNode joinNode) {
        if (joinNode.getCardinality() == -1L || ((PlanNode)joinNode.getChild(0)).getCardinality() == -1L || ((PlanNode)joinNode.getChild(0)).getCardinality() == 0L) {
            return -1.0;
        }
        return (double)joinNode.getCardinality() / (double)((PlanNode)joinNode.getChild(0)).getCardinality();
    }

    private Expr computeTargetExpr(RuntimeFilter filter, TupleId targetTid, Analyzer analyzer) {
        Expr targetExpr = filter.getOrigTargetExpr();
        if (!targetExpr.isBound(targetTid)) {
            Preconditions.checkState((boolean)filter.getTargetSlots().containsKey(targetTid));
            ExprSubstitutionMap smap = new ExprSubstitutionMap();
            ArrayList exprSlots = new ArrayList();
            targetExpr.collect(SlotRef.class, exprSlots);
            List<SlotId> sids = filter.getTargetSlots().get(targetTid);
            for (SlotRef slotRef : exprSlots) {
                boolean matched = false;
                for (SlotId sid : sids) {
                    if (!analyzer.hasValueTransfer(slotRef.getSlotId(), sid)) continue;
                    SlotRef newSlotRef = new SlotRef(analyzer.getSlotDesc(sid));
                    newSlotRef.analyzeNoThrow(analyzer);
                    smap.put(slotRef, newSlotRef);
                    matched = true;
                    break;
                }
                Preconditions.checkState((boolean)matched, (String)"No SlotId found for RuntimeFilter %s SlotRef %s", (Object)filter, (Object)slotRef);
            }
            try {
                targetExpr = targetExpr.substitute(smap, analyzer, false);
            }
            catch (Exception e) {
                return null;
            }
        }
        Type srcType = filter.getSrcExprType();
        if (!targetExpr.getType().equals(srcType)) {
            try {
                targetExpr = targetExpr.castTo(srcType);
            }
            catch (Exception e) {
                return null;
            }
        }
        return targetExpr;
    }

    private class BuildVisitor
    implements Visitor<PlanNode> {
        private boolean hasIncomingFilter_ = false;

        private BuildVisitor() {
        }

        @Override
        public void visit(PlanNode a) {
            if (!this.isEligibleForPrunning() || !(a instanceof ScanNode)) {
                return;
            }
            ScanNode scan = (ScanNode)a;
            TupleId sourceTid = scan.getTupleIds().get(0);
            List incomingFilters = (List)RuntimeFilterGenerator.this.runtimeFiltersByTid_.get(sourceTid);
            this.hasIncomingFilter_ |= incomingFilters != null && !incomingFilters.isEmpty();
        }

        public boolean isEligibleForPrunning() {
            return !this.hasIncomingFilter_;
        }

        public void reset() {
            this.hasIncomingFilter_ = false;
        }
    }

    public static class RuntimeFilter {
        private final RuntimeFilterId id_;
        private final JoinNode src_;
        private final Expr srcExpr_;
        private final Expr origTargetExpr_;
        private final BinaryPredicate.Operator exprCmpOp_;
        private final List<RuntimeFilterTarget> targets_ = new ArrayList<RuntimeFilterTarget>();
        private final Map<TupleId, List<SlotId>> targetSlotsByTid_;
        private boolean isBroadcastJoin_;
        private long ndvEstimate_ = -1L;
        private long buildKeyNdv_ = -1L;
        private long filterSizeBytes_ = 0L;
        private long originalFilterSizeBytes_ = 0L;
        private double est_fpp_ = 0.0;
        private boolean hasLocalTargets_ = false;
        private boolean hasRemoteTargets_ = false;
        private boolean finalized_ = false;
        private final TRuntimeFilterType type_;
        private boolean isTimestampTruncation_ = false;
        private int level_ = 1;

        private RuntimeFilter(RuntimeFilterId filterId, JoinNode filterSrcNode, Expr srcExpr, Expr origTargetExpr, BinaryPredicate.Operator exprCmpOp, Map<TupleId, List<SlotId>> targetSlots, TRuntimeFilterType type, FilterSizeLimits filterSizeLimits, boolean isTimestampTruncation, int level) {
            this.id_ = filterId;
            this.src_ = filterSrcNode;
            this.srcExpr_ = srcExpr;
            this.origTargetExpr_ = origTargetExpr;
            this.exprCmpOp_ = exprCmpOp;
            this.targetSlotsByTid_ = targetSlots;
            this.type_ = type;
            this.isTimestampTruncation_ = isTimestampTruncation;
            this.level_ = level;
            this.computeNdvEstimate();
            this.calculateFilterSize(filterSizeLimits);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RuntimeFilter)) {
                return false;
            }
            return ((RuntimeFilter)obj).id_.equals(this.id_);
        }

        public int hashCode() {
            return this.id_.hashCode();
        }

        public void markFinalized() {
            this.finalized_ = true;
        }

        public boolean isFinalized() {
            return this.finalized_;
        }

        public TRuntimeFilterDesc toThrift(ThriftSerializationCtx serialCtx, PlanNode cacheTarget) {
            TRuntimeFilterDesc tFilter = new TRuntimeFilterDesc();
            if (serialCtx.isTupleCache()) {
                tFilter.setFilter_id(0);
                tFilter.setTargets(new ArrayList<TRuntimeFilterTargetDesc>());
                tFilter.setPlanid_to_target_ndx(new HashMap<Integer, Integer>());
                for (RuntimeFilterTarget target : this.targets_) {
                    if (target.node != cacheTarget) continue;
                    tFilter.addToTargets(target.toThrift(serialCtx));
                    break;
                }
            } else {
                tFilter.setFilter_id(this.id_.asInt());
                tFilter.setSrc_node_id(this.src_.getId().asInt());
                tFilter.setNdv_estimate(this.ndvEstimate_);
                for (int i = 0; i < this.targets_.size(); ++i) {
                    RuntimeFilterTarget target;
                    target = this.targets_.get(i);
                    tFilter.addToTargets(target.toThrift(serialCtx));
                    tFilter.putToPlanid_to_target_ndx(target.node.getId().asInt(), i);
                }
            }
            tFilter.setSrc_expr(this.srcExpr_.treeToThrift(serialCtx));
            tFilter.setIs_broadcast_join(this.isBroadcastJoin_);
            tFilter.setHas_local_targets(this.hasLocalTargets_);
            tFilter.setHas_remote_targets(this.hasRemoteTargets_);
            tFilter.setCompareOp(this.exprCmpOp_.getThriftOp());
            boolean appliedOnPartitionColumns = true;
            for (RuntimeFilterTarget target : this.targets_) {
                appliedOnPartitionColumns &= target.isBoundByPartitionColumns;
            }
            tFilter.setApplied_on_partition_columns(appliedOnPartitionColumns);
            tFilter.setType(this.type_);
            tFilter.setFilter_size_bytes(this.filterSizeBytes_);
            return tFilter;
        }

        public static RuntimeFilter create(IdGenerator<RuntimeFilterId> idGen, Analyzer analyzer, Expr joinPredicate, JoinNode filterSrcNode, TRuntimeFilterType type, FilterSizeLimits filterSizeLimits, boolean isTimestampTruncation, int level) {
            Preconditions.checkNotNull(idGen);
            Preconditions.checkNotNull((Object)joinPredicate);
            Preconditions.checkNotNull((Object)filterSrcNode);
            if (!(type != TRuntimeFilterType.BLOOM && type != TRuntimeFilterType.IN_LIST || Predicate.isEquivalencePredicate(joinPredicate) && !(filterSrcNode instanceof NestedLoopJoinNode))) {
                return null;
            }
            if (type == TRuntimeFilterType.IN_LIST) {
                PrimitiveType rhsType;
                PrimitiveType lhsType = ((Expr)joinPredicate.getChild(0)).getType().getPrimitiveType();
                Preconditions.checkState((lhsType == (rhsType = ((Expr)joinPredicate.getChild(1)).getType().getPrimitiveType()) ? 1 : 0) != 0, (Object)"Unanalyzed equivalence pred!");
                if (!IN_LIST_FILTER_SUPPORTED_TYPES.contains((Object)lhsType)) {
                    return null;
                }
            }
            TreeNode normalizedJoinConjunct = null;
            if (type == TRuntimeFilterType.MIN_MAX) {
                if (filterSrcNode instanceof HashJoinNode) {
                    if (!Predicate.isSqlEquivalencePredicate(joinPredicate)) {
                        return null;
                    }
                    normalizedJoinConjunct = SingleNodePlanner.getNormalizedEqPred(joinPredicate, ((PlanNode)filterSrcNode.getChild(0)).getTupleIds(), ((PlanNode)filterSrcNode.getChild(1)).getTupleIds(), analyzer);
                } else if (filterSrcNode instanceof NestedLoopJoinNode) {
                    ScalarType decimalType;
                    if (Predicate.isSingleRangePredicate(joinPredicate)) {
                        PlanNode child1 = (PlanNode)filterSrcNode.getChild(1);
                        if (child1 instanceof ExchangeNode) {
                            child1 = (PlanNode)child1.getChild(0);
                        }
                        if (!(child1 instanceof AggregationNode) || !((AggregationNode)child1).isNonCorrelatedScalarSubquery()) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    normalizedJoinConjunct = SingleNodePlanner.getNormalizedSingleRangePred(joinPredicate, ((PlanNode)filterSrcNode.getChild(0)).getTupleIds(), ((PlanNode)filterSrcNode.getChild(1)).getTupleIds(), analyzer);
                    if (normalizedJoinConjunct != null && ((Expr)normalizedJoinConjunct.getChild(0)).getType().isDecimal() && (decimalType = (ScalarType)((Expr)normalizedJoinConjunct.getChild(0)).getType()).storageBytesForDecimal() == 16) {
                        return null;
                    }
                }
            } else {
                normalizedJoinConjunct = SingleNodePlanner.getNormalizedEqPred(joinPredicate, ((PlanNode)filterSrcNode.getChild(0)).getTupleIds(), ((PlanNode)filterSrcNode.getChild(1)).getTupleIds(), analyzer);
            }
            if (normalizedJoinConjunct == null) {
                return null;
            }
            Expr targetExpr = TupleIsNullPredicate.unwrapExpr(((Expr)normalizedJoinConjunct.getChild(0)).clone());
            Expr srcExpr = (Expr)normalizedJoinConjunct.getChild(1);
            if (isTimestampTruncation) {
                Preconditions.checkArgument((boolean)srcExpr.isAnalyzed());
                Preconditions.checkArgument((srcExpr.getType() == Type.TIMESTAMP ? 1 : 0) != 0);
                if (analyzer.getQueryOptions().isConvert_kudu_utc_timestamps()) {
                    ArrayList params = Lists.newArrayList((Object[])new Expr[]{srcExpr, new StringLiteral(analyzer.getQueryCtx().getLocal_time_zone())});
                    srcExpr = new FunctionCallExpr("to_utc_timestamp", (List<Expr>)params);
                }
                FunctionCallExpr toUnixTimeExpr = new FunctionCallExpr("utc_to_unix_micros", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{srcExpr}));
                try {
                    toUnixTimeExpr.analyze(analyzer);
                }
                catch (AnalysisException e) {
                    LOG.warn("Skipping runtime filter because analysis failed: " + toUnixTimeExpr.toSql(), (Throwable)e);
                    return null;
                }
                srcExpr = toUnixTimeExpr;
            }
            Map<TupleId, List<SlotId>> targetSlots = RuntimeFilter.getTargetSlots(analyzer, targetExpr);
            Preconditions.checkNotNull(targetSlots);
            if (targetSlots.isEmpty()) {
                return null;
            }
            if (filterSrcNode.getJoinOp().isLeftOuterJoin() || filterSrcNode.getJoinOp().isFullOuterJoin()) {
                try {
                    LiteralExpr nullSlotVal = analyzer.evalWithNullSlots(srcExpr);
                    if (nullSlotVal == null || !(nullSlotVal instanceof NullLiteral)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Skipping runtime filter because source expression returns non-null after null substitution: " + srcExpr.toSql());
                        }
                        return null;
                    }
                }
                catch (AnalysisException e) {
                    LOG.warn("Skipping runtime filter because analysis after null substitution failed: " + srcExpr.toSql(), (Throwable)e);
                    return null;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Generating runtime filter from predicate " + joinPredicate);
            }
            return new RuntimeFilter(idGen.getNextId(), filterSrcNode, srcExpr, targetExpr, ((BinaryPredicate)normalizedJoinConjunct).getOp(), targetSlots, type, filterSizeLimits, isTimestampTruncation, level);
        }

        private static Map<TupleId, List<SlotId>> getTargetSlots(Analyzer analyzer, Expr expr) {
            ArrayList<TupleId> tids = new ArrayList<TupleId>();
            ArrayList<SlotId> sids = new ArrayList<SlotId>();
            expr.getIds(tids, sids);
            if (analyzer.hasOuterJoinedValueTransferTarget(sids)) {
                IsNullPredicate isNotNullPred = new IsNullPredicate(expr, true);
                isNotNullPred.analyzeNoThrow(analyzer);
                try {
                    if (analyzer.isTrueWithNullSlots(isNotNullPred)) {
                        return Collections.emptyMap();
                    }
                }
                catch (InternalException e) {
                    LOG.warn("Skipping runtime filter because backend evaluation failed: " + isNotNullPred.toSql(), (Throwable)e);
                    return Collections.emptyMap();
                }
            }
            HashMap<TupleId, List<SlotId>> slotsByTid = new HashMap<TupleId, List<SlotId>>();
            for (SlotId slotId : sids) {
                Map<TupleId, List<SlotId>> currSlotsByTid = RuntimeFilter.getBaseTblEquivSlots(analyzer, slotId);
                if (currSlotsByTid.isEmpty()) {
                    return Collections.emptyMap();
                }
                if (slotsByTid.isEmpty()) {
                    slotsByTid.putAll(currSlotsByTid);
                    continue;
                }
                Iterator iter = slotsByTid.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    List<SlotId> slotIds = currSlotsByTid.get(entry.getKey());
                    if (slotIds == null) {
                        iter.remove();
                        continue;
                    }
                    ((List)entry.getValue()).addAll(slotIds);
                }
                if (!slotsByTid.isEmpty()) continue;
                return Collections.emptyMap();
            }
            return slotsByTid;
        }

        private static Map<TupleId, List<SlotId>> getBaseTblEquivSlots(Analyzer analyzer, SlotId srcSid) {
            HashMap<TupleId, List<SlotId>> slotsByTid = new HashMap<TupleId, List<SlotId>>();
            for (SlotId targetSid : analyzer.getValueTransferTargets(srcSid)) {
                TupleDescriptor tupleDesc = analyzer.getSlotDesc(targetSid).getParent();
                if (tupleDesc.getTable() == null) continue;
                ArrayList<SlotId> sids = (ArrayList<SlotId>)slotsByTid.get(tupleDesc.getId());
                if (sids == null) {
                    sids = new ArrayList<SlotId>();
                    slotsByTid.put(tupleDesc.getId(), sids);
                }
                sids.add(targetSid);
            }
            return slotsByTid;
        }

        public Expr getTargetExpr(PlanNodeId targetPlanNodeId) {
            for (RuntimeFilterTarget target : this.targets_) {
                if (target.node.getId() != targetPlanNodeId) continue;
                return target.expr;
            }
            return null;
        }

        public boolean isPartitionFilterAt(PlanNodeId targetPlanNodeId) {
            for (RuntimeFilterTarget target : this.targets_) {
                if (target.node.getId() != targetPlanNodeId) continue;
                return target.isBoundByPartitionColumns;
            }
            return false;
        }

        public List<RuntimeFilterTarget> getTargets() {
            return this.targets_;
        }

        public boolean hasTargets() {
            return !this.targets_.isEmpty();
        }

        public Expr getSrcExpr() {
            return this.srcExpr_;
        }

        public Expr getOrigTargetExpr() {
            return this.origTargetExpr_;
        }

        public Map<TupleId, List<SlotId>> getTargetSlots() {
            return this.targetSlotsByTid_;
        }

        public RuntimeFilterId getFilterId() {
            return this.id_;
        }

        public TRuntimeFilterType getType() {
            return this.type_;
        }

        public BinaryPredicate.Operator getExprCompOp() {
            return this.exprCmpOp_;
        }

        public long getFilterSize() {
            return this.filterSizeBytes_;
        }

        public boolean isTimestampTruncation() {
            return this.isTimestampTruncation_;
        }

        public boolean isBroadcast() {
            return this.isBroadcastJoin_;
        }

        public JoinNode getSrc() {
            return this.src_;
        }

        private long getBuildKeyNumRowStats() {
            long minNumRows = ((PlanNode)this.src_.getChild(1)).getCardinality();
            SlotRef buildSlotRef = this.srcExpr_.unwrapSlotRef(true);
            if (buildSlotRef == null || !buildSlotRef.hasDesc() || buildSlotRef.getDesc().getParent() == null || buildSlotRef.getDesc().getParent().getTable() == null || buildSlotRef.getDesc().getParent().getTable().getNumRows() <= -1L) {
                return minNumRows;
            }
            return buildSlotRef.getDesc().getParent().getTable().getNumRows();
        }

        public double getEstFpp() {
            return this.est_fpp_;
        }

        public Type getSrcExprType() {
            if (!this.isTimestampTruncation_) {
                return this.srcExpr_.getType();
            }
            return Type.TIMESTAMP;
        }

        public double getSelectivity() {
            return RuntimeFilterGenerator.getJoinNodeSelectivity(this.src_);
        }

        public void addTarget(RuntimeFilterTarget target) {
            this.targets_.add(target);
        }

        public void setIsBroadcast(boolean isBroadcast) {
            this.isBroadcastJoin_ = isBroadcast;
        }

        public void computeNdvEstimate() {
            this.ndvEstimate_ = ((PlanNode)this.src_.getChild(1)).getCardinality();
            this.buildKeyNdv_ = this.srcExpr_.getNumDistinctValues();
            if (this.buildKeyNdv_ >= 0L) {
                this.ndvEstimate_ = this.ndvEstimate_ >= 0L ? Math.min(this.buildKeyNdv_, this.ndvEstimate_) : this.buildKeyNdv_;
            }
        }

        public void computeHasLocalTargets() {
            Preconditions.checkNotNull((Object)this.src_.getFragment());
            Preconditions.checkState((boolean)this.hasTargets());
            for (RuntimeFilterTarget target : this.targets_) {
                Preconditions.checkNotNull((Object)target.node.getFragment());
                this.hasLocalTargets_ = this.hasLocalTargets_ || target.isLocalTarget;
                this.hasRemoteTargets_ = this.hasRemoteTargets_ || !target.isLocalTarget;
            }
        }

        private void calculateFilterSize(FilterSizeLimits filterSizeLimits) {
            if (this.type_ == TRuntimeFilterType.MIN_MAX) {
                return;
            }
            if (this.type_ == TRuntimeFilterType.IN_LIST) {
                Type colType = this.srcExpr_.getType();
                this.filterSizeBytes_ = colType.isStringType() ? 0x400000L : filterSizeLimits.inListFilterEntryLimit * (long)colType.getSlotSize();
                return;
            }
            if (this.ndvEstimate_ == -1L) {
                this.filterSizeBytes_ = filterSizeLimits.defaultVal;
                return;
            }
            double targetFpp = filterSizeLimits.targetFpp;
            int logFilterSize = FeSupport.GetMinLogSpaceForBloomFilter(this.ndvEstimate_, targetFpp);
            this.filterSizeBytes_ = this.originalFilterSizeBytes_ = 1L << logFilterSize;
            this.filterSizeBytes_ = Math.max(this.filterSizeBytes_, filterSizeLimits.minVal);
            this.filterSizeBytes_ = Math.min(this.filterSizeBytes_, filterSizeLimits.maxVal);
            int actualLogFilterSize = (int)(Math.log(this.filterSizeBytes_) / Math.log(2.0));
            this.est_fpp_ = FeSupport.GetFalsePositiveProbForBloomFilter(this.ndvEstimate_, actualLogFilterSize);
        }

        public void assignToPlanNodes() {
            Preconditions.checkState((boolean)this.hasTargets());
            this.src_.addRuntimeFilter(this);
            for (RuntimeFilterTarget target : this.targets_) {
                target.node.addRuntimeFilter(this);
            }
        }

        public boolean isHighlySelective() {
            return this.level_ <= 3 && (this.type_ != TRuntimeFilterType.BLOOM || this.est_fpp_ < 0.33);
        }

        public long reducedCardinalityForScanNode(ScanNode scanNode, long scanCardinality, Map<String, Double> partitionSelectivities) {
            boolean isEvalAtStorageLayer;
            Preconditions.checkState((boolean)this.isHighlySelective());
            SlotRef buildSlot = this.srcExpr_.unwrapSlotRef(true);
            PlanNodeId scanNodeId = scanNode.getId();
            Expr targetExpr = this.getTargetExpr(scanNodeId);
            SlotRef targetSlot = targetExpr.unwrapSlotRef(true);
            long scanColumnNdv = targetExpr.getNumDistinctValues();
            if (scanColumnNdv < 0L) {
                return -1L;
            }
            long buildKeyNdv = this.ndvEstimate_;
            long buildKeyCard = ((PlanNode)this.src_.getChild(1)).getCardinality();
            long buildKeyNumRows = this.getBuildKeyNumRowStats();
            long scanNumRows = scanNode.inputCardinality_;
            boolean isPartitionFilter = this.isPartitionFilterAt(scanNodeId);
            if (isPartitionFilter) {
                String colName;
                double currentSel;
                double thisPartSel = (double)buildKeyNdv / (double)scanColumnNdv;
                if (targetSlot != null && targetSlot.hasDesc() && targetSlot.getDesc().getColumn() != null && thisPartSel < (currentSel = partitionSelectivities.computeIfAbsent(colName = targetSlot.getDesc().getColumn().getName(), c -> 1.0).doubleValue())) {
                    partitionSelectivities.put(colName, thisPartSel);
                }
            }
            ArrayList<JoinNode.EqJoinConjunctScanSlots> eligibleFkPkJoinConjuncts = new ArrayList<JoinNode.EqJoinConjunctScanSlots>();
            boolean bl = isEvalAtStorageLayer = isPartitionFilter || scanNode instanceof KuduScanNode;
            if (isEvalAtStorageLayer && this.src_.fkPkEqJoinConjuncts_ != null && targetSlot != null && targetSlot.hasDesc() && buildSlot != null && buildSlot.hasDesc()) {
                for (JoinNode.EqJoinConjunctScanSlots fkPk : this.src_.fkPkEqJoinConjuncts_) {
                    if (!targetSlot.getSlotId().equals(fkPk.lhs_.getId()) || !buildSlot.getSlotId().equals(fkPk.rhs_.getId())) continue;
                    eligibleFkPkJoinConjuncts.add(fkPk);
                }
            }
            if (eligibleFkPkJoinConjuncts.isEmpty()) {
                return JoinNode.computeGenericJoinCardinality(scanColumnNdv, buildKeyNdv, scanNumRows, buildKeyNumRows, scanCardinality, buildKeyCard);
            }
            return JoinNode.getFkPkJoinCardinality(eligibleFkPkJoinConjuncts, scanCardinality, buildKeyCard);
        }

        public String debugString() {
            StringBuilder output = new StringBuilder();
            output.append("FilterID: " + this.id_).append(" Type: " + (Object)((Object)this.type_)).append(" Source: " + this.src_.getId()).append(" SrcExpr: " + this.getSrcExpr().debugString()).append(" Target(s): " + Joiner.on((String)", ").join(this.targets_)).append(" Selectivity: " + this.getSelectivity()).append(" Build key NDV: " + this.buildKeyNdv_).append(" NDV estimate " + this.ndvEstimate_).append(" Filter size (bytes): " + this.filterSizeBytes_).append(" Original filter size (bytes): " + this.originalFilterSizeBytes_).append(" Level: " + this.level_);
            if (this.type_ == TRuntimeFilterType.BLOOM) {
                output.append(" Est fpp: " + this.est_fpp_);
            }
            return output.toString();
        }

        private static class RuntimeFilterTarget {
            public ScanNode node;
            public Expr expr;
            public final boolean isBoundByPartitionColumns;
            public final boolean isLocalTarget;
            public final TColumnValue lowValue;
            public final TColumnValue highValue;
            public final boolean isColumnInDataFile;

            public RuntimeFilterTarget(ScanNode targetNode, Expr targetExpr, boolean isBoundByPartitionColumns, boolean isColumnInDataFile, boolean isLocalTarget, TColumnValue lowValue, TColumnValue highValue) {
                Preconditions.checkState((boolean)targetExpr.isBoundByTupleIds(targetNode.getTupleIds()));
                this.node = targetNode;
                this.expr = targetExpr;
                this.isBoundByPartitionColumns = isBoundByPartitionColumns;
                this.isColumnInDataFile = isColumnInDataFile;
                this.isLocalTarget = isLocalTarget;
                this.lowValue = lowValue;
                this.highValue = highValue;
            }

            public TRuntimeFilterTargetDesc toThrift(ThriftSerializationCtx serialCtx) {
                Column col;
                SlotRef slotRefInScan;
                TRuntimeFilterTargetDesc tFilterTarget = new TRuntimeFilterTargetDesc();
                if (serialCtx.isTupleCache()) {
                    tFilterTarget.setNode_id(0);
                } else {
                    tFilterTarget.setNode_id(this.node.getId().asInt());
                }
                tFilterTarget.setTarget_expr(this.expr.treeToThrift(serialCtx));
                ArrayList<SlotId> sids = new ArrayList<SlotId>();
                this.expr.getIds(null, sids);
                ArrayList tSlotIds = Lists.newArrayListWithCapacity((int)sids.size());
                for (SlotId sid : sids) {
                    tSlotIds.add(serialCtx.translateSlotId(sid).asInt());
                }
                tFilterTarget.setTarget_expr_slotids(tSlotIds);
                tFilterTarget.setIs_bound_by_partition_columns(this.isBoundByPartitionColumns);
                tFilterTarget.setIs_local_target(this.isLocalTarget);
                if (this.node instanceof HdfsScanNode) {
                    tFilterTarget.setIs_column_in_data_file(this.isColumnInDataFile);
                }
                if (this.node instanceof KuduScanNode) {
                    SlotRef slotRef = this.expr.unwrapSlotRef(true);
                    KuduColumn col2 = (KuduColumn)slotRef.getDesc().getColumn();
                    tFilterTarget.setKudu_col_name(col2.getKuduName());
                    tFilterTarget.setKudu_col_type(col2.getType().toThrift());
                }
                tFilterTarget.setLow_value(this.lowValue);
                tFilterTarget.setHigh_value(this.highValue);
                boolean minMaxValuePresent = false;
                if (this.node instanceof HdfsScanNode && (slotRefInScan = this.expr.unwrapSlotRef(true)) != null && (col = slotRefInScan.getDesc().getColumn()) != null) {
                    Type col_type = col.getType();
                    minMaxValuePresent = TColumnValueUtil.isFieldSet(col_type, this.lowValue) && TColumnValueUtil.isFieldSet(col_type, this.highValue);
                }
                tFilterTarget.setIs_min_max_value_present(minMaxValuePresent);
                return tFilterTarget;
            }

            public String toString() {
                StringBuilder output = new StringBuilder();
                return output.append("Target Id: " + this.node.getId()).append(" Target expr: " + this.expr.debugString()).append(" Partition columns: " + this.isBoundByPartitionColumns).append(" Is column stored in data files: " + this.isColumnInDataFile).append(" Is local: " + this.isLocalTarget).append(" lowValue: " + (this.lowValue != null ? this.lowValue.toString() : Integer.valueOf(-1))).append(" highValue: " + (this.highValue != null ? this.highValue.toString() : Integer.valueOf(-1))).toString();
            }
        }
    }

    private class FilterSizeLimits {
        public final long maxVal;
        public final long minVal;
        public final long defaultVal;
        public final double targetFpp;
        public final long inListFilterEntryLimit;

        public FilterSizeLimits(TQueryOptions tQueryOptions) {
            long maxLimit = tQueryOptions.getRuntime_filter_max_size();
            long minBufferSize = BackendConfig.INSTANCE.getMinBufferSize();
            this.maxVal = BitUtil.roundUpToPowerOf2(Math.max(maxLimit, minBufferSize));
            Preconditions.checkState((this.maxVal <= 0x20000000L ? 1 : 0) != 0);
            long minLimit = tQueryOptions.getRuntime_filter_min_size();
            minLimit = Math.max(minLimit, minBufferSize);
            this.minVal = BitUtil.roundUpToPowerOf2(Math.min(minLimit, this.maxVal));
            Preconditions.checkState((this.minVal >= 4096L ? 1 : 0) != 0);
            long defaultValue = tQueryOptions.getRuntime_bloom_filter_size();
            defaultValue = Math.max(defaultValue, this.minVal);
            this.defaultVal = BitUtil.roundUpToPowerOf2(Math.min(defaultValue, this.maxVal));
            this.targetFpp = tQueryOptions.isSetRuntime_filter_error_rate() ? tQueryOptions.getRuntime_filter_error_rate() : BackendConfig.INSTANCE.getMaxFilterErrorRate();
            this.inListFilterEntryLimit = tQueryOptions.getRuntime_in_list_filter_entry_limit();
        }
    }
}

