/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.util.MathUtil;

public class ResourceProfileBuilder {
    private long memEstimateBytes_ = -1L;
    private long minMemReservationBytes_ = 0L;
    private long maxMemReservationBytes_ = 0L;
    private long spillableBufferBytes_ = -1L;
    private long maxRowBufferBytes_ = -1L;
    private double scale_ = 0.0;
    private long maxMemEstimateBytesAfterScaling_ = -1L;
    private long threadReservation_ = 0L;

    public ResourceProfileBuilder setMemEstimateBytes(long memEstimateBytes) {
        this.memEstimateBytes_ = memEstimateBytes;
        return this;
    }

    public ResourceProfileBuilder setMinMemReservationBytes(long minMemReservationBytes) {
        this.minMemReservationBytes_ = minMemReservationBytes;
        if (this.maxMemReservationBytes_ == 0L) {
            this.maxMemReservationBytes_ = Long.MAX_VALUE;
        }
        return this;
    }

    public ResourceProfileBuilder setMaxMemReservationBytes(long maxMemReservationBytes) {
        this.maxMemReservationBytes_ = maxMemReservationBytes;
        return this;
    }

    public ResourceProfileBuilder setSpillableBufferBytes(long spillableBufferBytes) {
        this.spillableBufferBytes_ = spillableBufferBytes;
        return this;
    }

    public ResourceProfileBuilder setMaxRowBufferBytes(long maxRowBufferBytes) {
        this.maxRowBufferBytes_ = maxRowBufferBytes;
        return this;
    }

    public ResourceProfileBuilder setThreadReservation(long threadReservation) {
        this.threadReservation_ = threadReservation;
        return this;
    }

    public ResourceProfileBuilder setMemEstimateScale(double scale, long maxMemBound) {
        Preconditions.checkArgument((scale > 0.0 && scale <= 1.0 ? 1 : 0) != 0, (String)"invalid scale %s", (Object)scale);
        Preconditions.checkArgument((maxMemBound > 0L ? 1 : 0) != 0, (String)"invalid maxMemBound %s", (long)maxMemBound);
        this.scale_ = scale;
        this.maxMemEstimateBytesAfterScaling_ = maxMemBound;
        return this;
    }

    ResourceProfile build() {
        Preconditions.checkState((this.memEstimateBytes_ >= 0L ? 1 : 0) != 0, (Object)"Mem estimate must be set");
        if (this.scale_ > 0.0 && this.maxMemEstimateBytesAfterScaling_ > 0L) {
            long scaleBasedMemEstimate = this.minMemReservationBytes_;
            if (this.minMemReservationBytes_ <= this.maxMemEstimateBytesAfterScaling_) {
                scaleBasedMemEstimate = MathUtil.saturatingAdd(this.minMemReservationBytes_, (long)((double)(this.maxMemEstimateBytesAfterScaling_ - this.minMemReservationBytes_) * this.scale_));
                this.memEstimateBytes_ = Math.min(this.memEstimateBytes_, scaleBasedMemEstimate);
            }
            if (this.maxMemReservationBytes_ > 0L) {
                this.memEstimateBytes_ = Math.min(this.memEstimateBytes_, this.maxMemReservationBytes_);
            }
        }
        return new ResourceProfile(true, this.memEstimateBytes_, this.minMemReservationBytes_, this.maxMemReservationBytes_, this.spillableBufferBytes_, this.maxRowBufferBytes_, this.threadReservation_);
    }
}

