/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.thrift.TBackendResourceProfile;
import org.apache.impala.util.MathUtil;

public class ResourceProfile {
    private final boolean isValid_;
    private final long memEstimateBytes_;
    private final long minMemReservationBytes_;
    private final long maxMemReservationBytes_;
    private final long spillableBufferBytes_;
    private final long maxRowBufferBytes_;
    private final long threadReservation_;

    private ResourceProfile(boolean isValid, long memEstimateBytes, long minMemReservationBytes, long maxMemReservationBytes, long spillableBufferBytes, long maxRowBufferBytes, long threadReservation, boolean isStrictMaxMemory) {
        Preconditions.checkArgument((spillableBufferBytes == -1L || maxRowBufferBytes != -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((spillableBufferBytes == -1L || LongMath.isPowerOfTwo((long)spillableBufferBytes) ? 1 : 0) != 0);
        Preconditions.checkArgument((maxRowBufferBytes == -1L || LongMath.isPowerOfTwo((long)maxRowBufferBytes) ? 1 : 0) != 0);
        Preconditions.checkArgument((!isValid || threadReservation >= 0L ? 1 : 0) != 0, (Object)threadReservation);
        Preconditions.checkState((minMemReservationBytes <= maxMemReservationBytes ? 1 : 0) != 0, (String)"minMemReservationBytes (%s) is greater than maxMemReservationBytes (%s)!", (long)minMemReservationBytes, (long)maxMemReservationBytes);
        if (maxMemReservationBytes > 0L && isStrictMaxMemory) {
            Preconditions.checkState((memEstimateBytes <= maxMemReservationBytes ? 1 : 0) != 0, (String)"memEstimateBytes (%s) is greater than maxMemReservationBytes (%s)!", (long)memEstimateBytes, (long)maxMemReservationBytes);
        }
        this.isValid_ = isValid;
        this.memEstimateBytes_ = minMemReservationBytes != -1L ? Math.max(memEstimateBytes, minMemReservationBytes) : memEstimateBytes;
        this.minMemReservationBytes_ = minMemReservationBytes;
        this.maxMemReservationBytes_ = maxMemReservationBytes;
        this.spillableBufferBytes_ = spillableBufferBytes;
        this.maxRowBufferBytes_ = maxRowBufferBytes;
        this.threadReservation_ = threadReservation;
    }

    public ResourceProfile(boolean isValid, long memEstimateBytes, long minMemReservationBytes, long maxMemReservationBytes, long spillableBufferBytes, long maxRowBufferBytes, long threadReservation) {
        this(isValid, memEstimateBytes, minMemReservationBytes, maxMemReservationBytes, spillableBufferBytes, maxRowBufferBytes, threadReservation, true);
    }

    public static ResourceProfile noReservation(long memEstimateBytes) {
        return new ResourceProfile(true, memEstimateBytes, 0L, 0L, -1L, -1L, 0L, false);
    }

    public static ResourceProfile invalid() {
        return new ResourceProfile(false, -1L, -1L, -1L, -1L, -1L, -1L, false);
    }

    public boolean isValid() {
        return this.isValid_;
    }

    public long getMemEstimateBytes() {
        return this.memEstimateBytes_;
    }

    public long getMinMemReservationBytes() {
        return this.minMemReservationBytes_;
    }

    public long getMaxMemReservationBytes() {
        return this.maxMemReservationBytes_;
    }

    public long getSpillableBufferBytes() {
        return this.spillableBufferBytes_;
    }

    public long getMaxRowBufferBytes() {
        return this.maxRowBufferBytes_;
    }

    public long getThreadReservation() {
        return this.threadReservation_;
    }

    public boolean isNonZero() {
        Preconditions.checkState((boolean)this.isValid_);
        return this.memEstimateBytes_ > 0L || this.minMemReservationBytes_ > 0L || this.threadReservation_ > 0L;
    }

    public String getExplainString() {
        StringBuilder output = new StringBuilder();
        output.append("mem-estimate=");
        output.append(this.isValid_ ? PrintUtils.printBytes(this.memEstimateBytes_) : "invalid");
        output.append(" mem-reservation=");
        output.append(this.isValid_ ? PrintUtils.printBytes(this.minMemReservationBytes_) : "invalid");
        if (this.isValid_ && this.spillableBufferBytes_ != -1L) {
            output.append(" spill-buffer=");
            output.append(PrintUtils.printBytes(this.spillableBufferBytes_));
        }
        output.append(" thread-reservation=");
        output.append(this.isValid_ ? Long.valueOf(this.threadReservation_) : "invalid");
        return output.toString();
    }

    public ResourceProfile max(ResourceProfile other) {
        if (!this.isValid()) {
            return other;
        }
        if (!other.isValid()) {
            return this;
        }
        return new ResourceProfile(true, Math.max(this.getMemEstimateBytes(), other.getMemEstimateBytes()), Math.max(this.getMinMemReservationBytes(), other.getMinMemReservationBytes()), Math.max(this.getMaxMemReservationBytes(), other.getMaxMemReservationBytes()), -1L, -1L, Math.max(this.getThreadReservation(), other.getThreadReservation()), false);
    }

    public ResourceProfile sum(ResourceProfile other) {
        if (!this.isValid()) {
            return other;
        }
        if (!other.isValid()) {
            return this;
        }
        return new ResourceProfile(true, MathUtil.saturatingAdd(this.getMemEstimateBytes(), other.getMemEstimateBytes()), MathUtil.saturatingAdd(this.getMinMemReservationBytes(), other.getMinMemReservationBytes()), MathUtil.saturatingAdd(this.getMaxMemReservationBytes(), other.getMaxMemReservationBytes()), -1L, -1L, MathUtil.saturatingAdd(this.getThreadReservation(), other.getThreadReservation()), false);
    }

    public ResourceProfile combine(ResourceProfile other) {
        if (!this.isValid()) {
            return other;
        }
        if (!other.isValid()) {
            return this;
        }
        return new ResourceProfile(true, MathUtil.saturatingAdd(this.getMemEstimateBytes(), other.getMemEstimateBytes()), MathUtil.saturatingAdd(this.getMinMemReservationBytes(), other.getMinMemReservationBytes()), MathUtil.saturatingAdd(this.getMaxMemReservationBytes(), other.getMaxMemReservationBytes()), Math.max(this.getSpillableBufferBytes(), other.getSpillableBufferBytes()), Math.max(this.getMaxRowBufferBytes(), other.getMaxRowBufferBytes()), MathUtil.saturatingAdd(this.getThreadReservation(), other.getThreadReservation()), false);
    }

    public ResourceProfile multiply(int factor) {
        if (!this.isValid()) {
            return this;
        }
        return new ResourceProfile(true, MathUtil.saturatingMultiply(this.memEstimateBytes_, factor), MathUtil.saturatingMultiply(this.minMemReservationBytes_, factor), MathUtil.saturatingMultiply(this.maxMemReservationBytes_, factor), -1L, -1L, MathUtil.saturatingMultiply(this.threadReservation_, factor), false);
    }

    public TBackendResourceProfile toThrift() {
        TBackendResourceProfile result = new TBackendResourceProfile();
        result.setMin_reservation(this.minMemReservationBytes_);
        result.setMax_reservation(this.maxMemReservationBytes_);
        if (this.spillableBufferBytes_ != -1L) {
            result.setSpillable_buffer_size(this.spillableBufferBytes_);
        }
        if (this.maxRowBufferBytes_ != -1L) {
            result.setMax_row_buffer_size(this.maxRowBufferBytes_);
        }
        return result;
    }
}

