/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanRootSink;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.ExprUtil;
import org.apache.log4j.Logger;

public class PlanRootSink
extends DataSink {
    private static final Logger LOG = Logger.getLogger(PlanRootSink.class);
    private static final long DEFAULT_RESULT_SPOOLING_ESTIMATED_MEMORY = 0xA00000L;
    private final List<Expr> outputExprs_;

    public PlanRootSink(List<Expr> outputExprs) {
        Preconditions.checkState((outputExprs != null ? 1 : 0) != 0);
        this.outputExprs_ = outputExprs;
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        output.append(String.format("%sPLAN-ROOT SINK\n", prefix));
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix + "output exprs: ").append(Expr.getExplainString(this.outputExprs_, explainLevel) + "\n");
        }
    }

    @Override
    protected String getLabel() {
        return "ROOT";
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        if (queryOptions.isSpool_query_results() && queryOptions.getScratch_limit() != 0L && !BackendConfig.INSTANCE.getScratchDirs().isEmpty()) {
            long outputCardinality = Math.max(0L, this.fragment_.getPlanRoot().getCardinality());
            this.processingCost_ = ProcessingCost.basicCost(this.getLabel(), outputCardinality, ExprUtil.computeExprsTotalCost(this.outputExprs_));
        } else {
            this.processingCost_ = ProcessingCost.zero();
        }
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        if (queryOptions.isSpool_query_results()) {
            long memEstimateBytes;
            PlanNode inputNode;
            long scratchLimit = queryOptions.getScratch_limit();
            String scratchDirs = BackendConfig.INSTANCE.getScratchDirs();
            if (scratchLimit == 0L || scratchDirs.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Result spooling is disabled due to unavailability of scratch space.");
                }
                queryOptions.setSpool_query_results(false);
                this.resourceProfile_ = ResourceProfile.noReservation(0L);
                return;
            }
            long maxSpoolingMem = queryOptions.getMax_result_spooling_mem();
            if (maxSpoolingMem <= 0L) {
                TQueryOptions defaults = new TQueryOptions();
                maxSpoolingMem = defaults.getMax_result_spooling_mem();
                queryOptions.setMax_result_spooling_mem(maxSpoolingMem);
            }
            long bufferSize = queryOptions.getDefault_spillable_buffer_size();
            long maxRowBufferSize = PlanNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
            long minMemReservationBytes = 2L * maxRowBufferSize;
            long maxMemReservationBytes = Math.max(maxSpoolingMem, minMemReservationBytes);
            if (scratchLimit > -1L) {
                long maxAllowedScratchLimit = scratchLimit - maxRowBufferSize;
                if (maxAllowedScratchLimit < minMemReservationBytes) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Result spooling is disabled due to low scratch_limit (" + scratchLimit + "). Try increasing scratch_limit to >= " + (minMemReservationBytes + maxRowBufferSize) + " to enable result spooling."));
                    }
                    queryOptions.setSpool_query_results(false);
                    this.resourceProfile_ = ResourceProfile.noReservation(0L);
                    return;
                }
                if (maxAllowedScratchLimit < maxMemReservationBytes) {
                    maxMemReservationBytes = maxAllowedScratchLimit;
                    queryOptions.setMax_result_spooling_mem(maxAllowedScratchLimit);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("max_result_spooling_mem is lowered to " + maxMemReservationBytes + " to fit scratch_limit (" + scratchLimit + ")."));
                    }
                }
                if (maxAllowedScratchLimit < queryOptions.getMax_spilled_result_spooling_mem()) {
                    queryOptions.setMax_spilled_result_spooling_mem(maxAllowedScratchLimit);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("max_spilled_result_spooling_mem is lowered to " + maxAllowedScratchLimit + " to fit scratch_limit (" + scratchLimit + ")."));
                    }
                }
            }
            if ((inputNode = this.fragment_.getPlanRoot()).getCardinality() == -1L || inputNode.getAvgRowSize() == -1.0f) {
                memEstimateBytes = 0xA00000L;
            } else {
                long inputCardinality = Math.max(1L, inputNode.getCardinality());
                memEstimateBytes = (long)Math.ceil((float)inputCardinality * inputNode.getAvgRowSize());
            }
            memEstimateBytes = Math.min(memEstimateBytes, maxMemReservationBytes);
            this.resourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(memEstimateBytes).setMinMemReservationBytes(minMemReservationBytes).setMaxMemReservationBytes(maxMemReservationBytes).setMaxRowBufferBytes(maxRowBufferSize).setSpillableBufferBytes(bufferSize).build();
        } else {
            this.resourceProfile_ = ResourceProfile.noReservation(0L);
        }
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        TPlanRootSink tPlanRootSink = new TPlanRootSink(this.resourceProfile_.toThrift());
        tsink.setPlan_root_sink(tPlanRootSink);
        tsink.output_exprs = Expr.treesToThrift(this.outputExprs_);
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.PLAN_ROOT_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        exprs.addAll(this.outputExprs_);
    }

    @Override
    public void computeRowConsumptionAndProductionToCost() {
        super.computeRowConsumptionAndProductionToCost();
        this.fragment_.setFixedInstanceCount(this.fragment_.getNumInstances());
    }
}

