/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.AggregationNode;
import org.apache.impala.planner.CohortId;
import org.apache.impala.planner.CoreCount;
import org.apache.impala.planner.CostingSegment;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.DataStreamSink;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HashJoinNode;
import org.apache.impala.planner.HdfsTableSink;
import org.apache.impala.planner.JoinBuildSink;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanRootSink;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.RuntimeFilterId;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.planner.SpillableOperator;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPartitionType;
import org.apache.impala.thrift.TPlanFragment;
import org.apache.impala.thrift.TPlanFragmentTree;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanFragment
extends TreeNode<PlanFragment> {
    private static final Logger LOG = LoggerFactory.getLogger(PlanFragment.class);
    private final PlanFragmentId fragmentId_;
    private PlanId planId_;
    private CohortId cohortId_;
    private final boolean coordinatorOnly_;
    private PlanNode planRoot_;
    private PlanNode destNode_;
    private DataSink sink_;
    private DataPartition dataPartition_;
    private DataPartition outputPartition_;
    private ResourceProfile perInstanceResourceProfile_ = ResourceProfile.invalid();
    private ResourceProfile perBackendResourceProfile_ = ResourceProfile.invalid();
    private long perInstanceInitialMemReservationTotalClaims_ = -1L;
    private long perBackendInitialMemReservationTotalClaims_ = -1L;
    private long producedRuntimeFiltersMemReservationBytes_ = 0L;
    private long consumedGlobalRuntimeFiltersMemReservationBytes_ = 0L;
    private CostingSegment rootSegment_;
    private int maxParallelism_ = -1;
    private int adjustedInstanceCount_ = -1;
    private boolean isFixedParallelism_ = false;
    private int originalInstanceCount_ = -1;
    private int thisTreeCpuCore_ = -1;
    private int subtreeCpuCore_ = -1;
    private boolean isDominantFragment_ = false;

    public long getProducedRuntimeFiltersMemReservationBytes() {
        return this.producedRuntimeFiltersMemReservationBytes_;
    }

    public PlanFragment(PlanFragmentId id, PlanNode root, DataPartition partition, boolean coordinatorOnly) {
        this.fragmentId_ = id;
        this.planRoot_ = root;
        this.dataPartition_ = partition;
        this.outputPartition_ = DataPartition.UNPARTITIONED;
        this.setFragmentInPlanTree(this.planRoot_);
        this.coordinatorOnly_ = coordinatorOnly;
        Preconditions.checkState((!coordinatorOnly || this.dataPartition_.equals(DataPartition.UNPARTITIONED) ? 1 : 0) != 0);
    }

    public PlanFragment(PlanFragmentId id, PlanNode root, DataPartition partition) {
        this(id, root, partition, false);
    }

    public void setFragmentInPlanTree(PlanNode node) {
        if (node == null) {
            return;
        }
        node.setFragment(this);
        if (node instanceof ExchangeNode) {
            return;
        }
        for (PlanNode child : node.getChildren()) {
            this.setFragmentInPlanTree(child);
        }
    }

    public List<PlanNode> collectPlanNodes() {
        ArrayList<PlanNode> nodes = new ArrayList<PlanNode>();
        this.collectPlanNodesHelper(this.planRoot_, (Predicate<? super PlanNode>)Predicates.alwaysTrue(), nodes);
        return nodes;
    }

    public <T extends PlanNode> void collectPlanNodes(Predicate<? super PlanNode> predicate, List<T> nodes) {
        this.collectPlanNodesHelper(this.planRoot_, predicate, nodes);
    }

    private <T extends PlanNode> void collectPlanNodesHelper(PlanNode root, Predicate<? super PlanNode> predicate, List<T> nodes) {
        if (root == null) {
            return;
        }
        if (predicate.apply((Object)root)) {
            nodes.add(root);
        }
        for (PlanNode child : root.getChildren()) {
            if (child.getFragment() != this) continue;
            this.collectPlanNodesHelper(child, predicate, nodes);
        }
    }

    public void computeCostingSegment(TQueryOptions queryOptions) {
        List<PlanNode> planNodes = this.collectPlanNodes();
        for (int i = planNodes.size() - 1; i >= 0; --i) {
            PlanNode node = planNodes.get(i);
            node.computeProcessingCost(queryOptions);
            node.computeRowConsumptionAndProductionToCost();
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("ProcessingCost Node " + node.getProcessingCost().debugString());
        }
        this.sink_.computeProcessingCost(queryOptions);
        this.sink_.computeRowConsumptionAndProductionToCost();
        if (LOG.isTraceEnabled()) {
            LOG.trace("ProcessingCost Sink " + this.sink_.getProcessingCost().debugString());
        }
        CostingSegment topSegment = this.collectCostingSegmentHelper(this.planRoot_);
        if (PlanFragment.isBlockingNode(this.planRoot_)) {
            this.rootSegment_ = new CostingSegment(this.sink_);
            this.rootSegment_.addChild(topSegment);
        } else {
            topSegment.setSink(this.sink_);
            this.rootSegment_ = topSegment;
        }
    }

    private CostingSegment collectCostingSegmentHelper(PlanNode root) {
        CostingSegment thisSegment;
        Preconditions.checkNotNull((Object)root);
        ArrayList blockingChildSegments = Lists.newArrayList();
        ArrayList nonBlockingChildSegments = Lists.newArrayList();
        for (PlanNode child : root.getChildren()) {
            if (child.getFragment() != this) continue;
            CostingSegment childCostingSegment = this.collectCostingSegmentHelper(child);
            if (PlanFragment.isBlockingNode(child)) {
                blockingChildSegments.add(childCostingSegment);
                continue;
            }
            nonBlockingChildSegments.add(childCostingSegment);
        }
        if (nonBlockingChildSegments.isEmpty()) {
            thisSegment = new CostingSegment(root);
        } else {
            thisSegment = CostingSegment.mergeCostingSegment(nonBlockingChildSegments);
            thisSegment.appendNode(root);
        }
        if (!blockingChildSegments.isEmpty()) {
            thisSegment.addChildren(blockingChildSegments);
        }
        return thisSegment;
    }

    public void finalizeExchanges(Analyzer analyzer) throws InternalException {
        if (this.destNode_ != null && this.destNode_ instanceof ExchangeNode) {
            Preconditions.checkState((this.sink_ == null ? 1 : 0) != 0);
            DataStreamSink streamSink = new DataStreamSink((ExchangeNode)this.destNode_, this.outputPartition_);
            streamSink.setFragment(this);
            this.sink_ = streamSink;
        }
        this.castPartitionedJoinExchanges(this.planRoot_, analyzer);
    }

    private void castPartitionedJoinExchanges(PlanNode node, Analyzer analyzer) {
        if (node instanceof HashJoinNode && ((JoinNode)node).getDistributionMode() == JoinNode.DistributionMode.PARTITIONED) {
            ArrayList exchNodes = new ArrayList();
            node.collect(ExchangeNode.class, exchNodes);
            ArrayList<List<Expr>> senderPartitionExprs = new ArrayList<List<Expr>>();
            for (ExchangeNode exchNode : exchNodes) {
                Preconditions.checkState((!exchNode.getChildren().isEmpty() ? 1 : 0) != 0);
                PlanFragment senderFragment = ((PlanNode)exchNode.getChild(0)).getFragment();
                Preconditions.checkNotNull((Object)senderFragment);
                if (!senderFragment.getOutputPartition().isHashPartitioned()) continue;
                List<Expr> partExprs = senderFragment.getOutputPartition().getPartitionExprs();
                senderPartitionExprs.add(partExprs);
            }
            try {
                analyzer.castToSetOpCompatibleTypes(senderPartitionExprs, false);
            }
            catch (AnalysisException e) {
                throw new IllegalStateException(e);
            }
        } else {
            for (PlanNode child : node.getChildren()) {
                if (child.getFragment() != this) continue;
                this.castPartitionedJoinExchanges(child, analyzer);
            }
        }
    }

    public void computePipelineMembership() {
        this.planRoot_.computePipelineMembership();
    }

    public void computeResourceProfile(Analyzer analyzer) {
        Preconditions.checkState((this.sink_ != null ? 1 : 0) != 0);
        this.sink_.computeResourceProfile(analyzer.getQueryOptions());
        this.computeRuntimeFilterResources(analyzer);
        this.perBackendInitialMemReservationTotalClaims_ = this.consumedGlobalRuntimeFiltersMemReservationBytes_;
        this.perInstanceInitialMemReservationTotalClaims_ = this.sink_.getResourceProfile().getMinMemReservationBytes() + this.producedRuntimeFiltersMemReservationBytes_;
        for (PlanNode node : this.collectPlanNodes()) {
            this.perInstanceInitialMemReservationTotalClaims_ += node.getNodeResourceProfile().getMinMemReservationBytes();
        }
        PlanNode.ExecPhaseResourceProfiles planTreeProfile = this.planRoot_.computeTreeResourceProfiles(analyzer.getQueryOptions());
        ResourceProfile fInstancePostOpenProfile = planTreeProfile.postOpenProfile.sum(this.sink_.getResourceProfile());
        this.perInstanceResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(this.producedRuntimeFiltersMemReservationBytes_).setMinMemReservationBytes(this.producedRuntimeFiltersMemReservationBytes_).setThreadReservation(1L).build().sum(planTreeProfile.duringOpenProfile.max(fInstancePostOpenProfile));
        this.perBackendResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(this.consumedGlobalRuntimeFiltersMemReservationBytes_).setMinMemReservationBytes(this.consumedGlobalRuntimeFiltersMemReservationBytes_).setThreadReservation(0L).build();
        this.validateResourceProfiles();
    }

    private void validateResourceProfiles() {
        Preconditions.checkState((boolean)this.perInstanceResourceProfile_.isValid());
        Preconditions.checkState((boolean)this.perBackendResourceProfile_.isValid());
        Preconditions.checkArgument((this.perInstanceInitialMemReservationTotalClaims_ > -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.perBackendInitialMemReservationTotalClaims_ > -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.producedRuntimeFiltersMemReservationBytes_ > -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.consumedGlobalRuntimeFiltersMemReservationBytes_ > -1L ? 1 : 0) != 0);
    }

    private void computeRuntimeFilterResources(Analyzer analyzer) {
        HashMap<RuntimeFilterId, RuntimeFilterGenerator.RuntimeFilter> consumedFilters = new HashMap<RuntimeFilterId, RuntimeFilterGenerator.RuntimeFilter>();
        HashMap<RuntimeFilterId, RuntimeFilterGenerator.RuntimeFilter> producedFilters = new HashMap<RuntimeFilterId, RuntimeFilterGenerator.RuntimeFilter>();
        TQueryOptions queryOptions = analyzer.getQueryOptions();
        boolean biasToSpill = PlanNode.shouldComputeResourcesWithSpill(queryOptions);
        long maxMemPerInstance = Long.MAX_VALUE;
        if (biasToSpill) {
            boolean isCoordinator = this.sink_ instanceof PlanRootSink;
            maxMemPerInstance = analyzer.getMaxMemLimitPerHost(isCoordinator) / (long)this.getNumInstancesPerHost(queryOptions);
        }
        if (biasToSpill && this.sink_ instanceof SpillableOperator) {
            ((SpillableOperator)((Object)this.sink_)).computeResourceProfileIfSpill(queryOptions, maxMemPerInstance);
        } else {
            this.sink_.computeResourceProfile(queryOptions);
        }
        Preconditions.checkState((this.sink_.getRuntimeFilters().isEmpty() || this.sink_ instanceof JoinBuildSink ? 1 : 0) != 0);
        for (RuntimeFilterGenerator.RuntimeFilter filter : this.sink_.getRuntimeFilters()) {
            producedFilters.put(filter.getFilterId(), filter);
        }
        for (PlanNode node : this.collectPlanNodes()) {
            if (biasToSpill && node instanceof SpillableOperator) {
                ((SpillableOperator)((Object)node)).computeResourceProfileIfSpill(queryOptions, maxMemPerInstance);
            } else {
                node.computeNodeResourceProfile(queryOptions);
            }
            boolean isFilterProducer = node instanceof JoinNode;
            for (RuntimeFilterGenerator.RuntimeFilter filter : node.getRuntimeFilters()) {
                if (isFilterProducer) {
                    producedFilters.put(filter.getFilterId(), filter);
                    continue;
                }
                consumedFilters.put(filter.getFilterId(), filter);
            }
        }
        for (RuntimeFilterGenerator.RuntimeFilter f : producedFilters.values()) {
            this.producedRuntimeFiltersMemReservationBytes_ += f.getFilterSize();
            if (queryOptions.max_num_filters_aggregated_per_host <= 1 || f.isBroadcast()) continue;
            this.consumedGlobalRuntimeFiltersMemReservationBytes_ += f.getFilterSize();
        }
        for (RuntimeFilterGenerator.RuntimeFilter f : consumedFilters.values()) {
            if (producedFilters.containsKey(f.getFilterId())) continue;
            this.consumedGlobalRuntimeFiltersMemReservationBytes_ += f.getFilterSize();
        }
    }

    public boolean coordinatorOnly() {
        return this.coordinatorOnly_;
    }

    public ResourceProfile getPerInstanceResourceProfile() {
        return this.perInstanceResourceProfile_;
    }

    public ResourceProfile getPerBackendResourceProfile() {
        return this.perBackendResourceProfile_;
    }

    public ResourceProfile getTotalPerBackendResourceProfile(TQueryOptions queryOptions) {
        return this.perInstanceResourceProfile_.multiply(this.getNumInstancesPerHost(queryOptions)).sum(this.perBackendResourceProfile_);
    }

    public int getNumNodes() {
        if (this.dataPartition_ == DataPartition.UNPARTITIONED) {
            return 1;
        }
        if (this.sink_ instanceof JoinBuildSink) {
            return ((JoinBuildSink)this.sink_).getNumNodes();
        }
        if (this.sink_ instanceof HdfsTableSink) {
            return ((HdfsTableSink)this.sink_).getNumNodes();
        }
        return this.planRoot_.getNumNodes();
    }

    public int getNumInstancesPerHost(TQueryOptions queryOptions) {
        int numNodes = this.getNumNodes();
        int numInstances = this.getNumInstances();
        if (numNodes == -1 || numInstances == -1) {
            Preconditions.checkState((!queryOptions.isCompute_processing_cost() ? 1 : 0) != 0);
            return Math.max(1, queryOptions.getMt_dop());
        }
        return (int)Math.ceil((double)numInstances / (double)numNodes);
    }

    public int getNumInstances() {
        if (this.dataPartition_ == DataPartition.UNPARTITIONED) {
            return 1;
        }
        if (this.sink_ instanceof JoinBuildSink) {
            return ((JoinBuildSink)this.sink_).getNumInstances();
        }
        if (this.sink_ instanceof HdfsTableSink) {
            return ((HdfsTableSink)this.sink_).getNumInstances();
        }
        if (this.originalInstanceCount_ > -1) {
            int adjustedCount = this.getAdjustedInstanceCount();
            Preconditions.checkState((this.planRoot_.getNumInstances() == adjustedCount ? 1 : 0) != 0, (Object)("Instance count of " + this.getId() + " with plan root " + this.planRoot_.getDisplayLabel() + " (" + this.planRoot_.getNumInstances() + ") does not follow cost based adjustment (" + adjustedCount + ")!"));
        }
        return this.planRoot_.getNumInstances();
    }

    public int getNumInstancesForCosting() {
        Preconditions.checkState((this.originalInstanceCount_ < 0 ? 1 : 0) != 0);
        return this.getNumInstances();
    }

    public long getPerInstanceNdv(List<Expr> exprs, boolean useMaxNdv) {
        Preconditions.checkNotNull((Object)this.dataPartition_);
        long result = 1L;
        int numInstances = this.getNumInstances();
        Preconditions.checkState((numInstances >= 0 ? 1 : 0) != 0);
        if (numInstances == 0) {
            return 0L;
        }
        long maxNdv = 1L;
        boolean partition = false;
        for (Expr expr : exprs) {
            long numDistinct = expr.getNumDistinctValues();
            if (numDistinct == -1L) {
                result = -1L;
                break;
            }
            if (this.dataPartition_.getPartitionExprs().contains(expr)) {
                partition = true;
            }
            result = MathUtil.multiplyCardinalities(result, numDistinct);
            maxNdv = Math.max(maxNdv, numDistinct);
        }
        if (partition) {
            result = (long)Math.max((double)result / (double)numInstances, 1.0);
        }
        if (useMaxNdv && result > maxNdv) {
            result = maxNdv;
        }
        return result;
    }

    public TPlanFragment toThrift() {
        this.validateResourceProfiles();
        TPlanFragment result = new TPlanFragment();
        result.setDisplay_name(this.fragmentId_.toString());
        if (this.planRoot_ != null) {
            result.setPlan(this.planRoot_.treeToThrift());
        }
        if (this.sink_ != null) {
            result.setOutput_sink(this.sink_.toThrift());
        }
        result.setPartition(this.dataPartition_.toThrift());
        result.setInstance_initial_mem_reservation_total_claims(this.perInstanceInitialMemReservationTotalClaims_);
        result.setBackend_initial_mem_reservation_total_claims(this.perBackendInitialMemReservationTotalClaims_);
        result.setProduced_runtime_filters_reservation_bytes(this.producedRuntimeFiltersMemReservationBytes_);
        result.setConsumed_runtime_filters_reservation_bytes(this.consumedGlobalRuntimeFiltersMemReservationBytes_);
        result.setInstance_min_mem_reservation_bytes(this.perInstanceResourceProfile_.getMinMemReservationBytes());
        result.setBackend_min_mem_reservation_bytes(this.perBackendResourceProfile_.getMinMemReservationBytes());
        result.setThread_reservation(this.perInstanceResourceProfile_.getThreadReservation());
        if (this.hasAdjustedInstanceCount()) {
            result.setEffective_instance_count(this.adjustedInstanceCount_);
        }
        result.setIs_coordinator_only(this.coordinatorOnly_);
        result.setIs_dominant(this.isDominantFragment_);
        return result;
    }

    public TPlanFragmentTree treeToThrift() {
        TPlanFragmentTree result = new TPlanFragmentTree();
        this.treeToThriftHelper(result);
        return result;
    }

    private void treeToThriftHelper(TPlanFragmentTree plan) {
        plan.addToFragments(this.toThrift());
        for (PlanFragment child : this.children_) {
            child.treeToThriftHelper(plan);
        }
    }

    public String getExplainString(TQueryOptions queryOptions, TExplainLevel detailLevel) {
        return this.getExplainString("", "", queryOptions, detailLevel);
    }

    protected final String getExplainString(String rootPrefix, String prefix, TQueryOptions queryOptions, TExplainLevel detailLevel) {
        StringBuilder str = new StringBuilder();
        Preconditions.checkState((this.dataPartition_ != null ? 1 : 0) != 0);
        String detailPrefix = prefix + "|  ";
        if (detailLevel == TExplainLevel.VERBOSE) {
            prefix = "  ";
            rootPrefix = "  ";
            detailPrefix = prefix + "|  ";
            str.append(this.getFragmentHeaderString("", "", queryOptions, detailLevel));
            if (this.sink_ != null && this.sink_ instanceof DataStreamSink) {
                str.append(this.sink_.getExplainString(rootPrefix, detailPrefix, queryOptions, detailLevel));
            }
        } else if (detailLevel == TExplainLevel.EXTENDED) {
            str.append(this.getFragmentHeaderString(rootPrefix, detailPrefix, queryOptions, detailLevel));
            rootPrefix = prefix;
        }
        String planRootPrefix = rootPrefix;
        if (this.sink_ != null && !(this.sink_ instanceof DataStreamSink)) {
            str.append(this.sink_.getExplainString(rootPrefix, detailPrefix, queryOptions, detailLevel));
            if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
                str.append(prefix + "|\n");
            }
            planRootPrefix = prefix;
        }
        if (this.planRoot_ != null) {
            str.append(this.planRoot_.getExplainString(planRootPrefix, prefix, queryOptions, detailLevel));
        }
        return str.toString();
    }

    public String getFragmentHeaderString(String firstLinePrefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel) {
        boolean adjustsInstanceCount = queryOptions.isCompute_processing_cost();
        boolean useMTFragment = Planner.useMTFragment(queryOptions);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s%s:PLAN FRAGMENT [%s]", firstLinePrefix, this.fragmentId_.toString(), this.dataPartition_.getExplainString()));
        builder.append(PrintUtils.printNumHosts(" ", this.getNumNodes()));
        builder.append(PrintUtils.printNumInstances(" ", this.getNumInstances()));
        if (adjustsInstanceCount && this.originalInstanceCount_ != this.getNumInstances()) {
            builder.append(" (adjusted from " + this.originalInstanceCount_ + ")");
        }
        builder.append("\n");
        String perHostPrefix = !useMTFragment ? "Per-Host Resources: " : "Per-Host Shared Resources: ";
        String perHostExplainString = null;
        String perInstanceExplainString = null;
        if (!useMTFragment) {
            ResourceProfile perHostProfile = this.getTotalPerBackendResourceProfile(queryOptions);
            StringBuilder perHostBuilder = new StringBuilder(perHostProfile.getExplainString());
            long totalRuntimeFilterReservation = this.producedRuntimeFiltersMemReservationBytes_ + this.consumedGlobalRuntimeFiltersMemReservationBytes_;
            if (perHostProfile.isValid() && totalRuntimeFilterReservation > 0L) {
                perHostBuilder.append(" runtime-filters-memory=");
                perHostBuilder.append(PrintUtils.printBytes(totalRuntimeFilterReservation));
            }
            perHostExplainString = perHostBuilder.toString();
        } else {
            if (this.perBackendResourceProfile_.isValid() && this.perBackendResourceProfile_.isNonZero()) {
                StringBuilder perHostBuilder = new StringBuilder(this.perBackendResourceProfile_.getExplainString());
                if (this.consumedGlobalRuntimeFiltersMemReservationBytes_ > 0L) {
                    perHostBuilder.append(" runtime-filters-memory=");
                    perHostBuilder.append(PrintUtils.printBytes(this.consumedGlobalRuntimeFiltersMemReservationBytes_));
                }
                perHostExplainString = perHostBuilder.toString();
            }
            if (this.perInstanceResourceProfile_.isValid()) {
                StringBuilder perInstanceBuilder = new StringBuilder(this.perInstanceResourceProfile_.getExplainString());
                if (this.producedRuntimeFiltersMemReservationBytes_ > 0L) {
                    perInstanceBuilder.append(" runtime-filters-memory=");
                    perInstanceBuilder.append(PrintUtils.printBytes(this.producedRuntimeFiltersMemReservationBytes_));
                }
                perInstanceExplainString = perInstanceBuilder.toString();
            }
        }
        if (perHostExplainString != null) {
            builder.append(detailPrefix);
            builder.append(perHostPrefix);
            builder.append(perHostExplainString);
            builder.append("\n");
        }
        if (perInstanceExplainString != null) {
            builder.append(detailPrefix);
            builder.append("Per-Instance Resources: ");
            builder.append(perInstanceExplainString);
            builder.append("\n");
        }
        if (Planner.isProcessingCostAvailable(queryOptions) && this.rootSegment_ != null && explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            builder.append(detailPrefix);
            builder.append("max-parallelism=");
            builder.append(this.maxParallelism_);
            builder.append(" segment-costs=");
            builder.append(this.costingSegmentSummary());
            if (this.thisTreeCpuCore_ > 0 && this.subtreeCpuCore_ > 0) {
                builder.append(" cpu-comparison-result=");
                builder.append(Math.max(this.thisTreeCpuCore_, this.subtreeCpuCore_));
                builder.append(" [max(");
                builder.append(this.thisTreeCpuCore_);
                builder.append(" (self) vs ");
                builder.append(this.subtreeCpuCore_);
                builder.append(" (sum children))]");
            }
            builder.append("\n");
            if (explainLevel.ordinal() >= TExplainLevel.VERBOSE.ordinal()) {
                builder.append(this.explainProcessingCosts(detailPrefix, false));
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public boolean isPartitioned() {
        return this.dataPartition_.getType() != TPartitionType.UNPARTITIONED;
    }

    public PlanFragmentId getId() {
        return this.fragmentId_;
    }

    public PlanId getPlanId() {
        return this.planId_;
    }

    public void setPlanId(PlanId id) {
        this.planId_ = id;
    }

    public CohortId getCohortId() {
        return this.cohortId_;
    }

    public void setCohortId(CohortId id) {
        this.cohortId_ = id;
    }

    public PlanFragment getDestFragment() {
        if (this.destNode_ == null) {
            return null;
        }
        return this.destNode_.getFragment();
    }

    public PlanNode getDestNode() {
        return this.destNode_;
    }

    public DataPartition getDataPartition() {
        return this.dataPartition_;
    }

    public void setDataPartition(DataPartition dataPartition) {
        this.dataPartition_ = dataPartition;
    }

    public DataPartition getOutputPartition() {
        return this.outputPartition_;
    }

    public void setOutputPartition(DataPartition outputPartition) {
        this.outputPartition_ = outputPartition;
    }

    public PlanNode getPlanRoot() {
        return this.planRoot_;
    }

    public void setPlanRoot(PlanNode root) {
        this.planRoot_ = root;
        this.setFragmentInPlanTree(this.planRoot_);
    }

    protected void markDominant() {
        this.isDominantFragment_ = true;
    }

    public void setDestination(PlanNode destNode) {
        this.destNode_ = destNode;
        PlanFragment dest = this.getDestFragment();
        Preconditions.checkNotNull((Object)dest);
        dest.addChild(this);
    }

    public boolean hasSink() {
        return this.sink_ != null;
    }

    public DataSink getSink() {
        return this.sink_;
    }

    public void setSink(DataSink sink) {
        Preconditions.checkState((this.sink_ == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)sink);
        sink.setFragment(this);
        this.sink_ = sink;
    }

    public void addPlanRoot(PlanNode newRoot) {
        Preconditions.checkState((newRoot.getChildren().size() == 1 ? 1 : 0) != 0);
        newRoot.setChild(0, this.planRoot_);
        this.planRoot_ = newRoot;
        this.planRoot_.setFragment(this);
    }

    public List<PlanFragment> getFragmentsInPlanPreorder() {
        ArrayList<PlanFragment> result = new ArrayList<PlanFragment>();
        this.getFragmentsInPlanPreorderAux(result);
        return result;
    }

    protected void getFragmentsInPlanPreorderAux(List<PlanFragment> result) {
        result.add(this);
        for (PlanFragment child : this.children_) {
            if (!(child.getSink() instanceof DataStreamSink)) continue;
            child.getFragmentsInPlanPreorderAux(result);
        }
    }

    public void verifyTree() {
        List<PlanNode> nodes = this.collectPlanNodes();
        ArrayList<PlanNode> exchNodes = new ArrayList<PlanNode>();
        for (PlanNode node : nodes) {
            if (node instanceof ExchangeNode) {
                exchNodes.add(node);
            }
            Preconditions.checkState((node.getFragment() == this ? 1 : 0) != 0);
        }
        Preconditions.checkState((exchNodes.size() == this.getChildren().size() ? 1 : 0) != 0);
        ArrayList<PlanFragment> childFragments = new ArrayList<PlanFragment>();
        for (PlanNode exchNode : exchNodes) {
            PlanFragment childFragment = ((PlanNode)exchNode.getChild(0)).getFragment();
            Preconditions.checkState((!childFragments.contains(childFragment) ? 1 : 0) != 0);
            childFragments.add(childFragment);
            Preconditions.checkState((childFragment.getDestNode() == exchNode ? 1 : 0) != 0);
        }
        Preconditions.checkState((boolean)this.getChildren().containsAll(childFragments));
        for (PlanFragment child : this.getChildren()) {
            child.verifyTree();
        }
    }

    public int getHashSeed() {
        return this.planRoot_.getId().asInt() + 1;
    }

    protected int getCostBasedMaxParallelism() {
        ProcessingCost maxCostingSegment = ProcessingCost.zero();
        List allSegments = this.rootSegment_.getNodesPostOrder();
        for (CostingSegment costingSegment : allSegments) {
            maxCostingSegment = ProcessingCost.maxCost(maxCostingSegment, costingSegment.getProcessingCost());
        }
        return maxCostingSegment.getNumInstanceMax(this.getNumNodes());
    }

    protected int getCappedCostBasedMaxParallelism(int minCap) {
        int costBasedMaxParallelism = Math.max(minCap, this.getCostBasedMaxParallelism());
        Preconditions.checkState((costBasedMaxParallelism > 0 ? 1 : 0) != 0);
        return costBasedMaxParallelism;
    }

    protected int getNodeStepCountForParallelismTraversal() {
        return this.getNumInstances() % this.getNumNodes() == 0 ? this.getNumNodes() : 1;
    }

    protected boolean hasBlockingNode() {
        if (this.sink_ instanceof JoinBuildSink) {
            return true;
        }
        for (PlanNode p : this.collectPlanNodes()) {
            if (!PlanFragment.isBlockingNode(p)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAdjustedInstanceCount() {
        return this.adjustedInstanceCount_ > 0;
    }

    protected void setFixedInstanceCount(int count) {
        this.isFixedParallelism_ = true;
        this.setAdjustedInstanceCount(count);
    }

    private void setAdjustedInstanceCount(int count) {
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)(this.getId() + " adjusted instance count (" + count + ") is not positive number."));
        boolean isFirstAdjustment = this.adjustedInstanceCount_ <= 0;
        this.adjustedInstanceCount_ = count;
        if (this.rootSegment_ != null) {
            List costingSegments = this.rootSegment_.getNodesPostOrder();
            for (CostingSegment costingSegment : costingSegments) {
                costingSegment.getProcessingCost().setNumInstanceExpected(this::getAdjustedInstanceCount);
            }
        }
        if (isFirstAdjustment) {
            for (PlanNode node : this.collectPlanNodes()) {
                node.getProcessingCost().setNumInstanceExpected(this::getAdjustedInstanceCount);
            }
            this.sink_.getProcessingCost().setNumInstanceExpected(this::getAdjustedInstanceCount);
        }
    }

    protected int getAdjustedInstanceCount() {
        Preconditions.checkState((this.adjustedInstanceCount_ > -1 ? 1 : 0) != 0);
        return this.adjustedInstanceCount_;
    }

    protected int getMaxParallelism() {
        Preconditions.checkState((this.maxParallelism_ > -1 ? 1 : 0) != 0);
        return this.maxParallelism_;
    }

    protected ProcessingCost getLastCostingSegment() {
        return this.rootSegment_.getProcessingCost();
    }

    private List<Long> costingSegmentSummary() {
        return this.rootSegment_.getNodesPostOrder().stream().map(s -> ((CostingSegment)s).getProcessingCost().getTotalCost()).collect(Collectors.toList());
    }

    private String explainProcessingCosts(String linePrefix, boolean fullExplain) {
        return this.rootSegment_.getNodesPreOrder().stream().map(s -> ((CostingSegment)s).getProcessingCost().getExplainString(linePrefix, fullExplain)).collect(Collectors.joining("\n"));
    }

    private String debugProcessingCosts() {
        return this.explainProcessingCosts("", true);
    }

    private void validateProcessingCosts() {
        Preconditions.checkState((boolean)this.hasAdjustedInstanceCount());
        Preconditions.checkNotNull((Object)this.rootSegment_);
        List costingSegments = this.rootSegment_.getNodesPreOrder();
        for (CostingSegment costingSegment : costingSegments) {
            ProcessingCost cost = costingSegment.getProcessingCost();
            Preconditions.checkState((boolean)cost.isValid(), (String)"Segment cost is invalid! %s", (Object)cost);
            Preconditions.checkState((cost.getNumInstancesExpected() == this.getAdjustedInstanceCount() ? 1 : 0) != 0);
        }
    }

    protected void traverseEffectiveParallelism(int minThreadPerNode, int maxThreadPerNode, @Nullable PlanFragment parentFragment, TQueryOptions queryOptions) {
        PlanFragment lc;
        int lcNumNode;
        int lcMaxParallelism;
        Preconditions.checkNotNull((Object)this.rootSegment_, (String)"ProcessingCost Fragment %s has not been computed!", (Object)this.getId());
        int nodeStepCount = this.getNodeStepCountForParallelismTraversal();
        ScalingVerdict verdict = this.adjustToMaxParallelism(minThreadPerNode, maxThreadPerNode, parentFragment, nodeStepCount, queryOptions);
        if (verdict == ScalingVerdict.CAN_LOWER && this.getAdjustedInstanceCount() > 1) {
            Preconditions.checkState((this.getChildCount() > 0 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)(((PlanFragment)this.getChild(0)).getSink() instanceof DataStreamSink));
            int maxParallelism = this.getAdjustedInstanceCount();
            int minParallelism = IntMath.saturatedMultiply((int)minThreadPerNode, (int)this.getNumNodes());
            int effectiveParallelism = this.rootSegment_.tryAdjustParallelism(nodeStepCount, minParallelism, maxParallelism);
            this.setAdjustedInstanceCount(effectiveParallelism);
            if (LOG.isTraceEnabled() && effectiveParallelism != maxParallelism) {
                this.logCountAdjustmentTrace(maxParallelism, effectiveParallelism, verdict, "Lower parallelism based on load and produce-consume rate ratio.");
            }
        }
        if (parentFragment == null && this.hasChild(0) && verdict != ScalingVerdict.FIXED_BY_PLAN_NODE && verdict != ScalingVerdict.FIXED_BY_PARTITIONED_JOIN_BUILD && (lcMaxParallelism = IntMath.saturatedMultiply((int)maxThreadPerNode, (int)(lcNumNode = (lc = (PlanFragment)this.getChild(0)).getNumNodes()))) < this.getAdjustedInstanceCount()) {
            LOG.warn("Reducing instance count of {} from {} to {} to follow left-child node {} (num_nodes={}, num_instance={}). Scaling verdict was {}.", new Object[]{this.getId(), this.getAdjustedInstanceCount(), lcMaxParallelism, lc.getId(), lc.getNumNodes(), lc.getAdjustedInstanceCount(), verdict});
            this.setAdjustedInstanceCount(lcMaxParallelism);
        }
        this.validateProcessingCosts();
        for (PlanFragment child : this.getChildren()) {
            if (!(child.getSink() instanceof JoinBuildSink)) continue;
            child.traverseEffectiveParallelism(minThreadPerNode, maxThreadPerNode, this, queryOptions);
        }
    }

    protected boolean isPartitionedJoinBuildFragment() {
        return this.sink_ instanceof JoinBuildSink && !((JoinBuildSink)this.sink_).isShared();
    }

    protected int getMaxParallelismForUnionFragment(UnionNode node, boolean findUnboundedCount, @Nullable TQueryOptions queryOptions) {
        Preconditions.checkState((this == node.getFragment() ? 1 : 0) != 0);
        int nodeStepCount = this.getNodeStepCountForParallelismTraversal();
        int costBasedMaxParallelism = this.getCappedCostBasedMaxParallelism(nodeStepCount);
        int maxParallelism = 1;
        for (PlanFragment child : this.getChildren()) {
            if (child.getSink() instanceof JoinBuildSink) continue;
            Preconditions.checkState((boolean)child.hasAdjustedInstanceCount());
            maxParallelism = Math.max(maxParallelism, findUnboundedCount ? child.getMaxParallelism() : child.getAdjustedInstanceCount());
        }
        ArrayList scanNodes = Lists.newArrayList();
        this.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(ScanNode.class), scanNodes);
        int maxScannerThreads = 0;
        if (!scanNodes.isEmpty()) {
            maxScannerThreads = 1;
            for (ScanNode scanNode : scanNodes) {
                int thisScannerThreads = 1;
                if (findUnboundedCount) {
                    thisScannerThreads = scanNode.estScanRangeAfterRuntimeFilter();
                } else {
                    Preconditions.checkNotNull((Object)queryOptions);
                    thisScannerThreads = scanNode.computeMaxScannerThreadsForCPC(queryOptions);
                }
                maxScannerThreads = Math.max(maxScannerThreads, thisScannerThreads);
            }
            maxParallelism = Math.max(maxParallelism, Math.min(costBasedMaxParallelism, maxScannerThreads));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set maxParallelism to: " + maxParallelism + ", costBasedMaxParallelism: " + costBasedMaxParallelism + ", maxScannerThreads: " + maxScannerThreads + ", findUnboundedCount: " + findUnboundedCount);
        }
        return maxParallelism;
    }

    private ScalingVerdict adjustToMaxParallelism(int minThreadPerNode, int maxThreadPerNode, @Nullable PlanFragment parentFragment, int nodeStepCount, TQueryOptions queryOptions) {
        int maxThreadAllowed = IntMath.saturatedMultiply((int)maxThreadPerNode, (int)this.getNumNodes());
        ScalingVerdict verdict = ScalingVerdict.CAN_LOWER;
        int selectedParallelism = this.getNumInstances();
        if (this.isFixedParallelism_) {
            this.maxParallelism_ = selectedParallelism = this.getAdjustedInstanceCount();
            verdict = ScalingVerdict.FIXED_BY_PLAN_NODE;
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} instance count fixed to {}. verdict={}", new Object[]{this.getId(), this.maxParallelism_, verdict});
            }
        } else if (this.isPartitionedJoinBuildFragment()) {
            int parentParallelism;
            Preconditions.checkNotNull((Object)parentFragment);
            selectedParallelism = parentParallelism = parentFragment.getAdjustedInstanceCount();
            this.maxParallelism_ = parentFragment.getMaxParallelism();
            verdict = ScalingVerdict.FIXED_BY_PARTITIONED_JOIN_BUILD;
            if (LOG.isTraceEnabled()) {
                this.logCountAdjustmentTrace(selectedParallelism, parentParallelism, verdict, "Partitioned join build fragment follow parent's parallelism.");
            }
        } else {
            UnionNode unionNode = this.getUnionNode();
            if (unionNode != null) {
                this.maxParallelism_ = this.getMaxParallelismForUnionFragment(unionNode, false, queryOptions);
                if (this.maxParallelism_ > maxThreadAllowed) {
                    selectedParallelism = maxThreadAllowed;
                    if (LOG.isTraceEnabled()) {
                        this.logCountAdjustmentTrace(this.getNumInstances(), selectedParallelism, verdict, "Follow maxThreadPerNode.");
                    }
                } else {
                    selectedParallelism = this.maxParallelism_;
                    if (LOG.isTraceEnabled()) {
                        this.logCountAdjustmentTrace(this.getNumInstances(), selectedParallelism, verdict, "Follow minimum work per thread or max child count.");
                    }
                }
                verdict = ScalingVerdict.UNION_FRAGMENT_BOUNDED;
            } else {
                int costBasedMaxParallelism;
                int maxScannerThreads = Integer.MAX_VALUE;
                this.maxParallelism_ = costBasedMaxParallelism = this.getCappedCostBasedMaxParallelism(nodeStepCount);
                int boundedParallelism = costBasedMaxParallelism;
                ArrayList scanNodes = Lists.newArrayList();
                this.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(ScanNode.class), scanNodes);
                if (!scanNodes.isEmpty()) {
                    Preconditions.checkState((scanNodes.size() == 1 ? 1 : 0) != 0);
                    maxScannerThreads = ((ScanNode)scanNodes.get(0)).computeMaxScannerThreadsForCPC(queryOptions);
                    this.maxParallelism_ = Math.max(1, Math.min(this.maxParallelism_, ((ScanNode)scanNodes.get(0)).estScanRangeAfterRuntimeFilter()));
                    boundedParallelism = Math.max(1, Math.min(boundedParallelism, maxScannerThreads));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Set maxParallelism to: " + this.maxParallelism_ + ", costBasedMaxParallelism: " + costBasedMaxParallelism + ", maxScannerThreads: " + maxScannerThreads);
                    }
                    verdict = ScalingVerdict.SCAN_FRAGMENT_BOUNDED;
                }
                int minParallelism = Math.min(maxThreadAllowed, IntMath.saturatedMultiply((int)minThreadPerNode, (int)this.getNumNodes()));
                LOG.info("maxParallelism_=" + this.maxParallelism_ + " boundedParallelism=" + boundedParallelism + " minParallelism=" + minParallelism);
                if (boundedParallelism > maxThreadAllowed) {
                    selectedParallelism = maxThreadAllowed;
                    if (LOG.isTraceEnabled()) {
                        this.logCountAdjustmentTrace(this.getNumInstances(), selectedParallelism, verdict, "Follow maxThreadPerNode.");
                    }
                } else {
                    if (boundedParallelism < minParallelism && minParallelism < maxScannerThreads) {
                        boundedParallelism = minParallelism;
                        verdict = ScalingVerdict.MIN_GLOBAL_PARALLELISM;
                        if (LOG.isTraceEnabled()) {
                            this.logCountAdjustmentTrace(this.getNumInstances(), boundedParallelism, verdict, "Follow minThreadPerNode.");
                        }
                    } else if (LOG.isTraceEnabled()) {
                        this.logCountAdjustmentTrace(this.getNumInstances(), boundedParallelism, verdict, "Follow minimum work per thread.");
                    }
                    selectedParallelism = boundedParallelism;
                }
            }
        }
        Preconditions.checkState((selectedParallelism <= maxThreadAllowed ? 1 : 0) != 0);
        this.setAdjustedInstanceCount(selectedParallelism);
        return verdict;
    }

    @Nullable
    protected UnionNode getUnionNode() {
        ArrayList nodes = Lists.newArrayList();
        this.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(UnionNode.class), nodes);
        return nodes.isEmpty() ? null : (UnionNode)nodes.get(0);
    }

    protected void computeBlockingAwareCores(Map<PlanFragmentId, Pair<CoreCount, List<CoreCount>>> fragmentCoreState, boolean findUnboundedCount) {
        Preconditions.checkNotNull((Object)this.rootSegment_, (String)"ProcessingCost Fragment %s has not been computed!", (Object)this.getId());
        ImmutableList.Builder subtreeCoreBuilder = new ImmutableList.Builder();
        CoreCount coreReq = this.rootSegment_.traverseBlockingAwareCores(fragmentCoreState, (ImmutableList.Builder<CoreCount>)subtreeCoreBuilder, findUnboundedCount);
        fragmentCoreState.put(this.getId(), Pair.create(coreReq, subtreeCoreBuilder.build()));
    }

    protected CoreCount maxCore(CoreCount thisTreeCpuCore, CoreCount subtreeCpuCore, boolean findUnboundedCount) {
        if (!findUnboundedCount) {
            this.thisTreeCpuCore_ = thisTreeCpuCore.total();
            this.subtreeCpuCore_ = subtreeCpuCore.total();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("At {}, do {} comparison of {} ({}) vs {} ({})", new Object[]{this.getId(), thisTreeCpuCore, findUnboundedCount ? "unbounded" : "bounded", thisTreeCpuCore.total(), subtreeCpuCore, subtreeCpuCore.total()});
        }
        return CoreCount.max(thisTreeCpuCore, subtreeCpuCore);
    }

    protected void setEffectiveNumInstance() {
        this.validateProcessingCosts();
        if (this.originalInstanceCount_ <= 0) {
            this.originalInstanceCount_ = this.getNumInstances();
        }
        int adjustedCount = this.getAdjustedInstanceCount();
        if (LOG.isTraceEnabled() && this.originalInstanceCount_ != adjustedCount) {
            LOG.trace("{} finalize instance count from {} to {}.", new Object[]{this.getId(), this.originalInstanceCount_, adjustedCount});
        }
        for (PlanNode node : this.collectPlanNodes()) {
            node.numInstances_ = adjustedCount;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ProcessingCost Fragment {}:\n{}", (Object)this.getId(), (Object)this.debugProcessingCosts());
        }
    }

    private void logCountAdjustmentTrace(int oldCount, int newCount, ScalingVerdict verdict, String reason) {
        LOG.trace("{} adjust instance count from {} to {}. verdict={} reason={}", new Object[]{this.getId(), oldCount, newCount, verdict, reason});
    }

    private static boolean isBlockingNode(PlanNode node) {
        return node.isBlockingNode() || node instanceof AggregationNode;
    }

    private static enum ScalingVerdict {
        CAN_LOWER,
        FIXED_BY_PLAN_NODE,
        FIXED_BY_PARTITIONED_JOIN_BUILD,
        UNION_FRAGMENT_BOUNDED,
        SCAN_FRAGMENT_BOUNDED,
        MIN_GLOBAL_PARALLELISM;

    }
}

