/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TNestedLoopJoinNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedLoopJoinNode
extends JoinNode {
    private static final Logger LOG = LoggerFactory.getLogger(NestedLoopJoinNode.class);
    private static final double COST_COEFFICIENT_NLJ_TINY_RHS = 0.2049;
    private static final double COST_COEFFICIENT_NLJ = 0.1559;

    public NestedLoopJoinNode(PlanNode outer, PlanNode inner, boolean isStraightJoin, JoinNode.DistributionMode distrMode, JoinOperator joinOp, List<Expr> otherJoinConjuncts) {
        super(outer, inner, isStraightJoin, distrMode, joinOp, Collections.emptyList(), otherJoinConjuncts, "NESTED LOOP JOIN");
        Preconditions.checkState((this.joinOp_ != JoinOperator.ICEBERG_DELETE_JOIN ? 1 : 0) != 0);
    }

    @Override
    public boolean isBlockingJoinNode() {
        return true;
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        Preconditions.checkState((boolean)this.eqJoinConjuncts_.isEmpty());
        if (this.conjuncts_.isEmpty() && this.otherJoinConjuncts_.isEmpty() && !this.joinOp_.isSemiJoin() && !this.joinOp_.isOuterJoin()) {
            this.joinOp_ = JoinOperator.CROSS_JOIN;
        } else if (this.joinOp_.isCrossJoin()) {
            this.joinOp_ = JoinOperator.INNER_JOIN;
        }
        this.orderJoinConjunctsByCost();
        this.computeStats(analyzer);
    }

    @Override
    public Pair<ResourceProfile, ResourceProfile> computeJoinResourceProfile(TQueryOptions queryOptions) {
        long perInstanceMemEstimate;
        long rhsChildNode = ((PlanNode)this.getChild(1)).getCardinality();
        if (rhsChildNode == -1L || ((PlanNode)this.getChild(1)).getAvgRowSize() == -1.0f || this.numNodes_ == 0) {
            perInstanceMemEstimate = 0x80000000L;
        } else {
            double memMult = (float)rhsChildNode * ((PlanNode)this.getChild((int)1)).avgRowSize_;
            perInstanceMemEstimate = (long)Math.ceil(memMult);
        }
        ResourceProfile buildProfile = ResourceProfile.noReservation(perInstanceMemEstimate);
        return Pair.create(ResourceProfile.noReservation(0L), buildProfile);
    }

    @Override
    public Pair<ProcessingCost, ProcessingCost> computeJoinProcessingCost() {
        long probeCardinality = this.getProbeCardinalityForCosting();
        long buildCardinality = Math.max(0L, ((PlanNode)this.getChild(1)).getCardinality());
        long cardProduct = MathUtil.multiplyCardinalities(probeCardinality, buildCardinality);
        long perInstanceBuildCardinality = (long)Math.ceil(buildCardinality / (long)this.fragment_.getNumInstancesForCosting());
        double totalCost = 0.0;
        totalCost = perInstanceBuildCardinality < 5L ? (double)cardProduct * 0.2049 : (double)cardProduct * 0.1559;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Probe CPU cost estimate: " + totalCost + ", Probe Card: " + probeCardinality + ", Build Card: " + buildCardinality + ", Build Card Per Instance: " + perInstanceBuildCardinality);
        }
        ProcessingCost processingCost = ProcessingCost.basicCost(this.getDisplayLabel(), totalCost);
        return Pair.create(processingCost, ProcessingCost.zero());
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String labelDetail = this.getDisplayLabelDetail();
        if (labelDetail == null) {
            output.append(prefix + this.getDisplayLabel() + "\n");
        } else {
            output.append(String.format("%s%s:%s [%s]\n", prefix, this.id_.toString(), this.displayName_, this.getDisplayLabelDetail()));
        }
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            if (this.joinTableId_.isValid()) {
                output.append(detailPrefix + "join table id: " + this.joinTableId_.toString() + "\n");
            }
            if (!this.otherJoinConjuncts_.isEmpty()) {
                output.append(detailPrefix + "join predicates: ").append(Expr.getExplainString(this.otherJoinConjuncts_, detailLevel) + "\n");
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix + "predicates: ").append(Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
            }
            if (!this.runtimeFilters_.isEmpty()) {
                output.append(detailPrefix + "runtime filters: ");
                output.append(this.getRuntimeFilterExplainString(true, detailLevel));
            }
        }
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        msg.node_type = TPlanNodeType.NESTED_LOOP_JOIN_NODE;
        msg.join_node = this.joinNodeToThrift(serialCtx);
        msg.join_node.nested_loop_join_node = new TNestedLoopJoinNode();
        for (Expr e : this.otherJoinConjuncts_) {
            msg.join_node.nested_loop_join_node.addToJoin_conjuncts(e.treeToThrift(serialCtx));
        }
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)super.debugString()).toString();
    }
}

