/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.JoinTableId;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.PipelineMembership;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.TupleCacheInfo;
import org.apache.impala.thrift.TEqJoinCondition;
import org.apache.impala.thrift.TExecNodePhase;
import org.apache.impala.thrift.TJoinDistributionMode;
import org.apache.impala.thrift.TJoinNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoinNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(JoinNode.class);
    protected static final long DEFAULT_PER_INSTANCE_MEM = 0x80000000L;
    public static final double FK_PK_MAX_STATS_DELTA_PERC = 0.05;
    protected JoinOperator joinOp_;
    protected final boolean isStraightJoin_;
    protected final DistributionMode distrModeHint_;
    protected DistributionMode distrMode_ = DistributionMode.NONE;
    protected List<BinaryPredicate> eqJoinConjuncts_;
    protected List<Expr> otherJoinConjuncts_;
    protected JoinTableId joinTableId_ = JoinTableId.INVALID;
    protected boolean isDeleteRowsJoin_ = false;
    protected List<EqJoinConjunctScanSlots> fkPkEqJoinConjuncts_;

    public void setIsDeleteRowsJoin() {
        this.isDeleteRowsJoin_ = true;
        this.displayName_ = "DELETE EVENTS " + this.displayName_;
    }

    public JoinNode(PlanNode outer, PlanNode inner, boolean isStraightJoin, DistributionMode distrMode, JoinOperator joinOp, List<BinaryPredicate> eqJoinConjuncts, List<Expr> otherJoinConjuncts, String displayName) {
        super(displayName);
        Preconditions.checkNotNull(otherJoinConjuncts);
        this.isStraightJoin_ = isStraightJoin;
        this.distrModeHint_ = distrMode;
        this.joinOp_ = joinOp;
        this.children_.add(outer);
        this.children_.add(inner);
        this.eqJoinConjuncts_ = eqJoinConjuncts;
        this.otherJoinConjuncts_ = otherJoinConjuncts;
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        Preconditions.checkState((this.children_.size() == 2 ? 1 : 0) != 0);
        this.clearTupleIds();
        PlanNode outer = (PlanNode)this.children_.get(0);
        PlanNode inner = (PlanNode)this.children_.get(1);
        switch (this.joinOp_) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: 
            case ICEBERG_DELETE_JOIN: {
                this.tupleIds_.addAll(outer.getTupleIds());
                break;
            }
            case RIGHT_ANTI_JOIN: 
            case RIGHT_SEMI_JOIN: {
                this.tupleIds_.addAll(inner.getTupleIds());
                break;
            }
            default: {
                this.tupleIds_.addAll(outer.getTupleIds());
                this.tupleIds_.addAll(inner.getTupleIds());
            }
        }
        this.tblRefIds_.addAll(outer.getTblRefIds());
        this.tblRefIds_.addAll(inner.getTblRefIds());
        this.nullableTupleIds_.addAll(inner.getNullableTupleIds());
        this.nullableTupleIds_.addAll(outer.getNullableTupleIds());
        if (this.joinOp_.equals((Object)JoinOperator.FULL_OUTER_JOIN)) {
            this.nullableTupleIds_.addAll(outer.getTupleIds());
            this.nullableTupleIds_.addAll(inner.getTupleIds());
        } else if (this.joinOp_.equals((Object)JoinOperator.LEFT_OUTER_JOIN)) {
            this.nullableTupleIds_.addAll(inner.getTupleIds());
        } else if (this.joinOp_.equals((Object)JoinOperator.RIGHT_OUTER_JOIN)) {
            this.nullableTupleIds_.addAll(outer.getTupleIds());
        }
    }

    @Override
    public ExprSubstitutionMap getOutputSmap() {
        switch (this.joinOp_) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: 
            case ICEBERG_DELETE_JOIN: {
                ExprSubstitutionMap result = new ExprSubstitutionMap();
                List<Expr> lhs = Expr.cloneList(this.outputSmap_.getLhs());
                List<Expr> rhs = Expr.cloneList(this.outputSmap_.getRhs());
                for (int i = 0; i < rhs.size(); ++i) {
                    SlotRef slotRef;
                    TupleId tid;
                    if (rhs.get(i) instanceof SlotRef && !this.tupleIds_.contains(tid = (slotRef = (SlotRef)rhs.get(i)).getDesc().getParent().getId())) continue;
                    result.put(lhs.get(i), rhs.get(i));
                }
                return result;
            }
        }
        return this.outputSmap_;
    }

    public boolean isInvertible(boolean isLocalPlan) {
        if (this.isStraightJoin()) {
            return false;
        }
        if (this.joinOp_.isNullAwareLeftAntiJoin()) {
            return false;
        }
        if (isLocalPlan) {
            return true;
        }
        if (!this.eqJoinConjuncts_.isEmpty()) {
            return true;
        }
        if (this.joinOp_.isLeftOuterJoin()) {
            return false;
        }
        return !this.joinOp_.isLeftSemiJoin();
    }

    public boolean canShareBuild() {
        return this.distrMode_ == DistributionMode.BROADCAST || this.distrMode_ == DistributionMode.DIRECTED;
    }

    public JoinOperator getJoinOp() {
        return this.joinOp_;
    }

    public List<BinaryPredicate> getEqJoinConjuncts() {
        return this.eqJoinConjuncts_;
    }

    public List<Expr> getOtherJoinConjuncts() {
        return this.otherJoinConjuncts_;
    }

    public boolean isStraightJoin() {
        return this.isStraightJoin_;
    }

    public DistributionMode getDistributionModeHint() {
        return this.distrModeHint_;
    }

    public DistributionMode getDistributionMode() {
        return this.distrMode_;
    }

    public void setDistributionMode(DistributionMode distrMode) {
        this.distrMode_ = distrMode;
    }

    public JoinTableId getJoinTableId() {
        return this.joinTableId_;
    }

    public void setJoinTableId(JoinTableId id) {
        this.joinTableId_ = id;
    }

    public boolean hasSeparateBuild() {
        return this.joinTableId_ != JoinTableId.INVALID;
    }

    public abstract boolean isBlockingJoinNode();

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.assignConjuncts(analyzer);
        this.createDefaultSmap(analyzer);
        for (TupleDescriptor tuple : analyzer.materializeSlots(this.conjuncts_)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Recompute mem layout for " + tuple.debugString());
            }
            Preconditions.checkNotNull((Object)tuple.getMaskedByTuple());
            tuple.recomputeMemLayout();
        }
        this.assignedConjuncts_ = analyzer.getAssignedConjuncts();
        this.otherJoinConjuncts_ = Expr.substituteList(this.otherJoinConjuncts_, this.getCombinedChildSmap(), analyzer, false);
        ArrayList<SlotRef> slotRefs = new ArrayList<SlotRef>();
        for (Expr expr : this.getConjuncts()) {
            expr.collect(SlotRef.class, slotRefs);
        }
        for (Expr expr : this.getOtherJoinConjuncts()) {
            expr.collect(SlotRef.class, slotRefs);
        }
        for (Expr expr : this.getEqJoinConjuncts()) {
            expr.collect(SlotRef.class, slotRefs);
        }
        analyzer.addJoinColumns(slotRefs);
    }

    private long getJoinCardinality(Analyzer analyzer) {
        Preconditions.checkState((this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin() ? 1 : 0) != 0);
        this.fkPkEqJoinConjuncts_ = Collections.emptyList();
        long lhsCard = ((PlanNode)this.getChild((int)0)).cardinality_;
        long rhsCard = ((PlanNode)this.getChild((int)1)).cardinality_;
        if (lhsCard == -1L || rhsCard == -1L) {
            return lhsCard;
        }
        ArrayList<EqJoinConjunctScanSlots> eqJoinConjunctSlots = new ArrayList<EqJoinConjunctScanSlots>();
        ArrayList<NdvAndRowCountStats> otherEqJoinStats = new ArrayList<NdvAndRowCountStats>();
        for (Expr expr : this.eqJoinConjuncts_) {
            EqJoinConjunctScanSlots slots = EqJoinConjunctScanSlots.create(expr, otherEqJoinStats, lhsCard, rhsCard);
            if (slots == null) continue;
            eqJoinConjunctSlots.add(slots);
        }
        if (eqJoinConjunctSlots.isEmpty()) {
            if (!otherEqJoinStats.isEmpty() && (this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin())) {
                return this.getGenericJoinCardinality2(otherEqJoinStats, lhsCard, rhsCard, analyzer);
            }
            return lhsCard;
        }
        this.fkPkEqJoinConjuncts_ = this.getFkPkEqJoinConjuncts(eqJoinConjunctSlots);
        if (this.fkPkEqJoinConjuncts_ != null) {
            return JoinNode.getFkPkJoinCardinality(this.fkPkEqJoinConjuncts_, lhsCard, rhsCard);
        }
        return this.getGenericJoinCardinality(eqJoinConjunctSlots, otherEqJoinStats, lhsCard, rhsCard, analyzer);
    }

    private List<EqJoinConjunctScanSlots> getFkPkEqJoinConjuncts(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots) {
        Preconditions.checkState((!eqJoinConjunctSlots.isEmpty() ? 1 : 0) != 0);
        Map<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>> scanSlotsByJoinedTids = EqJoinConjunctScanSlots.groupByJoinedTupleIds(eqJoinConjunctSlots);
        ArrayList<EqJoinConjunctScanSlots> result = null;
        for (List<EqJoinConjunctScanSlots> fkPkCandidate : scanSlotsByJoinedTids.values()) {
            double jointNdv = 1.0;
            for (EqJoinConjunctScanSlots slots : fkPkCandidate) {
                jointNdv *= slots.rhsNdv();
            }
            double rhsNumRows = fkPkCandidate.get(0).rhsNumRows();
            if (!(jointNdv >= (double)Math.round(rhsNumRows * 0.95))) continue;
            if (result == null) {
                result = new ArrayList<EqJoinConjunctScanSlots>();
            }
            result.addAll(fkPkCandidate);
        }
        return result;
    }

    protected static long getFkPkJoinCardinality(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots, long lhsCard, long rhsCard) {
        Preconditions.checkState((!eqJoinConjunctSlots.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((lhsCard >= 0L && rhsCard >= 0L ? 1 : 0) != 0);
        long result = -1L;
        for (EqJoinConjunctScanSlots slots : eqJoinConjunctSlots) {
            double ndvRatio = 1.0;
            if (slots.lhsNdv() > 0.0) {
                ndvRatio = slots.rhsNdv() / slots.lhsNdv();
            }
            double rhsSelectivity = Double.MIN_VALUE;
            if (slots.rhsNumRows() > 0.0) {
                rhsSelectivity = (double)rhsCard / slots.rhsNumRows();
            }
            long joinCard = (long)Math.ceil((double)lhsCard * rhsSelectivity * ndvRatio);
            if (result == -1L) {
                result = joinCard;
                continue;
            }
            result = Math.min(result, joinCard);
        }
        Preconditions.checkState(((result = Math.min(result, lhsCard)) >= 0L ? 1 : 0) != 0);
        return result;
    }

    private long getGenericJoinCardinality(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots, List<NdvAndRowCountStats> otherEqJoinStats, long lhsCard, long rhsCard, Analyzer analyzer) {
        Preconditions.checkState((this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin() ? 1 : 0) != 0);
        Preconditions.checkState((!eqJoinConjunctSlots.isEmpty() ? 1 : 0) != 0);
        ArrayList<Long> joinCardList = new ArrayList<Long>();
        for (EqJoinConjunctScanSlots slots : eqJoinConjunctSlots) {
            joinCardList.add(JoinNode.computeGenericJoinCardinality(slots.lhsNdv(), slots.rhsNdv(), slots.lhsNumRows(), slots.rhsNumRows(), lhsCard, rhsCard));
        }
        if (!otherEqJoinStats.isEmpty() && (this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin())) {
            joinCardList.add(this.getGenericJoinCardinality2(otherEqJoinStats, lhsCard, rhsCard, analyzer));
        }
        long result = -1L;
        double corrfactor = analyzer.getQueryOptions().getJoin_selectivity_correlation_factor();
        double cumulativeSel = 1.0;
        for (Long joinCard : joinCardList) {
            result = result == -1L ? joinCard : Math.min(result, joinCard);
            if (!(corrfactor > 0.0)) continue;
            cumulativeSel *= (double)joinCard.longValue() / (double)lhsCard / (double)rhsCard;
        }
        if (corrfactor > 0.0) {
            result = (long)Math.min((double)result, cumulativeSel * (double)lhsCard * (double)rhsCard / corrfactor);
        }
        Preconditions.checkState((result >= 0L ? 1 : 0) != 0);
        return result;
    }

    public static long computeGenericJoinCardinality(double lhsNdv, double rhsNdv, double lhsNumRows, double rhsNumRows, long lhsCard, long rhsCard) {
        Preconditions.checkState((lhsCard >= 0L && rhsCard >= 0L ? 1 : 0) != 0);
        double lhsAdjNdv = lhsNdv;
        if (lhsNumRows > (double)lhsCard) {
            lhsAdjNdv *= (double)lhsCard / lhsNumRows;
        }
        double rhsAdjNdv = rhsNdv;
        if (rhsNumRows > (double)rhsCard) {
            rhsAdjNdv *= (double)rhsCard / rhsNumRows;
        }
        long joinCard = Math.round((double)lhsCard / Math.max(1.0, Math.max(lhsAdjNdv, rhsAdjNdv)) * (double)rhsCard);
        return joinCard;
    }

    private long getGenericJoinCardinality2(List<NdvAndRowCountStats> statsList, long lhsCard, long rhsCard, Analyzer analyzer) {
        Preconditions.checkState((this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin() ? 1 : 0) != 0);
        Preconditions.checkState((!statsList.isEmpty() ? 1 : 0) != 0);
        long result = -1L;
        double corrfactor = analyzer.getQueryOptions().getJoin_selectivity_correlation_factor();
        double cumulativeSel = 1.0;
        for (NdvAndRowCountStats stats : statsList) {
            long joinCard = JoinNode.computeGenericJoinCardinality(stats.lhsNdv(), stats.rhsNdv(), stats.lhsNumRows(), stats.rhsNumRows(), lhsCard, rhsCard);
            result = result == -1L ? joinCard : Math.min(result, joinCard);
            if (!(corrfactor > 0.0)) continue;
            cumulativeSel *= (double)joinCard / (double)lhsCard / (double)rhsCard;
        }
        if (corrfactor > 0.0) {
            result = (long)Math.min((double)result, cumulativeSel * (double)lhsCard * (double)rhsCard / corrfactor);
        }
        Preconditions.checkState((result >= 0L ? 1 : 0) != 0);
        return result;
    }

    private long getSemiJoinCardinality() {
        long cardinality;
        Preconditions.checkState((boolean)this.joinOp_.isSemiJoin());
        if (this.joinOp_ == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp_ == JoinOperator.RIGHT_ANTI_JOIN) {
            if (((PlanNode)this.getChild((int)1)).cardinality_ == -1L) {
                return -1L;
            }
            cardinality = ((PlanNode)this.getChild((int)1)).cardinality_;
        } else {
            if (((PlanNode)this.getChild((int)0)).cardinality_ == -1L) {
                return -1L;
            }
            cardinality = ((PlanNode)this.getChild((int)0)).cardinality_;
        }
        double minSelectivity = 1.0;
        for (Expr expr : this.eqJoinConjuncts_) {
            long lhsNdv = JoinNode.getNdv((Expr)expr.getChild(0));
            lhsNdv = Math.min(lhsNdv, ((PlanNode)this.getChild((int)0)).cardinality_);
            long rhsNdv = JoinNode.getNdv((Expr)expr.getChild(1));
            rhsNdv = Math.min(rhsNdv, ((PlanNode)this.getChild((int)1)).cardinality_);
            if (lhsNdv == -1L || rhsNdv == -1L) continue;
            double selectivity = 1.0;
            switch (this.joinOp_) {
                case LEFT_SEMI_JOIN: {
                    selectivity = (double)Math.min(lhsNdv, rhsNdv) / (double)lhsNdv;
                    break;
                }
                case RIGHT_SEMI_JOIN: {
                    selectivity = (double)Math.min(lhsNdv, rhsNdv) / (double)rhsNdv;
                    break;
                }
                case LEFT_ANTI_JOIN: 
                case NULL_AWARE_LEFT_ANTI_JOIN: 
                case ICEBERG_DELETE_JOIN: {
                    selectivity = (double)Math.max(lhsNdv - rhsNdv, lhsNdv) / (double)lhsNdv;
                    break;
                }
                case RIGHT_ANTI_JOIN: {
                    selectivity = (double)Math.max(rhsNdv - lhsNdv, rhsNdv) / (double)rhsNdv;
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false);
                }
            }
            minSelectivity = Math.min(minSelectivity, selectivity);
        }
        Preconditions.checkState((cardinality != -1L ? 1 : 0) != 0);
        return Math.round((double)cardinality * minSelectivity);
    }

    public static long getNdv(Expr expr) {
        ColumnStats stats = ColumnStats.fromExpr(expr);
        if (!stats.hasNumDistinctValues()) {
            return -1L;
        }
        return stats.getNumDistinctValues();
    }

    public void recomputeNodes() {
        this.numNodes_ = ((PlanNode)this.getChild((int)0)).numNodes_;
        this.numInstances_ = ((PlanNode)this.getChild((int)0)).numInstances_;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        long rightCard;
        long leftCard;
        super.computeStats(analyzer);
        if (this.joinOp_.isSemiJoin()) {
            this.cardinality_ = this.getSemiJoinCardinality();
        } else if (this.joinOp_.isInnerJoin() || this.joinOp_.isOuterJoin()) {
            this.cardinality_ = this.getJoinCardinality(analyzer);
        } else {
            Preconditions.checkState((boolean)this.joinOp_.isCrossJoin());
            leftCard = ((PlanNode)this.getChild((int)0)).cardinality_;
            rightCard = ((PlanNode)this.getChild((int)1)).cardinality_;
            if (leftCard != -1L && rightCard != -1L) {
                this.cardinality_ = MathUtil.multiplyCardinalities(leftCard, rightCard);
            }
        }
        leftCard = ((PlanNode)this.getChild((int)0)).cardinality_;
        rightCard = ((PlanNode)this.getChild((int)1)).cardinality_;
        switch (this.joinOp_) {
            case INNER_JOIN: {
                break;
            }
            case LEFT_SEMI_JOIN: {
                if (leftCard == -1L) break;
                this.cardinality_ = Math.min(leftCard, this.cardinality_);
                break;
            }
            case RIGHT_SEMI_JOIN: {
                if (rightCard == -1L) break;
                this.cardinality_ = Math.min(rightCard, this.cardinality_);
                break;
            }
            case LEFT_OUTER_JOIN: {
                if (leftCard == -1L) break;
                this.cardinality_ = Math.max(leftCard, this.cardinality_);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                if (rightCard == -1L) break;
                this.cardinality_ = Math.max(rightCard, this.cardinality_);
                break;
            }
            case FULL_OUTER_JOIN: {
                if (leftCard == -1L || rightCard == -1L) break;
                long cardinalitySum = MathUtil.addCardinalities(leftCard, rightCard);
                this.cardinality_ = Math.max(cardinalitySum, this.cardinality_);
                break;
            }
            case LEFT_ANTI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: 
            case ICEBERG_DELETE_JOIN: {
                if (leftCard == -1L) break;
                this.cardinality_ = Math.min(leftCard, this.cardinality_);
                break;
            }
            case RIGHT_ANTI_JOIN: {
                if (rightCard == -1L) break;
                this.cardinality_ = Math.min(rightCard, this.cardinality_);
                break;
            }
            case CROSS_JOIN: {
                this.cardinality_ = ((PlanNode)this.getChild((int)0)).cardinality_ == -1L || ((PlanNode)this.getChild((int)1)).cardinality_ == -1L ? -1L : MathUtil.multiplyCardinalities(((PlanNode)this.getChild((int)0)).cardinality_, ((PlanNode)this.getChild((int)1)).cardinality_);
            }
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        Preconditions.checkState((boolean)this.hasValidStats());
        if (LOG.isTraceEnabled()) {
            LOG.trace("stats Join: cardinality=" + Long.toString(this.cardinality_));
        }
    }

    public void invertJoin() {
        this.joinOp_ = this.joinOp_.invert();
        Collections.swap(this.children_, 0, 1);
        for (BinaryPredicate p : this.eqJoinConjuncts_) {
            p.reverse();
        }
    }

    @Override
    protected String getDisplayLabelDetail() {
        StringBuilder output = new StringBuilder(this.joinOp_.toString());
        if (this.distrMode_ != DistributionMode.NONE) {
            output.append(", " + this.distrMode_.toString());
        }
        return output.toString();
    }

    protected void orderJoinConjunctsByCost() {
        this.conjuncts_ = JoinNode.orderConjunctsByCost(this.conjuncts_);
        this.eqJoinConjuncts_ = JoinNode.orderConjunctsByCost(this.eqJoinConjuncts_);
        this.otherJoinConjuncts_ = JoinNode.orderConjunctsByCost(this.otherJoinConjuncts_);
    }

    @Override
    public PlanNode.ExecPhaseResourceProfiles computeTreeResourceProfiles(TQueryOptions queryOptions) {
        ResourceProfile finishedBuildProfile;
        ResourceProfile buildPhaseProfile;
        Preconditions.checkState((boolean)this.isBlockingJoinNode(), (Object)"Only blocking join nodes supported");
        PlanNode.ExecPhaseResourceProfiles probeSideProfile = ((PlanNode)this.getChild(0)).computeTreeResourceProfiles(queryOptions);
        if (this.hasSeparateBuild()) {
            buildPhaseProfile = this.nodeResourceProfile_;
            finishedBuildProfile = this.nodeResourceProfile_;
        } else {
            PlanNode.ExecPhaseResourceProfiles buildSideProfile = ((PlanNode)this.getChild(1)).computeTreeResourceProfiles(queryOptions);
            buildPhaseProfile = buildSideProfile.duringOpenProfile.max(buildSideProfile.postOpenProfile.sum(this.nodeResourceProfile_));
            finishedBuildProfile = this.nodeResourceProfile_;
            if (this instanceof NestedLoopJoinNode) {
                finishedBuildProfile = buildSideProfile.postOpenProfile.sum(this.nodeResourceProfile_);
            }
        }
        ResourceProfile duringOpenProfile = buildPhaseProfile.sum(probeSideProfile.duringOpenProfile);
        ResourceProfile probePhaseProfile = finishedBuildProfile.sum(probeSideProfile.postOpenProfile);
        return new PlanNode.ExecPhaseResourceProfiles(duringOpenProfile, probePhaseProfile);
    }

    @Override
    public void computePipelineMembership() {
        ((PlanNode)this.children_.get(0)).computePipelineMembership();
        ((PlanNode)this.children_.get(1)).computePipelineMembership();
        this.pipelines_ = new ArrayList();
        for (PipelineMembership probePipeline : ((PlanNode)this.children_.get(0)).getPipelines()) {
            if (probePipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
            this.pipelines_.add(new PipelineMembership(probePipeline.getId(), probePipeline.getHeight() + 1, TExecNodePhase.GETNEXT));
        }
        for (PipelineMembership buildPipeline : ((PlanNode)this.children_.get(1)).getPipelines()) {
            if (buildPipeline.getPhase() != TExecNodePhase.GETNEXT) continue;
            this.pipelines_.add(new PipelineMembership(buildPipeline.getId(), buildPipeline.getHeight() + 1, TExecNodePhase.OPEN));
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature.");
    }

    protected TJoinNode joinNodeToThrift(ThriftSerializationCtx serialCtx) {
        if (this.distrMode_ == DistributionMode.PARTITIONED) {
            LOG.trace("{} ineligible for caching because it is a partitioned exchange", (Object)this);
            serialCtx.setTupleCachingIneligible(TupleCacheInfo.IneligibilityReason.PARTITIONED_EXCHANGE);
        }
        TJoinNode result = new TJoinNode(this.joinOp_.toThrift());
        List<TupleId> buildTupleIds = ((PlanNode)this.getChild(1)).getTupleIds();
        result.setBuild_tuples(new ArrayList<Integer>(buildTupleIds.size()));
        result.setNullable_build_tuples(new ArrayList<Boolean>(buildTupleIds.size()));
        for (TupleId tid : buildTupleIds) {
            result.addToBuild_tuples(serialCtx.translateTupleId(tid).asInt());
            result.addToNullable_build_tuples(((PlanNode)this.getChild(1)).getNullableTupleIds().contains(tid));
        }
        return result;
    }

    public List<TEqJoinCondition> getThriftEquiJoinConjuncts(ThriftSerializationCtx serialCtx) {
        ArrayList<TEqJoinCondition> equiJoinConjuncts = new ArrayList<TEqJoinCondition>(this.eqJoinConjuncts_.size());
        for (BinaryPredicate bp : this.eqJoinConjuncts_) {
            TEqJoinCondition eqJoinCondition = new TEqJoinCondition(((Expr)bp.getChild(0)).treeToThrift(serialCtx), ((Expr)bp.getChild(1)).treeToThrift(serialCtx), bp.getOp() == BinaryPredicate.Operator.NOT_DISTINCT);
            equiJoinConjuncts.add(eqJoinCondition);
        }
        return equiJoinConjuncts;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        Pair<ProcessingCost, ProcessingCost> probeBuildCost = this.computeJoinProcessingCost();
        this.processingCost_ = this.hasSeparateBuild() ? (ProcessingCost)probeBuildCost.first : ProcessingCost.sumCost((ProcessingCost)probeBuildCost.first, (ProcessingCost)probeBuildCost.second);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        Pair<ResourceProfile, ResourceProfile> profiles = this.computeJoinResourceProfile(queryOptions);
        this.nodeResourceProfile_ = this.hasSeparateBuild() ? (ResourceProfile)profiles.first : ((ResourceProfile)profiles.first).combine((ResourceProfile)profiles.second);
    }

    public PlanNode getBuildNode() {
        Preconditions.checkState((this.getChildCount() == 2 ? 1 : 0) != 0);
        return (PlanNode)this.getChild(1);
    }

    public abstract Pair<ResourceProfile, ResourceProfile> computeJoinResourceProfile(TQueryOptions var1);

    public abstract Pair<ProcessingCost, ProcessingCost> computeJoinProcessingCost();

    protected long getProbeCardinalityForCosting() {
        return Math.max(0L, ((PlanNode)this.getChild(0)).getFilteredCardinality());
    }

    @Override
    protected void reduceCardinalityByRuntimeFilter(Stack<PlanNode> nodeStack, double reductionScale) {
        if (this.isSelectiveAndReducingJoin()) {
            nodeStack.add(this);
        } else {
            nodeStack.clear();
        }
        int i = 0;
        for (PlanNode child : this.getChildren()) {
            if (i > 0) {
                nodeStack.clear();
            }
            child.reduceCardinalityByRuntimeFilter(nodeStack, reductionScale);
            ++i;
        }
    }

    private boolean isSelectiveAndReducingJoin() {
        if (this.eqJoinConjuncts_.isEmpty() || ((PlanNode)this.getChild(0)).getCardinality() < 0L || ((PlanNode)this.getChild(1)).getCardinality() < 0L || !this.joinOp_.isInnerJoin() && !this.joinOp_.isLeftOuterJoin() && !this.joinOp_.isLeftSemiJoin()) {
            return false;
        }
        double selectivity = RuntimeFilterGenerator.getJoinNodeSelectivity(this);
        return 0.0 <= selectivity && selectivity <= 1.0;
    }

    @Override
    public boolean isTupleCachingImplemented() {
        return true;
    }

    public static final class NdvAndRowCountStats {
        private final long lhsNdv_;
        private final long rhsNdv_;
        private final long lhsNumRows_;
        private final long rhsNumRows_;

        public NdvAndRowCountStats(long lhsNdv, long rhsNdv, long lhsNumRows, long rhsNumRows) {
            this.lhsNdv_ = Math.min(lhsNdv, lhsNumRows);
            this.rhsNdv_ = Math.min(rhsNdv, rhsNumRows);
            this.lhsNumRows_ = lhsNumRows;
            this.rhsNumRows_ = rhsNumRows;
        }

        public double lhsNdv() {
            return this.lhsNdv_;
        }

        public double rhsNdv() {
            return this.rhsNdv_;
        }

        public double lhsNumRows() {
            return this.lhsNumRows_;
        }

        public double rhsNumRows() {
            return this.rhsNumRows_;
        }
    }

    public static final class EqJoinConjunctScanSlots {
        private final Expr eqJoinConjunct_;
        protected final SlotDescriptor lhs_;
        protected final SlotDescriptor rhs_;

        private EqJoinConjunctScanSlots(Expr eqJoinConjunct, SlotDescriptor lhs, SlotDescriptor rhs) {
            this.eqJoinConjunct_ = eqJoinConjunct;
            this.lhs_ = lhs;
            this.rhs_ = rhs;
        }

        public double lhsNdv() {
            return Math.min((double)this.lhs_.getStats().getNumDistinctValues(), this.lhsNumRows());
        }

        public double rhsNdv() {
            return Math.min((double)this.rhs_.getStats().getNumDistinctValues(), this.rhsNumRows());
        }

        public double lhsNumRows() {
            return this.lhs_.getParent().getTable().getNumRows();
        }

        public double rhsNumRows() {
            return this.rhs_.getParent().getTable().getNumRows();
        }

        public TupleId lhsTid() {
            return this.lhs_.getParent().getId();
        }

        public TupleId rhsTid() {
            return this.rhs_.getParent().getId();
        }

        public static EqJoinConjunctScanSlots create(Expr eqJoinConjunct, List<NdvAndRowCountStats> otherEqJoinConjuncts, long lhsCard, long rhsCard) {
            long rhsNdv;
            SlotDescriptor rhsScanSlot;
            if (!Expr.IS_EQ_BINARY_PREDICATE.apply((Object)eqJoinConjunct)) {
                return null;
            }
            SlotDescriptor lhsScanSlot = ((Expr)eqJoinConjunct.getChild(0)).findSrcScanSlot();
            boolean hasLhs = true;
            boolean hasRhs = true;
            if (lhsScanSlot == null || !EqJoinConjunctScanSlots.hasNumRowsAndNdvStats(lhsScanSlot)) {
                hasLhs = false;
            }
            if ((rhsScanSlot = ((Expr)eqJoinConjunct.getChild(1)).findSrcScanSlot()) == null || !EqJoinConjunctScanSlots.hasNumRowsAndNdvStats(rhsScanSlot)) {
                hasRhs = false;
            }
            if (hasLhs && hasRhs) {
                return new EqJoinConjunctScanSlots(eqJoinConjunct, lhsScanSlot, rhsScanSlot);
            }
            Expr lhsExpr = (Expr)eqJoinConjunct.getChild(0);
            Expr rhsExpr = (Expr)eqJoinConjunct.getChild(1);
            if (!hasLhs && (lhsExpr = lhsExpr.getSlotDescFirstSourceExpr()) == null) {
                return null;
            }
            if (!hasRhs && (rhsExpr = rhsExpr.getSlotDescFirstSourceExpr()) == null) {
                return null;
            }
            if (lhsExpr instanceof AnalyticExpr || rhsExpr instanceof AnalyticExpr) {
                return null;
            }
            long lhsNdv = lhsScanSlot != null ? lhsScanSlot.getStats().getNumDistinctValues() : JoinNode.getNdv((Expr)eqJoinConjunct.getChild(0));
            long l = rhsNdv = rhsScanSlot != null ? rhsScanSlot.getStats().getNumDistinctValues() : JoinNode.getNdv((Expr)eqJoinConjunct.getChild(1));
            if (lhsNdv == -1L || rhsNdv == -1L) {
                return null;
            }
            long lhsNumRows = lhsScanSlot != null && EqJoinConjunctScanSlots.hasNumRowsStats(lhsScanSlot) ? lhsScanSlot.getParent().getTable().getNumRows() : lhsCard;
            long rhsNumRows = rhsScanSlot != null && EqJoinConjunctScanSlots.hasNumRowsStats(rhsScanSlot) ? rhsScanSlot.getParent().getTable().getNumRows() : rhsCard;
            otherEqJoinConjuncts.add(new NdvAndRowCountStats(lhsNdv, rhsNdv, lhsNumRows, rhsNumRows));
            return null;
        }

        private static boolean hasNumRowsAndNdvStats(SlotDescriptor slotDesc) {
            return EqJoinConjunctScanSlots.hasNdvStats(slotDesc) && EqJoinConjunctScanSlots.hasNumRowsStats(slotDesc);
        }

        private static boolean hasNdvStats(SlotDescriptor slotDesc) {
            if (slotDesc.getColumn() == null) {
                return false;
            }
            return slotDesc.getStats().hasNumDistinctValues();
        }

        private static boolean hasNumRowsStats(SlotDescriptor slotDesc) {
            FeTable tbl = slotDesc.getParent().getTable();
            return tbl != null && tbl.getNumRows() != -1L;
        }

        public static Map<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>> groupByJoinedTupleIds(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots) {
            LinkedHashMap<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>> scanSlotsByJoinedTids = new LinkedHashMap<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>>();
            for (EqJoinConjunctScanSlots slots : eqJoinConjunctSlots) {
                Pair<TupleId, TupleId> tids = Pair.create(slots.lhsTid(), slots.rhsTid());
                ArrayList<EqJoinConjunctScanSlots> scanSlots = (ArrayList<EqJoinConjunctScanSlots>)scanSlotsByJoinedTids.get(tids);
                if (scanSlots == null) {
                    scanSlots = new ArrayList<EqJoinConjunctScanSlots>();
                    scanSlotsByJoinedTids.put(tids, scanSlots);
                }
                scanSlots.add(slots);
            }
            return scanSlotsByJoinedTids;
        }

        public String toString() {
            return this.eqJoinConjunct_.toSql();
        }
    }

    public static enum DistributionMode {
        NONE("NONE"),
        BROADCAST("BROADCAST"),
        PARTITIONED("PARTITIONED"),
        DIRECTED("DIRECTED");

        private final String description_;

        private DistributionMode(String description) {
            this.description_ = description;
        }

        public String toString() {
            return this.description_;
        }

        public static DistributionMode fromThrift(TJoinDistributionMode distrMode) {
            switch (distrMode) {
                case BROADCAST: {
                    return BROADCAST;
                }
                case SHUFFLE: {
                    return PARTITIONED;
                }
                case DIRECTED: {
                    return DIRECTED;
                }
            }
            throw new RuntimeException("Invalid distribution mode: " + (Object)((Object)distrMode));
        }
    }
}

