/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Snapshot;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergScanNode
extends HdfsScanNode {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergScanNode.class);
    private List<IcebergFileDescriptor> fileDescs_;
    private int numIcebergPartitions_;
    private boolean filesAreSorted_ = false;
    private List<Expr> nonIdentityConjuncts_;
    private List<Expr> skippedConjuncts_;
    private final long snapshotId_;
    private final PlanNodeId deleteFileScanNodeId;

    public IcebergScanNode(PlanNodeId id, TableRef tblRef, List<Expr> conjuncts, MultiAggregateInfo aggInfo, List<IcebergFileDescriptor> fileDescs, int numPartitions, List<Expr> nonIdentityConjuncts, List<Expr> skippedConjuncts, long snapshotId) {
        this(id, tblRef, conjuncts, aggInfo, fileDescs, numPartitions, nonIdentityConjuncts, skippedConjuncts, null, snapshotId);
    }

    public IcebergScanNode(PlanNodeId id, TableRef tblRef, List<Expr> conjuncts, MultiAggregateInfo aggInfo, List<IcebergFileDescriptor> fileDescs, int numPartitions, List<Expr> nonIdentityConjuncts, List<Expr> skippedConjuncts, PlanNodeId deleteId, long snapshotId) {
        super(id, tblRef.getDesc(), conjuncts, IcebergScanNode.getIcebergPartition(((FeIcebergTable)tblRef.getTable()).getFeFsTable()), tblRef, aggInfo, null, false);
        Preconditions.checkState((this.partitions_.size() == 1 ? 1 : 0) != 0);
        this.fileDescs_ = fileDescs;
        this.numIcebergPartitions_ = numPartitions;
        if (((FeIcebergTable)tblRef.getTable()).isPartitioned()) {
            this.fileDescs_ = new ArrayList<IcebergFileDescriptor>(this.fileDescs_);
            Collections.sort(this.fileDescs_);
            this.filesAreSorted_ = true;
        }
        this.nonIdentityConjuncts_ = nonIdentityConjuncts;
        this.snapshotId_ = snapshotId;
        this.skippedConjuncts_ = skippedConjuncts;
        this.deleteFileScanNodeId = deleteId;
    }

    @Override
    protected void computeCardinalities(Analyzer analyzer) {
        this.cardinality_ = 0L;
        if (this.sampledFiles_ != null) {
            for (List sampledFileDescs : this.sampledFiles_.values()) {
                for (FileDescriptor fd : sampledFileDescs) {
                    Preconditions.checkState((boolean)(fd instanceof IcebergFileDescriptor));
                    IcebergFileDescriptor iceFd = (IcebergFileDescriptor)fd;
                    this.cardinality_ = MathUtil.addCardinalities(this.cardinality_, iceFd.getFbFileMetadata().icebergMetadata().recordCount());
                }
            }
        } else {
            for (IcebergFileDescriptor fd : this.fileDescs_) {
                this.cardinality_ = MathUtil.addCardinalities(this.cardinality_, fd.getFbFileMetadata().icebergMetadata().recordCount());
            }
        }
        if (this.cardinality_ > 0L) {
            for (Type t : this.desc_.getPath().getMatchedTypes()) {
                if (!t.isCollectionType()) continue;
                this.cardinality_ = MathUtil.multiplyCardinalities(this.cardinality_, 10L);
            }
        }
        this.inputCardinality_ = this.cardinality_ = Math.max(-1L, this.cardinality_);
        if (this.cardinality_ > 0L) {
            double selectivity = IcebergScanNode.computeCombinedSelectivity(this.nonIdentityConjuncts_);
            if (LOG.isTraceEnabled()) {
                LOG.trace("cardinality_=" + Long.toString(this.cardinality_) + " sel=" + Double.toString(selectivity));
            }
            this.cardinality_ = this.applySelectivity(this.cardinality_, selectivity);
        }
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        if (this.countStarSlot_ != null) {
            this.inputCardinality_ = this.fileDescs_.size();
            this.cardinality_ = this.fileDescs_.size();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("IcebergScanNode: cardinality_=" + Long.toString(this.cardinality_));
        }
    }

    private static List<? extends FeFsPartition> getIcebergPartition(FeFsTable feFsTable) {
        Collection<? extends FeFsPartition> partitions = feFsTable.loadAllPartitions();
        return new ArrayList<FeFsPartition>(partitions);
    }

    @Override
    protected List<FileDescriptor> getFileDescriptorsWithLimit(FeFsPartition partition, boolean fsHasBlocks, long limit) {
        if (limit != -1L) {
            long cnt = 0L;
            ArrayList<FileDescriptor> ret = new ArrayList<FileDescriptor>();
            for (IcebergFileDescriptor fd : this.fileDescs_) {
                if (cnt == limit) break;
                ret.add(fd);
                ++cnt;
            }
            return ret;
        }
        return new ArrayList<FileDescriptor>(this.fileDescs_);
    }

    @Override
    protected Map<Long, List<FileDescriptor>> getFilesSample(long percentBytes, long minSampleBytes, long randomSeed) {
        return FeIcebergTable.Utils.getFilesSample((FeIcebergTable)this.tbl_, this.fileDescs_, this.filesAreSorted_, percentBytes, minSampleBytes, randomSeed);
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        super.toThrift(msg, serialCtx);
        Preconditions.checkNotNull((Object)msg.hdfs_scan_node);
        if (this.deleteFileScanNodeId != null) {
            msg.hdfs_scan_node.setDeleteFileScanNodeId(this.deleteFileScanNodeId.asInt());
        }
    }

    @Override
    protected long getNumSelectedPartitions(long partsPerFs) {
        BitSet selectedPartitions = new BitSet(this.numIcebergPartitions_);
        for (FileDescriptor fileDescriptor : this.fileDescs_) {
            selectedPartitions.set(((IcebergFileDescriptor)fileDescriptor).getFbFileMetadata().icebergMetadata().partId());
        }
        return selectedPartitions.cardinality();
    }

    @Override
    protected String getNumPartitionString(FeFsTable table) {
        Preconditions.checkState((boolean)(table instanceof FeIcebergTable));
        Snapshot currentSnapshot = ((FeIcebergTable)table).getIcebergApiTable().currentSnapshot();
        if (currentSnapshot != null && this.snapshotId_ != currentSnapshot.snapshotId()) {
            return "unknown";
        }
        return Integer.toString(this.numIcebergPartitions_);
    }

    @Override
    protected String getDerivedExplainString(String indentPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(indentPrefix + "Iceberg snapshot id: " + String.valueOf(this.snapshotId_) + "\n");
        if (!this.skippedConjuncts_.isEmpty()) {
            output.append(indentPrefix + String.format("skipped Iceberg predicates: %s\n", Expr.getExplainString(this.skippedConjuncts_, detailLevel)));
        }
        return output.toString();
    }

    @Override
    protected void populateFileFormats() throws ImpalaRuntimeException {
        boolean hasParquet = false;
        boolean hasOrc = false;
        boolean hasAvro = false;
        for (IcebergFileDescriptor fileDesc : this.fileDescs_) {
            byte fileFormat = fileDesc.getFbFileMetadata().icebergMetadata().fileFormat();
            if (fileFormat == 0) {
                hasParquet = true;
                continue;
            }
            if (fileFormat == 1) {
                hasOrc = true;
                continue;
            }
            if (fileFormat == 2) {
                hasAvro = true;
                continue;
            }
            throw new ImpalaRuntimeException(String.format("Invalid Iceberg file format of file: %s", fileDesc.getAbsolutePath()));
        }
        if (hasParquet) {
            this.fileFormats_.add(HdfsFileFormat.PARQUET);
        }
        if (hasOrc) {
            this.fileFormats_.add(HdfsFileFormat.ORC);
        }
        if (hasAvro) {
            this.fileFormats_.add(HdfsFileFormat.AVRO);
        }
    }
}

