/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TIcebergMergeCase;
import org.apache.impala.thrift.TIcebergMergeNode;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;

public class IcebergMergeNode
extends PlanNode {
    private final List<MergeCase> cases_;
    private final Expr rowPresent_;
    private List<Expr> deleteMetaExprs_;
    private List<Expr> partitionMetaExprs_;
    private final TupleDescriptor mergeActionTuple_;
    private final TupleId targetTupleId_;

    public IcebergMergeNode(PlanNodeId id, PlanNode child, List<MergeCase> cases, Expr rowPresent, List<Expr> deleteMetaExprs, List<Expr> partitionMetaExprs, TupleDescriptor mergeActionTuple, TupleId targetTupleId) {
        super(id, "MERGE");
        this.cases_ = cases;
        this.rowPresent_ = rowPresent;
        this.deleteMetaExprs_ = deleteMetaExprs;
        this.partitionMetaExprs_ = partitionMetaExprs;
        this.mergeActionTuple_ = mergeActionTuple;
        this.targetTupleId_ = targetTupleId;
        Preconditions.checkState((boolean)(child instanceof JoinNode));
        this.addChild(child);
        this.computeTupleIds();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        ArrayList<TIcebergMergeCase> mergeCases = new ArrayList<TIcebergMergeCase>();
        for (MergeCase mergeCase : this.cases_) {
            TIcebergMergeCase tMergeCase = new TIcebergMergeCase(Expr.treesToThrift(mergeCase.getResultExprs()), mergeCase.caseType(), mergeCase.matchType());
            if (!mergeCase.getFilterExprs().isEmpty()) {
                tMergeCase.setFilter_conjuncts(Expr.treesToThrift(mergeCase.getFilterExprs()));
            }
            mergeCases.add(tMergeCase);
        }
        TIcebergMergeNode mergeNode = new TIcebergMergeNode(mergeCases, this.rowPresent_.treeToThrift(), Expr.treesToThrift(this.deleteMetaExprs_), Expr.treesToThrift(this.partitionMetaExprs_), this.mergeActionTuple_.getId().asInt(), this.targetTupleId_.asInt());
        msg.setMerge_node(mergeNode);
        msg.setNode_type(TPlanNodeType.ICEBERG_MERGE_NODE);
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        super.init(analyzer);
        this.mergeActionTuple_.computeMemLayout();
        for (MergeCase mergeCase : this.cases_) {
            mergeCase.substituteResultExprs(this.getOutputSmap(), analyzer);
        }
        this.partitionMetaExprs_ = Expr.substituteList(this.partitionMetaExprs_, this.getOutputSmap(), analyzer, true);
        this.deleteMetaExprs_ = Expr.substituteList(this.deleteMetaExprs_, this.getOutputSmap(), analyzer, true);
        this.rowPresent_.substitute(this.getOutputSmap(), analyzer, true);
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.tupleIds_.add(this.mergeActionTuple_.getId());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (((PlanNode)this.getChild((int)0)).cardinality_ == -1L) {
            this.cardinality_ = -1L;
        } else {
            this.cardinality_ = this.applyConjunctsSelectivity(((PlanNode)this.getChild((int)0)).cardinality_);
            Preconditions.checkState((this.cardinality_ >= 0L ? 1 : 0) != 0);
        }
    }

    @Override
    protected String getNodeExplainString(String rootPrefix, String detailPrefix, TExplainLevel detailLevel) {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(String.format("%s%s", rootPrefix, this.getDisplayLabel()));
        for (int i = 0; i < this.cases_.size(); ++i) {
            MergeCase mergeCase = this.cases_.get(i);
            joiner.add(String.format("%sCASE %d: %s", detailPrefix, i, this.cases_.get(i).matchTypeAsString()));
            for (String detail : mergeCase.getExplainStrings(detailLevel)) {
                joiner.add(String.format("%s%s%s", detailPrefix, detailPrefix, detail));
            }
        }
        return joiner + "\n";
    }
}

