/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Expr;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.TableSink;
import org.apache.impala.thrift.TDataSink;
import org.apache.impala.thrift.TDataSinkType;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.THdfsTableSink;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTableSink;
import org.apache.impala.thrift.TTableSinkType;
import org.apache.impala.util.BitUtil;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTableSink
extends TableSink {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsTableSink.class);
    public static final String PARQUET_BLOOM_FILTER_WRITING_TBL_PROPERTY = "parquet.bloom.filter.columns";
    public static final long PARQUET_BLOOM_FILTER_MAX_BYTES = 0x8000000L;
    public static final long PARQUET_BLOOM_FILTER_MIN_BYTES = 64L;
    public static final int MIN_WRITE_BYTES = 0x10000000;
    protected final long DEFAULT_NUM_PARTITIONS = 10L;
    private static final double COST_COEFFICIENT_PARQUET_BYTES_INSERTED = 0.117;
    private static final double PARQUET_FIXED_INSERT_COST = 3954235.0;
    private static final double COST_COEFFICIENT_DEFAULT_BYTES_INSERTED = 0.2916;
    private static final double DEFAULT_FIXED_INSERT_COST = 3621898.0;
    protected final List<Expr> partitionKeyExprs_;
    protected final boolean overwrite_;
    protected final boolean inputIsClustered_;
    protected final boolean isResultSink_;
    public static final Set<HdfsFileFormat> SUPPORTED_FILE_FORMATS = ImmutableSet.of((Object)((Object)HdfsFileFormat.PARQUET), (Object)((Object)HdfsFileFormat.TEXT), (Object)((Object)HdfsFileFormat.RC_FILE), (Object)((Object)HdfsFileFormat.SEQUENCE_FILE), (Object)((Object)HdfsFileFormat.AVRO), (Object)((Object)HdfsFileFormat.ICEBERG), (Object[])new HdfsFileFormat[0]);
    private List<Integer> sortColumns_ = new ArrayList<Integer>();
    private TSortingOrder sortingOrder_;
    private long writeId_;
    private int maxHdfsSinks_;
    protected String externalOutputDir_;
    private int externalOutputPartitionDepth_;

    public HdfsTableSink(FeTable targetTable, List<Expr> partitionKeyExprs, List<Expr> outputExprs, boolean overwrite, boolean inputIsClustered, Pair<List<Integer>, TSortingOrder> sortProperties, long writeId, int maxTableSinks, boolean isResultSink) {
        super(targetTable, TableSink.Op.INSERT, outputExprs);
        Preconditions.checkState((boolean)(targetTable instanceof FeFsTable));
        this.partitionKeyExprs_ = partitionKeyExprs;
        this.overwrite_ = overwrite;
        this.inputIsClustered_ = inputIsClustered;
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        this.writeId_ = writeId;
        this.maxHdfsSinks_ = maxTableSinks;
        this.isResultSink_ = isResultSink;
    }

    public void setExternalOutputDir(String externalOutputDir) {
        this.externalOutputDir_ = externalOutputDir;
    }

    public void setExternalOutputPartitionDepth(int partitionDepth) {
        this.externalOutputPartitionDepth_ = partitionDepth;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        String fileFormat;
        PlanNode inputNode = this.fragment_.getPlanRoot();
        long cardinality = Math.max(0L, inputNode.getCardinality());
        float avgRowDataSize = inputNode.getAvgRowSizeWithoutPad();
        long estBytesInserted = (long)Math.ceil((double)avgRowDataSize * (double)cardinality);
        double totalCost = 0.0;
        FeFsTable table = (FeFsTable)this.targetTable_;
        Set<HdfsFileFormat> formats = table.getFileFormats();
        if (formats.contains((Object)HdfsFileFormat.PARQUET) || formats.contains((Object)HdfsFileFormat.ICEBERG)) {
            fileFormat = "PARQUET";
            totalCost = (double)estBytesInserted * 0.117 + 3954235.0;
        } else {
            fileFormat = "NON-PARQUET";
            totalCost = (double)estBytesInserted * 0.2916 + 3621898.0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("HdfsTableSink insert CPU cost estimate: " + totalCost + ", File Format: " + fileFormat + ", Cardinality: " + cardinality + ", Estimated Bytes Inserted: " + estBytesInserted);
        }
        this.processingCost_ = ProcessingCost.basicCost(this.getLabel(), totalCost);
    }

    @Override
    public void computeResourceProfile(TQueryOptions queryOptions) {
        long perInstanceMemEstimate;
        long numBufferedPartitionsPerInstance;
        PlanNode inputNode = this.fragment_.getPlanRoot();
        int numInstances = this.fragment_.getNumInstances();
        if (this.inputIsClustered_) {
            numBufferedPartitionsPerInstance = 1L;
        } else {
            numBufferedPartitionsPerInstance = this.fragment_.getPerInstanceNdv(this.partitionKeyExprs_, false);
            if (numBufferedPartitionsPerInstance == -1L) {
                numBufferedPartitionsPerInstance = 10L;
            }
        }
        FeFsTable table = (FeFsTable)this.targetTable_;
        Set<HdfsFileFormat> formats = table.getFileFormats();
        long perPartitionMemReq = this.getPerPartitionMemReq(formats);
        if (inputNode.getCardinality() == -1L || inputNode.getAvgRowSize() == -1.0f) {
            perInstanceMemEstimate = numBufferedPartitionsPerInstance * perPartitionMemReq;
        } else {
            long perInstanceInputCardinality = Math.max(1L, inputNode.getCardinality() / (long)numInstances);
            long perInstanceInputBytes = (long)Math.ceil((float)perInstanceInputCardinality * inputNode.getAvgRowSize());
            long perInstanceMemReq = MathUtil.multiplyCardinalities(numBufferedPartitionsPerInstance, perPartitionMemReq);
            perInstanceMemEstimate = Math.min(perInstanceInputBytes, perInstanceMemReq);
        }
        this.resourceProfile_ = ResourceProfile.noReservation(perInstanceMemEstimate);
    }

    private long getPerPartitionMemReq(Set<HdfsFileFormat> formats) {
        if (formats.contains((Object)HdfsFileFormat.PARQUET)) {
            return 0x40000000L;
        }
        return 102400L;
    }

    @Override
    public void appendSinkExplainString(String prefix, String detailPrefix, TQueryOptions queryOptions, TExplainLevel explainLevel, StringBuilder output) {
        String overwriteStr = ", OVERWRITE=" + (this.overwrite_ ? "true" : "false");
        String partitionKeyStr = "";
        if (!this.partitionKeyExprs_.isEmpty()) {
            StringBuilder tmpBuilder = new StringBuilder(", PARTITION-KEYS=(");
            for (Expr expr : this.partitionKeyExprs_) {
                tmpBuilder.append(expr.toSql() + ",");
            }
            tmpBuilder.deleteCharAt(tmpBuilder.length() - 1);
            tmpBuilder.append(")");
            partitionKeyStr = tmpBuilder.toString();
        }
        output.append(String.format("%sWRITE TO HDFS [%s%s%s]\n", prefix, this.targetTable_.getFullName(), overwriteStr, partitionKeyStr));
        if (!(this.targetTable_ instanceof FeIcebergTable) && explainLevel.ordinal() > TExplainLevel.MINIMAL.ordinal()) {
            long totalNumPartitions = Expr.getNumDistinctValues(this.partitionKeyExprs_);
            if (totalNumPartitions == -1L) {
                output.append(detailPrefix + "partitions=unavailable");
            } else {
                output.append(detailPrefix + "partitions=" + (totalNumPartitions == 0L ? 1L : totalNumPartitions));
            }
            output.append("\n");
        }
        if (explainLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal()) {
            output.append(detailPrefix + "output exprs: ").append(Expr.getExplainString(this.outputExprs_, explainLevel) + "\n");
        }
    }

    @Override
    protected String getLabel() {
        return "HDFS WRITER";
    }

    @VisibleForTesting
    static Map<String, Long> parseParquetBloomFilterWritingTblProp(String tbl_prop) {
        String[] colSizePairs;
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String colSizePair : colSizePairs = tbl_prop.split(",")) {
            long size;
            String[] tokens = colSizePair.split(":");
            if (tokens.length == 0 || tokens.length > 2) {
                String err = "Invalid token in table property parquet.bloom.filter.columns: " + colSizePair.trim() + ". Expected either a column name or a column name and a size separated by a colon (';').";
                LOG.warn(err);
                return null;
            }
            if (tokens.length == 1) {
                size = 0x8000000L;
            } else {
                assert (tokens.length == 2);
                try {
                    size = Long.parseLong(tokens[1].trim());
                }
                catch (NumberFormatException e) {
                    String err = "Invalid bitset size in table property parquet.bloom.filter.columns: " + tokens[1].trim();
                    LOG.warn(err);
                    return null;
                }
                size = Long.max(64L, size);
                size = Long.min(0x8000000L, size);
                size = BitUtil.roundUpToPowerOf2(size);
            }
            result.put(tokens[0].trim(), size);
        }
        return result;
    }

    @Override
    protected void toThriftImpl(TDataSink tsink) {
        Table msTbl;
        Map params;
        String parquetBloomTblProp;
        THdfsTableSink hdfsTableSink = new THdfsTableSink(Expr.treesToThrift(this.partitionKeyExprs_), this.overwrite_, this.inputIsClustered_, this.sortingOrder_);
        FeFsTable table = (FeFsTable)this.targetTable_;
        StringBuilder error = new StringBuilder();
        int skipHeaderLineCount = table.parseSkipHeaderLineCount(error);
        Preconditions.checkState((error.length() == 0 ? 1 : 0) != 0);
        if (skipHeaderLineCount > 0) {
            hdfsTableSink.setSkip_header_line_count(skipHeaderLineCount);
        }
        if ((parquetBloomTblProp = (String)(params = (msTbl = table.getMetaStoreTable()).getParameters()).get(PARQUET_BLOOM_FILTER_WRITING_TBL_PROPERTY)) != null) {
            Map<String, Long> parsedProperties = HdfsTableSink.parseParquetBloomFilterWritingTblProp(parquetBloomTblProp);
            hdfsTableSink.setParquet_bloom_filter_col_info(parsedProperties);
        }
        hdfsTableSink.setSort_columns(this.sortColumns_);
        hdfsTableSink.setSorting_order(this.sortingOrder_);
        hdfsTableSink.setIs_result_sink(this.isResultSink_);
        if (this.externalOutputDir_ != null) {
            hdfsTableSink.setExternal_output_dir(this.externalOutputDir_);
            hdfsTableSink.setExternal_output_partition_depth(this.externalOutputPartitionDepth_);
        }
        if (this.writeId_ != -1L) {
            hdfsTableSink.setWrite_id(this.writeId_);
        }
        TTableSink tTableSink = new TTableSink(0, TTableSinkType.HDFS, this.sinkOp_.toThrift());
        tTableSink.hdfs_table_sink = hdfsTableSink;
        tsink.table_sink = tTableSink;
        tsink.output_exprs = Expr.treesToThrift(this.outputExprs_);
    }

    @Override
    protected TDataSinkType getSinkType() {
        return TDataSinkType.TABLE_SINK;
    }

    @Override
    public void collectExprs(List<Expr> exprs) {
        if (!(this.targetTable_ instanceof FeIcebergTable)) {
            exprs.addAll(this.partitionKeyExprs_);
        }
        if (this.isResultSink_) {
            exprs.addAll(this.outputExprs_);
        } else {
            exprs.addAll(this.outputExprs_.subList(0, this.targetTable_.getNonClusteringColumns().size()));
        }
    }

    public int getNumNodes() {
        int num_nodes = this.getFragment().getPlanRoot().getNumNodes();
        if (this.maxHdfsSinks_ > 0) {
            num_nodes = Math.min(num_nodes, this.getNumInstances());
        }
        return num_nodes;
    }

    public int getNumInstances() {
        int num_instances = this.getFragment().getPlanRoot().getNumInstances();
        if (this.maxHdfsSinks_ > 0) {
            num_instances = Math.min(num_instances, this.maxHdfsSinks_);
        }
        return num_instances;
    }

    @Override
    public void computeRowConsumptionAndProductionToCost() {
        super.computeRowConsumptionAndProductionToCost();
        this.fragment_.setFixedInstanceCount(this.fragment_.getNumInstances());
    }

    public static int bytesBasedNumWriters(int numInputNodes, int maxNumWriters, boolean isPartitioned, long totalNumPartitions, long inputCardinality, double avgRowSize) {
        Preconditions.checkArgument((maxNumWriters > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((inputCardinality >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((avgRowSize >= 0.0 ? 1 : 0) != 0);
        if (inputCardinality == 0L) {
            return 1;
        }
        long byteBasedNumWriters = Math.round(avgRowSize / 2.68435456E8 * (double)inputCardinality);
        if (isPartitioned && totalNumPartitions > 0L) {
            if (totalNumPartitions == 1L) {
                byteBasedNumWriters = numInputNodes;
            } else {
                long minWriters = Math.min((long)numInputNodes, totalNumPartitions);
                long maxWriters = totalNumPartitions;
                byteBasedNumWriters = Math.max(minWriters, byteBasedNumWriters);
                byteBasedNumWriters = Math.min(maxWriters, byteBasedNumWriters);
            }
        }
        return (int)Math.max(1L, Math.min((long)maxNumWriters, byteBasedNumWriters));
    }
}

