/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.MathUtil;

public class HdfsEstimatedMissingTableStats {
    public final int numPartitionsWithNumRows_;
    public final boolean hasCorruptTableStats_;
    public final long partitionNumRows_;
    public final long statsNumRows_;
    private double DEFAULT_ROW_WIDTH_ESTIMATE = 1.0;
    private static double ESTIMATED_COMPRESSION_FACTOR_UNCOMPRESSED = 1.0;
    private static double ESTIMATED_COMPRESSION_FACTOR_LEGACY = 3.58;
    private static double ESTIMATED_COMPRESSION_FACTOR_COLUMNAR = 4.97;
    private static Set<HdfsFileFormat> VALID_LEGACY_FORMATS = ImmutableSet.builder().add((Object)HdfsFileFormat.RC_FILE).add((Object)HdfsFileFormat.TEXT).add((Object)HdfsFileFormat.SEQUENCE_FILE).add((Object)HdfsFileFormat.AVRO).add((Object)HdfsFileFormat.JSON).build();

    public HdfsEstimatedMissingTableStats() {
        this.numPartitionsWithNumRows_ = 0;
        this.hasCorruptTableStats_ = false;
        this.partitionNumRows_ = -1L;
        this.statsNumRows_ = -1L;
    }

    public HdfsEstimatedMissingTableStats(TQueryOptions queryOptions, FeFsTable tbl, Collection<? extends FeFsPartition> partitions, long tableNumRowsHint) {
        int numPartitionsWithNumRows = 0;
        boolean hasCorruptTableStats = false;
        long partitionNumRows = -1L;
        ArrayList<FeFsPartition> partitionsWithCorruptOrMissingStats = new ArrayList<FeFsPartition>();
        for (FeFsPartition feFsPartition : partitions) {
            long partNumRows = feFsPartition.getNumRows();
            if (partNumRows < -1L || partNumRows == 0L && feFsPartition.getSize() > 0L) {
                hasCorruptTableStats = true;
                partitionsWithCorruptOrMissingStats.add(feFsPartition);
                continue;
            }
            if (partNumRows == -1L) {
                partitionsWithCorruptOrMissingStats.add(feFsPartition);
                continue;
            }
            if (partNumRows <= -1L) continue;
            if (partitionNumRows == -1L) {
                partitionNumRows = 0L;
            }
            partitionNumRows = MathUtil.addCardinalities(partitionNumRows, partNumRows);
            ++numPartitionsWithNumRows;
        }
        if (partitionsWithCorruptOrMissingStats.size() == 0 && numPartitionsWithNumRows > 0) {
            this.partitionNumRows_ = partitionNumRows;
            this.hasCorruptTableStats_ = hasCorruptTableStats;
            this.numPartitionsWithNumRows_ = numPartitionsWithNumRows;
            this.statsNumRows_ = this.partitionNumRows_;
            return;
        }
        long numRows = tbl.getNumRows();
        if (!queryOptions.disable_hdfs_num_rows_estimate && (numRows == -1L || hasCorruptTableStats) && tableNumRowsHint == -1L) {
            long estimatedTableSize = this.computeEstimatedTableSize(partitionsWithCorruptOrMissingStats);
            double sumAvgRowSizes = 0.0;
            for (Column col : tbl.getColumns()) {
                Type currentType = col.getType();
                if (!(currentType instanceof ScalarType)) continue;
                if (col.getStats().hasAvgSize()) {
                    sumAvgRowSizes += col.getStats().getAvgSerializedSize();
                    continue;
                }
                sumAvgRowSizes += (double)col.getType().getSlotSize();
            }
            long estNumRows = 0L;
            estNumRows = sumAvgRowSizes == 0.0 ? Math.round((double)estimatedTableSize / this.DEFAULT_ROW_WIDTH_ESTIMATE) : Math.round((double)estimatedTableSize / sumAvgRowSizes);
            partitionNumRows = partitionNumRows > 0L ? partitionNumRows + estNumRows : estNumRows;
            numRows = partitionNumRows;
        }
        if (numRows < -1L || numRows == 0L && tbl.getTotalHdfsBytes() > 0L) {
            hasCorruptTableStats = true;
        }
        this.partitionNumRows_ = partitionNumRows;
        this.hasCorruptTableStats_ = hasCorruptTableStats;
        this.numPartitionsWithNumRows_ = numPartitionsWithNumRows;
        this.statsNumRows_ = numRows >= 0L && !hasCorruptTableStats || tableNumRowsHint == -1L ? numRows : tableNumRowsHint;
    }

    private long computeEstimatedTableSize(List<FeFsPartition> partitions) {
        long estimatedTableSize = 0L;
        for (FeFsPartition p : partitions) {
            HdfsFileFormat format = p.getFileFormat();
            long estimatedPartitionSize = 0L;
            if (format == HdfsFileFormat.TEXT || format == HdfsFileFormat.JSON) {
                for (FileDescriptor desc : p.getFileDescriptors()) {
                    HdfsCompression compression = HdfsCompression.fromFileName(desc.getPath());
                    if (HdfsCompression.SUFFIX_MAP.containsValue((Object)compression)) {
                        estimatedPartitionSize += Math.round((double)desc.getFileLength() * ESTIMATED_COMPRESSION_FACTOR_LEGACY);
                        continue;
                    }
                    estimatedPartitionSize += Math.round((double)desc.getFileLength() * ESTIMATED_COMPRESSION_FACTOR_UNCOMPRESSED);
                }
            } else if (VALID_LEGACY_FORMATS.contains((Object)format)) {
                estimatedPartitionSize += Math.round((double)p.getSize() * ESTIMATED_COMPRESSION_FACTOR_LEGACY);
            } else {
                Preconditions.checkState((boolean)HdfsScanNode.VALID_COLUMNAR_FORMATS.contains((Object)format), (String)"Unknown HDFS compressed format: %s", (Object)((Object)format), (Object)this);
                estimatedPartitionSize += Math.round((double)p.getSize() * ESTIMATED_COMPRESSION_FACTOR_COLUMNAR);
            }
            estimatedTableSize += estimatedPartitionSize;
        }
        return estimatedTableSize;
    }
}

