/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.impala.common.Id;
import org.apache.impala.common.Pair;
import org.apache.impala.common.TreeNode;
import org.apache.impala.planner.CoreCount;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanFragmentId;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.UnionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostingSegment
extends TreeNode<CostingSegment> {
    private static final Logger LOG = LoggerFactory.getLogger(CostingSegment.class);
    private List<PlanNode> nodes_ = Lists.newArrayList();
    private ProcessingCost cost_;
    private DataSink sink_ = null;

    public CostingSegment(DataSink sink) {
        Preconditions.checkArgument((boolean)sink.getProcessingCost().isValid());
        this.cost_ = sink.getProcessingCost();
        this.sink_ = sink;
    }

    public CostingSegment(PlanNode node) {
        Preconditions.checkArgument((boolean)node.getProcessingCost().isValid());
        this.cost_ = node.getProcessingCost();
        this.nodes_.add(node);
    }

    private CostingSegment() {
        this.cost_ = ProcessingCost.zero();
    }

    public ProcessingCost getProcessingCost() {
        return this.cost_;
    }

    public boolean isOutputSegment() {
        return this.sink_ != null;
    }

    private Id getRootId() {
        if (this.isOutputSegment()) {
            return this.sink_.getFragment().getId();
        }
        Preconditions.checkState((!this.nodes_.isEmpty() ? 1 : 0) != 0);
        return this.nodes_.get(this.nodes_.size() - 1).getId();
    }

    private CoreCount createCoreCount(boolean isUnbounded) {
        PlanFragment fragment;
        PlanNode topNode = null;
        if (this.isOutputSegment()) {
            fragment = this.sink_.getFragment();
        } else {
            Preconditions.checkState((!this.nodes_.isEmpty() ? 1 : 0) != 0);
            topNode = this.nodes_.get(this.nodes_.size() - 1);
            fragment = topNode.getFragment();
        }
        int maxParallelism = this.cost_.getNumInstancesExpected();
        if (isUnbounded) {
            maxParallelism = fragment.getMaxParallelism();
            UnionNode unionNode = fragment.getUnionNode();
            if (unionNode != null) {
                maxParallelism = fragment.getMaxParallelismForUnionFragment(unionNode, true, null);
            }
        }
        if (topNode == null) {
            return new CoreCount(this.sink_.getFragment(), maxParallelism);
        }
        Preconditions.checkNotNull(topNode);
        return new CoreCount(topNode, maxParallelism);
    }

    private void appendCost(ProcessingCost additionalCost) {
        Preconditions.checkArgument((boolean)additionalCost.isValid(), (String)"additionalCost is invalid! %s", (Object)additionalCost);
        ProcessingCost newTotalCost = ProcessingCost.sumCost(additionalCost, this.cost_);
        newTotalCost.setNumRowToConsume(this.cost_.getNumRowToConsume());
        newTotalCost.setNumRowToProduce(additionalCost.getNumRowToConsume());
        this.cost_ = newTotalCost;
    }

    protected void setSink(DataSink sink) {
        this.appendCost(sink.getProcessingCost());
        this.sink_ = sink;
    }

    protected void appendNode(PlanNode node) {
        this.appendCost(node.getProcessingCost());
        this.nodes_.add(node);
    }

    protected CoreCount traverseBlockingAwareCores(Map<PlanFragmentId, Pair<CoreCount, List<CoreCount>>> fragmentCoreState, ImmutableList.Builder<CoreCount> subtreeCoreBuilder, boolean findUnboundedCount) {
        CoreCount segmentCore = this.createCoreCount(findUnboundedCount);
        for (CostingSegment childSegment : this.getChildren()) {
            CoreCount childSegmentCores = childSegment.traverseBlockingAwareCores(fragmentCoreState, subtreeCoreBuilder, findUnboundedCount);
            if (childSegmentCores.total() <= 0) continue;
            segmentCore = CoreCount.max(segmentCore, childSegmentCores);
        }
        for (PlanNode node : this.nodes_) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                PlanFragment childFragment = ((PlanNode)node.getChild(i)).getFragment();
                if (childFragment == node.getFragment()) continue;
                Pair<CoreCount, List<CoreCount>> childCores = fragmentCoreState.get(childFragment.getId());
                Preconditions.checkNotNull(childCores);
                if (childFragment.hasBlockingNode()) {
                    CoreCount childCoreCount = childFragment.maxCore((CoreCount)childCores.first, CoreCount.sum((List)childCores.second), findUnboundedCount);
                    subtreeCoreBuilder.add((Object)childCoreCount);
                    continue;
                }
                Preconditions.checkState((boolean)(node instanceof ExchangeNode));
                Preconditions.checkState((i == 0 ? 1 : 0) != 0);
                segmentCore = CoreCount.sum(segmentCore, (CoreCount)childCores.first);
                subtreeCoreBuilder.addAll((Iterable)childCores.second);
            }
        }
        return segmentCore;
    }

    protected int tryAdjustParallelism(int nodeStepCount, int minParallelism, int maxParallelism) {
        List<ProcessingCost> childOutputCosts;
        int newParallelism = minParallelism;
        int originalParallelism = this.cost_.getNumInstancesExpected();
        ProcessingCost producerCost = ProcessingCost.zero();
        if (this.getChildCount() > 0) {
            for (CostingSegment childSegment : this.getChildren()) {
                newParallelism = Math.max(newParallelism, childSegment.tryAdjustParallelism(nodeStepCount, minParallelism, maxParallelism));
            }
            producerCost = CostingSegment.mergeCostingSegment(this.getChildren()).getProcessingCost();
        }
        if (!(childOutputCosts = this.nodes_.stream().filter(Predicates.instanceOf(ExchangeNode.class)).map(p -> ((PlanNode)p.getChild(0)).getFragment().getLastCostingSegment()).collect(Collectors.toList())).isEmpty()) {
            if (producerCost.getTotalCost() > 0L) {
                childOutputCosts.add(producerCost);
            }
            producerCost = ProcessingCost.fullMergeCosts(childOutputCosts);
        }
        ProcessingCost.tryAdjustConsumerParallelism(nodeStepCount, minParallelism, maxParallelism, producerCost, this.cost_);
        newParallelism = Math.max(newParallelism, this.cost_.getNumInstancesExpected());
        Preconditions.checkState((newParallelism <= maxParallelism ? 1 : 0) != 0, (Object)(this.getRootId() + " originalParallelism=" + originalParallelism + ". newParallelism=" + newParallelism + " > maxParallelism=" + maxParallelism));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adjust ProcessingCost on {}. originalParallelism={} minParallelism={} maxParallelism={} newParallelism={} consumerCost={} consumerInstCount={} producerCost={} producerInstCount={}", new Object[]{this.getRootId(), originalParallelism, minParallelism, maxParallelism, newParallelism, this.cost_.getTotalCost(), this.cost_.getNumInstancesExpected(), producerCost.getTotalCost(), producerCost.getNumInstancesExpected()});
        }
        return newParallelism;
    }

    protected static CostingSegment mergeCostingSegment(List<CostingSegment> costingSegments) {
        Preconditions.checkNotNull(costingSegments);
        Preconditions.checkArgument((!costingSegments.isEmpty() ? 1 : 0) != 0);
        if (costingSegments.size() == 1) {
            return costingSegments.get(0);
        }
        CostingSegment mergedCost = new CostingSegment();
        ArrayList allCosts = Lists.newArrayList();
        for (CostingSegment costingSegment : costingSegments) {
            Preconditions.checkArgument((!costingSegment.isOutputSegment() ? 1 : 0) != 0);
            mergedCost.nodes_.addAll(costingSegment.nodes_);
            mergedCost.addChildren(costingSegment.getChildren());
            allCosts.add(costingSegment.getProcessingCost());
        }
        mergedCost.cost_ = ProcessingCost.fullMergeCosts(allCosts);
        return mergedCost;
    }
}

