/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.thrift.TCardinalityCheckNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;

public class CardinalityCheckNode
extends PlanNode {
    private final String displayStatement_;

    public CardinalityCheckNode(PlanNodeId id, PlanNode child, String displayStmt) {
        super(id, "CARDINALITY CHECK");
        Preconditions.checkState((child.getLimit() <= 2L ? 1 : 0) != 0);
        this.cardinality_ = 1L;
        this.limit_ = 1L;
        this.displayStatement_ = displayStmt;
        this.addChild(child);
        this.computeTupleIds();
    }

    @Override
    public void init(Analyzer analyzer) throws ImpalaException {
        this.computeStats(analyzer);
        this.createDefaultSmap(analyzer);
    }

    @Override
    public boolean isBlockingNode() {
        return true;
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tblRefIds_.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.CARDINALITY_CHECK_NODE;
        TCardinalityCheckNode cardinalityCheckNode = new TCardinalityCheckNode(this.displayStatement_);
        msg.setCardinality_check_node(cardinalityCheckNode);
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = this.computeDefaultProcessingCost();
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.nodeResourceProfile_ = ResourceProfile.noReservation(0L);
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        return String.format("%s%s:%s\n", prefix, this.id_.toString(), this.displayName_);
    }
}

