/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.impala.analysis.AggregateInfoBase;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.AnalyticInfo;
import org.apache.impala.analysis.AnalyticWindow;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.AnalyticEvalNode;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.EmptySetNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SortNode;
import org.apache.impala.thrift.TSortingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticPlanner.class);
    private final AnalyticInfo analyticInfo_;
    private final Analyzer analyzer_;
    private final PlannerContext ctx_;

    public AnalyticPlanner(AnalyticInfo analyticInfo, Analyzer analyzer, PlannerContext ctx) {
        this.analyticInfo_ = analyticInfo;
        this.analyzer_ = analyzer;
        this.ctx_ = ctx;
    }

    public PlanNode createSingleNodePlan(PlanNode root, List<Expr> groupingExprs, List<Expr> inputPartitionExprs, List<TupleIsNullPredicate> tupleIsNullPreds) throws ImpalaException {
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        if (!(root instanceof EmptySetNode)) {
            tids.addAll(root.getTupleIds());
        }
        tids.add(this.analyticInfo_.getOutputTupleId());
        List<Expr> analyticConjs = this.analyzer_.getUnassignedConjuncts(tids);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Analytic conjuncts: " + Expr.listToSql(analyticConjs, ToSqlOptions.SHOW_IMPLICIT_CASTS));
        }
        List<PartitionLimit> perPartitionLimits = this.inferPartitionLimits(analyticConjs);
        List<WindowGroup> windowGroups = this.collectWindowGroups();
        for (int i = 0; i < windowGroups.size(); ++i) {
            windowGroups.get(i).init(this.analyzer_, "wg-" + i);
        }
        List<SortGroup> sortGroups = this.collectSortGroups(windowGroups);
        this.mergeSortGroups(sortGroups);
        for (SortGroup g : sortGroups) {
            g.init();
        }
        List<PartitionGroup> partitionGroups = this.collectPartitionGroups(sortGroups);
        this.mergePartitionGroups(partitionGroups, root.getNumInstances());
        this.orderGroups(partitionGroups);
        if (groupingExprs != null) {
            Preconditions.checkNotNull(inputPartitionExprs);
            this.computeInputPartitionExprs(partitionGroups, groupingExprs, root.getNumInstances(), inputPartitionExprs);
        }
        ArrayList<TupleIsNullPredicate> emptyPreds = new ArrayList<TupleIsNullPredicate>();
        for (int i = 0; i < partitionGroups.size(); ++i) {
            PartitionGroup partitionGroup = partitionGroups.get(i);
            for (int j = 0; j < partitionGroup.sortGroups.size(); ++j) {
                boolean firstSortGroup = i == 0 && j == 0;
                boolean lastSortGroup = i == partitionGroups.size() - 1 && j == partitionGroup.sortGroups.size() - 1;
                root = this.createSortGroupPlan(root, partitionGroup.sortGroups.get(j), j == 0 ? partitionGroup.partitionByExprs : null, lastSortGroup ? perPartitionLimits : null, firstSortGroup ? tupleIsNullPreds : emptyPreds);
            }
        }
        List<Expr> substAnalyticConjs = Expr.substituteList(analyticConjs, root.getOutputSmap(), this.analyzer_, false);
        this.overrideSelectivityPushedLimits(analyticConjs, perPartitionLimits, substAnalyticConjs);
        return root.addConjunctsToNode(this.ctx_, this.analyzer_, tids, substAnalyticConjs);
    }

    public PlanNode createSingleNodePlan(PlanNode root, List<Expr> groupingExprs, List<Expr> inputPartitionExprs) throws ImpalaException {
        return this.createSingleNodePlan(root, groupingExprs, inputPartitionExprs, AnalyticPlanner.getTupleIsNullPreds(root));
    }

    private static List<TupleIsNullPredicate> getTupleIsNullPreds(PlanNode planNode) {
        if (planNode.getOutputSmap() == null) {
            return new ArrayList<TupleIsNullPredicate>();
        }
        return TupleIsNullPredicate.getUniqueBoundTupleIsNullPredicates(planNode.getOutputSmap().getRhs(), planNode.getTupleIds());
    }

    private void overrideSelectivityPushedLimits(List<Expr> analyticConjs, List<PartitionLimit> perPartitionLimits, List<Expr> substAnalyticConjs) {
        for (PartitionLimit limit : perPartitionLimits) {
            int idx;
            if (!limit.pushed || !limit.isLessThan || (idx = analyticConjs.indexOf(limit.conjunct)) < 0) continue;
            substAnalyticConjs.set(idx, substAnalyticConjs.get(idx).cloneAndOverrideSelectivity(1.0));
        }
    }

    private void mergeSortGroups(List<SortGroup> sortGroups) {
        boolean hasMerged = false;
        block0: do {
            hasMerged = false;
            for (SortGroup sg1 : sortGroups) {
                for (SortGroup sg2 : sortGroups) {
                    if (sg1 == sg2 || !sg1.isPrefixOf(sg2)) continue;
                    sg1.absorb(sg2);
                    sortGroups.remove(sg2);
                    hasMerged = true;
                    break;
                }
                if (!hasMerged) continue;
                continue block0;
            }
        } while (hasMerged);
    }

    private void mergePartitionGroups(List<PartitionGroup> partitionGroups, int numInstances) {
        boolean hasMerged = false;
        block0: do {
            hasMerged = false;
            for (PartitionGroup pg1 : partitionGroups) {
                for (PartitionGroup pg2 : partitionGroups) {
                    long ndv;
                    if (pg1 == pg2 || (ndv = Expr.getNumDistinctValues(Expr.intersect(pg1.partitionByExprs, pg2.partitionByExprs))) == -1L || ndv < 0L || ndv < (long)numInstances) continue;
                    pg1.merge(pg2);
                    partitionGroups.remove(pg2);
                    hasMerged = true;
                    break;
                }
                if (!hasMerged) continue;
                continue block0;
            }
        } while (hasMerged);
    }

    private void computeInputPartitionExprs(List<PartitionGroup> partitionGroups, List<Expr> groupingExprs, int numInstances, List<Expr> inputPartitionExprs) {
        inputPartitionExprs.clear();
        Preconditions.checkState((numInstances != -1 ? 1 : 0) != 0);
        long maxNdv = 0L;
        PartitionGroup maxPg = null;
        ArrayList<Expr> maxGroupingExprs = null;
        for (PartitionGroup pg : partitionGroups) {
            ArrayList<Expr> l1 = new ArrayList<Expr>();
            ArrayList<Expr> l2 = new ArrayList<Expr>();
            this.analyzer_.exprIntersect(pg.partitionByExprs, groupingExprs, l1, l2);
            long ndv = Expr.getNumDistinctValues(l1);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Partition group: %s, intersection: %s. GroupingExprs: %s, intersection: %s. ndv: %d, numInstances: %d, maxNdv: %d.", Expr.debugString(pg.partitionByExprs), Expr.debugString(l1), Expr.debugString(groupingExprs), Expr.debugString(l2), ndv, numInstances, maxNdv));
            }
            if (ndv < 0L || ndv < (long)numInstances || ndv < maxNdv) continue;
            maxPg = pg;
            maxPg.partitionByExprs = l1;
            maxGroupingExprs = l2;
            maxNdv = ndv;
        }
        if (maxNdv > (long)numInstances) {
            Preconditions.checkNotNull(maxPg);
            partitionGroups.remove(maxPg);
            partitionGroups.add(0, maxPg);
            inputPartitionExprs.addAll(maxGroupingExprs);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Optimized partition exprs: " + Expr.debugString(inputPartitionExprs));
            }
        }
    }

    private void orderGroups(List<PartitionGroup> partitionGroups) {
        PartitionGroup nonPartitioning = null;
        for (PartitionGroup pg : partitionGroups) {
            if (!Expr.allConstant(pg.partitionByExprs)) continue;
            nonPartitioning = pg;
            break;
        }
        if (nonPartitioning != null) {
            partitionGroups.remove(nonPartitioning);
        }
        Collections.sort(partitionGroups, new Comparator<PartitionGroup>(){

            @Override
            public int compare(PartitionGroup pg1, PartitionGroup pg2) {
                Preconditions.checkState((pg1.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                Preconditions.checkState((pg2.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                int diff = pg1.totalOutputTupleSize - pg2.totalOutputTupleSize;
                return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
            }
        });
        if (nonPartitioning != null) {
            partitionGroups.add(nonPartitioning);
        }
        for (PartitionGroup pg : partitionGroups) {
            pg.orderSortGroups();
        }
    }

    private SortInfo createSortInfo(PlanNode input, List<Expr> sortExprs, List<Boolean> isAsc, List<Boolean> nullsFirst, List<TupleIsNullPredicate> tupleIsNullPreds) {
        return this.createSortInfo(input, sortExprs, isAsc, nullsFirst, tupleIsNullPreds, TSortingOrder.LEXICAL);
    }

    private SortInfo createSortInfo(PlanNode input, List<Expr> sortExprs, List<Boolean> isAsc, List<Boolean> nullsFirst, List<TupleIsNullPredicate> tupleIsNullPreds, TSortingOrder sortingOrder) {
        ArrayList<Expr> inputSlotRefs = new ArrayList<Expr>();
        for (TupleId tid : input.getTupleIds()) {
            TupleDescriptor tupleDesc = this.analyzer_.getTupleDesc(tid);
            for (SlotDescriptor inputSlotDesc : tupleDesc.getSlots()) {
                if (!inputSlotDesc.isFullyMaterialized()) continue;
                if (SortInfo.isValidInSortingTuple(inputSlotDesc.getType())) {
                    inputSlotRefs.add(new SlotRef(inputSlotDesc));
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Project out unsupported collection slot in sort tuple of analytic: slot={}", (Object)inputSlotDesc.debugString());
            }
        }
        ExprSubstitutionMap inputSmap = input.getOutputSmap();
        List<Expr> resolvedSortExprs = Expr.substituteList(sortExprs, inputSmap, this.analyzer_, true);
        SortInfo sortInfo = new SortInfo(resolvedSortExprs, isAsc, nullsFirst, sortingOrder);
        sortInfo.createSortTupleInfo(inputSlotRefs, this.analyzer_);
        sortInfo.addMaterializedExprs(tupleIsNullPreds, this.analyzer_);
        sortInfo.getSortTupleDescriptor().materializeSlots();
        return sortInfo;
    }

    private PlanNode createSortGroupPlan(PlanNode root, SortGroup sortGroup, List<Expr> partitionExprs, List<PartitionLimit> perPartitionLimits, List<TupleIsNullPredicate> tupleIsNullPreds) throws ImpalaException {
        List<Expr> partitionByExprs = sortGroup.partitionByExprs;
        List<OrderByElement> orderByElements = sortGroup.orderByElements;
        boolean hasActivePartition = !Expr.allConstant(partitionByExprs);
        boolean isConstSort = true;
        for (OrderByElement elmt : orderByElements) {
            isConstSort = isConstSort && elmt.getExpr().isConstant();
        }
        SortNode sortNode = null;
        if (hasActivePartition || !isConstSort) {
            ArrayList sortExprs = Lists.newArrayList(partitionByExprs);
            ArrayList isAsc = Lists.newArrayList(Collections.nCopies(sortExprs.size(), true));
            ArrayList nullsFirst = Lists.newArrayList(Collections.nCopies(sortExprs.size(), false));
            for (OrderByElement orderByElement : sortGroup.orderByElements) {
                if (sortExprs.contains(orderByElement.getExpr())) continue;
                sortExprs.add(orderByElement.getExpr());
                isAsc.add(orderByElement.isAsc());
                nullsFirst.add(orderByElement.getNullsFirstParam());
            }
            SortInfo sortInfo = this.createSortInfo(root, sortExprs, isAsc, nullsFirst, tupleIsNullPreds);
            if (sortInfo.getSortTupleDescriptor().getSlots().size() > 0) {
                PartitionLimit limit = null;
                if (perPartitionLimits != null && sortGroup.windowGroups.size() == 1) {
                    for (PartitionLimit p : perPartitionLimits) {
                        if (!sortGroup.windowGroups.get((int)0).analyticExprs.contains(p.analyticExpr) || limit != null && p.limit >= limit.limit) continue;
                        limit = p;
                    }
                }
                if (limit == null || limit.limit > this.analyzer_.getQueryOptions().analytic_rank_pushdown_threshold) {
                    sortNode = SortNode.createTotalSortNode(this.ctx_.getNextNodeId(), root, sortInfo, 0L);
                } else {
                    long planNodeLimit = Math.max(1L, limit.limit);
                    sortNode = Iterables.all(partitionByExprs, Expr.IS_LITERAL_VALUE) ? SortNode.createTopNSortNode(this.ctx_.getQueryOptions(), this.ctx_.getNextNodeId(), root, sortInfo, 0L, planNodeLimit, limit.includeTies) : SortNode.createPartitionedTopNSortNode(this.ctx_.getNextNodeId(), root, sortInfo, partitionByExprs.size(), planNodeLimit, limit.includeTies);
                    sortNode.setLimitSrcPred(limit.conjunct);
                    limit.markPushed();
                }
                if (hasActivePartition) {
                    sortNode.setIsAnalyticSort(true);
                }
                if (partitionExprs != null) {
                    DataPartition inputPartition = DataPartition.UNPARTITIONED;
                    if (hasActivePartition) {
                        inputPartition = DataPartition.hashPartitioned(partitionExprs);
                    }
                    sortNode.setInputPartition(inputPartition);
                }
                root = sortNode;
                root.init(this.analyzer_);
            }
        }
        AnalyticEvalNode lowestAnalyticNode = null;
        for (WindowGroup windowGroup : sortGroup.windowGroups) {
            root = new AnalyticEvalNode(this.ctx_.getNextNodeId(), root, windowGroup.analyticFnCalls, windowGroup.partitionByExprs, windowGroup.orderByElements, windowGroup.window, windowGroup.physicalIntermediateTuple, windowGroup.physicalOutputTuple, windowGroup.logicalToPhysicalSmap);
            root.init(this.analyzer_);
            if (lowestAnalyticNode != null) continue;
            lowestAnalyticNode = (AnalyticEvalNode)root;
            if (sortNode == null) continue;
            sortNode.setAnalyticEvalNode(lowestAnalyticNode);
        }
        return root;
    }

    private List<WindowGroup> collectWindowGroups() {
        List<AnalyticExpr> analyticExprs = this.analyticInfo_.getAnalyticExprs();
        ArrayList<WindowGroup> groups = new ArrayList<WindowGroup>();
        for (int i = 0; i < analyticExprs.size(); ++i) {
            AnalyticExpr analyticExpr = analyticExprs.get(i);
            if (!this.analyticInfo_.getOutputTupleDesc().getSlots().get(i).isMaterialized()) continue;
            boolean match = false;
            for (WindowGroup group : groups) {
                if (!group.isCompatible(analyticExpr)) continue;
                group.add(this.analyticInfo_.getAnalyticExprs().get(i), this.analyticInfo_.getOutputTupleDesc().getSlots().get(i), this.analyticInfo_.getIntermediateTupleDesc().getSlots().get(i));
                match = true;
                break;
            }
            if (match) continue;
            groups.add(new WindowGroup(this.analyticInfo_.getAnalyticExprs().get(i), this.analyticInfo_.getOutputTupleDesc().getSlots().get(i), this.analyticInfo_.getIntermediateTupleDesc().getSlots().get(i)));
        }
        return groups;
    }

    private List<SortGroup> collectSortGroups(List<WindowGroup> windowGroups) {
        ArrayList<SortGroup> sortGroups = new ArrayList<SortGroup>();
        for (WindowGroup windowGroup : windowGroups) {
            boolean match = false;
            for (SortGroup sortGroup : sortGroups) {
                if (!sortGroup.isCompatible(windowGroup)) continue;
                sortGroup.add(windowGroup);
                match = true;
                break;
            }
            if (match) continue;
            sortGroups.add(new SortGroup(windowGroup));
        }
        return sortGroups;
    }

    private List<PartitionGroup> collectPartitionGroups(List<SortGroup> sortGroups) {
        ArrayList<PartitionGroup> partitionGroups = new ArrayList<PartitionGroup>();
        for (SortGroup sortGroup : sortGroups) {
            boolean match = false;
            for (PartitionGroup partitionGroup : partitionGroups) {
                if (!partitionGroup.isCompatible(sortGroup)) continue;
                partitionGroup.add(sortGroup);
                match = true;
                break;
            }
            if (match) continue;
            partitionGroups.add(new PartitionGroup(sortGroup));
        }
        return partitionGroups;
    }

    private List<PartitionLimit> inferPartitionLimits(List<Expr> conjuncts) {
        ArrayList<PartitionLimit> result = new ArrayList<PartitionLimit>();
        if (this.analyzer_.getQueryOptions().analytic_rank_pushdown_threshold <= 0L) {
            return result;
        }
        for (Expr conj : conjuncts) {
            boolean isLessThan;
            long perPartitionLimit;
            BigDecimal val;
            AnalyticWindow window;
            boolean includeTies;
            List<Expr> lhsSourceExprs;
            if (!Expr.IS_BINARY_PREDICATE.apply((Object)conj)) continue;
            BinaryPredicate pred = (BinaryPredicate)conj;
            Expr lhs = (Expr)pred.getChild(0);
            Expr rhs = (Expr)pred.getChild(1);
            if (!(lhs instanceof SlotRef) || (lhsSourceExprs = ((SlotRef)lhs).getDesc().getSourceExprs()).size() != 1 || !(lhsSourceExprs.get(0) instanceof AnalyticExpr)) continue;
            AnalyticExpr analyticExpr = (AnalyticExpr)lhsSourceExprs.get(0);
            Function fn = analyticExpr.getFnCall().getFn();
            if (AnalyticExpr.isAnalyticFn(fn, AnalyticExpr.RANK)) {
                includeTies = true;
            } else {
                if (!AnalyticExpr.isAnalyticFn(fn, AnalyticExpr.ROWNUMBER)) continue;
                includeTies = false;
            }
            if ((window = analyticExpr.getWindow()).getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING || window.getRightBoundary().getType() != AnalyticWindow.BoundaryType.CURRENT_ROW || !(rhs instanceof NumericLiteral) || (val = ((NumericLiteral)rhs).getValue()).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) continue;
            long longVal = val.longValue();
            if (pred.getOp() == BinaryPredicate.Operator.EQ || pred.getOp() == BinaryPredicate.Operator.LE) {
                perPartitionLimit = longVal;
            } else {
                if (pred.getOp() != BinaryPredicate.Operator.LT) continue;
                perPartitionLimit = longVal - 1L;
            }
            boolean bl = isLessThan = pred.getOp() == BinaryPredicate.Operator.LE || pred.getOp() == BinaryPredicate.Operator.LT;
            if (LOG.isTraceEnabled()) {
                LOG.trace(analyticExpr.debugString() + " implies per-partition limit " + perPartitionLimit + " includeTies=" + includeTies);
            }
            result.add(new PartitionLimit(conj, analyticExpr, perPartitionLimit, includeTies, isLessThan));
        }
        return result;
    }

    private static class PartitionLimit {
        public final Expr conjunct;
        public final AnalyticExpr analyticExpr;
        public final long limit;
        public final boolean includeTies;
        public final boolean isLessThan;
        private boolean pushed;

        public PartitionLimit(Expr conjunct, AnalyticExpr analyticExpr, long limit, boolean includeTies, boolean isLessThan) {
            this.conjunct = conjunct;
            this.analyticExpr = analyticExpr;
            this.limit = limit;
            this.includeTies = includeTies;
            this.isLessThan = isLessThan;
            this.pushed = false;
        }

        public boolean isPushed() {
            return this.pushed;
        }

        public void markPushed() {
            this.pushed = true;
        }
    }

    private static class PartitionGroup {
        public List<Expr> partitionByExprs;
        public List<SortGroup> sortGroups = new ArrayList<SortGroup>();
        public int totalOutputTupleSize = -1;

        public PartitionGroup(SortGroup sortGroup) {
            this.partitionByExprs = sortGroup.partitionByExprs;
            this.sortGroups.add(sortGroup);
            this.totalOutputTupleSize = sortGroup.totalOutputTupleSize;
        }

        public boolean isCompatible(SortGroup sortGroup) {
            return Expr.equalSets(sortGroup.partitionByExprs, this.partitionByExprs);
        }

        public void add(SortGroup sortGroup) {
            Preconditions.checkState((boolean)this.isCompatible(sortGroup));
            this.sortGroups.add(sortGroup);
            this.totalOutputTupleSize += sortGroup.totalOutputTupleSize;
        }

        public void merge(PartitionGroup other) {
            this.partitionByExprs = Expr.intersect(this.partitionByExprs, other.partitionByExprs);
            Preconditions.checkState((Expr.getNumDistinctValues(this.partitionByExprs) >= 0L ? 1 : 0) != 0);
            this.sortGroups.addAll(other.sortGroups);
        }

        public void orderSortGroups() {
            Collections.sort(this.sortGroups, new Comparator<SortGroup>(){

                @Override
                public int compare(SortGroup sg1, SortGroup sg2) {
                    Preconditions.checkState((sg1.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                    Preconditions.checkState((sg2.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                    int diff = sg1.totalOutputTupleSize - sg2.totalOutputTupleSize;
                    return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
                }
            });
            for (SortGroup sortGroup : this.sortGroups) {
                sortGroup.orderWindowGroups();
            }
        }
    }

    private static class SortGroup {
        public List<Expr> partitionByExprs;
        public List<OrderByElement> orderByElements;
        public List<WindowGroup> windowGroups = new ArrayList<WindowGroup>();
        public int totalOutputTupleSize = -1;
        private static final SizeLt SIZE_LT = new SizeLt();

        public SortGroup(WindowGroup windowGroup) {
            this.partitionByExprs = windowGroup.partitionByExprs;
            this.orderByElements = windowGroup.orderByElements;
            this.windowGroups.add(windowGroup);
        }

        public boolean isCompatible(WindowGroup windowGroup) {
            return Expr.equalSets(windowGroup.partitionByExprs, this.partitionByExprs) && windowGroup.orderByElements.equals(this.orderByElements);
        }

        public void add(WindowGroup windowGroup) {
            Preconditions.checkState((boolean)this.isCompatible(windowGroup));
            this.windowGroups.add(windowGroup);
        }

        public boolean isPrefixOf(SortGroup other) {
            if (other.orderByElements.size() > this.orderByElements.size()) {
                return false;
            }
            if (!Expr.equalSets(this.partitionByExprs, other.partitionByExprs)) {
                return false;
            }
            for (int i = 0; i < other.orderByElements.size(); ++i) {
                OrderByElement ob = this.orderByElements.get(i);
                OrderByElement otherOb = other.orderByElements.get(i);
                if (!ob.getExpr().equals(otherOb.getExpr())) {
                    return false;
                }
                if (ob.isAsc() != otherOb.isAsc()) {
                    return false;
                }
                if (ob.nullsFirst() == otherOb.nullsFirst()) continue;
                return false;
            }
            return true;
        }

        public void absorb(SortGroup other) {
            Preconditions.checkState((boolean)this.isPrefixOf(other));
            this.windowGroups.addAll(other.windowGroups);
        }

        public void init() {
            this.totalOutputTupleSize = 0;
            for (WindowGroup g : this.windowGroups) {
                TupleDescriptor outputTuple = g.physicalOutputTuple;
                Preconditions.checkState((boolean)outputTuple.isMaterialized());
                Preconditions.checkState((outputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                this.totalOutputTupleSize += outputTuple.getByteSize();
            }
        }

        public void orderWindowGroups() {
            Collections.sort(this.windowGroups, SIZE_LT);
        }

        private static class SizeLt
        implements Comparator<WindowGroup> {
            private SizeLt() {
            }

            @Override
            public int compare(WindowGroup wg1, WindowGroup wg2) {
                Preconditions.checkState((wg1.physicalOutputTuple != null && wg1.physicalOutputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                Preconditions.checkState((wg2.physicalOutputTuple != null && wg2.physicalOutputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                int diff = wg1.physicalOutputTuple.getByteSize() - wg2.physicalOutputTuple.getByteSize();
                return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
            }
        }
    }

    private static class WindowGroup {
        public final List<Expr> partitionByExprs;
        public final List<OrderByElement> orderByElements;
        public final AnalyticWindow window;
        public final List<AnalyticExpr> analyticExprs = new ArrayList<AnalyticExpr>();
        public final List<Expr> analyticFnCalls = new ArrayList<Expr>();
        public final List<SlotDescriptor> logicalOutputSlots = new ArrayList<SlotDescriptor>();
        public final List<SlotDescriptor> logicalIntermediateSlots = new ArrayList<SlotDescriptor>();
        public TupleDescriptor physicalOutputTuple;
        public TupleDescriptor physicalIntermediateTuple;
        public final ExprSubstitutionMap logicalToPhysicalSmap = new ExprSubstitutionMap();

        public WindowGroup(AnalyticExpr analyticExpr, SlotDescriptor logicalOutputSlot, SlotDescriptor logicalIntermediateSlot) {
            this.partitionByExprs = analyticExpr.getPartitionExprs();
            this.orderByElements = analyticExpr.getOrderByElements();
            this.window = analyticExpr.getWindow();
            this.analyticExprs.add(analyticExpr);
            this.analyticFnCalls.add(analyticExpr.getFnCall());
            this.logicalOutputSlots.add(logicalOutputSlot);
            this.logicalIntermediateSlots.add(logicalIntermediateSlot);
        }

        private static boolean requiresIndependentEval(AnalyticExpr analyticExpr) {
            return analyticExpr.getFnCall().getFnName().getFunction().equals(AnalyticExpr.FIRST_VALUE_REWRITE);
        }

        public boolean isCompatible(AnalyticExpr analyticExpr) {
            if (WindowGroup.requiresIndependentEval(this.analyticExprs.get(0)) || WindowGroup.requiresIndependentEval(analyticExpr)) {
                return false;
            }
            if (!Expr.equalSets(analyticExpr.getPartitionExprs(), this.partitionByExprs)) {
                return false;
            }
            if (!analyticExpr.getOrderByElements().equals(this.orderByElements)) {
                return false;
            }
            if (this.window == null != (analyticExpr.getWindow() == null)) {
                return false;
            }
            if (this.window == null) {
                return true;
            }
            return analyticExpr.getWindow().equals(this.window);
        }

        public void add(AnalyticExpr analyticExpr, SlotDescriptor logicalOutputSlot, SlotDescriptor logicalIntermediateSlot) {
            Preconditions.checkState((boolean)this.isCompatible(analyticExpr));
            this.analyticExprs.add(analyticExpr);
            this.analyticFnCalls.add(analyticExpr.getFnCall());
            this.logicalOutputSlots.add(logicalOutputSlot);
            this.logicalIntermediateSlots.add(logicalIntermediateSlot);
        }

        public void init(Analyzer analyzer, String tupleName) {
            Preconditions.checkState((this.physicalOutputTuple == null ? 1 : 0) != 0);
            Preconditions.checkState((this.physicalIntermediateTuple == null ? 1 : 0) != 0);
            Preconditions.checkState((this.analyticFnCalls.size() == this.analyticExprs.size() ? 1 : 0) != 0);
            boolean requiresIntermediateTuple = AggregateInfoBase.requiresIntermediateTuple(this.analyticFnCalls);
            if (requiresIntermediateTuple) {
                this.physicalIntermediateTuple = analyzer.getDescTbl().createTupleDescriptor(tupleName + "intermed");
                this.physicalOutputTuple = analyzer.getDescTbl().createTupleDescriptor(tupleName + "out");
            } else {
                this.physicalIntermediateTuple = this.physicalOutputTuple = analyzer.getDescTbl().createTupleDescriptor(tupleName + "out");
            }
            Preconditions.checkState((this.analyticExprs.size() == this.logicalIntermediateSlots.size() ? 1 : 0) != 0);
            Preconditions.checkState((this.analyticExprs.size() == this.logicalOutputSlots.size() ? 1 : 0) != 0);
            for (int i = 0; i < this.analyticExprs.size(); ++i) {
                SlotDescriptor logicalOutputSlot = this.logicalOutputSlots.get(i);
                SlotDescriptor physicalOutputSlot = analyzer.copySlotDescriptor(logicalOutputSlot, this.physicalOutputTuple);
                physicalOutputSlot.setIsMaterialized(true);
                if (requiresIntermediateTuple) {
                    SlotDescriptor logicalIntermediateSlot = this.logicalIntermediateSlots.get(i);
                    SlotDescriptor physicalIntermediateSlot = analyzer.copySlotDescriptor(logicalIntermediateSlot, this.physicalIntermediateTuple);
                    physicalIntermediateSlot.setIsMaterialized(true);
                }
                this.logicalToPhysicalSmap.put(new SlotRef(logicalOutputSlot), new SlotRef(physicalOutputSlot));
            }
            this.physicalOutputTuple.computeMemLayout();
            if (requiresIntermediateTuple) {
                this.physicalIntermediateTuple.computeMemLayout();
            }
        }
    }
}

