/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.AnalyticWindow;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.SelectNode;
import org.apache.impala.planner.SortNode;
import org.apache.impala.thrift.TAnalyticNode;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticEvalNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticEvalNode.class);
    private List<Expr> analyticFnCalls_;
    private final List<Expr> partitionExprs_;
    private List<Expr> substitutedPartitionExprs_;
    private List<OrderByElement> orderByElements_;
    private final AnalyticWindow analyticWindow_;
    private final TupleDescriptor intermediateTupleDesc_;
    private final TupleDescriptor outputTupleDesc_;
    private final ExprSubstitutionMap logicalToPhysicalSmap_;
    private Expr partitionByEq_;
    private Expr orderByEq_;
    private TupleDescriptor bufferedTupleDesc_;

    public AnalyticEvalNode(PlanNodeId id, PlanNode input, List<Expr> analyticFnCalls, List<Expr> partitionExprs, List<OrderByElement> orderByElements, AnalyticWindow analyticWindow, TupleDescriptor intermediateTupleDesc, TupleDescriptor outputTupleDesc, ExprSubstitutionMap logicalToPhysicalSmap) {
        super(id, "ANALYTIC");
        Preconditions.checkState((!this.tupleIds_.contains(outputTupleDesc.getId()) ? 1 : 0) != 0);
        this.analyticFnCalls_ = analyticFnCalls;
        this.partitionExprs_ = partitionExprs;
        this.orderByElements_ = orderByElements;
        this.analyticWindow_ = analyticWindow;
        this.intermediateTupleDesc_ = intermediateTupleDesc;
        this.outputTupleDesc_ = outputTupleDesc;
        this.logicalToPhysicalSmap_ = logicalToPhysicalSmap;
        this.children_.add(input);
        this.computeTupleIds();
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        this.tupleIds_.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.tupleIds_.add(this.outputTupleDesc_.getId());
        this.nullableTupleIds_.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    public boolean isBlockingNode() {
        return false;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements_;
    }

    public boolean requiresUnpartitionedEval() {
        if (!Expr.allConstant(this.partitionExprs_)) {
            return false;
        }
        for (OrderByElement orderBy : this.orderByElements_) {
            if (orderBy.getExpr().isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void init(Analyzer analyzer) {
        Preconditions.checkState((boolean)this.conjuncts_.isEmpty());
        this.computeMemLayout(analyzer);
        this.intermediateTupleDesc_.computeMemLayout();
        this.outputSmap_ = this.logicalToPhysicalSmap_;
        this.createDefaultSmap(analyzer);
        this.computeStats(analyzer);
        if (LOG.isTraceEnabled()) {
            LOG.trace("desctbl: " + analyzer.getDescTbl().debugString());
        }
        ExprSubstitutionMap childSmap = this.getCombinedChildSmap();
        this.analyticFnCalls_ = Expr.substituteList(this.analyticFnCalls_, childSmap, analyzer, false);
        this.substitutedPartitionExprs_ = Expr.substituteList(this.partitionExprs_, childSmap, analyzer, false);
        this.orderByElements_ = OrderByElement.substitute(this.orderByElements_, childSmap, analyzer);
        this.constructEqExprs(analyzer);
        if (LOG.isTraceEnabled()) {
            LOG.trace("evalnode: " + this.debugString());
        }
    }

    private void constructEqExprs(Analyzer analyzer) {
        boolean hasOrderBy;
        ExprSubstitutionMap bufferedSmap = new ExprSubstitutionMap();
        TupleId sortTupleId = ((PlanNode)this.getChild(0)).getTupleIds().get(0);
        boolean hasActivePartition = !Expr.allConstant(this.substitutedPartitionExprs_);
        boolean bl = hasOrderBy = !this.orderByElements_.isEmpty();
        if (hasActivePartition || hasOrderBy) {
            this.bufferedTupleDesc_ = analyzer.getDescTbl().copyTupleDescriptor(sortTupleId, "buffered-tuple");
            if (LOG.isTraceEnabled()) {
                LOG.trace("desctbl: " + analyzer.getDescTbl().debugString());
            }
            List<SlotDescriptor> inputSlots = analyzer.getTupleDesc(sortTupleId).getSlots();
            List<SlotDescriptor> bufferedSlots = this.bufferedTupleDesc_.getSlots();
            for (int i = 0; i < inputSlots.size(); ++i) {
                bufferedSmap.put(new SlotRef(inputSlots.get(i)), new SlotRef(bufferedSlots.get(i)));
            }
        }
        if (hasActivePartition) {
            this.partitionByEq_ = this.createNullMatchingEquals(analyzer, this.substitutedPartitionExprs_, sortTupleId, bufferedSmap);
            if (LOG.isTraceEnabled()) {
                LOG.trace("partitionByEq: " + this.partitionByEq_.debugString());
            }
        }
        if (hasOrderBy) {
            this.orderByEq_ = this.createNullMatchingEquals(analyzer, OrderByElement.getOrderByExprs(this.orderByElements_), sortTupleId, bufferedSmap);
            if (LOG.isTraceEnabled()) {
                LOG.trace("orderByEq: " + this.orderByEq_.debugString());
            }
        }
    }

    private Expr createNullMatchingEquals(Analyzer analyzer, List<Expr> exprs, TupleId inputTid, ExprSubstitutionMap bufferedSmap) {
        Preconditions.checkState((!exprs.isEmpty() ? 1 : 0) != 0);
        Expr result = this.createNullMatchingEqualsAux(analyzer, exprs, 0, inputTid, bufferedSmap);
        result.analyzeNoThrow(analyzer);
        return result;
    }

    private Expr createNullMatchingEqualsAux(Analyzer analyzer, List<Expr> elements, int i, TupleId inputTid, ExprSubstitutionMap bufferedSmap) {
        if (i > elements.size() - 1) {
            return new BoolLiteral(true);
        }
        Expr lhs = elements.get(i);
        Preconditions.checkState((boolean)lhs.isBound(inputTid), (Object)lhs.debugString());
        Expr rhs = lhs.substitute(bufferedSmap, analyzer, false);
        CompoundPredicate bothNull = new CompoundPredicate(CompoundPredicate.Operator.AND, new IsNullPredicate(lhs, false), new IsNullPredicate(rhs, false));
        CompoundPredicate lhsEqRhsNotNull = new CompoundPredicate(CompoundPredicate.Operator.AND, new CompoundPredicate(CompoundPredicate.Operator.AND, new IsNullPredicate(lhs, true), new IsNullPredicate(rhs, true)), new BinaryPredicate(BinaryPredicate.Operator.EQ, lhs, rhs));
        Expr remainder = this.createNullMatchingEqualsAux(analyzer, elements, i + 1, inputTid, bufferedSmap);
        return new CompoundPredicate(CompoundPredicate.Operator.AND, new CompoundPredicate(CompoundPredicate.Operator.OR, bothNull, lhsEqRhsNotNull), remainder);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = ((PlanNode)this.getChild((int)0)).cardinality_;
        this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
    }

    @Override
    protected String debugString() {
        ArrayList<String> orderByElementStrs = new ArrayList<String>();
        for (OrderByElement element : this.orderByElements_) {
            orderByElementStrs.add(element.toSql());
        }
        return MoreObjects.toStringHelper((Object)this).add("analyticFnCalls", (Object)Expr.debugString(this.analyticFnCalls_)).add("partitionExprs", (Object)Expr.debugString(this.partitionExprs_)).add("subtitutedPartitionExprs", (Object)Expr.debugString(this.substitutedPartitionExprs_)).add("orderByElements", (Object)Joiner.on((String)", ").join(orderByElementStrs)).add("window", (Object)this.analyticWindow_).add("intermediateTid", (Object)this.intermediateTupleDesc_.getId()).add("outputTid", (Object)this.outputTupleDesc_.getId()).add("partitionByEq", (Object)(this.partitionByEq_ != null ? this.partitionByEq_.debugString() : "null")).add("orderByEq", (Object)(this.orderByEq_ != null ? this.orderByEq_.debugString() : "null")).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.ANALYTIC_EVAL_NODE;
        msg.analytic_node = new TAnalyticNode();
        msg.analytic_node.setIntermediate_tuple_id(this.intermediateTupleDesc_.getId().asInt());
        msg.analytic_node.setOutput_tuple_id(this.outputTupleDesc_.getId().asInt());
        msg.analytic_node.setPartition_exprs(Expr.treesToThrift(this.substitutedPartitionExprs_));
        msg.analytic_node.setOrder_by_exprs(Expr.treesToThrift(OrderByElement.getOrderByExprs(this.orderByElements_)));
        msg.analytic_node.setAnalytic_functions(Expr.treesToThrift(this.analyticFnCalls_));
        if (this.analyticWindow_ == null) {
            if (!this.orderByElements_.isEmpty()) {
                msg.analytic_node.setWindow(AnalyticWindow.DEFAULT_WINDOW.toThrift());
            }
        } else {
            msg.analytic_node.setWindow(this.analyticWindow_.toThrift());
        }
        if (this.partitionByEq_ != null) {
            msg.analytic_node.setPartition_by_eq(this.partitionByEq_.treeToThrift());
        }
        if (this.orderByEq_ != null) {
            msg.analytic_node.setOrder_by_eq(this.orderByEq_.treeToThrift());
        }
        if (this.bufferedTupleDesc_ != null) {
            msg.analytic_node.setBuffered_tuple_id(this.bufferedTupleDesc_.getId().asInt());
        }
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("%s%s", prefix, this.getDisplayLabel()));
        output.append("\n");
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            output.append(detailPrefix + "functions: ");
            ArrayList<String> strings = new ArrayList<String>();
            for (Expr fnCall : this.analyticFnCalls_) {
                strings.add(fnCall.toSql());
            }
            output.append(Joiner.on((String)", ").join(strings));
            output.append("\n");
            if (!this.partitionExprs_.isEmpty()) {
                output.append(detailPrefix + "partition by: ");
                strings.clear();
                for (Expr partitionExpr : this.partitionExprs_) {
                    strings.add(partitionExpr.toSql());
                }
                output.append(Joiner.on((String)", ").join(strings));
                output.append("\n");
            }
            if (!this.orderByElements_.isEmpty()) {
                output.append(detailPrefix + "order by: ");
                strings.clear();
                for (OrderByElement element : this.orderByElements_) {
                    strings.add(element.toSql());
                }
                output.append(Joiner.on((String)", ").join(strings));
                output.append("\n");
            }
            if (this.analyticWindow_ != null) {
                output.append(detailPrefix + "window: ");
                output.append(this.analyticWindow_.toSql());
                output.append("\n");
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix + "predicates: " + Expr.getExplainString(this.conjuncts_, detailLevel) + "\n");
            }
        }
        return output.toString();
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        float totalCostToEvalOneRow = ExprUtil.computeExprsTotalCost(this.analyticFnCalls_);
        this.processingCost_ = ProcessingCost.basicCost(this.getDisplayLabel(), this.getCardinality(), totalCostToEvalOneRow);
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)this.fragment_, (Object)"PlanNode must be placed into a fragment before calling this method.");
        long perInstanceMemEstimate = 0L;
        long bufferSize = AnalyticEvalNode.computeMaxSpillableBufferSize(queryOptions.getDefault_spillable_buffer_size(), queryOptions.getMax_row_size());
        long perInstanceMinMemReservation = 2L * bufferSize;
        this.nodeResourceProfile_ = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(bufferSize).build();
    }

    public LimitPushdownInfo checkForLimitPushdown(SortInfo sortInfo, ExprSubstitutionMap sortInputSmap, SelectNode selectNode, long limit, SortNode analyticNodeSort, Analyzer analyzer) {
        if (!analyticNodeSort.isPartitionedTopN() && !analyticNodeSort.isTotalSort()) {
            return null;
        }
        if (this.analyticFnCalls_.size() != 1) {
            return null;
        }
        Expr expr = this.analyticFnCalls_.get(0);
        if (!(expr instanceof FunctionCallExpr) || !AnalyticExpr.isRankingFn(((FunctionCallExpr)expr).getFn())) {
            return null;
        }
        List<Expr> analyticSortSortExprs = analyticNodeSort.getSortInfo().getSortExprs();
        ArrayList origSortExprs = sortInfo != null ? sortInfo.getOrigSortExprs() : new ArrayList();
        List<Expr> sortExprs = Expr.substituteList(origSortExprs, sortInputSmap, analyzer, false);
        List<Expr> pbExprs = this.substitutedPartitionExprs_;
        if (sortExprs.size() == 0) {
            return this.checkForUnorderedLimitPushdown(selectNode, limit, analyticNodeSort);
        }
        Preconditions.checkArgument((analyticSortSortExprs.size() >= pbExprs.size() ? 1 : 0) != 0);
        if (sortExprs.size() > 0 && !this.analyticSortExprsArePrefix(sortInfo, sortExprs, analyticNodeSort.getSortInfo(), pbExprs)) {
            return null;
        }
        if (this.analyticWindow_.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING || this.analyticWindow_.getRightBoundary().getType() != AnalyticWindow.BoundaryType.CURRENT_ROW) {
            return null;
        }
        if (selectNode == null) {
            if (analyticNodeSort.isPartitionedTopN()) {
                return null;
            }
            Preconditions.checkState((boolean)analyticNodeSort.isTotalSort());
            if (!this.analyticSortExprsArePrefix(sortInfo, sortExprs, analyticNodeSort.getSortInfo(), analyticSortSortExprs)) {
                return null;
            }
            return new LimitPushdownInfo(false, 0);
        }
        Pair<LimitPushdownInfo, Double> status = this.checkPredEligibleForLimitPushdown(analyticNodeSort, selectNode.getConjuncts(), limit);
        if (status.first != null) {
            selectNode.setSelectivity((Double)status.second);
            return (LimitPushdownInfo)status.first;
        }
        return null;
    }

    private LimitPushdownInfo checkForUnorderedLimitPushdown(SelectNode selectNode, long limit, SortNode analyticNodeSort) {
        if (!analyticNodeSort.isTotalSort()) {
            return null;
        }
        if (selectNode == null) {
            return new LimitPushdownInfo(false, 0);
        }
        Pair<LimitPushdownInfo, Double> status = this.checkPredEligibleForLimitPushdown(analyticNodeSort, selectNode.getConjuncts(), limit);
        if (status.first != null) {
            selectNode.setSelectivity((Double)status.second);
            return (LimitPushdownInfo)status.first;
        }
        return null;
    }

    private boolean analyticSortExprsArePrefix(SortInfo sortInfo, List<Expr> sortExprs, SortInfo analyticSortInfo, List<Expr> analyticSortExprs) {
        if (analyticSortExprs.size() > sortExprs.size()) {
            return false;
        }
        for (int i = 0; i < analyticSortExprs.size(); ++i) {
            if (!analyticSortExprs.get(i).equals(sortExprs.get(i))) {
                return false;
            }
            if (!sortInfo.getIsAscOrder().get(i).equals(analyticSortInfo.getIsAscOrder().get(i))) {
                return false;
            }
            if (sortInfo.getNullsFirst().get(i).equals(analyticSortInfo.getNullsFirst().get(i))) continue;
            return false;
        }
        return true;
    }

    private Pair<LimitPushdownInfo, Double> checkPredEligibleForLimitPushdown(SortNode analyticNodeSort, List<Expr> conjuncts, long limit) {
        boolean includeTies;
        Pair<Object, Double> falseStatus = new Pair<Object, Double>(null, -1.0);
        if (conjuncts.size() > 1) {
            return falseStatus;
        }
        Expr conj = conjuncts.get(0);
        if (!Expr.IS_BINARY_PREDICATE.apply((Object)conj)) {
            return falseStatus;
        }
        BinaryPredicate pred = (BinaryPredicate)conj;
        Expr lhs = (Expr)pred.getChild(0);
        Expr rhs = (Expr)pred.getChild(1);
        if (!(lhs instanceof SlotRef) || !lhs.isBound(this.outputTupleDesc_.getId())) {
            return falseStatus;
        }
        List<Expr> lhsSourceExprs = ((SlotRef)lhs).getDesc().getSourceExprs();
        if (lhsSourceExprs.size() != 1 || !(lhsSourceExprs.get(0) instanceof AnalyticExpr)) {
            return falseStatus;
        }
        Function fn = ((AnalyticExpr)lhsSourceExprs.get(0)).getFnCall().getFn();
        if (AnalyticExpr.isAnalyticFn(fn, AnalyticExpr.RANK)) {
            includeTies = true;
        } else if (AnalyticExpr.isAnalyticFn(fn, AnalyticExpr.ROWNUMBER)) {
            includeTies = false;
        } else {
            return falseStatus;
        }
        if (pred.getOp() != BinaryPredicate.Operator.EQ && pred.getOp() != BinaryPredicate.Operator.LT && pred.getOp() != BinaryPredicate.Operator.LE) {
            return falseStatus;
        }
        if (!(rhs instanceof NumericLiteral)) {
            return falseStatus;
        }
        long analyticLimit = ((NumericLiteral)rhs).getLongValue();
        if (pred.getOp() == BinaryPredicate.Operator.LT) {
            --analyticLimit;
        }
        if (pred.getOp() == BinaryPredicate.Operator.EQ && limit > 1L) {
            return falseStatus;
        }
        if (analyticNodeSort.isPartitionedTopN() && (analyticLimit != analyticNodeSort.getPerPartitionLimit() || includeTies != analyticNodeSort.isIncludeTies())) {
            return falseStatus;
        }
        LimitPushdownInfo pushdownInfo = this.checkLimitEligibleForPushdown(limit, includeTies, analyticLimit);
        if (pushdownInfo == null) {
            return falseStatus;
        }
        double selectivity = 0.1;
        if (pred.getOp() == BinaryPredicate.Operator.LT || pred.getOp() == BinaryPredicate.Operator.LE) {
            selectivity = 1.0;
        }
        return new Pair<LimitPushdownInfo, Double>(pushdownInfo, selectivity);
    }

    private LimitPushdownInfo checkLimitEligibleForPushdown(long limit, boolean includeTies, long analyticLimit) {
        if (analyticLimit < limit) {
            return null;
        }
        if (analyticLimit + limit > Integer.MAX_VALUE) {
            return null;
        }
        return new LimitPushdownInfo(includeTies, (int)analyticLimit);
    }

    public TupleDescriptor getOutputTupleDesc() {
        return this.outputTupleDesc_;
    }

    public List<Expr> getAnalyticFnCalls() {
        return this.analyticFnCalls_;
    }

    public AnalyticWindow getAnalyticWindow() {
        return this.analyticWindow_;
    }

    public static class LimitPushdownInfo {
        public final boolean includeTies;
        public final int additionalLimit;

        public LimitPushdownInfo(boolean includeTies, int additionalLimit) {
            this.includeTies = includeTies;
            this.additionalLimit = additionalLimit;
        }
    }
}

