/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.impala.analysis.AggregateInfo;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.ValidTupleIdExpr;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.planner.ExchangeNode;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.ProcessingCost;
import org.apache.impala.planner.ResourceProfile;
import org.apache.impala.planner.ResourceProfileBuilder;
import org.apache.impala.planner.SpillableOperator;
import org.apache.impala.planner.TupleCacheNode;
import org.apache.impala.planner.UnionNode;
import org.apache.impala.thrift.TAggregationNode;
import org.apache.impala.thrift.TAggregator;
import org.apache.impala.thrift.TBackendResourceProfile;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TPlanNode;
import org.apache.impala.thrift.TPlanNodeType;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.BitUtil;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationNode
extends PlanNode
implements SpillableOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationNode.class);
    private static final long DEFAULT_PER_INSTANCE_MEM = 0x8000000L;
    private static final double DEFAULT_SKEW_FACTOR = 1.5;
    private static final long NON_GROUPING_AGG_NUM_GROUPS = 1L;
    private final MultiAggregateInfo multiAggInfo_;
    private final MultiAggregateInfo.AggPhase aggPhase_;
    private final List<AggregateInfo> aggInfos_;
    private boolean useIntermediateTuple_ = false;
    private boolean needsFinalize_ = false;
    private boolean isPreagg_ = false;
    private boolean useStreamingPreagg_ = false;
    private List<ResourceProfile> resourceProfiles_;
    protected static final long MIN_PLAIN_AGG_MEM = 16384L;
    protected boolean isNonCorrelatedScalarSubquery_ = false;
    private long aggInputCardinality_ = -1L;
    private List<Long> aggClassNumGroups_;
    private List<Long> aggClassOutputCardinality_;
    private boolean skipTupleAnalysis_ = false;

    public AggregationNode(PlanNodeId id, PlanNode input, MultiAggregateInfo multiAggInfo, MultiAggregateInfo.AggPhase aggPhase) {
        super(id, "AGGREGATE");
        this.children_.add(input);
        this.multiAggInfo_ = multiAggInfo;
        this.aggInfos_ = this.multiAggInfo_.getMaterializedAggInfos(aggPhase);
        this.aggPhase_ = aggPhase;
        this.needsFinalize_ = true;
        this.computeTupleIds();
    }

    private AggregationNode(PlanNodeId id, AggregationNode src) {
        super(id, src, "AGGREGATE");
        this.multiAggInfo_ = src.multiAggInfo_;
        this.aggPhase_ = src.aggPhase_;
        this.aggInfos_ = src.aggInfos_;
        this.needsFinalize_ = src.needsFinalize_;
        this.useIntermediateTuple_ = src.useIntermediateTuple_;
        this.isNonCorrelatedScalarSubquery_ = src.isNonCorrelatedScalarSubquery_;
    }

    @Override
    public void computeTupleIds() {
        this.clearTupleIds();
        for (AggregateInfo aggInfo : this.aggInfos_) {
            TupleId aggClassTupleId = null;
            aggClassTupleId = this.useIntermediateTuple_ ? aggInfo.getIntermediateTupleId() : aggInfo.getOutputTupleId();
            this.tupleIds_.add(aggClassTupleId);
            this.tblRefIds_.add(aggClassTupleId);
            if (this.aggInfos_.size() <= 1) continue;
            this.nullableTupleIds_.add(aggClassTupleId);
        }
    }

    public void setIsPreagg(PlannerContext ctx) {
        this.isPreagg_ = true;
        if (ctx.getQueryOptions().disable_streaming_preaggregations) {
            this.useStreamingPreagg_ = false;
            return;
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (aggInfo.getGroupingExprs().size() <= 0) continue;
            this.useStreamingPreagg_ = true;
            return;
        }
    }

    public void unsetNeedsFinalize() {
        Preconditions.checkState((boolean)this.needsFinalize_);
        this.needsFinalize_ = false;
    }

    public void setIntermediateTuple() {
        this.useIntermediateTuple_ = true;
        this.computeTupleIds();
    }

    public MultiAggregateInfo getMultiAggInfo() {
        return this.multiAggInfo_;
    }

    public MultiAggregateInfo.AggPhase getAggPhase() {
        return this.aggPhase_;
    }

    public boolean hasGrouping() {
        return this.multiAggInfo_.hasGrouping();
    }

    public boolean isSingleClassAgg() {
        return this.aggInfos_.size() == 1;
    }

    public boolean isDistinctAgg() {
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (!aggInfo.isDistinctAgg()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockingNode() {
        return !this.useStreamingPreagg_;
    }

    @Override
    public void init(Analyzer analyzer) throws InternalException {
        this.init(analyzer, null);
    }

    public void init(Analyzer analyzer, List<Expr> transferredConjuncts) throws InternalException {
        Preconditions.checkState((this.tupleIds_.size() == this.aggInfos_.size() ? 1 : 0) != 0);
        if (this.aggPhase_ == this.multiAggInfo_.getConjunctAssignmentPhase()) {
            this.conjuncts_.clear();
            this.conjuncts_.addAll(this.multiAggInfo_.collectConjuncts(analyzer, true));
        }
        if (transferredConjuncts != null) {
            this.conjuncts_.addAll(transferredConjuncts);
        }
        this.conjuncts_ = AggregationNode.orderConjunctsByCost(this.conjuncts_);
        for (AggregateInfo aggInfo : this.aggInfos_) {
            aggInfo.getOutputTupleDesc().computeMemLayout();
            aggInfo.getIntermediateTupleDesc().computeMemLayout();
        }
        this.computeStats(analyzer);
        this.outputSmap_ = this.getCombinedChildSmap();
        if (this.aggPhase_ == MultiAggregateInfo.AggPhase.FIRST) {
            this.multiAggInfo_.substitute(this.outputSmap_, analyzer);
        }
        for (AggregateInfo aggInfo : this.aggInfos_) {
            aggInfo.substitute(this.outputSmap_, analyzer);
            aggInfo.checkConsistency();
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality_ = 0L;
        this.aggInputCardinality_ = this.getFirstAggInputCardinality();
        Preconditions.checkState((this.aggInputCardinality_ >= -1L ? 1 : 0) != 0, (Object)this.aggInputCardinality_);
        AggregationNode preaggNode = null;
        if (this.aggPhase_.isMerge()) {
            preaggNode = this.getPrevAggNode(this);
            Preconditions.checkState((preaggNode.aggInfos_.size() == this.aggInfos_.size() ? 1 : 0) != 0, (String)"Merge aggregation %s have mismatch aggInfo count compared to the preaggregation %s (%s vs %s)", (Object)this.getId(), (Object)preaggNode.getId(), (Object)this.aggInfos_.size(), (Object)preaggNode.aggInfos_.size());
        }
        this.skipTupleAnalysis_ |= !this.conjuncts_.isEmpty();
        this.skipTupleAnalysis_ |= !analyzer.getQueryOptions().isEnable_tuple_analysis_in_aggregate();
        boolean unknownEstimate = false;
        boolean canCompleteEarly = this.canCompleteEarly();
        boolean estimatePreaggDuplicate = this.isPreagg_ && analyzer.getQueryOptions().isEstimate_duplicate_in_preagg();
        this.aggClassNumGroups_ = Lists.newArrayList();
        this.aggClassOutputCardinality_ = Lists.newArrayList();
        int aggIdx = 0;
        for (AggregateInfo aggInfo : this.aggInfos_) {
            long numGroups = -1L;
            long preaggNumgroup = -1L;
            List<Expr> groupingExprs = aggInfo.getGroupingExprs();
            if (preaggNode != null) {
                preaggNumgroup = preaggNode.aggClassNumGroups_.get(aggIdx);
                numGroups = AggregationNode.estimateNumGroups(groupingExprs, this.aggInputCardinality_, preaggNumgroup);
            } else {
                numGroups = AggregationNode.estimateNumGroups(groupingExprs, this.aggInputCardinality_, this, analyzer);
            }
            Preconditions.checkState((numGroups >= -1L ? 1 : 0) != 0, (String)"numGroups is invalid: %s", (long)numGroups);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} aggPhase={} aggInputCardinality={} aggIdx={} numGroups={} preaggNumGroup={} aggInfo={}", new Object[]{this.getDisplayLabel(), this.aggPhase_, this.aggInputCardinality_, aggIdx, numGroups, preaggNumgroup, aggInfo.debugString()});
            }
            this.aggClassNumGroups_.add(numGroups);
            if (numGroups == -1L) {
                unknownEstimate = true;
                this.aggClassOutputCardinality_.add(-1L);
            } else {
                long aggOutputCard = numGroups;
                if (this.isPreagg_) {
                    List<Expr> inputPartExprs = this.getFragment().getDataPartition().getPartitionExprs();
                    if (numGroups > 0L && (inputPartExprs.isEmpty() || !Expr.isSubset(inputPartExprs, groupingExprs) || canCompleteEarly)) {
                        aggOutputCard = AggregationNode.estimatePreaggCardinality(this.fragment_.getNumInstancesForCosting(), numGroups, this.aggInputCardinality_, groupingExprs.isEmpty(), canCompleteEarly, this.getLimit());
                    }
                } else if (canCompleteEarly) {
                    aggOutputCard = MathUtil.smallestValidCardinality(aggOutputCard, this.getLimit());
                }
                this.aggClassOutputCardinality_.add(aggOutputCard);
                this.cardinality_ = MathUtil.addCardinalities(this.cardinality_, estimatePreaggDuplicate ? aggOutputCard : numGroups);
            }
            ++aggIdx;
        }
        if (unknownEstimate) {
            this.cardinality_ = -1L;
        }
        long cardBeforeConjunct = this.cardinality_;
        long cardAfterConjunct = this.cardinality_;
        if (this.cardinality_ > 0L && !this.getConjuncts().isEmpty()) {
            Preconditions.checkState((!canCompleteEarly ? 1 : 0) != 0, (Object)"canCompleteEarly is true but conjuncts_ is not empty");
            cardAfterConjunct = this.cardinality_ = this.applyConjunctsSelectivity(this.cardinality_);
        }
        if (!estimatePreaggDuplicate) {
            this.cardinality_ = this.capCardinalityAtLimit(this.cardinality_);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} cardinality=[BeforeConjunct={} AfterConjunct={} AfterLimit={}]", new Object[]{this.getDisplayLabel(), cardBeforeConjunct, cardAfterConjunct, this.cardinality_});
        }
    }

    @Nullable
    private static TupleDescriptor findSourceTupleId(Expr expr) {
        Expr exprToFind = expr;
        Expr lastExpr = null;
        while (exprToFind != null && exprToFind != lastExpr) {
            lastExpr = exprToFind;
            SlotRef slotRef = exprToFind.unwrapSlotRef(true);
            if (slotRef != null && slotRef.getDesc() != null) {
                SlotDescriptor sd = slotRef.getDesc();
                if (sd.getParent() != null && sd.getType().isScalarType() && sd.getColumn() != null) {
                    LOG.trace("Tracing Slot={}, a simple column slot", (Object)slotRef);
                    return sd.getParent();
                }
                if (sd.getParent() != null && sd.getParent().getSourceView() != null) {
                    LOG.trace("Tracing Slot={}, a view slot", (Object)slotRef);
                    exprToFind = sd.getParent().getSourceView().getBaseTblSmap().get(slotRef);
                    continue;
                }
                if (sd.getSourceExprs().size() == 1) {
                    LOG.trace("Tracing Slot={}, an intermediate slot with single source", (Object)slotRef);
                    exprToFind = sd.getSourceExprs().get(0);
                    continue;
                }
                if (sd.getSourceExprs().size() > 1 && sd.getParent() != null && sd.getType().isScalarType()) {
                    LOG.trace("Tracing Slot={}, an intermediate slot with {} sources", (Object)slotRef, (Object)sd.getSourceExprs().size());
                    return sd.getParent();
                }
                exprToFind = null;
                continue;
            }
            exprToFind = null;
        }
        return null;
    }

    protected static long estimatePreaggCardinality(long totalInstances, long globalNdv, long inputCardinality, boolean isNonGroupingAggregation, boolean canCompleteEarly, long limit) {
        Preconditions.checkArgument((totalInstances > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((globalNdv > 0L ? 1 : 0) != 0);
        if (canCompleteEarly) {
            Preconditions.checkArgument((limit > -1L ? 1 : 0) != 0, (Object)"limit must not be negative.");
            long limitMultiple = MathUtil.multiplyCardinalities(limit, totalInstances);
            long ndvMultiple = MathUtil.multiplyCardinalities(globalNdv, totalInstances);
            return MathUtil.smallestValidCardinality(inputCardinality, MathUtil.smallestValidCardinality(ndvMultiple, limitMultiple));
        }
        if (isNonGroupingAggregation) {
            return MathUtil.smallestValidCardinality(inputCardinality, MathUtil.multiplyCardinalities(globalNdv, totalInstances));
        }
        if (totalInstances > 1L && inputCardinality > globalNdv) {
            double perInstanceInputCard = Math.ceil((double)inputCardinality / (double)totalInstances);
            double globalNdvInDouble = globalNdv;
            double probValExist = 1.0 - Math.pow((globalNdvInDouble - 1.0) / globalNdvInDouble, perInstanceInputCard);
            double perInstanceNdv = Math.ceil(probValExist * globalNdvInDouble);
            long preaggOutputCard = MathUtil.multiplyCardinalities(Math.round(perInstanceNdv), totalInstances);
            preaggOutputCard = MathUtil.smallestValidCardinality(inputCardinality, preaggOutputCard);
            LOG.trace("inputCardinality={} perInstanceInputCard={} globalNdv={} probValExist={} perInstanceNdv={} preaggOutputCard={}", new Object[]{inputCardinality, perInstanceInputCard, globalNdv, probValExist, perInstanceNdv, preaggOutputCard});
            return preaggOutputCard;
        }
        return MathUtil.smallestValidCardinality(inputCardinality, globalNdv);
    }

    public static long estimateNumGroups(List<Expr> groupingExprs, long aggInputCardinality, long preaggNumGroup) {
        Preconditions.checkArgument((aggInputCardinality >= -1L ? 1 : 0) != 0, (Object)aggInputCardinality);
        if (groupingExprs.isEmpty()) {
            return 1L;
        }
        return MathUtil.smallestValidCardinality(preaggNumGroup, aggInputCardinality);
    }

    public static long estimateNumGroups(List<Expr> groupingExprs, long aggInputCardinality, PlanNode planNode, Analyzer analyzer) {
        Preconditions.checkArgument((aggInputCardinality >= -1L ? 1 : 0) != 0, (Object)aggInputCardinality);
        if (groupingExprs.isEmpty()) {
            return 1L;
        }
        if (planNode instanceof AggregationNode && ((AggregationNode)planNode).skipTupleAnalysis_) {
            return AggregationNode.estimateNumGroups(groupingExprs, aggInputCardinality);
        }
        HashMap tupleDescToExprs = new HashMap();
        ArrayList<Expr> exprsWithUniqueTupleId = new ArrayList<Expr>();
        for (Expr expr : groupingExprs) {
            TupleDescriptor tupleDescriptor = AggregationNode.findSourceTupleId(expr);
            if (tupleDescriptor != null) {
                tupleDescToExprs.putIfAbsent(tupleDescriptor, new ArrayList());
                ((List)tupleDescToExprs.get(tupleDescriptor)).add(expr);
                LOG.trace("Slot {} match with tuple {}", (Object)expr, (Object)tupleDescriptor.getId());
                continue;
            }
            exprsWithUniqueTupleId.add(expr);
        }
        ArrayList<Long> tupleBasedNumGroups = new ArrayList<Long>();
        if (tupleDescToExprs.isEmpty()) {
            Preconditions.checkState((exprsWithUniqueTupleId.size() == groupingExprs.size() ? 1 : 0) != 0, (String)"Missing expression after TupleId analysis! Expect %s but found %s", (int)groupingExprs.size(), (int)exprsWithUniqueTupleId.size());
        } else {
            for (Map.Entry entry : tupleDescToExprs.entrySet()) {
                long numGroupFromCommonTuple;
                ArrayList<Expr> exprs = new ArrayList<Expr>((Collection)entry.getValue());
                PlanNode producerNode = analyzer.getProducingNode(((TupleDescriptor)entry.getKey()).getId());
                if (producerNode == null) {
                    exprsWithUniqueTupleId.addAll((Collection)entry.getValue());
                    continue;
                }
                Preconditions.checkNotNull(exprs, (Object)"exprs must not be null");
                long producerCardinality = -1L;
                long filteredNdv = 1L;
                if (producerNode.hasHardEstimates_ || producerNode instanceof UnionNode) {
                    producerCardinality = producerNode.getCardinality();
                } else {
                    producerCardinality = producerNode.capCardinalityAtLimit(producerNode.getInputCardinality());
                    if (producerNode instanceof HdfsScanNode) {
                        filteredNdv = ((HdfsScanNode)producerNode).filterExprWithStatsConjunct((TupleDescriptor)entry.getKey(), exprs);
                    }
                }
                long ndvBasedNumGroup = 1L;
                if (!exprs.isEmpty()) {
                    ndvBasedNumGroup = AggregationNode.estimateNumGroups(exprs, aggInputCardinality);
                }
                if (ndvBasedNumGroup > -1L) {
                    Preconditions.checkState((filteredNdv > 0L ? 1 : 0) != 0, (Object)"filteredNdv must be greater than 0.");
                    ndvBasedNumGroup = MathUtil.multiplyCardinalities(ndvBasedNumGroup, filteredNdv);
                }
                if ((numGroupFromCommonTuple = MathUtil.smallestValidCardinality(producerCardinality, ndvBasedNumGroup)) < 0L) {
                    exprsWithUniqueTupleId.addAll((Collection)entry.getValue());
                    continue;
                }
                tupleBasedNumGroups.add(numGroupFromCommonTuple);
            }
        }
        long l = 1L;
        if (!exprsWithUniqueTupleId.isEmpty()) {
            l = AggregationNode.estimateNumGroups(exprsWithUniqueTupleId, aggInputCardinality);
        }
        if (l < 0L) {
            return l;
        }
        for (Long entry : tupleBasedNumGroups) {
            l = MathUtil.multiplyCardinalities(l, entry);
        }
        return MathUtil.smallestValidCardinality(l, aggInputCardinality);
    }

    private static long estimateNumGroups(List<Expr> groupingExprs, long aggInputCardinality) {
        Preconditions.checkArgument((!groupingExprs.isEmpty() ? 1 : 0) != 0, (Object)"groupingExprs must not be empty");
        long numGroups = Expr.getNumDistinctValues(groupingExprs);
        return MathUtil.smallestValidCardinality(numGroups, aggInputCardinality);
    }

    private long getFirstAggInputCardinality() {
        long inputCardinality = ((PlanNode)this.getChild(0)).getCardinality();
        if (this.multiAggInfo_.getIsGroupingSet() && this.aggPhase_ == MultiAggregateInfo.AggPhase.TRANSPOSE) {
            return inputCardinality;
        }
        AggregationNode firstAgg = this;
        while (firstAgg.getAggPhase() != MultiAggregateInfo.AggPhase.FIRST) {
            firstAgg = this.getPrevAggNode(firstAgg);
        }
        return Math.min(inputCardinality, ((PlanNode)firstAgg.getChild(0)).getCardinality());
    }

    private AggregationNode getPrevAggNode(AggregationNode aggNode) {
        Preconditions.checkArgument((aggNode.getAggPhase() != MultiAggregateInfo.AggPhase.FIRST ? 1 : 0) != 0);
        PlanNode child = (PlanNode)aggNode.getChild(0);
        while (child instanceof ExchangeNode || child instanceof TupleCacheNode) {
            child = (PlanNode)child.getChild(0);
        }
        Preconditions.checkState((boolean)(child instanceof AggregationNode));
        return (AggregationNode)child;
    }

    @Nullable
    private AggregationNode getPreAggNodeChild() {
        AggregationNode prevAgg = null;
        if (this.aggPhase_.isMerge()) {
            prevAgg = this.getPrevAggNode(this);
            Preconditions.checkState((this.aggInfos_.size() == prevAgg.aggInfos_.size() ? 1 : 0) != 0);
            Preconditions.checkState((this.aggInfos_.size() == prevAgg.aggClassNumGroups_.size() ? 1 : 0) != 0);
            Preconditions.checkState((this.aggInfos_.size() == prevAgg.aggClassOutputCardinality_.size() ? 1 : 0) != 0);
        }
        return prevAgg;
    }

    public List<Expr> getMergePartitionExprs(Analyzer analyzer) {
        Preconditions.checkState((!this.tupleIds_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!this.aggPhase_.isMerge() && !this.aggPhase_.isTranspose() ? 1 : 0) != 0);
        boolean shuffleDistinctExprs = analyzer.getQueryOptions().shuffle_distinct_exprs;
        if (this.aggInfos_.size() == 1) {
            AggregateInfo aggInfo = this.aggInfos_.get(0);
            List<Expr> groupingExprs = null;
            if (this.aggPhase_.isFirstPhase() && this.hasGrouping() && !shuffleDistinctExprs) {
                groupingExprs = this.multiAggInfo_.getSubstGroupingExprs();
            } else {
                groupingExprs = aggInfo.getPartitionExprs();
                if (groupingExprs == null) {
                    groupingExprs = aggInfo.getGroupingExprs();
                }
            }
            return Expr.substituteList(groupingExprs, aggInfo.getIntermediateSmap(), analyzer, false);
        }
        int maxNumExprs = 0;
        for (AggregateInfo aggInfo : this.aggInfos_) {
            if (aggInfo.getGroupingExprs() == null) continue;
            maxNumExprs = Math.max(maxNumExprs, aggInfo.getGroupingExprs().size());
        }
        if (maxNumExprs == 0) {
            return Collections.emptyList();
        }
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (int i = 0; i < maxNumExprs; ++i) {
            ArrayList<CaseWhenClause> caseWhenClauses = new ArrayList<CaseWhenClause>();
            for (AggregateInfo aggInfo : this.aggInfos_) {
                Expr thenExpr;
                TupleId tid = aggInfo.isDistinctAgg() ? aggInfo.getOutputTupleId() : aggInfo.getIntermediateTupleId();
                List<Expr> groupingExprs = aggInfo.getGroupingExprs();
                if (this.aggPhase_.isFirstPhase() && this.hasGrouping() && !shuffleDistinctExprs) {
                    groupingExprs = this.multiAggInfo_.getSubstGroupingExprs();
                }
                NumericLiteral whenExpr = NumericLiteral.create(tid.asInt());
                if (groupingExprs == null || i >= groupingExprs.size()) {
                    thenExpr = NumericLiteral.create(0L);
                } else {
                    thenExpr = new FunctionCallExpr("murmur_hash", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{groupingExprs.get(i).clone()}));
                    thenExpr.analyzeNoThrow(analyzer);
                    thenExpr = thenExpr.substitute(aggInfo.getIntermediateSmap(), analyzer, true);
                }
                caseWhenClauses.add(new CaseWhenClause(whenExpr, thenExpr));
            }
            CaseExpr caseExpr = new CaseExpr(new ValidTupleIdExpr(this.tupleIds_), caseWhenClauses, null);
            caseExpr.analyzeNoThrow(analyzer);
            result.add(caseExpr);
        }
        return result;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature.");
    }

    @Override
    protected void toThrift(TPlanNode msg, ThriftSerializationCtx serialCtx) {
        msg.agg_node = new TAggregationNode();
        msg.node_type = TPlanNodeType.AGGREGATION_NODE;
        boolean replicateInput = this.aggPhase_ == MultiAggregateInfo.AggPhase.FIRST && this.aggInfos_.size() > 1;
        msg.agg_node.setReplicate_input(replicateInput);
        msg.agg_node.setEstimated_input_cardinality(serialCtx.isTupleCache() ? 1L : ((PlanNode)this.getChild(0)).getCardinality());
        msg.agg_node.setFast_limit_check(this.canCompleteEarly());
        for (int i = 0; i < this.aggInfos_.size(); ++i) {
            AggregateInfo aggInfo = this.aggInfos_.get(i);
            ArrayList<TExpr> aggregateFunctions = new ArrayList<TExpr>();
            for (FunctionCallExpr e : aggInfo.getMaterializedAggregateExprs()) {
                aggregateFunctions.add(e.treeToThrift(serialCtx));
            }
            TBackendResourceProfile resourceProfile = serialCtx.isTupleCache() ? ResourceProfile.noReservation(0L).toThrift() : this.resourceProfiles_.get(i).toThrift();
            serialCtx.registerTuple(aggInfo.getIntermediateTupleId());
            serialCtx.registerTuple(aggInfo.getOutputTupleId());
            TAggregator taggregator = new TAggregator(aggregateFunctions, serialCtx.translateTupleId(aggInfo.getIntermediateTupleId()).asInt(), serialCtx.translateTupleId(aggInfo.getOutputTupleId()).asInt(), this.needsFinalize_, this.useStreamingPreagg_, resourceProfile);
            List<Expr> groupingExprs = aggInfo.getGroupingExprs();
            if (!groupingExprs.isEmpty()) {
                taggregator.setGrouping_exprs(Expr.treesToThrift(groupingExprs, serialCtx));
            }
            msg.agg_node.addToAggregators(taggregator);
        }
        if (this.useStreamingPreagg_) {
            serialCtx.setStreamingAggVariability();
        } else if (this.needsFinalize_) {
            serialCtx.clearStreamingAggVariability();
        }
    }

    @Override
    protected String getDisplayLabelDetail() {
        if (this.useStreamingPreagg_) {
            return "STREAMING";
        }
        if (this.needsFinalize_) {
            return "FINALIZE";
        }
        return null;
    }

    @Override
    protected String getNodeExplainString(String prefix, String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String nameDetail = this.getDisplayLabelDetail();
        output.append(String.format("%s%s", prefix, this.getDisplayLabel()));
        if (nameDetail != null) {
            output.append(" [" + nameDetail + "]");
        }
        output.append("\n");
        if (detailLevel.ordinal() >= TExplainLevel.STANDARD.ordinal()) {
            if (this.aggInfos_.size() == 1) {
                output.append((CharSequence)this.getAggInfoExplainString(detailPrefix, this.aggInfos_.get(0), detailLevel));
            } else {
                for (int i = 0; i < this.aggInfos_.size(); ++i) {
                    AggregateInfo aggInfo = this.aggInfos_.get(i);
                    output.append(String.format("%sClass %d\n", detailPrefix, i));
                    output.append((CharSequence)this.getAggInfoExplainString(detailPrefix + "  ", aggInfo, detailLevel));
                }
            }
            if (!this.conjuncts_.isEmpty()) {
                output.append(detailPrefix).append("having: ").append(Expr.getExplainString(this.conjuncts_, detailLevel)).append("\n");
            }
        }
        return output.toString();
    }

    private StringBuilder getAggInfoExplainString(String prefix, AggregateInfo aggInfo, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        List<FunctionCallExpr> aggExprs = aggInfo.getMaterializedAggregateExprs();
        List<Expr> groupingExprs = aggInfo.getGroupingExprs();
        if (!aggExprs.isEmpty()) {
            output.append(prefix).append("output: ").append(Expr.getExplainString(aggExprs, detailLevel)).append("\n");
        }
        if (!groupingExprs.isEmpty()) {
            output.append(prefix).append("group by: ").append(Expr.getExplainString(groupingExprs, detailLevel)).append("\n");
        }
        return output;
    }

    @Override
    public void computeProcessingCost(TQueryOptions queryOptions) {
        this.processingCost_ = ProcessingCost.zero();
        AggregationNode preaggNode = this.getPreAggNodeChild();
        int aggIdx = 0;
        for (AggregateInfo aggInfo : this.aggInfos_) {
            long intermediateOutputCardinality;
            long inputCardinality;
            if (preaggNode != null) {
                inputCardinality = preaggNode.aggClassOutputCardinality_.get(aggIdx);
                intermediateOutputCardinality = this.aggClassNumGroups_.get(aggIdx);
            } else {
                inputCardinality = ((PlanNode)this.getChild(0)).getCardinality();
                intermediateOutputCardinality = this.aggClassOutputCardinality_.get(aggIdx);
            }
            if (inputCardinality < 0L) {
                inputCardinality = 1L;
            }
            if (intermediateOutputCardinality < 0L) {
                intermediateOutputCardinality = 1L;
            }
            ProcessingCost aggCost = aggInfo.computeProcessingCost(this.getDisplayLabel(), inputCardinality, intermediateOutputCardinality);
            this.processingCost_ = ProcessingCost.sumCost(this.processingCost_, aggCost);
            ++aggIdx;
        }
    }

    @Override
    public void computeNodeResourceProfile(TQueryOptions queryOptions) {
        this.computeResourceProfileIfSpill(queryOptions, Long.MAX_VALUE);
    }

    @Override
    public void computeResourceProfileIfSpill(TQueryOptions queryOptions, long maxMemoryEstimatePerInstance) {
        boolean biasToSpill = AggregationNode.shouldComputeResourcesWithSpill(queryOptions);
        if (!biasToSpill) {
            Preconditions.checkArgument((maxMemoryEstimatePerInstance == Long.MAX_VALUE ? 1 : 0) != 0);
        }
        this.resourceProfiles_ = Lists.newArrayListWithCapacity((int)this.aggInfos_.size());
        this.resourceProfiles_.clear();
        boolean estimatePreaggDuplicate = queryOptions.isEstimate_duplicate_in_preagg();
        AggregationNode prevAggNode = this.getPreAggNodeChild();
        int aggIdx = 0;
        for (AggregateInfo aggregateInfo : this.aggInfos_) {
            long inputCardinality = this.aggInputCardinality_;
            if (prevAggNode != null) {
                long aggClassOutputCardinality = estimatePreaggDuplicate ? prevAggNode.aggClassOutputCardinality_.get(aggIdx).longValue() : prevAggNode.aggClassNumGroups_.get(aggIdx).longValue();
                inputCardinality = MathUtil.smallestValidCardinality(inputCardinality, aggClassOutputCardinality);
            }
            this.resourceProfiles_.add(this.computeAggClassResourceProfile(queryOptions, aggregateInfo, inputCardinality, maxMemoryEstimatePerInstance));
            ++aggIdx;
        }
        ResourceProfile totalResource = ResourceProfile.noReservation(0L);
        if (this.aggInfos_.size() == 1) {
            totalResource = this.resourceProfiles_.get(0);
        } else {
            for (ResourceProfile aggProfile : this.resourceProfiles_) {
                totalResource = totalResource.sum(aggProfile);
            }
        }
        if (this.aggInfos_.size() > 1 && biasToSpill) {
            ResourceProfileBuilder resourceProfileBuilder = new ResourceProfileBuilder().setMemEstimateBytes(totalResource.getMemEstimateBytes()).setMinMemReservationBytes(totalResource.getMinMemReservationBytes()).setThreadReservation(totalResource.getThreadReservation()).setMemEstimateScale(queryOptions.getMem_estimate_scale_for_spilling_operator(), maxMemoryEstimatePerInstance);
            if (totalResource.getMaxMemReservationBytes() > 0L) {
                resourceProfileBuilder.setMaxMemReservationBytes(totalResource.getMaxMemReservationBytes());
            }
            this.nodeResourceProfile_ = resourceProfileBuilder.build();
        } else {
            this.nodeResourceProfile_ = totalResource;
        }
    }

    private long estimatePerInstanceDataBytes(long perInstanceCardinality, long inputCardinality) {
        Preconditions.checkArgument((perInstanceCardinality > -1L ? 1 : 0) != 0);
        if (inputCardinality != -1L) {
            long numInstances = this.fragment_.getNumInstances();
            long perInstanceInputCardinality = numInstances > 1L ? (this.useStreamingPreagg_ ? (long)Math.ceil((double)inputCardinality / (double)numInstances * 1.5) : (long)Math.ceil((double)inputCardinality / (double)numInstances)) : inputCardinality;
            perInstanceCardinality = this.useStreamingPreagg_ ? Math.min(perInstanceCardinality, perInstanceInputCardinality / 2L) : Math.min(perInstanceCardinality, perInstanceInputCardinality);
        }
        long perInstanceDataBytes = (long)Math.ceil((double)perInstanceCardinality * ((double)this.avgRowSize_ + 12.0));
        return perInstanceDataBytes;
    }

    private ResourceProfile computeAggClassResourceProfile(TQueryOptions queryOptions, AggregateInfo aggInfo, long inputCardinality, long maxMemoryEstimatePerInstance) {
        long perInstanceMinMemReservation;
        long perInstanceMemEstimate;
        Preconditions.checkNotNull((Object)this.fragment_, (Object)"PlanNode must be placed into a fragment before calling this method.");
        long perInstanceCardinality = this.fragment_.getPerInstanceNdv(aggInfo.getGroupingExprs(), false);
        long perInstanceDataBytes = -1L;
        long largeAggMemThreshold = Long.MAX_VALUE;
        if (this.useStreamingPreagg_ && queryOptions.getPreagg_bytes_limit() > 0L) {
            largeAggMemThreshold = queryOptions.getPreagg_bytes_limit();
        } else if (queryOptions.getLarge_agg_mem_threshold() > 0L) {
            largeAggMemThreshold = queryOptions.getLarge_agg_mem_threshold();
        }
        if (perInstanceCardinality == -1L) {
            perInstanceMemEstimate = 0x8000000L;
        } else {
            perInstanceDataBytes = this.estimatePerInstanceDataBytes(perInstanceCardinality, inputCardinality);
            if (perInstanceDataBytes > largeAggMemThreshold) {
                long lowPerInstanceCardinality = this.fragment_.getPerInstanceNdv(aggInfo.getGroupingExprs(), true);
                Preconditions.checkState((lowPerInstanceCardinality > -1L ? 1 : 0) != 0);
                long lowPerInstanceDataBytes = Math.max(largeAggMemThreshold, this.estimatePerInstanceDataBytes(lowPerInstanceCardinality, inputCardinality));
                Preconditions.checkState((lowPerInstanceDataBytes <= perInstanceDataBytes ? 1 : 0) != 0);
                long nonLiteralExprCount = aggInfo.getGroupingExprs().stream().filter(e -> !(e instanceof LiteralExpr)).count();
                double corrFactor = queryOptions.getAgg_mem_correlation_factor();
                double memScale = Math.pow(1.0 - corrFactor, Math.max(0L, nonLiteralExprCount - 1L));
                long resolvedPerInstanceDataBytes = lowPerInstanceDataBytes + Math.round(memScale * (double)(perInstanceDataBytes - lowPerInstanceDataBytes));
                if (LOG.isTraceEnabled() && perInstanceDataBytes > resolvedPerInstanceDataBytes) {
                    LOG.trace("Node " + this.getDisplayLabel() + " reduce perInstanceDataBytes from " + perInstanceDataBytes + " to " + resolvedPerInstanceDataBytes);
                }
                perInstanceDataBytes = resolvedPerInstanceDataBytes;
            }
            perInstanceMemEstimate = aggInfo.getGroupingExprs().isEmpty() ? 16384L : Math.max(perInstanceDataBytes, 0xA00000L);
        }
        long bufferSize = queryOptions.getDefault_spillable_buffer_size();
        long maxRowBufferSize = AggregationNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
        if (aggInfo.getGroupingExprs().isEmpty()) {
            perInstanceMinMemReservation = 0L;
        } else {
            int PARTITION_FANOUT = 16;
            if (perInstanceDataBytes != -1L) {
                long bytesPerPartition = perInstanceDataBytes / 16L;
                bufferSize = Math.min(bufferSize, Math.max(queryOptions.getMin_spillable_buffer_size(), BitUtil.roundUpToPowerOf2(bytesPerPartition)));
                maxRowBufferSize = AggregationNode.computeMaxSpillableBufferSize(bufferSize, queryOptions.getMax_row_size());
            }
            if (this.useStreamingPreagg_) {
                perInstanceMinMemReservation = bufferSize * 16L + Math.max(0x100000L, bufferSize);
            } else {
                long minBuffers = 17 + (aggInfo.needsSerialize() ? 1 : 0);
                perInstanceMinMemReservation = bufferSize * (minBuffers - 2L) + maxRowBufferSize * 2L;
            }
        }
        ResourceProfileBuilder builder = new ResourceProfileBuilder().setMemEstimateBytes(perInstanceMemEstimate).setMinMemReservationBytes(perInstanceMinMemReservation).setSpillableBufferBytes(bufferSize).setMaxRowBufferBytes(maxRowBufferSize);
        if (this.useStreamingPreagg_ && queryOptions.getPreagg_bytes_limit() > 0L) {
            long maxReservationBytes = Math.max(perInstanceMinMemReservation, queryOptions.getPreagg_bytes_limit());
            builder.setMaxMemReservationBytes(maxReservationBytes);
            builder.setMemEstimateBytes(Math.min(perInstanceMemEstimate, maxReservationBytes));
        }
        if (AggregationNode.shouldComputeResourcesWithSpill(queryOptions)) {
            builder.setMemEstimateScale(queryOptions.getMem_estimate_scale_for_spilling_operator(), maxMemoryEstimatePerInstance);
        }
        return builder.build();
    }

    public void setIsNonCorrelatedScalarSubquery(boolean val) {
        this.isNonCorrelatedScalarSubquery_ = val;
    }

    public boolean isNonCorrelatedScalarSubquery() {
        return this.isNonCorrelatedScalarSubquery_;
    }

    public boolean canCompleteEarly() {
        return this.isSingleClassAgg() && this.hasLimit() && this.hasGrouping() && !this.multiAggInfo_.hasAggregateExprs() && this.getConjuncts().isEmpty();
    }

    @Override
    public boolean isTupleCachingImplemented() {
        return true;
    }
}

