/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.hive.executor.HiveGenericJavaFunction;
import org.apache.impala.hive.executor.HiveLegacyJavaFunction;
import org.apache.impala.hive.executor.HiveUdfExecutor;
import org.apache.impala.hive.executor.HiveUdfExecutorGeneric;
import org.apache.impala.hive.executor.HiveUdfExecutorLegacy;
import org.apache.impala.hive.executor.HiveUdfLoader;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.thrift.THiveUdfExecutorCtorParams;
import org.apache.log4j.Logger;
import org.apache.thrift.protocol.TBinaryProtocol;

public class UdfExecutor
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(UdfExecutor.class);
    private static final TBinaryProtocol.Factory PROTOCOL_FACTORY = new TBinaryProtocol.Factory();
    private final HiveUdfExecutor hiveUdfExecutor_;
    private HiveUdfLoader udfLoader_;

    public UdfExecutor(byte[] thriftParams) throws ImpalaException {
        THiveUdfExecutorCtorParams request = new THiveUdfExecutorCtorParams();
        JniUtil.deserializeThrift(PROTOCOL_FACTORY, request, thriftParams);
        String location = null;
        try {
            if (request.local_location != null) {
                location = new File(request.local_location).toURI().toString();
            }
        }
        catch (Exception e) {
            String errorMsg = "Could not load jar file " + request.local_location;
            throw new ImpalaRuntimeException(errorMsg, e);
        }
        try {
            this.checkValidRequest(request);
            this.udfLoader_ = new HiveUdfLoader(location, request.fn.scalar_fn.symbol);
            this.hiveUdfExecutor_ = this.createHiveUdfExecutor(request, this.udfLoader_);
            LOG.debug((Object)("Loaded UDF '" + request.fn.scalar_fn.symbol + "' from " + request.local_location));
        }
        catch (Exception e) {
            String errorMsg = "Could not load class " + request.fn.scalar_fn.symbol + " from jar " + location + ": " + e.getMessage();
            throw new ImpalaRuntimeException(errorMsg, e);
        }
    }

    @Override
    public void close() {
        this.hiveUdfExecutor_.close();
        this.udfLoader_.close();
    }

    public void evaluate() throws ImpalaRuntimeException {
        this.hiveUdfExecutor_.evaluate();
    }

    public long evaluateForTesting(Object ... args) throws ImpalaRuntimeException {
        return this.hiveUdfExecutor_.evaluateForTesting(args);
    }

    public Method getMethod() {
        return this.hiveUdfExecutor_.getMethod();
    }

    private HiveUdfExecutor createHiveUdfExecutor(THiveUdfExecutorCtorParams request, HiveUdfLoader udfLoader) throws ImpalaRuntimeException {
        try {
            switch (udfLoader.getUDFClassType()) {
                case UDF: {
                    HiveLegacyJavaFunction function = new HiveLegacyJavaFunction(udfLoader.getUDFClass(), HiveUdfExecutor.getRetType(request), HiveUdfExecutor.getParameterTypes(request));
                    return new HiveUdfExecutorLegacy(request, function);
                }
                case GENERIC_UDF: {
                    HiveGenericJavaFunction function = new HiveGenericJavaFunction(udfLoader.getUDFClass(), HiveUdfExecutor.getRetType(request), HiveUdfExecutor.getParameterTypes(request));
                    return new HiveUdfExecutorGeneric(request, function);
                }
            }
            throw new ImpalaRuntimeException("The class " + request.fn.scalar_fn.symbol + " does not derive from a known supported Hive UDF class (UDF or GenericUDF).");
        }
        catch (CatalogException e) {
            throw new ImpalaRuntimeException(e.getMessage(), e);
        }
    }

    private void checkValidRequest(THiveUdfExecutorCtorParams request) throws ImpalaRuntimeException {
        Type retType = Type.fromThrift(request.fn.ret_type);
        if (!JavaUdfDataType.isSupported(retType)) {
            throw new ImpalaRuntimeException("Unsupported return type: " + retType.toSql());
        }
    }
}

