/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.log4j.Logger;

public class HiveUdfLoader
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(HiveUdfLoader.class);
    private final Class<?> udfClass_;
    private final FunctionUtils.UDFClassType classType_;
    private final ClassLoader classLoader_;
    private boolean isClassLoaderClosed_;

    public HiveUdfLoader(String localJarPath, String className) throws CatalogException {
        LOG.debug((Object)("Loading UDF '" + className + "' from " + localJarPath));
        this.classLoader_ = HiveUdfLoader.getClassLoader(localJarPath);
        this.udfClass_ = HiveUdfLoader.loadUDFClass(className, this.classLoader_);
        this.classType_ = FunctionUtils.getUDFClassType(this.udfClass_);
    }

    public Class<?> getUDFClass() {
        return this.udfClass_;
    }

    @Override
    public void close() {
        if (!(this.classLoader_ instanceof URLClassLoader)) {
            return;
        }
        if (this.isClassLoaderClosed_) {
            return;
        }
        URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader_;
        try {
            urlClassLoader.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to close classloader: " + e.getMessage()));
        }
        this.isClassLoaderClosed_ = true;
    }

    public FunctionUtils.UDFClassType getUDFClassType() {
        return this.classType_;
    }

    private static Class<?> loadUDFClass(String className, ClassLoader classLoader) throws CatalogException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException c) {
            String errorMsg = className + " not found in Jar.";
            throw new CatalogException(errorMsg, c);
        }
        catch (LinkageError e) {
            String errorMsg = "Error resolving dependencies.";
            throw new CatalogException("Error resolving dependencies for class " + className + ".", e);
        }
        catch (Exception e) {
            throw new CatalogException("Error loading class " + className + ".", e);
        }
    }

    private static ClassLoader getClassLoader(String jarPath) throws CatalogException {
        try {
            if (jarPath == null) {
                return ClassLoader.getSystemClassLoader();
            }
            URL[] classLoaderUrls = new URL[]{new URL(jarPath)};
            return new URLClassLoader(classLoaderUrls);
        }
        catch (MalformedURLException e) {
            throw new CatalogException("Unable to load jar " + jarPath, e);
        }
    }

    public static HiveUdfLoader createWithLocalPath(String localLibPath, Function fn) throws CatalogException {
        Path localJarPath = null;
        String fullFunctionName = fn.getDbName() + "." + fn.getFunctionName();
        String uri = ((ResourceUri)fn.getResourceUris().get(0)).getUri();
        try {
            String localJarPathString = null;
            if (uri != null) {
                localJarPath = new Path("file://" + localLibPath, UUID.randomUUID().toString() + ".jar");
                Preconditions.checkNotNull((Object)localJarPath);
                try {
                    FileSystemUtil.copyToLocal(new Path(uri), localJarPath);
                }
                catch (IOException e) {
                    String errorMsg = "Couldn't copy " + uri + " to local path: " + localJarPath.toString();
                    LOG.error((Object)errorMsg, (Throwable)e);
                    throw new CatalogException(errorMsg);
                }
                localJarPathString = localJarPath.toString();
            }
            HiveUdfLoader e = new HiveUdfLoader(localJarPathString, fn.getClassName());
            return e;
        }
        catch (Exception e) {
            String errorMsg = "Could not load class " + fn.getClassName() + " from jar " + uri + ": " + e.getMessage();
            throw new CatalogException(errorMsg, e);
        }
        finally {
            if (localJarPath != null) {
                FileSystemUtil.deleteIfExists(localJarPath);
            }
        }
    }
}

