/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.hive.executor.HiveLegacyJavaFunction;
import org.apache.impala.hive.executor.HiveUdfExecutor;
import org.apache.impala.hive.executor.ImpalaBigIntWritable;
import org.apache.impala.hive.executor.ImpalaBooleanWritable;
import org.apache.impala.hive.executor.ImpalaBytesWritable;
import org.apache.impala.hive.executor.ImpalaDoubleWritable;
import org.apache.impala.hive.executor.ImpalaFloatWritable;
import org.apache.impala.hive.executor.ImpalaIntWritable;
import org.apache.impala.hive.executor.ImpalaSmallIntWritable;
import org.apache.impala.hive.executor.ImpalaTextWritable;
import org.apache.impala.hive.executor.ImpalaTinyIntWritable;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.thrift.THiveUdfExecutorCtorParams;
import org.apache.impala.util.UnsafeUtil;

public class HiveUdfExecutorLegacy
extends HiveUdfExecutor {
    private UDF udf_;
    private Method method_;
    private final Object[] inputArgs_;

    public HiveUdfExecutorLegacy(THiveUdfExecutorCtorParams request, HiveLegacyJavaFunction hiveJavaFn) throws ImpalaRuntimeException {
        super(request, JavaUdfDataType.getType(hiveJavaFn.getRetType()), JavaUdfDataType.getTypes(hiveJavaFn.getParameterTypes()));
        this.udf_ = hiveJavaFn.getUDFInstance();
        this.method_ = hiveJavaFn.getMethod();
        this.inputArgs_ = new Object[this.getNumParams()];
    }

    @Override
    public void closeDerived() {
        this.method_ = null;
    }

    @Override
    protected Object evaluateDerived(JavaUdfDataType[] argTypes, long inputNullsPtr, Object ... inputObjects) throws ImpalaRuntimeException {
        try {
            for (int i = 0; i < argTypes.length; ++i) {
                if (UnsafeUtil.UNSAFE.getByte(inputNullsPtr + (long)i) == 0) {
                    switch (argTypes[i]) {
                        case BOOLEAN_WRITABLE: 
                        case BYTE_WRITABLE: 
                        case SHORT_WRITABLE: 
                        case INT_WRITABLE: 
                        case LONG_WRITABLE: 
                        case FLOAT_WRITABLE: 
                        case DOUBLE_WRITABLE: {
                            this.inputArgs_[i] = inputObjects[i];
                            break;
                        }
                        case BYTE_ARRAY: 
                        case BYTES_WRITABLE: {
                            ((ImpalaBytesWritable)inputObjects[i]).reload();
                            this.inputArgs_[i] = inputObjects[i];
                            break;
                        }
                        case TEXT: {
                            ((ImpalaTextWritable)inputObjects[i]).reload();
                            this.inputArgs_[i] = inputObjects[i];
                            break;
                        }
                        case BOOLEAN: {
                            this.inputArgs_[i] = ((ImpalaBooleanWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case TINYINT: {
                            this.inputArgs_[i] = ((ImpalaTinyIntWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case SMALLINT: {
                            this.inputArgs_[i] = ((ImpalaSmallIntWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case INT: {
                            this.inputArgs_[i] = ((ImpalaIntWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case BIGINT: {
                            this.inputArgs_[i] = ((ImpalaBigIntWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case FLOAT: {
                            this.inputArgs_[i] = Float.valueOf(((ImpalaFloatWritable)((Object)inputObjects[i])).get());
                            break;
                        }
                        case DOUBLE: {
                            this.inputArgs_[i] = ((ImpalaDoubleWritable)((Object)inputObjects[i])).get();
                            break;
                        }
                        case STRING: {
                            Preconditions.checkState((boolean)(inputObjects[i] instanceof ImpalaBytesWritable));
                            ImpalaBytesWritable inputObject = (ImpalaBytesWritable)inputObjects[i];
                            inputObject.reload();
                            this.inputArgs_[i] = new String(inputObject.getBytes());
                        }
                    }
                    continue;
                }
                this.inputArgs_[i] = null;
            }
            return this.method_.invoke((Object)this.udf_, this.inputArgs_);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new ImpalaRuntimeException("UDF::evaluate() ran into a problem.", e);
        }
    }

    @Override
    public Method getMethod() {
        return this.method_;
    }
}

