/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import java.lang.reflect.Method;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.hive.executor.ImpalaBigIntWritable;
import org.apache.impala.hive.executor.ImpalaBooleanWritable;
import org.apache.impala.hive.executor.ImpalaBytesWritable;
import org.apache.impala.hive.executor.ImpalaDoubleWritable;
import org.apache.impala.hive.executor.ImpalaFloatWritable;
import org.apache.impala.hive.executor.ImpalaIntWritable;
import org.apache.impala.hive.executor.ImpalaSmallIntWritable;
import org.apache.impala.hive.executor.ImpalaTextWritable;
import org.apache.impala.hive.executor.ImpalaTinyIntWritable;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.thrift.THiveUdfExecutorCtorParams;
import org.apache.impala.util.UnsafeUtil;
import org.apache.log4j.Logger;

public abstract class HiveUdfExecutor {
    private static final Logger LOG = Logger.getLogger(HiveUdfExecutor.class);
    private final JavaUdfDataType[] argTypes_;
    private final JavaUdfDataType retType_;
    private final long inputBufferPtr_;
    private final long inputNullsPtr_;
    private final int[] inputBufferOffsets_;
    private final long outputBufferPtr_;
    private final long outputNullPtr_;
    private long outBufferStringPtr_;
    private int outBufferStringCapacity_;
    private final Writable[] inputObjects_;

    protected HiveUdfExecutor(THiveUdfExecutorCtorParams request, JavaUdfDataType retType, JavaUdfDataType[] argTypes) throws ImpalaRuntimeException {
        this.retType_ = retType;
        this.argTypes_ = argTypes;
        this.inputBufferPtr_ = request.input_buffer_ptr;
        this.inputNullsPtr_ = request.input_nulls_ptr;
        this.outputBufferPtr_ = request.output_buffer_ptr;
        this.outputNullPtr_ = request.output_null_ptr;
        this.outBufferStringPtr_ = 0L;
        this.outBufferStringCapacity_ = 0;
        this.inputBufferOffsets_ = new int[request.input_byte_offsets.size()];
        for (int i = 0; i < request.input_byte_offsets.size(); ++i) {
            this.inputBufferOffsets_[i] = request.input_byte_offsets.get(i);
        }
        this.inputObjects_ = new Writable[this.argTypes_.length];
        this.allocateInputObjects();
    }

    public void close() {
        UnsafeUtil.UNSAFE.freeMemory(this.outBufferStringPtr_);
        this.outBufferStringPtr_ = 0L;
        this.outBufferStringCapacity_ = 0;
        this.closeDerived();
    }

    public long evaluate() throws ImpalaRuntimeException {
        return this.storeUdfResult(this.evaluateDerived(this.argTypes_, this.inputNullsPtr_, this.inputObjects_));
    }

    public long evaluateForTesting(Object ... args) throws ImpalaRuntimeException {
        return this.storeUdfResult(this.evaluateDerived(this.argTypes_, this.inputNullsPtr_, args));
    }

    protected long storeUdfResult(Object obj) throws ImpalaRuntimeException {
        if (obj == null) {
            UnsafeUtil.UNSAFE.putByte(this.outputNullPtr_, (byte)1);
            return 0L;
        }
        UnsafeUtil.UNSAFE.putByte(this.outputNullPtr_, (byte)0);
        switch (this.retType_) {
            case BOOLEAN_WRITABLE: {
                BooleanWritable val = (BooleanWritable)obj;
                UnsafeUtil.UNSAFE.putByte(this.outputBufferPtr_, val.get() ? (byte)1 : 0);
                return this.outputBufferPtr_;
            }
            case BOOLEAN: {
                UnsafeUtil.UNSAFE.putByte(this.outputBufferPtr_, (Boolean)obj != false ? (byte)1 : 0);
                return this.outputBufferPtr_;
            }
            case BYTE_WRITABLE: {
                ByteWritable val = (ByteWritable)obj;
                UnsafeUtil.UNSAFE.putByte(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case TINYINT: {
                UnsafeUtil.UNSAFE.putByte(this.outputBufferPtr_, (Byte)obj);
                return this.outputBufferPtr_;
            }
            case SHORT_WRITABLE: {
                ShortWritable val = (ShortWritable)obj;
                UnsafeUtil.UNSAFE.putShort(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case SMALLINT: {
                UnsafeUtil.UNSAFE.putShort(this.outputBufferPtr_, (Short)obj);
                return this.outputBufferPtr_;
            }
            case INT_WRITABLE: {
                IntWritable val = (IntWritable)obj;
                UnsafeUtil.UNSAFE.putInt(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case INT: {
                UnsafeUtil.UNSAFE.putInt(this.outputBufferPtr_, (Integer)obj);
                return this.outputBufferPtr_;
            }
            case LONG_WRITABLE: {
                LongWritable val = (LongWritable)obj;
                UnsafeUtil.UNSAFE.putLong(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case BIGINT: {
                UnsafeUtil.UNSAFE.putLong(this.outputBufferPtr_, (Long)obj);
                return this.outputBufferPtr_;
            }
            case FLOAT_WRITABLE: {
                FloatWritable val = (FloatWritable)obj;
                UnsafeUtil.UNSAFE.putFloat(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case FLOAT: {
                UnsafeUtil.UNSAFE.putFloat(this.outputBufferPtr_, ((Float)obj).floatValue());
                return this.outputBufferPtr_;
            }
            case DOUBLE_WRITABLE: {
                DoubleWritable val = (DoubleWritable)obj;
                UnsafeUtil.UNSAFE.putDouble(this.outputBufferPtr_, val.get());
                return this.outputBufferPtr_;
            }
            case DOUBLE: {
                UnsafeUtil.UNSAFE.putDouble(this.outputBufferPtr_, (Double)obj);
                return this.outputBufferPtr_;
            }
            case TEXT: {
                this.copyBytesToOutputBuffer(((Text)obj).copyBytes());
                return this.outputBufferPtr_;
            }
            case BYTE_ARRAY: {
                this.copyBytesToOutputBuffer((byte[])obj);
                return this.outputBufferPtr_;
            }
            case BYTES_WRITABLE: {
                this.copyBytesToOutputBuffer(((BytesWritable)obj).copyBytes());
                return this.outputBufferPtr_;
            }
            case STRING: {
                this.copyBytesToOutputBuffer(((String)obj).getBytes());
                return this.outputBufferPtr_;
            }
        }
        throw new ImpalaRuntimeException("Unsupported return type: " + (Object)((Object)this.retType_));
    }

    protected int getNumParams() {
        return this.inputObjects_.length;
    }

    protected Object getInputObject(int i) {
        return this.inputObjects_[i];
    }

    private void copyBytesToOutputBuffer(byte[] bytes) {
        if (bytes.length > this.outBufferStringCapacity_) {
            this.outBufferStringPtr_ = UnsafeUtil.UNSAFE.reallocateMemory(this.outBufferStringPtr_, bytes.length);
            this.outBufferStringCapacity_ = bytes.length;
            UnsafeUtil.UNSAFE.putLong(this.outputBufferPtr_, this.outBufferStringPtr_);
        }
        UnsafeUtil.Copy(this.outBufferStringPtr_, bytes, 0, bytes.length);
        UnsafeUtil.UNSAFE.putInt(this.outputBufferPtr_ + 8L, bytes.length);
    }

    private void allocateInputObjects() throws ImpalaRuntimeException {
        block12: for (int i = 0; i < this.argTypes_.length; ++i) {
            int offset = this.inputBufferOffsets_[i];
            switch (this.argTypes_[i]) {
                case BOOLEAN_WRITABLE: 
                case BOOLEAN: {
                    this.inputObjects_[i] = new ImpalaBooleanWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case BYTE_WRITABLE: 
                case TINYINT: {
                    this.inputObjects_[i] = new ImpalaTinyIntWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case SHORT_WRITABLE: 
                case SMALLINT: {
                    this.inputObjects_[i] = new ImpalaSmallIntWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case INT_WRITABLE: 
                case INT: {
                    this.inputObjects_[i] = new ImpalaIntWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case LONG_WRITABLE: 
                case BIGINT: {
                    this.inputObjects_[i] = new ImpalaBigIntWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case FLOAT_WRITABLE: 
                case FLOAT: {
                    this.inputObjects_[i] = new ImpalaFloatWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case DOUBLE_WRITABLE: 
                case DOUBLE: {
                    this.inputObjects_[i] = new ImpalaDoubleWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case TEXT: {
                    this.inputObjects_[i] = new ImpalaTextWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case BYTES_WRITABLE: {
                    this.inputObjects_[i] = new ImpalaBytesWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                case STRING: {
                    this.inputObjects_[i] = new ImpalaBytesWritable(this.inputBufferPtr_ + (long)offset);
                    continue block12;
                }
                default: {
                    throw new ImpalaRuntimeException("Unsupported argument type: " + (Object)((Object)this.argTypes_[i]));
                }
            }
        }
    }

    public static Type getRetType(THiveUdfExecutorCtorParams request) {
        return Type.fromThrift(request.fn.ret_type);
    }

    public static Type[] getParameterTypes(THiveUdfExecutorCtorParams request) {
        Type[] parameterTypes = new Type[request.fn.arg_types.size()];
        for (int i = 0; i < request.fn.arg_types.size(); ++i) {
            parameterTypes[i] = Type.fromThrift(request.fn.arg_types.get(i));
        }
        return parameterTypes;
    }

    protected abstract void closeDerived();

    protected abstract Object evaluateDerived(JavaUdfDataType[] var1, long var2, Object[] var4) throws ImpalaRuntimeException;

    public abstract Method getMethod();
}

