/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.hive.executor.HiveGenericJavaFunction;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveJavaFunctionFactory;
import org.apache.impala.hive.executor.HiveLegacyJavaFunction;
import org.apache.impala.hive.executor.HiveUdfLoader;

public class HiveJavaFunctionFactoryImpl
implements HiveJavaFunctionFactory {
    private final String localLibPath_;

    public HiveJavaFunctionFactoryImpl(String localLibPath) {
        this.localLibPath_ = localLibPath;
    }

    @Override
    public HiveJavaFunction create(Function hiveFn, Type retType, Type[] paramTypes) throws CatalogException {
        this.checkValidFunction(hiveFn);
        String jarUri = ((ResourceUri)hiveFn.getResourceUris().get(0)).getUri();
        String fnName = hiveFn.getDbName() + "." + hiveFn.getFunctionName();
        Throwable throwable = null;
        try (HiveUdfLoader javaClass = HiveUdfLoader.createWithLocalPath(this.localLibPath_, hiveFn);){
            switch (javaClass.getUDFClassType()) {
                case UDF: {
                    HiveLegacyJavaFunction hiveLegacyJavaFunction = new HiveLegacyJavaFunction(javaClass.getUDFClass(), hiveFn, retType, paramTypes);
                    return hiveLegacyJavaFunction;
                }
                case GENERIC_UDF: {
                    HiveGenericJavaFunction hiveGenericJavaFunction = new HiveGenericJavaFunction(javaClass.getUDFClass(), hiveFn, retType, paramTypes);
                    return hiveGenericJavaFunction;
                }
            }
            try {
                throw new CatalogException("Function " + fnName + ": The class " + jarUri + " does not derive from a known supported Hive UDF class (UDF).");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public HiveJavaFunction create(ScalarFunction fn) throws CatalogException {
        if (fn.hasVarArgs()) {
            throw new CatalogException("Variable arguments not supported in Hive UDFs.");
        }
        return this.create(HiveJavaFunction.toHiveFunction(fn), fn.getReturnType(), fn.getArgs());
    }

    @Override
    public HiveJavaFunction create(Function hiveFn) throws CatalogException {
        return this.create(hiveFn, null, null);
    }

    private void checkValidFunction(Function fn) throws CatalogException {
        String errorPrefix = "Skipping load of incompatible function: " + fn.getFunctionName() + ". ";
        if (fn.getFunctionType() != FunctionType.JAVA) {
            throw new CatalogException(errorPrefix + "Function type: " + fn.getFunctionType().name() + " is not supported. Only " + FunctionType.JAVA.name() + " functions are supported.");
        }
        if (fn.getResourceUrisSize() == 0) {
            throw new CatalogException(errorPrefix + "No executable binary resource (like a JAR file) is associated with this function. To fix this, recreate the function by specifying a 'location' in the function create statement.");
        }
        if (fn.getResourceUrisSize() != 1) {
            ArrayList<String> resourceUris = new ArrayList<String>();
            for (ResourceUri resource : fn.getResourceUris()) {
                resourceUris.add(resource.getUri());
            }
            throw new CatalogException(errorPrefix + "Impala does not support multiple Jars for dependencies. (" + Joiner.on((String)",").join(resourceUris) + ") ");
        }
        if (((ResourceUri)fn.getResourceUris().get(0)).getResourceType() != ResourceType.JAR) {
            throw new CatalogException(errorPrefix + "Function binary type: " + ((ResourceUri)fn.getResourceUris().get(0)).getResourceType().name() + " is not supported. Only " + ResourceType.JAR.name() + " type is supported.");
        }
    }
}

