/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.common;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableValidReaderWriteIdList
implements MutableValidWriteIdList {
    private static final Logger LOG = LoggerFactory.getLogger(MutableValidReaderWriteIdList.class);
    private String tableName;
    private List<Long> exceptions;
    private BitSet abortedBits;
    private long minOpenWriteId = Long.MAX_VALUE;
    private long highWatermark;

    public MutableValidReaderWriteIdList(ValidWriteIdList writeIdList) {
        this.readFromString(writeIdList.writeToString());
    }

    public boolean isWriteIdValid(long writeId) {
        if (writeId > this.highWatermark) {
            return false;
        }
        return Collections.binarySearch(this.exceptions, writeId) < 0;
    }

    public boolean isValidBase(long writeId) {
        return writeId < this.minOpenWriteId && writeId <= this.highWatermark;
    }

    public ValidWriteIdList.RangeResponse isWriteIdRangeValid(long minWriteId, long maxWriteId) {
        if (minWriteId > this.highWatermark) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        if (this.exceptions.size() > 0 && this.exceptions.get(0) > maxWriteId) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        long count = Math.max(0L, maxWriteId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minWriteId > txn || txn > maxWriteId) continue;
            ++count;
        }
        if (count == 0L) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        if (count == maxWriteId - minWriteId + 1L) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        return ValidWriteIdList.RangeResponse.SOME;
    }

    public String toString() {
        return this.writeToString();
    }

    public String writeToString() {
        StringBuilder buf = new StringBuilder();
        if (this.tableName == null) {
            buf.append("null");
        } else {
            buf.append(this.tableName);
        }
        buf.append(':');
        buf.append(this.highWatermark);
        buf.append(':');
        buf.append(this.minOpenWriteId);
        StringBuilder open = new StringBuilder();
        StringBuilder abort = new StringBuilder();
        for (int i = 0; i < this.exceptions.size(); ++i) {
            if (this.abortedBits.get(i)) {
                if (abort.length() > 0) {
                    abort.append(',');
                }
                abort.append(this.exceptions.get(i));
                continue;
            }
            if (open.length() > 0) {
                open.append(',');
            }
            open.append(this.exceptions.get(i));
        }
        buf.append(':');
        buf.append((CharSequence)open);
        buf.append(':');
        buf.append((CharSequence)abort);
        return buf.toString();
    }

    public void readFromString(String src) {
        if (src == null || src.length() == 0) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new ArrayList<Long>();
            this.abortedBits = new BitSet();
        } else {
            String[] values = src.split(":");
            Preconditions.checkState((values.length >= 3 ? 1 : 0) != 0, (Object)"Not enough values");
            this.tableName = values[0];
            if (this.tableName.equalsIgnoreCase("null")) {
                this.tableName = null;
            }
            this.highWatermark = Long.parseLong(values[1]);
            this.minOpenWriteId = Long.parseLong(values[2]);
            String[] openWriteIds = new String[]{};
            String[] abortedWriteIds = new String[]{};
            if (values.length < 4) {
                openWriteIds = new String[]{};
                abortedWriteIds = new String[]{};
            } else if (values.length == 4) {
                if (!values[3].isEmpty()) {
                    openWriteIds = values[3].split(",");
                }
            } else {
                if (!values[3].isEmpty()) {
                    openWriteIds = values[3].split(",");
                }
                if (!values[4].isEmpty()) {
                    abortedWriteIds = values[4].split(",");
                }
            }
            this.exceptions = new ArrayList<Long>(openWriteIds.length + abortedWriteIds.length);
            for (String open : openWriteIds) {
                this.exceptions.add(Long.parseLong(open));
            }
            for (String abort : abortedWriteIds) {
                this.exceptions.add(Long.parseLong(abort));
            }
            Collections.sort(this.exceptions);
            this.abortedBits = new BitSet(this.exceptions.size());
            for (String abort : abortedWriteIds) {
                int index = Collections.binarySearch(this.exceptions, Long.parseLong(abort));
                this.abortedBits.set(index);
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getHighWatermark() {
        return this.highWatermark;
    }

    public long[] getInvalidWriteIds() {
        return Longs.toArray(this.exceptions);
    }

    public Long getMinOpenWriteId() {
        return this.minOpenWriteId == Long.MAX_VALUE ? null : Long.valueOf(this.minOpenWriteId);
    }

    public boolean isWriteIdAborted(long writeId) {
        int index = Collections.binarySearch(this.exceptions, writeId);
        return index >= 0 && this.abortedBits.get(index);
    }

    public ValidWriteIdList.RangeResponse isWriteIdRangeAborted(long minWriteId, long maxWriteId) {
        long abortedTxnId;
        if (this.highWatermark < minWriteId) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        int count = 0;
        int i = this.abortedBits.nextSetBit(0);
        while (i >= 0 && (abortedTxnId = this.exceptions.get(i).longValue()) <= maxWriteId) {
            if (abortedTxnId >= minWriteId && abortedTxnId <= maxWriteId) {
                ++count;
            }
            i = this.abortedBits.nextSetBit(i + 1);
        }
        if (count == 0) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        if ((long)count == maxWriteId - minWriteId + 1L) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        return ValidWriteIdList.RangeResponse.SOME;
    }

    @Override
    public boolean isWriteIdOpen(long writeId) {
        int index = Collections.binarySearch(this.exceptions, writeId);
        return index >= 0 && !this.abortedBits.get(index);
    }

    @Override
    public boolean addOpenWriteId(long writeId) {
        if (writeId <= this.highWatermark) {
            LOG.debug("Not adding open write id: {} since high water mark: {}", (Object)writeId, (Object)this.highWatermark);
            return false;
        }
        for (long currentId = this.highWatermark + 1L; currentId <= writeId; ++currentId) {
            this.exceptions.add(currentId);
        }
        LOG.debug("Added OPEN write id: {}. Old high water mark: {}.", (Object)writeId, (Object)this.highWatermark);
        this.highWatermark = writeId;
        return true;
    }

    @Override
    public boolean addAbortedWriteIds(List<Long> writeIds) {
        Preconditions.checkNotNull(writeIds);
        Preconditions.checkArgument((writeIds.size() > 0 ? 1 : 0) != 0);
        boolean added = false;
        long maxWriteId = Collections.max(writeIds);
        if (maxWriteId > this.highWatermark) {
            LOG.info("Current high water mark: {} and max aborted write id: {}, so mark them as open first", (Object)this.highWatermark, (Object)maxWriteId);
            this.addOpenWriteId(maxWriteId);
            added = true;
        }
        for (long writeId : writeIds) {
            int index = Collections.binarySearch(this.exceptions, writeId);
            if (index < 0) {
                LOG.info("Not added ABORTED write id {} since it's not opened and might already be cleaned up. minOpenWriteId: {}.", (Object)writeId, (Object)this.minOpenWriteId);
                continue;
            }
            added = added || !this.abortedBits.get(index);
            this.abortedBits.set(index);
        }
        this.updateMinOpenWriteId();
        if (!added) {
            LOG.info("Not added any ABORTED write ids of the given {}", (Object)writeIds.size());
        }
        return added;
    }

    @Override
    public boolean addCommittedWriteIds(List<Long> writeIds) {
        Preconditions.checkNotNull(writeIds);
        Preconditions.checkArgument((writeIds.size() > 0 ? 1 : 0) != 0);
        long maxWriteId = Collections.max(writeIds);
        if (maxWriteId > this.highWatermark) {
            LOG.trace("Current high water mark: {} and max committed write id: {}, so mark them as open first", (Object)this.highWatermark, (Object)maxWriteId);
            this.addOpenWriteId(maxWriteId);
        }
        ArrayList<Long> updatedExceptions = new ArrayList<Long>();
        BitSet updatedAbortedBits = new BitSet();
        HashSet<Integer> idxToRemove = new HashSet<Integer>();
        for (long writeId : writeIds) {
            int idx = Collections.binarySearch(this.exceptions, writeId);
            if (idx < 0) continue;
            Preconditions.checkState((!this.abortedBits.get(idx) ? 1 : 0) != 0, (String)"write id %d is expected to be open but is aborted", (long)writeId);
            idxToRemove.add(idx);
        }
        for (int idx = 0; idx < this.exceptions.size(); ++idx) {
            if (idxToRemove.contains(idx)) continue;
            updatedAbortedBits.set(updatedExceptions.size(), this.abortedBits.get(idx));
            updatedExceptions.add(this.exceptions.get(idx));
        }
        this.exceptions = updatedExceptions;
        this.abortedBits = updatedAbortedBits;
        this.updateMinOpenWriteId();
        return !idxToRemove.isEmpty();
    }

    private void updateMinOpenWriteId() {
        int index = this.abortedBits.nextClearBit(0);
        this.minOpenWriteId = index >= this.exceptions.size() ? Long.MAX_VALUE : this.exceptions.get(index);
    }
}

