/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.fb;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.impala.fb.FbFileBlock;

public final class FbFileDesc
extends Table {
    public static FbFileDesc getRootAsFbFileDesc(ByteBuffer _bb) {
        return FbFileDesc.getRootAsFbFileDesc(_bb, new FbFileDesc());
    }

    public static FbFileDesc getRootAsFbFileDesc(ByteBuffer _bb, FbFileDesc obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public FbFileDesc __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String relativePath() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer relativePathAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer relativePathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public long length() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateLength(long length) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, length);
            return true;
        }
        return false;
    }

    public byte compression() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateCompression(byte compression) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, compression);
            return true;
        }
        return false;
    }

    public long lastModificationTime() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateLastModificationTime(long last_modification_time) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, last_modification_time);
            return true;
        }
        return false;
    }

    public FbFileBlock fileBlocks(int j) {
        return this.fileBlocks(new FbFileBlock(), j);
    }

    public FbFileBlock fileBlocks(FbFileBlock obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int fileBlocksLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public boolean isEc() {
        int o = this.__offset(14);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateIsEc(boolean is_ec) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(is_ec ? 1 : 0));
            return true;
        }
        return false;
    }

    public String absolutePath() {
        int o = this.__offset(16);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer absolutePathAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 1);
    }

    public ByteBuffer absolutePathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 16, 1);
    }

    public boolean isEncrypted() {
        int o = this.__offset(18);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateIsEncrypted(boolean is_encrypted) {
        int o = this.__offset(18);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(is_encrypted ? 1 : 0));
            return true;
        }
        return false;
    }

    public static int createFbFileDesc(FlatBufferBuilder builder, int relative_pathOffset, long length, byte compression, long last_modification_time, int file_blocksOffset, boolean is_ec, int absolute_pathOffset, boolean is_encrypted) {
        builder.startObject(8);
        FbFileDesc.addLastModificationTime(builder, last_modification_time);
        FbFileDesc.addLength(builder, length);
        FbFileDesc.addAbsolutePath(builder, absolute_pathOffset);
        FbFileDesc.addFileBlocks(builder, file_blocksOffset);
        FbFileDesc.addRelativePath(builder, relative_pathOffset);
        FbFileDesc.addIsEncrypted(builder, is_encrypted);
        FbFileDesc.addIsEc(builder, is_ec);
        FbFileDesc.addCompression(builder, compression);
        return FbFileDesc.endFbFileDesc(builder);
    }

    public static void startFbFileDesc(FlatBufferBuilder builder) {
        builder.startObject(8);
    }

    public static void addRelativePath(FlatBufferBuilder builder, int relativePathOffset) {
        builder.addOffset(0, relativePathOffset, 0);
    }

    public static void addLength(FlatBufferBuilder builder, long length) {
        builder.addLong(1, length, 0L);
    }

    public static void addCompression(FlatBufferBuilder builder, byte compression) {
        builder.addByte(2, compression, 0);
    }

    public static void addLastModificationTime(FlatBufferBuilder builder, long lastModificationTime) {
        builder.addLong(3, lastModificationTime, 0L);
    }

    public static void addFileBlocks(FlatBufferBuilder builder, int fileBlocksOffset) {
        builder.addOffset(4, fileBlocksOffset, 0);
    }

    public static int createFileBlocksVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startFileBlocksVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addIsEc(FlatBufferBuilder builder, boolean isEc) {
        builder.addBoolean(5, isEc, false);
    }

    public static void addAbsolutePath(FlatBufferBuilder builder, int absolutePathOffset) {
        builder.addOffset(6, absolutePathOffset, 0);
    }

    public static void addIsEncrypted(FlatBufferBuilder builder, boolean isEncrypted) {
        builder.addBoolean(7, isEncrypted, false);
    }

    public static int endFbFileDesc(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

