/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.extdatasource.jdbc.dao.DatabaseAccessor;
import org.apache.impala.extdatasource.thrift.TBinaryPredicate;
import org.apache.impala.extdatasource.thrift.TComparisonOp;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.thrift.TTypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConditionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QueryConditionUtil.class);

    public static String buildCondition(List<List<TBinaryPredicate>> predicates, Map<String, String> columnMapping, DatabaseAccessor dbAccessor_) {
        ArrayList condition = Lists.newArrayList();
        for (List<TBinaryPredicate> tBinaryPredicates : predicates) {
            StringJoiner joiner = new StringJoiner(" OR ", "(", ")");
            for (TBinaryPredicate predicate : tBinaryPredicates) {
                String name = predicate.getCol().getName();
                name = columnMapping.getOrDefault(name, name);
                String op = QueryConditionUtil.converse(predicate.getOp());
                String value = QueryConditionUtil.getTColumnValueAsString(predicate.getValue(), predicate.getCol().getType().getTypes().get(0), dbAccessor_);
                joiner.add(String.format("%s %s %s", name, op, value));
            }
            condition.add(joiner.toString());
        }
        return Joiner.on((String)" AND ").join((Iterable)condition);
    }

    public static String getTColumnValueAsString(TColumnValue value, TTypeNode node, DatabaseAccessor dbAccessor_) {
        Preconditions.checkState((value != null ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        if (value.isSetBool_val()) {
            sb.append(value.bool_val);
        } else if (value.isSetByte_val()) {
            sb.append(value.byte_val);
        } else if (value.isSetShort_val()) {
            sb.append(value.short_val);
        } else if (value.isSetInt_val()) {
            sb.append(value.int_val);
        } else if (value.isSetLong_val()) {
            sb.append(value.long_val);
        } else if (value.isSetDouble_val()) {
            sb.append(value.double_val);
        } else if (value.isSetString_val()) {
            if (node.getScalar_type().getType() == TPrimitiveType.DECIMAL) {
                sb.append(String.format("%s", value.string_val));
            } else {
                sb.append(String.format("'%s'", value.string_val));
            }
        } else if (value.isSetDate_val()) {
            sb.append(String.format("'%s'", dbAccessor_.getDateString(value.date_val)));
        } else {
            throw new IllegalArgumentException("Unsupported data type.");
        }
        return sb.toString();
    }

    public static String converse(TComparisonOp op) {
        for (BinaryPredicate.Operator operator : BinaryPredicate.Operator.values()) {
            if (operator.getThriftOp() != op) continue;
            return operator.toString();
        }
        return null;
    }
}

