/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.dao;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfigManager;
import org.apache.impala.extdatasource.jdbc.dao.DataSourceObjectCache;
import org.apache.impala.extdatasource.jdbc.dao.DatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.JdbcRecordIterator;
import org.apache.impala.extdatasource.jdbc.exception.JdbcDatabaseAccessException;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJdbcDatabaseAccessor
implements DatabaseAccessor {
    protected static final Logger LOG = LoggerFactory.getLogger(GenericJdbcDatabaseAccessor.class);
    protected static final String DBCP_CONFIG_PREFIX = "dbcp";
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final long MILLI_SECONDS_PER_DAY = 86400000L;
    protected DataSource dbcpDataSource = null;
    protected String dataSourceCacheKey = null;
    private static final DataSourceObjectCache dataSourceCache = new DataSourceObjectCache();

    @Override
    public long getTotalNumberOfRecords(Configuration conf) throws JdbcDatabaseAccessException {
        String countQuery;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            this.initializeDatabaseSource(conf);
            String sql = JdbcStorageConfigManager.getQueryToExecute(conf);
            countQuery = "SELECT COUNT(*) FROM (" + sql + ") tmptable";
            LOG.info("Query to execute is [{}]", (Object)countQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(countQuery);
            rs = ps.executeQuery();
            if (!rs.next()) break block6;
            long l = rs.getLong(1);
            this.cleanupResources(conn, ps, rs);
            return l;
        }
        try {
            try {
                LOG.warn("The count query '{}' did not return any results.", (Object)countQuery);
                throw new JdbcDatabaseAccessException("Count query did not return any results.");
            }
            catch (JdbcDatabaseAccessException he) {
                throw he;
            }
            catch (Exception e) {
                LOG.error("Caught exception while trying to get the number of records", (Throwable)e);
                throw new JdbcDatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.cleanupResources(conn, ps, rs);
            throw throwable;
        }
    }

    @Override
    public JdbcRecordIterator getRecordIterator(Configuration conf, int limit, int offset) throws JdbcDatabaseAccessException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.initializeDatabaseSource(conf);
            String sql = JdbcStorageConfigManager.getQueryToExecute(conf);
            String partitionQuery = this.addLimitAndOffsetToQuery(sql, limit, offset);
            LOG.info("Query to execute is [{}]", (Object)partitionQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(partitionQuery, 1003, 1007);
            ps.setFetchSize(this.getFetchSize(conf));
            rs = ps.executeQuery();
            return new JdbcRecordIterator(conn, ps, rs, conf);
        }
        catch (Exception e) {
            LOG.error("Caught exception while trying to execute query", (Throwable)e);
            this.cleanupResources(conn, ps, rs);
            throw new JdbcDatabaseAccessException("Caught exception while trying to execute query:" + e.getMessage(), e);
        }
    }

    @Override
    public void close(Connection connToBeClosed, boolean cleanDbcpDSCache) {
        if (connToBeClosed != null) {
            Preconditions.checkNotNull((Object)this.dbcpDataSource);
            this.invalidateConnection(connToBeClosed);
        }
        Preconditions.checkNotNull((Object)dataSourceCache);
        dataSourceCache.remove(this.dataSourceCacheKey, cleanDbcpDSCache);
        this.dbcpDataSource = null;
    }

    @Override
    public String getCaseSensitiveName(String name) {
        return name;
    }

    protected boolean isAdditionalPropertiesSupported() {
        return false;
    }

    protected String getPropertiesDelimiter(boolean precededDelimiter) {
        return null;
    }

    protected String getAdditionalProperties(String configProperties) {
        if (Strings.isNullOrEmpty((String)configProperties)) {
            return null;
        }
        String delimiter = this.getPropertiesDelimiter(false);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)delimiter) ? 1 : 0) != 0);
        Pattern pattern = Pattern.compile("(\\w*\\s*)=(\\s*\"[^\"]*\"|[^,]*)");
        Matcher matcher = pattern.matcher(configProperties);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)matcher.group(1)) ? 1 : 0) != 0);
            if (Strings.isNullOrEmpty((String)matcher.group(2))) {
                LOG.info("Ignore invalid query option '{}'", (Object)matcher.group(1));
                continue;
            }
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(matcher.group(1).trim());
            sb.append("=");
            sb.append(matcher.group(2).trim());
        }
        return sb.toString();
    }

    @Override
    public String getDateString(int dateVal) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateToString = formatter.format(new Date((long)dateVal * 86400000L));
        return dateToString;
    }

    protected String addLimitAndOffsetToQuery(String sql, int limit, int offset) {
        if (offset == 0) {
            return this.addLimitToQuery(sql, limit);
        }
        if (limit != -1) {
            return sql + " {LIMIT " + limit + " OFFSET " + offset + "}";
        }
        return sql + " {OFFSET " + offset + "}";
    }

    protected String addLimitToQuery(String sql, int limit) {
        if (limit == -1) {
            return sql;
        }
        return sql + " {LIMIT " + limit + "}";
    }

    protected void cleanupResources(Connection conn, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Caught exception during resultset cleanup.", (Throwable)e);
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Caught exception during statement cleanup.", (Throwable)e);
        }
        if (conn != null) {
            Preconditions.checkNotNull((Object)this.dbcpDataSource);
            this.invalidateConnection(conn);
        }
    }

    private void invalidateConnection(Connection conn) {
        try {
            Preconditions.checkState((boolean)(this.dbcpDataSource instanceof BasicDataSource));
            BasicDataSource basicDataSource = (BasicDataSource)this.dbcpDataSource;
            basicDataSource.invalidateConnection(conn);
        }
        catch (Exception e) {
            LOG.warn("Caught exception during connection cleanup.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDatabaseSource(Configuration conf) throws JdbcDatabaseAccessException {
        if (this.dbcpDataSource == null) {
            GenericJdbcDatabaseAccessor genericJdbcDatabaseAccessor = this;
            synchronized (genericJdbcDatabaseAccessor) {
                if (this.dbcpDataSource == null) {
                    Properties props = this.getConnectionPoolProperties(conf);
                    String jdbcUrl = props.getProperty("url");
                    String username = props.getProperty("username", "-");
                    this.dataSourceCacheKey = String.format("%s.%s", jdbcUrl, username);
                    Preconditions.checkNotNull((Object)dataSourceCache);
                    this.dbcpDataSource = dataSourceCache.get(this.dataSourceCacheKey, props);
                }
            }
        }
    }

    protected Properties getConnectionPoolProperties(Configuration conf) {
        String additionalProperties;
        String passwd;
        Properties dbProperties = this.getDefaultDBCPProperties();
        Map userProperties = conf.getValByRegex("dbcp\\.*");
        if (userProperties != null && !userProperties.isEmpty()) {
            for (Map.Entry entry : userProperties.entrySet()) {
                dbProperties.put(((String)entry.getKey()).replaceFirst("dbcp\\.", ""), entry.getValue());
            }
        }
        if ((passwd = JdbcStorageConfigManager.getPasswordFromProperties(conf)) != null) {
            dbProperties.put(JdbcStorageConfig.DBCP_PASSWORD.getPropertyName().replaceFirst("dbcp\\.", ""), passwd);
        }
        String jdbcUrl = conf.get(JdbcStorageConfig.JDBC_URL.getPropertyName());
        boolean precededDelimiter = true;
        String jdbcAuth = conf.get(JdbcStorageConfig.JDBC_AUTH.getPropertyName());
        if (!Strings.isNullOrEmpty((String)jdbcAuth)) {
            jdbcUrl = jdbcUrl + this.getPropertiesDelimiter(precededDelimiter) + jdbcAuth;
            precededDelimiter = false;
        }
        if (this.isAdditionalPropertiesSupported() && !Strings.isNullOrEmpty((String)(additionalProperties = this.getAdditionalProperties(conf.get(JdbcStorageConfig.JDBC_OPTIONS.getPropertyName()))))) {
            jdbcUrl = jdbcUrl + this.getPropertiesDelimiter(precededDelimiter) + additionalProperties;
            if (precededDelimiter) {
                precededDelimiter = false;
            }
        }
        LOG.trace("JDBC URL: {}", (Object)jdbcUrl);
        dbProperties.put("url", jdbcUrl);
        dbProperties.put("driverClassName", conf.get(JdbcStorageConfig.JDBC_DRIVER_CLASS.getPropertyName()));
        if (conf.get(JdbcStorageConfig.JDBC_DRIVER_URL.getPropertyName()) != null) {
            dbProperties.put("driverUrl", conf.get(JdbcStorageConfig.JDBC_DRIVER_URL.getPropertyName()));
        }
        dbProperties.put("type", "javax.sql.DataSource");
        return dbProperties;
    }

    protected Properties getDefaultDBCPProperties() {
        Properties props = new Properties();
        props.put("maxTotal", String.valueOf(BackendConfig.INSTANCE.getDbcpMaxConnPoolSize()));
        props.put("maxIdle", String.valueOf(BackendConfig.INSTANCE.getDbcpMaxConnPoolSize()));
        props.put("minIdle", "0");
        props.put("maxWaitMillis", String.valueOf(BackendConfig.INSTANCE.getDbcpMaxWaitMillisForConn()));
        return props;
    }

    protected int getFetchSize(Configuration conf) {
        return conf.getInt(JdbcStorageConfig.JDBC_FETCH_SIZE.getPropertyName(), 1000);
    }
}

