/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.extdatasource.ApiVersion;
import org.apache.impala.extdatasource.thrift.TCloseParams;
import org.apache.impala.extdatasource.thrift.TCloseResult;
import org.apache.impala.extdatasource.thrift.TGetNextParams;
import org.apache.impala.extdatasource.thrift.TGetNextResult;
import org.apache.impala.extdatasource.thrift.TOpenParams;
import org.apache.impala.extdatasource.thrift.TOpenResult;
import org.apache.impala.extdatasource.thrift.TPrepareParams;
import org.apache.impala.extdatasource.thrift.TPrepareResult;
import org.apache.impala.extdatasource.v1.ExternalDataSource;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TStatus;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalDataSourceExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalDataSourceExecutor.class);
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private static final String CACHE_CLASS_PREFIX = "CACHE_CLASS::";
    private static final Map<String, Class<?>> cachedClasses_ = Maps.newHashMap();
    private static long numClassCacheHits_ = 0L;
    private static long numClassCacheMisses_ = 0L;
    private static final Object cachedClassesLock_ = new Object();
    private URLClassLoader classLoader_;
    private final ApiVersion apiVersion_;
    private final ExternalDataSource dataSource_;
    private final String jarPath_;
    private final String className_;
    private final String initString_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNumClassCacheHits() {
        Object object = cachedClassesLock_;
        synchronized (object) {
            return numClassCacheHits_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNumClassCacheMisses() {
        Object object = cachedClassesLock_;
        synchronized (object) {
            return numClassCacheMisses_;
        }
    }

    public ExternalDataSourceExecutor(String jarPath, String className, String apiVersionStr, String initString) throws ImpalaException {
        this.apiVersion_ = ApiVersion.valueOf(apiVersionStr);
        if (this.apiVersion_ == null) {
            throw new ImpalaRuntimeException("Invalid API version: " + apiVersionStr);
        }
        this.jarPath_ = jarPath;
        this.className_ = className;
        this.initString_ = initString;
        try {
            Class<?> c = this.getDataSourceClass();
            Constructor<?> ctor = c.getConstructor(new Class[0]);
            this.dataSource_ = (ExternalDataSource)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ImpalaRuntimeException(String.format("Unable to load external data source library from path=%s className=%s apiVersion=%s", jarPath != null ? jarPath : "Impala classpath", className, apiVersionStr), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getDataSourceClass() throws Exception {
        Class<?> c = null;
        if (Strings.isNullOrEmpty((String)this.jarPath_)) {
            c = Class.forName(this.className_);
            LOG.trace("Get instance of DataSourceClass in current ClassLoader");
            return c;
        }
        String cacheMapKey = String.format("%s.%s", this.className_, this.initString_);
        Object object = cachedClassesLock_;
        synchronized (object) {
            c = cachedClasses_.get(cacheMapKey);
            if (c == null) {
                URL url = new File(this.jarPath_).toURI().toURL();
                URLClassLoader loader = URLClassLoader.newInstance(new URL[]{url}, this.getClass().getClassLoader());
                c = Class.forName(this.className_, true, loader);
                if (!ArrayUtils.contains((Object[])c.getInterfaces(), this.apiVersion_.getApiInterface())) {
                    throw new ImpalaRuntimeException(String.format("Class '%s' does not implement interface '%s' required for API version %s", this.className_, this.apiVersion_.getApiInterface().getName(), this.apiVersion_.name()));
                }
                if (this.initString_ != null && this.initString_.startsWith(CACHE_CLASS_PREFIX)) {
                    cachedClasses_.put(cacheMapKey, c);
                } else {
                    this.classLoader_ = loader;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loaded jar for class {} at path {}", (Object)this.className_, (Object)this.jarPath_);
                }
                ++numClassCacheMisses_;
            } else {
                ++numClassCacheHits_;
            }
        }
        return c;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public void release() {
        if (this.classLoader_ != null) {
            try {
                this.classLoader_.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing the URLClassloader.", (Throwable)e);
            }
            this.classLoader_ = null;
        }
    }

    public byte[] prepare(byte[] thriftParams) throws ImpalaException {
        TPrepareParams params = new TPrepareParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TPrepareResult result = this.prepare(params);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage(), e);
        }
    }

    public byte[] open(byte[] thriftParams) throws ImpalaException {
        TOpenParams params = new TOpenParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TOpenResult result = this.open(params);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage(), e);
        }
    }

    public byte[] getNext(byte[] thriftParams) throws ImpalaException {
        TGetNextParams params = new TGetNextParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TGetNextResult result = this.getNext(params);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage(), e);
        }
    }

    public byte[] close(byte[] thriftParams) throws ImpalaException {
        TCloseParams params = new TCloseParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftParams);
        TCloseResult result = this.close(params);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage(), e);
        }
    }

    private TStatus logAndMakeErrorStatus(String opName, Exception e) {
        String exceptionMessage = e.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = "No error message returned by data source. Check the impalad log for more information.";
        }
        String errorMessage = String.format("Error in data source (path=%s, class=%s, version=%s) %s: %s", this.jarPath_ != null ? this.jarPath_ : "Impala classpath", this.className_, this.apiVersion_.name(), opName, exceptionMessage);
        LOG.error(errorMessage, (Throwable)e);
        return new TStatus(TErrorCode.RUNTIME_ERROR, Lists.newArrayList((Object[])new String[]{errorMessage}));
    }

    public TPrepareResult prepare(TPrepareParams params) {
        try {
            TPrepareResult result = this.dataSource_.prepare(params);
            result.validate();
            return result;
        }
        catch (Exception e) {
            return new TPrepareResult(this.logAndMakeErrorStatus("prepare()", e));
        }
    }

    public TOpenResult open(TOpenParams params) {
        try {
            TOpenResult result = this.dataSource_.open(params);
            result.validate();
            return result;
        }
        catch (Exception e) {
            return new TOpenResult(this.logAndMakeErrorStatus("open()", e));
        }
    }

    public TGetNextResult getNext(TGetNextParams params) {
        try {
            TGetNextResult result = this.dataSource_.getNext(params);
            result.validate();
            return result;
        }
        catch (Exception e) {
            return new TGetNextResult(this.logAndMakeErrorStatus("getNext()", e));
        }
    }

    public TCloseResult close(TCloseParams params) {
        try {
            TCloseResult result = this.dataSource_.close(params);
            result.validate();
            return result;
        }
        catch (Exception e) {
            return new TCloseResult(this.logAndMakeErrorStatus("close()", e));
        }
    }
}

