/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.compat;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitCompactionMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.MessageSerializer;
import org.apache.hadoop.hive.metastore.messaging.ReloadMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataTable;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.CompactionInfoLoader;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.Hive3MetastoreShimBase;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.TableNotFoundException;
import org.apache.impala.catalog.TableNotLoadedException;
import org.apache.impala.catalog.TableWriteId;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.events.MetastoreNotificationNeedsInvalidateException;
import org.apache.impala.catalog.events.SelfEventContext;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.catalog.metastore.CatalogMetastoreServer;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Metrics;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.HiveMetadataFormatUtils;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreShim
extends Hive3MetastoreShimBase {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreShim.class);
    private static final String HMS_DATA_CONNECTOR_TYPE = "impalaDataSource";
    private static final String HMS_DATA_CONNECTOR_DESC = "Impala DataSource Object";
    private static final String HMS_DATA_CONNECTOR_PARAM_KEY_CLASS_NAME = "className";
    private static final String HMS_DATA_CONNECTOR_PARAM_KEY_API_VERSION = "apiVersion";
    private static final MessageEncoder eventMessageEncoder_ = MessageFactory.getDefaultInstance((Configuration)MetastoreConf.newMetastoreConf());

    public static void alterTableWithTransaction(IMetaStoreClient client, Table tbl, AcidUtils.TblTransaction tblTxn) throws ImpalaRuntimeException {
        tbl.setWriteId(tblTxn.writeId);
        try {
            client.alter_table(null, tbl.getDbName(), tbl.getTableName(), tbl, null, tblTxn.validWriteIds);
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format("Error making '%s' RPC to Hive Metastore: ", "alter_table"), e);
        }
    }

    public static void alterPartitionsWithTransaction(IMetaStoreClient client, String dbName, String tblName, List<Partition> partitions, AcidUtils.TblTransaction tblTxn) throws InvalidOperationException, MetaException, TException {
        for (Partition part : partitions) {
            part.setWriteId(tblTxn.writeId);
        }
        client.alter_partitions(dbName, tblName, partitions, null, tblTxn.validWriteIds, tblTxn.writeId);
    }

    public static List<ColumnStatisticsObj> getTableColumnStatistics(IMetaStoreClient client, String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return client.getTableColumnStatistics(dbName, tableName, colNames, "impala");
    }

    public static boolean deleteTableColumnStatistics(IMetaStoreClient client, String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return client.deleteTableColumnStatistics(dbName, tableName, colName, "impala");
    }

    public static ColumnStatistics createNewHiveColStats() {
        ColumnStatistics colStats = new ColumnStatistics();
        colStats.setEngine("impala");
        return colStats;
    }

    public static MessageDeserializer getMessageDeserializer() {
        return eventMessageEncoder_.getDeserializer();
    }

    public static MessageSerializer getMessageSerializer() {
        return eventMessageEncoder_.getSerializer();
    }

    @VisibleForTesting
    public static AlterTableMessage buildAlterTableMessage(Table before, Table after, boolean isTruncateOp, long writeId) {
        return MessageBuilder.getInstance().buildAlterTableMessage(before, after, isTruncateOp, Long.valueOf(writeId));
    }

    @VisibleForTesting
    public static String serializeEventMessage(EventMessage message) {
        return MetastoreShim.getMessageSerializer().serialize(message);
    }

    public static ValidWriteIdList fetchValidWriteIds(IMetaStoreClient client, String tableFullName) throws TException {
        return client.getValidWriteIds(tableFullName);
    }

    public static long getWriteIdFromMSPartition(Partition partition) {
        Preconditions.checkNotNull((Object)partition);
        return partition.getWriteId();
    }

    public static void setWriteIdToMSPartition(Partition partition, long writeId) {
        Preconditions.checkNotNull((Object)partition);
        partition.setWriteId(writeId);
    }

    public static long getWriteIdFromMSTable(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        return msTbl.getWriteId();
    }

    public static synchronized void setHiveClientCapabilities() {
        String buildVersion;
        String hostName;
        if (capabilitiestSet_) {
            return;
        }
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ue) {
            hostName = "unknown";
        }
        String string = buildVersion = BackendConfig.INSTANCE != null ? BackendConfig.INSTANCE.getImpalaBuildVersion() : String.valueOf(3L);
        if (buildVersion == null) {
            buildVersion = String.valueOf(3L);
        }
        String impalaId = String.format("Impala%s@%s", buildVersion, hostName);
        String[] capabilities = new String[]{"EXTWRITE", "EXTREAD", "HIVEMANAGEDINSERTREAD", "HIVEMANAGEDINSERTWRITE", "HIVEFULLACIDREAD", "HIVEFULLACIDWRITE", "HIVESQL", "HIVEMQT", "HIVEBUCKET2"};
        HiveMetaStoreClient.setProcessorIdentifier((String)impalaId);
        HiveMetaStoreClient.setProcessorCapabilities((String[])capabilities);
        capabilitiestSet_ = true;
    }

    public static boolean hasTableCapability(Table msTbl, byte requiredCapability) {
        Preconditions.checkNotNull((Object)msTbl);
        return requiredCapability != 1 && (msTbl.getAccessType() & requiredCapability) != 0;
    }

    public static String getTableAccessType(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        switch (msTbl.getAccessType()) {
            case 2: {
                return "READONLY";
            }
            case 4: {
                return "WRITEONLY";
            }
            case 8: {
                return "READWRITE";
            }
        }
        return "NONE";
    }

    public static void setTableAccessType(Table msTbl, byte accessType) {
        Preconditions.checkNotNull((Object)msTbl);
        msTbl.setAccessType(accessType);
    }

    public static void setTableColumnStatsTransactional(IMetaStoreClient client, Table msTbl, ColumnStatistics colStats, AcidUtils.TblTransaction tblTxn) throws ImpalaRuntimeException {
        ArrayList<ColumnStatistics> colStatsList = new ArrayList<ColumnStatistics>();
        colStatsList.add(colStats);
        SetPartitionsStatsRequest request = new SetPartitionsStatsRequest(colStatsList);
        request.setWriteId(tblTxn.writeId);
        request.setValidWriteIdList(tblTxn.validWriteIds);
        try {
            client.setPartitionColumnStatistics(request);
        }
        catch (TException e) {
            throw new ImpalaRuntimeException(String.format("Error making '%s' RPC to Hive Metastore: ", "setPartitionColumnStatistics"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> fireInsertEvents(MetaStoreClientPool.MetaStoreClient msClient, MetaStoreUtil.TableInsertEventInfo insertEventInfo, String dbName, String tableName) {
        Stopwatch sw;
        block5: {
            List<Long> list;
            sw = Stopwatch.createStarted();
            try {
                if (insertEventInfo.isTransactional()) {
                    MetastoreShim.fireInsertTransactionalEventHelper(msClient.getHiveClient(), insertEventInfo, dbName, tableName);
                    break block5;
                }
                list = MetastoreShim.fireInsertEventHelper(msClient.getHiveClient(), insertEventInfo.getInsertEventReqData(), insertEventInfo.getInsertEventPartVals(), dbName, tableName);
            }
            catch (Exception e) {
                try {
                    LOG.error("Failed to fire insert event. Some tables might not be refreshed on other impala clusters.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
                    msClient.close();
                    throw throwable;
                }
                LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
                msClient.close();
            }
            LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
            msClient.close();
            return list;
        }
        LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
        msClient.close();
        return Collections.emptyList();
    }

    private static void fireInsertTransactionalEventHelper(IMetaStoreClient hiveClient, MetaStoreUtil.TableInsertEventInfo insertEventInfo, String dbName, String tableName) throws TException {
        int insertBatchSize = insertEventInfo.getInsertEventReqData().size();
        int maxRPCBatchSize = 1000;
        for (int i = 0; i < insertBatchSize; i += maxRPCBatchSize) {
            ArrayList<WriteNotificationLogRequest> batchRequestList = new ArrayList<WriteNotificationLogRequest>();
            StringBuilder sb = new StringBuilder();
            List<InsertEventRequestData> insertDataList = insertEventInfo.getInsertEventReqData().subList(i, Math.min(i + maxRPCBatchSize, insertBatchSize));
            for (InsertEventRequestData insertData : insertDataList) {
                WriteNotificationLogRequest req = new WriteNotificationLogRequest(insertEventInfo.getTxnId(), insertEventInfo.getWriteId(), dbName, tableName, insertData);
                if (insertData.isSetPartitionVal()) {
                    req.setPartitionVals(insertData.getPartitionVal());
                    sb.append(insertData.getPartitionVal());
                }
                batchRequestList.add(req);
            }
            WriteNotificationLogBatchRequest batchedReq = new WriteNotificationLogBatchRequest(MetastoreShim.getDefaultCatalogName(), dbName, tableName, batchRequestList);
            hiveClient.addWriteNotificationLogInBatch(batchedReq);
            if (!LOG.isDebugEnabled()) continue;
            String msg = "Firing write notification log request for table " + dbName + "." + tableName + (!sb.toString().isEmpty() ? " on partitions " + sb.toString() : "");
            LOG.debug(msg);
        }
    }

    @VisibleForTesting
    public static List<Long> fireInsertEventHelper(IMetaStoreClient msClient, List<InsertEventRequestData> insertEventDataList, List<List<String>> insertEventPartValList, String dbName, String tableName) throws TException {
        Preconditions.checkNotNull((Object)msClient);
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkState((!insertEventDataList.isEmpty() ? 1 : 0) != 0, (Object)"Atleast one insert event info must be provided.");
        LOG.debug("Firing {} insert event(s) for {}.{}", new Object[]{insertEventDataList.size(), dbName, tableName});
        FireEventRequestData data = new FireEventRequestData();
        FireEventRequest rqst = new FireEventRequest(true, data);
        rqst.setDbName(dbName);
        rqst.setTableName(tableName);
        if (insertEventDataList.size() == 1) {
            InsertEventRequestData insertEventData = (InsertEventRequestData)Iterables.getOnlyElement(insertEventDataList);
            if (insertEventData.getPartitionVal() != null) {
                rqst.setPartitionVals(insertEventData.getPartitionVal());
            }
            data.setInsertData(insertEventData);
        } else {
            data.setInsertDatas(insertEventDataList);
        }
        FireEventResponse response = msClient.fireListenerEvent(rqst);
        if (!response.isSetEventIds()) {
            LOG.error("FireEventResponse does not have event ids set for table {}.{}. This may cause the table to unnecessarily be refreshed when the insert event is received.", (Object)dbName, (Object)tableName);
            return Collections.EMPTY_LIST;
        }
        return response.getEventIds();
    }

    @VisibleForTesting
    public static List<Long> fireReloadEventHelper(MetaStoreClientPool.MetaStoreClient msClient, boolean isRefresh, List<List<String>> partValsList, String dbName, String tableName, Map<String, String> selfEventParams) throws TException {
        Preconditions.checkNotNull((Object)msClient);
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        FireEventRequestData data = new FireEventRequestData();
        data.setRefreshEvent(isRefresh);
        FireEventRequest rqst = new FireEventRequest(true, data);
        rqst.setDbName(dbName);
        rqst.setTableName(tableName);
        rqst.setTblParams(selfEventParams);
        if (partValsList == null || partValsList.isEmpty()) {
            FireEventResponse response = msClient.getHiveClient().fireListenerEvent(rqst);
            if (!response.isSetEventIds()) {
                LOG.error("FireEventResponse does not have event ids set for table {}.{}. This may cause the table to unnecessarily be refreshed when the refresh/invalidate event is received.", (Object)dbName, (Object)tableName);
                return Collections.emptyList();
            }
            return response.getEventIds();
        }
        ArrayList<Long> eventIds = new ArrayList<Long>();
        for (List<String> partVals : partValsList) {
            rqst.setPartitionVals(partVals);
            FireEventResponse response = msClient.getHiveClient().fireListenerEvent(rqst);
            if (!response.isSetEventIds()) {
                LOG.error("FireEventResponse does not have event ids set for table {}.{} partition {}. This may cause the table to unnecessarily be refreshed when the refresh/invalidate event is received.", new Object[]{dbName, tableName, partVals});
                continue;
            }
            eventIds.addAll(response.getEventIds());
        }
        return eventIds;
    }

    public static Map<String, Object> getFieldsFromReloadEvent(NotificationEvent event) throws MetastoreNotificationException {
        ReloadMessage reloadMessage = MetastoreEventsProcessor.getMessageDeserializer().getReloadMessage(event.getMessage());
        HashMap<String, Object> updatedFields = new HashMap<String, Object>();
        try {
            Table msTbl = (Table)Preconditions.checkNotNull((Object)reloadMessage.getTableObj());
            Partition reloadPartition = reloadMessage.getPtnObj();
            boolean isRefresh = reloadMessage.isRefreshEvent();
            updatedFields.put("table", msTbl);
            updatedFields.put("partition", reloadPartition);
            updatedFields.put("isRefresh", isRefresh);
        }
        catch (Exception e) {
            throw new MetastoreNotificationException(e);
        }
        return updatedFields;
    }

    public static Hive3MetastoreShimBase.AlterPartitionsInfo getFieldsFromAlterPartitionsEvent(NotificationEvent event) throws MetastoreNotificationException {
        Preconditions.checkNotNull((Object)event.getMessage());
        AlterPartitionsMessage alterPartitionsMessage = MetastoreEventsProcessor.getMessageDeserializer().getAlterPartitionsMessage(event.getMessage());
        Hive3MetastoreShimBase.AlterPartitionsInfo alterPartitionsInfo = null;
        try {
            Iterator partitionsIterator = (Iterator)Preconditions.checkNotNull(alterPartitionsMessage.getPartitionObjs().iterator());
            ArrayList<Partition> partitionsAfter = new ArrayList<Partition>();
            while (partitionsIterator.hasNext()) {
                partitionsAfter.add((Partition)partitionsIterator.next());
            }
            Table msTbl = (Table)Preconditions.checkNotNull((Object)alterPartitionsMessage.getTableObj());
            boolean isTruncateOp = alterPartitionsMessage.getIsTruncateOp();
            alterPartitionsInfo = new Hive3MetastoreShimBase.AlterPartitionsInfo(msTbl, partitionsAfter, isTruncateOp);
        }
        catch (Exception e) {
            throw new MetastoreNotificationException(e);
        }
        return alterPartitionsInfo;
    }

    public static String getPartitionNameFromCommitCompactionEvent(NotificationEvent event) {
        CommitCompactionMessage commitCompactionMessage = MetastoreEventsProcessor.getMessageDeserializer().getCommitCompactionMessage(event.getMessage());
        return commitCompactionMessage.getPartName();
    }

    public static NotificationEventResponse getNextNotification(IMetaStoreClient msClient, NotificationEventRequest eventRequest, List<String> eventTypeSkipList) throws TException {
        if (eventTypeSkipList != null) {
            eventRequest.setEventTypeSkipList(eventTypeSkipList);
        }
        if (!(!eventRequest.isSetCatName() || eventTypeSkipList != null && eventTypeSkipList.contains(MetastoreEvents.MetastoreEventType.COMMIT_COMPACTION_EVENT.toString()) && eventTypeSkipList.contains(MetastoreEvents.MetastoreEventType.ALLOC_WRITE_ID_EVENT.toString()))) {
            eventRequest.unsetCatName();
        }
        return msClient.getThriftClient().get_next_notification(eventRequest);
    }

    public static void setManagedLocationUri(Database db, String managedLocation) {
        db.setManagedLocationUri(managedLocation);
    }

    public static String getManagedLocationUri(Database db) {
        return db.getManagedLocationUri();
    }

    public static void setTableLocation(Db db, Table tbl) throws ImpalaRuntimeException {
    }

    public static long getTableId(Table tbl) {
        return tbl.getId();
    }

    public static Database getDatabaseObject(JSONDropDatabaseMessage dropDatabaseMessage) throws Exception {
        return dropDatabaseMessage.getDatabaseObject();
    }

    public static void truncateTable(IMetaStoreClient msClient, String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        msClient.truncateTable(dbName, tableName, partNames, validWriteIds, writeId);
    }

    public static List<Partition> getPartitions(IMetaStoreClient msClient, String testDbName, String testTblName) throws TException {
        PartitionsRequest req = new PartitionsRequest();
        req.setDbName(testDbName);
        req.setTblName(testTblName);
        return msClient.getPartitionsRequest(req).getPartitions();
    }

    public static void setPartitionVal(InsertEventRequestData insertEventRequestData, List<String> partVals) {
        if (partVals != null && !partVals.isEmpty()) {
            insertEventRequestData.setPartitionVal(partVals);
        }
    }

    public static void addToSubDirectoryList(InsertEventRequestData insertEventRequestData, String acidDirPath) {
        insertEventRequestData.addToSubDirectoryList(acidDirPath);
    }

    public static List<HdfsPartition.Builder> getPartitionsForRefreshingFileMetadata(CatalogServiceCatalog catalog, HdfsTable hdfsTable) throws CatalogException {
        GetLatestCommittedCompactionInfoResponse response;
        ArrayList<HdfsPartition.Builder> partBuilders = new ArrayList<HdfsPartition.Builder>();
        GetLatestCommittedCompactionInfoRequest request = new GetLatestCommittedCompactionInfoRequest(hdfsTable.getDb().getName(), hdfsTable.getName());
        if (hdfsTable.getLastCompactionId() > 0L) {
            request.setLastCompactionId(hdfsTable.getLastCompactionId());
        }
        try {
            MetaStoreClientPool.MetaStoreClient client = catalog.getMetaStoreClient();
            Iterator<HdfsPartition> iterator = null;
            try {
                response = CompactionInfoLoader.getLatestCompactionInfo(client, request);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (iterator != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CatalogException("Error getting latest compaction info for " + hdfsTable.getFullName(), e);
        }
        HashMap<String, Long> partNameToCompactionId = new HashMap<String, Long>();
        if (hdfsTable.isPartitioned()) {
            for (CompactionInfoStruct ci : response.getCompactions()) {
                if (ci.getPartitionname() != null) {
                    partNameToCompactionId.put(ci.getPartitionname(), ci.getId());
                    continue;
                }
                LOG.warn("Partitioned table {} has null partitionname in CompactionInfoStruct: {}", (Object)hdfsTable.getFullName(), (Object)ci.toString());
            }
        } else {
            CompactionInfoStruct ci = (CompactionInfoStruct)Iterables.getOnlyElement((Iterable)response.getCompactions(), null);
            if (ci != null) {
                partNameToCompactionId.put("", ci.getId());
            }
        }
        for (HdfsPartition partition : hdfsTable.getPartitionsForNames(partNameToCompactionId.keySet())) {
            long latestCompactionId = (Long)partNameToCompactionId.get(partition.getPartitionName());
            HdfsPartition.Builder builder = new HdfsPartition.Builder(partition);
            LOG.debug("Cached compaction id for {} partition {}: {} but the latest compaction id: {}", new Object[]{hdfsTable.getFullName(), partition.getPartitionName(), partition.getLastCompactionId(), latestCompactionId});
            builder.setLastCompactionId(latestCompactionId);
            partBuilders.add(builder);
        }
        return partBuilders;
    }

    public static Map<String, Long> getLatestCompactions(MetaStoreClientPool.MetaStoreClient client, String dbName, String tableName, List<String> partitionNames, String unPartitionedName, long lastCompactionId) throws TException {
        GetLatestCommittedCompactionInfoRequest request = new GetLatestCommittedCompactionInfoRequest(dbName, tableName);
        request.setPartitionnames(partitionNames);
        if (lastCompactionId > 0L) {
            request.setLastCompactionId(lastCompactionId);
        }
        GetLatestCommittedCompactionInfoResponse response = CompactionInfoLoader.getLatestCompactionInfo(client, request);
        HashMap<String, Long> partNameToCompactionId = new HashMap<String, Long>();
        if (partitionNames != null) {
            for (CompactionInfoStruct ci : response.getCompactions()) {
                if (ci.getPartitionname() != null) {
                    partNameToCompactionId.put(ci.getPartitionname(), ci.getId());
                    continue;
                }
                LOG.warn("Partitioned table {} has null partitionname in CompactionInfoStruct: {}", (Object)tableName, (Object)ci.toString());
            }
        } else {
            CompactionInfoStruct ci = (CompactionInfoStruct)Iterables.getOnlyElement((Iterable)response.getCompactions(), null);
            if (ci != null) {
                partNameToCompactionId.put(unPartitionedName, ci.getId());
            }
        }
        return partNameToCompactionId;
    }

    public static List<MetaProvider.PartitionRef> checkLatestCompaction(MetaStoreClientPool msClientPool, String dbName, String tableName, MetaProvider.TableMetaRef table, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas, String unPartitionedName) throws TException {
        Preconditions.checkNotNull((Object)table, (Object)"TableMetaRef must be non-null");
        Preconditions.checkNotNull(metas, (Object)"Partition map must be non-null");
        if (!table.isTransactional() || metas.isEmpty()) {
            return Collections.emptyList();
        }
        Stopwatch sw = Stopwatch.createStarted();
        List<String> partitionNames = null;
        if (table.isPartitioned()) {
            partitionNames = metas.keySet().stream().map(MetaProvider.PartitionRef::getName).collect(Collectors.toList());
        }
        long lastCompactionId = metas.values().stream().mapToLong(MetaProvider.PartitionMetadata::getLastCompactionId).max().orElse(-1L);
        Map<Object, Object> partNameToCompactionId = Collections.emptyMap();
        try (MetaStoreClientPool.MetaStoreClient client = msClientPool.getClient();){
            partNameToCompactionId = MetastoreShim.getLatestCompactions(client, dbName, tableName, partitionNames, unPartitionedName, lastCompactionId);
        }
        ArrayList<MetaProvider.PartitionRef> stalePartitions = new ArrayList<MetaProvider.PartitionRef>();
        Iterator<Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata>> iter = metas.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> entry = iter.next();
            if (!partNameToCompactionId.containsKey(entry.getKey().getName())) continue;
            stalePartitions.add(entry.getKey());
            iter.remove();
        }
        LOG.debug("Checked the latest compaction info for {}.{}. Time taken: {}", new Object[]{dbName, tableName, PrintUtils.printTimeMs(sw.stop().elapsed(TimeUnit.MILLISECONDS))});
        return stalePartitions;
    }

    public static ICatalogMetastoreServer getCatalogMetastoreServer(CatalogOpExecutor catalogOpExecutor) {
        int portNumber = BackendConfig.INSTANCE.getHMSPort();
        Preconditions.checkState((portNumber > 0 ? 1 : 0) != 0, (Object)"Invalid port number for HMS service.");
        return new CatalogMetastoreServer(catalogOpExecutor);
    }

    public static void addCommittedWriteIdsAndReload(CatalogOpExecutor catalogOpExecutor, String dbName, String tableName, boolean isPartitioned, boolean isMaterializedView, List<Long> writeIds, List<Partition> partitions, long eventId, Metrics metrics) throws CatalogException {
        if (isPartitioned && !isMaterializedView) {
            try {
                int numPartsRefreshed = catalogOpExecutor.addCommittedWriteIdsAndReloadPartitionsIfExist(eventId, dbName, tableName, writeIds, partitions, "COMMIT_TXN event " + eventId);
                if (numPartsRefreshed > 0) {
                    metrics.getCounter("partitions-refreshed").inc((long)numPartsRefreshed);
                }
            }
            catch (TableNotLoadedException e) {
                LOG.debug("Ignoring reloading since table {}.{} is not loaded", (Object)dbName, (Object)tableName);
            }
            catch (DatabaseNotFoundException | TableNotFoundException e) {
                LOG.debug("Ignoring reloading since table {}.{} is not found", (Object)dbName, (Object)tableName);
            }
        } else {
            boolean tableRefresh = catalogOpExecutor.getCatalog().reloadTableIfExists(dbName, tableName, "COMMIT_TXN event " + eventId, eventId, false, writeIds);
            if (tableRefresh) {
                LOG.info("Refreshed table {}.{}", (Object)dbName, (Object)tableName);
                metrics.getCounter("tables-refreshed").inc();
            }
        }
    }

    public static List<PseudoCommitTxnEvent> getPseudoCommitTxnEvents(CommitTxnEvent event) throws MetastoreNotificationException {
        List writeEventInfoList;
        ArrayList<PseudoCommitTxnEvent> pseudoEvents = new ArrayList<PseudoCommitTxnEvent>();
        try {
            MetaStoreClientPool.MetaStoreClient client = event.getCatalogOpExecutor().getCatalog().getMetaStoreClient();
            Object object = null;
            try {
                writeEventInfoList = client.getHiveClient().getAllWriteEventInfo(new GetAllWriteEventInfoRequest(event.txnId_));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (TException e) {
            throw new MetastoreNotificationNeedsInvalidateException(String.format("Failed to get write event infos for txn %d. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", event.txnId_), e);
        }
        HashMap<org.apache.impala.analysis.TableName, List> tableNameToWriteIds = new HashMap<org.apache.impala.analysis.TableName, List>();
        for (TableWriteId writeId : event.tableWriteIds_) {
            org.apache.impala.analysis.TableName tableName = new org.apache.impala.analysis.TableName(writeId.getDbName(), writeId.getTblName());
            tableNameToWriteIds.computeIfAbsent(tableName, k -> new ArrayList()).add(writeId.getWriteId());
        }
        try {
            HashMap<org.apache.impala.analysis.TableName, AcidTableWriteInfo> tableNameToWriteInfos = new HashMap<org.apache.impala.analysis.TableName, AcidTableWriteInfo>();
            int derivedEventCount = 0;
            MetastoreEvents.DerivedMetastoreEventContext context = new MetastoreEvents.DerivedMetastoreEventContext(event);
            if (writeEventInfoList != null && !writeEventInfoList.isEmpty()) {
                List writeIds = writeEventInfoList.stream().map(WriteEventInfo::getWriteId).collect(Collectors.toList());
                for (int i = 0; i < writeIds.size(); ++i) {
                    Table tbl = (Table)MessageBuilder.getTObj((String)((WriteEventInfo)writeEventInfoList.get(i)).getTableObj(), Table.class);
                    if (event.getCatalogOpExecutor().getCatalog().isHmsEventSyncDisabled(tbl)) {
                        LOG.debug("Not adding write ids to table {}.{} for event {} since table/db level flag {} is set to true", new Object[]{tbl.getDbName(), tbl.getTableName(), event.getEventId(), MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey()});
                        continue;
                    }
                    org.apache.impala.analysis.TableName tableName = new org.apache.impala.analysis.TableName(tbl.getDbName(), tbl.getTableName());
                    Partition partition = null;
                    if (((WriteEventInfo)writeEventInfoList.get(i)).getPartitionObj() != null) {
                        partition = (Partition)MessageBuilder.getTObj((String)((WriteEventInfo)writeEventInfoList.get(i)).getPartitionObj(), Partition.class);
                        Preconditions.checkNotNull((Object)partition);
                    }
                    AcidTableWriteInfo writeInfo = tableNameToWriteInfos.computeIfAbsent(tableName, k -> new AcidTableWriteInfo(tbl));
                    writeInfo.appendWriteIdAndPartition((Long)writeIds.get(i), partition);
                }
                for (Map.Entry entry : tableNameToWriteInfos.entrySet()) {
                    List writeIdsInCatalog = (List)tableNameToWriteIds.remove(entry.getKey());
                    AcidTableWriteInfo writeInfo = (AcidTableWriteInfo)entry.getValue();
                    Table tbl = writeInfo.getTable();
                    pseudoEvents.add(new PseudoCommitTxnEvent(context, tbl.getDbName(), tbl.getTableName(), tbl.getPartitionKeysSize() > 0, MetaStoreUtils.isMaterializedViewTable((Table)tbl), writeIdsInCatalog, writeInfo.getWriteIdList(), writeInfo.getPartitionList()));
                    ++derivedEventCount;
                }
            }
            for (Map.Entry entry : tableNameToWriteIds.entrySet()) {
                org.apache.impala.catalog.Table table = event.getCatalogOpExecutor().getCatalog().getTableNoThrow(((org.apache.impala.analysis.TableName)entry.getKey()).getDb(), ((org.apache.impala.analysis.TableName)entry.getKey()).getTbl());
                if (table == null || table.getMetaStoreTable() == null) continue;
                Table tbl = table.getMetaStoreTable();
                pseudoEvents.add(new PseudoCommitTxnEvent(context, tbl.getDbName(), tbl.getTableName(), tbl.getPartitionKeysSize() > 0, MetaStoreUtils.isMaterializedViewTable((Table)tbl), (List)entry.getValue(), Collections.emptyList(), Collections.emptyList()));
                ++derivedEventCount;
            }
            context.setDerivedEventsCount(derivedEventCount);
        }
        catch (Exception e) {
            throw new MetastoreNotificationNeedsInvalidateException(String.format("Failed to form PseudoCommitTxnEvent for txn %d. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", event.txnId_), e);
        }
        return pseudoEvents;
    }

    public static void getMaterializedViewInfo(StringBuilder tableInfo, Table tbl, boolean isOutputPadded) {
        HiveMetadataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("Rewrite Enabled:", tbl.isRewriteEnabled() ? "Yes" : "No", tableInfo);
        HiveMetadataFormatUtils.formatOutput("Outdated for Rewriting:", "Unknown", tableInfo);
        tableInfo.append("\n").append("# Materialized View Source table information").append("\n");
        TextMetaDataTable metaDataTable = new TextMetaDataTable();
        metaDataTable.addRow(new String[]{"Table name", "I/U/D since last rebuild"});
        ArrayList<SourceTable> sourceTableList = new ArrayList<SourceTable>(tbl.getCreationMetadata().getSourceTables());
        sourceTableList.sort(Comparator.comparing(sourceTable -> sourceTable.getTable().getDbName()).thenComparing(sourceTable -> sourceTable.getTable().getTableName()));
        for (SourceTable sourceTable2 : sourceTableList) {
            String qualifiedTableName = TableName.getQualified((String)sourceTable2.getTable().getCatName(), (String)sourceTable2.getTable().getDbName(), (String)sourceTable2.getTable().getTableName());
            metaDataTable.addRow(new String[]{qualifiedTableName, String.format("%d/%d/%d", sourceTable2.getInsertedCount(), sourceTable2.getUpdatedCount(), sourceTable2.getDeletedCount())});
            tableInfo.append(metaDataTable.renderTable(isOutputPadded));
        }
    }

    public static void createDataSource(IMetaStoreClient client, DataSource dataSource) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        DataConnector connector = MetastoreShim.dataSourceToDataConnector(dataSource);
        Preconditions.checkNotNull((Object)connector);
        client.createDataConnector(connector);
    }

    public static void dropDataSource(IMetaStoreClient client, String name, boolean ifExists) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        client.dropDataConnector(name, !ifExists, false);
    }

    public static Map<String, DataSource> loadAllDataSources(IMetaStoreClient client) throws MetaException, TException {
        HashMap<String, DataSource> newDataSrcs = new HashMap<String, DataSource>();
        List allConnectorNames = client.getAllDataConnectorNames();
        for (String connectorName : allConnectorNames) {
            DataSource dataSrc;
            DataConnector connector = client.getDataConnector(connectorName);
            if (connector == null || (dataSrc = MetastoreShim.dataConnectorToDataSource(connector)) == null) continue;
            newDataSrcs.put(connectorName, dataSrc);
        }
        return newDataSrcs;
    }

    private static DataConnector dataSourceToDataConnector(DataSource dataSource) {
        DataConnector connector = new DataConnector(dataSource.getName(), HMS_DATA_CONNECTOR_TYPE, dataSource.getLocation());
        connector.setDescription(HMS_DATA_CONNECTOR_DESC);
        connector.putToParameters(HMS_DATA_CONNECTOR_PARAM_KEY_CLASS_NAME, dataSource.getClassName());
        connector.putToParameters(HMS_DATA_CONNECTOR_PARAM_KEY_API_VERSION, dataSource.getApiVersion());
        return connector;
    }

    private static DataSource dataConnectorToDataSource(DataConnector connector) {
        if (!(connector.isSetName() && connector.isSetType() && connector.isSetDescription() && connector.getParametersSize() != 0 && connector.getType().equalsIgnoreCase(HMS_DATA_CONNECTOR_TYPE))) {
            return null;
        }
        String name = connector.getName();
        String location = connector.isSetUrl() ? connector.getUrl() : "";
        String className = (String)connector.getParameters().get(HMS_DATA_CONNECTOR_PARAM_KEY_CLASS_NAME);
        String apiVersion = (String)connector.getParameters().get(HMS_DATA_CONNECTOR_PARAM_KEY_API_VERSION);
        if (!(Strings.isNullOrEmpty((String)name) || location == null || Strings.isNullOrEmpty((String)className) || Strings.isNullOrEmpty((String)apiVersion))) {
            return new DataSource(name, location, className, apiVersion);
        }
        return null;
    }

    public static void setNotificationEventRequestWithFilter(NotificationEventRequest eventRequest, MetastoreEventsProcessor.MetaDataFilter metaDataFilter) {
        if (metaDataFilter != null) {
            if (metaDataFilter.getCatName() != null && !metaDataFilter.getCatName().isEmpty()) {
                eventRequest.setCatName(metaDataFilter.getCatName());
            }
            if (metaDataFilter.getDbName() != null && !metaDataFilter.getDbName().isEmpty()) {
                eventRequest.setDbName(metaDataFilter.getDbName());
            }
            if (metaDataFilter.getTableNames() != null && !metaDataFilter.getTableNames().isEmpty()) {
                eventRequest.setTableNames(metaDataFilter.getTableNames());
            }
        }
    }

    public static class PseudoCommitTxnEvent
    extends MetastoreEvents.DerivedMetastoreTableEvent {
        private final long txnId_;
        private final boolean isPartitioned_;
        private final boolean isMaterializedView_;
        private final List<Long> writeIdsInCatalog_;
        private final List<Long> writeIdsInEvent_;
        private final List<Partition> partitions_;

        PseudoCommitTxnEvent(MetastoreEvents.DerivedMetastoreEventContext context, String dbName, String tableName, boolean isPartitioned, boolean isMaterializedView, List<Long> writeIdsInCatalog, List<Long> writeIdsInEvent, List<Partition> partitions) {
            super(context);
            this.txnId_ = ((CommitTxnEvent)context.getActualEvent()).txnId_;
            this.writeIdsInCatalog_ = writeIdsInCatalog;
            this.writeIdsInEvent_ = writeIdsInEvent;
            this.partitions_ = partitions;
            this.dbName_ = dbName;
            this.tblName_ = tableName;
            this.isPartitioned_ = isPartitioned;
            this.isMaterializedView_ = isMaterializedView;
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            org.apache.impala.catalog.Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl != null && tbl.getCreateEventId() < this.getEventId()) {
                this.msTbl_ = tbl.getMetaStoreTable();
            }
            if (this.msTbl_ == null) {
                return false;
            }
            return super.isEventProcessingDisabled();
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }

        @Override
        protected void processTableEvent() throws MetastoreNotificationException {
            try {
                MetastoreShim.addCommittedWriteIdsAndReload(this.getCatalogOpExecutor(), this.dbName_, this.tblName_, this.isPartitioned_, this.isMaterializedView_, this.writeIdsInEvent_, this.partitions_, this.getEventId(), this.getMetrics());
                this.catalog_.addWriteIdsToTable(this.getDbName(), this.getTableName(), this.getEventId(), this.writeIdsInCatalog_, MutableValidWriteIdList.WriteIdStatus.COMMITTED);
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to mark committed write ids and refresh partitions for txn {}. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.txnId_), e);
            }
        }

        @Override
        public String getEventDesc() {
            return super.getEventDesc() + " pseudo-event";
        }
    }

    public static class CommitTxnEvent
    extends MetastoreEvents.MetastoreEvent {
        public static final String EVENT_TYPE = "COMMIT_TXN";
        private final long txnId_;
        private Set<TableWriteId> tableWriteIds_ = Collections.emptySet();
        private final Set<String> tableNames_ = new HashSet<String>();

        public CommitTxnEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEvents.MetastoreEventType.COMMIT_TXN));
            Preconditions.checkNotNull((Object)event.getMessage());
            CommitTxnMessage commitTxnMessage = MetastoreEventsProcessor.getMessageDeserializer().getCommitTxnMessage(event.getMessage());
            this.txnId_ = commitTxnMessage.getTxnId();
            this.tableWriteIds_ = this.catalog_.removeWriteIds(this.txnId_);
            this.LOG.info("EventId: {} EventType: COMMIT_TXN transaction id: {}", (Object)this.getEventId(), (Object)this.txnId_);
        }

        @Override
        public String getTargetName() {
            if (this.tableNames_.isEmpty()) {
                return "CLUSTER_WIDE";
            }
            return this.tableNames_.stream().sorted().collect(Collectors.joining(","));
        }

        @Override
        protected void process() throws MetastoreNotificationException {
            List writeEventInfoList;
            try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
                writeEventInfoList = client.getHiveClient().getAllWriteEventInfo(new GetAllWriteEventInfoRequest(this.txnId_));
            }
            catch (TException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to get write event infos for txn {}. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.txnId_), e);
            }
            try {
                if (writeEventInfoList != null && !writeEventInfoList.isEmpty()) {
                    this.addCommittedWriteIdsAndRefreshPartitions(writeEventInfoList);
                }
                this.addCommittedWriteIdsToTables(this.tableWriteIds_);
            }
            catch (Exception e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to mark committed write ids and refresh partitions for txn {}. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.txnId_), e);
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            if (!BackendConfig.INSTANCE.isInvalidateMetadataOnEventProcessFailureEnabled() || !this.canInvalidateTable(e)) {
                return false;
            }
            this.errorLog("Invalidating tables in transaction due to exception during event processing", e);
            Set tableNames = this.tableWriteIds_.stream().map(writeId -> new org.apache.impala.analysis.TableName(writeId.getDbName(), writeId.getTblName())).collect(Collectors.toSet());
            for (org.apache.impala.analysis.TableName tableName : tableNames) {
                this.errorLog("Invalidate table {}.{}", tableName.getDb(), tableName.getTbl());
                this.catalog_.invalidateTableIfExists(tableName.getDb(), tableName.getTbl());
            }
            return true;
        }

        private void addCommittedWriteIdsToTables(Set<TableWriteId> tableWriteIds) throws CatalogException {
            for (TableWriteId tableWriteId : tableWriteIds) {
                this.catalog_.addWriteIdsToTable(tableWriteId.getDbName(), tableWriteId.getTblName(), this.getEventId(), Collections.singletonList(tableWriteId.getWriteId()), MutableValidWriteIdList.WriteIdStatus.COMMITTED);
                this.tableNames_.add(tableWriteId.getDbName() + "." + tableWriteId.getTblName());
            }
        }

        private void addCommittedWriteIdsAndRefreshPartitions(List<WriteEventInfo> writeEventInfoList) throws Exception {
            List writeIds = writeEventInfoList.stream().map(WriteEventInfo::getWriteId).collect(Collectors.toList());
            HashMap<org.apache.impala.analysis.TableName, AcidTableWriteInfo> tableNameToWriteInfos = new HashMap<org.apache.impala.analysis.TableName, AcidTableWriteInfo>();
            for (int i = 0; i < writeIds.size(); ++i) {
                Table tbl = (Table)MessageBuilder.getTObj((String)writeEventInfoList.get(i).getTableObj(), Table.class);
                if (this.catalog_.isHmsEventSyncDisabled(tbl)) {
                    this.LOG.debug("Not adding write ids to table {}.{} for event {} since table/db level flag {} is set to true", new Object[]{tbl.getDbName(), tbl.getTableName(), this.getEventId(), MetastoreEvents.MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey()});
                    continue;
                }
                org.apache.impala.analysis.TableName tableName = new org.apache.impala.analysis.TableName(tbl.getDbName(), tbl.getTableName());
                Partition partition = null;
                if (writeEventInfoList.get(i).getPartitionObj() != null) {
                    partition = (Partition)MessageBuilder.getTObj((String)writeEventInfoList.get(i).getPartitionObj(), Partition.class);
                    Preconditions.checkNotNull((Object)partition);
                }
                AcidTableWriteInfo writeInfo = tableNameToWriteInfos.computeIfAbsent(tableName, k -> new AcidTableWriteInfo(tbl));
                writeInfo.appendWriteIdAndPartition((Long)writeIds.get(i), partition);
                this.tableNames_.add(tableName.toString());
            }
            for (AcidTableWriteInfo writeInfo : tableNameToWriteInfos.values()) {
                Table tbl = writeInfo.getTable();
                MetastoreShim.addCommittedWriteIdsAndReload(this.getCatalogOpExecutor(), tbl.getDbName(), tbl.getTableName(), tbl.getPartitionKeysSize() > 0, MetaStoreUtils.isMaterializedViewTable((Table)tbl), writeInfo.getWriteIdList(), writeInfo.getPartitionList(), this.getEventId(), this.getMetrics());
            }
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            return false;
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }
    }

    private static class AcidTableWriteInfo {
        private final Table table_;
        private final List<Long> writeIds_ = new ArrayList<Long>();
        private final List<Partition> partitions_ = new ArrayList<Partition>();

        private AcidTableWriteInfo(Table table) {
            this.table_ = table;
        }

        private void appendWriteIdAndPartition(Long writeId, Partition partition) {
            this.writeIds_.add(writeId);
            this.partitions_.add(partition);
        }

        private Table getTable() {
            return this.table_;
        }

        private List<Long> getWriteIdList() {
            return this.writeIds_;
        }

        private List<Partition> getPartitionList() {
            return this.partitions_;
        }
    }
}

